/*****************************************************************************
* SPSSload_KID_2009_Hospital.SPS
* This program will load the 2009 KID ASCII Hospital File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'KID_2009_Hospital.ASC' FIXED / 
    AHAID                      1-  7 (A)
    HFIPSSTCO                  8- 12
    HOSPADDR                  13- 72 (A)
    HOSPCITY                  73- 92 (A)
    HOSPID                    93- 97
    HOSPNAME                  98-187 (A)
    HOSPST                   188-189 (A)
    HOSPSTCO                 190-194
    HOSPZIP                  195-199 (A)
    HOSP_BEDSIZE             200-201
    HOSP_CONTROL             202-203
    HOSP_LOCATION            204-205
    HOSP_LOCTEACH            206-207
    HOSP_REGION              208-209
    HOSP_TEACH               210-211
    IDNUMBER                 212-217 (A)
    KID_STRATUM              218-221
    NACHTYPE                 222-223
    N_BRTH_U                 224-229
    N_DISC_U                 230-237
    N_HOSP_U                 238-241
    PEDS_DISC                242-247
    PEDS_PCT                 248-255
    S_BRTH_U                 256-261
    S_CHLD_U                 262-267
    S_CMPB_U                 268-273
    S_DISC_U                 274-279
    S_HOSP_U                 280-283
    S_UNCB_U                 284-289
    TOTAL_DISC               290-295
    YEAR                     296-299
    H_CONTRL                 300-301
    HOSP_RNPCT               302-304
    HOSP_RNFTEAPD            305-308
    HOSP_LPNFTEAPD           309-312
    HOSP_NAFTEAPD            313-316
    HOSP_OPSURGPCT           317-319
    HOSP_MHSMEMBER           320-321
    HOSP_MHSCLUSTER          322-323.

***  Specify write formats  ***.
FORMATS
    HFIPSSTCO                (F5.0) /
    HOSPID                   (F5.0) /
    HOSPSTCO                 (F5.0) /
    HOSP_BEDSIZE             (F2.0) /
    HOSP_CONTROL             (F2.0) /
    HOSP_LOCATION            (F2.0) /
    HOSP_LOCTEACH            (F2.0) /
    HOSP_REGION              (F2.0) /
    HOSP_TEACH               (F2.0) /
    KID_STRATUM              (F4.0) /
    NACHTYPE                 (F2.0) /
    N_BRTH_U                 (F6.0) /
    N_DISC_U                 (F8.0) /
    N_HOSP_U                 (F4.0) /
    PEDS_DISC                (F6.0) /
    PEDS_PCT                 (F8.4) /
    S_BRTH_U                 (F6.0) /
    S_CHLD_U                 (F6.0) /
    S_CMPB_U                 (F6.0) /
    S_DISC_U                 (F6.0) /
    S_HOSP_U                 (F4.0) /
    S_UNCB_U                 (F6.0) /
    TOTAL_DISC               (F6.0) /
    YEAR                     (F4.0) /
    H_CONTRL                 (F2.0) /
    HOSP_RNPCT               (F3.0) /
    HOSP_RNFTEAPD            (F4.1) /
    HOSP_LPNFTEAPD           (F4.1) /
    HOSP_NAFTEAPD            (F4.1) /
    HOSP_OPSURGPCT           (F3.0) /
    HOSP_MHSMEMBER           (F2.0) /
    HOSP_MHSCLUSTER          (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    AHAID                    "AHA hospital identifier"
    HFIPSSTCO                "Hospital FIPS state/county code"
    HOSPADDR                 "Hospital address from AHA Survey (Z011)"
    HOSPCITY                 "Hospital city from AHA Survey (Z012)"
    HOSPID                   "HCUP hospital identification number"
    HOSPNAME                 "Hospital name from AHA Survey (Z000)"
    HOSPST                   "Hospital state postal code"
    HOSPSTCO                 "Hospital modified FIPS state/county code"
    HOSPZIP                  "Hospital ZIP Code from AHA Survey (Z014)"
    HOSP_BEDSIZE             "Bedsize of hospital"
    HOSP_CONTROL             "Control/ownership of hospital"
    HOSP_LOCATION            "Location (urban/rural) of hospital"
    HOSP_LOCTEACH            "Location/teaching status of hospital"
    HOSP_REGION              "Region of hospital"
    HOSP_TEACH               "Teaching status of hospital"
    IDNUMBER                 "AHA hospital identifier without the leading 6"
    KID_STRATUM              "Hospital stratum used for weights"
    NACHTYPE                 "NACHRI hospital type"
    N_BRTH_U                 "Number of universe births in KID_STRATUM"
    N_DISC_U                 "Number of universe discharges in KID_STRATUM"
    N_HOSP_U                 "Number of universe hospitals in KID_STRATUM"
    PEDS_DISC                "Number of discharges, 20 years old or younger, from this hospital in the SID"
    PEDS_PCT                 "Percentage of hospital discharges, 20 years old or younger"
    S_BRTH_U                 "Number of sample births in KID_STRATUM"
    S_CHLD_U                 "Number of sample pediatric non-births in KID_STRATUM"
    S_CMPB_U                 "Number of sample complicated births in KID_STRATUM"
    S_DISC_U                 "Number of sample births and children in KID_STRATUM"
    S_HOSP_U                 "Number of sample hospitals in KID_STRATUM"
    S_UNCB_U                 "Number of sample uncomplicated births in KID_STRATUM"
    TOTAL_DISC               "Total number of discharges from this hospital in the SID"
    YEAR                     "Calendar year"
    H_CONTRL                 "Control/ownership of hospital"
    HOSP_RNPCT               "Percentage of RNs among licensed nurses"
    HOSP_RNFTEAPD            "RN FTEs per 1000 adjusted patient days"
    HOSP_LPNFTEAPD           "LPN FTEs per 1000 adjusted patient days"
    HOSP_NAFTEAPD            "Nurse aides per 1000 adjusted patient days"
    HOSP_OPSURGPCT           "Percentage of all surgeries performed in outpatient setting"
    HOSP_MHSMEMBER           "Hospital is part of multiple hospital system-@"
    HOSP_MHSCLUSTER          "AHA multiple hospital system cluster code" .

*** Convert special values to system missing values ***.
RECODE HFIPSSTCO                (-9999 -8888 -6666=SYSMIS).
RECODE HOSPSTCO                 (-9999 -8888 -6666=SYSMIS).
RECODE HOSP_BEDSIZE             (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_CONTROL             (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_LOCATION            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_LOCTEACH            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_REGION              (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_TEACH               (-9 -8 -6 -5=SYSMIS).
RECODE KID_STRATUM              (-999 -888 -666=SYSMIS).
RECODE NACHTYPE                 (-9 -8 -6 -5=SYSMIS).
RECODE N_BRTH_U                 (-99999 -88888 -66666=SYSMIS).
RECODE N_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE N_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE PEDS_DISC                (-99999 -88888 -66666=SYSMIS).
RECODE PEDS_PCT                 (-99.9999 -88.8888 -66.6666=SYSMIS).
RECODE S_BRTH_U                 (-99999 -88888 -66666=SYSMIS).
RECODE S_CHLD_U                 (-99999 -88888 -66666=SYSMIS).
RECODE S_CMPB_U                 (-99999 -88888 -66666=SYSMIS).
RECODE S_DISC_U                 (-99999 -88888 -66666=SYSMIS).
RECODE S_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE S_UNCB_U                 (-99999 -88888 -66666=SYSMIS).
RECODE TOTAL_DISC               (-99999 -88888 -66666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE H_CONTRL                 (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_RNPCT               (-99 -88 -66=SYSMIS).
RECODE HOSP_RNFTEAPD            (-9.9 -8.8 -6.6=SYSMIS).
RECODE HOSP_LPNFTEAPD           (-9.9 -8.8 -6.6=SYSMIS).
RECODE HOSP_NAFTEAPD            (-9.9 -8.8 -6.6=SYSMIS).
RECODE HOSP_OPSURGPCT           (-99 -88 -66=SYSMIS).
RECODE HOSP_MHSMEMBER           (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_MHSCLUSTER          (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'KID_2009_Hospital.SAV' / COMPRESSED.
