/*****************************************************************************
* SPSSload_KID_2009_DX_PR_GRPS.SPS
* This program will load the 2009 KID ASCII DX_PR_GRPS File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'KID_2009_DX_PR_GRPS.ASC' FIXED / 
    HOSPID                     1-  5
    RECNUM                     6- 13
    CHRON1                    14- 16
    CHRON2                    17- 19
    CHRON3                    20- 22
    CHRON4                    23- 25
    CHRON5                    26- 28
    CHRON6                    29- 31
    CHRON7                    32- 34
    CHRON8                    35- 37
    CHRON9                    38- 40
    CHRON10                   41- 43
    CHRON11                   44- 46
    CHRON12                   47- 49
    CHRON13                   50- 52
    CHRON14                   53- 55
    CHRON15                   56- 58
    CHRON16                   59- 61
    CHRON17                   62- 64
    CHRON18                   65- 67
    CHRON19                   68- 70
    CHRON20                   71- 73
    CHRON21                   74- 76
    CHRON22                   77- 79
    CHRON23                   80- 82
    CHRON24                   83- 85
    CHRON25                   86- 88
    CHRONB1                   89- 91
    CHRONB2                   92- 94
    CHRONB3                   95- 97
    CHRONB4                   98-100
    CHRONB5                  101-103
    CHRONB6                  104-106
    CHRONB7                  107-109
    CHRONB8                  110-112
    CHRONB9                  113-115
    CHRONB10                 116-118
    CHRONB11                 119-121
    CHRONB12                 122-124
    CHRONB13                 125-127
    CHRONB14                 128-130
    CHRONB15                 131-133
    CHRONB16                 134-136
    CHRONB17                 137-139
    CHRONB18                 140-142
    CHRONB19                 143-145
    CHRONB20                 146-148
    CHRONB21                 149-151
    CHRONB22                 152-154
    CHRONB23                 155-157
    CHRONB24                 158-160
    CHRONB25                 161-163
    DXMCCS1                  164-174 (A)
    E_MCCS1                  175-185 (A)
    PCLASS1                  186-188
    PCLASS2                  189-191
    PCLASS3                  192-194
    PCLASS4                  195-197
    PCLASS5                  198-200
    PCLASS6                  201-203
    PCLASS7                  204-206
    PCLASS8                  207-209
    PCLASS9                  210-212
    PCLASS10                 213-215
    PCLASS11                 216-218
    PCLASS12                 219-221
    PCLASS13                 222-224
    PCLASS14                 225-227
    PCLASS15                 228-230
    PRMCCS1                  231-238 (A).

***  Specify write formats  ***.
FORMATS
    HOSPID                   (F5.0) /
    RECNUM                   (F8.0) /
    CHRON1                   (F3.0) /
    CHRON2                   (F3.0) /
    CHRON3                   (F3.0) /
    CHRON4                   (F3.0) /
    CHRON5                   (F3.0) /
    CHRON6                   (F3.0) /
    CHRON7                   (F3.0) /
    CHRON8                   (F3.0) /
    CHRON9                   (F3.0) /
    CHRON10                  (F3.0) /
    CHRON11                  (F3.0) /
    CHRON12                  (F3.0) /
    CHRON13                  (F3.0) /
    CHRON14                  (F3.0) /
    CHRON15                  (F3.0) /
    CHRON16                  (F3.0) /
    CHRON17                  (F3.0) /
    CHRON18                  (F3.0) /
    CHRON19                  (F3.0) /
    CHRON20                  (F3.0) /
    CHRON21                  (F3.0) /
    CHRON22                  (F3.0) /
    CHRON23                  (F3.0) /
    CHRON24                  (F3.0) /
    CHRON25                  (F3.0) /
    CHRONB1                  (F3.0) /
    CHRONB2                  (F3.0) /
    CHRONB3                  (F3.0) /
    CHRONB4                  (F3.0) /
    CHRONB5                  (F3.0) /
    CHRONB6                  (F3.0) /
    CHRONB7                  (F3.0) /
    CHRONB8                  (F3.0) /
    CHRONB9                  (F3.0) /
    CHRONB10                 (F3.0) /
    CHRONB11                 (F3.0) /
    CHRONB12                 (F3.0) /
    CHRONB13                 (F3.0) /
    CHRONB14                 (F3.0) /
    CHRONB15                 (F3.0) /
    CHRONB16                 (F3.0) /
    CHRONB17                 (F3.0) /
    CHRONB18                 (F3.0) /
    CHRONB19                 (F3.0) /
    CHRONB20                 (F3.0) /
    CHRONB21                 (F3.0) /
    CHRONB22                 (F3.0) /
    CHRONB23                 (F3.0) /
    CHRONB24                 (F3.0) /
    CHRONB25                 (F3.0) /
    PCLASS1                  (F3.0) /
    PCLASS2                  (F3.0) /
    PCLASS3                  (F3.0) /
    PCLASS4                  (F3.0) /
    PCLASS5                  (F3.0) /
    PCLASS6                  (F3.0) /
    PCLASS7                  (F3.0) /
    PCLASS8                  (F3.0) /
    PCLASS9                  (F3.0) /
    PCLASS10                 (F3.0) /
    PCLASS11                 (F3.0) /
    PCLASS12                 (F3.0) /
    PCLASS13                 (F3.0) /
    PCLASS14                 (F3.0) /
    PCLASS15                 (F3.0) /
.

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSPID                   "HCUP hospital identification number"
    RECNUM                   "HCUP record number"
    CHRON1                   "Chronic condition indicator 1"
    CHRON2                   "Chronic condition indicator 2"
    CHRON3                   "Chronic condition indicator 3"
    CHRON4                   "Chronic condition indicator 4"
    CHRON5                   "Chronic condition indicator 5"
    CHRON6                   "Chronic condition indicator 6"
    CHRON7                   "Chronic condition indicator 7"
    CHRON8                   "Chronic condition indicator 8"
    CHRON9                   "Chronic condition indicator 9"
    CHRON10                  "Chronic condition indicator 10"
    CHRON11                  "Chronic condition indicator 11"
    CHRON12                  "Chronic condition indicator 12"
    CHRON13                  "Chronic condition indicator 13"
    CHRON14                  "Chronic condition indicator 14"
    CHRON15                  "Chronic condition indicator 15"
    CHRON16                  "Chronic condition indicator 16"
    CHRON17                  "Chronic condition indicator 17"
    CHRON18                  "Chronic condition indicator 18"
    CHRON19                  "Chronic condition indicator 19"
    CHRON20                  "Chronic condition indicator 20"
    CHRON21                  "Chronic condition indicator 21"
    CHRON22                  "Chronic condition indicator 22"
    CHRON23                  "Chronic condition indicator 23"
    CHRON24                  "Chronic condition indicator 24"
    CHRON25                  "Chronic condition indicator 25"
    CHRONB1                  "Chronic condition body system 1"
    CHRONB2                  "Chronic condition body system 2"
    CHRONB3                  "Chronic condition body system 3"
    CHRONB4                  "Chronic condition body system 4"
    CHRONB5                  "Chronic condition body system 5"
    CHRONB6                  "Chronic condition body system 6"
    CHRONB7                  "Chronic condition body system 7"
    CHRONB8                  "Chronic condition body system 8"
    CHRONB9                  "Chronic condition body system 9"
    CHRONB10                 "Chronic condition body system 10"
    CHRONB11                 "Chronic condition body system 11"
    CHRONB12                 "Chronic condition body system 12"
    CHRONB13                 "Chronic condition body system 13"
    CHRONB14                 "Chronic condition body system 14"
    CHRONB15                 "Chronic condition body system 15"
    CHRONB16                 "Chronic condition body system 16"
    CHRONB17                 "Chronic condition body system 17"
    CHRONB18                 "Chronic condition body system 18"
    CHRONB19                 "Chronic condition body system 19"
    CHRONB20                 "Chronic condition body system 20"
    CHRONB21                 "Chronic condition body system 21"
    CHRONB22                 "Chronic condition body system 22"
    CHRONB23                 "Chronic condition body system 23"
    CHRONB24                 "Chronic condition body system 24"
    CHRONB25                 "Chronic condition body system 25"
    DXMCCS1                  "Multi-Level CCS:  Diagnosis 1"
    E_MCCS1                  "Multi-Level CCS:  E Code 1"
    PCLASS1                  "Procedure class 1"
    PCLASS2                  "Procedure class 2"
    PCLASS3                  "Procedure class 3"
    PCLASS4                  "Procedure class 4"
    PCLASS5                  "Procedure class 5"
    PCLASS6                  "Procedure class 6"
    PCLASS7                  "Procedure class 7"
    PCLASS8                  "Procedure class 8"
    PCLASS9                  "Procedure class 9"
    PCLASS10                 "Procedure class 10"
    PCLASS11                 "Procedure class 11"
    PCLASS12                 "Procedure class 12"
    PCLASS13                 "Procedure class 13"
    PCLASS14                 "Procedure class 14"
    PCLASS15                 "Procedure class 15"
    PRMCCS1                  "Multi-Level CCS:  Procedure 1" .

*** Convert special values to system missing values ***.
RECODE RECNUM                   (-9999999 -8888888 -6666666=SYSMIS).
RECODE CHRON1                   (-99 -88 -66=SYSMIS).
RECODE CHRON2                   (-99 -88 -66=SYSMIS).
RECODE CHRON3                   (-99 -88 -66=SYSMIS).
RECODE CHRON4                   (-99 -88 -66=SYSMIS).
RECODE CHRON5                   (-99 -88 -66=SYSMIS).
RECODE CHRON6                   (-99 -88 -66=SYSMIS).
RECODE CHRON7                   (-99 -88 -66=SYSMIS).
RECODE CHRON8                   (-99 -88 -66=SYSMIS).
RECODE CHRON9                   (-99 -88 -66=SYSMIS).
RECODE CHRON10                  (-99 -88 -66=SYSMIS).
RECODE CHRON11                  (-99 -88 -66=SYSMIS).
RECODE CHRON12                  (-99 -88 -66=SYSMIS).
RECODE CHRON13                  (-99 -88 -66=SYSMIS).
RECODE CHRON14                  (-99 -88 -66=SYSMIS).
RECODE CHRON15                  (-99 -88 -66=SYSMIS).
RECODE CHRON16                  (-99 -88 -66=SYSMIS).
RECODE CHRON17                  (-99 -88 -66=SYSMIS).
RECODE CHRON18                  (-99 -88 -66=SYSMIS).
RECODE CHRON19                  (-99 -88 -66=SYSMIS).
RECODE CHRON20                  (-99 -88 -66=SYSMIS).
RECODE CHRON21                  (-99 -88 -66=SYSMIS).
RECODE CHRON22                  (-99 -88 -66=SYSMIS).
RECODE CHRON23                  (-99 -88 -66=SYSMIS).
RECODE CHRON24                  (-99 -88 -66=SYSMIS).
RECODE CHRON25                  (-99 -88 -66=SYSMIS).
RECODE CHRONB1                  (-99 -88 -66=SYSMIS).
RECODE CHRONB2                  (-99 -88 -66=SYSMIS).
RECODE CHRONB3                  (-99 -88 -66=SYSMIS).
RECODE CHRONB4                  (-99 -88 -66=SYSMIS).
RECODE CHRONB5                  (-99 -88 -66=SYSMIS).
RECODE CHRONB6                  (-99 -88 -66=SYSMIS).
RECODE CHRONB7                  (-99 -88 -66=SYSMIS).
RECODE CHRONB8                  (-99 -88 -66=SYSMIS).
RECODE CHRONB9                  (-99 -88 -66=SYSMIS).
RECODE CHRONB10                 (-99 -88 -66=SYSMIS).
RECODE CHRONB11                 (-99 -88 -66=SYSMIS).
RECODE CHRONB12                 (-99 -88 -66=SYSMIS).
RECODE CHRONB13                 (-99 -88 -66=SYSMIS).
RECODE CHRONB14                 (-99 -88 -66=SYSMIS).
RECODE CHRONB15                 (-99 -88 -66=SYSMIS).
RECODE CHRONB16                 (-99 -88 -66=SYSMIS).
RECODE CHRONB17                 (-99 -88 -66=SYSMIS).
RECODE CHRONB18                 (-99 -88 -66=SYSMIS).
RECODE CHRONB19                 (-99 -88 -66=SYSMIS).
RECODE CHRONB20                 (-99 -88 -66=SYSMIS).
RECODE CHRONB21                 (-99 -88 -66=SYSMIS).
RECODE CHRONB22                 (-99 -88 -66=SYSMIS).
RECODE CHRONB23                 (-99 -88 -66=SYSMIS).
RECODE CHRONB24                 (-99 -88 -66=SYSMIS).
RECODE CHRONB25                 (-99 -88 -66=SYSMIS).
RECODE PCLASS1                  (-99 -88 -66=SYSMIS).
RECODE PCLASS2                  (-99 -88 -66=SYSMIS).
RECODE PCLASS3                  (-99 -88 -66=SYSMIS).
RECODE PCLASS4                  (-99 -88 -66=SYSMIS).
RECODE PCLASS5                  (-99 -88 -66=SYSMIS).
RECODE PCLASS6                  (-99 -88 -66=SYSMIS).
RECODE PCLASS7                  (-99 -88 -66=SYSMIS).
RECODE PCLASS8                  (-99 -88 -66=SYSMIS).
RECODE PCLASS9                  (-99 -88 -66=SYSMIS).
RECODE PCLASS10                 (-99 -88 -66=SYSMIS).
RECODE PCLASS11                 (-99 -88 -66=SYSMIS).
RECODE PCLASS12                 (-99 -88 -66=SYSMIS).
RECODE PCLASS13                 (-99 -88 -66=SYSMIS).
RECODE PCLASS14                 (-99 -88 -66=SYSMIS).
RECODE PCLASS15                 (-99 -88 -66=SYSMIS).

SAVE OUTFILE = 'KID_2009_DX_PR_GRPS.SAV' / COMPRESSED.
