/*****************************************************************************
* SPSSload_KID_2012_Core.SPS
* This program will load the 2012 KID ASCII Core File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'KID_2012_Core.ASC' FIXED / 
    HOSP_KID                   1-  5
    RECNUM                     6- 13
    AGE                       14- 16
    AGE_NEONATE               17- 18
    AMONTH                    19- 20
    AWEEKEND                  21- 22
    DIED                      23- 24
    DISCWT                    25- 35
    DISPUNIFORM               36- 37
    DQTR                      38- 39
    DRG                       40- 42
    DRG24                     43- 45
    DRGVER                    46- 47
    DRG_NoPOA                 48- 50
    DX1                       51- 55 (A)
    DX2                       56- 60 (A)
    DX3                       61- 65 (A)
    DX4                       66- 70 (A)
    DX5                       71- 75 (A)
    DX6                       76- 80 (A)
    DX7                       81- 85 (A)
    DX8                       86- 90 (A)
    DX9                       91- 95 (A)
    DX10                      96-100 (A)
    DX11                     101-105 (A)
    DX12                     106-110 (A)
    DX13                     111-115 (A)
    DX14                     116-120 (A)
    DX15                     121-125 (A)
    DX16                     126-130 (A)
    DX17                     131-135 (A)
    DX18                     136-140 (A)
    DX19                     141-145 (A)
    DX20                     146-150 (A)
    DX21                     151-155 (A)
    DX22                     156-160 (A)
    DX23                     161-165 (A)
    DX24                     166-170 (A)
    DX25                     171-175 (A)
    DXCCS1                   176-178
    DXCCS2                   179-181
    DXCCS3                   182-184
    DXCCS4                   185-187
    DXCCS5                   188-190
    DXCCS6                   191-193
    DXCCS7                   194-196
    DXCCS8                   197-199
    DXCCS9                   200-202
    DXCCS10                  203-205
    DXCCS11                  206-208
    DXCCS12                  209-211
    DXCCS13                  212-214
    DXCCS14                  215-217
    DXCCS15                  218-220
    DXCCS16                  221-223
    DXCCS17                  224-226
    DXCCS18                  227-229
    DXCCS19                  230-232
    DXCCS20                  233-235
    DXCCS21                  236-238
    DXCCS22                  239-241
    DXCCS23                  242-244
    DXCCS24                  245-247
    DXCCS25                  248-250
    ECODE1                   251-255 (A)
    ECODE2                   256-260 (A)
    ECODE3                   261-265 (A)
    ECODE4                   266-270 (A)
    ELECTIVE                 271-272
    E_CCS1                   273-276
    E_CCS2                   277-280
    E_CCS3                   281-284
    E_CCS4                   285-288
    FEMALE                   289-290
    HCUP_ED                  291-293
    HOSPBRTH                 294-295
    HOSP_REGION              296-297
    KID_STRATUM              298-301
    LOS                      302-306
    MDC                      307-308
    MDC24                    309-310
    MDC_NoPOA                311-312
    NCHRONIC                 313-314
    NDX                      315-316
    NECODE                   317-319
    NEOMAT                   320-321
    NPR                      322-323
    ORPROC                   324-325
    PAY1                     326-327
    PL_NCHS2006              328-330
    PR1                      331-334 (A)
    PR2                      335-338 (A)
    PR3                      339-342 (A)
    PR4                      343-346 (A)
    PR5                      347-350 (A)
    PR6                      351-354 (A)
    PR7                      355-358 (A)
    PR8                      359-362 (A)
    PR9                      363-366 (A)
    PR10                     367-370 (A)
    PR11                     371-374 (A)
    PR12                     375-378 (A)
    PR13                     379-382 (A)
    PR14                     383-386 (A)
    PR15                     387-390 (A)
    PRCCS1                   391-393
    PRCCS2                   394-396
    PRCCS3                   397-399
    PRCCS4                   400-402
    PRCCS5                   403-405
    PRCCS6                   406-408
    PRCCS7                   409-411
    PRCCS8                   412-414
    PRCCS9                   415-417
    PRCCS10                  418-420
    PRCCS11                  421-423
    PRCCS12                  424-426
    PRCCS13                  427-429
    PRCCS14                  430-432
    PRCCS15                  433-435
    PRDAY1                   436-438
    PRDAY2                   439-441
    PRDAY3                   442-444
    PRDAY4                   445-447
    PRDAY5                   448-450
    PRDAY6                   451-453
    PRDAY7                   454-456
    PRDAY8                   457-459
    PRDAY9                   460-462
    PRDAY10                  463-465
    PRDAY11                  466-468
    PRDAY12                  469-471
    PRDAY13                  472-474
    PRDAY14                  475-477
    PRDAY15                  478-480
    RACE                     481-482
    TOTCHG                   483-492
    TRAN_IN                  493-494
    TRAN_OUT                 495-496
    UNCBRTH                  497-498
    YEAR                     499-502
    ZIPINC_QRTL              503-504.

***  Specify write formats  ***.
FORMATS
    HOSP_KID                 (F5.0) /
    RECNUM                   (F8.0) /
    AGE                      (F3.0) /
    AGE_NEONATE              (F2.0) /
    AMONTH                   (F2.0) /
    AWEEKEND                 (F2.0) /
    DIED                     (F2.0) /
    DISCWT                   (F11.7) /
    DISPUNIFORM              (F2.0) /
    DQTR                     (F2.0) /
    DRG                      (F3.0) /
    DRG24                    (F3.0) /
    DRGVER                   (F2.0) /
    DRG_NoPOA                (F3.0) /
    DXCCS1                   (F3.0) /
    DXCCS2                   (F3.0) /
    DXCCS3                   (F3.0) /
    DXCCS4                   (F3.0) /
    DXCCS5                   (F3.0) /
    DXCCS6                   (F3.0) /
    DXCCS7                   (F3.0) /
    DXCCS8                   (F3.0) /
    DXCCS9                   (F3.0) /
    DXCCS10                  (F3.0) /
    DXCCS11                  (F3.0) /
    DXCCS12                  (F3.0) /
    DXCCS13                  (F3.0) /
    DXCCS14                  (F3.0) /
    DXCCS15                  (F3.0) /
    DXCCS16                  (F3.0) /
    DXCCS17                  (F3.0) /
    DXCCS18                  (F3.0) /
    DXCCS19                  (F3.0) /
    DXCCS20                  (F3.0) /
    DXCCS21                  (F3.0) /
    DXCCS22                  (F3.0) /
    DXCCS23                  (F3.0) /
    DXCCS24                  (F3.0) /
    DXCCS25                  (F3.0) /
    ELECTIVE                 (F2.0) /
    E_CCS1                   (F4.0) /
    E_CCS2                   (F4.0) /
    E_CCS3                   (F4.0) /
    E_CCS4                   (F4.0) /
    FEMALE                   (F2.0) /
    HCUP_ED                  (F3.0) /
    HOSPBRTH                 (F2.0) /
    HOSP_REGION              (F2.0) /
    KID_STRATUM              (F4.0) /
    LOS                      (F5.0) /
    MDC                      (F2.0) /
    MDC24                    (F2.0) /
    MDC_NoPOA                (F2.0) /
    NCHRONIC                 (F2.0) /
    NDX                      (F2.0) /
    NECODE                   (F3.0) /
    NEOMAT                   (F2.0) /
    NPR                      (F2.0) /
    ORPROC                   (F2.0) /
    PAY1                     (F2.0) /
    PL_NCHS2006              (F3.0) /
    PRCCS1                   (F3.0) /
    PRCCS2                   (F3.0) /
    PRCCS3                   (F3.0) /
    PRCCS4                   (F3.0) /
    PRCCS5                   (F3.0) /
    PRCCS6                   (F3.0) /
    PRCCS7                   (F3.0) /
    PRCCS8                   (F3.0) /
    PRCCS9                   (F3.0) /
    PRCCS10                  (F3.0) /
    PRCCS11                  (F3.0) /
    PRCCS12                  (F3.0) /
    PRCCS13                  (F3.0) /
    PRCCS14                  (F3.0) /
    PRCCS15                  (F3.0) /
    PRDAY1                   (F3.0) /
    PRDAY2                   (F3.0) /
    PRDAY3                   (F3.0) /
    PRDAY4                   (F3.0) /
    PRDAY5                   (F3.0) /
    PRDAY6                   (F3.0) /
    PRDAY7                   (F3.0) /
    PRDAY8                   (F3.0) /
    PRDAY9                   (F3.0) /
    PRDAY10                  (F3.0) /
    PRDAY11                  (F3.0) /
    PRDAY12                  (F3.0) /
    PRDAY13                  (F3.0) /
    PRDAY14                  (F3.0) /
    PRDAY15                  (F3.0) /
    RACE                     (F2.0) /
    TOTCHG                   (F10.0) /
    TRAN_IN                  (F2.0) /
    TRAN_OUT                 (F2.0) /
    UNCBRTH                  (F2.0) /
    YEAR                     (F4.0) /
    ZIPINC_QRTL              (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSP_KID                 "KID hospital number"
    RECNUM                   "KID record number"
    AGE                      "Age in years at admission"
    AGE_NEONATE              "Neonatal age (first 28 days after birth) indicator"
    AMONTH                   "Admission month"
    AWEEKEND                 "Admission day is a weekend"
    DIED                     "Died during hospitalization"
    DISCWT                   "KID discharge weight"
    DISPUNIFORM              "Disposition of patient (uniform)"
    DQTR                     "Discharge quarter"
    DRG                      "DRG in effect on discharge date"
    DRG24                    "DRG, version 24"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    DX1                      "Diagnosis 1"
    DX2                      "Diagnosis 2"
    DX3                      "Diagnosis 3"
    DX4                      "Diagnosis 4"
    DX5                      "Diagnosis 5"
    DX6                      "Diagnosis 6"
    DX7                      "Diagnosis 7"
    DX8                      "Diagnosis 8"
    DX9                      "Diagnosis 9"
    DX10                     "Diagnosis 10"
    DX11                     "Diagnosis 11"
    DX12                     "Diagnosis 12"
    DX13                     "Diagnosis 13"
    DX14                     "Diagnosis 14"
    DX15                     "Diagnosis 15"
    DX16                     "Diagnosis 16"
    DX17                     "Diagnosis 17"
    DX18                     "Diagnosis 18"
    DX19                     "Diagnosis 19"
    DX20                     "Diagnosis 20"
    DX21                     "Diagnosis 21"
    DX22                     "Diagnosis 22"
    DX23                     "Diagnosis 23"
    DX24                     "Diagnosis 24"
    DX25                     "Diagnosis 25"
    DXCCS1                   "CCS: diagnosis 1"
    DXCCS2                   "CCS: diagnosis 2"
    DXCCS3                   "CCS: diagnosis 3"
    DXCCS4                   "CCS: diagnosis 4"
    DXCCS5                   "CCS: diagnosis 5"
    DXCCS6                   "CCS: diagnosis 6"
    DXCCS7                   "CCS: diagnosis 7"
    DXCCS8                   "CCS: diagnosis 8"
    DXCCS9                   "CCS: diagnosis 9"
    DXCCS10                  "CCS: diagnosis 10"
    DXCCS11                  "CCS: diagnosis 11"
    DXCCS12                  "CCS: diagnosis 12"
    DXCCS13                  "CCS: diagnosis 13"
    DXCCS14                  "CCS: diagnosis 14"
    DXCCS15                  "CCS: diagnosis 15"
    DXCCS16                  "CCS: diagnosis 16"
    DXCCS17                  "CCS: diagnosis 17"
    DXCCS18                  "CCS: diagnosis 18"
    DXCCS19                  "CCS: diagnosis 19"
    DXCCS20                  "CCS: diagnosis 20"
    DXCCS21                  "CCS: diagnosis 21"
    DXCCS22                  "CCS: diagnosis 22"
    DXCCS23                  "CCS: diagnosis 23"
    DXCCS24                  "CCS: diagnosis 24"
    DXCCS25                  "CCS: diagnosis 25"
    ECODE1                   "E code 1"
    ECODE2                   "E code 2"
    ECODE3                   "E code 3"
    ECODE4                   "E code 4"
    ELECTIVE                 "Elective versus non-elective admission"
    E_CCS1                   "CCS: E Code 1"
    E_CCS2                   "CCS: E Code 2"
    E_CCS3                   "CCS: E Code 3"
    E_CCS4                   "CCS: E Code 4"
    FEMALE                   "Indicator of sex"
    HCUP_ED                  "HCUP Emergency Department service indicator"
    HOSPBRTH                 "Indicator of birth in this hospital"
    HOSP_REGION              "Region of hospital"
    KID_STRATUM              "Stratum used to sample hospital"
    LOS                      "Length of stay (cleaned)"
    MDC                      "MDC in effect on discharge date"
    MDC24                    "MDC, version 24"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    NCHRONIC                 "Number of chronic conditions"
    NDX                      "Number of diagnoses on this record"
    NECODE                   "Number of E codes on this record"
    NEOMAT                   "Neonatal and/or maternal DX and/or PR"
    NPR                      "Number of procedures on this record"
    ORPROC                   "Major operating room procedure indicator"
    PAY1                     "Primary expected payer (uniform)"
    PL_NCHS2006              "Patient Location: NCHS Urban-Rural Code (V2006)"
    PR1                      "Procedure 1"
    PR2                      "Procedure 2"
    PR3                      "Procedure 3"
    PR4                      "Procedure 4"
    PR5                      "Procedure 5"
    PR6                      "Procedure 6"
    PR7                      "Procedure 7"
    PR8                      "Procedure 8"
    PR9                      "Procedure 9"
    PR10                     "Procedure 10"
    PR11                     "Procedure 11"
    PR12                     "Procedure 12"
    PR13                     "Procedure 13"
    PR14                     "Procedure 14"
    PR15                     "Procedure 15"
    PRCCS1                   "CCS: procedure 1"
    PRCCS2                   "CCS: procedure 2"
    PRCCS3                   "CCS: procedure 3"
    PRCCS4                   "CCS: procedure 4"
    PRCCS5                   "CCS: procedure 5"
    PRCCS6                   "CCS: procedure 6"
    PRCCS7                   "CCS: procedure 7"
    PRCCS8                   "CCS: procedure 8"
    PRCCS9                   "CCS: procedure 9"
    PRCCS10                  "CCS: procedure 10"
    PRCCS11                  "CCS: procedure 11"
    PRCCS12                  "CCS: procedure 12"
    PRCCS13                  "CCS: procedure 13"
    PRCCS14                  "CCS: procedure 14"
    PRCCS15                  "CCS: procedure 15"
    PRDAY1                   "Number of days from admission to PR1"
    PRDAY2                   "Number of days from admission to PR2"
    PRDAY3                   "Number of days from admission to PR3"
    PRDAY4                   "Number of days from admission to PR4"
    PRDAY5                   "Number of days from admission to PR5"
    PRDAY6                   "Number of days from admission to PR6"
    PRDAY7                   "Number of days from admission to PR7"
    PRDAY8                   "Number of days from admission to PR8"
    PRDAY9                   "Number of days from admission to PR9"
    PRDAY10                  "Number of days from admission to PR10"
    PRDAY11                  "Number of days from admission to PR11"
    PRDAY12                  "Number of days from admission to PR12"
    PRDAY13                  "Number of days from admission to PR13"
    PRDAY14                  "Number of days from admission to PR14"
    PRDAY15                  "Number of days from admission to PR15"
    RACE                     "Race (uniform)"
    TOTCHG                   "Total charges (cleaned)"
    TRAN_IN                  "Transfer in indicator"
    TRAN_OUT                 "Transfer out indicator"
    UNCBRTH                  "Normal uncomplicated birth in hospital"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code" .

*** Convert special values to system missing values ***.
RECODE HOSP_KID                 (-9999 -8888 -6666=SYSMIS).
RECODE RECNUM                   (-9999999 -8888888 -6666666=SYSMIS).
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AGE_NEONATE              (-9 -8 -6 -5=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRG24                    (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE DXCCS1                   (-99 -88 -66=SYSMIS).
RECODE DXCCS2                   (-99 -88 -66=SYSMIS).
RECODE DXCCS3                   (-99 -88 -66=SYSMIS).
RECODE DXCCS4                   (-99 -88 -66=SYSMIS).
RECODE DXCCS5                   (-99 -88 -66=SYSMIS).
RECODE DXCCS6                   (-99 -88 -66=SYSMIS).
RECODE DXCCS7                   (-99 -88 -66=SYSMIS).
RECODE DXCCS8                   (-99 -88 -66=SYSMIS).
RECODE DXCCS9                   (-99 -88 -66=SYSMIS).
RECODE DXCCS10                  (-99 -88 -66=SYSMIS).
RECODE DXCCS11                  (-99 -88 -66=SYSMIS).
RECODE DXCCS12                  (-99 -88 -66=SYSMIS).
RECODE DXCCS13                  (-99 -88 -66=SYSMIS).
RECODE DXCCS14                  (-99 -88 -66=SYSMIS).
RECODE DXCCS15                  (-99 -88 -66=SYSMIS).
RECODE DXCCS16                  (-99 -88 -66=SYSMIS).
RECODE DXCCS17                  (-99 -88 -66=SYSMIS).
RECODE DXCCS18                  (-99 -88 -66=SYSMIS).
RECODE DXCCS19                  (-99 -88 -66=SYSMIS).
RECODE DXCCS20                  (-99 -88 -66=SYSMIS).
RECODE DXCCS21                  (-99 -88 -66=SYSMIS).
RECODE DXCCS22                  (-99 -88 -66=SYSMIS).
RECODE DXCCS23                  (-99 -88 -66=SYSMIS).
RECODE DXCCS24                  (-99 -88 -66=SYSMIS).
RECODE DXCCS25                  (-99 -88 -66=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE E_CCS1                   (-999 -888 -666=SYSMIS).
RECODE E_CCS2                   (-999 -888 -666=SYSMIS).
RECODE E_CCS3                   (-999 -888 -666=SYSMIS).
RECODE E_CCS4                   (-999 -888 -666=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HCUP_ED                  (-99 -88 -66=SYSMIS).
RECODE HOSPBRTH                 (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_REGION              (-9 -8 -6 -5=SYSMIS).
RECODE KID_STRATUM              (-999 -888 -666=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC24                    (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE NCHRONIC                 (-9 -8 -6 -5=SYSMIS).
RECODE NDX                      (-9 -8 -6 -5=SYSMIS).
RECODE NECODE                   (-99 -88 -66=SYSMIS).
RECODE NEOMAT                   (-9 -8 -6 -5=SYSMIS).
RECODE NPR                      (-9 -8 -6 -5=SYSMIS).
RECODE ORPROC                   (-9 -8 -6 -5=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS2006              (-99 -88 -66=SYSMIS).
RECODE PRCCS1                   (-99 -88 -66=SYSMIS).
RECODE PRCCS2                   (-99 -88 -66=SYSMIS).
RECODE PRCCS3                   (-99 -88 -66=SYSMIS).
RECODE PRCCS4                   (-99 -88 -66=SYSMIS).
RECODE PRCCS5                   (-99 -88 -66=SYSMIS).
RECODE PRCCS6                   (-99 -88 -66=SYSMIS).
RECODE PRCCS7                   (-99 -88 -66=SYSMIS).
RECODE PRCCS8                   (-99 -88 -66=SYSMIS).
RECODE PRCCS9                   (-99 -88 -66=SYSMIS).
RECODE PRCCS10                  (-99 -88 -66=SYSMIS).
RECODE PRCCS11                  (-99 -88 -66=SYSMIS).
RECODE PRCCS12                  (-99 -88 -66=SYSMIS).
RECODE PRCCS13                  (-99 -88 -66=SYSMIS).
RECODE PRCCS14                  (-99 -88 -66=SYSMIS).
RECODE PRCCS15                  (-99 -88 -66=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE RACE                     (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE TRAN_IN                  (-9 -8 -6 -5=SYSMIS).
RECODE TRAN_OUT                 (-9 -8 -6 -5=SYSMIS).
RECODE UNCBRTH                  (-9 -8 -6 -5=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'KID_2012_Core.SAV' / COMPRESSED.
