/*****************************************************************************
* SPSSload_KID_2006_Hospital.SPS
* This program will load the 2006 KID ASCII Hospital File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'KID_2006_Hospital.ASC' FIXED / 
    AHAID                      1-  7 (A)
    HFIPSSTC                   8- 12
    HOSPADDR                  13- 42 (A)
    HOSPCITY                  43- 62 (A)
    HOSPID                    63- 67
    HOSPNAME                  68- 97 (A)
    HOSPST                    98- 99 (A)
    HOSPSTCO                 100-104
    HOSPZIP                  105-109 (A)
    HOSP_BED                 110-111
    HOSP_CON                 112-113
    HOSP_LOC                 114-115
    HOSP_LT                  116-117
    HOSP_REG                 118-119
    HOSP_TEA                 120-121
    IDNUMBER                 122-127 (A)
    KID_STRA                 128-131
    NACHTYPE                 132-133
    N_BRTH_U                 134-139
    N_DISC_U                 140-147
    N_HOSP_U                 148-151
    PEDS_DIS                 152-157
    PEDS_PCT                 158-165
    S_BRTH_U                 166-171
    S_CHLD_U                 172-177
    S_CMPB_U                 178-183
    S_DISC_U                 184-189
    S_HOSP_U                 190-193
    S_UNCB_U                 194-199
    TOTAL_DI                 200-205
    YEAR                     206-209.

***  Specify write formats  ***.
FORMATS
    HFIPSSTC                 (F5.0) /
    HOSPID                   (F5.0) /
    HOSPSTCO                 (F5.0) /
    HOSP_BED                 (F2.0) /
    HOSP_CON                 (F2.0) /
    HOSP_LOC                 (F2.0) /
    HOSP_LT                  (F2.0) /
    HOSP_REG                 (F2.0) /
    HOSP_TEA                 (F2.0) /
    KID_STRA                 (F4.0) /
    NACHTYPE                 (F2.0) /
    N_BRTH_U                 (F6.0) /
    N_DISC_U                 (F8.0) /
    N_HOSP_U                 (F4.0) /
    PEDS_DIS                 (F6.0) /
    PEDS_PCT                 (F8.4) /
    S_BRTH_U                 (F6.0) /
    S_CHLD_U                 (F6.0) /
    S_CMPB_U                 (F6.0) /
    S_DISC_U                 (F6.0) /
    S_HOSP_U                 (F4.0) /
    S_UNCB_U                 (F6.0) /
    TOTAL_DI                 (F6.0) /
    YEAR                     (F4.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    AHAID                    "AHA hospital identifier"
    HFIPSSTC                 "Hospital FIPS state/county code"
    HOSPADDR                 "Hospital address from AHA Survey (Z011)"
    HOSPCITY                 "Hospital city from AHA Survey (Z012)"
    HOSPID                   "HCUP hospital identification number"
    HOSPNAME                 "Hospital name from AHA Survey (Z000)"
    HOSPST                   "Hospital state postal code"
    HOSPSTCO                 "Hospital modified FIPS state/county code"
    HOSPZIP                  "Hospital ZIP Code from AHA Survey (Z014)"
    HOSP_BED                 "Bedsize of hospital"
    HOSP_CON                 "Control/ownership of hospital"
    HOSP_LOC                 "Location (urban/rural) of hospital"
    HOSP_LT                  "Location/teaching status of hospital"
    HOSP_REG                 "Region of hospital"
    HOSP_TEA                 "Teaching status of hospital"
    IDNUMBER                 "AHA hospital identifier without the leading 6"
    KID_STRA                 "Hospital stratum used for weights"
    NACHTYPE                 "NACHRI hospital type"
    N_BRTH_U                 "Number of universe births in KID_STRATUM"
    N_DISC_U                 "Number of universe discharges in KID_STRATUM"
    N_HOSP_U                 "Number of universe hospitals in KID_STRATUM"
    PEDS_DIS                 "Number of discharges, 20 years old or younger, from this hospital in the SID"
    PEDS_PCT                 "Percentage of hospital discharges, 20 years old or younger"
    S_BRTH_U                 "Number of sample births in KID_STRATUM"
    S_CHLD_U                 "Number of sample pediatric non-births in KID_STRATUM"
    S_CMPB_U                 "Number of sample complicated births in KID_STRATUM"
    S_DISC_U                 "Number of sample births and children in KID_STRATUM"
    S_HOSP_U                 "Number of sample hospitals in KID_STRATUM"
    S_UNCB_U                 "Number of sample uncomplicated births in KID_STRATUM"
    TOTAL_DI                 "Total number of discharges from this hospital in the SID"
    YEAR                     "Calendar year" .

*** Convert special values to system missing values ***.
RECODE HFIPSSTC                 (-9999 -8888 -6666=SYSMIS).
RECODE HOSPSTCO                 (-9999 -8888 -6666=SYSMIS).
RECODE HOSP_BED                 (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_CON                 (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_LOC                 (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_LT                  (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_REG                 (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_TEA                 (-9 -8 -6 -5=SYSMIS).
RECODE KID_STRA                 (-999 -888 -666=SYSMIS).
RECODE NACHTYPE                 (-9 -8 -6 -5=SYSMIS).
RECODE N_BRTH_U                 (-99999 -88888 -66666=SYSMIS).
RECODE N_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE N_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE PEDS_DIS                 (-99999 -88888 -66666=SYSMIS).
RECODE PEDS_PCT                 (-99.9999 -88.8888 -66.6666=SYSMIS).
RECODE S_BRTH_U                 (-99999 -88888 -66666=SYSMIS).
RECODE S_CHLD_U                 (-99999 -88888 -66666=SYSMIS).
RECODE S_CMPB_U                 (-99999 -88888 -66666=SYSMIS).
RECODE S_DISC_U                 (-99999 -88888 -66666=SYSMIS).
RECODE S_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE S_UNCB_U                 (-99999 -88888 -66666=SYSMIS).
RECODE TOTAL_DI                 (-99999 -88888 -66666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).

SAVE OUTFILE = 'KID_2006_Hospital.SAV' / COMPRESSED.
