/*****************************************************************************
* SPSSload_KID_2006_Core.SPS
* This program will load the 2006 KID ASCII Core File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'KID_2006_Core.ASC' FIXED / 
    HOSPID                     1-  5
    RECNUM                     6- 13
    AGE                       14- 16
    AGEDAY                    17- 19
    AGEMONTH                  20- 22
    AMONTH                    23- 24
    ASOURCE                   25- 26
    ASOURCEU                  27     (A)
    ASOURCE_                  28- 35 (A)
    ATYPE                     36- 37
    AWEEKEND                  38- 39
    BWT                       40- 43
    DIED                      44- 45
    DISCWT                    46- 56
    DISPUB92                  57- 58
    DISPUNIF                  59- 60
    DQTR                      61- 62
    DQTR_X                    63- 64
    DRG                       65- 67
    DRG24                     68- 70
    DRGVER                    71- 72
    DSHOSPID                  73- 85 (A)
    DX1                       86- 90 (A)
    DX2                       91- 95 (A)
    DX3                       96-100 (A)
    DX4                      101-105 (A)
    DX5                      106-110 (A)
    DX6                      111-115 (A)
    DX7                      116-120 (A)
    DX8                      121-125 (A)
    DX9                      126-130 (A)
    DX10                     131-135 (A)
    DX11                     136-140 (A)
    DX12                     141-145 (A)
    DX13                     146-150 (A)
    DX14                     151-155 (A)
    DX15                     156-160 (A)
    DXCCS1                   161-164
    DXCCS2                   165-168
    DXCCS3                   169-172
    DXCCS4                   173-176
    DXCCS5                   177-180
    DXCCS6                   181-184
    DXCCS7                   185-188
    DXCCS8                   189-192
    DXCCS9                   193-196
    DXCCS10                  197-200
    DXCCS11                  201-204
    DXCCS12                  205-208
    DXCCS13                  209-212
    DXCCS14                  213-216
    DXCCS15                  217-220
    ECODE1                   221-225 (A)
    ECODE2                   226-230 (A)
    ECODE3                   231-235 (A)
    ECODE4                   236-240 (A)
    ELECTIVE                 241-242
    E_CCS1                   243-246
    E_CCS2                   247-250
    E_CCS3                   251-254
    E_CCS4                   255-258
    FEMALE                   259-260
    HOSPBRTH                 261-262
    HOSPST                   263-264 (A)
    KID_STRA                 265-268
    LOS                      269-273
    LOS_X                    274-279
    MDC                      280-281
    MDC24                    282-283
    MDNUM1_R                 284-288
    MDNUM2_R                 289-293
    NDX                      294-295
    NECODE                   296-298
    NEOMAT                   299-300
    NPR                      301-302
    PAY1                     303-304
    PAY1_X                   305-314 (A)
    PAY2                     315-316
    PAY2_X                   317-326 (A)
    PL_NCHS2                 327-329
    PR1                      330-333 (A)
    PR2                      334-337 (A)
    PR3                      338-341 (A)
    PR4                      342-345 (A)
    PR5                      346-349 (A)
    PR6                      350-353 (A)
    PR7                      354-357 (A)
    PR8                      358-361 (A)
    PR9                      362-365 (A)
    PR10                     366-369 (A)
    PR11                     370-373 (A)
    PR12                     374-377 (A)
    PR13                     378-381 (A)
    PR14                     382-385 (A)
    PR15                     386-389 (A)
    PRCCS1                   390-392
    PRCCS2                   393-395
    PRCCS3                   396-398
    PRCCS4                   399-401
    PRCCS5                   402-404
    PRCCS6                   405-407
    PRCCS7                   408-410
    PRCCS8                   411-413
    PRCCS9                   414-416
    PRCCS10                  417-419
    PRCCS11                  420-422
    PRCCS12                  423-425
    PRCCS13                  426-428
    PRCCS14                  429-431
    PRCCS15                  432-434
    PRDAY1                   435-437
    PRDAY2                   438-440
    PRDAY3                   441-443
    PRDAY4                   444-446
    PRDAY5                   447-449
    PRDAY6                   450-452
    PRDAY7                   453-455
    PRDAY8                   456-458
    PRDAY9                   459-461
    PRDAY10                  462-464
    PRDAY11                  465-467
    PRDAY12                  468-470
    PRDAY13                  471-473
    PRDAY14                  474-476
    PRDAY15                  477-479
    RACE                     480-481
    TOTCHG                   482-491
    TOTCHG_X                 492-506
    UNCBRTH                  507-508
    YEAR                     509-512
    ZIPINC_Q                 513-514.

***  Specify write formats  ***.
FORMATS
    HOSPID                   (F5.0) /
    RECNUM                   (F8.0) /
    AGE                      (F3.0) /
    AGEDAY                   (F3.0) /
    AGEMONTH                 (F3.0) /
    AMONTH                   (F2.0) /
    ASOURCE                  (F2.0) /
    ATYPE                    (F2.0) /
    AWEEKEND                 (F2.0) /
    BWT                      (F4.0) /
    DIED                     (F2.0) /
    DISCWT                   (F11.7) /
    DISPUB92                 (F2.0) /
    DISPUNIF                 (F2.0) /
    DQTR                     (F2.0) /
    DQTR_X                   (F2.0) /
    DRG                      (F3.0) /
    DRG24                    (F3.0) /
    DRGVER                   (F2.0) /
    DXCCS1                   (F4.0) /
    DXCCS2                   (F4.0) /
    DXCCS3                   (F4.0) /
    DXCCS4                   (F4.0) /
    DXCCS5                   (F4.0) /
    DXCCS6                   (F4.0) /
    DXCCS7                   (F4.0) /
    DXCCS8                   (F4.0) /
    DXCCS9                   (F4.0) /
    DXCCS10                  (F4.0) /
    DXCCS11                  (F4.0) /
    DXCCS12                  (F4.0) /
    DXCCS13                  (F4.0) /
    DXCCS14                  (F4.0) /
    DXCCS15                  (F4.0) /
    ELECTIVE                 (F2.0) /
    E_CCS1                   (F4.0) /
    E_CCS2                   (F4.0) /
    E_CCS3                   (F4.0) /
    E_CCS4                   (F4.0) /
    FEMALE                   (F2.0) /
    HOSPBRTH                 (F2.0) /
    KID_STRA                 (F4.0) /
    LOS                      (F5.0) /
    LOS_X                    (F6.0) /
    MDC                      (F2.0) /
    MDC24                    (F2.0) /
    MDNUM1_R                 (F5.0) /
    MDNUM2_R                 (F5.0) /
    NDX                      (F2.0) /
    NECODE                   (F3.0) /
    NEOMAT                   (F2.0) /
    NPR                      (F2.0) /
    PAY1                     (F2.0) /
    PAY2                     (F2.0) /
    PL_NCHS2                 (F3.0) /
    PRCCS1                   (F3.0) /
    PRCCS2                   (F3.0) /
    PRCCS3                   (F3.0) /
    PRCCS4                   (F3.0) /
    PRCCS5                   (F3.0) /
    PRCCS6                   (F3.0) /
    PRCCS7                   (F3.0) /
    PRCCS8                   (F3.0) /
    PRCCS9                   (F3.0) /
    PRCCS10                  (F3.0) /
    PRCCS11                  (F3.0) /
    PRCCS12                  (F3.0) /
    PRCCS13                  (F3.0) /
    PRCCS14                  (F3.0) /
    PRCCS15                  (F3.0) /
    PRDAY1                   (F3.0) /
    PRDAY2                   (F3.0) /
    PRDAY3                   (F3.0) /
    PRDAY4                   (F3.0) /
    PRDAY5                   (F3.0) /
    PRDAY6                   (F3.0) /
    PRDAY7                   (F3.0) /
    PRDAY8                   (F3.0) /
    PRDAY9                   (F3.0) /
    PRDAY10                  (F3.0) /
    PRDAY11                  (F3.0) /
    PRDAY12                  (F3.0) /
    PRDAY13                  (F3.0) /
    PRDAY14                  (F3.0) /
    PRDAY15                  (F3.0) /
    RACE                     (F2.0) /
    TOTCHG                   (F10.0) /
    TOTCHG_X                 (F15.2) /
    UNCBRTH                  (F2.0) /
    YEAR                     (F4.0) /
    ZIPINC_Q                 (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSPID                   "HCUP hospital identification number"
    RECNUM                   "HCUP record number"
    AGE                      "Age in years at admission"
    AGEDAY                   "Age in days (when age < 1 year)"
    AGEMONTH                 "Age in months (when age < 11 years)"
    AMONTH                   "Admission month"
    ASOURCE                  "Admission source (uniform)"
    ASOURCEU                 "Admission source (UB-92 standard coding)"
    ASOURCE_                 "Admission source (as received from source)"
    ATYPE                    "Admission type"
    AWEEKEND                 "Admission day is a weekend"
    BWT                      "Birth weight in grams"
    DIED                     "Died during hospitalization"
    DISCWT                   "Weight to discharges in AHA universe"
    DISPUB92                 "Disposition of patient (UB-92 standard coding)"
    DISPUNIF                 "Disposition of patient (uniform)"
    DQTR                     "Discharge quarter"
    DQTR_X                   "Discharge quarter (as received from source)"
    DRG                      "DRG in effect on discharge date"
    DRG24                    "DRG, version 24"
    DRGVER                   "DRG grouper version used on discharge date"
    DSHOSPID                 "Data source hospital identifier"
    DX1                      "Principal diagnosis"
    DX2                      "Diagnosis 2"
    DX3                      "Diagnosis 3"
    DX4                      "Diagnosis 4"
    DX5                      "Diagnosis 5"
    DX6                      "Diagnosis 6"
    DX7                      "Diagnosis 7"
    DX8                      "Diagnosis 8"
    DX9                      "Diagnosis 9"
    DX10                     "Diagnosis 10"
    DX11                     "Diagnosis 11"
    DX12                     "Diagnosis 12"
    DX13                     "Diagnosis 13"
    DX14                     "Diagnosis 14"
    DX15                     "Diagnosis 15"
    DXCCS1                   "CCS: principal diagnosis"
    DXCCS2                   "CCS: diagnosis 2"
    DXCCS3                   "CCS: diagnosis 3"
    DXCCS4                   "CCS: diagnosis 4"
    DXCCS5                   "CCS: diagnosis 5"
    DXCCS6                   "CCS: diagnosis 6"
    DXCCS7                   "CCS: diagnosis 7"
    DXCCS8                   "CCS: diagnosis 8"
    DXCCS9                   "CCS: diagnosis 9"
    DXCCS10                  "CCS: diagnosis 10"
    DXCCS11                  "CCS: diagnosis 11"
    DXCCS12                  "CCS: diagnosis 12"
    DXCCS13                  "CCS: diagnosis 13"
    DXCCS14                  "CCS: diagnosis 14"
    DXCCS15                  "CCS: diagnosis 15"
    ECODE1                   "E code 1"
    ECODE2                   "E code 2"
    ECODE3                   "E code 3"
    ECODE4                   "E code 4"
    ELECTIVE                 "Elective versus non-elective admission"
    E_CCS1                   "CCS: E Code 1"
    E_CCS2                   "CCS: E Code 2"
    E_CCS3                   "CCS: E Code 3"
    E_CCS4                   "CCS: E Code 4"
    FEMALE                   "Indicator of sex"
    HOSPBRTH                 "Indicator of birth in this hospital"
    HOSPST                   "Hospital state postal code"
    KID_STRA                 "Hospital stratum used for weights"
    LOS                      "Length of stay (cleaned)"
    LOS_X                    "Length of stay (as received from source)"
    MDC                      "MDC in effect on discharge date"
    MDC24                    "MDC, version 24"
    MDNUM1_R                 "Physician 1 number (re-identified)"
    MDNUM2_R                 "Physician 2 number (re-identified)"
    NDX                      "Number of diagnoses on this record"
    NECODE                   "Number of E codes on this record"
    NEOMAT                   "Neonatal and/or maternal DX and/or PR"
    NPR                      "Number of procedures on this record"
    PAY1                     "Primary expected payer (uniform)"
    PAY1_X                   "Primary expected payer (as received from source)"
    PAY2                     "Secondary expected payer (uniform)"
    PAY2_X                   "Secondary expected payer (as received from source)"
    PL_NCHS2                 "Patient Location: NCHS Urban-Rural Code (V2006)"
    PR1                      "Principal procedure"
    PR2                      "Procedure 2"
    PR3                      "Procedure 3"
    PR4                      "Procedure 4"
    PR5                      "Procedure 5"
    PR6                      "Procedure 6"
    PR7                      "Procedure 7"
    PR8                      "Procedure 8"
    PR9                      "Procedure 9"
    PR10                     "Procedure 10"
    PR11                     "Procedure 11"
    PR12                     "Procedure 12"
    PR13                     "Procedure 13"
    PR14                     "Procedure 14"
    PR15                     "Procedure 15"
    PRCCS1                   "CCS: principal procedure"
    PRCCS2                   "CCS: procedure 2"
    PRCCS3                   "CCS: procedure 3"
    PRCCS4                   "CCS: procedure 4"
    PRCCS5                   "CCS: procedure 5"
    PRCCS6                   "CCS: procedure 6"
    PRCCS7                   "CCS: procedure 7"
    PRCCS8                   "CCS: procedure 8"
    PRCCS9                   "CCS: procedure 9"
    PRCCS10                  "CCS: procedure 10"
    PRCCS11                  "CCS: procedure 11"
    PRCCS12                  "CCS: procedure 12"
    PRCCS13                  "CCS: procedure 13"
    PRCCS14                  "CCS: procedure 14"
    PRCCS15                  "CCS: procedure 15"
    PRDAY1                   "Number of days from admission to PR1"
    PRDAY2                   "Number of days from admission to PR2"
    PRDAY3                   "Number of days from admission to PR3"
    PRDAY4                   "Number of days from admission to PR4"
    PRDAY5                   "Number of days from admission to PR5"
    PRDAY6                   "Number of days from admission to PR6"
    PRDAY7                   "Number of days from admission to PR7"
    PRDAY8                   "Number of days from admission to PR8"
    PRDAY9                   "Number of days from admission to PR9"
    PRDAY10                  "Number of days from admission to PR10"
    PRDAY11                  "Number of days from admission to PR11"
    PRDAY12                  "Number of days from admission to PR12"
    PRDAY13                  "Number of days from admission to PR13"
    PRDAY14                  "Number of days from admission to PR14"
    PRDAY15                  "Number of days from admission to PR15"
    RACE                     "Race (uniform)"
    TOTCHG                   "Total charges (cleaned)"
    TOTCHG_X                 "Total charges (as received from source)"
    UNCBRTH                  "Normal uncomplicated birth in hospital"
    YEAR                     "Calendar year"
    ZIPINC_Q                 "Median household income national quartile for patient ZIP Code" .

*** Convert special values to system missing values ***.
RECODE RECNUM                   (-9999999 -8888888 -6666666=SYSMIS).
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AGEDAY                   (-99 -88 -66=SYSMIS).
RECODE AGEMONTH                 (-99 -88 -66=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE ASOURCE                  (-9 -8 -6 -5=SYSMIS).
RECODE ATYPE                    (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE BWT                      (-999 -888 -666=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUB92                 (-9 -8 -6 -5=SYSMIS).
RECODE DISPUNIF                 (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DQTR_X                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRG24                    (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DXCCS1                   (-999 -888 -666=SYSMIS).
RECODE DXCCS2                   (-999 -888 -666=SYSMIS).
RECODE DXCCS3                   (-999 -888 -666=SYSMIS).
RECODE DXCCS4                   (-999 -888 -666=SYSMIS).
RECODE DXCCS5                   (-999 -888 -666=SYSMIS).
RECODE DXCCS6                   (-999 -888 -666=SYSMIS).
RECODE DXCCS7                   (-999 -888 -666=SYSMIS).
RECODE DXCCS8                   (-999 -888 -666=SYSMIS).
RECODE DXCCS9                   (-999 -888 -666=SYSMIS).
RECODE DXCCS10                  (-999 -888 -666=SYSMIS).
RECODE DXCCS11                  (-999 -888 -666=SYSMIS).
RECODE DXCCS12                  (-999 -888 -666=SYSMIS).
RECODE DXCCS13                  (-999 -888 -666=SYSMIS).
RECODE DXCCS14                  (-999 -888 -666=SYSMIS).
RECODE DXCCS15                  (-999 -888 -666=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE E_CCS1                   (-999 -888 -666=SYSMIS).
RECODE E_CCS2                   (-999 -888 -666=SYSMIS).
RECODE E_CCS3                   (-999 -888 -666=SYSMIS).
RECODE E_CCS4                   (-999 -888 -666=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HOSPBRTH                 (-9 -8 -6 -5=SYSMIS).
RECODE KID_STRA                 (-999 -888 -666=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE LOS_X                    (-99999 -88888 -66666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC24                    (-9 -8 -6 -5=SYSMIS).
RECODE MDNUM1_R                 (-9999 -8888 -6666=SYSMIS).
RECODE MDNUM2_R                 (-9999 -8888 -6666=SYSMIS).
RECODE NDX                      (-9 -8 -6 -5=SYSMIS).
RECODE NECODE                   (-99 -88 -66=SYSMIS).
RECODE NEOMAT                   (-9 -8 -6 -5=SYSMIS).
RECODE NPR                      (-9 -8 -6 -5=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PAY2                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS2                 (-99 -88 -66=SYSMIS).
RECODE PRCCS1                   (-99 -88 -66=SYSMIS).
RECODE PRCCS2                   (-99 -88 -66=SYSMIS).
RECODE PRCCS3                   (-99 -88 -66=SYSMIS).
RECODE PRCCS4                   (-99 -88 -66=SYSMIS).
RECODE PRCCS5                   (-99 -88 -66=SYSMIS).
RECODE PRCCS6                   (-99 -88 -66=SYSMIS).
RECODE PRCCS7                   (-99 -88 -66=SYSMIS).
RECODE PRCCS8                   (-99 -88 -66=SYSMIS).
RECODE PRCCS9                   (-99 -88 -66=SYSMIS).
RECODE PRCCS10                  (-99 -88 -66=SYSMIS).
RECODE PRCCS11                  (-99 -88 -66=SYSMIS).
RECODE PRCCS12                  (-99 -88 -66=SYSMIS).
RECODE PRCCS13                  (-99 -88 -66=SYSMIS).
RECODE PRCCS14                  (-99 -88 -66=SYSMIS).
RECODE PRCCS15                  (-99 -88 -66=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE RACE                     (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE TOTCHG_X                 (-99999999999.99 -88888888888.88 -66666666666.66=SYSMIS).
RECODE UNCBRTH                  (-9 -8 -6 -5=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_Q                 (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'KID_2006_Core.SAV' / COMPRESSED.
