/*****************************************************************************
* SASload_KID_2019_Hospital.SAS
* This program will load the KID_2019_Hospital ASCII File into SAS.
* Created on 12/02/2022.
*****************************************************************************/

Options Compress=Yes;

*** Create SAS informats for missing values ***;
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

*** Data Step to load the file ***;
DATA KID_2019_Hospital; 
INFILE 'KID_2019_Hospital.ASC' LRECL = 85;

*** Define data element attributes ***;
ATTRIB 
  HOSP_KID                   LENGTH=4            FORMAT=Z5.
  LABEL="KID hospital number"

  N_BRTH_U                   LENGTH=4
  LABEL="Number of universe births in the stratum"

  N_DISC_U                   LENGTH=5
  LABEL="Number of universe discharges in the stratum"

  N_HOSP_U                   LENGTH=3
  LABEL="Number of universe hospitals in the stratum"

  S_BRTH_U                   LENGTH=4
  LABEL="Number of sample births in the stratum"

  S_CHLD_U                   LENGTH=4
  LABEL="Number of sample pediatric non-births in the stratum"

  S_CMPB_U                   LENGTH=4
  LABEL="Number of sample sick newborns in the stratum"

  S_DISC_U                   LENGTH=4
  LABEL="Number of sample births and children in the stratum"

  S_HOSP_U                   LENGTH=3
  LABEL="Number of sample hospitals in the stratum"

  S_UNCB_U                   LENGTH=4
  LABEL="Number of sample normal newborns in the stratum"

  HOSP_LOCTEACH              LENGTH=3            FORMAT=2.
  LABEL="Location/teaching status of hospital"

  H_CONTRL                   LENGTH=3            FORMAT=2.
  LABEL="Control/ownership of hospital"

  HOSP_REGION                LENGTH=3            FORMAT=2.
  LABEL="Region of hospital"

  KID_STRATUM                LENGTH=4
  LABEL="KID hospital stratum"

  YEAR                       LENGTH=4
  LABEL="Calendar year"

  HOSP_BEDSIZE               LENGTH=3            FORMAT=2.
  LABEL="Bedsize of hospital"
  ;

*** Read data elements from the ASCII file ***;
INPUT 
      @1      HOSP_KID                 N5PF.
      @6      N_BRTH_U                 N8PF.
      @14     N_DISC_U                 N8PF.
      @22     N_HOSP_U                 N4PF.
      @26     S_BRTH_U                 N8PF.
      @34     S_CHLD_U                 N8PF.
      @42     S_CMPB_U                 N8PF.
      @50     S_DISC_U                 N8PF.
      @58     S_HOSP_U                 N4PF.
      @62     S_UNCB_U                 N8PF.
      @70     HOSP_LOCTEACH            N2PF.
      @72     H_CONTRL                 N2PF.
      @74     HOSP_REGION              N2PF.
      @76     KID_STRATUM              N4PF.
      @80     YEAR                     N4PF.
      @84     HOSP_BEDSIZE             N2PF.
      ;
RUN;
