/*****************************************************************************
* SASload_KID_2009_Hospital.SAS
* This program will load the 2009 KID ASCII Hospital File into SAS.
*****************************************************************************/

*** Create SAS informats for missing values ***;
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

*** Data Step to load the file ***;
DATA KID_2009_Hospital; 
INFILE 'KID_2009_Hospital.ASC' LRECL = 323;                                                                                                                                                                                                    

*** Define data element attributes ***;
ATTRIB 
  AHAID                      LENGTH=$7
  LABEL="AHA hospital identifier"

  HFIPSSTCO                  LENGTH=4
  LABEL="Hospital FIPS state/county code"

  HOSPADDR                   LENGTH=$60
  LABEL="Hospital address from AHA Survey (Z011)"

  HOSPCITY                   LENGTH=$20
  LABEL="Hospital city from AHA Survey (Z012)"

  HOSPID                     LENGTH=4            FORMAT=Z5.
  LABEL="HCUP hospital identification number"

  HOSPNAME                   LENGTH=$90
  LABEL="Hospital name from AHA Survey (Z000)"

  HOSPST                     LENGTH=$2
  LABEL="Hospital state postal code"

  HOSPSTCO                   LENGTH=4            FORMAT=Z5.
  LABEL="Hospital modified FIPS state/county code"

  HOSPZIP                    LENGTH=$5
  LABEL="Hospital ZIP Code from AHA Survey (Z014)"

  HOSP_BEDSIZE               LENGTH=3            FORMAT=2.
  LABEL="Bedsize of hospital"

  HOSP_CONTROL               LENGTH=3            FORMAT=2.
  LABEL="Control/ownership of hospital"

  HOSP_LOCATION              LENGTH=3            FORMAT=2.
  LABEL="Location (urban/rural) of hospital"

  HOSP_LOCTEACH              LENGTH=3            FORMAT=2.
  LABEL="Location/teaching status of hospital"

  HOSP_REGION                LENGTH=3            FORMAT=2.
  LABEL="Region of hospital"

  HOSP_TEACH                 LENGTH=3            FORMAT=2.
  LABEL="Teaching status of hospital"

  IDNUMBER                   LENGTH=$6
  LABEL="AHA hospital identifier without the leading 6"

  KID_STRATUM                LENGTH=4            FORMAT=4.
  LABEL="Hospital stratum used for weights"

  NACHTYPE                   LENGTH=3            FORMAT=3.
  LABEL="NACHRI hospital type"

  N_BRTH_U                   LENGTH=8
  LABEL="Number of universe births in KID_STRATUM"

  N_DISC_U                   LENGTH=8
  LABEL="Number of universe discharges in KID_STRATUM"

  N_HOSP_U                   LENGTH=8
  LABEL="Number of universe hospitals in KID_STRATUM"

  PEDS_DISC                  LENGTH=4
  LABEL="Number of discharges, 20 years old or younger, from this hospital in the SID"

  PEDS_PCT                   LENGTH=8
  LABEL="Percentage of hospital discharges, 20 years old or younger"

  S_BRTH_U                   LENGTH=8
  LABEL="Number of sample births in KID_STRATUM"

  S_CHLD_U                   LENGTH=8
  LABEL="Number of sample pediatric non-births in KID_STRATUM"

  S_CMPB_U                   LENGTH=8
  LABEL="Number of sample complicated births in KID_STRATUM"

  S_DISC_U                   LENGTH=8
  LABEL="Number of sample births and children in KID_STRATUM"

  S_HOSP_U                   LENGTH=8
  LABEL="Number of sample hospitals in KID_STRATUM"

  S_UNCB_U                   LENGTH=8
  LABEL="Number of sample uncomplicated births in KID_STRATUM"

  TOTAL_DISC                 LENGTH=4
  LABEL="Total number of discharges from this hospital in the SID"

  YEAR                       LENGTH=3
  LABEL="Calendar year"

  H_CONTRL                   LENGTH=3
  LABEL="Control/ownership of hospital"

  HOSP_RNPCT                 LENGTH=3
  LABEL="Percentage of RNs among licensed nurses"

  HOSP_RNFTEAPD              LENGTH=4            FORMAT=5.1
  LABEL="RN FTEs per 1000 adjusted patient days"

  HOSP_LPNFTEAPD             LENGTH=4            FORMAT=5.1
  LABEL="LPN FTEs per 1000 adjusted patient days"

  HOSP_NAFTEAPD              LENGTH=4            FORMAT=5.1
  LABEL="Nurse aides per 1000 adjusted patient days"

  HOSP_OPSURGPCT             LENGTH=3
  LABEL="Percentage of all surgeries performed in outpatient setting"

  HOSP_MHSMEMBER             LENGTH=3
  LABEL="Hospital is part of multiple hospital system-@"

  HOSP_MHSCLUSTER            LENGTH=3
  LABEL="AHA multiple hospital system cluster code"
  ;

*** Read data elements from the ASCII file ***;
INPUT 
      @1      AHAID                    $CHAR7.
      @8      HFIPSSTCO                N5PF.
      @13     HOSPADDR                 $CHAR60.
      @73     HOSPCITY                 $CHAR20.
      @93     HOSPID                   5.
      @98     HOSPNAME                 $CHAR90.
      @188    HOSPST                   $CHAR2.
      @190    HOSPSTCO                 N5PF.
      @195    HOSPZIP                  $CHAR5.
      @200    HOSP_BEDSIZE             N2PF.
      @202    HOSP_CONTROL             N2PF.
      @204    HOSP_LOCATION            N2PF.
      @206    HOSP_LOCTEACH            N2PF.
      @208    HOSP_REGION              N2PF.
      @210    HOSP_TEACH               N2PF.
      @212    IDNUMBER                 $CHAR6.
      @218    KID_STRATUM              N4PF.
      @222    NACHTYPE                 N2PF.
      @224    N_BRTH_U                 N6PF.
      @230    N_DISC_U                 N8PF.
      @238    N_HOSP_U                 N4PF.
      @242    PEDS_DISC                N6PF.
      @248    PEDS_PCT                 N8P4F.
      @256    S_BRTH_U                 N6PF.
      @262    S_CHLD_U                 N6PF.
      @268    S_CMPB_U                 N6PF.
      @274    S_DISC_U                 N6PF.
      @280    S_HOSP_U                 N4PF.
      @284    S_UNCB_U                 N6PF.
      @290    TOTAL_DISC               N6PF.
      @296    YEAR                     N4PF.
      @300    H_CONTRL                 N2PF.
      @302    HOSP_RNPCT               N3PF.
      @305    HOSP_RNFTEAPD            N4P1F.
      @309    HOSP_LPNFTEAPD           N4P1F.
      @313    HOSP_NAFTEAPD            N4P1F.
      @317    HOSP_OPSURGPCT           N3PF.
      @320    HOSP_MHSMEMBER           N2PF.
      @322    HOSP_MHSCLUSTER          N2PF.
      ;
RUN;
