/************************************************************************************
Program Name: SingleDXCCSLoad.do 
Description : Load SingleDXCCS.dta file used to assign Single-Level DXCCS categories from Stata. 
Developed   : By David Ross on 10/26/2009.
Updated     : By David Ross and Nils Nordstrand on 11/03/2016.
************************************************************************************/

local fyear     "2015"
local tool      SingleDXCCS
local prefix    "dxref "
local ivar      DX
local ovar      DXCCS

if `"`ivar'"' == "PR" local icd9f icd9p
else local icd9f icd9

* Remove first two lines from file
infix str line 1-200 using "\$`prefix'`fyear'.csv" in 3/L, clear
outfile line using "\$`prefix'`fyear'Stata.csv", noquote replace wide

infile str6    _`ivar'            ///
       str4    `ovar'             ///
       str100  DXCCSDescription   ///
       str100  I9DXDescription    ///
       str4    O`ovar'            ///
       str100  ODXCCSDescription  ///
       using "\$`prefix'`fyear'Stata.csv", clear

destring `ovar', replace

`icd9f' clean _`ivar', dots
sort _`ivar'
keep _`ivar' `ovar'
save `tool', replace

