/************************************************************************************
Program Name: MultiPRCCSLoad.do 
Description : Load MultiPRCCS.dta file used to assign Multi-Level PRCCS categories from Stata. 
Developed   : By David Ross on 10/26/2009.
Updated     : By Nils Nordstrand on 11/03/2016
************************************************************************************/

local fyear     "2015"
local tool      MultiPRCCS
local prefix    ccs_multi_pr_tool_
local ivar      PR
local ovar      L1pccs L2pccs L3pccs

if `"`ivar'"' == "PR" local icd9f icd9p
else local icd9f icd9

* Remove first line from file
infix str lineA    1-200    ///
      str lineB  201-400    ///
      using `prefix'`fyear'.csv in 2/L, clear
outfile lineA lineB using `prefix'`fyear'Stata.csv, runtogether replace

infile str6    _`ivar'       ///
       str2    L1pccs       ///
       str100  L1Description ///
       str5    L2pccs       ///
       str100  L2Description ///
       str8    L3pccs       ///
       str100  L3Description ///
       using `prefix'`fyear'Stata.csv, clear

replace L1pccs = trim(L1pccs)
replace L2pccs = trim(L2pccs)
replace L3pccs = trim(L3pccs)

`icd9f' clean _`ivar', dots
sort _`ivar'
keep _`ivar' `ovar'
save `tool', replace

