/*****************************************************************************
* Creation Date: 08/05/2025   
* MA_SID_2023_DX_PR_GRPS.Do
* This program will load the 2023 MA ASCII DX_PR_GRPS File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/*** Set available memory size ***/
set mem 500m

/*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***/
infix 3 firstlineoffile                            ///
      str    CCIR_VERSION                 1-   6   ///
      int    CCIR1                        7-   9   ///
      int    CCIR2                       10-  12   ///
      int    CCIR3                       13-  15   ///
      int    CCIR4                       16-  18   ///
      int    CCIR5                       19-  21   ///
      int    CCIR6                       22-  24   ///
      int    CCIR7                       25-  27   ///
      int    CCIR8                       28-  30   ///
      int    CCIR9                       31-  33   ///
      int    CCIR10                      34-  36   ///
      int    CCIR11                      37-  39   ///
      int    CCIR12                      40-  42   ///
      int    CCIR13                      43-  45   ///
      int    CCIR14                      46-  48   ///
      int    CCIR15                      49-  51   ///
      int    CCIR16                      52-  54   ///
      int    CCIR17                      55-  57   ///
      int    CCIR18                      58-  60   ///
      int    CCIR19                      61-  63   ///
      int    CCIR20                      64-  66   ///
      int    CCIR21                      67-  69   ///
      int    CCIR22                      70-  72   ///
      int    CCIR23                      73-  75   ///
      int    CCIR24                      76-  78   ///
      int    CCIR25                      79-  81   ///
      int    CCIR26                      82-  84   ///
      int    CCIR27                      85-  87   ///
      int    CCIR28                      88-  90   ///
      int    CCIR29                      91-  93   ///
      int    CCIR30                      94-  96   ///
      int    CCIR31                      97-  99   ///
      int    CCIR32                     100- 102   ///
      int    CCIR33                     103- 105   ///
      int    CCIR34                     106- 108   ///
      int    CCIR35                     109- 111   ///
      int    CCIR36                     112- 114   ///
      int    CCIR37                     115- 117   ///
      int    CCIR38                     118- 120   ///
      int    CCIR39                     121- 123   ///
      int    CCIR40                     124- 126   ///
      int    CCIR41                     127- 129   ///
      int    CCIR42                     130- 132   ///
      int    CCIR43                     133- 135   ///
      int    CCIR44                     136- 138   ///
      int    CCIR45                     139- 141   ///
      int    CCIR46                     142- 144   ///
      int    CCIR47                     145- 147   ///
      int    CCIR48                     148- 150   ///
      int    CCIR49                     151- 153   ///
      int    CCIR50                     154- 156   ///
      int    CCIR51                     157- 159   ///
      int    CCIR52                     160- 162   ///
      int    CCIR53                     163- 165   ///
      int    CCIR54                     166- 168   ///
      int    CCIR55                     169- 171   ///
      int    CCIR56                     172- 174   ///
      int    CCIR57                     175- 177   ///
      int    CCIR58                     178- 180   ///
      int    CCIR59                     181- 183   ///
      int    CCIR60                     184- 186   ///
      int    CCIR61                     187- 189   ///
      int    CCIR62                     190- 192   ///
      int    CCIR63                     193- 195   ///
      int    CCIR64                     196- 198   ///
      int    CCIR65                     199- 201   ///
      int    CCIR66                     202- 204   ///
      int    CCIR67                     205- 207   ///
      int    CCIR68                     208- 210   ///
      int    CCIR69                     211- 213   ///
      int    CCIR70                     214- 216   ///
      int    CCIR71                     217- 219   ///
      int    CCIR72                     220- 222   ///
      int    CCIR73                     223- 225   ///
      int    CCIR74                     226- 228   ///
      int    CCIR75                     229- 231   ///
      int    CCIR76                     232- 234   ///
      int    CCIR77                     235- 237   ///
      int    CCIR78                     238- 240   ///
      int    CCIR79                     241- 243   ///
      int    CCIR80                     244- 246   ///
      int    CCIR81                     247- 249   ///
      int    CCIR82                     250- 252   ///
      int    CCIR83                     253- 255   ///
      int    CCIR84                     256- 258   ///
      int    CCIR85                     259- 261   ///
      int    CCIR86                     262- 264   ///
      int    CCIR87                     265- 267   ///
      int    CCIR88                     268- 270   ///
      int    CCIR89                     271- 273   ///
      int    CCIR90                     274- 276   ///
      int    CCIR91                     277- 279   ///
      int    CCIR92                     280- 282   ///
      int    CCIR93                     283- 285   ///
      int    CCIR94                     286- 288   ///
      int    CCIR95                     289- 291   ///
      int    CCIR96                     292- 294   ///
      int    CCIR97                     295- 297   ///
      int    CCIR98                     298- 300   ///
      int    CCIR99                     301- 303   ///
      int    CCIR100                    304- 306   ///
      int    CCIR101                    307- 309   ///
      int    CCIR102                    310- 312   ///
      int    CCIR103                    313- 315   ///
      int    CCIR104                    316- 318   ///
      int    CCIR105                    319- 321   ///
      int    CCIR106                    322- 324   ///
      int    CCIR107                    325- 327   ///
      int    CCIR108                    328- 330   ///
      int    CCIR109                    331- 333   ///
      int    CCIR110                    334- 336   ///
      int    CCIR111                    337- 339   ///
      int    CCIR112                    340- 342   ///
      int    CCIR113                    343- 345   ///
      int    CCIR114                    346- 348   ///
      int    CCIR115                    349- 351   ///
      int    CCIR116                    352- 354   ///
      int    CCIR117                    355- 357   ///
      int    CCIR118                    358- 360   ///
      int    CCIR119                    361- 363   ///
      int    CCIR120                    364- 366   ///
      int    CCIR121                    367- 369   ///
      int    CCIR122                    370- 372   ///
      int    CCIR123                    373- 375   ///
      int    CCIR124                    376- 378   ///
      int    CCIR125                    379- 381   ///
      int    CCIR126                    382- 384   ///
      int    CCIR127                    385- 387   ///
      byte   CMR_ANEMDEF                388- 389   ///
      byte   CMR_AUTOIMMUNE             390- 391   ///
      byte   CMR_BLDLOSS                392- 393   ///
      byte   CMR_CANCER_LEUK            394- 395   ///
      byte   CMR_CANCER_LYMPH           396- 397   ///
      byte   CMR_CANCER_METS            398- 399   ///
      byte   CMR_CANCER_NSITU           400- 401   ///
      byte   CMR_CANCER_SOLID           402- 403   ///
      byte   CMR_CBVD                   404- 405   ///
      byte   CMR_COAG                   406- 407   ///
      byte   CMR_DEMENTIA               408- 409   ///
      byte   CMR_DIAB_CX                410- 411   ///
      byte   CMR_DIAB_UNCX              412- 413   ///
      byte   CMR_HF                     414- 415   ///
      byte   CMR_HTN_CX                 416- 417   ///
      byte   CMR_HTN_UNCX               418- 419   ///
      byte   CMR_LUNG_CHRONIC           420- 421   ///
      byte   CMR_NEURO_MOVT             422- 423   ///
      byte   CMR_NEURO_OTH              424- 425   ///
      byte   CMR_NEURO_SEIZ             426- 427   ///
      byte   CMR_PARALYSIS              428- 429   ///
      byte   CMR_PERIVASC               430- 431   ///
      byte   CMR_PULMCIRC               432- 433   ///
      byte   CMR_RENLFL_MOD             434- 435   ///
      byte   CMR_RENLFL_SEV             436- 437   ///
      byte   CMR_THYROID_HYPO           438- 439   ///
      byte   CMR_THYROID_OTH            440- 441   ///
      byte   CMR_ULCER_PEPTIC           442- 443   ///
      byte   CMR_VALVE                  444- 445   ///
      str    CMR_VERSION                446- 451   ///
      byte   CMR_WGHTLOSS               452- 453   ///
      byte   I10_INJURY                 454- 455   ///
      byte   I10_INJURY_CUT             456- 457   ///
      byte   I10_INJURY_DROWN           458- 459   ///
      byte   I10_INJURY_FALL            460- 461   ///
      byte   I10_INJURY_FIRE            462- 463   ///
      byte   I10_INJURY_FIREARM         464- 465   ///
      byte   I10_INJURY_MACHINERY       466- 467   ///
      byte   I10_INJURY_MVT             468- 469   ///
      byte   I10_INJURY_NATURE          470- 471   ///
      byte   I10_INJURY_OVEREXERTION    472- 473   ///
      byte   I10_INJURY_POISON          474- 475   ///
      byte   I10_INJURY_STRUCK          476- 477   ///
      byte   I10_INJURY_SUFFOCATION     478- 479   ///
      byte   I10_INTENT_ASSAULT         480- 481   ///
      byte   I10_INTENT_SELF_HARM       482- 483   ///
      byte   I10_INTENT_UNINTENTIONAL   484- 485   ///
      byte   I10_MULTINJURY             486- 487   ///
      double KEY                        488- 502   ///
      str    PCLASS_VERSION             503- 508   ///
      byte   PCLASS1                    509- 510   ///
      byte   PCLASS2                    511- 512   ///
      byte   PCLASS3                    513- 514   ///
      byte   PCLASS4                    515- 516   ///
      byte   PCLASS5                    517- 518   ///
      byte   PCLASS6                    519- 520   ///
      byte   PCLASS7                    521- 522   ///
      byte   PCLASS8                    523- 524   ///
      byte   PCLASS9                    525- 526   ///
      byte   PCLASS10                   527- 528   ///
      byte   PCLASS11                   529- 530   ///
      byte   PCLASS12                   531- 532   ///
      byte   PCLASS13                   533- 534   ///
      byte   PCLASS14                   535- 536   ///
      byte   PCLASS15                   537- 538   ///
      byte   PCLASS16                   539- 540   ///
      byte   PCLASS17                   541- 542   ///
      byte   PCLASS18                   543- 544   ///
      byte   PCLASS19                   545- 546   ///
      byte   PCLASS20                   547- 548   ///
      byte   PCLASS21                   549- 550   ///
      byte   PCLASS22                   551- 552   ///
      byte   PCLASS23                   553- 554   ///
      byte   PCLASS24                   555- 556   ///
      byte   PCLASS25                   557- 558   ///
      byte   PCLASS26                   559- 560   ///
      byte   PCLASS27                   561- 562   ///
      byte   PCLASS28                   563- 564   ///
      byte   PCLASS29                   565- 566   ///
      byte   PCLASS30                   567- 568   ///
      byte   PCLASS31                   569- 570   ///
      byte   PCLASS32                   571- 572   ///
      byte   PCLASS33                   573- 574   ///
      byte   PCLASS34                   575- 576   ///
      byte   PCLASS35                   577- 578   ///
      byte   PCLASS36                   579- 580   ///
      byte   PCLASS37                   581- 582   ///
      byte   PCLASS38                   583- 584   ///
      byte   PCLASS39                   585- 586   ///
      byte   PCLASS40                   587- 588   ///
      byte   PCLASS41                   589- 590   ///
      byte   PCLASS42                   591- 592   ///
      byte   PCLASS43                   593- 594   ///
      byte   PCLASS44                   595- 596   ///
      byte   PCLASS45                   597- 598   ///
      byte   PCLASS46                   599- 600   ///
      byte   PCLASS47                   601- 602   ///
      byte   PCLASS48                   603- 604   ///
      byte   PCLASS49                   605- 606   ///
      byte   PCLASS50                   607- 608   ///
      byte   PCLASS51                   609- 610   ///
      byte   PCLASS52                   611- 612   ///
      byte   PCLASS53                   613- 614   ///
      byte   PCLASS54                   615- 616   ///
      byte   PCLASS55                   617- 618   ///
      byte   PCLASS56                   619- 620   ///
      byte   PCLASS57                   621- 622   ///
      byte   PCLASS58                   623- 624   ///
      byte   PCLASS59                   625- 626   ///
      byte   PCLASS60                   627- 628   ///
      byte   PCLASS61                   629- 630   ///
      byte   PCLASS62                   631- 632   ///
      byte   PCLASS63                   633- 634   ///
      byte   PCLASS64                   635- 636   ///
      byte   PCLASS65                   637- 638   ///
      byte   PCLASS66                   639- 640   ///
      byte   PCLASS67                   641- 642   ///
      byte   PCLASS68                   643- 644   ///
      byte   PCLASS69                   645- 646   ///
      byte   PCLASS70                   647- 648   ///
      byte   PCLASS71                   649- 650   ///
      byte   PCLASS72                   651- 652   ///
      byte   PCLASS73                   653- 654   ///
      byte   PCLASS74                   655- 656   ///
      byte   PCLASS75                   657- 658   ///
      byte   PCLASS76                   659- 660   ///
      byte   PCLASS77                   661- 662   ///
      byte   PCLASS78                   663- 664   ///
      byte   PCLASS79                   665- 666   ///
      byte   PCLASS80                   667- 668   ///
      byte   PCLASS81                   669- 670   ///
      byte   PCLASS82                   671- 672   ///
      byte   PCLASS83                   673- 674   ///
      byte   PCLASS84                   675- 676   ///
      byte   PCLASS85                   677- 678   ///
      byte   PCLASS86                   679- 680   ///
      byte   PCLASS87                   681- 682   ///
      byte   PCLASS88                   683- 684   ///
      byte   PCLASS89                   685- 686   ///
      byte   PCLASS90                   687- 688   ///
      byte   PCLASS91                   689- 690   ///
      byte   PCLASS92                   691- 692   ///
      byte   PCLASS93                   693- 694   ///
      byte   PCLASS94                   695- 696   ///
      byte   PCLASS95                   697- 698   ///
      byte   PCLASS96                   699- 700   ///
      byte   PCLASS97                   701- 702   ///
      byte   PCLASS98                   703- 704   ///
      byte   PCLASS99                   705- 706   ///
      byte   PCLASS100                  707- 708   ///
      byte   PCLASS101                  709- 710   ///
      byte   PCLASS102                  711- 712   ///
      byte   PCLASS103                  713- 714   ///
      byte   PCLASS104                  715- 716   ///
      byte   PCLASS105                  717- 718   ///
      byte   PCLASS106                  719- 720   ///
      byte   PCLASS107                  721- 722   ///
      byte   PCLASS108                  723- 724   ///
      byte   PCLASS109                  725- 726   ///
      byte   PCLASS110                  727- 728   ///
      byte   PCLASS111                  729- 730   ///
      byte   PCLASS112                  731- 732   ///
      byte   PCLASS113                  733- 734   ///
      byte   PCLASS114                  735- 736   ///
      byte   PCLASS115                  737- 738   ///
      byte   PCLASS116                  739- 740   ///
      byte   PCLASS117                  741- 742   ///
      byte   PCLASS118                  743- 744   ///
      byte   PCLASS119                  745- 746   ///
      byte   PCLASS120                  747- 748   ///
      byte   PCLASS121                  749- 750   ///
      byte   PCLASS122                  751- 752   ///
      byte   PCLASS123                  753- 754   ///
      byte   PCLASS124                  755- 756   ///
      byte   PCLASS125                  757- 758   ///
      byte   PCLASS126                  759- 760   ///
      byte   PCLASS127                  761- 762   ///
      byte   PCLASS128                  763- 764   ///
      byte   PCLASS129                  765- 766   ///
      byte   PCLASS130                  767- 768   ///
      byte   PCLASS131                  769- 770   ///
      byte   PCLASS132                  771- 772   ///
      byte   PCLASS133                  773- 774   ///
      byte   PCLASS134                  775- 776   ///
      byte   PCLASS135                  777- 778   ///
      byte   PCLASS136                  779- 780   ///
      byte   PCLASS137                  781- 782   ///
      byte   PCLASS138                  783- 784   ///
      byte   PCLASS139                  785- 786   ///
      byte   PCLASS140                  787- 788   ///
      byte   PCLASS141                  789- 790   ///
      byte   PCLASS142                  791- 792   ///
      byte   PCLASS143                  793- 794   ///
      byte   PCLASS144                  795- 796   ///
      byte   PCLASS145                  797- 798   ///
      byte   PCLASS146                  799- 800   ///
      byte   PCLASS147                  801- 802   ///
      byte   PCLASS148                  803- 804   ///
      byte   PCLASS149                  805- 806   ///
      byte   PCLASS150                  807- 808   ///
      byte   PCLASS151                  809- 810   ///
      byte   PCLASS152                  811- 812   ///
      byte   PCLASS153                  813- 814   ///
      byte   PCLASS154                  815- 816   ///
      byte   PCLASS155                  817- 818   ///
      byte   PCLASS156                  819- 820   ///
      byte   PCLASS157                  821- 822   ///
      byte   PCLASS158                  823- 824   ///
      byte   PCLASS159                  825- 826   ///
      byte   PCLASS160                  827- 828   ///
      byte   PCLASS161                  829- 830   ///
      byte   PCLASS162                  831- 832   ///
      byte   PCLASS163                  833- 834   ///
      byte   PCLASS164                  835- 836   ///
      byte   PCLASS165                  837- 838   ///
      byte   PCLASS166                  839- 840   ///
      byte   PCLASS167                  841- 842   ///
      byte   PCLASS168                  843- 844   ///
      byte   PCLASS169                  845- 846   ///
      byte   PCLASS170                  847- 848   ///
      byte   PCLASS171                  849- 850   ///
      byte   PCLASS172                  851- 852   ///
      byte   PCLASS173                  853- 854   ///
      byte   PCLASS174                  855- 856   ///
      byte   PCLASS175                  857- 858   ///
      byte   PCLASS176                  859- 860   ///
      byte   PCLASS177                  861- 862   ///
      byte   PCLASS178                  863- 864   ///
      byte   PCLASS179                  865- 866   ///
      byte   PCLASS180                  867- 868   ///
      byte   PCLASS181                  869- 870   ///
      byte   PCLASS182                  871- 872   ///
      byte   PCLASS183                  873- 874   ///
      byte   PCLASS184                  875- 876   ///
      byte   PCLASS185                  877- 878   ///
      byte   PCLASS186                  879- 880   ///
      byte   PCLASS187                  881- 882   ///
      byte   PCLASS188                  883- 884   ///
      byte   PCLASS189                  885- 886   ///
      byte   PCLASS190                  887- 888   ///
      byte   PCLASS191                  889- 890   ///
      byte   PCLASS192                  891- 892   ///
      byte   PCLASS193                  893- 894   ///
      byte   PCLASS194                  895- 896   ///
      byte   PCLASS195                  897- 898   ///
      byte   PCLASS196                  899- 900   ///
      byte   PCLASS197                  901- 902   ///
      byte   PCLASS198                  903- 904   ///
      byte   PCLASS199                  905- 906   ///
      byte   PCLASS200                  907- 908   ///
      str    DXCCSR_Default_DX1         909- 914   ///
      int    DXCCSR_BLD001              915- 917   ///
      int    DXCCSR_BLD002              918- 920   ///
      int    DXCCSR_BLD003              921- 923   ///
      int    DXCCSR_BLD004              924- 926   ///
      int    DXCCSR_BLD005              927- 929   ///
      int    DXCCSR_BLD006              930- 932   ///
      int    DXCCSR_BLD007              933- 935   ///
      int    DXCCSR_BLD008              936- 938   ///
      int    DXCCSR_BLD009              939- 941   ///
      int    DXCCSR_BLD010              942- 944   ///
      int    DXCCSR_CIR001              945- 947   ///
      int    DXCCSR_CIR002              948- 950   ///
      int    DXCCSR_CIR003              951- 953   ///
      int    DXCCSR_CIR004              954- 956   ///
      int    DXCCSR_CIR005              957- 959   ///
      int    DXCCSR_CIR006              960- 962   ///
      int    DXCCSR_CIR007              963- 965   ///
      int    DXCCSR_CIR008              966- 968   ///
      int    DXCCSR_CIR009              969- 971   ///
      int    DXCCSR_CIR010              972- 974   ///
      int    DXCCSR_CIR011              975- 977   ///
      int    DXCCSR_CIR012              978- 980   ///
      int    DXCCSR_CIR013              981- 983   ///
      int    DXCCSR_CIR014              984- 986   ///
      int    DXCCSR_CIR015              987- 989   ///
      int    DXCCSR_CIR016              990- 992   ///
      int    DXCCSR_CIR017              993- 995   ///
      int    DXCCSR_CIR018              996- 998   ///
      int    DXCCSR_CIR019              999-1001   ///
      int    DXCCSR_CIR020             1002-1004   ///
      int    DXCCSR_CIR021             1005-1007   ///
      int    DXCCSR_CIR022             1008-1010   ///
      int    DXCCSR_CIR023             1011-1013   ///
      int    DXCCSR_CIR024             1014-1016   ///
      int    DXCCSR_CIR025             1017-1019   ///
      int    DXCCSR_CIR026             1020-1022   ///
      int    DXCCSR_CIR027             1023-1025   ///
      int    DXCCSR_CIR028             1026-1028   ///
      int    DXCCSR_CIR029             1029-1031   ///
      int    DXCCSR_CIR030             1032-1034   ///
      int    DXCCSR_CIR031             1035-1037   ///
      int    DXCCSR_CIR032             1038-1040   ///
      int    DXCCSR_CIR033             1041-1043   ///
      int    DXCCSR_CIR034             1044-1046   ///
      int    DXCCSR_CIR035             1047-1049   ///
      int    DXCCSR_CIR036             1050-1052   ///
      int    DXCCSR_CIR037             1053-1055   ///
      int    DXCCSR_CIR038             1056-1058   ///
      int    DXCCSR_CIR039             1059-1061   ///
      int    DXCCSR_DEN001             1062-1064   ///
      int    DXCCSR_DEN002             1065-1067   ///
      int    DXCCSR_DEN003             1068-1070   ///
      int    DXCCSR_DIG001             1071-1073   ///
      int    DXCCSR_DIG002             1074-1076   ///
      int    DXCCSR_DIG003             1077-1079   ///
      int    DXCCSR_DIG004             1080-1082   ///
      int    DXCCSR_DIG005             1083-1085   ///
      int    DXCCSR_DIG006             1086-1088   ///
      int    DXCCSR_DIG007             1089-1091   ///
      int    DXCCSR_DIG008             1092-1094   ///
      int    DXCCSR_DIG009             1095-1097   ///
      int    DXCCSR_DIG010             1098-1100   ///
      int    DXCCSR_DIG011             1101-1103   ///
      int    DXCCSR_DIG012             1104-1106   ///
      int    DXCCSR_DIG013             1107-1109   ///
      int    DXCCSR_DIG014             1110-1112   ///
      int    DXCCSR_DIG015             1113-1115   ///
      int    DXCCSR_DIG016             1116-1118   ///
      int    DXCCSR_DIG017             1119-1121   ///
      int    DXCCSR_DIG018             1122-1124   ///
      int    DXCCSR_DIG019             1125-1127   ///
      int    DXCCSR_DIG020             1128-1130   ///
      int    DXCCSR_DIG021             1131-1133   ///
      int    DXCCSR_DIG022             1134-1136   ///
      int    DXCCSR_DIG023             1137-1139   ///
      int    DXCCSR_DIG024             1140-1142   ///
      int    DXCCSR_DIG025             1143-1145   ///
      int    DXCCSR_EAR001             1146-1148   ///
      int    DXCCSR_EAR002             1149-1151   ///
      int    DXCCSR_EAR003             1152-1154   ///
      int    DXCCSR_EAR004             1155-1157   ///
      int    DXCCSR_EAR005             1158-1160   ///
      int    DXCCSR_EAR006             1161-1163   ///
      int    DXCCSR_END001             1164-1166   ///
      int    DXCCSR_END002             1167-1169   ///
      int    DXCCSR_END003             1170-1172   ///
      int    DXCCSR_END004             1173-1175   ///
      int    DXCCSR_END005             1176-1178   ///
      int    DXCCSR_END006             1179-1181   ///
      int    DXCCSR_END007             1182-1184   ///
      int    DXCCSR_END008             1185-1187   ///
      int    DXCCSR_END009             1188-1190   ///
      int    DXCCSR_END010             1191-1193   ///
      int    DXCCSR_END011             1194-1196   ///
      int    DXCCSR_END012             1197-1199   ///
      int    DXCCSR_END013             1200-1202   ///
      int    DXCCSR_END014             1203-1205   ///
      int    DXCCSR_END015             1206-1208   ///
      int    DXCCSR_END016             1209-1211   ///
      int    DXCCSR_END017             1212-1214   ///
      int    DXCCSR_EXT001             1215-1217   ///
      int    DXCCSR_EXT002             1218-1220   ///
      int    DXCCSR_EXT003             1221-1223   ///
      int    DXCCSR_EXT004             1224-1226   ///
      int    DXCCSR_EXT005             1227-1229   ///
      int    DXCCSR_EXT006             1230-1232   ///
      int    DXCCSR_EXT007             1233-1235   ///
      int    DXCCSR_EXT008             1236-1238   ///
      int    DXCCSR_EXT009             1239-1241   ///
      int    DXCCSR_EXT010             1242-1244   ///
      int    DXCCSR_EXT011             1245-1247   ///
      int    DXCCSR_EXT012             1248-1250   ///
      int    DXCCSR_EXT013             1251-1253   ///
      int    DXCCSR_EXT014             1254-1256   ///
      int    DXCCSR_EXT015             1257-1259   ///
      int    DXCCSR_EXT016             1260-1262   ///
      int    DXCCSR_EXT017             1263-1265   ///
      int    DXCCSR_EXT018             1266-1268   ///
      int    DXCCSR_EXT019             1269-1271   ///
      int    DXCCSR_EXT020             1272-1274   ///
      int    DXCCSR_EXT021             1275-1277   ///
      int    DXCCSR_EXT022             1278-1280   ///
      int    DXCCSR_EXT023             1281-1283   ///
      int    DXCCSR_EXT024             1284-1286   ///
      int    DXCCSR_EXT025             1287-1289   ///
      int    DXCCSR_EXT026             1290-1292   ///
      int    DXCCSR_EXT027             1293-1295   ///
      int    DXCCSR_EXT028             1296-1298   ///
      int    DXCCSR_EXT029             1299-1301   ///
      int    DXCCSR_EXT030             1302-1304   ///
      int    DXCCSR_EYE001             1305-1307   ///
      int    DXCCSR_EYE002             1308-1310   ///
      int    DXCCSR_EYE003             1311-1313   ///
      int    DXCCSR_EYE004             1314-1316   ///
      int    DXCCSR_EYE005             1317-1319   ///
      int    DXCCSR_EYE006             1320-1322   ///
      int    DXCCSR_EYE007             1323-1325   ///
      int    DXCCSR_EYE008             1326-1328   ///
      int    DXCCSR_EYE009             1329-1331   ///
      int    DXCCSR_EYE010             1332-1334   ///
      int    DXCCSR_EYE011             1335-1337   ///
      int    DXCCSR_EYE012             1338-1340   ///
      int    DXCCSR_FAC001             1341-1343   ///
      int    DXCCSR_FAC002             1344-1346   ///
      int    DXCCSR_FAC003             1347-1349   ///
      int    DXCCSR_FAC004             1350-1352   ///
      int    DXCCSR_FAC005             1353-1355   ///
      int    DXCCSR_FAC006             1356-1358   ///
      int    DXCCSR_FAC007             1359-1361   ///
      int    DXCCSR_FAC008             1362-1364   ///
      int    DXCCSR_FAC009             1365-1367   ///
      int    DXCCSR_FAC010             1368-1370   ///
      int    DXCCSR_FAC011             1371-1373   ///
      int    DXCCSR_FAC012             1374-1376   ///
      int    DXCCSR_FAC013             1377-1379   ///
      int    DXCCSR_FAC014             1380-1382   ///
      int    DXCCSR_FAC015             1383-1385   ///
      int    DXCCSR_FAC016             1386-1388   ///
      int    DXCCSR_FAC017             1389-1391   ///
      int    DXCCSR_FAC018             1392-1394   ///
      int    DXCCSR_FAC019             1395-1397   ///
      int    DXCCSR_FAC020             1398-1400   ///
      int    DXCCSR_FAC021             1401-1403   ///
      int    DXCCSR_FAC022             1404-1406   ///
      int    DXCCSR_FAC023             1407-1409   ///
      int    DXCCSR_FAC024             1410-1412   ///
      int    DXCCSR_FAC025             1413-1415   ///
      int    DXCCSR_GEN001             1416-1418   ///
      int    DXCCSR_GEN002             1419-1421   ///
      int    DXCCSR_GEN003             1422-1424   ///
      int    DXCCSR_GEN004             1425-1427   ///
      int    DXCCSR_GEN005             1428-1430   ///
      int    DXCCSR_GEN006             1431-1433   ///
      int    DXCCSR_GEN007             1434-1436   ///
      int    DXCCSR_GEN008             1437-1439   ///
      int    DXCCSR_GEN009             1440-1442   ///
      int    DXCCSR_GEN010             1443-1445   ///
      int    DXCCSR_GEN011             1446-1448   ///
      int    DXCCSR_GEN012             1449-1451   ///
      int    DXCCSR_GEN013             1452-1454   ///
      int    DXCCSR_GEN014             1455-1457   ///
      int    DXCCSR_GEN015             1458-1460   ///
      int    DXCCSR_GEN016             1461-1463   ///
      int    DXCCSR_GEN017             1464-1466   ///
      int    DXCCSR_GEN018             1467-1469   ///
      int    DXCCSR_GEN019             1470-1472   ///
      int    DXCCSR_GEN020             1473-1475   ///
      int    DXCCSR_GEN021             1476-1478   ///
      int    DXCCSR_GEN022             1479-1481   ///
      int    DXCCSR_GEN023             1482-1484   ///
      int    DXCCSR_GEN024             1485-1487   ///
      int    DXCCSR_GEN025             1488-1490   ///
      int    DXCCSR_GEN026             1491-1493   ///
      int    DXCCSR_INF001             1494-1496   ///
      int    DXCCSR_INF002             1497-1499   ///
      int    DXCCSR_INF003             1500-1502   ///
      int    DXCCSR_INF004             1503-1505   ///
      int    DXCCSR_INF005             1506-1508   ///
      int    DXCCSR_INF006             1509-1511   ///
      int    DXCCSR_INF007             1512-1514   ///
      int    DXCCSR_INF008             1515-1517   ///
      int    DXCCSR_INF009             1518-1520   ///
      int    DXCCSR_INF010             1521-1523   ///
      int    DXCCSR_INF011             1524-1526   ///
      int    DXCCSR_INF012             1527-1529   ///
      int    DXCCSR_INJ001             1530-1532   ///
      int    DXCCSR_INJ002             1533-1535   ///
      int    DXCCSR_INJ003             1536-1538   ///
      int    DXCCSR_INJ004             1539-1541   ///
      int    DXCCSR_INJ005             1542-1544   ///
      int    DXCCSR_INJ006             1545-1547   ///
      int    DXCCSR_INJ007             1548-1550   ///
      int    DXCCSR_INJ008             1551-1553   ///
      int    DXCCSR_INJ009             1554-1556   ///
      int    DXCCSR_INJ010             1557-1559   ///
      int    DXCCSR_INJ011             1560-1562   ///
      int    DXCCSR_INJ012             1563-1565   ///
      int    DXCCSR_INJ013             1566-1568   ///
      int    DXCCSR_INJ014             1569-1571   ///
      int    DXCCSR_INJ015             1572-1574   ///
      int    DXCCSR_INJ016             1575-1577   ///
      int    DXCCSR_INJ017             1578-1580   ///
      int    DXCCSR_INJ018             1581-1583   ///
      int    DXCCSR_INJ019             1584-1586   ///
      int    DXCCSR_INJ020             1587-1589   ///
      int    DXCCSR_INJ021             1590-1592   ///
      int    DXCCSR_INJ022             1593-1595   ///
      int    DXCCSR_INJ023             1596-1598   ///
      int    DXCCSR_INJ024             1599-1601   ///
      int    DXCCSR_INJ025             1602-1604   ///
      int    DXCCSR_INJ026             1605-1607   ///
      int    DXCCSR_INJ027             1608-1610   ///
      int    DXCCSR_INJ028             1611-1613   ///
      int    DXCCSR_INJ029             1614-1616   ///
      int    DXCCSR_INJ030             1617-1619   ///
      int    DXCCSR_INJ031             1620-1622   ///
      int    DXCCSR_INJ032             1623-1625   ///
      int    DXCCSR_INJ033             1626-1628   ///
      int    DXCCSR_INJ034             1629-1631   ///
      int    DXCCSR_INJ035             1632-1634   ///
      int    DXCCSR_INJ036             1635-1637   ///
      int    DXCCSR_INJ037             1638-1640   ///
      int    DXCCSR_INJ038             1641-1643   ///
      int    DXCCSR_INJ039             1644-1646   ///
      int    DXCCSR_INJ040             1647-1649   ///
      int    DXCCSR_INJ041             1650-1652   ///
      int    DXCCSR_INJ042             1653-1655   ///
      int    DXCCSR_INJ043             1656-1658   ///
      int    DXCCSR_INJ044             1659-1661   ///
      int    DXCCSR_INJ045             1662-1664   ///
      int    DXCCSR_INJ046             1665-1667   ///
      int    DXCCSR_INJ047             1668-1670   ///
      int    DXCCSR_INJ048             1671-1673   ///
      int    DXCCSR_INJ049             1674-1676   ///
      int    DXCCSR_INJ050             1677-1679   ///
      int    DXCCSR_INJ051             1680-1682   ///
      int    DXCCSR_INJ052             1683-1685   ///
      int    DXCCSR_INJ053             1686-1688   ///
      int    DXCCSR_INJ054             1689-1691   ///
      int    DXCCSR_INJ055             1692-1694   ///
      int    DXCCSR_INJ056             1695-1697   ///
      int    DXCCSR_INJ057             1698-1700   ///
      int    DXCCSR_INJ058             1701-1703   ///
      int    DXCCSR_INJ059             1704-1706   ///
      int    DXCCSR_INJ060             1707-1709   ///
      int    DXCCSR_INJ061             1710-1712   ///
      int    DXCCSR_INJ062             1713-1715   ///
      int    DXCCSR_INJ063             1716-1718   ///
      int    DXCCSR_INJ064             1719-1721   ///
      int    DXCCSR_INJ065             1722-1724   ///
      int    DXCCSR_INJ066             1725-1727   ///
      int    DXCCSR_INJ067             1728-1730   ///
      int    DXCCSR_INJ068             1731-1733   ///
      int    DXCCSR_INJ069             1734-1736   ///
      int    DXCCSR_INJ070             1737-1739   ///
      int    DXCCSR_INJ071             1740-1742   ///
      int    DXCCSR_INJ072             1743-1745   ///
      int    DXCCSR_INJ073             1746-1748   ///
      int    DXCCSR_INJ074             1749-1751   ///
      int    DXCCSR_INJ075             1752-1754   ///
      int    DXCCSR_INJ076             1755-1757   ///
      int    DXCCSR_MAL001             1758-1760   ///
      int    DXCCSR_MAL002             1761-1763   ///
      int    DXCCSR_MAL003             1764-1766   ///
      int    DXCCSR_MAL004             1767-1769   ///
      int    DXCCSR_MAL005             1770-1772   ///
      int    DXCCSR_MAL006             1773-1775   ///
      int    DXCCSR_MAL007             1776-1778   ///
      int    DXCCSR_MAL008             1779-1781   ///
      int    DXCCSR_MAL009             1782-1784   ///
      int    DXCCSR_MAL010             1785-1787   ///
      int    DXCCSR_MBD001             1788-1790   ///
      int    DXCCSR_MBD002             1791-1793   ///
      int    DXCCSR_MBD003             1794-1796   ///
      int    DXCCSR_MBD004             1797-1799   ///
      int    DXCCSR_MBD005             1800-1802   ///
      int    DXCCSR_MBD006             1803-1805   ///
      int    DXCCSR_MBD007             1806-1808   ///
      int    DXCCSR_MBD008             1809-1811   ///
      int    DXCCSR_MBD009             1812-1814   ///
      int    DXCCSR_MBD010             1815-1817   ///
      int    DXCCSR_MBD011             1818-1820   ///
      int    DXCCSR_MBD012             1821-1823   ///
      int    DXCCSR_MBD013             1824-1826   ///
      int    DXCCSR_MBD014             1827-1829   ///
      int    DXCCSR_MBD017             1830-1832   ///
      int    DXCCSR_MBD018             1833-1835   ///
      int    DXCCSR_MBD019             1836-1838   ///
      int    DXCCSR_MBD020             1839-1841   ///
      int    DXCCSR_MBD021             1842-1844   ///
      int    DXCCSR_MBD022             1845-1847   ///
      int    DXCCSR_MBD023             1848-1850   ///
      int    DXCCSR_MBD024             1851-1853   ///
      int    DXCCSR_MBD025             1854-1856   ///
      int    DXCCSR_MBD026             1857-1859   ///
      int    DXCCSR_MBD027             1860-1862   ///
      int    DXCCSR_MBD028             1863-1865   ///
      int    DXCCSR_MBD029             1866-1868   ///
      int    DXCCSR_MBD030             1869-1871   ///
      int    DXCCSR_MBD031             1872-1874   ///
      int    DXCCSR_MBD032             1875-1877   ///
      int    DXCCSR_MBD033             1878-1880   ///
      int    DXCCSR_MBD034             1881-1883   ///
      int    DXCCSR_MUS001             1884-1886   ///
      int    DXCCSR_MUS002             1887-1889   ///
      int    DXCCSR_MUS003             1890-1892   ///
      int    DXCCSR_MUS004             1893-1895   ///
      int    DXCCSR_MUS005             1896-1898   ///
      int    DXCCSR_MUS006             1899-1901   ///
      int    DXCCSR_MUS007             1902-1904   ///
      int    DXCCSR_MUS008             1905-1907   ///
      int    DXCCSR_MUS009             1908-1910   ///
      int    DXCCSR_MUS010             1911-1913   ///
      int    DXCCSR_MUS011             1914-1916   ///
      int    DXCCSR_MUS012             1917-1919   ///
      int    DXCCSR_MUS013             1920-1922   ///
      int    DXCCSR_MUS014             1923-1925   ///
      int    DXCCSR_MUS015             1926-1928   ///
      int    DXCCSR_MUS016             1929-1931   ///
      int    DXCCSR_MUS017             1932-1934   ///
      int    DXCCSR_MUS018             1935-1937   ///
      int    DXCCSR_MUS019             1938-1940   ///
      int    DXCCSR_MUS020             1941-1943   ///
      int    DXCCSR_MUS021             1944-1946   ///
      int    DXCCSR_MUS022             1947-1949   ///
      int    DXCCSR_MUS023             1950-1952   ///
      int    DXCCSR_MUS024             1953-1955   ///
      int    DXCCSR_MUS025             1956-1958   ///
      int    DXCCSR_MUS026             1959-1961   ///
      int    DXCCSR_MUS027             1962-1964   ///
      int    DXCCSR_MUS028             1965-1967   ///
      int    DXCCSR_MUS029             1968-1970   ///
      int    DXCCSR_MUS030             1971-1973   ///
      int    DXCCSR_MUS031             1974-1976   ///
      int    DXCCSR_MUS032             1977-1979   ///
      int    DXCCSR_MUS033             1980-1982   ///
      int    DXCCSR_MUS034             1983-1985   ///
      int    DXCCSR_MUS035             1986-1988   ///
      int    DXCCSR_MUS036             1989-1991   ///
      int    DXCCSR_MUS037             1992-1994   ///
      int    DXCCSR_MUS038             1995-1997   ///
      int    DXCCSR_NEO001             1998-2000   ///
      int    DXCCSR_NEO002             2001-2003   ///
      int    DXCCSR_NEO003             2004-2006   ///
      int    DXCCSR_NEO004             2007-2009   ///
      int    DXCCSR_NEO005             2010-2012   ///
      int    DXCCSR_NEO006             2013-2015   ///
      int    DXCCSR_NEO007             2016-2018   ///
      int    DXCCSR_NEO008             2019-2021   ///
      int    DXCCSR_NEO009             2022-2024   ///
      int    DXCCSR_NEO010             2025-2027   ///
      int    DXCCSR_NEO011             2028-2030   ///
      int    DXCCSR_NEO012             2031-2033   ///
      int    DXCCSR_NEO013             2034-2036   ///
      int    DXCCSR_NEO014             2037-2039   ///
      int    DXCCSR_NEO015             2040-2042   ///
      int    DXCCSR_NEO016             2043-2045   ///
      int    DXCCSR_NEO017             2046-2048   ///
      int    DXCCSR_NEO018             2049-2051   ///
      int    DXCCSR_NEO019             2052-2054   ///
      int    DXCCSR_NEO020             2055-2057   ///
      int    DXCCSR_NEO021             2058-2060   ///
      int    DXCCSR_NEO022             2061-2063   ///
      int    DXCCSR_NEO023             2064-2066   ///
      int    DXCCSR_NEO024             2067-2069   ///
      int    DXCCSR_NEO025             2070-2072   ///
      int    DXCCSR_NEO026             2073-2075   ///
      int    DXCCSR_NEO027             2076-2078   ///
      int    DXCCSR_NEO028             2079-2081   ///
      int    DXCCSR_NEO029             2082-2084   ///
      int    DXCCSR_NEO030             2085-2087   ///
      int    DXCCSR_NEO031             2088-2090   ///
      int    DXCCSR_NEO032             2091-2093   ///
      int    DXCCSR_NEO033             2094-2096   ///
      int    DXCCSR_NEO034             2097-2099   ///
      int    DXCCSR_NEO035             2100-2102   ///
      int    DXCCSR_NEO036             2103-2105   ///
      int    DXCCSR_NEO037             2106-2108   ///
      int    DXCCSR_NEO038             2109-2111   ///
      int    DXCCSR_NEO039             2112-2114   ///
      int    DXCCSR_NEO040             2115-2117   ///
      int    DXCCSR_NEO041             2118-2120   ///
      int    DXCCSR_NEO042             2121-2123   ///
      int    DXCCSR_NEO043             2124-2126   ///
      int    DXCCSR_NEO044             2127-2129   ///
      int    DXCCSR_NEO045             2130-2132   ///
      int    DXCCSR_NEO046             2133-2135   ///
      int    DXCCSR_NEO047             2136-2138   ///
      int    DXCCSR_NEO048             2139-2141   ///
      int    DXCCSR_NEO049             2142-2144   ///
      int    DXCCSR_NEO050             2145-2147   ///
      int    DXCCSR_NEO051             2148-2150   ///
      int    DXCCSR_NEO052             2151-2153   ///
      int    DXCCSR_NEO053             2154-2156   ///
      int    DXCCSR_NEO054             2157-2159   ///
      int    DXCCSR_NEO055             2160-2162   ///
      int    DXCCSR_NEO056             2163-2165   ///
      int    DXCCSR_NEO057             2166-2168   ///
      int    DXCCSR_NEO058             2169-2171   ///
      int    DXCCSR_NEO059             2172-2174   ///
      int    DXCCSR_NEO060             2175-2177   ///
      int    DXCCSR_NEO061             2178-2180   ///
      int    DXCCSR_NEO062             2181-2183   ///
      int    DXCCSR_NEO063             2184-2186   ///
      int    DXCCSR_NEO064             2187-2189   ///
      int    DXCCSR_NEO065             2190-2192   ///
      int    DXCCSR_NEO066             2193-2195   ///
      int    DXCCSR_NEO067             2196-2198   ///
      int    DXCCSR_NEO068             2199-2201   ///
      int    DXCCSR_NEO069             2202-2204   ///
      int    DXCCSR_NEO070             2205-2207   ///
      int    DXCCSR_NEO071             2208-2210   ///
      int    DXCCSR_NEO072             2211-2213   ///
      int    DXCCSR_NEO073             2214-2216   ///
      int    DXCCSR_NEO074             2217-2219   ///
      int    DXCCSR_NVS001             2220-2222   ///
      int    DXCCSR_NVS002             2223-2225   ///
      int    DXCCSR_NVS003             2226-2228   ///
      int    DXCCSR_NVS004             2229-2231   ///
      int    DXCCSR_NVS005             2232-2234   ///
      int    DXCCSR_NVS006             2235-2237   ///
      int    DXCCSR_NVS007             2238-2240   ///
      int    DXCCSR_NVS008             2241-2243   ///
      int    DXCCSR_NVS009             2244-2246   ///
      int    DXCCSR_NVS010             2247-2249   ///
      int    DXCCSR_NVS011             2250-2252   ///
      int    DXCCSR_NVS012             2253-2255   ///
      int    DXCCSR_NVS013             2256-2258   ///
      int    DXCCSR_NVS014             2259-2261   ///
      int    DXCCSR_NVS015             2262-2264   ///
      int    DXCCSR_NVS016             2265-2267   ///
      int    DXCCSR_NVS017             2268-2270   ///
      int    DXCCSR_NVS018             2271-2273   ///
      int    DXCCSR_NVS019             2274-2276   ///
      int    DXCCSR_NVS020             2277-2279   ///
      int    DXCCSR_NVS021             2280-2282   ///
      int    DXCCSR_NVS022             2283-2285   ///
      int    DXCCSR_PNL001             2286-2288   ///
      int    DXCCSR_PNL002             2289-2291   ///
      int    DXCCSR_PNL003             2292-2294   ///
      int    DXCCSR_PNL004             2295-2297   ///
      int    DXCCSR_PNL005             2298-2300   ///
      int    DXCCSR_PNL006             2301-2303   ///
      int    DXCCSR_PNL007             2304-2306   ///
      int    DXCCSR_PNL008             2307-2309   ///
      int    DXCCSR_PNL009             2310-2312   ///
      int    DXCCSR_PNL010             2313-2315   ///
      int    DXCCSR_PNL011             2316-2318   ///
      int    DXCCSR_PNL012             2319-2321   ///
      int    DXCCSR_PNL013             2322-2324   ///
      int    DXCCSR_PNL014             2325-2327   ///
      int    DXCCSR_PNL015             2328-2330   ///
      int    DXCCSR_PRG001             2331-2333   ///
      int    DXCCSR_PRG002             2334-2336   ///
      int    DXCCSR_PRG003             2337-2339   ///
      int    DXCCSR_PRG004             2340-2342   ///
      int    DXCCSR_PRG005             2343-2345   ///
      int    DXCCSR_PRG006             2346-2348   ///
      int    DXCCSR_PRG007             2349-2351   ///
      int    DXCCSR_PRG008             2352-2354   ///
      int    DXCCSR_PRG009             2355-2357   ///
      int    DXCCSR_PRG010             2358-2360   ///
      int    DXCCSR_PRG011             2361-2363   ///
      int    DXCCSR_PRG012             2364-2366   ///
      int    DXCCSR_PRG013             2367-2369   ///
      int    DXCCSR_PRG014             2370-2372   ///
      int    DXCCSR_PRG015             2373-2375   ///
      int    DXCCSR_PRG016             2376-2378   ///
      int    DXCCSR_PRG017             2379-2381   ///
      int    DXCCSR_PRG018             2382-2384   ///
      int    DXCCSR_PRG019             2385-2387   ///
      int    DXCCSR_PRG020             2388-2390   ///
      int    DXCCSR_PRG021             2391-2393   ///
      int    DXCCSR_PRG022             2394-2396   ///
      int    DXCCSR_PRG023             2397-2399   ///
      int    DXCCSR_PRG024             2400-2402   ///
      int    DXCCSR_PRG025             2403-2405   ///
      int    DXCCSR_PRG026             2406-2408   ///
      int    DXCCSR_PRG027             2409-2411   ///
      int    DXCCSR_PRG028             2412-2414   ///
      int    DXCCSR_PRG029             2415-2417   ///
      int    DXCCSR_PRG030             2418-2420   ///
      int    DXCCSR_RSP001             2421-2423   ///
      int    DXCCSR_RSP002             2424-2426   ///
      int    DXCCSR_RSP003             2427-2429   ///
      int    DXCCSR_RSP004             2430-2432   ///
      int    DXCCSR_RSP005             2433-2435   ///
      int    DXCCSR_RSP006             2436-2438   ///
      int    DXCCSR_RSP007             2439-2441   ///
      int    DXCCSR_RSP008             2442-2444   ///
      int    DXCCSR_RSP009             2445-2447   ///
      int    DXCCSR_RSP010             2448-2450   ///
      int    DXCCSR_RSP011             2451-2453   ///
      int    DXCCSR_RSP012             2454-2456   ///
      int    DXCCSR_RSP013             2457-2459   ///
      int    DXCCSR_RSP014             2460-2462   ///
      int    DXCCSR_RSP015             2463-2465   ///
      int    DXCCSR_RSP016             2466-2468   ///
      int    DXCCSR_RSP017             2469-2471   ///
      int    DXCCSR_SKN001             2472-2474   ///
      int    DXCCSR_SKN002             2475-2477   ///
      int    DXCCSR_SKN003             2478-2480   ///
      int    DXCCSR_SKN004             2481-2483   ///
      int    DXCCSR_SKN005             2484-2486   ///
      int    DXCCSR_SKN006             2487-2489   ///
      int    DXCCSR_SKN007             2490-2492   ///
      int    DXCCSR_SYM001             2493-2495   ///
      int    DXCCSR_SYM002             2496-2498   ///
      int    DXCCSR_SYM003             2499-2501   ///
      int    DXCCSR_SYM004             2502-2504   ///
      int    DXCCSR_SYM005             2505-2507   ///
      int    DXCCSR_SYM006             2508-2510   ///
      int    DXCCSR_SYM007             2511-2513   ///
      int    DXCCSR_SYM008             2514-2516   ///
      int    DXCCSR_SYM009             2517-2519   ///
      int    DXCCSR_SYM010             2520-2522   ///
      int    DXCCSR_SYM011             2523-2525   ///
      int    DXCCSR_SYM012             2526-2528   ///
      int    DXCCSR_SYM013             2529-2531   ///
      int    DXCCSR_SYM014             2532-2534   ///
      int    DXCCSR_SYM015             2535-2537   ///
      int    DXCCSR_SYM016             2538-2540   ///
      int    DXCCSR_SYM017             2541-2543   ///
      str    DXCCSR_VERSION            2544-2549   ///
      int    PRCCSR_ADM001             2550-2552   ///
      int    PRCCSR_ADM002             2553-2555   ///
      int    PRCCSR_ADM003             2556-2558   ///
      int    PRCCSR_ADM004             2559-2561   ///
      int    PRCCSR_ADM005             2562-2564   ///
      int    PRCCSR_ADM006             2565-2567   ///
      int    PRCCSR_ADM007             2568-2570   ///
      int    PRCCSR_ADM008             2571-2573   ///
      int    PRCCSR_ADM009             2574-2576   ///
      int    PRCCSR_ADM010             2577-2579   ///
      int    PRCCSR_ADM011             2580-2582   ///
      int    PRCCSR_ADM012             2583-2585   ///
      int    PRCCSR_ADM013             2586-2588   ///
      int    PRCCSR_ADM014             2589-2591   ///
      int    PRCCSR_ADM015             2592-2594   ///
      int    PRCCSR_ADM016             2595-2597   ///
      int    PRCCSR_ADM017             2598-2600   ///
      int    PRCCSR_ADM018             2601-2603   ///
      int    PRCCSR_ADM019             2604-2606   ///
      int    PRCCSR_ADM020             2607-2609   ///
      int    PRCCSR_ADM021             2610-2612   ///
      int    PRCCSR_ADM022             2613-2615   ///
      int    PRCCSR_CAR001             2616-2618   ///
      int    PRCCSR_CAR002             2619-2621   ///
      int    PRCCSR_CAR003             2622-2624   ///
      int    PRCCSR_CAR004             2625-2627   ///
      int    PRCCSR_CAR005             2628-2630   ///
      int    PRCCSR_CAR006             2631-2633   ///
      int    PRCCSR_CAR007             2634-2636   ///
      int    PRCCSR_CAR008             2637-2639   ///
      int    PRCCSR_CAR009             2640-2642   ///
      int    PRCCSR_CAR010             2643-2645   ///
      int    PRCCSR_CAR011             2646-2648   ///
      int    PRCCSR_CAR012             2649-2651   ///
      int    PRCCSR_CAR013             2652-2654   ///
      int    PRCCSR_CAR014             2655-2657   ///
      int    PRCCSR_CAR015             2658-2660   ///
      int    PRCCSR_CAR016             2661-2663   ///
      int    PRCCSR_CAR017             2664-2666   ///
      int    PRCCSR_CAR018             2667-2669   ///
      int    PRCCSR_CAR019             2670-2672   ///
      int    PRCCSR_CAR020             2673-2675   ///
      int    PRCCSR_CAR021             2676-2678   ///
      int    PRCCSR_CAR022             2679-2681   ///
      int    PRCCSR_CAR023             2682-2684   ///
      int    PRCCSR_CAR024             2685-2687   ///
      int    PRCCSR_CAR025             2688-2690   ///
      int    PRCCSR_CAR026             2691-2693   ///
      int    PRCCSR_CAR027             2694-2696   ///
      int    PRCCSR_CAR028             2697-2699   ///
      int    PRCCSR_CAR029             2700-2702   ///
      int    PRCCSR_CHP001             2703-2705   ///
      int    PRCCSR_CNS001             2706-2708   ///
      int    PRCCSR_CNS002             2709-2711   ///
      int    PRCCSR_CNS003             2712-2714   ///
      int    PRCCSR_CNS004             2715-2717   ///
      int    PRCCSR_CNS005             2718-2720   ///
      int    PRCCSR_CNS006             2721-2723   ///
      int    PRCCSR_CNS007             2724-2726   ///
      int    PRCCSR_CNS008             2727-2729   ///
      int    PRCCSR_CNS009             2730-2732   ///
      int    PRCCSR_CNS010             2733-2735   ///
      int    PRCCSR_CNS011             2736-2738   ///
      int    PRCCSR_CNS012             2739-2741   ///
      int    PRCCSR_CNS013             2742-2744   ///
      int    PRCCSR_CNS014             2745-2747   ///
      int    PRCCSR_ENP001             2748-2750   ///
      int    PRCCSR_ENP002             2751-2753   ///
      int    PRCCSR_ENP003             2754-2756   ///
      int    PRCCSR_ENP004             2757-2759   ///
      int    PRCCSR_ENP005             2760-2762   ///
      int    PRCCSR_ENP006             2763-2765   ///
      int    PRCCSR_ENT001             2766-2768   ///
      int    PRCCSR_ENT002             2769-2771   ///
      int    PRCCSR_ENT003             2772-2774   ///
      int    PRCCSR_ENT004             2775-2777   ///
      int    PRCCSR_ENT005             2778-2780   ///
      int    PRCCSR_ENT006             2781-2783   ///
      int    PRCCSR_ENT007             2784-2786   ///
      int    PRCCSR_ENT008             2787-2789   ///
      int    PRCCSR_ENT009             2790-2792   ///
      int    PRCCSR_ENT010             2793-2795   ///
      int    PRCCSR_ENT011             2796-2798   ///
      int    PRCCSR_ENT012             2799-2801   ///
      int    PRCCSR_ENT013             2802-2804   ///
      int    PRCCSR_ENT014             2805-2807   ///
      int    PRCCSR_ENT015             2808-2810   ///
      int    PRCCSR_ENT016             2811-2813   ///
      int    PRCCSR_ENT017             2814-2816   ///
      int    PRCCSR_ESA001             2817-2819   ///
      int    PRCCSR_ESA002             2820-2822   ///
      int    PRCCSR_ESA003             2823-2825   ///
      int    PRCCSR_ESA004             2826-2828   ///
      int    PRCCSR_ESA005             2829-2831   ///
      int    PRCCSR_ESA006             2832-2834   ///
      int    PRCCSR_ESA007             2835-2837   ///
      int    PRCCSR_ESA008             2838-2840   ///
      int    PRCCSR_ESA009             2841-2843   ///
      int    PRCCSR_ESA010             2844-2846   ///
      int    PRCCSR_ESA011             2847-2849   ///
      int    PRCCSR_EST001             2850-2852   ///
      int    PRCCSR_EST002             2853-2855   ///
      int    PRCCSR_EST003             2856-2858   ///
      int    PRCCSR_EST004             2859-2861   ///
      int    PRCCSR_EST005             2862-2864   ///
      int    PRCCSR_EYP001             2865-2867   ///
      int    PRCCSR_EYP002             2868-2870   ///
      int    PRCCSR_FRS001             2871-2873   ///
      int    PRCCSR_FRS002             2874-2876   ///
      int    PRCCSR_FRS003             2877-2879   ///
      int    PRCCSR_FRS004             2880-2882   ///
      int    PRCCSR_FRS005             2883-2885   ///
      int    PRCCSR_FRS006             2886-2888   ///
      int    PRCCSR_FRS007             2889-2891   ///
      int    PRCCSR_FRS008             2892-2894   ///
      int    PRCCSR_FRS009             2895-2897   ///
      int    PRCCSR_FRS010             2898-2900   ///
      int    PRCCSR_FRS011             2901-2903   ///
      int    PRCCSR_FRS012             2904-2906   ///
      int    PRCCSR_FRS013             2907-2909   ///
      int    PRCCSR_FRS014             2910-2912   ///
      int    PRCCSR_FRS015             2913-2915   ///
      int    PRCCSR_GIS001             2916-2918   ///
      int    PRCCSR_GIS002             2919-2921   ///
      int    PRCCSR_GIS003             2922-2924   ///
      int    PRCCSR_GIS004             2925-2927   ///
      int    PRCCSR_GIS005             2928-2930   ///
      int    PRCCSR_GIS006             2931-2933   ///
      int    PRCCSR_GIS007             2934-2936   ///
      int    PRCCSR_GIS008             2937-2939   ///
      int    PRCCSR_GIS009             2940-2942   ///
      int    PRCCSR_GIS010             2943-2945   ///
      int    PRCCSR_GIS011             2946-2948   ///
      int    PRCCSR_GIS012             2949-2951   ///
      int    PRCCSR_GIS013             2952-2954   ///
      int    PRCCSR_GIS014             2955-2957   ///
      int    PRCCSR_GIS015             2958-2960   ///
      int    PRCCSR_GIS016             2961-2963   ///
      int    PRCCSR_GIS017             2964-2966   ///
      int    PRCCSR_GIS018             2967-2969   ///
      int    PRCCSR_GIS019             2970-2972   ///
      int    PRCCSR_GIS020             2973-2975   ///
      int    PRCCSR_GIS021             2976-2978   ///
      int    PRCCSR_GIS022             2979-2981   ///
      int    PRCCSR_GIS023             2982-2984   ///
      int    PRCCSR_GIS024             2985-2987   ///
      int    PRCCSR_GIS025             2988-2990   ///
      int    PRCCSR_GIS026             2991-2993   ///
      int    PRCCSR_GIS027             2994-2996   ///
      int    PRCCSR_GIS028             2997-2999   ///
      int    PRCCSR_GIS029             3000-3002   ///
      int    PRCCSR_GNR001             3003-3005   ///
      int    PRCCSR_GNR002             3006-3008   ///
      int    PRCCSR_GNR003             3009-3011   ///
      int    PRCCSR_GNR004             3012-3014   ///
      int    PRCCSR_GNR005             3015-3017   ///
      int    PRCCSR_GNR006             3018-3020   ///
      int    PRCCSR_GNR007             3021-3023   ///
      int    PRCCSR_GNR008             3024-3026   ///
      int    PRCCSR_GNR009             3027-3029   ///
      int    PRCCSR_GNR010             3030-3032   ///
      int    PRCCSR_HEP001             3033-3035   ///
      int    PRCCSR_HEP002             3036-3038   ///
      int    PRCCSR_HEP003             3039-3041   ///
      int    PRCCSR_HEP004             3042-3044   ///
      int    PRCCSR_HEP005             3045-3047   ///
      int    PRCCSR_HEP006             3048-3050   ///
      int    PRCCSR_HEP007             3051-3053   ///
      int    PRCCSR_HEP008             3054-3056   ///
      int    PRCCSR_HEP009             3057-3059   ///
      int    PRCCSR_HEP010             3060-3062   ///
      int    PRCCSR_HEP011             3063-3065   ///
      int    PRCCSR_HEP012             3066-3068   ///
      int    PRCCSR_HEP013             3069-3071   ///
      int    PRCCSR_IMG001             3072-3074   ///
      int    PRCCSR_IMG002             3075-3077   ///
      int    PRCCSR_IMG003             3078-3080   ///
      int    PRCCSR_IMG004             3081-3083   ///
      int    PRCCSR_IMG005             3084-3086   ///
      int    PRCCSR_IMG006             3087-3089   ///
      int    PRCCSR_IMG007             3090-3092   ///
      int    PRCCSR_IMG008             3093-3095   ///
      int    PRCCSR_IMG009             3096-3098   ///
      int    PRCCSR_IMG010             3099-3101   ///
      int    PRCCSR_LYM001             3102-3104   ///
      int    PRCCSR_LYM002             3105-3107   ///
      int    PRCCSR_LYM003             3108-3110   ///
      int    PRCCSR_LYM004             3111-3113   ///
      int    PRCCSR_LYM005             3114-3116   ///
      int    PRCCSR_LYM006             3117-3119   ///
      int    PRCCSR_LYM007             3120-3122   ///
      int    PRCCSR_LYM008             3123-3125   ///
      int    PRCCSR_LYM009             3126-3128   ///
      int    PRCCSR_LYM010             3129-3131   ///
      int    PRCCSR_LYM011             3132-3134   ///
      int    PRCCSR_MAM001             3135-3137   ///
      int    PRCCSR_MAM002             3138-3140   ///
      int    PRCCSR_MAM003             3141-3143   ///
      int    PRCCSR_MAM004             3144-3146   ///
      int    PRCCSR_MAM005             3147-3149   ///
      int    PRCCSR_MAM006             3150-3152   ///
      int    PRCCSR_MAM007             3153-3155   ///
      int    PRCCSR_MAM008             3156-3158   ///
      int    PRCCSR_MAM009             3159-3161   ///
      int    PRCCSR_MAM010             3162-3164   ///
      int    PRCCSR_MAM011             3165-3167   ///
      int    PRCCSR_MAM012             3168-3170   ///
      int    PRCCSR_MAM013             3171-3173   ///
      int    PRCCSR_MAM014             3174-3176   ///
      int    PRCCSR_MAM015             3177-3179   ///
      int    PRCCSR_MHT001             3180-3182   ///
      int    PRCCSR_MHT002             3183-3185   ///
      int    PRCCSR_MHT003             3186-3188   ///
      int    PRCCSR_MHT004             3189-3191   ///
      int    PRCCSR_MHT005             3192-3194   ///
      int    PRCCSR_MRS001             3195-3197   ///
      int    PRCCSR_MRS002             3198-3200   ///
      int    PRCCSR_MRS003             3201-3203   ///
      int    PRCCSR_MRS004             3204-3206   ///
      int    PRCCSR_MRS005             3207-3209   ///
      int    PRCCSR_MRS006             3210-3212   ///
      int    PRCCSR_MRS007             3213-3215   ///
      int    PRCCSR_MST001             3216-3218   ///
      int    PRCCSR_MST002             3219-3221   ///
      int    PRCCSR_MST003             3222-3224   ///
      int    PRCCSR_MST004             3225-3227   ///
      int    PRCCSR_MST005             3228-3230   ///
      int    PRCCSR_MST006             3231-3233   ///
      int    PRCCSR_MST007             3234-3236   ///
      int    PRCCSR_MST008             3237-3239   ///
      int    PRCCSR_MST009             3240-3242   ///
      int    PRCCSR_MST010             3243-3245   ///
      int    PRCCSR_MST011             3246-3248   ///
      int    PRCCSR_MST012             3249-3251   ///
      int    PRCCSR_MST013             3252-3254   ///
      int    PRCCSR_MST014             3255-3257   ///
      int    PRCCSR_MST015             3258-3260   ///
      int    PRCCSR_MST016             3261-3263   ///
      int    PRCCSR_MST017             3264-3266   ///
      int    PRCCSR_MST018             3267-3269   ///
      int    PRCCSR_MST019             3270-3272   ///
      int    PRCCSR_MST020             3273-3275   ///
      int    PRCCSR_MST021             3276-3278   ///
      int    PRCCSR_MST022             3279-3281   ///
      int    PRCCSR_MST023             3282-3284   ///
      int    PRCCSR_MST024             3285-3287   ///
      int    PRCCSR_MST025             3288-3290   ///
      int    PRCCSR_MST026             3291-3293   ///
      int    PRCCSR_MST027             3294-3296   ///
      int    PRCCSR_MST028             3297-3299   ///
      int    PRCCSR_MST029             3300-3302   ///
      int    PRCCSR_MST030             3303-3305   ///
      int    PRCCSR_NCM001             3306-3308   ///
      int    PRCCSR_NCM002             3309-3311   ///
      int    PRCCSR_NCM003             3312-3314   ///
      int    PRCCSR_NCM004             3315-3317   ///
      int    PRCCSR_OST001             3318-3320   ///
      int    PRCCSR_OTR001             3321-3323   ///
      int    PRCCSR_OTR002             3324-3326   ///
      int    PRCCSR_OTR003             3327-3329   ///
      int    PRCCSR_OTR004             3330-3332   ///
      int    PRCCSR_OTR005             3333-3335   ///
      int    PRCCSR_PGN001             3336-3338   ///
      int    PRCCSR_PGN002             3339-3341   ///
      int    PRCCSR_PGN003             3342-3344   ///
      int    PRCCSR_PGN004             3345-3347   ///
      int    PRCCSR_PGN005             3348-3350   ///
      int    PRCCSR_PGN006             3351-3353   ///
      int    PRCCSR_PGN007             3354-3356   ///
      int    PRCCSR_PGN008             3357-3359   ///
      int    PRCCSR_PGN009             3360-3362   ///
      int    PRCCSR_PLC001             3363-3365   ///
      int    PRCCSR_PLC002             3366-3368   ///
      int    PRCCSR_PNS001             3369-3371   ///
      int    PRCCSR_PNS002             3372-3374   ///
      int    PRCCSR_PNS003             3375-3377   ///
      int    PRCCSR_PNS004             3378-3380   ///
      int    PRCCSR_PNS005             3381-3383   ///
      int    PRCCSR_PNS006             3384-3386   ///
      int    PRCCSR_RAD001             3387-3389   ///
      int    PRCCSR_RAD002             3390-3392   ///
      int    PRCCSR_RAD003             3393-3395   ///
      int    PRCCSR_RAD004             3396-3398   ///
      int    PRCCSR_RES001             3399-3401   ///
      int    PRCCSR_RES002             3402-3404   ///
      int    PRCCSR_RES003             3405-3407   ///
      int    PRCCSR_RES004             3408-3410   ///
      int    PRCCSR_RES005             3411-3413   ///
      int    PRCCSR_RES006             3414-3416   ///
      int    PRCCSR_RES007             3417-3419   ///
      int    PRCCSR_RES008             3420-3422   ///
      int    PRCCSR_RES009             3423-3425   ///
      int    PRCCSR_RES010             3426-3428   ///
      int    PRCCSR_RES011             3429-3431   ///
      int    PRCCSR_RES012             3432-3434   ///
      int    PRCCSR_RES013             3435-3437   ///
      int    PRCCSR_RES014             3438-3440   ///
      int    PRCCSR_RHB001             3441-3443   ///
      int    PRCCSR_RHB002             3444-3446   ///
      int    PRCCSR_RHB003             3447-3449   ///
      int    PRCCSR_RHB004             3450-3452   ///
      int    PRCCSR_SKB001             3453-3455   ///
      int    PRCCSR_SKB002             3456-3458   ///
      int    PRCCSR_SKB003             3459-3461   ///
      int    PRCCSR_SKB004             3462-3464   ///
      int    PRCCSR_SKB005             3465-3467   ///
      int    PRCCSR_SKB006             3468-3470   ///
      int    PRCCSR_SKB007             3471-3473   ///
      int    PRCCSR_SKB008             3474-3476   ///
      int    PRCCSR_SKB009             3477-3479   ///
      int    PRCCSR_SKB010             3480-3482   ///
      int    PRCCSR_SUD001             3483-3485   ///
      int    PRCCSR_SUD002             3486-3488   ///
      int    PRCCSR_SUD003             3489-3491   ///
      int    PRCCSR_SUD004             3492-3494   ///
      int    PRCCSR_URN001             3495-3497   ///
      int    PRCCSR_URN002             3498-3500   ///
      int    PRCCSR_URN003             3501-3503   ///
      int    PRCCSR_URN004             3504-3506   ///
      int    PRCCSR_URN005             3507-3509   ///
      int    PRCCSR_URN006             3510-3512   ///
      int    PRCCSR_URN007             3513-3515   ///
      int    PRCCSR_URN008             3516-3518   ///
      int    PRCCSR_URN009             3519-3521   ///
      int    PRCCSR_URN010             3522-3524   ///
      int    PRCCSR_URN011             3525-3527   ///
      int    PRCCSR_URN012             3528-3530   ///
      str    PRCCSR_VERSION            3531-3536   ///
      using  "MA_SID_2023_DX_PR_GRPS.asc"

/***  Assign labels to the data elements ***/
label var CCIR_VERSION             "Version of Chronic Condition Indicator Refined for ICD-10-CM"
label var CCIR1                    "ICD-10-CM Chronic Condition Indicator Refined 1"
label var CCIR2                    "ICD-10-CM Chronic Condition Indicator Refined 2"
label var CCIR3                    "ICD-10-CM Chronic Condition Indicator Refined 3"
label var CCIR4                    "ICD-10-CM Chronic Condition Indicator Refined 4"
label var CCIR5                    "ICD-10-CM Chronic Condition Indicator Refined 5"
label var CCIR6                    "ICD-10-CM Chronic Condition Indicator Refined 6"
label var CCIR7                    "ICD-10-CM Chronic Condition Indicator Refined 7"
label var CCIR8                    "ICD-10-CM Chronic Condition Indicator Refined 8"
label var CCIR9                    "ICD-10-CM Chronic Condition Indicator Refined 9"
label var CCIR10                   "ICD-10-CM Chronic Condition Indicator Refined 10"
label var CCIR11                   "ICD-10-CM Chronic Condition Indicator Refined 11"
label var CCIR12                   "ICD-10-CM Chronic Condition Indicator Refined 12"
label var CCIR13                   "ICD-10-CM Chronic Condition Indicator Refined 13"
label var CCIR14                   "ICD-10-CM Chronic Condition Indicator Refined 14"
label var CCIR15                   "ICD-10-CM Chronic Condition Indicator Refined 15"
label var CCIR16                   "ICD-10-CM Chronic Condition Indicator Refined 16"
label var CCIR17                   "ICD-10-CM Chronic Condition Indicator Refined 17"
label var CCIR18                   "ICD-10-CM Chronic Condition Indicator Refined 18"
label var CCIR19                   "ICD-10-CM Chronic Condition Indicator Refined 19"
label var CCIR20                   "ICD-10-CM Chronic Condition Indicator Refined 20"
label var CCIR21                   "ICD-10-CM Chronic Condition Indicator Refined 21"
label var CCIR22                   "ICD-10-CM Chronic Condition Indicator Refined 22"
label var CCIR23                   "ICD-10-CM Chronic Condition Indicator Refined 23"
label var CCIR24                   "ICD-10-CM Chronic Condition Indicator Refined 24"
label var CCIR25                   "ICD-10-CM Chronic Condition Indicator Refined 25"
label var CCIR26                   "ICD-10-CM Chronic Condition Indicator Refined 26"
label var CCIR27                   "ICD-10-CM Chronic Condition Indicator Refined 27"
label var CCIR28                   "ICD-10-CM Chronic Condition Indicator Refined 28"
label var CCIR29                   "ICD-10-CM Chronic Condition Indicator Refined 29"
label var CCIR30                   "ICD-10-CM Chronic Condition Indicator Refined 30"
label var CCIR31                   "ICD-10-CM Chronic Condition Indicator Refined 31"
label var CCIR32                   "ICD-10-CM Chronic Condition Indicator Refined 32"
label var CCIR33                   "ICD-10-CM Chronic Condition Indicator Refined 33"
label var CCIR34                   "ICD-10-CM Chronic Condition Indicator Refined 34"
label var CCIR35                   "ICD-10-CM Chronic Condition Indicator Refined 35"
label var CCIR36                   "ICD-10-CM Chronic Condition Indicator Refined 36"
label var CCIR37                   "ICD-10-CM Chronic Condition Indicator Refined 37"
label var CCIR38                   "ICD-10-CM Chronic Condition Indicator Refined 38"
label var CCIR39                   "ICD-10-CM Chronic Condition Indicator Refined 39"
label var CCIR40                   "ICD-10-CM Chronic Condition Indicator Refined 40"
label var CCIR41                   "ICD-10-CM Chronic Condition Indicator Refined 41"
label var CCIR42                   "ICD-10-CM Chronic Condition Indicator Refined 42"
label var CCIR43                   "ICD-10-CM Chronic Condition Indicator Refined 43"
label var CCIR44                   "ICD-10-CM Chronic Condition Indicator Refined 44"
label var CCIR45                   "ICD-10-CM Chronic Condition Indicator Refined 45"
label var CCIR46                   "ICD-10-CM Chronic Condition Indicator Refined 46"
label var CCIR47                   "ICD-10-CM Chronic Condition Indicator Refined 47"
label var CCIR48                   "ICD-10-CM Chronic Condition Indicator Refined 48"
label var CCIR49                   "ICD-10-CM Chronic Condition Indicator Refined 49"
label var CCIR50                   "ICD-10-CM Chronic Condition Indicator Refined 50"
label var CCIR51                   "ICD-10-CM Chronic Condition Indicator Refined 51"
label var CCIR52                   "ICD-10-CM Chronic Condition Indicator Refined 52"
label var CCIR53                   "ICD-10-CM Chronic Condition Indicator Refined 53"
label var CCIR54                   "ICD-10-CM Chronic Condition Indicator Refined 54"
label var CCIR55                   "ICD-10-CM Chronic Condition Indicator Refined 55"
label var CCIR56                   "ICD-10-CM Chronic Condition Indicator Refined 56"
label var CCIR57                   "ICD-10-CM Chronic Condition Indicator Refined 57"
label var CCIR58                   "ICD-10-CM Chronic Condition Indicator Refined 58"
label var CCIR59                   "ICD-10-CM Chronic Condition Indicator Refined 59"
label var CCIR60                   "ICD-10-CM Chronic Condition Indicator Refined 60"
label var CCIR61                   "ICD-10-CM Chronic Condition Indicator Refined 61"
label var CCIR62                   "ICD-10-CM Chronic Condition Indicator Refined 62"
label var CCIR63                   "ICD-10-CM Chronic Condition Indicator Refined 63"
label var CCIR64                   "ICD-10-CM Chronic Condition Indicator Refined 64"
label var CCIR65                   "ICD-10-CM Chronic Condition Indicator Refined 65"
label var CCIR66                   "ICD-10-CM Chronic Condition Indicator Refined 66"
label var CCIR67                   "ICD-10-CM Chronic Condition Indicator Refined 67"
label var CCIR68                   "ICD-10-CM Chronic Condition Indicator Refined 68"
label var CCIR69                   "ICD-10-CM Chronic Condition Indicator Refined 69"
label var CCIR70                   "ICD-10-CM Chronic Condition Indicator Refined 70"
label var CCIR71                   "ICD-10-CM Chronic Condition Indicator Refined 71"
label var CCIR72                   "ICD-10-CM Chronic Condition Indicator Refined 72"
label var CCIR73                   "ICD-10-CM Chronic Condition Indicator Refined 73"
label var CCIR74                   "ICD-10-CM Chronic Condition Indicator Refined 74"
label var CCIR75                   "ICD-10-CM Chronic Condition Indicator Refined 75"
label var CCIR76                   "ICD-10-CM Chronic Condition Indicator Refined 76"
label var CCIR77                   "ICD-10-CM Chronic Condition Indicator Refined 77"
label var CCIR78                   "ICD-10-CM Chronic Condition Indicator Refined 78"
label var CCIR79                   "ICD-10-CM Chronic Condition Indicator Refined 79"
label var CCIR80                   "ICD-10-CM Chronic Condition Indicator Refined 80"
label var CCIR81                   "ICD-10-CM Chronic Condition Indicator Refined 81"
label var CCIR82                   "ICD-10-CM Chronic Condition Indicator Refined 82"
label var CCIR83                   "ICD-10-CM Chronic Condition Indicator Refined 83"
label var CCIR84                   "ICD-10-CM Chronic Condition Indicator Refined 84"
label var CCIR85                   "ICD-10-CM Chronic Condition Indicator Refined 85"
label var CCIR86                   "ICD-10-CM Chronic Condition Indicator Refined 86"
label var CCIR87                   "ICD-10-CM Chronic Condition Indicator Refined 87"
label var CCIR88                   "ICD-10-CM Chronic Condition Indicator Refined 88"
label var CCIR89                   "ICD-10-CM Chronic Condition Indicator Refined 89"
label var CCIR90                   "ICD-10-CM Chronic Condition Indicator Refined 90"
label var CCIR91                   "ICD-10-CM Chronic Condition Indicator Refined 91"
label var CCIR92                   "ICD-10-CM Chronic Condition Indicator Refined 92"
label var CCIR93                   "ICD-10-CM Chronic Condition Indicator Refined 93"
label var CCIR94                   "ICD-10-CM Chronic Condition Indicator Refined 94"
label var CCIR95                   "ICD-10-CM Chronic Condition Indicator Refined 95"
label var CCIR96                   "ICD-10-CM Chronic Condition Indicator Refined 96"
label var CCIR97                   "ICD-10-CM Chronic Condition Indicator Refined 97"
label var CCIR98                   "ICD-10-CM Chronic Condition Indicator Refined 98"
label var CCIR99                   "ICD-10-CM Chronic Condition Indicator Refined 99"
label var CCIR100                  "ICD-10-CM Chronic Condition Indicator Refined 100"
label var CCIR101                  "ICD-10-CM Chronic Condition Indicator Refined 101"
label var CCIR102                  "ICD-10-CM Chronic Condition Indicator Refined 102"
label var CCIR103                  "ICD-10-CM Chronic Condition Indicator Refined 103"
label var CCIR104                  "ICD-10-CM Chronic Condition Indicator Refined 104"
label var CCIR105                  "ICD-10-CM Chronic Condition Indicator Refined 105"
label var CCIR106                  "ICD-10-CM Chronic Condition Indicator Refined 106"
label var CCIR107                  "ICD-10-CM Chronic Condition Indicator Refined 107"
label var CCIR108                  "ICD-10-CM Chronic Condition Indicator Refined 108"
label var CCIR109                  "ICD-10-CM Chronic Condition Indicator Refined 109"
label var CCIR110                  "ICD-10-CM Chronic Condition Indicator Refined 110"
label var CCIR111                  "ICD-10-CM Chronic Condition Indicator Refined 111"
label var CCIR112                  "ICD-10-CM Chronic Condition Indicator Refined 112"
label var CCIR113                  "ICD-10-CM Chronic Condition Indicator Refined 113"
label var CCIR114                  "ICD-10-CM Chronic Condition Indicator Refined 114"
label var CCIR115                  "ICD-10-CM Chronic Condition Indicator Refined 115"
label var CCIR116                  "ICD-10-CM Chronic Condition Indicator Refined 116"
label var CCIR117                  "ICD-10-CM Chronic Condition Indicator Refined 117"
label var CCIR118                  "ICD-10-CM Chronic Condition Indicator Refined 118"
label var CCIR119                  "ICD-10-CM Chronic Condition Indicator Refined 119"
label var CCIR120                  "ICD-10-CM Chronic Condition Indicator Refined 120"
label var CCIR121                  "ICD-10-CM Chronic Condition Indicator Refined 121"
label var CCIR122                  "ICD-10-CM Chronic Condition Indicator Refined 122"
label var CCIR123                  "ICD-10-CM Chronic Condition Indicator Refined 123"
label var CCIR124                  "ICD-10-CM Chronic Condition Indicator Refined 124"
label var CCIR125                  "ICD-10-CM Chronic Condition Indicator Refined 125"
label var CCIR126                  "ICD-10-CM Chronic Condition Indicator Refined 126"
label var CCIR127                  "ICD-10-CM Chronic Condition Indicator Refined 127"
label var CMR_ANEMDEF              "Anemias due to other nutritional deficiencies"
label var CMR_AUTOIMMUNE           "Autoimmune conditions"
label var CMR_BLDLOSS              "Chronic blood loss anemia (iron deficiency)"
label var CMR_CANCER_LEUK          "Leukemia"
label var CMR_CANCER_LYMPH         "Lymphoma"
label var CMR_CANCER_METS          "Metastatic cancer"
label var CMR_CANCER_NSITU         "Solid tumor without metastasis, in situ"
label var CMR_CANCER_SOLID         "Solid tumor without metastasis, malignant"
label var CMR_CBVD                 "Cerebrovascular disease"
label var CMR_COAG                 "Coagulopathy"
label var CMR_DEMENTIA             "Dementia"
label var CMR_DIAB_CX              "Diabetes with chronic complications"
label var CMR_DIAB_UNCX            "Diabetes without chronic complications"
label var CMR_HF                   "Heart failure"
label var CMR_HTN_CX               "Hypertension, complicated"
label var CMR_HTN_UNCX             "Hypertension, uncomplicated"
label var CMR_LUNG_CHRONIC         "Chronic pulmonary disease"
label var CMR_NEURO_MOVT           "Neurological disorders affecting movement"
label var CMR_NEURO_OTH            "Other neurological disorders"
label var CMR_NEURO_SEIZ           "Seizures and epilepsy"
label var CMR_PARALYSIS            "Paralysis"
label var CMR_PERIVASC             "Peripheral vascular disease"
label var CMR_PULMCIRC             "Pulmonary circulation disease"
label var CMR_RENLFL_MOD           "Renal failure, moderate"
label var CMR_RENLFL_SEV           "Renal failure, severe"
label var CMR_THYROID_HYPO         "Hypothyroidism"
label var CMR_THYROID_OTH          "Other thyroid disorders"
label var CMR_ULCER_PEPTIC         "Peptic ulcer disease x bleeding"
label var CMR_VALVE                "Valvular disease"
label var CMR_VERSION              "Version of Elixhauser Comorbidity Software Refined"
label var CMR_WGHTLOSS             "Weight loss"
label var I10_INJURY
    "Injury ICD-10-CM diagnosis reported on record (1: First-listed injury; 2: Other than first-listed injury; 0: No injury)"
label var I10_INJURY_CUT           "Mechanism of injury: cut or pierce"
label var I10_INJURY_DROWN         "Mechanism of injury: drowning or submersion"
label var I10_INJURY_FALL          "Mechanism of injury: fall"
label var I10_INJURY_FIRE          "Mechanism of injury: fire, flame, hot object, or hot substance"
label var I10_INJURY_FIREARM       "Mechanism of injury: firearm"
label var I10_INJURY_MACHINERY     "Mechanism of injury: machinery"
label var I10_INJURY_MVT

"Mechanism of injury: motor vehicle traffic, including the occupant of a car, motorcyclist, pedal cyclist, pedestrian, other, or uns
pecified"
label var I10_INJURY_NATURE
    "Mechanism of injury: natural or environmental, included venomous and nonvenomous bites and stings"
label var I10_INJURY_OVEREXERTION  "Mechanism of injury: overexertion"
label var I10_INJURY_POISON        "Mechanism of injury: poisoning, including drugs and nondrugs"
label var I10_INJURY_STRUCK        "Mechanism of injury: struck by or against"
label var I10_INJURY_SUFFOCATION   "Mechanism of injury: suffocation"
label var I10_INTENT_ASSAULT       "Intent of injury: assault"
label var I10_INTENT_SELF_HARM     "Intent of injury: intentional self-harm"
label var I10_INTENT_UNINTENTIONAL "Intent of injury: unintentional"
label var I10_MULTINJURY           "Multiple ICD-10-CM injuries reported on record"
label var KEY                      "HCUP record identifier"
label var PCLASS_VERSION           "Version of ICD-10-PCS Procedure class"
label var PCLASS1                  "ICD-10-PCS Procedure class 1"
label var PCLASS2                  "ICD-10-PCS Procedure class 2"
label var PCLASS3                  "ICD-10-PCS Procedure class 3"
label var PCLASS4                  "ICD-10-PCS Procedure class 4"
label var PCLASS5                  "ICD-10-PCS Procedure class 5"
label var PCLASS6                  "ICD-10-PCS Procedure class 6"
label var PCLASS7                  "ICD-10-PCS Procedure class 7"
label var PCLASS8                  "ICD-10-PCS Procedure class 8"
label var PCLASS9                  "ICD-10-PCS Procedure class 9"
label var PCLASS10                 "ICD-10-PCS Procedure class 10"
label var PCLASS11                 "ICD-10-PCS Procedure class 11"
label var PCLASS12                 "ICD-10-PCS Procedure class 12"
label var PCLASS13                 "ICD-10-PCS Procedure class 13"
label var PCLASS14                 "ICD-10-PCS Procedure class 14"
label var PCLASS15                 "ICD-10-PCS Procedure class 15"
label var PCLASS16                 "ICD-10-PCS Procedure class 16"
label var PCLASS17                 "ICD-10-PCS Procedure class 17"
label var PCLASS18                 "ICD-10-PCS Procedure class 18"
label var PCLASS19                 "ICD-10-PCS Procedure class 19"
label var PCLASS20                 "ICD-10-PCS Procedure class 20"
label var PCLASS21                 "ICD-10-PCS Procedure class 21"
label var PCLASS22                 "ICD-10-PCS Procedure class 22"
label var PCLASS23                 "ICD-10-PCS Procedure class 23"
label var PCLASS24                 "ICD-10-PCS Procedure class 24"
label var PCLASS25                 "ICD-10-PCS Procedure class 25"
label var PCLASS26                 "ICD-10-PCS Procedure class 26"
label var PCLASS27                 "ICD-10-PCS Procedure class 27"
label var PCLASS28                 "ICD-10-PCS Procedure class 28"
label var PCLASS29                 "ICD-10-PCS Procedure class 29"
label var PCLASS30                 "ICD-10-PCS Procedure class 30"
label var PCLASS31                 "ICD-10-PCS Procedure class 31"
label var PCLASS32                 "ICD-10-PCS Procedure class 32"
label var PCLASS33                 "ICD-10-PCS Procedure class 33"
label var PCLASS34                 "ICD-10-PCS Procedure class 34"
label var PCLASS35                 "ICD-10-PCS Procedure class 35"
label var PCLASS36                 "ICD-10-PCS Procedure class 36"
label var PCLASS37                 "ICD-10-PCS Procedure class 37"
label var PCLASS38                 "ICD-10-PCS Procedure class 38"
label var PCLASS39                 "ICD-10-PCS Procedure class 39"
label var PCLASS40                 "ICD-10-PCS Procedure class 40"
label var PCLASS41                 "ICD-10-PCS Procedure class 41"
label var PCLASS42                 "ICD-10-PCS Procedure class 42"
label var PCLASS43                 "ICD-10-PCS Procedure class 43"
label var PCLASS44                 "ICD-10-PCS Procedure class 44"
label var PCLASS45                 "ICD-10-PCS Procedure class 45"
label var PCLASS46                 "ICD-10-PCS Procedure class 46"
label var PCLASS47                 "ICD-10-PCS Procedure class 47"
label var PCLASS48                 "ICD-10-PCS Procedure class 48"
label var PCLASS49                 "ICD-10-PCS Procedure class 49"
label var PCLASS50                 "ICD-10-PCS Procedure class 50"
label var PCLASS51                 "ICD-10-PCS Procedure class 51"
label var PCLASS52                 "ICD-10-PCS Procedure class 52"
label var PCLASS53                 "ICD-10-PCS Procedure class 53"
label var PCLASS54                 "ICD-10-PCS Procedure class 54"
label var PCLASS55                 "ICD-10-PCS Procedure class 55"
label var PCLASS56                 "ICD-10-PCS Procedure class 56"
label var PCLASS57                 "ICD-10-PCS Procedure class 57"
label var PCLASS58                 "ICD-10-PCS Procedure class 58"
label var PCLASS59                 "ICD-10-PCS Procedure class 59"
label var PCLASS60                 "ICD-10-PCS Procedure class 60"
label var PCLASS61                 "ICD-10-PCS Procedure class 61"
label var PCLASS62                 "ICD-10-PCS Procedure class 62"
label var PCLASS63                 "ICD-10-PCS Procedure class 63"
label var PCLASS64                 "ICD-10-PCS Procedure class 64"
label var PCLASS65                 "ICD-10-PCS Procedure class 65"
label var PCLASS66                 "ICD-10-PCS Procedure class 66"
label var PCLASS67                 "ICD-10-PCS Procedure class 67"
label var PCLASS68                 "ICD-10-PCS Procedure class 68"
label var PCLASS69                 "ICD-10-PCS Procedure class 69"
label var PCLASS70                 "ICD-10-PCS Procedure class 70"
label var PCLASS71                 "ICD-10-PCS Procedure class 71"
label var PCLASS72                 "ICD-10-PCS Procedure class 72"
label var PCLASS73                 "ICD-10-PCS Procedure class 73"
label var PCLASS74                 "ICD-10-PCS Procedure class 74"
label var PCLASS75                 "ICD-10-PCS Procedure class 75"
label var PCLASS76                 "ICD-10-PCS Procedure class 76"
label var PCLASS77                 "ICD-10-PCS Procedure class 77"
label var PCLASS78                 "ICD-10-PCS Procedure class 78"
label var PCLASS79                 "ICD-10-PCS Procedure class 79"
label var PCLASS80                 "ICD-10-PCS Procedure class 80"
label var PCLASS81                 "ICD-10-PCS Procedure class 81"
label var PCLASS82                 "ICD-10-PCS Procedure class 82"
label var PCLASS83                 "ICD-10-PCS Procedure class 83"
label var PCLASS84                 "ICD-10-PCS Procedure class 84"
label var PCLASS85                 "ICD-10-PCS Procedure class 85"
label var PCLASS86                 "ICD-10-PCS Procedure class 86"
label var PCLASS87                 "ICD-10-PCS Procedure class 87"
label var PCLASS88                 "ICD-10-PCS Procedure class 88"
label var PCLASS89                 "ICD-10-PCS Procedure class 89"
label var PCLASS90                 "ICD-10-PCS Procedure class 90"
label var PCLASS91                 "ICD-10-PCS Procedure class 91"
label var PCLASS92                 "ICD-10-PCS Procedure class 92"
label var PCLASS93                 "ICD-10-PCS Procedure class 93"
label var PCLASS94                 "ICD-10-PCS Procedure class 94"
label var PCLASS95                 "ICD-10-PCS Procedure class 95"
label var PCLASS96                 "ICD-10-PCS Procedure class 96"
label var PCLASS97                 "ICD-10-PCS Procedure class 97"
label var PCLASS98                 "ICD-10-PCS Procedure class 98"
label var PCLASS99                 "ICD-10-PCS Procedure class 99"
label var PCLASS100                "ICD-10-PCS Procedure class 100"
label var PCLASS101                "ICD-10-PCS Procedure class 101"
label var PCLASS102                "ICD-10-PCS Procedure class 102"
label var PCLASS103                "ICD-10-PCS Procedure class 103"
label var PCLASS104                "ICD-10-PCS Procedure class 104"
label var PCLASS105                "ICD-10-PCS Procedure class 105"
label var PCLASS106                "ICD-10-PCS Procedure class 106"
label var PCLASS107                "ICD-10-PCS Procedure class 107"
label var PCLASS108                "ICD-10-PCS Procedure class 108"
label var PCLASS109                "ICD-10-PCS Procedure class 109"
label var PCLASS110                "ICD-10-PCS Procedure class 110"
label var PCLASS111                "ICD-10-PCS Procedure class 111"
label var PCLASS112                "ICD-10-PCS Procedure class 112"
label var PCLASS113                "ICD-10-PCS Procedure class 113"
label var PCLASS114                "ICD-10-PCS Procedure class 114"
label var PCLASS115                "ICD-10-PCS Procedure class 115"
label var PCLASS116                "ICD-10-PCS Procedure class 116"
label var PCLASS117                "ICD-10-PCS Procedure class 117"
label var PCLASS118                "ICD-10-PCS Procedure class 118"
label var PCLASS119                "ICD-10-PCS Procedure class 119"
label var PCLASS120                "ICD-10-PCS Procedure class 120"
label var PCLASS121                "ICD-10-PCS Procedure class 121"
label var PCLASS122                "ICD-10-PCS Procedure class 122"
label var PCLASS123                "ICD-10-PCS Procedure class 123"
label var PCLASS124                "ICD-10-PCS Procedure class 124"
label var PCLASS125                "ICD-10-PCS Procedure class 125"
label var PCLASS126                "ICD-10-PCS Procedure class 126"
label var PCLASS127                "ICD-10-PCS Procedure class 127"
label var PCLASS128                "ICD-10-PCS Procedure class 128"
label var PCLASS129                "ICD-10-PCS Procedure class 129"
label var PCLASS130                "ICD-10-PCS Procedure class 130"
label var PCLASS131                "ICD-10-PCS Procedure class 131"
label var PCLASS132                "ICD-10-PCS Procedure class 132"
label var PCLASS133                "ICD-10-PCS Procedure class 133"
label var PCLASS134                "ICD-10-PCS Procedure class 134"
label var PCLASS135                "ICD-10-PCS Procedure class 135"
label var PCLASS136                "ICD-10-PCS Procedure class 136"
label var PCLASS137                "ICD-10-PCS Procedure class 137"
label var PCLASS138                "ICD-10-PCS Procedure class 138"
label var PCLASS139                "ICD-10-PCS Procedure class 139"
label var PCLASS140                "ICD-10-PCS Procedure class 140"
label var PCLASS141                "ICD-10-PCS Procedure class 141"
label var PCLASS142                "ICD-10-PCS Procedure class 142"
label var PCLASS143                "ICD-10-PCS Procedure class 143"
label var PCLASS144                "ICD-10-PCS Procedure class 144"
label var PCLASS145                "ICD-10-PCS Procedure class 145"
label var PCLASS146                "ICD-10-PCS Procedure class 146"
label var PCLASS147                "ICD-10-PCS Procedure class 147"
label var PCLASS148                "ICD-10-PCS Procedure class 148"
label var PCLASS149                "ICD-10-PCS Procedure class 149"
label var PCLASS150                "ICD-10-PCS Procedure class 150"
label var PCLASS151                "ICD-10-PCS Procedure class 151"
label var PCLASS152                "ICD-10-PCS Procedure class 152"
label var PCLASS153                "ICD-10-PCS Procedure class 153"
label var PCLASS154                "ICD-10-PCS Procedure class 154"
label var PCLASS155                "ICD-10-PCS Procedure class 155"
label var PCLASS156                "ICD-10-PCS Procedure class 156"
label var PCLASS157                "ICD-10-PCS Procedure class 157"
label var PCLASS158                "ICD-10-PCS Procedure class 158"
label var PCLASS159                "ICD-10-PCS Procedure class 159"
label var PCLASS160                "ICD-10-PCS Procedure class 160"
label var PCLASS161                "ICD-10-PCS Procedure class 161"
label var PCLASS162                "ICD-10-PCS Procedure class 162"
label var PCLASS163                "ICD-10-PCS Procedure class 163"
label var PCLASS164                "ICD-10-PCS Procedure class 164"
label var PCLASS165                "ICD-10-PCS Procedure class 165"
label var PCLASS166                "ICD-10-PCS Procedure class 166"
label var PCLASS167                "ICD-10-PCS Procedure class 167"
label var PCLASS168                "ICD-10-PCS Procedure class 168"
label var PCLASS169                "ICD-10-PCS Procedure class 169"
label var PCLASS170                "ICD-10-PCS Procedure class 170"
label var PCLASS171                "ICD-10-PCS Procedure class 171"
label var PCLASS172                "ICD-10-PCS Procedure class 172"
label var PCLASS173                "ICD-10-PCS Procedure class 173"
label var PCLASS174                "ICD-10-PCS Procedure class 174"
label var PCLASS175                "ICD-10-PCS Procedure class 175"
label var PCLASS176                "ICD-10-PCS Procedure class 176"
label var PCLASS177                "ICD-10-PCS Procedure class 177"
label var PCLASS178                "ICD-10-PCS Procedure class 178"
label var PCLASS179                "ICD-10-PCS Procedure class 179"
label var PCLASS180                "ICD-10-PCS Procedure class 180"
label var PCLASS181                "ICD-10-PCS Procedure class 181"
label var PCLASS182                "ICD-10-PCS Procedure class 182"
label var PCLASS183                "ICD-10-PCS Procedure class 183"
label var PCLASS184                "ICD-10-PCS Procedure class 184"
label var PCLASS185                "ICD-10-PCS Procedure class 185"
label var PCLASS186                "ICD-10-PCS Procedure class 186"
label var PCLASS187                "ICD-10-PCS Procedure class 187"
label var PCLASS188                "ICD-10-PCS Procedure class 188"
label var PCLASS189                "ICD-10-PCS Procedure class 189"
label var PCLASS190                "ICD-10-PCS Procedure class 190"
label var PCLASS191                "ICD-10-PCS Procedure class 191"
label var PCLASS192                "ICD-10-PCS Procedure class 192"
label var PCLASS193                "ICD-10-PCS Procedure class 193"
label var PCLASS194                "ICD-10-PCS Procedure class 194"
label var PCLASS195                "ICD-10-PCS Procedure class 195"
label var PCLASS196                "ICD-10-PCS Procedure class 196"
label var PCLASS197                "ICD-10-PCS Procedure class 197"
label var PCLASS198                "ICD-10-PCS Procedure class 198"
label var PCLASS199                "ICD-10-PCS Procedure class 199"
label var PCLASS200                "ICD-10-PCS Procedure class 200"
label var DXCCSR_Default_DX1       "Default CCSR for principal/first-listed ICD-10-CM diagnosis"
label var DXCCSR_BLD001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD001"
label var DXCCSR_BLD002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD002"
label var DXCCSR_BLD003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD003"
label var DXCCSR_BLD004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD004"
label var DXCCSR_BLD005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD005"
label var DXCCSR_BLD006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD006"
label var DXCCSR_BLD007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD007"
label var DXCCSR_BLD008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD008"
label var DXCCSR_BLD009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD009"
label var DXCCSR_BLD010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD010"
label var DXCCSR_CIR001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR001"
label var DXCCSR_CIR002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR002"
label var DXCCSR_CIR003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR003"
label var DXCCSR_CIR004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR004"
label var DXCCSR_CIR005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR005"
label var DXCCSR_CIR006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR006"
label var DXCCSR_CIR007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR007"
label var DXCCSR_CIR008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR008"
label var DXCCSR_CIR009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR009"
label var DXCCSR_CIR010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR010"
label var DXCCSR_CIR011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR011"
label var DXCCSR_CIR012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR012"
label var DXCCSR_CIR013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR013"
label var DXCCSR_CIR014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR014"
label var DXCCSR_CIR015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR015"
label var DXCCSR_CIR016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR016"
label var DXCCSR_CIR017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR017"
label var DXCCSR_CIR018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR018"
label var DXCCSR_CIR019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR019"
label var DXCCSR_CIR020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR020"
label var DXCCSR_CIR021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR021"
label var DXCCSR_CIR022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR022"
label var DXCCSR_CIR023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR023"
label var DXCCSR_CIR024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR024"
label var DXCCSR_CIR025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR025"
label var DXCCSR_CIR026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR026"
label var DXCCSR_CIR027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR027"
label var DXCCSR_CIR028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR028"
label var DXCCSR_CIR029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR029"
label var DXCCSR_CIR030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR030"
label var DXCCSR_CIR031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR031"
label var DXCCSR_CIR032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR032"
label var DXCCSR_CIR033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR033"
label var DXCCSR_CIR034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR034"
label var DXCCSR_CIR035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR035"
label var DXCCSR_CIR036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR036"
label var DXCCSR_CIR037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR037"
label var DXCCSR_CIR038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR038"
label var DXCCSR_CIR039            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR039"
label var DXCCSR_DEN001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN001"
label var DXCCSR_DEN002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN002"
label var DXCCSR_DEN003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN003"
label var DXCCSR_DIG001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG001"
label var DXCCSR_DIG002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG002"
label var DXCCSR_DIG003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG003"
label var DXCCSR_DIG004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG004"
label var DXCCSR_DIG005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG005"
label var DXCCSR_DIG006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG006"
label var DXCCSR_DIG007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG007"
label var DXCCSR_DIG008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG008"
label var DXCCSR_DIG009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG009"
label var DXCCSR_DIG010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG010"
label var DXCCSR_DIG011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG011"
label var DXCCSR_DIG012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG012"
label var DXCCSR_DIG013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG013"
label var DXCCSR_DIG014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG014"
label var DXCCSR_DIG015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG015"
label var DXCCSR_DIG016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG016"
label var DXCCSR_DIG017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG017"
label var DXCCSR_DIG018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG018"
label var DXCCSR_DIG019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG019"
label var DXCCSR_DIG020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG020"
label var DXCCSR_DIG021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG021"
label var DXCCSR_DIG022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG022"
label var DXCCSR_DIG023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG023"
label var DXCCSR_DIG024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG024"
label var DXCCSR_DIG025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG025"
label var DXCCSR_EAR001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR001"
label var DXCCSR_EAR002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR002"
label var DXCCSR_EAR003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR003"
label var DXCCSR_EAR004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR004"
label var DXCCSR_EAR005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR005"
label var DXCCSR_EAR006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR006"
label var DXCCSR_END001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END001"
label var DXCCSR_END002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END002"
label var DXCCSR_END003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END003"
label var DXCCSR_END004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END004"
label var DXCCSR_END005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END005"
label var DXCCSR_END006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END006"
label var DXCCSR_END007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END007"
label var DXCCSR_END008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END008"
label var DXCCSR_END009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END009"
label var DXCCSR_END010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END010"
label var DXCCSR_END011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END011"
label var DXCCSR_END012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END012"
label var DXCCSR_END013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END013"
label var DXCCSR_END014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END014"
label var DXCCSR_END015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END015"
label var DXCCSR_END016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END016"
label var DXCCSR_END017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END017"
label var DXCCSR_EXT001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT001"
label var DXCCSR_EXT002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT002"
label var DXCCSR_EXT003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT003"
label var DXCCSR_EXT004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT004"
label var DXCCSR_EXT005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT005"
label var DXCCSR_EXT006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT006"
label var DXCCSR_EXT007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT007"
label var DXCCSR_EXT008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT008"
label var DXCCSR_EXT009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT009"
label var DXCCSR_EXT010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT010"
label var DXCCSR_EXT011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT011"
label var DXCCSR_EXT012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT012"
label var DXCCSR_EXT013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT013"
label var DXCCSR_EXT014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT014"
label var DXCCSR_EXT015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT015"
label var DXCCSR_EXT016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT016"
label var DXCCSR_EXT017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT017"
label var DXCCSR_EXT018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT018"
label var DXCCSR_EXT019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT019"
label var DXCCSR_EXT020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT020"
label var DXCCSR_EXT021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT021"
label var DXCCSR_EXT022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT022"
label var DXCCSR_EXT023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT023"
label var DXCCSR_EXT024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT024"
label var DXCCSR_EXT025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT025"
label var DXCCSR_EXT026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT026"
label var DXCCSR_EXT027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT027"
label var DXCCSR_EXT028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT028"
label var DXCCSR_EXT029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT029"
label var DXCCSR_EXT030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT030"
label var DXCCSR_EYE001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE001"
label var DXCCSR_EYE002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE002"
label var DXCCSR_EYE003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE003"
label var DXCCSR_EYE004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE004"
label var DXCCSR_EYE005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE005"
label var DXCCSR_EYE006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE006"
label var DXCCSR_EYE007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE007"
label var DXCCSR_EYE008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE008"
label var DXCCSR_EYE009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE009"
label var DXCCSR_EYE010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE010"
label var DXCCSR_EYE011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE011"
label var DXCCSR_EYE012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE012"
label var DXCCSR_FAC001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC001"
label var DXCCSR_FAC002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC002"
label var DXCCSR_FAC003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC003"
label var DXCCSR_FAC004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC004"
label var DXCCSR_FAC005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC005"
label var DXCCSR_FAC006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC006"
label var DXCCSR_FAC007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC007"
label var DXCCSR_FAC008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC008"
label var DXCCSR_FAC009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC009"
label var DXCCSR_FAC010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC010"
label var DXCCSR_FAC011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC011"
label var DXCCSR_FAC012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC012"
label var DXCCSR_FAC013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC013"
label var DXCCSR_FAC014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC014"
label var DXCCSR_FAC015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC015"
label var DXCCSR_FAC016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC016"
label var DXCCSR_FAC017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC017"
label var DXCCSR_FAC018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC018"
label var DXCCSR_FAC019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC019"
label var DXCCSR_FAC020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC020"
label var DXCCSR_FAC021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC021"
label var DXCCSR_FAC022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC022"
label var DXCCSR_FAC023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC023"
label var DXCCSR_FAC024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC024"
label var DXCCSR_FAC025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC025"
label var DXCCSR_GEN001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN001"
label var DXCCSR_GEN002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN002"
label var DXCCSR_GEN003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN003"
label var DXCCSR_GEN004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN004"
label var DXCCSR_GEN005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN005"
label var DXCCSR_GEN006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN006"
label var DXCCSR_GEN007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN007"
label var DXCCSR_GEN008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN008"
label var DXCCSR_GEN009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN009"
label var DXCCSR_GEN010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN010"
label var DXCCSR_GEN011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN011"
label var DXCCSR_GEN012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN012"
label var DXCCSR_GEN013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN013"
label var DXCCSR_GEN014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN014"
label var DXCCSR_GEN015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN015"
label var DXCCSR_GEN016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN016"
label var DXCCSR_GEN017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN017"
label var DXCCSR_GEN018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN018"
label var DXCCSR_GEN019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN019"
label var DXCCSR_GEN020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN020"
label var DXCCSR_GEN021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN021"
label var DXCCSR_GEN022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN022"
label var DXCCSR_GEN023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN023"
label var DXCCSR_GEN024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN024"
label var DXCCSR_GEN025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN025"
label var DXCCSR_GEN026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN026"
label var DXCCSR_INF001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF001"
label var DXCCSR_INF002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF002"
label var DXCCSR_INF003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF003"
label var DXCCSR_INF004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF004"
label var DXCCSR_INF005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF005"
label var DXCCSR_INF006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF006"
label var DXCCSR_INF007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF007"
label var DXCCSR_INF008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF008"
label var DXCCSR_INF009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF009"
label var DXCCSR_INF010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF010"
label var DXCCSR_INF011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF011"
label var DXCCSR_INF012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF012"
label var DXCCSR_INJ001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ001"
label var DXCCSR_INJ002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ002"
label var DXCCSR_INJ003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ003"
label var DXCCSR_INJ004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ004"
label var DXCCSR_INJ005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ005"
label var DXCCSR_INJ006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ006"
label var DXCCSR_INJ007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ007"
label var DXCCSR_INJ008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ008"
label var DXCCSR_INJ009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ009"
label var DXCCSR_INJ010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ010"
label var DXCCSR_INJ011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ011"
label var DXCCSR_INJ012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ012"
label var DXCCSR_INJ013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ013"
label var DXCCSR_INJ014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ014"
label var DXCCSR_INJ015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ015"
label var DXCCSR_INJ016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ016"
label var DXCCSR_INJ017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ017"
label var DXCCSR_INJ018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ018"
label var DXCCSR_INJ019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ019"
label var DXCCSR_INJ020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ020"
label var DXCCSR_INJ021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ021"
label var DXCCSR_INJ022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ022"
label var DXCCSR_INJ023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ023"
label var DXCCSR_INJ024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ024"
label var DXCCSR_INJ025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ025"
label var DXCCSR_INJ026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ026"
label var DXCCSR_INJ027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ027"
label var DXCCSR_INJ028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ028"
label var DXCCSR_INJ029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ029"
label var DXCCSR_INJ030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ030"
label var DXCCSR_INJ031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ031"
label var DXCCSR_INJ032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ032"
label var DXCCSR_INJ033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ033"
label var DXCCSR_INJ034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ034"
label var DXCCSR_INJ035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ035"
label var DXCCSR_INJ036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ036"
label var DXCCSR_INJ037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ037"
label var DXCCSR_INJ038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ038"
label var DXCCSR_INJ039            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ039"
label var DXCCSR_INJ040            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ040"
label var DXCCSR_INJ041            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ041"
label var DXCCSR_INJ042            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ042"
label var DXCCSR_INJ043            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ043"
label var DXCCSR_INJ044            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ044"
label var DXCCSR_INJ045            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ045"
label var DXCCSR_INJ046            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ046"
label var DXCCSR_INJ047            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ047"
label var DXCCSR_INJ048            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ048"
label var DXCCSR_INJ049            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ049"
label var DXCCSR_INJ050            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ050"
label var DXCCSR_INJ051            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ051"
label var DXCCSR_INJ052            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ052"
label var DXCCSR_INJ053            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ053"
label var DXCCSR_INJ054            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ054"
label var DXCCSR_INJ055            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ055"
label var DXCCSR_INJ056            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ056"
label var DXCCSR_INJ057            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ057"
label var DXCCSR_INJ058            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ058"
label var DXCCSR_INJ059            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ059"
label var DXCCSR_INJ060            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ060"
label var DXCCSR_INJ061            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ061"
label var DXCCSR_INJ062            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ062"
label var DXCCSR_INJ063            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ063"
label var DXCCSR_INJ064            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ064"
label var DXCCSR_INJ065            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ065"
label var DXCCSR_INJ066            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ066"
label var DXCCSR_INJ067            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ067"
label var DXCCSR_INJ068            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ068"
label var DXCCSR_INJ069            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ069"
label var DXCCSR_INJ070            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ070"
label var DXCCSR_INJ071            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ071"
label var DXCCSR_INJ072            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ072"
label var DXCCSR_INJ073            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ073"
label var DXCCSR_INJ074            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ074"
label var DXCCSR_INJ075            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ075"
label var DXCCSR_INJ076            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ076"
label var DXCCSR_MAL001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL001"
label var DXCCSR_MAL002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL002"
label var DXCCSR_MAL003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL003"
label var DXCCSR_MAL004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL004"
label var DXCCSR_MAL005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL005"
label var DXCCSR_MAL006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL006"
label var DXCCSR_MAL007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL007"
label var DXCCSR_MAL008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL008"
label var DXCCSR_MAL009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL009"
label var DXCCSR_MAL010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL010"
label var DXCCSR_MBD001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD001"
label var DXCCSR_MBD002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD002"
label var DXCCSR_MBD003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD003"
label var DXCCSR_MBD004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD004"
label var DXCCSR_MBD005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD005"
label var DXCCSR_MBD006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD006"
label var DXCCSR_MBD007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD007"
label var DXCCSR_MBD008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD008"
label var DXCCSR_MBD009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD009"
label var DXCCSR_MBD010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD010"
label var DXCCSR_MBD011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD011"
label var DXCCSR_MBD012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD012"
label var DXCCSR_MBD013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD013"
label var DXCCSR_MBD014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD014"
label var DXCCSR_MBD017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD017"
label var DXCCSR_MBD018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD018"
label var DXCCSR_MBD019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD019"
label var DXCCSR_MBD020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD020"
label var DXCCSR_MBD021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD021"
label var DXCCSR_MBD022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD022"
label var DXCCSR_MBD023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD023"
label var DXCCSR_MBD024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD024"
label var DXCCSR_MBD025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD025"
label var DXCCSR_MBD026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD026"
label var DXCCSR_MBD027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD027"
label var DXCCSR_MBD028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD028"
label var DXCCSR_MBD029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD029"
label var DXCCSR_MBD030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD030"
label var DXCCSR_MBD031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD031"
label var DXCCSR_MBD032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD032"
label var DXCCSR_MBD033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD033"
label var DXCCSR_MBD034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD034"
label var DXCCSR_MUS001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS001"
label var DXCCSR_MUS002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS002"
label var DXCCSR_MUS003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS003"
label var DXCCSR_MUS004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS004"
label var DXCCSR_MUS005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS005"
label var DXCCSR_MUS006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS006"
label var DXCCSR_MUS007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS007"
label var DXCCSR_MUS008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS008"
label var DXCCSR_MUS009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS009"
label var DXCCSR_MUS010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS010"
label var DXCCSR_MUS011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS011"
label var DXCCSR_MUS012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS012"
label var DXCCSR_MUS013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS013"
label var DXCCSR_MUS014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS014"
label var DXCCSR_MUS015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS015"
label var DXCCSR_MUS016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS016"
label var DXCCSR_MUS017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS017"
label var DXCCSR_MUS018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS018"
label var DXCCSR_MUS019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS019"
label var DXCCSR_MUS020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS020"
label var DXCCSR_MUS021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS021"
label var DXCCSR_MUS022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS022"
label var DXCCSR_MUS023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS023"
label var DXCCSR_MUS024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS024"
label var DXCCSR_MUS025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS025"
label var DXCCSR_MUS026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS026"
label var DXCCSR_MUS027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS027"
label var DXCCSR_MUS028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS028"
label var DXCCSR_MUS029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS029"
label var DXCCSR_MUS030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS030"
label var DXCCSR_MUS031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS031"
label var DXCCSR_MUS032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS032"
label var DXCCSR_MUS033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS033"
label var DXCCSR_MUS034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS034"
label var DXCCSR_MUS035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS035"
label var DXCCSR_MUS036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS036"
label var DXCCSR_MUS037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS037"
label var DXCCSR_MUS038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS038"
label var DXCCSR_NEO001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO001"
label var DXCCSR_NEO002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO002"
label var DXCCSR_NEO003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO003"
label var DXCCSR_NEO004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO004"
label var DXCCSR_NEO005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO005"
label var DXCCSR_NEO006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO006"
label var DXCCSR_NEO007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO007"
label var DXCCSR_NEO008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO008"
label var DXCCSR_NEO009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO009"
label var DXCCSR_NEO010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO010"
label var DXCCSR_NEO011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO011"
label var DXCCSR_NEO012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO012"
label var DXCCSR_NEO013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO013"
label var DXCCSR_NEO014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO014"
label var DXCCSR_NEO015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO015"
label var DXCCSR_NEO016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO016"
label var DXCCSR_NEO017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO017"
label var DXCCSR_NEO018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO018"
label var DXCCSR_NEO019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO019"
label var DXCCSR_NEO020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO020"
label var DXCCSR_NEO021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO021"
label var DXCCSR_NEO022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO022"
label var DXCCSR_NEO023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO023"
label var DXCCSR_NEO024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO024"
label var DXCCSR_NEO025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO025"
label var DXCCSR_NEO026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO026"
label var DXCCSR_NEO027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO027"
label var DXCCSR_NEO028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO028"
label var DXCCSR_NEO029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO029"
label var DXCCSR_NEO030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO030"
label var DXCCSR_NEO031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO031"
label var DXCCSR_NEO032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO032"
label var DXCCSR_NEO033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO033"
label var DXCCSR_NEO034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO034"
label var DXCCSR_NEO035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO035"
label var DXCCSR_NEO036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO036"
label var DXCCSR_NEO037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO037"
label var DXCCSR_NEO038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO038"
label var DXCCSR_NEO039            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO039"
label var DXCCSR_NEO040            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO040"
label var DXCCSR_NEO041            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO041"
label var DXCCSR_NEO042            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO042"
label var DXCCSR_NEO043            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO043"
label var DXCCSR_NEO044            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO044"
label var DXCCSR_NEO045            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO045"
label var DXCCSR_NEO046            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO046"
label var DXCCSR_NEO047            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO047"
label var DXCCSR_NEO048            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO048"
label var DXCCSR_NEO049            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO049"
label var DXCCSR_NEO050            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO050"
label var DXCCSR_NEO051            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO051"
label var DXCCSR_NEO052            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO052"
label var DXCCSR_NEO053            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO053"
label var DXCCSR_NEO054            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO054"
label var DXCCSR_NEO055            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO055"
label var DXCCSR_NEO056            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO056"
label var DXCCSR_NEO057            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO057"
label var DXCCSR_NEO058            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO058"
label var DXCCSR_NEO059            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO059"
label var DXCCSR_NEO060            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO060"
label var DXCCSR_NEO061            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO061"
label var DXCCSR_NEO062            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO062"
label var DXCCSR_NEO063            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO063"
label var DXCCSR_NEO064            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO064"
label var DXCCSR_NEO065            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO065"
label var DXCCSR_NEO066            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO066"
label var DXCCSR_NEO067            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO067"
label var DXCCSR_NEO068            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO068"
label var DXCCSR_NEO069            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO069"
label var DXCCSR_NEO070            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO070"
label var DXCCSR_NEO071            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO071"
label var DXCCSR_NEO072            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO072"
label var DXCCSR_NEO073            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO073"
label var DXCCSR_NEO074            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO074"
label var DXCCSR_NVS001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS001"
label var DXCCSR_NVS002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS002"
label var DXCCSR_NVS003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS003"
label var DXCCSR_NVS004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS004"
label var DXCCSR_NVS005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS005"
label var DXCCSR_NVS006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS006"
label var DXCCSR_NVS007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS007"
label var DXCCSR_NVS008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS008"
label var DXCCSR_NVS009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS009"
label var DXCCSR_NVS010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS010"
label var DXCCSR_NVS011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS011"
label var DXCCSR_NVS012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS012"
label var DXCCSR_NVS013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS013"
label var DXCCSR_NVS014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS014"
label var DXCCSR_NVS015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS015"
label var DXCCSR_NVS016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS016"
label var DXCCSR_NVS017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS017"
label var DXCCSR_NVS018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS018"
label var DXCCSR_NVS019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS019"
label var DXCCSR_NVS020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS020"
label var DXCCSR_NVS021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS021"
label var DXCCSR_NVS022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS022"
label var DXCCSR_PNL001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL001"
label var DXCCSR_PNL002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL002"
label var DXCCSR_PNL003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL003"
label var DXCCSR_PNL004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL004"
label var DXCCSR_PNL005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL005"
label var DXCCSR_PNL006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL006"
label var DXCCSR_PNL007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL007"
label var DXCCSR_PNL008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL008"
label var DXCCSR_PNL009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL009"
label var DXCCSR_PNL010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL010"
label var DXCCSR_PNL011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL011"
label var DXCCSR_PNL012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL012"
label var DXCCSR_PNL013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL013"
label var DXCCSR_PNL014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL014"
label var DXCCSR_PNL015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL015"
label var DXCCSR_PRG001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG001"
label var DXCCSR_PRG002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG002"
label var DXCCSR_PRG003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG003"
label var DXCCSR_PRG004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG004"
label var DXCCSR_PRG005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG005"
label var DXCCSR_PRG006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG006"
label var DXCCSR_PRG007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG007"
label var DXCCSR_PRG008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG008"
label var DXCCSR_PRG009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG009"
label var DXCCSR_PRG010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG010"
label var DXCCSR_PRG011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG011"
label var DXCCSR_PRG012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG012"
label var DXCCSR_PRG013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG013"
label var DXCCSR_PRG014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG014"
label var DXCCSR_PRG015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG015"
label var DXCCSR_PRG016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG016"
label var DXCCSR_PRG017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG017"
label var DXCCSR_PRG018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG018"
label var DXCCSR_PRG019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG019"
label var DXCCSR_PRG020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG020"
label var DXCCSR_PRG021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG021"
label var DXCCSR_PRG022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG022"
label var DXCCSR_PRG023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG023"
label var DXCCSR_PRG024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG024"
label var DXCCSR_PRG025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG025"
label var DXCCSR_PRG026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG026"
label var DXCCSR_PRG027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG027"
label var DXCCSR_PRG028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG028"
label var DXCCSR_PRG029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG029"
label var DXCCSR_PRG030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG030"
label var DXCCSR_RSP001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP001"
label var DXCCSR_RSP002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP002"
label var DXCCSR_RSP003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP003"
label var DXCCSR_RSP004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP004"
label var DXCCSR_RSP005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP005"
label var DXCCSR_RSP006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP006"
label var DXCCSR_RSP007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP007"
label var DXCCSR_RSP008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP008"
label var DXCCSR_RSP009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP009"
label var DXCCSR_RSP010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP010"
label var DXCCSR_RSP011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP011"
label var DXCCSR_RSP012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP012"
label var DXCCSR_RSP013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP013"
label var DXCCSR_RSP014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP014"
label var DXCCSR_RSP015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP015"
label var DXCCSR_RSP016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP016"
label var DXCCSR_RSP017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP017"
label var DXCCSR_SKN001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN001"
label var DXCCSR_SKN002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN002"
label var DXCCSR_SKN003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN003"
label var DXCCSR_SKN004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN004"
label var DXCCSR_SKN005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN005"
label var DXCCSR_SKN006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN006"
label var DXCCSR_SKN007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN007"
label var DXCCSR_SYM001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM001"
label var DXCCSR_SYM002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM002"
label var DXCCSR_SYM003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM003"
label var DXCCSR_SYM004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM004"
label var DXCCSR_SYM005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM005"
label var DXCCSR_SYM006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM006"
label var DXCCSR_SYM007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM007"
label var DXCCSR_SYM008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM008"
label var DXCCSR_SYM009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM009"
label var DXCCSR_SYM010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM010"
label var DXCCSR_SYM011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM011"
label var DXCCSR_SYM012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM012"
label var DXCCSR_SYM013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM013"
label var DXCCSR_SYM014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM014"
label var DXCCSR_SYM015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM015"
label var DXCCSR_SYM016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM016"
label var DXCCSR_SYM017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM017"
label var DXCCSR_VERSION           "Version of CCSR for ICD-10-CM diagnoses"
label var PRCCSR_ADM001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM001"
label var PRCCSR_ADM002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM002"
label var PRCCSR_ADM003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM003"
label var PRCCSR_ADM004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM004"
label var PRCCSR_ADM005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM005"
label var PRCCSR_ADM006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM006"
label var PRCCSR_ADM007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM007"
label var PRCCSR_ADM008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM008"
label var PRCCSR_ADM009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM009"
label var PRCCSR_ADM010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM010"
label var PRCCSR_ADM011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM011"
label var PRCCSR_ADM012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM012"
label var PRCCSR_ADM013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM013"
label var PRCCSR_ADM014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM014"
label var PRCCSR_ADM015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM015"
label var PRCCSR_ADM016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM016"
label var PRCCSR_ADM017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM017"
label var PRCCSR_ADM018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM018"
label var PRCCSR_ADM019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM019"
label var PRCCSR_ADM020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM020"
label var PRCCSR_ADM021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM021"
label var PRCCSR_ADM022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM022"
label var PRCCSR_CAR001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR001"
label var PRCCSR_CAR002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR002"
label var PRCCSR_CAR003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR003"
label var PRCCSR_CAR004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR004"
label var PRCCSR_CAR005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR005"
label var PRCCSR_CAR006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR006"
label var PRCCSR_CAR007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR007"
label var PRCCSR_CAR008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR008"
label var PRCCSR_CAR009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR009"
label var PRCCSR_CAR010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR010"
label var PRCCSR_CAR011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR011"
label var PRCCSR_CAR012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR012"
label var PRCCSR_CAR013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR013"
label var PRCCSR_CAR014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR014"
label var PRCCSR_CAR015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR015"
label var PRCCSR_CAR016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR016"
label var PRCCSR_CAR017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR017"
label var PRCCSR_CAR018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR018"
label var PRCCSR_CAR019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR019"
label var PRCCSR_CAR020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR020"
label var PRCCSR_CAR021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR021"
label var PRCCSR_CAR022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR022"
label var PRCCSR_CAR023            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR023"
label var PRCCSR_CAR024            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR024"
label var PRCCSR_CAR025            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR025"
label var PRCCSR_CAR026            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR026"
label var PRCCSR_CAR027            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR027"
label var PRCCSR_CAR028            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR028"
label var PRCCSR_CAR029            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR029"
label var PRCCSR_CHP001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CHP001"
label var PRCCSR_CNS001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS001"
label var PRCCSR_CNS002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS002"
label var PRCCSR_CNS003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS003"
label var PRCCSR_CNS004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS004"
label var PRCCSR_CNS005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS005"
label var PRCCSR_CNS006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS006"
label var PRCCSR_CNS007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS007"
label var PRCCSR_CNS008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS008"
label var PRCCSR_CNS009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS009"
label var PRCCSR_CNS010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS010"
label var PRCCSR_CNS011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS011"
label var PRCCSR_CNS012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS012"
label var PRCCSR_CNS013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS013"
label var PRCCSR_CNS014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS014"
label var PRCCSR_ENP001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP001"
label var PRCCSR_ENP002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP002"
label var PRCCSR_ENP003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP003"
label var PRCCSR_ENP004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP004"
label var PRCCSR_ENP005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP005"
label var PRCCSR_ENP006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP006"
label var PRCCSR_ENT001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT001"
label var PRCCSR_ENT002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT002"
label var PRCCSR_ENT003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT003"
label var PRCCSR_ENT004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT004"
label var PRCCSR_ENT005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT005"
label var PRCCSR_ENT006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT006"
label var PRCCSR_ENT007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT007"
label var PRCCSR_ENT008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT008"
label var PRCCSR_ENT009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT009"
label var PRCCSR_ENT010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT010"
label var PRCCSR_ENT011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT011"
label var PRCCSR_ENT012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT012"
label var PRCCSR_ENT013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT013"
label var PRCCSR_ENT014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT014"
label var PRCCSR_ENT015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT015"
label var PRCCSR_ENT016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT016"
label var PRCCSR_ENT017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT017"
label var PRCCSR_ESA001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA001"
label var PRCCSR_ESA002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA002"
label var PRCCSR_ESA003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA003"
label var PRCCSR_ESA004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA004"
label var PRCCSR_ESA005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA005"
label var PRCCSR_ESA006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA006"
label var PRCCSR_ESA007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA007"
label var PRCCSR_ESA008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA008"
label var PRCCSR_ESA009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA009"
label var PRCCSR_ESA010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA010"
label var PRCCSR_ESA011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA011"
label var PRCCSR_EST001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST001"
label var PRCCSR_EST002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST002"
label var PRCCSR_EST003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST003"
label var PRCCSR_EST004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST004"
label var PRCCSR_EST005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST005"
label var PRCCSR_EYP001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EYP001"
label var PRCCSR_EYP002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EYP002"
label var PRCCSR_FRS001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS001"
label var PRCCSR_FRS002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS002"
label var PRCCSR_FRS003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS003"
label var PRCCSR_FRS004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS004"
label var PRCCSR_FRS005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS005"
label var PRCCSR_FRS006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS006"
label var PRCCSR_FRS007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS007"
label var PRCCSR_FRS008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS008"
label var PRCCSR_FRS009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS009"
label var PRCCSR_FRS010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS010"
label var PRCCSR_FRS011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS011"
label var PRCCSR_FRS012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS012"
label var PRCCSR_FRS013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS013"
label var PRCCSR_FRS014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS014"
label var PRCCSR_FRS015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS015"
label var PRCCSR_GIS001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS001"
label var PRCCSR_GIS002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS002"
label var PRCCSR_GIS003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS003"
label var PRCCSR_GIS004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS004"
label var PRCCSR_GIS005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS005"
label var PRCCSR_GIS006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS006"
label var PRCCSR_GIS007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS007"
label var PRCCSR_GIS008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS008"
label var PRCCSR_GIS009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS009"
label var PRCCSR_GIS010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS010"
label var PRCCSR_GIS011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS011"
label var PRCCSR_GIS012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS012"
label var PRCCSR_GIS013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS013"
label var PRCCSR_GIS014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS014"
label var PRCCSR_GIS015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS015"
label var PRCCSR_GIS016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS016"
label var PRCCSR_GIS017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS017"
label var PRCCSR_GIS018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS018"
label var PRCCSR_GIS019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS019"
label var PRCCSR_GIS020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS020"
label var PRCCSR_GIS021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS021"
label var PRCCSR_GIS022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS022"
label var PRCCSR_GIS023            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS023"
label var PRCCSR_GIS024            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS024"
label var PRCCSR_GIS025            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS025"
label var PRCCSR_GIS026            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS026"
label var PRCCSR_GIS027            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS027"
label var PRCCSR_GIS028            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS028"
label var PRCCSR_GIS029            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS029"
label var PRCCSR_GNR001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR001"
label var PRCCSR_GNR002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR002"
label var PRCCSR_GNR003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR003"
label var PRCCSR_GNR004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR004"
label var PRCCSR_GNR005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR005"
label var PRCCSR_GNR006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR006"
label var PRCCSR_GNR007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR007"
label var PRCCSR_GNR008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR008"
label var PRCCSR_GNR009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR009"
label var PRCCSR_GNR010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR010"
label var PRCCSR_HEP001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP001"
label var PRCCSR_HEP002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP002"
label var PRCCSR_HEP003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP003"
label var PRCCSR_HEP004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP004"
label var PRCCSR_HEP005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP005"
label var PRCCSR_HEP006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP006"
label var PRCCSR_HEP007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP007"
label var PRCCSR_HEP008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP008"
label var PRCCSR_HEP009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP009"
label var PRCCSR_HEP010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP010"
label var PRCCSR_HEP011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP011"
label var PRCCSR_HEP012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP012"
label var PRCCSR_HEP013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP013"
label var PRCCSR_IMG001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG001"
label var PRCCSR_IMG002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG002"
label var PRCCSR_IMG003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG003"
label var PRCCSR_IMG004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG004"
label var PRCCSR_IMG005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG005"
label var PRCCSR_IMG006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG006"
label var PRCCSR_IMG007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG007"
label var PRCCSR_IMG008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG008"
label var PRCCSR_IMG009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG009"
label var PRCCSR_IMG010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG010"
label var PRCCSR_LYM001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM001"
label var PRCCSR_LYM002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM002"
label var PRCCSR_LYM003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM003"
label var PRCCSR_LYM004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM004"
label var PRCCSR_LYM005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM005"
label var PRCCSR_LYM006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM006"
label var PRCCSR_LYM007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM007"
label var PRCCSR_LYM008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM008"
label var PRCCSR_LYM009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM009"
label var PRCCSR_LYM010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM010"
label var PRCCSR_LYM011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM011"
label var PRCCSR_MAM001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM001"
label var PRCCSR_MAM002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM002"
label var PRCCSR_MAM003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM003"
label var PRCCSR_MAM004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM004"
label var PRCCSR_MAM005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM005"
label var PRCCSR_MAM006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM006"
label var PRCCSR_MAM007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM007"
label var PRCCSR_MAM008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM008"
label var PRCCSR_MAM009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM009"
label var PRCCSR_MAM010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM010"
label var PRCCSR_MAM011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM011"
label var PRCCSR_MAM012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM012"
label var PRCCSR_MAM013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM013"
label var PRCCSR_MAM014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM014"
label var PRCCSR_MAM015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM015"
label var PRCCSR_MHT001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT001"
label var PRCCSR_MHT002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT002"
label var PRCCSR_MHT003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT003"
label var PRCCSR_MHT004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT004"
label var PRCCSR_MHT005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT005"
label var PRCCSR_MRS001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS001"
label var PRCCSR_MRS002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS002"
label var PRCCSR_MRS003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS003"
label var PRCCSR_MRS004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS004"
label var PRCCSR_MRS005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS005"
label var PRCCSR_MRS006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS006"
label var PRCCSR_MRS007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS007"
label var PRCCSR_MST001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST001"
label var PRCCSR_MST002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST002"
label var PRCCSR_MST003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST003"
label var PRCCSR_MST004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST004"
label var PRCCSR_MST005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST005"
label var PRCCSR_MST006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST006"
label var PRCCSR_MST007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST007"
label var PRCCSR_MST008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST008"
label var PRCCSR_MST009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST009"
label var PRCCSR_MST010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST010"
label var PRCCSR_MST011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST011"
label var PRCCSR_MST012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST012"
label var PRCCSR_MST013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST013"
label var PRCCSR_MST014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST014"
label var PRCCSR_MST015            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST015"
label var PRCCSR_MST016            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST016"
label var PRCCSR_MST017            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST017"
label var PRCCSR_MST018            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST018"
label var PRCCSR_MST019            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST019"
label var PRCCSR_MST020            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST020"
label var PRCCSR_MST021            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST021"
label var PRCCSR_MST022            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST022"
label var PRCCSR_MST023            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST023"
label var PRCCSR_MST024            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST024"
label var PRCCSR_MST025            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST025"
label var PRCCSR_MST026            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST026"
label var PRCCSR_MST027            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST027"
label var PRCCSR_MST028            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST028"
label var PRCCSR_MST029            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST029"
label var PRCCSR_MST030            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST030"
label var PRCCSR_NCM001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM001"
label var PRCCSR_NCM002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM002"
label var PRCCSR_NCM003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM003"
label var PRCCSR_NCM004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM004"
label var PRCCSR_OST001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OST001"
label var PRCCSR_OTR001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR001"
label var PRCCSR_OTR002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR002"
label var PRCCSR_OTR003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR003"
label var PRCCSR_OTR004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR004"
label var PRCCSR_OTR005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR005"
label var PRCCSR_PGN001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN001"
label var PRCCSR_PGN002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN002"
label var PRCCSR_PGN003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN003"
label var PRCCSR_PGN004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN004"
label var PRCCSR_PGN005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN005"
label var PRCCSR_PGN006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN006"
label var PRCCSR_PGN007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN007"
label var PRCCSR_PGN008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN008"
label var PRCCSR_PGN009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN009"
label var PRCCSR_PLC001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PLC001"
label var PRCCSR_PLC002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PLC002"
label var PRCCSR_PNS001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS001"
label var PRCCSR_PNS002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS002"
label var PRCCSR_PNS003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS003"
label var PRCCSR_PNS004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS004"
label var PRCCSR_PNS005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS005"
label var PRCCSR_PNS006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS006"
label var PRCCSR_RAD001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD001"
label var PRCCSR_RAD002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD002"
label var PRCCSR_RAD003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD003"
label var PRCCSR_RAD004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD004"
label var PRCCSR_RES001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES001"
label var PRCCSR_RES002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES002"
label var PRCCSR_RES003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES003"
label var PRCCSR_RES004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES004"
label var PRCCSR_RES005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES005"
label var PRCCSR_RES006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES006"
label var PRCCSR_RES007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES007"
label var PRCCSR_RES008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES008"
label var PRCCSR_RES009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES009"
label var PRCCSR_RES010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES010"
label var PRCCSR_RES011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES011"
label var PRCCSR_RES012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES012"
label var PRCCSR_RES013            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES013"
label var PRCCSR_RES014            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES014"
label var PRCCSR_RHB001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB001"
label var PRCCSR_RHB002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB002"
label var PRCCSR_RHB003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB003"
label var PRCCSR_RHB004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB004"
label var PRCCSR_SKB001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB001"
label var PRCCSR_SKB002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB002"
label var PRCCSR_SKB003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB003"
label var PRCCSR_SKB004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB004"
label var PRCCSR_SKB005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB005"
label var PRCCSR_SKB006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB006"
label var PRCCSR_SKB007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB007"
label var PRCCSR_SKB008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB008"
label var PRCCSR_SKB009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB009"
label var PRCCSR_SKB010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB010"
label var PRCCSR_SUD001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD001"
label var PRCCSR_SUD002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD002"
label var PRCCSR_SUD003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD003"
label var PRCCSR_SUD004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD004"
label var PRCCSR_URN001            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN001"
label var PRCCSR_URN002            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN002"
label var PRCCSR_URN003            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN003"
label var PRCCSR_URN004            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN004"
label var PRCCSR_URN005            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN005"
label var PRCCSR_URN006            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN006"
label var PRCCSR_URN007            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN007"
label var PRCCSR_URN008            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN008"
label var PRCCSR_URN009            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN009"
label var PRCCSR_URN010            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN010"
label var PRCCSR_URN011            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN011"
label var PRCCSR_URN012            "Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN012"
label var PRCCSR_VERSION           "Version of CCSR for ICD-10-PCS procedures"

/*** Convert special values to missing values ***/
recode CCIR1                     (-99 -88 -66=.)
recode CCIR2                     (-99 -88 -66=.)
recode CCIR3                     (-99 -88 -66=.)
recode CCIR4                     (-99 -88 -66=.)
recode CCIR5                     (-99 -88 -66=.)
recode CCIR6                     (-99 -88 -66=.)
recode CCIR7                     (-99 -88 -66=.)
recode CCIR8                     (-99 -88 -66=.)
recode CCIR9                     (-99 -88 -66=.)
recode CCIR10                    (-99 -88 -66=.)
recode CCIR11                    (-99 -88 -66=.)
recode CCIR12                    (-99 -88 -66=.)
recode CCIR13                    (-99 -88 -66=.)
recode CCIR14                    (-99 -88 -66=.)
recode CCIR15                    (-99 -88 -66=.)
recode CCIR16                    (-99 -88 -66=.)
recode CCIR17                    (-99 -88 -66=.)
recode CCIR18                    (-99 -88 -66=.)
recode CCIR19                    (-99 -88 -66=.)
recode CCIR20                    (-99 -88 -66=.)
recode CCIR21                    (-99 -88 -66=.)
recode CCIR22                    (-99 -88 -66=.)
recode CCIR23                    (-99 -88 -66=.)
recode CCIR24                    (-99 -88 -66=.)
recode CCIR25                    (-99 -88 -66=.)
recode CCIR26                    (-99 -88 -66=.)
recode CCIR27                    (-99 -88 -66=.)
recode CCIR28                    (-99 -88 -66=.)
recode CCIR29                    (-99 -88 -66=.)
recode CCIR30                    (-99 -88 -66=.)
recode CCIR31                    (-99 -88 -66=.)
recode CCIR32                    (-99 -88 -66=.)
recode CCIR33                    (-99 -88 -66=.)
recode CCIR34                    (-99 -88 -66=.)
recode CCIR35                    (-99 -88 -66=.)
recode CCIR36                    (-99 -88 -66=.)
recode CCIR37                    (-99 -88 -66=.)
recode CCIR38                    (-99 -88 -66=.)
recode CCIR39                    (-99 -88 -66=.)
recode CCIR40                    (-99 -88 -66=.)
recode CCIR41                    (-99 -88 -66=.)
recode CCIR42                    (-99 -88 -66=.)
recode CCIR43                    (-99 -88 -66=.)
recode CCIR44                    (-99 -88 -66=.)
recode CCIR45                    (-99 -88 -66=.)
recode CCIR46                    (-99 -88 -66=.)
recode CCIR47                    (-99 -88 -66=.)
recode CCIR48                    (-99 -88 -66=.)
recode CCIR49                    (-99 -88 -66=.)
recode CCIR50                    (-99 -88 -66=.)
recode CCIR51                    (-99 -88 -66=.)
recode CCIR52                    (-99 -88 -66=.)
recode CCIR53                    (-99 -88 -66=.)
recode CCIR54                    (-99 -88 -66=.)
recode CCIR55                    (-99 -88 -66=.)
recode CCIR56                    (-99 -88 -66=.)
recode CCIR57                    (-99 -88 -66=.)
recode CCIR58                    (-99 -88 -66=.)
recode CCIR59                    (-99 -88 -66=.)
recode CCIR60                    (-99 -88 -66=.)
recode CCIR61                    (-99 -88 -66=.)
recode CCIR62                    (-99 -88 -66=.)
recode CCIR63                    (-99 -88 -66=.)
recode CCIR64                    (-99 -88 -66=.)
recode CCIR65                    (-99 -88 -66=.)
recode CCIR66                    (-99 -88 -66=.)
recode CCIR67                    (-99 -88 -66=.)
recode CCIR68                    (-99 -88 -66=.)
recode CCIR69                    (-99 -88 -66=.)
recode CCIR70                    (-99 -88 -66=.)
recode CCIR71                    (-99 -88 -66=.)
recode CCIR72                    (-99 -88 -66=.)
recode CCIR73                    (-99 -88 -66=.)
recode CCIR74                    (-99 -88 -66=.)
recode CCIR75                    (-99 -88 -66=.)
recode CCIR76                    (-99 -88 -66=.)
recode CCIR77                    (-99 -88 -66=.)
recode CCIR78                    (-99 -88 -66=.)
recode CCIR79                    (-99 -88 -66=.)
recode CCIR80                    (-99 -88 -66=.)
recode CCIR81                    (-99 -88 -66=.)
recode CCIR82                    (-99 -88 -66=.)
recode CCIR83                    (-99 -88 -66=.)
recode CCIR84                    (-99 -88 -66=.)
recode CCIR85                    (-99 -88 -66=.)
recode CCIR86                    (-99 -88 -66=.)
recode CCIR87                    (-99 -88 -66=.)
recode CCIR88                    (-99 -88 -66=.)
recode CCIR89                    (-99 -88 -66=.)
recode CCIR90                    (-99 -88 -66=.)
recode CCIR91                    (-99 -88 -66=.)
recode CCIR92                    (-99 -88 -66=.)
recode CCIR93                    (-99 -88 -66=.)
recode CCIR94                    (-99 -88 -66=.)
recode CCIR95                    (-99 -88 -66=.)
recode CCIR96                    (-99 -88 -66=.)
recode CCIR97                    (-99 -88 -66=.)
recode CCIR98                    (-99 -88 -66=.)
recode CCIR99                    (-99 -88 -66=.)
recode CCIR100                   (-99 -88 -66=.)
recode CCIR101                   (-99 -88 -66=.)
recode CCIR102                   (-99 -88 -66=.)
recode CCIR103                   (-99 -88 -66=.)
recode CCIR104                   (-99 -88 -66=.)
recode CCIR105                   (-99 -88 -66=.)
recode CCIR106                   (-99 -88 -66=.)
recode CCIR107                   (-99 -88 -66=.)
recode CCIR108                   (-99 -88 -66=.)
recode CCIR109                   (-99 -88 -66=.)
recode CCIR110                   (-99 -88 -66=.)
recode CCIR111                   (-99 -88 -66=.)
recode CCIR112                   (-99 -88 -66=.)
recode CCIR113                   (-99 -88 -66=.)
recode CCIR114                   (-99 -88 -66=.)
recode CCIR115                   (-99 -88 -66=.)
recode CCIR116                   (-99 -88 -66=.)
recode CCIR117                   (-99 -88 -66=.)
recode CCIR118                   (-99 -88 -66=.)
recode CCIR119                   (-99 -88 -66=.)
recode CCIR120                   (-99 -88 -66=.)
recode CCIR121                   (-99 -88 -66=.)
recode CCIR122                   (-99 -88 -66=.)
recode CCIR123                   (-99 -88 -66=.)
recode CCIR124                   (-99 -88 -66=.)
recode CCIR125                   (-99 -88 -66=.)
recode CCIR126                   (-99 -88 -66=.)
recode CCIR127                   (-99 -88 -66=.)
recode CMR_ANEMDEF               (-9 -8 -6 -5=.)
recode CMR_AUTOIMMUNE            (-9 -8 -6 -5=.)
recode CMR_BLDLOSS               (-9 -8 -6 -5=.)
recode CMR_CANCER_LEUK           (-9 -8 -6 -5=.)
recode CMR_CANCER_LYMPH          (-9 -8 -6 -5=.)
recode CMR_CANCER_METS           (-9 -8 -6 -5=.)
recode CMR_CANCER_NSITU          (-9 -8 -6 -5=.)
recode CMR_CANCER_SOLID          (-9 -8 -6 -5=.)
recode CMR_CBVD                  (-9 -8 -6 -5=.)
recode CMR_COAG                  (-9 -8 -6 -5=.)
recode CMR_DEMENTIA              (-9 -8 -6 -5=.)
recode CMR_DIAB_CX               (-9 -8 -6 -5=.)
recode CMR_DIAB_UNCX             (-9 -8 -6 -5=.)
recode CMR_HF                    (-9 -8 -6 -5=.)
recode CMR_HTN_CX                (-9 -8 -6 -5=.)
recode CMR_HTN_UNCX              (-9 -8 -6 -5=.)
recode CMR_LUNG_CHRONIC          (-9 -8 -6 -5=.)
recode CMR_NEURO_MOVT            (-9 -8 -6 -5=.)
recode CMR_NEURO_OTH             (-9 -8 -6 -5=.)
recode CMR_NEURO_SEIZ            (-9 -8 -6 -5=.)
recode CMR_PARALYSIS             (-9 -8 -6 -5=.)
recode CMR_PERIVASC              (-9 -8 -6 -5=.)
recode CMR_PULMCIRC              (-9 -8 -6 -5=.)
recode CMR_RENLFL_MOD            (-9 -8 -6 -5=.)
recode CMR_RENLFL_SEV            (-9 -8 -6 -5=.)
recode CMR_THYROID_HYPO          (-9 -8 -6 -5=.)
recode CMR_THYROID_OTH           (-9 -8 -6 -5=.)
recode CMR_ULCER_PEPTIC          (-9 -8 -6 -5=.)
recode CMR_VALVE                 (-9 -8 -6 -5=.)
recode CMR_WGHTLOSS              (-9 -8 -6 -5=.)
recode I10_INJURY                (-9 -8 -6 -5=.)
recode I10_INJURY_CUT            (-9 -8 -6 -5=.)
recode I10_INJURY_DROWN          (-9 -8 -6 -5=.)
recode I10_INJURY_FALL           (-9 -8 -6 -5=.)
recode I10_INJURY_FIRE           (-9 -8 -6 -5=.)
recode I10_INJURY_FIREARM        (-9 -8 -6 -5=.)
recode I10_INJURY_MACHINERY      (-9 -8 -6 -5=.)
recode I10_INJURY_MVT            (-9 -8 -6 -5=.)
recode I10_INJURY_NATURE         (-9 -8 -6 -5=.)
recode I10_INJURY_OVEREXERTION   (-9 -8 -6 -5=.)
recode I10_INJURY_POISON         (-9 -8 -6 -5=.)
recode I10_INJURY_STRUCK         (-9 -8 -6 -5=.)
recode I10_INJURY_SUFFOCATION    (-9 -8 -6 -5=.)
recode I10_INTENT_ASSAULT        (-9 -8 -6 -5=.)
recode I10_INTENT_SELF_HARM      (-9 -8 -6 -5=.)
recode I10_INTENT_UNINTENTIONAL  (-9 -8 -6 -5=.)
recode I10_MULTINJURY            (-9 -8 -6 -5=.)
recode PCLASS1                   (-9 -8 -6 -5=.)
recode PCLASS2                   (-9 -8 -6 -5=.)
recode PCLASS3                   (-9 -8 -6 -5=.)
recode PCLASS4                   (-9 -8 -6 -5=.)
recode PCLASS5                   (-9 -8 -6 -5=.)
recode PCLASS6                   (-9 -8 -6 -5=.)
recode PCLASS7                   (-9 -8 -6 -5=.)
recode PCLASS8                   (-9 -8 -6 -5=.)
recode PCLASS9                   (-9 -8 -6 -5=.)
recode PCLASS10                  (-9 -8 -6 -5=.)
recode PCLASS11                  (-9 -8 -6 -5=.)
recode PCLASS12                  (-9 -8 -6 -5=.)
recode PCLASS13                  (-9 -8 -6 -5=.)
recode PCLASS14                  (-9 -8 -6 -5=.)
recode PCLASS15                  (-9 -8 -6 -5=.)
recode PCLASS16                  (-9 -8 -6 -5=.)
recode PCLASS17                  (-9 -8 -6 -5=.)
recode PCLASS18                  (-9 -8 -6 -5=.)
recode PCLASS19                  (-9 -8 -6 -5=.)
recode PCLASS20                  (-9 -8 -6 -5=.)
recode PCLASS21                  (-9 -8 -6 -5=.)
recode PCLASS22                  (-9 -8 -6 -5=.)
recode PCLASS23                  (-9 -8 -6 -5=.)
recode PCLASS24                  (-9 -8 -6 -5=.)
recode PCLASS25                  (-9 -8 -6 -5=.)
recode PCLASS26                  (-9 -8 -6 -5=.)
recode PCLASS27                  (-9 -8 -6 -5=.)
recode PCLASS28                  (-9 -8 -6 -5=.)
recode PCLASS29                  (-9 -8 -6 -5=.)
recode PCLASS30                  (-9 -8 -6 -5=.)
recode PCLASS31                  (-9 -8 -6 -5=.)
recode PCLASS32                  (-9 -8 -6 -5=.)
recode PCLASS33                  (-9 -8 -6 -5=.)
recode PCLASS34                  (-9 -8 -6 -5=.)
recode PCLASS35                  (-9 -8 -6 -5=.)
recode PCLASS36                  (-9 -8 -6 -5=.)
recode PCLASS37                  (-9 -8 -6 -5=.)
recode PCLASS38                  (-9 -8 -6 -5=.)
recode PCLASS39                  (-9 -8 -6 -5=.)
recode PCLASS40                  (-9 -8 -6 -5=.)
recode PCLASS41                  (-9 -8 -6 -5=.)
recode PCLASS42                  (-9 -8 -6 -5=.)
recode PCLASS43                  (-9 -8 -6 -5=.)
recode PCLASS44                  (-9 -8 -6 -5=.)
recode PCLASS45                  (-9 -8 -6 -5=.)
recode PCLASS46                  (-9 -8 -6 -5=.)
recode PCLASS47                  (-9 -8 -6 -5=.)
recode PCLASS48                  (-9 -8 -6 -5=.)
recode PCLASS49                  (-9 -8 -6 -5=.)
recode PCLASS50                  (-9 -8 -6 -5=.)
recode PCLASS51                  (-9 -8 -6 -5=.)
recode PCLASS52                  (-9 -8 -6 -5=.)
recode PCLASS53                  (-9 -8 -6 -5=.)
recode PCLASS54                  (-9 -8 -6 -5=.)
recode PCLASS55                  (-9 -8 -6 -5=.)
recode PCLASS56                  (-9 -8 -6 -5=.)
recode PCLASS57                  (-9 -8 -6 -5=.)
recode PCLASS58                  (-9 -8 -6 -5=.)
recode PCLASS59                  (-9 -8 -6 -5=.)
recode PCLASS60                  (-9 -8 -6 -5=.)
recode PCLASS61                  (-9 -8 -6 -5=.)
recode PCLASS62                  (-9 -8 -6 -5=.)
recode PCLASS63                  (-9 -8 -6 -5=.)
recode PCLASS64                  (-9 -8 -6 -5=.)
recode PCLASS65                  (-9 -8 -6 -5=.)
recode PCLASS66                  (-9 -8 -6 -5=.)
recode PCLASS67                  (-9 -8 -6 -5=.)
recode PCLASS68                  (-9 -8 -6 -5=.)
recode PCLASS69                  (-9 -8 -6 -5=.)
recode PCLASS70                  (-9 -8 -6 -5=.)
recode PCLASS71                  (-9 -8 -6 -5=.)
recode PCLASS72                  (-9 -8 -6 -5=.)
recode PCLASS73                  (-9 -8 -6 -5=.)
recode PCLASS74                  (-9 -8 -6 -5=.)
recode PCLASS75                  (-9 -8 -6 -5=.)
recode PCLASS76                  (-9 -8 -6 -5=.)
recode PCLASS77                  (-9 -8 -6 -5=.)
recode PCLASS78                  (-9 -8 -6 -5=.)
recode PCLASS79                  (-9 -8 -6 -5=.)
recode PCLASS80                  (-9 -8 -6 -5=.)
recode PCLASS81                  (-9 -8 -6 -5=.)
recode PCLASS82                  (-9 -8 -6 -5=.)
recode PCLASS83                  (-9 -8 -6 -5=.)
recode PCLASS84                  (-9 -8 -6 -5=.)
recode PCLASS85                  (-9 -8 -6 -5=.)
recode PCLASS86                  (-9 -8 -6 -5=.)
recode PCLASS87                  (-9 -8 -6 -5=.)
recode PCLASS88                  (-9 -8 -6 -5=.)
recode PCLASS89                  (-9 -8 -6 -5=.)
recode PCLASS90                  (-9 -8 -6 -5=.)
recode PCLASS91                  (-9 -8 -6 -5=.)
recode PCLASS92                  (-9 -8 -6 -5=.)
recode PCLASS93                  (-9 -8 -6 -5=.)
recode PCLASS94                  (-9 -8 -6 -5=.)
recode PCLASS95                  (-9 -8 -6 -5=.)
recode PCLASS96                  (-9 -8 -6 -5=.)
recode PCLASS97                  (-9 -8 -6 -5=.)
recode PCLASS98                  (-9 -8 -6 -5=.)
recode PCLASS99                  (-9 -8 -6 -5=.)
recode PCLASS100                 (-9 -8 -6 -5=.)
recode PCLASS101                 (-9 -8 -6 -5=.)
recode PCLASS102                 (-9 -8 -6 -5=.)
recode PCLASS103                 (-9 -8 -6 -5=.)
recode PCLASS104                 (-9 -8 -6 -5=.)
recode PCLASS105                 (-9 -8 -6 -5=.)
recode PCLASS106                 (-9 -8 -6 -5=.)
recode PCLASS107                 (-9 -8 -6 -5=.)
recode PCLASS108                 (-9 -8 -6 -5=.)
recode PCLASS109                 (-9 -8 -6 -5=.)
recode PCLASS110                 (-9 -8 -6 -5=.)
recode PCLASS111                 (-9 -8 -6 -5=.)
recode PCLASS112                 (-9 -8 -6 -5=.)
recode PCLASS113                 (-9 -8 -6 -5=.)
recode PCLASS114                 (-9 -8 -6 -5=.)
recode PCLASS115                 (-9 -8 -6 -5=.)
recode PCLASS116                 (-9 -8 -6 -5=.)
recode PCLASS117                 (-9 -8 -6 -5=.)
recode PCLASS118                 (-9 -8 -6 -5=.)
recode PCLASS119                 (-9 -8 -6 -5=.)
recode PCLASS120                 (-9 -8 -6 -5=.)
recode PCLASS121                 (-9 -8 -6 -5=.)
recode PCLASS122                 (-9 -8 -6 -5=.)
recode PCLASS123                 (-9 -8 -6 -5=.)
recode PCLASS124                 (-9 -8 -6 -5=.)
recode PCLASS125                 (-9 -8 -6 -5=.)
recode PCLASS126                 (-9 -8 -6 -5=.)
recode PCLASS127                 (-9 -8 -6 -5=.)
recode PCLASS128                 (-9 -8 -6 -5=.)
recode PCLASS129                 (-9 -8 -6 -5=.)
recode PCLASS130                 (-9 -8 -6 -5=.)
recode PCLASS131                 (-9 -8 -6 -5=.)
recode PCLASS132                 (-9 -8 -6 -5=.)
recode PCLASS133                 (-9 -8 -6 -5=.)
recode PCLASS134                 (-9 -8 -6 -5=.)
recode PCLASS135                 (-9 -8 -6 -5=.)
recode PCLASS136                 (-9 -8 -6 -5=.)
recode PCLASS137                 (-9 -8 -6 -5=.)
recode PCLASS138                 (-9 -8 -6 -5=.)
recode PCLASS139                 (-9 -8 -6 -5=.)
recode PCLASS140                 (-9 -8 -6 -5=.)
recode PCLASS141                 (-9 -8 -6 -5=.)
recode PCLASS142                 (-9 -8 -6 -5=.)
recode PCLASS143                 (-9 -8 -6 -5=.)
recode PCLASS144                 (-9 -8 -6 -5=.)
recode PCLASS145                 (-9 -8 -6 -5=.)
recode PCLASS146                 (-9 -8 -6 -5=.)
recode PCLASS147                 (-9 -8 -6 -5=.)
recode PCLASS148                 (-9 -8 -6 -5=.)
recode PCLASS149                 (-9 -8 -6 -5=.)
recode PCLASS150                 (-9 -8 -6 -5=.)
recode PCLASS151                 (-9 -8 -6 -5=.)
recode PCLASS152                 (-9 -8 -6 -5=.)
recode PCLASS153                 (-9 -8 -6 -5=.)
recode PCLASS154                 (-9 -8 -6 -5=.)
recode PCLASS155                 (-9 -8 -6 -5=.)
recode PCLASS156                 (-9 -8 -6 -5=.)
recode PCLASS157                 (-9 -8 -6 -5=.)
recode PCLASS158                 (-9 -8 -6 -5=.)
recode PCLASS159                 (-9 -8 -6 -5=.)
recode PCLASS160                 (-9 -8 -6 -5=.)
recode PCLASS161                 (-9 -8 -6 -5=.)
recode PCLASS162                 (-9 -8 -6 -5=.)
recode PCLASS163                 (-9 -8 -6 -5=.)
recode PCLASS164                 (-9 -8 -6 -5=.)
recode PCLASS165                 (-9 -8 -6 -5=.)
recode PCLASS166                 (-9 -8 -6 -5=.)
recode PCLASS167                 (-9 -8 -6 -5=.)
recode PCLASS168                 (-9 -8 -6 -5=.)
recode PCLASS169                 (-9 -8 -6 -5=.)
recode PCLASS170                 (-9 -8 -6 -5=.)
recode PCLASS171                 (-9 -8 -6 -5=.)
recode PCLASS172                 (-9 -8 -6 -5=.)
recode PCLASS173                 (-9 -8 -6 -5=.)
recode PCLASS174                 (-9 -8 -6 -5=.)
recode PCLASS175                 (-9 -8 -6 -5=.)
recode PCLASS176                 (-9 -8 -6 -5=.)
recode PCLASS177                 (-9 -8 -6 -5=.)
recode PCLASS178                 (-9 -8 -6 -5=.)
recode PCLASS179                 (-9 -8 -6 -5=.)
recode PCLASS180                 (-9 -8 -6 -5=.)
recode PCLASS181                 (-9 -8 -6 -5=.)
recode PCLASS182                 (-9 -8 -6 -5=.)
recode PCLASS183                 (-9 -8 -6 -5=.)
recode PCLASS184                 (-9 -8 -6 -5=.)
recode PCLASS185                 (-9 -8 -6 -5=.)
recode PCLASS186                 (-9 -8 -6 -5=.)
recode PCLASS187                 (-9 -8 -6 -5=.)
recode PCLASS188                 (-9 -8 -6 -5=.)
recode PCLASS189                 (-9 -8 -6 -5=.)
recode PCLASS190                 (-9 -8 -6 -5=.)
recode PCLASS191                 (-9 -8 -6 -5=.)
recode PCLASS192                 (-9 -8 -6 -5=.)
recode PCLASS193                 (-9 -8 -6 -5=.)
recode PCLASS194                 (-9 -8 -6 -5=.)
recode PCLASS195                 (-9 -8 -6 -5=.)
recode PCLASS196                 (-9 -8 -6 -5=.)
recode PCLASS197                 (-9 -8 -6 -5=.)
recode PCLASS198                 (-9 -8 -6 -5=.)
recode PCLASS199                 (-9 -8 -6 -5=.)
recode PCLASS200                 (-9 -8 -6 -5=.)
recode DXCCSR_BLD001             (-99 -88 -66=.)
recode DXCCSR_BLD002             (-99 -88 -66=.)
recode DXCCSR_BLD003             (-99 -88 -66=.)
recode DXCCSR_BLD004             (-99 -88 -66=.)
recode DXCCSR_BLD005             (-99 -88 -66=.)
recode DXCCSR_BLD006             (-99 -88 -66=.)
recode DXCCSR_BLD007             (-99 -88 -66=.)
recode DXCCSR_BLD008             (-99 -88 -66=.)
recode DXCCSR_BLD009             (-99 -88 -66=.)
recode DXCCSR_BLD010             (-99 -88 -66=.)
recode DXCCSR_CIR001             (-99 -88 -66=.)
recode DXCCSR_CIR002             (-99 -88 -66=.)
recode DXCCSR_CIR003             (-99 -88 -66=.)
recode DXCCSR_CIR004             (-99 -88 -66=.)
recode DXCCSR_CIR005             (-99 -88 -66=.)
recode DXCCSR_CIR006             (-99 -88 -66=.)
recode DXCCSR_CIR007             (-99 -88 -66=.)
recode DXCCSR_CIR008             (-99 -88 -66=.)
recode DXCCSR_CIR009             (-99 -88 -66=.)
recode DXCCSR_CIR010             (-99 -88 -66=.)
recode DXCCSR_CIR011             (-99 -88 -66=.)
recode DXCCSR_CIR012             (-99 -88 -66=.)
recode DXCCSR_CIR013             (-99 -88 -66=.)
recode DXCCSR_CIR014             (-99 -88 -66=.)
recode DXCCSR_CIR015             (-99 -88 -66=.)
recode DXCCSR_CIR016             (-99 -88 -66=.)
recode DXCCSR_CIR017             (-99 -88 -66=.)
recode DXCCSR_CIR018             (-99 -88 -66=.)
recode DXCCSR_CIR019             (-99 -88 -66=.)
recode DXCCSR_CIR020             (-99 -88 -66=.)
recode DXCCSR_CIR021             (-99 -88 -66=.)
recode DXCCSR_CIR022             (-99 -88 -66=.)
recode DXCCSR_CIR023             (-99 -88 -66=.)
recode DXCCSR_CIR024             (-99 -88 -66=.)
recode DXCCSR_CIR025             (-99 -88 -66=.)
recode DXCCSR_CIR026             (-99 -88 -66=.)
recode DXCCSR_CIR027             (-99 -88 -66=.)
recode DXCCSR_CIR028             (-99 -88 -66=.)
recode DXCCSR_CIR029             (-99 -88 -66=.)
recode DXCCSR_CIR030             (-99 -88 -66=.)
recode DXCCSR_CIR031             (-99 -88 -66=.)
recode DXCCSR_CIR032             (-99 -88 -66=.)
recode DXCCSR_CIR033             (-99 -88 -66=.)
recode DXCCSR_CIR034             (-99 -88 -66=.)
recode DXCCSR_CIR035             (-99 -88 -66=.)
recode DXCCSR_CIR036             (-99 -88 -66=.)
recode DXCCSR_CIR037             (-99 -88 -66=.)
recode DXCCSR_CIR038             (-99 -88 -66=.)
recode DXCCSR_CIR039             (-99 -88 -66=.)
recode DXCCSR_DEN001             (-99 -88 -66=.)
recode DXCCSR_DEN002             (-99 -88 -66=.)
recode DXCCSR_DEN003             (-99 -88 -66=.)
recode DXCCSR_DIG001             (-99 -88 -66=.)
recode DXCCSR_DIG002             (-99 -88 -66=.)
recode DXCCSR_DIG003             (-99 -88 -66=.)
recode DXCCSR_DIG004             (-99 -88 -66=.)
recode DXCCSR_DIG005             (-99 -88 -66=.)
recode DXCCSR_DIG006             (-99 -88 -66=.)
recode DXCCSR_DIG007             (-99 -88 -66=.)
recode DXCCSR_DIG008             (-99 -88 -66=.)
recode DXCCSR_DIG009             (-99 -88 -66=.)
recode DXCCSR_DIG010             (-99 -88 -66=.)
recode DXCCSR_DIG011             (-99 -88 -66=.)
recode DXCCSR_DIG012             (-99 -88 -66=.)
recode DXCCSR_DIG013             (-99 -88 -66=.)
recode DXCCSR_DIG014             (-99 -88 -66=.)
recode DXCCSR_DIG015             (-99 -88 -66=.)
recode DXCCSR_DIG016             (-99 -88 -66=.)
recode DXCCSR_DIG017             (-99 -88 -66=.)
recode DXCCSR_DIG018             (-99 -88 -66=.)
recode DXCCSR_DIG019             (-99 -88 -66=.)
recode DXCCSR_DIG020             (-99 -88 -66=.)
recode DXCCSR_DIG021             (-99 -88 -66=.)
recode DXCCSR_DIG022             (-99 -88 -66=.)
recode DXCCSR_DIG023             (-99 -88 -66=.)
recode DXCCSR_DIG024             (-99 -88 -66=.)
recode DXCCSR_DIG025             (-99 -88 -66=.)
recode DXCCSR_EAR001             (-99 -88 -66=.)
recode DXCCSR_EAR002             (-99 -88 -66=.)
recode DXCCSR_EAR003             (-99 -88 -66=.)
recode DXCCSR_EAR004             (-99 -88 -66=.)
recode DXCCSR_EAR005             (-99 -88 -66=.)
recode DXCCSR_EAR006             (-99 -88 -66=.)
recode DXCCSR_END001             (-99 -88 -66=.)
recode DXCCSR_END002             (-99 -88 -66=.)
recode DXCCSR_END003             (-99 -88 -66=.)
recode DXCCSR_END004             (-99 -88 -66=.)
recode DXCCSR_END005             (-99 -88 -66=.)
recode DXCCSR_END006             (-99 -88 -66=.)
recode DXCCSR_END007             (-99 -88 -66=.)
recode DXCCSR_END008             (-99 -88 -66=.)
recode DXCCSR_END009             (-99 -88 -66=.)
recode DXCCSR_END010             (-99 -88 -66=.)
recode DXCCSR_END011             (-99 -88 -66=.)
recode DXCCSR_END012             (-99 -88 -66=.)
recode DXCCSR_END013             (-99 -88 -66=.)
recode DXCCSR_END014             (-99 -88 -66=.)
recode DXCCSR_END015             (-99 -88 -66=.)
recode DXCCSR_END016             (-99 -88 -66=.)
recode DXCCSR_END017             (-99 -88 -66=.)
recode DXCCSR_EXT001             (-99 -88 -66=.)
recode DXCCSR_EXT002             (-99 -88 -66=.)
recode DXCCSR_EXT003             (-99 -88 -66=.)
recode DXCCSR_EXT004             (-99 -88 -66=.)
recode DXCCSR_EXT005             (-99 -88 -66=.)
recode DXCCSR_EXT006             (-99 -88 -66=.)
recode DXCCSR_EXT007             (-99 -88 -66=.)
recode DXCCSR_EXT008             (-99 -88 -66=.)
recode DXCCSR_EXT009             (-99 -88 -66=.)
recode DXCCSR_EXT010             (-99 -88 -66=.)
recode DXCCSR_EXT011             (-99 -88 -66=.)
recode DXCCSR_EXT012             (-99 -88 -66=.)
recode DXCCSR_EXT013             (-99 -88 -66=.)
recode DXCCSR_EXT014             (-99 -88 -66=.)
recode DXCCSR_EXT015             (-99 -88 -66=.)
recode DXCCSR_EXT016             (-99 -88 -66=.)
recode DXCCSR_EXT017             (-99 -88 -66=.)
recode DXCCSR_EXT018             (-99 -88 -66=.)
recode DXCCSR_EXT019             (-99 -88 -66=.)
recode DXCCSR_EXT020             (-99 -88 -66=.)
recode DXCCSR_EXT021             (-99 -88 -66=.)
recode DXCCSR_EXT022             (-99 -88 -66=.)
recode DXCCSR_EXT023             (-99 -88 -66=.)
recode DXCCSR_EXT024             (-99 -88 -66=.)
recode DXCCSR_EXT025             (-99 -88 -66=.)
recode DXCCSR_EXT026             (-99 -88 -66=.)
recode DXCCSR_EXT027             (-99 -88 -66=.)
recode DXCCSR_EXT028             (-99 -88 -66=.)
recode DXCCSR_EXT029             (-99 -88 -66=.)
recode DXCCSR_EXT030             (-99 -88 -66=.)
recode DXCCSR_EYE001             (-99 -88 -66=.)
recode DXCCSR_EYE002             (-99 -88 -66=.)
recode DXCCSR_EYE003             (-99 -88 -66=.)
recode DXCCSR_EYE004             (-99 -88 -66=.)
recode DXCCSR_EYE005             (-99 -88 -66=.)
recode DXCCSR_EYE006             (-99 -88 -66=.)
recode DXCCSR_EYE007             (-99 -88 -66=.)
recode DXCCSR_EYE008             (-99 -88 -66=.)
recode DXCCSR_EYE009             (-99 -88 -66=.)
recode DXCCSR_EYE010             (-99 -88 -66=.)
recode DXCCSR_EYE011             (-99 -88 -66=.)
recode DXCCSR_EYE012             (-99 -88 -66=.)
recode DXCCSR_FAC001             (-99 -88 -66=.)
recode DXCCSR_FAC002             (-99 -88 -66=.)
recode DXCCSR_FAC003             (-99 -88 -66=.)
recode DXCCSR_FAC004             (-99 -88 -66=.)
recode DXCCSR_FAC005             (-99 -88 -66=.)
recode DXCCSR_FAC006             (-99 -88 -66=.)
recode DXCCSR_FAC007             (-99 -88 -66=.)
recode DXCCSR_FAC008             (-99 -88 -66=.)
recode DXCCSR_FAC009             (-99 -88 -66=.)
recode DXCCSR_FAC010             (-99 -88 -66=.)
recode DXCCSR_FAC011             (-99 -88 -66=.)
recode DXCCSR_FAC012             (-99 -88 -66=.)
recode DXCCSR_FAC013             (-99 -88 -66=.)
recode DXCCSR_FAC014             (-99 -88 -66=.)
recode DXCCSR_FAC015             (-99 -88 -66=.)
recode DXCCSR_FAC016             (-99 -88 -66=.)
recode DXCCSR_FAC017             (-99 -88 -66=.)
recode DXCCSR_FAC018             (-99 -88 -66=.)
recode DXCCSR_FAC019             (-99 -88 -66=.)
recode DXCCSR_FAC020             (-99 -88 -66=.)
recode DXCCSR_FAC021             (-99 -88 -66=.)
recode DXCCSR_FAC022             (-99 -88 -66=.)
recode DXCCSR_FAC023             (-99 -88 -66=.)
recode DXCCSR_FAC024             (-99 -88 -66=.)
recode DXCCSR_FAC025             (-99 -88 -66=.)
recode DXCCSR_GEN001             (-99 -88 -66=.)
recode DXCCSR_GEN002             (-99 -88 -66=.)
recode DXCCSR_GEN003             (-99 -88 -66=.)
recode DXCCSR_GEN004             (-99 -88 -66=.)
recode DXCCSR_GEN005             (-99 -88 -66=.)
recode DXCCSR_GEN006             (-99 -88 -66=.)
recode DXCCSR_GEN007             (-99 -88 -66=.)
recode DXCCSR_GEN008             (-99 -88 -66=.)
recode DXCCSR_GEN009             (-99 -88 -66=.)
recode DXCCSR_GEN010             (-99 -88 -66=.)
recode DXCCSR_GEN011             (-99 -88 -66=.)
recode DXCCSR_GEN012             (-99 -88 -66=.)
recode DXCCSR_GEN013             (-99 -88 -66=.)
recode DXCCSR_GEN014             (-99 -88 -66=.)
recode DXCCSR_GEN015             (-99 -88 -66=.)
recode DXCCSR_GEN016             (-99 -88 -66=.)
recode DXCCSR_GEN017             (-99 -88 -66=.)
recode DXCCSR_GEN018             (-99 -88 -66=.)
recode DXCCSR_GEN019             (-99 -88 -66=.)
recode DXCCSR_GEN020             (-99 -88 -66=.)
recode DXCCSR_GEN021             (-99 -88 -66=.)
recode DXCCSR_GEN022             (-99 -88 -66=.)
recode DXCCSR_GEN023             (-99 -88 -66=.)
recode DXCCSR_GEN024             (-99 -88 -66=.)
recode DXCCSR_GEN025             (-99 -88 -66=.)
recode DXCCSR_GEN026             (-99 -88 -66=.)
recode DXCCSR_INF001             (-99 -88 -66=.)
recode DXCCSR_INF002             (-99 -88 -66=.)
recode DXCCSR_INF003             (-99 -88 -66=.)
recode DXCCSR_INF004             (-99 -88 -66=.)
recode DXCCSR_INF005             (-99 -88 -66=.)
recode DXCCSR_INF006             (-99 -88 -66=.)
recode DXCCSR_INF007             (-99 -88 -66=.)
recode DXCCSR_INF008             (-99 -88 -66=.)
recode DXCCSR_INF009             (-99 -88 -66=.)
recode DXCCSR_INF010             (-99 -88 -66=.)
recode DXCCSR_INF011             (-99 -88 -66=.)
recode DXCCSR_INF012             (-99 -88 -66=.)
recode DXCCSR_INJ001             (-99 -88 -66=.)
recode DXCCSR_INJ002             (-99 -88 -66=.)
recode DXCCSR_INJ003             (-99 -88 -66=.)
recode DXCCSR_INJ004             (-99 -88 -66=.)
recode DXCCSR_INJ005             (-99 -88 -66=.)
recode DXCCSR_INJ006             (-99 -88 -66=.)
recode DXCCSR_INJ007             (-99 -88 -66=.)
recode DXCCSR_INJ008             (-99 -88 -66=.)
recode DXCCSR_INJ009             (-99 -88 -66=.)
recode DXCCSR_INJ010             (-99 -88 -66=.)
recode DXCCSR_INJ011             (-99 -88 -66=.)
recode DXCCSR_INJ012             (-99 -88 -66=.)
recode DXCCSR_INJ013             (-99 -88 -66=.)
recode DXCCSR_INJ014             (-99 -88 -66=.)
recode DXCCSR_INJ015             (-99 -88 -66=.)
recode DXCCSR_INJ016             (-99 -88 -66=.)
recode DXCCSR_INJ017             (-99 -88 -66=.)
recode DXCCSR_INJ018             (-99 -88 -66=.)
recode DXCCSR_INJ019             (-99 -88 -66=.)
recode DXCCSR_INJ020             (-99 -88 -66=.)
recode DXCCSR_INJ021             (-99 -88 -66=.)
recode DXCCSR_INJ022             (-99 -88 -66=.)
recode DXCCSR_INJ023             (-99 -88 -66=.)
recode DXCCSR_INJ024             (-99 -88 -66=.)
recode DXCCSR_INJ025             (-99 -88 -66=.)
recode DXCCSR_INJ026             (-99 -88 -66=.)
recode DXCCSR_INJ027             (-99 -88 -66=.)
recode DXCCSR_INJ028             (-99 -88 -66=.)
recode DXCCSR_INJ029             (-99 -88 -66=.)
recode DXCCSR_INJ030             (-99 -88 -66=.)
recode DXCCSR_INJ031             (-99 -88 -66=.)
recode DXCCSR_INJ032             (-99 -88 -66=.)
recode DXCCSR_INJ033             (-99 -88 -66=.)
recode DXCCSR_INJ034             (-99 -88 -66=.)
recode DXCCSR_INJ035             (-99 -88 -66=.)
recode DXCCSR_INJ036             (-99 -88 -66=.)
recode DXCCSR_INJ037             (-99 -88 -66=.)
recode DXCCSR_INJ038             (-99 -88 -66=.)
recode DXCCSR_INJ039             (-99 -88 -66=.)
recode DXCCSR_INJ040             (-99 -88 -66=.)
recode DXCCSR_INJ041             (-99 -88 -66=.)
recode DXCCSR_INJ042             (-99 -88 -66=.)
recode DXCCSR_INJ043             (-99 -88 -66=.)
recode DXCCSR_INJ044             (-99 -88 -66=.)
recode DXCCSR_INJ045             (-99 -88 -66=.)
recode DXCCSR_INJ046             (-99 -88 -66=.)
recode DXCCSR_INJ047             (-99 -88 -66=.)
recode DXCCSR_INJ048             (-99 -88 -66=.)
recode DXCCSR_INJ049             (-99 -88 -66=.)
recode DXCCSR_INJ050             (-99 -88 -66=.)
recode DXCCSR_INJ051             (-99 -88 -66=.)
recode DXCCSR_INJ052             (-99 -88 -66=.)
recode DXCCSR_INJ053             (-99 -88 -66=.)
recode DXCCSR_INJ054             (-99 -88 -66=.)
recode DXCCSR_INJ055             (-99 -88 -66=.)
recode DXCCSR_INJ056             (-99 -88 -66=.)
recode DXCCSR_INJ057             (-99 -88 -66=.)
recode DXCCSR_INJ058             (-99 -88 -66=.)
recode DXCCSR_INJ059             (-99 -88 -66=.)
recode DXCCSR_INJ060             (-99 -88 -66=.)
recode DXCCSR_INJ061             (-99 -88 -66=.)
recode DXCCSR_INJ062             (-99 -88 -66=.)
recode DXCCSR_INJ063             (-99 -88 -66=.)
recode DXCCSR_INJ064             (-99 -88 -66=.)
recode DXCCSR_INJ065             (-99 -88 -66=.)
recode DXCCSR_INJ066             (-99 -88 -66=.)
recode DXCCSR_INJ067             (-99 -88 -66=.)
recode DXCCSR_INJ068             (-99 -88 -66=.)
recode DXCCSR_INJ069             (-99 -88 -66=.)
recode DXCCSR_INJ070             (-99 -88 -66=.)
recode DXCCSR_INJ071             (-99 -88 -66=.)
recode DXCCSR_INJ072             (-99 -88 -66=.)
recode DXCCSR_INJ073             (-99 -88 -66=.)
recode DXCCSR_INJ074             (-99 -88 -66=.)
recode DXCCSR_INJ075             (-99 -88 -66=.)
recode DXCCSR_INJ076             (-99 -88 -66=.)
recode DXCCSR_MAL001             (-99 -88 -66=.)
recode DXCCSR_MAL002             (-99 -88 -66=.)
recode DXCCSR_MAL003             (-99 -88 -66=.)
recode DXCCSR_MAL004             (-99 -88 -66=.)
recode DXCCSR_MAL005             (-99 -88 -66=.)
recode DXCCSR_MAL006             (-99 -88 -66=.)
recode DXCCSR_MAL007             (-99 -88 -66=.)
recode DXCCSR_MAL008             (-99 -88 -66=.)
recode DXCCSR_MAL009             (-99 -88 -66=.)
recode DXCCSR_MAL010             (-99 -88 -66=.)
recode DXCCSR_MBD001             (-99 -88 -66=.)
recode DXCCSR_MBD002             (-99 -88 -66=.)
recode DXCCSR_MBD003             (-99 -88 -66=.)
recode DXCCSR_MBD004             (-99 -88 -66=.)
recode DXCCSR_MBD005             (-99 -88 -66=.)
recode DXCCSR_MBD006             (-99 -88 -66=.)
recode DXCCSR_MBD007             (-99 -88 -66=.)
recode DXCCSR_MBD008             (-99 -88 -66=.)
recode DXCCSR_MBD009             (-99 -88 -66=.)
recode DXCCSR_MBD010             (-99 -88 -66=.)
recode DXCCSR_MBD011             (-99 -88 -66=.)
recode DXCCSR_MBD012             (-99 -88 -66=.)
recode DXCCSR_MBD013             (-99 -88 -66=.)
recode DXCCSR_MBD014             (-99 -88 -66=.)
recode DXCCSR_MBD017             (-99 -88 -66=.)
recode DXCCSR_MBD018             (-99 -88 -66=.)
recode DXCCSR_MBD019             (-99 -88 -66=.)
recode DXCCSR_MBD020             (-99 -88 -66=.)
recode DXCCSR_MBD021             (-99 -88 -66=.)
recode DXCCSR_MBD022             (-99 -88 -66=.)
recode DXCCSR_MBD023             (-99 -88 -66=.)
recode DXCCSR_MBD024             (-99 -88 -66=.)
recode DXCCSR_MBD025             (-99 -88 -66=.)
recode DXCCSR_MBD026             (-99 -88 -66=.)
recode DXCCSR_MBD027             (-99 -88 -66=.)
recode DXCCSR_MBD028             (-99 -88 -66=.)
recode DXCCSR_MBD029             (-99 -88 -66=.)
recode DXCCSR_MBD030             (-99 -88 -66=.)
recode DXCCSR_MBD031             (-99 -88 -66=.)
recode DXCCSR_MBD032             (-99 -88 -66=.)
recode DXCCSR_MBD033             (-99 -88 -66=.)
recode DXCCSR_MBD034             (-99 -88 -66=.)
recode DXCCSR_MUS001             (-99 -88 -66=.)
recode DXCCSR_MUS002             (-99 -88 -66=.)
recode DXCCSR_MUS003             (-99 -88 -66=.)
recode DXCCSR_MUS004             (-99 -88 -66=.)
recode DXCCSR_MUS005             (-99 -88 -66=.)
recode DXCCSR_MUS006             (-99 -88 -66=.)
recode DXCCSR_MUS007             (-99 -88 -66=.)
recode DXCCSR_MUS008             (-99 -88 -66=.)
recode DXCCSR_MUS009             (-99 -88 -66=.)
recode DXCCSR_MUS010             (-99 -88 -66=.)
recode DXCCSR_MUS011             (-99 -88 -66=.)
recode DXCCSR_MUS012             (-99 -88 -66=.)
recode DXCCSR_MUS013             (-99 -88 -66=.)
recode DXCCSR_MUS014             (-99 -88 -66=.)
recode DXCCSR_MUS015             (-99 -88 -66=.)
recode DXCCSR_MUS016             (-99 -88 -66=.)
recode DXCCSR_MUS017             (-99 -88 -66=.)
recode DXCCSR_MUS018             (-99 -88 -66=.)
recode DXCCSR_MUS019             (-99 -88 -66=.)
recode DXCCSR_MUS020             (-99 -88 -66=.)
recode DXCCSR_MUS021             (-99 -88 -66=.)
recode DXCCSR_MUS022             (-99 -88 -66=.)
recode DXCCSR_MUS023             (-99 -88 -66=.)
recode DXCCSR_MUS024             (-99 -88 -66=.)
recode DXCCSR_MUS025             (-99 -88 -66=.)
recode DXCCSR_MUS026             (-99 -88 -66=.)
recode DXCCSR_MUS027             (-99 -88 -66=.)
recode DXCCSR_MUS028             (-99 -88 -66=.)
recode DXCCSR_MUS029             (-99 -88 -66=.)
recode DXCCSR_MUS030             (-99 -88 -66=.)
recode DXCCSR_MUS031             (-99 -88 -66=.)
recode DXCCSR_MUS032             (-99 -88 -66=.)
recode DXCCSR_MUS033             (-99 -88 -66=.)
recode DXCCSR_MUS034             (-99 -88 -66=.)
recode DXCCSR_MUS035             (-99 -88 -66=.)
recode DXCCSR_MUS036             (-99 -88 -66=.)
recode DXCCSR_MUS037             (-99 -88 -66=.)
recode DXCCSR_MUS038             (-99 -88 -66=.)
recode DXCCSR_NEO001             (-99 -88 -66=.)
recode DXCCSR_NEO002             (-99 -88 -66=.)
recode DXCCSR_NEO003             (-99 -88 -66=.)
recode DXCCSR_NEO004             (-99 -88 -66=.)
recode DXCCSR_NEO005             (-99 -88 -66=.)
recode DXCCSR_NEO006             (-99 -88 -66=.)
recode DXCCSR_NEO007             (-99 -88 -66=.)
recode DXCCSR_NEO008             (-99 -88 -66=.)
recode DXCCSR_NEO009             (-99 -88 -66=.)
recode DXCCSR_NEO010             (-99 -88 -66=.)
recode DXCCSR_NEO011             (-99 -88 -66=.)
recode DXCCSR_NEO012             (-99 -88 -66=.)
recode DXCCSR_NEO013             (-99 -88 -66=.)
recode DXCCSR_NEO014             (-99 -88 -66=.)
recode DXCCSR_NEO015             (-99 -88 -66=.)
recode DXCCSR_NEO016             (-99 -88 -66=.)
recode DXCCSR_NEO017             (-99 -88 -66=.)
recode DXCCSR_NEO018             (-99 -88 -66=.)
recode DXCCSR_NEO019             (-99 -88 -66=.)
recode DXCCSR_NEO020             (-99 -88 -66=.)
recode DXCCSR_NEO021             (-99 -88 -66=.)
recode DXCCSR_NEO022             (-99 -88 -66=.)
recode DXCCSR_NEO023             (-99 -88 -66=.)
recode DXCCSR_NEO024             (-99 -88 -66=.)
recode DXCCSR_NEO025             (-99 -88 -66=.)
recode DXCCSR_NEO026             (-99 -88 -66=.)
recode DXCCSR_NEO027             (-99 -88 -66=.)
recode DXCCSR_NEO028             (-99 -88 -66=.)
recode DXCCSR_NEO029             (-99 -88 -66=.)
recode DXCCSR_NEO030             (-99 -88 -66=.)
recode DXCCSR_NEO031             (-99 -88 -66=.)
recode DXCCSR_NEO032             (-99 -88 -66=.)
recode DXCCSR_NEO033             (-99 -88 -66=.)
recode DXCCSR_NEO034             (-99 -88 -66=.)
recode DXCCSR_NEO035             (-99 -88 -66=.)
recode DXCCSR_NEO036             (-99 -88 -66=.)
recode DXCCSR_NEO037             (-99 -88 -66=.)
recode DXCCSR_NEO038             (-99 -88 -66=.)
recode DXCCSR_NEO039             (-99 -88 -66=.)
recode DXCCSR_NEO040             (-99 -88 -66=.)
recode DXCCSR_NEO041             (-99 -88 -66=.)
recode DXCCSR_NEO042             (-99 -88 -66=.)
recode DXCCSR_NEO043             (-99 -88 -66=.)
recode DXCCSR_NEO044             (-99 -88 -66=.)
recode DXCCSR_NEO045             (-99 -88 -66=.)
recode DXCCSR_NEO046             (-99 -88 -66=.)
recode DXCCSR_NEO047             (-99 -88 -66=.)
recode DXCCSR_NEO048             (-99 -88 -66=.)
recode DXCCSR_NEO049             (-99 -88 -66=.)
recode DXCCSR_NEO050             (-99 -88 -66=.)
recode DXCCSR_NEO051             (-99 -88 -66=.)
recode DXCCSR_NEO052             (-99 -88 -66=.)
recode DXCCSR_NEO053             (-99 -88 -66=.)
recode DXCCSR_NEO054             (-99 -88 -66=.)
recode DXCCSR_NEO055             (-99 -88 -66=.)
recode DXCCSR_NEO056             (-99 -88 -66=.)
recode DXCCSR_NEO057             (-99 -88 -66=.)
recode DXCCSR_NEO058             (-99 -88 -66=.)
recode DXCCSR_NEO059             (-99 -88 -66=.)
recode DXCCSR_NEO060             (-99 -88 -66=.)
recode DXCCSR_NEO061             (-99 -88 -66=.)
recode DXCCSR_NEO062             (-99 -88 -66=.)
recode DXCCSR_NEO063             (-99 -88 -66=.)
recode DXCCSR_NEO064             (-99 -88 -66=.)
recode DXCCSR_NEO065             (-99 -88 -66=.)
recode DXCCSR_NEO066             (-99 -88 -66=.)
recode DXCCSR_NEO067             (-99 -88 -66=.)
recode DXCCSR_NEO068             (-99 -88 -66=.)
recode DXCCSR_NEO069             (-99 -88 -66=.)
recode DXCCSR_NEO070             (-99 -88 -66=.)
recode DXCCSR_NEO071             (-99 -88 -66=.)
recode DXCCSR_NEO072             (-99 -88 -66=.)
recode DXCCSR_NEO073             (-99 -88 -66=.)
recode DXCCSR_NEO074             (-99 -88 -66=.)
recode DXCCSR_NVS001             (-99 -88 -66=.)
recode DXCCSR_NVS002             (-99 -88 -66=.)
recode DXCCSR_NVS003             (-99 -88 -66=.)
recode DXCCSR_NVS004             (-99 -88 -66=.)
recode DXCCSR_NVS005             (-99 -88 -66=.)
recode DXCCSR_NVS006             (-99 -88 -66=.)
recode DXCCSR_NVS007             (-99 -88 -66=.)
recode DXCCSR_NVS008             (-99 -88 -66=.)
recode DXCCSR_NVS009             (-99 -88 -66=.)
recode DXCCSR_NVS010             (-99 -88 -66=.)
recode DXCCSR_NVS011             (-99 -88 -66=.)
recode DXCCSR_NVS012             (-99 -88 -66=.)
recode DXCCSR_NVS013             (-99 -88 -66=.)
recode DXCCSR_NVS014             (-99 -88 -66=.)
recode DXCCSR_NVS015             (-99 -88 -66=.)
recode DXCCSR_NVS016             (-99 -88 -66=.)
recode DXCCSR_NVS017             (-99 -88 -66=.)
recode DXCCSR_NVS018             (-99 -88 -66=.)
recode DXCCSR_NVS019             (-99 -88 -66=.)
recode DXCCSR_NVS020             (-99 -88 -66=.)
recode DXCCSR_NVS021             (-99 -88 -66=.)
recode DXCCSR_NVS022             (-99 -88 -66=.)
recode DXCCSR_PNL001             (-99 -88 -66=.)
recode DXCCSR_PNL002             (-99 -88 -66=.)
recode DXCCSR_PNL003             (-99 -88 -66=.)
recode DXCCSR_PNL004             (-99 -88 -66=.)
recode DXCCSR_PNL005             (-99 -88 -66=.)
recode DXCCSR_PNL006             (-99 -88 -66=.)
recode DXCCSR_PNL007             (-99 -88 -66=.)
recode DXCCSR_PNL008             (-99 -88 -66=.)
recode DXCCSR_PNL009             (-99 -88 -66=.)
recode DXCCSR_PNL010             (-99 -88 -66=.)
recode DXCCSR_PNL011             (-99 -88 -66=.)
recode DXCCSR_PNL012             (-99 -88 -66=.)
recode DXCCSR_PNL013             (-99 -88 -66=.)
recode DXCCSR_PNL014             (-99 -88 -66=.)
recode DXCCSR_PNL015             (-99 -88 -66=.)
recode DXCCSR_PRG001             (-99 -88 -66=.)
recode DXCCSR_PRG002             (-99 -88 -66=.)
recode DXCCSR_PRG003             (-99 -88 -66=.)
recode DXCCSR_PRG004             (-99 -88 -66=.)
recode DXCCSR_PRG005             (-99 -88 -66=.)
recode DXCCSR_PRG006             (-99 -88 -66=.)
recode DXCCSR_PRG007             (-99 -88 -66=.)
recode DXCCSR_PRG008             (-99 -88 -66=.)
recode DXCCSR_PRG009             (-99 -88 -66=.)
recode DXCCSR_PRG010             (-99 -88 -66=.)
recode DXCCSR_PRG011             (-99 -88 -66=.)
recode DXCCSR_PRG012             (-99 -88 -66=.)
recode DXCCSR_PRG013             (-99 -88 -66=.)
recode DXCCSR_PRG014             (-99 -88 -66=.)
recode DXCCSR_PRG015             (-99 -88 -66=.)
recode DXCCSR_PRG016             (-99 -88 -66=.)
recode DXCCSR_PRG017             (-99 -88 -66=.)
recode DXCCSR_PRG018             (-99 -88 -66=.)
recode DXCCSR_PRG019             (-99 -88 -66=.)
recode DXCCSR_PRG020             (-99 -88 -66=.)
recode DXCCSR_PRG021             (-99 -88 -66=.)
recode DXCCSR_PRG022             (-99 -88 -66=.)
recode DXCCSR_PRG023             (-99 -88 -66=.)
recode DXCCSR_PRG024             (-99 -88 -66=.)
recode DXCCSR_PRG025             (-99 -88 -66=.)
recode DXCCSR_PRG026             (-99 -88 -66=.)
recode DXCCSR_PRG027             (-99 -88 -66=.)
recode DXCCSR_PRG028             (-99 -88 -66=.)
recode DXCCSR_PRG029             (-99 -88 -66=.)
recode DXCCSR_PRG030             (-99 -88 -66=.)
recode DXCCSR_RSP001             (-99 -88 -66=.)
recode DXCCSR_RSP002             (-99 -88 -66=.)
recode DXCCSR_RSP003             (-99 -88 -66=.)
recode DXCCSR_RSP004             (-99 -88 -66=.)
recode DXCCSR_RSP005             (-99 -88 -66=.)
recode DXCCSR_RSP006             (-99 -88 -66=.)
recode DXCCSR_RSP007             (-99 -88 -66=.)
recode DXCCSR_RSP008             (-99 -88 -66=.)
recode DXCCSR_RSP009             (-99 -88 -66=.)
recode DXCCSR_RSP010             (-99 -88 -66=.)
recode DXCCSR_RSP011             (-99 -88 -66=.)
recode DXCCSR_RSP012             (-99 -88 -66=.)
recode DXCCSR_RSP013             (-99 -88 -66=.)
recode DXCCSR_RSP014             (-99 -88 -66=.)
recode DXCCSR_RSP015             (-99 -88 -66=.)
recode DXCCSR_RSP016             (-99 -88 -66=.)
recode DXCCSR_RSP017             (-99 -88 -66=.)
recode DXCCSR_SKN001             (-99 -88 -66=.)
recode DXCCSR_SKN002             (-99 -88 -66=.)
recode DXCCSR_SKN003             (-99 -88 -66=.)
recode DXCCSR_SKN004             (-99 -88 -66=.)
recode DXCCSR_SKN005             (-99 -88 -66=.)
recode DXCCSR_SKN006             (-99 -88 -66=.)
recode DXCCSR_SKN007             (-99 -88 -66=.)
recode DXCCSR_SYM001             (-99 -88 -66=.)
recode DXCCSR_SYM002             (-99 -88 -66=.)
recode DXCCSR_SYM003             (-99 -88 -66=.)
recode DXCCSR_SYM004             (-99 -88 -66=.)
recode DXCCSR_SYM005             (-99 -88 -66=.)
recode DXCCSR_SYM006             (-99 -88 -66=.)
recode DXCCSR_SYM007             (-99 -88 -66=.)
recode DXCCSR_SYM008             (-99 -88 -66=.)
recode DXCCSR_SYM009             (-99 -88 -66=.)
recode DXCCSR_SYM010             (-99 -88 -66=.)
recode DXCCSR_SYM011             (-99 -88 -66=.)
recode DXCCSR_SYM012             (-99 -88 -66=.)
recode DXCCSR_SYM013             (-99 -88 -66=.)
recode DXCCSR_SYM014             (-99 -88 -66=.)
recode DXCCSR_SYM015             (-99 -88 -66=.)
recode DXCCSR_SYM016             (-99 -88 -66=.)
recode DXCCSR_SYM017             (-99 -88 -66=.)
recode PRCCSR_ADM001             (-99 -88 -66=.)
recode PRCCSR_ADM002             (-99 -88 -66=.)
recode PRCCSR_ADM003             (-99 -88 -66=.)
recode PRCCSR_ADM004             (-99 -88 -66=.)
recode PRCCSR_ADM005             (-99 -88 -66=.)
recode PRCCSR_ADM006             (-99 -88 -66=.)
recode PRCCSR_ADM007             (-99 -88 -66=.)
recode PRCCSR_ADM008             (-99 -88 -66=.)
recode PRCCSR_ADM009             (-99 -88 -66=.)
recode PRCCSR_ADM010             (-99 -88 -66=.)
recode PRCCSR_ADM011             (-99 -88 -66=.)
recode PRCCSR_ADM012             (-99 -88 -66=.)
recode PRCCSR_ADM013             (-99 -88 -66=.)
recode PRCCSR_ADM014             (-99 -88 -66=.)
recode PRCCSR_ADM015             (-99 -88 -66=.)
recode PRCCSR_ADM016             (-99 -88 -66=.)
recode PRCCSR_ADM017             (-99 -88 -66=.)
recode PRCCSR_ADM018             (-99 -88 -66=.)
recode PRCCSR_ADM019             (-99 -88 -66=.)
recode PRCCSR_ADM020             (-99 -88 -66=.)
recode PRCCSR_ADM021             (-99 -88 -66=.)
recode PRCCSR_ADM022             (-99 -88 -66=.)
recode PRCCSR_CAR001             (-99 -88 -66=.)
recode PRCCSR_CAR002             (-99 -88 -66=.)
recode PRCCSR_CAR003             (-99 -88 -66=.)
recode PRCCSR_CAR004             (-99 -88 -66=.)
recode PRCCSR_CAR005             (-99 -88 -66=.)
recode PRCCSR_CAR006             (-99 -88 -66=.)
recode PRCCSR_CAR007             (-99 -88 -66=.)
recode PRCCSR_CAR008             (-99 -88 -66=.)
recode PRCCSR_CAR009             (-99 -88 -66=.)
recode PRCCSR_CAR010             (-99 -88 -66=.)
recode PRCCSR_CAR011             (-99 -88 -66=.)
recode PRCCSR_CAR012             (-99 -88 -66=.)
recode PRCCSR_CAR013             (-99 -88 -66=.)
recode PRCCSR_CAR014             (-99 -88 -66=.)
recode PRCCSR_CAR015             (-99 -88 -66=.)
recode PRCCSR_CAR016             (-99 -88 -66=.)
recode PRCCSR_CAR017             (-99 -88 -66=.)
recode PRCCSR_CAR018             (-99 -88 -66=.)
recode PRCCSR_CAR019             (-99 -88 -66=.)
recode PRCCSR_CAR020             (-99 -88 -66=.)
recode PRCCSR_CAR021             (-99 -88 -66=.)
recode PRCCSR_CAR022             (-99 -88 -66=.)
recode PRCCSR_CAR023             (-99 -88 -66=.)
recode PRCCSR_CAR024             (-99 -88 -66=.)
recode PRCCSR_CAR025             (-99 -88 -66=.)
recode PRCCSR_CAR026             (-99 -88 -66=.)
recode PRCCSR_CAR027             (-99 -88 -66=.)
recode PRCCSR_CAR028             (-99 -88 -66=.)
recode PRCCSR_CAR029             (-99 -88 -66=.)
recode PRCCSR_CHP001             (-99 -88 -66=.)
recode PRCCSR_CNS001             (-99 -88 -66=.)
recode PRCCSR_CNS002             (-99 -88 -66=.)
recode PRCCSR_CNS003             (-99 -88 -66=.)
recode PRCCSR_CNS004             (-99 -88 -66=.)
recode PRCCSR_CNS005             (-99 -88 -66=.)
recode PRCCSR_CNS006             (-99 -88 -66=.)
recode PRCCSR_CNS007             (-99 -88 -66=.)
recode PRCCSR_CNS008             (-99 -88 -66=.)
recode PRCCSR_CNS009             (-99 -88 -66=.)
recode PRCCSR_CNS010             (-99 -88 -66=.)
recode PRCCSR_CNS011             (-99 -88 -66=.)
recode PRCCSR_CNS012             (-99 -88 -66=.)
recode PRCCSR_CNS013             (-99 -88 -66=.)
recode PRCCSR_CNS014             (-99 -88 -66=.)
recode PRCCSR_ENP001             (-99 -88 -66=.)
recode PRCCSR_ENP002             (-99 -88 -66=.)
recode PRCCSR_ENP003             (-99 -88 -66=.)
recode PRCCSR_ENP004             (-99 -88 -66=.)
recode PRCCSR_ENP005             (-99 -88 -66=.)
recode PRCCSR_ENP006             (-99 -88 -66=.)
recode PRCCSR_ENT001             (-99 -88 -66=.)
recode PRCCSR_ENT002             (-99 -88 -66=.)
recode PRCCSR_ENT003             (-99 -88 -66=.)
recode PRCCSR_ENT004             (-99 -88 -66=.)
recode PRCCSR_ENT005             (-99 -88 -66=.)
recode PRCCSR_ENT006             (-99 -88 -66=.)
recode PRCCSR_ENT007             (-99 -88 -66=.)
recode PRCCSR_ENT008             (-99 -88 -66=.)
recode PRCCSR_ENT009             (-99 -88 -66=.)
recode PRCCSR_ENT010             (-99 -88 -66=.)
recode PRCCSR_ENT011             (-99 -88 -66=.)
recode PRCCSR_ENT012             (-99 -88 -66=.)
recode PRCCSR_ENT013             (-99 -88 -66=.)
recode PRCCSR_ENT014             (-99 -88 -66=.)
recode PRCCSR_ENT015             (-99 -88 -66=.)
recode PRCCSR_ENT016             (-99 -88 -66=.)
recode PRCCSR_ENT017             (-99 -88 -66=.)
recode PRCCSR_ESA001             (-99 -88 -66=.)
recode PRCCSR_ESA002             (-99 -88 -66=.)
recode PRCCSR_ESA003             (-99 -88 -66=.)
recode PRCCSR_ESA004             (-99 -88 -66=.)
recode PRCCSR_ESA005             (-99 -88 -66=.)
recode PRCCSR_ESA006             (-99 -88 -66=.)
recode PRCCSR_ESA007             (-99 -88 -66=.)
recode PRCCSR_ESA008             (-99 -88 -66=.)
recode PRCCSR_ESA009             (-99 -88 -66=.)
recode PRCCSR_ESA010             (-99 -88 -66=.)
recode PRCCSR_ESA011             (-99 -88 -66=.)
recode PRCCSR_EST001             (-99 -88 -66=.)
recode PRCCSR_EST002             (-99 -88 -66=.)
recode PRCCSR_EST003             (-99 -88 -66=.)
recode PRCCSR_EST004             (-99 -88 -66=.)
recode PRCCSR_EST005             (-99 -88 -66=.)
recode PRCCSR_EYP001             (-99 -88 -66=.)
recode PRCCSR_EYP002             (-99 -88 -66=.)
recode PRCCSR_FRS001             (-99 -88 -66=.)
recode PRCCSR_FRS002             (-99 -88 -66=.)
recode PRCCSR_FRS003             (-99 -88 -66=.)
recode PRCCSR_FRS004             (-99 -88 -66=.)
recode PRCCSR_FRS005             (-99 -88 -66=.)
recode PRCCSR_FRS006             (-99 -88 -66=.)
recode PRCCSR_FRS007             (-99 -88 -66=.)
recode PRCCSR_FRS008             (-99 -88 -66=.)
recode PRCCSR_FRS009             (-99 -88 -66=.)
recode PRCCSR_FRS010             (-99 -88 -66=.)
recode PRCCSR_FRS011             (-99 -88 -66=.)
recode PRCCSR_FRS012             (-99 -88 -66=.)
recode PRCCSR_FRS013             (-99 -88 -66=.)
recode PRCCSR_FRS014             (-99 -88 -66=.)
recode PRCCSR_FRS015             (-99 -88 -66=.)
recode PRCCSR_GIS001             (-99 -88 -66=.)
recode PRCCSR_GIS002             (-99 -88 -66=.)
recode PRCCSR_GIS003             (-99 -88 -66=.)
recode PRCCSR_GIS004             (-99 -88 -66=.)
recode PRCCSR_GIS005             (-99 -88 -66=.)
recode PRCCSR_GIS006             (-99 -88 -66=.)
recode PRCCSR_GIS007             (-99 -88 -66=.)
recode PRCCSR_GIS008             (-99 -88 -66=.)
recode PRCCSR_GIS009             (-99 -88 -66=.)
recode PRCCSR_GIS010             (-99 -88 -66=.)
recode PRCCSR_GIS011             (-99 -88 -66=.)
recode PRCCSR_GIS012             (-99 -88 -66=.)
recode PRCCSR_GIS013             (-99 -88 -66=.)
recode PRCCSR_GIS014             (-99 -88 -66=.)
recode PRCCSR_GIS015             (-99 -88 -66=.)
recode PRCCSR_GIS016             (-99 -88 -66=.)
recode PRCCSR_GIS017             (-99 -88 -66=.)
recode PRCCSR_GIS018             (-99 -88 -66=.)
recode PRCCSR_GIS019             (-99 -88 -66=.)
recode PRCCSR_GIS020             (-99 -88 -66=.)
recode PRCCSR_GIS021             (-99 -88 -66=.)
recode PRCCSR_GIS022             (-99 -88 -66=.)
recode PRCCSR_GIS023             (-99 -88 -66=.)
recode PRCCSR_GIS024             (-99 -88 -66=.)
recode PRCCSR_GIS025             (-99 -88 -66=.)
recode PRCCSR_GIS026             (-99 -88 -66=.)
recode PRCCSR_GIS027             (-99 -88 -66=.)
recode PRCCSR_GIS028             (-99 -88 -66=.)
recode PRCCSR_GIS029             (-99 -88 -66=.)
recode PRCCSR_GNR001             (-99 -88 -66=.)
recode PRCCSR_GNR002             (-99 -88 -66=.)
recode PRCCSR_GNR003             (-99 -88 -66=.)
recode PRCCSR_GNR004             (-99 -88 -66=.)
recode PRCCSR_GNR005             (-99 -88 -66=.)
recode PRCCSR_GNR006             (-99 -88 -66=.)
recode PRCCSR_GNR007             (-99 -88 -66=.)
recode PRCCSR_GNR008             (-99 -88 -66=.)
recode PRCCSR_GNR009             (-99 -88 -66=.)
recode PRCCSR_GNR010             (-99 -88 -66=.)
recode PRCCSR_HEP001             (-99 -88 -66=.)
recode PRCCSR_HEP002             (-99 -88 -66=.)
recode PRCCSR_HEP003             (-99 -88 -66=.)
recode PRCCSR_HEP004             (-99 -88 -66=.)
recode PRCCSR_HEP005             (-99 -88 -66=.)
recode PRCCSR_HEP006             (-99 -88 -66=.)
recode PRCCSR_HEP007             (-99 -88 -66=.)
recode PRCCSR_HEP008             (-99 -88 -66=.)
recode PRCCSR_HEP009             (-99 -88 -66=.)
recode PRCCSR_HEP010             (-99 -88 -66=.)
recode PRCCSR_HEP011             (-99 -88 -66=.)
recode PRCCSR_HEP012             (-99 -88 -66=.)
recode PRCCSR_HEP013             (-99 -88 -66=.)
recode PRCCSR_IMG001             (-99 -88 -66=.)
recode PRCCSR_IMG002             (-99 -88 -66=.)
recode PRCCSR_IMG003             (-99 -88 -66=.)
recode PRCCSR_IMG004             (-99 -88 -66=.)
recode PRCCSR_IMG005             (-99 -88 -66=.)
recode PRCCSR_IMG006             (-99 -88 -66=.)
recode PRCCSR_IMG007             (-99 -88 -66=.)
recode PRCCSR_IMG008             (-99 -88 -66=.)
recode PRCCSR_IMG009             (-99 -88 -66=.)
recode PRCCSR_IMG010             (-99 -88 -66=.)
recode PRCCSR_LYM001             (-99 -88 -66=.)
recode PRCCSR_LYM002             (-99 -88 -66=.)
recode PRCCSR_LYM003             (-99 -88 -66=.)
recode PRCCSR_LYM004             (-99 -88 -66=.)
recode PRCCSR_LYM005             (-99 -88 -66=.)
recode PRCCSR_LYM006             (-99 -88 -66=.)
recode PRCCSR_LYM007             (-99 -88 -66=.)
recode PRCCSR_LYM008             (-99 -88 -66=.)
recode PRCCSR_LYM009             (-99 -88 -66=.)
recode PRCCSR_LYM010             (-99 -88 -66=.)
recode PRCCSR_LYM011             (-99 -88 -66=.)
recode PRCCSR_MAM001             (-99 -88 -66=.)
recode PRCCSR_MAM002             (-99 -88 -66=.)
recode PRCCSR_MAM003             (-99 -88 -66=.)
recode PRCCSR_MAM004             (-99 -88 -66=.)
recode PRCCSR_MAM005             (-99 -88 -66=.)
recode PRCCSR_MAM006             (-99 -88 -66=.)
recode PRCCSR_MAM007             (-99 -88 -66=.)
recode PRCCSR_MAM008             (-99 -88 -66=.)
recode PRCCSR_MAM009             (-99 -88 -66=.)
recode PRCCSR_MAM010             (-99 -88 -66=.)
recode PRCCSR_MAM011             (-99 -88 -66=.)
recode PRCCSR_MAM012             (-99 -88 -66=.)
recode PRCCSR_MAM013             (-99 -88 -66=.)
recode PRCCSR_MAM014             (-99 -88 -66=.)
recode PRCCSR_MAM015             (-99 -88 -66=.)
recode PRCCSR_MHT001             (-99 -88 -66=.)
recode PRCCSR_MHT002             (-99 -88 -66=.)
recode PRCCSR_MHT003             (-99 -88 -66=.)
recode PRCCSR_MHT004             (-99 -88 -66=.)
recode PRCCSR_MHT005             (-99 -88 -66=.)
recode PRCCSR_MRS001             (-99 -88 -66=.)
recode PRCCSR_MRS002             (-99 -88 -66=.)
recode PRCCSR_MRS003             (-99 -88 -66=.)
recode PRCCSR_MRS004             (-99 -88 -66=.)
recode PRCCSR_MRS005             (-99 -88 -66=.)
recode PRCCSR_MRS006             (-99 -88 -66=.)
recode PRCCSR_MRS007             (-99 -88 -66=.)
recode PRCCSR_MST001             (-99 -88 -66=.)
recode PRCCSR_MST002             (-99 -88 -66=.)
recode PRCCSR_MST003             (-99 -88 -66=.)
recode PRCCSR_MST004             (-99 -88 -66=.)
recode PRCCSR_MST005             (-99 -88 -66=.)
recode PRCCSR_MST006             (-99 -88 -66=.)
recode PRCCSR_MST007             (-99 -88 -66=.)
recode PRCCSR_MST008             (-99 -88 -66=.)
recode PRCCSR_MST009             (-99 -88 -66=.)
recode PRCCSR_MST010             (-99 -88 -66=.)
recode PRCCSR_MST011             (-99 -88 -66=.)
recode PRCCSR_MST012             (-99 -88 -66=.)
recode PRCCSR_MST013             (-99 -88 -66=.)
recode PRCCSR_MST014             (-99 -88 -66=.)
recode PRCCSR_MST015             (-99 -88 -66=.)
recode PRCCSR_MST016             (-99 -88 -66=.)
recode PRCCSR_MST017             (-99 -88 -66=.)
recode PRCCSR_MST018             (-99 -88 -66=.)
recode PRCCSR_MST019             (-99 -88 -66=.)
recode PRCCSR_MST020             (-99 -88 -66=.)
recode PRCCSR_MST021             (-99 -88 -66=.)
recode PRCCSR_MST022             (-99 -88 -66=.)
recode PRCCSR_MST023             (-99 -88 -66=.)
recode PRCCSR_MST024             (-99 -88 -66=.)
recode PRCCSR_MST025             (-99 -88 -66=.)
recode PRCCSR_MST026             (-99 -88 -66=.)
recode PRCCSR_MST027             (-99 -88 -66=.)
recode PRCCSR_MST028             (-99 -88 -66=.)
recode PRCCSR_MST029             (-99 -88 -66=.)
recode PRCCSR_MST030             (-99 -88 -66=.)
recode PRCCSR_NCM001             (-99 -88 -66=.)
recode PRCCSR_NCM002             (-99 -88 -66=.)
recode PRCCSR_NCM003             (-99 -88 -66=.)
recode PRCCSR_NCM004             (-99 -88 -66=.)
recode PRCCSR_OST001             (-99 -88 -66=.)
recode PRCCSR_OTR001             (-99 -88 -66=.)
recode PRCCSR_OTR002             (-99 -88 -66=.)
recode PRCCSR_OTR003             (-99 -88 -66=.)
recode PRCCSR_OTR004             (-99 -88 -66=.)
recode PRCCSR_OTR005             (-99 -88 -66=.)
recode PRCCSR_PGN001             (-99 -88 -66=.)
recode PRCCSR_PGN002             (-99 -88 -66=.)
recode PRCCSR_PGN003             (-99 -88 -66=.)
recode PRCCSR_PGN004             (-99 -88 -66=.)
recode PRCCSR_PGN005             (-99 -88 -66=.)
recode PRCCSR_PGN006             (-99 -88 -66=.)
recode PRCCSR_PGN007             (-99 -88 -66=.)
recode PRCCSR_PGN008             (-99 -88 -66=.)
recode PRCCSR_PGN009             (-99 -88 -66=.)
recode PRCCSR_PLC001             (-99 -88 -66=.)
recode PRCCSR_PLC002             (-99 -88 -66=.)
recode PRCCSR_PNS001             (-99 -88 -66=.)
recode PRCCSR_PNS002             (-99 -88 -66=.)
recode PRCCSR_PNS003             (-99 -88 -66=.)
recode PRCCSR_PNS004             (-99 -88 -66=.)
recode PRCCSR_PNS005             (-99 -88 -66=.)
recode PRCCSR_PNS006             (-99 -88 -66=.)
recode PRCCSR_RAD001             (-99 -88 -66=.)
recode PRCCSR_RAD002             (-99 -88 -66=.)
recode PRCCSR_RAD003             (-99 -88 -66=.)
recode PRCCSR_RAD004             (-99 -88 -66=.)
recode PRCCSR_RES001             (-99 -88 -66=.)
recode PRCCSR_RES002             (-99 -88 -66=.)
recode PRCCSR_RES003             (-99 -88 -66=.)
recode PRCCSR_RES004             (-99 -88 -66=.)
recode PRCCSR_RES005             (-99 -88 -66=.)
recode PRCCSR_RES006             (-99 -88 -66=.)
recode PRCCSR_RES007             (-99 -88 -66=.)
recode PRCCSR_RES008             (-99 -88 -66=.)
recode PRCCSR_RES009             (-99 -88 -66=.)
recode PRCCSR_RES010             (-99 -88 -66=.)
recode PRCCSR_RES011             (-99 -88 -66=.)
recode PRCCSR_RES012             (-99 -88 -66=.)
recode PRCCSR_RES013             (-99 -88 -66=.)
recode PRCCSR_RES014             (-99 -88 -66=.)
recode PRCCSR_RHB001             (-99 -88 -66=.)
recode PRCCSR_RHB002             (-99 -88 -66=.)
recode PRCCSR_RHB003             (-99 -88 -66=.)
recode PRCCSR_RHB004             (-99 -88 -66=.)
recode PRCCSR_SKB001             (-99 -88 -66=.)
recode PRCCSR_SKB002             (-99 -88 -66=.)
recode PRCCSR_SKB003             (-99 -88 -66=.)
recode PRCCSR_SKB004             (-99 -88 -66=.)
recode PRCCSR_SKB005             (-99 -88 -66=.)
recode PRCCSR_SKB006             (-99 -88 -66=.)
recode PRCCSR_SKB007             (-99 -88 -66=.)
recode PRCCSR_SKB008             (-99 -88 -66=.)
recode PRCCSR_SKB009             (-99 -88 -66=.)
recode PRCCSR_SKB010             (-99 -88 -66=.)
recode PRCCSR_SUD001             (-99 -88 -66=.)
recode PRCCSR_SUD002             (-99 -88 -66=.)
recode PRCCSR_SUD003             (-99 -88 -66=.)
recode PRCCSR_SUD004             (-99 -88 -66=.)
recode PRCCSR_URN001             (-99 -88 -66=.)
recode PRCCSR_URN002             (-99 -88 -66=.)
recode PRCCSR_URN003             (-99 -88 -66=.)
recode PRCCSR_URN004             (-99 -88 -66=.)
recode PRCCSR_URN005             (-99 -88 -66=.)
recode PRCCSR_URN006             (-99 -88 -66=.)
recode PRCCSR_URN007             (-99 -88 -66=.)
recode PRCCSR_URN008             (-99 -88 -66=.)
recode PRCCSR_URN009             (-99 -88 -66=.)
recode PRCCSR_URN010             (-99 -88 -66=.)
recode PRCCSR_URN011             (-99 -88 -66=.)
recode PRCCSR_URN012             (-99 -88 -66=.)

save "MA_SID_2023_DX_PR_GRPS.dta", replace
