/*****************************************************************************
* Creation Date: 01/15/2025   
* MD_SID_2023_CORE.Do
* This program will load the 2023 MD ASCII CORE File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/*** Set available memory size ***/
set mem 500m

/*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***/
infix 3 firstlineoffile                            ///
      int    AGE                          1-   3   ///
      int    AGEDAY                       4-   6   ///
      int    AGEMONTH                     7-   9   ///
      byte   ATYPE                       10-  11   ///
      byte   AWEEKEND                    12-  13   ///
      int    BWT                         14-  17   ///
      int    DaysBurnUnit                18-  20   ///
      int    DaysCCU                     21-  23   ///
      int    DaysICU                     24-  26   ///
      int    DaysNICU                    27-  29   ///
      int    DaysPICU                    30-  32   ///
      int    DaysShockUnit               33-  35   ///
      long   DaysToEvent                 36-  41   ///
      byte   DIED                        42-  43   ///
      str    DISP_X                      44-  45   ///
      byte   DISPUB04                    46-  47   ///
      byte   DISPUNIFORM                 48-  49   ///
      byte   DQTR                        50-  51   ///
      int    DRG                         52-  54   ///
      int    DRG_NoPOA                   55-  57   ///
      byte   DRGVER                      58-  59   ///
      str    DSHOSPID                    60-  76   ///
      str    DXPOA1                      77        ///
      str    DXPOA2                      78        ///
      str    DXPOA3                      79        ///
      str    DXPOA4                      80        ///
      str    DXPOA5                      81        ///
      str    DXPOA6                      82        ///
      str    DXPOA7                      83        ///
      str    DXPOA8                      84        ///
      str    DXPOA9                      85        ///
      str    DXPOA10                     86        ///
      str    DXPOA11                     87        ///
      str    DXPOA12                     88        ///
      str    DXPOA13                     89        ///
      str    DXPOA14                     90        ///
      str    DXPOA15                     91        ///
      str    DXPOA16                     92        ///
      str    DXPOA17                     93        ///
      str    DXPOA18                     94        ///
      str    DXPOA19                     95        ///
      str    DXPOA20                     96        ///
      str    DXPOA21                     97        ///
      str    DXPOA22                     98        ///
      str    DXPOA23                     99        ///
      str    DXPOA24                    100        ///
      str    DXPOA25                    101        ///
      str    DXPOA26                    102        ///
      str    DXPOA27                    103        ///
      str    DXPOA28                    104        ///
      str    DXPOA29                    105        ///
      str    DXPOA30                    106        ///
      str    DXPOA31                    107        ///
      str    DXPOA32                    108        ///
      str    DXPOA33                    109        ///
      str    DXPOA34                    110        ///
      str    DXPOA35                    111        ///
      str    DXPOA36                    112        ///
      str    DXPOA37                    113        ///
      str    DXPOA38                    114        ///
      str    DXPOA39                    115        ///
      str    DXPOA40                    116        ///
      str    DXPOA41                    117        ///
      str    DXPOA42                    118        ///
      str    DXPOA43                    119        ///
      str    DXPOA44                    120        ///
      str    DXPOA45                    121        ///
      str    DXPOA46                    122        ///
      str    DXPOA47                    123        ///
      str    DXPOA48                    124        ///
      str    DXPOA49                    125        ///
      str    DXPOA50                    126        ///
      str    DXPOA51                    127        ///
      str    DXPOA52                    128        ///
      str    DXPOA53                    129        ///
      str    DXPOA54                    130        ///
      str    DXPOA55                    131        ///
      str    DXPOA56                    132        ///
      str    DXPOA57                    133        ///
      str    DXPOA58                    134        ///
      str    DXPOA59                    135        ///
      str    DXPOA60                    136        ///
      str    DXPOA61                    137        ///
      str    DXPOA62                    138        ///
      str    DXPOA63                    139        ///
      str    DXPOA64                    140        ///
      str    DXPOA65                    141        ///
      str    DXPOA66                    142        ///
      str    DXPOA67                    143        ///
      str    DXPOA68                    144        ///
      str    DXPOA69                    145        ///
      str    DXPOA70                    146        ///
      str    DXPOA71                    147        ///
      str    DXPOA72                    148        ///
      str    DXPOA73                    149        ///
      str    DXPOA74                    150        ///
      str    DXPOA75                    151        ///
      str    DXPOA76                    152        ///
      str    DXPOA77                    153        ///
      str    DXPOA78                    154        ///
      str    DXPOA79                    155        ///
      str    DXPOA80                    156        ///
      str    DXPOA81                    157        ///
      str    DXPOA82                    158        ///
      str    DXPOA83                    159        ///
      str    DXPOA84                    160        ///
      str    DXPOA85                    161        ///
      str    DXPOA86                    162        ///
      str    DXPOA87                    163        ///
      str    DXPOA88                    164        ///
      str    DXPOA89                    165        ///
      str    DXPOA90                    166        ///
      str    DXPOA91                    167        ///
      str    DXPOA92                    168        ///
      str    DXPOA93                    169        ///
      str    DXPOA94                    170        ///
      str    DXPOA95                    171        ///
      str    DXPOA96                    172        ///
      str    DXPOA97                    173        ///
      str    DXPOA98                    174        ///
      str    DXPOA99                    175        ///
      str    DXPOA100                   176        ///
      byte   FEMALE                     177- 178   ///
      byte   HCUP_ED                    179- 180   ///
      byte   HCUP_OS                    181- 182   ///
      byte   HISPANIC                   183- 184   ///
      str    HISPANIC_X                 185        ///
      byte   Homeless                   186- 187   ///
      byte   HospitalUnit               188- 189   ///
      str    HOSPST                     190- 191   ///
      int    I10_BIRTH                  192- 194   ///
      int    I10_DELIVERY               195- 197   ///
      str    I10_DX1                    198- 204   ///
      str    I10_DX2                    205- 211   ///
      str    I10_DX3                    212- 218   ///
      str    I10_DX4                    219- 225   ///
      str    I10_DX5                    226- 232   ///
      str    I10_DX6                    233- 239   ///
      str    I10_DX7                    240- 246   ///
      str    I10_DX8                    247- 253   ///
      str    I10_DX9                    254- 260   ///
      str    I10_DX10                   261- 267   ///
      str    I10_DX11                   268- 274   ///
      str    I10_DX12                   275- 281   ///
      str    I10_DX13                   282- 288   ///
      str    I10_DX14                   289- 295   ///
      str    I10_DX15                   296- 302   ///
      str    I10_DX16                   303- 309   ///
      str    I10_DX17                   310- 316   ///
      str    I10_DX18                   317- 323   ///
      str    I10_DX19                   324- 330   ///
      str    I10_DX20                   331- 337   ///
      str    I10_DX21                   338- 344   ///
      str    I10_DX22                   345- 351   ///
      str    I10_DX23                   352- 358   ///
      str    I10_DX24                   359- 365   ///
      str    I10_DX25                   366- 372   ///
      str    I10_DX26                   373- 379   ///
      str    I10_DX27                   380- 386   ///
      str    I10_DX28                   387- 393   ///
      str    I10_DX29                   394- 400   ///
      str    I10_DX30                   401- 407   ///
      str    I10_DX31                   408- 414   ///
      str    I10_DX32                   415- 421   ///
      str    I10_DX33                   422- 428   ///
      str    I10_DX34                   429- 435   ///
      str    I10_DX35                   436- 442   ///
      str    I10_DX36                   443- 449   ///
      str    I10_DX37                   450- 456   ///
      str    I10_DX38                   457- 463   ///
      str    I10_DX39                   464- 470   ///
      str    I10_DX40                   471- 477   ///
      str    I10_DX41                   478- 484   ///
      str    I10_DX42                   485- 491   ///
      str    I10_DX43                   492- 498   ///
      str    I10_DX44                   499- 505   ///
      str    I10_DX45                   506- 512   ///
      str    I10_DX46                   513- 519   ///
      str    I10_DX47                   520- 526   ///
      str    I10_DX48                   527- 533   ///
      str    I10_DX49                   534- 540   ///
      str    I10_DX50                   541- 547   ///
      str    I10_DX51                   548- 554   ///
      str    I10_DX52                   555- 561   ///
      str    I10_DX53                   562- 568   ///
      str    I10_DX54                   569- 575   ///
      str    I10_DX55                   576- 582   ///
      str    I10_DX56                   583- 589   ///
      str    I10_DX57                   590- 596   ///
      str    I10_DX58                   597- 603   ///
      str    I10_DX59                   604- 610   ///
      str    I10_DX60                   611- 617   ///
      str    I10_DX61                   618- 624   ///
      str    I10_DX62                   625- 631   ///
      str    I10_DX63                   632- 638   ///
      str    I10_DX64                   639- 645   ///
      str    I10_DX65                   646- 652   ///
      str    I10_DX66                   653- 659   ///
      str    I10_DX67                   660- 666   ///
      str    I10_DX68                   667- 673   ///
      str    I10_DX69                   674- 680   ///
      str    I10_DX70                   681- 687   ///
      str    I10_DX71                   688- 694   ///
      str    I10_DX72                   695- 701   ///
      str    I10_DX73                   702- 708   ///
      str    I10_DX74                   709- 715   ///
      str    I10_DX75                   716- 722   ///
      str    I10_DX76                   723- 729   ///
      str    I10_DX77                   730- 736   ///
      str    I10_DX78                   737- 743   ///
      str    I10_DX79                   744- 750   ///
      str    I10_DX80                   751- 757   ///
      str    I10_DX81                   758- 764   ///
      str    I10_DX82                   765- 771   ///
      str    I10_DX83                   772- 778   ///
      str    I10_DX84                   779- 785   ///
      str    I10_DX85                   786- 792   ///
      str    I10_DX86                   793- 799   ///
      str    I10_DX87                   800- 806   ///
      str    I10_DX88                   807- 813   ///
      str    I10_DX89                   814- 820   ///
      str    I10_DX90                   821- 827   ///
      str    I10_DX91                   828- 834   ///
      str    I10_DX92                   835- 841   ///
      str    I10_DX93                   842- 848   ///
      str    I10_DX94                   849- 855   ///
      str    I10_DX95                   856- 862   ///
      str    I10_DX96                   863- 869   ///
      str    I10_DX97                   870- 876   ///
      str    I10_DX98                   877- 883   ///
      str    I10_DX99                   884- 890   ///
      str    I10_DX100                  891- 897   ///
      str    I10_DX101                  898- 904   ///
      int    I10_NDX                    905- 907   ///
      int    I10_NPR                    908- 910   ///
      str    I10_PR1                    911- 917   ///
      str    I10_PR2                    918- 924   ///
      str    I10_PR3                    925- 931   ///
      str    I10_PR4                    932- 938   ///
      str    I10_PR5                    939- 945   ///
      str    I10_PR6                    946- 952   ///
      str    I10_PR7                    953- 959   ///
      str    I10_PR8                    960- 966   ///
      str    I10_PR9                    967- 973   ///
      str    I10_PR10                   974- 980   ///
      str    I10_PR11                   981- 987   ///
      str    I10_PR12                   988- 994   ///
      str    I10_PR13                   995-1001   ///
      str    I10_PR14                  1002-1008   ///
      str    I10_PR15                  1009-1015   ///
      str    I10_PR16                  1016-1022   ///
      str    I10_PR17                  1023-1029   ///
      str    I10_PR18                  1030-1036   ///
      str    I10_PR19                  1037-1043   ///
      str    I10_PR20                  1044-1050   ///
      str    I10_PR21                  1051-1057   ///
      str    I10_PR22                  1058-1064   ///
      str    I10_PR23                  1065-1071   ///
      str    I10_PR24                  1072-1078   ///
      str    I10_PR25                  1079-1085   ///
      str    I10_PR26                  1086-1092   ///
      str    I10_PR27                  1093-1099   ///
      str    I10_PR28                  1100-1106   ///
      str    I10_PR29                  1107-1113   ///
      str    I10_PR30                  1114-1120   ///
      str    I10_PR31                  1121-1127   ///
      str    I10_PR32                  1128-1134   ///
      str    I10_PR33                  1135-1141   ///
      str    I10_PR34                  1142-1148   ///
      str    I10_PR35                  1149-1155   ///
      str    I10_PR36                  1156-1162   ///
      str    I10_PR37                  1163-1169   ///
      str    I10_PR38                  1170-1176   ///
      str    I10_PR39                  1177-1183   ///
      str    I10_PR40                  1184-1190   ///
      str    I10_PR41                  1191-1197   ///
      str    I10_PR42                  1198-1204   ///
      str    I10_PR43                  1205-1211   ///
      str    I10_PR44                  1212-1218   ///
      str    I10_PR45                  1219-1225   ///
      str    I10_PR46                  1226-1232   ///
      str    I10_PR47                  1233-1239   ///
      str    I10_PR48                  1240-1246   ///
      str    I10_PR49                  1247-1253   ///
      str    I10_PR50                  1254-1260   ///
      str    I10_PR51                  1261-1267   ///
      str    I10_PR52                  1268-1274   ///
      str    I10_PR53                  1275-1281   ///
      str    I10_PR54                  1282-1288   ///
      str    I10_PR55                  1289-1295   ///
      str    I10_PR56                  1296-1302   ///
      str    I10_PR57                  1303-1309   ///
      str    I10_PR58                  1310-1316   ///
      str    I10_PR59                  1317-1323   ///
      str    I10_PR60                  1324-1330   ///
      str    I10_PR61                  1331-1337   ///
      str    I10_PR62                  1338-1344   ///
      str    I10_PR63                  1345-1351   ///
      str    I10_PR64                  1352-1358   ///
      str    I10_PR65                  1359-1365   ///
      str    I10_PR66                  1366-1372   ///
      str    I10_PR67                  1373-1379   ///
      str    I10_PR68                  1380-1386   ///
      str    I10_PR69                  1387-1393   ///
      str    I10_PR70                  1394-1400   ///
      str    I10_PR71                  1401-1407   ///
      str    I10_PR72                  1408-1414   ///
      str    I10_PR73                  1415-1421   ///
      str    I10_PR74                  1422-1428   ///
      str    I10_PR75                  1429-1435   ///
      str    I10_PR76                  1436-1442   ///
      str    I10_PR77                  1443-1449   ///
      str    I10_PR78                  1450-1456   ///
      str    I10_PR79                  1457-1463   ///
      str    I10_PR80                  1464-1470   ///
      str    I10_PR81                  1471-1477   ///
      str    I10_PR82                  1478-1484   ///
      str    I10_PR83                  1485-1491   ///
      str    I10_PR84                  1492-1498   ///
      str    I10_PR85                  1499-1505   ///
      str    I10_PR86                  1506-1512   ///
      str    I10_PR87                  1513-1519   ///
      str    I10_PR88                  1520-1526   ///
      str    I10_PR89                  1527-1533   ///
      str    I10_PR90                  1534-1540   ///
      str    I10_PR91                  1541-1547   ///
      str    I10_PR92                  1548-1554   ///
      str    I10_PR93                  1555-1561   ///
      str    I10_PR94                  1562-1568   ///
      str    I10_PR95                  1569-1575   ///
      str    I10_PR96                  1576-1582   ///
      str    I10_PR97                  1583-1589   ///
      str    I10_PR98                  1590-1596   ///
      str    I10_PR99                  1597-1603   ///
      str    I10_PR100                 1604-1610   ///
      int    I10_PROCTYPE              1611-1613   ///
      byte   I10_SERVICELINE           1614-1615   ///
      double KEY                       1616-1630   ///
      long   LOS                       1631-1635   ///
      long   LOS_X                     1636-1641   ///
      str    MARITALSTATUS_X           1642        ///
      str    MARITALSTATUSUB04         1643        ///
      byte   MDC                       1644-1645   ///
      byte   MDC_NoPOA                 1646-1647   ///
      long   MDNUM1_R                  1648-1656   ///
      long   MDNUM2_R                  1657-1665   ///
      byte   MEDINCSTQ                 1666-1667   ///
      long   MRN_R                     1668-1676   ///
      double OS_TIME                   1677-1687   ///
      str    P7EDSRC_X                 1688-1689   ///
      byte   PAY1                      1690-1691   ///
      str    PAY1_X                    1692-1693   ///
      byte   PAY2                      1694-1695   ///
      str    PAY2_X                    1696-1697   ///
      byte   PAY3                      1698-1699   ///
      str    PAY3_X                    1700-1701   ///
      str    PAYER1_X                  1702-1704   ///
      str    PAYER2_X                  1705-1707   ///
      str    PAYER3_X                  1708-1710   ///
      byte   PCLASS_ORPROC             1711-1712   ///
      int    PL_CBSA                   1713-1715   ///
      byte   PL_NCHS                   1716-1717   ///
      byte   PL_RUCC                   1718-1719   ///
      byte   PL_UIC                    1720-1721   ///
      byte   PL_UR_CAT4                1722-1723   ///
      byte   POA_Disch_Edit1           1724-1725   ///
      byte   POA_Disch_Edit2           1726-1727   ///
      byte   POA_Hosp_Edit1            1728-1729   ///
      byte   POA_Hosp_Edit2            1730-1731   ///
      byte   POA_Hosp_Edit3            1732-1733   ///
      double POA_Hosp_Edit3_Value      1734-1741   ///
      str    PointOfOrigin_X           1742-1743   ///
      str    PointOfOriginUB04         1744        ///
      long   PRDAY1                    1745-1749   ///
      long   PRDAY2                    1750-1754   ///
      long   PRDAY3                    1755-1759   ///
      long   PRDAY4                    1760-1764   ///
      long   PRDAY5                    1765-1769   ///
      long   PRDAY6                    1770-1774   ///
      long   PRDAY7                    1775-1779   ///
      long   PRDAY8                    1780-1784   ///
      long   PRDAY9                    1785-1789   ///
      long   PRDAY10                   1790-1794   ///
      long   PRDAY11                   1795-1799   ///
      long   PRDAY12                   1800-1804   ///
      long   PRDAY13                   1805-1809   ///
      long   PRDAY14                   1810-1814   ///
      long   PRDAY15                   1815-1819   ///
      long   PRDAY16                   1820-1824   ///
      long   PRDAY17                   1825-1829   ///
      long   PRDAY18                   1830-1834   ///
      long   PRDAY19                   1835-1839   ///
      long   PRDAY20                   1840-1844   ///
      long   PRDAY21                   1845-1849   ///
      long   PRDAY22                   1850-1854   ///
      long   PRDAY23                   1855-1859   ///
      long   PRDAY24                   1860-1864   ///
      long   PRDAY25                   1865-1869   ///
      long   PRDAY26                   1870-1874   ///
      long   PRDAY27                   1875-1879   ///
      long   PRDAY28                   1880-1884   ///
      long   PRDAY29                   1885-1889   ///
      long   PRDAY30                   1890-1894   ///
      long   PRDAY31                   1895-1899   ///
      long   PRDAY32                   1900-1904   ///
      long   PRDAY33                   1905-1909   ///
      long   PRDAY34                   1910-1914   ///
      long   PRDAY35                   1915-1919   ///
      long   PRDAY36                   1920-1924   ///
      long   PRDAY37                   1925-1929   ///
      long   PRDAY38                   1930-1934   ///
      long   PRDAY39                   1935-1939   ///
      long   PRDAY40                   1940-1944   ///
      long   PRDAY41                   1945-1949   ///
      long   PRDAY42                   1950-1954   ///
      long   PRDAY43                   1955-1959   ///
      long   PRDAY44                   1960-1964   ///
      long   PRDAY45                   1965-1969   ///
      long   PRDAY46                   1970-1974   ///
      long   PRDAY47                   1975-1979   ///
      long   PRDAY48                   1980-1984   ///
      long   PRDAY49                   1985-1989   ///
      long   PRDAY50                   1990-1994   ///
      long   PRDAY51                   1995-1999   ///
      long   PRDAY52                   2000-2004   ///
      long   PRDAY53                   2005-2009   ///
      long   PRDAY54                   2010-2014   ///
      long   PRDAY55                   2015-2019   ///
      long   PRDAY56                   2020-2024   ///
      long   PRDAY57                   2025-2029   ///
      long   PRDAY58                   2030-2034   ///
      long   PRDAY59                   2035-2039   ///
      long   PRDAY60                   2040-2044   ///
      long   PRDAY61                   2045-2049   ///
      long   PRDAY62                   2050-2054   ///
      long   PRDAY63                   2055-2059   ///
      long   PRDAY64                   2060-2064   ///
      long   PRDAY65                   2065-2069   ///
      long   PRDAY66                   2070-2074   ///
      long   PRDAY67                   2075-2079   ///
      long   PRDAY68                   2080-2084   ///
      long   PRDAY69                   2085-2089   ///
      long   PRDAY70                   2090-2094   ///
      long   PRDAY71                   2095-2099   ///
      long   PRDAY72                   2100-2104   ///
      long   PRDAY73                   2105-2109   ///
      long   PRDAY74                   2110-2114   ///
      long   PRDAY75                   2115-2119   ///
      long   PRDAY76                   2120-2124   ///
      long   PRDAY77                   2125-2129   ///
      long   PRDAY78                   2130-2134   ///
      long   PRDAY79                   2135-2139   ///
      long   PRDAY80                   2140-2144   ///
      long   PRDAY81                   2145-2149   ///
      long   PRDAY82                   2150-2154   ///
      long   PRDAY83                   2155-2159   ///
      long   PRDAY84                   2160-2164   ///
      long   PRDAY85                   2165-2169   ///
      long   PRDAY86                   2170-2174   ///
      long   PRDAY87                   2175-2179   ///
      long   PRDAY88                   2180-2184   ///
      long   PRDAY89                   2185-2189   ///
      long   PRDAY90                   2190-2194   ///
      long   PRDAY91                   2195-2199   ///
      long   PRDAY92                   2200-2204   ///
      long   PRDAY93                   2205-2209   ///
      long   PRDAY94                   2210-2214   ///
      long   PRDAY95                   2215-2219   ///
      long   PRDAY96                   2220-2224   ///
      long   PRDAY97                   2225-2229   ///
      long   PRDAY98                   2230-2234   ///
      long   PRDAY99                   2235-2239   ///
      long   PRDAY100                  2240-2244   ///
      str    PrimLang                  2245-2247   ///
      str    PSTATE                    2248-2249   ///
      str    PSTATE_GEO                2250-2251   ///
      long   PSTCO                     2252-2256   ///
      long   PSTCO_GEO                 2257-2261   ///
      byte   RACE                      2262-2263   ///
      float  RACE_PCT_MISS_HOSP        2264-2270   ///
      str    RACE_X                    2271        ///
      byte   READMIT                   2272-2273   ///
      double TOTCHG                    2274-2283   ///
      double TOTCHG_X                  2284-2298   ///
      byte   TRAN_IN                   2299-2300   ///
      byte   TRAN_OUT                  2301-2302   ///
      long   VisitLink                 2303-2311   ///
      int    YEAR                      2312-2315   ///
      str    ZIP                       2316-2320   ///
      str    ZIP3                      2321-2323   ///
      int    ZIPINC_QRTL               2324-2326   ///
      int    AYEAR                     2327-2330   ///
      using  "MD_SID_2023_CORE.asc"

/***  Assign labels to the data elements ***/
label var AGE                      "Age in years at admission"
label var AGEDAY                   "Age in days (when age < 1 year)"
label var AGEMONTH                 "Age in months (when age < 11 years)"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var BWT                      "Birth weight in grams"
label var DaysBurnUnit             "Days in burn care unit (as received from source)"
label var DaysCCU                  "Days in coronary care unit (as received from source)"
label var DaysICU                  "Days in medical/surgical intensive care unit (as received from source)"
label var DaysNICU                 "Days in neonetal care unit (as received from source)"
label var DaysPICU                 "Days in pediatric care unit (as received from source)"
label var DaysShockUnit            "Days in shock trauma unit (as received from source"
label var DaysToEvent              "Days from 'start date' to admission"
label var DIED                     "Died during hospitalization"
label var DISP_X                   "Disposition of patient (as received from source)"
label var DISPUB04                 "Disposition of patient (UB-04 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DQTR                     "Discharge quarter"
label var DRG                      "DRG in effect on discharge date"
label var DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DSHOSPID                 "Data source hospital identifier"
label var DXPOA1                   "Diagnosis 1, present on admission indicator"
label var DXPOA2                   "Diagnosis 2, present on admission indicator"
label var DXPOA3                   "Diagnosis 3, present on admission indicator"
label var DXPOA4                   "Diagnosis 4, present on admission indicator"
label var DXPOA5                   "Diagnosis 5, present on admission indicator"
label var DXPOA6                   "Diagnosis 6, present on admission indicator"
label var DXPOA7                   "Diagnosis 7, present on admission indicator"
label var DXPOA8                   "Diagnosis 8, present on admission indicator"
label var DXPOA9                   "Diagnosis 9, present on admission indicator"
label var DXPOA10                  "Diagnosis 10, present on admission indicator"
label var DXPOA11                  "Diagnosis 11, present on admission indicator"
label var DXPOA12                  "Diagnosis 12, present on admission indicator"
label var DXPOA13                  "Diagnosis 13, present on admission indicator"
label var DXPOA14                  "Diagnosis 14, present on admission indicator"
label var DXPOA15                  "Diagnosis 15, present on admission indicator"
label var DXPOA16                  "Diagnosis 16, present on admission indicator"
label var DXPOA17                  "Diagnosis 17, present on admission indicator"
label var DXPOA18                  "Diagnosis 18, present on admission indicator"
label var DXPOA19                  "Diagnosis 19, present on admission indicator"
label var DXPOA20                  "Diagnosis 20, present on admission indicator"
label var DXPOA21                  "Diagnosis 21, present on admission indicator"
label var DXPOA22                  "Diagnosis 22, present on admission indicator"
label var DXPOA23                  "Diagnosis 23, present on admission indicator"
label var DXPOA24                  "Diagnosis 24, present on admission indicator"
label var DXPOA25                  "Diagnosis 25, present on admission indicator"
label var DXPOA26                  "Diagnosis 26, present on admission indicator"
label var DXPOA27                  "Diagnosis 27, present on admission indicator"
label var DXPOA28                  "Diagnosis 28, present on admission indicator"
label var DXPOA29                  "Diagnosis 29, present on admission indicator"
label var DXPOA30                  "Diagnosis 30, present on admission indicator"
label var DXPOA31                  "Diagnosis 31, present on admission indicator"
label var DXPOA32                  "Diagnosis 32, present on admission indicator"
label var DXPOA33                  "Diagnosis 33, present on admission indicator"
label var DXPOA34                  "Diagnosis 34, present on admission indicator"
label var DXPOA35                  "Diagnosis 35, present on admission indicator"
label var DXPOA36                  "Diagnosis 36, present on admission indicator"
label var DXPOA37                  "Diagnosis 37, present on admission indicator"
label var DXPOA38                  "Diagnosis 38, present on admission indicator"
label var DXPOA39                  "Diagnosis 39, present on admission indicator"
label var DXPOA40                  "Diagnosis 40, present on admission indicator"
label var DXPOA41                  "Diagnosis 41, present on admission indicator"
label var DXPOA42                  "Diagnosis 42, present on admission indicator"
label var DXPOA43                  "Diagnosis 43, present on admission indicator"
label var DXPOA44                  "Diagnosis 44, present on admission indicator"
label var DXPOA45                  "Diagnosis 45, present on admission indicator"
label var DXPOA46                  "Diagnosis 46, present on admission indicator"
label var DXPOA47                  "Diagnosis 47, present on admission indicator"
label var DXPOA48                  "Diagnosis 48, present on admission indicator"
label var DXPOA49                  "Diagnosis 49, present on admission indicator"
label var DXPOA50                  "Diagnosis 50, present on admission indicator"
label var DXPOA51                  "Diagnosis 51, present on admission indicator"
label var DXPOA52                  "Diagnosis 52, present on admission indicator"
label var DXPOA53                  "Diagnosis 53, present on admission indicator"
label var DXPOA54                  "Diagnosis 54, present on admission indicator"
label var DXPOA55                  "Diagnosis 55, present on admission indicator"
label var DXPOA56                  "Diagnosis 56, present on admission indicator"
label var DXPOA57                  "Diagnosis 57, present on admission indicator"
label var DXPOA58                  "Diagnosis 58, present on admission indicator"
label var DXPOA59                  "Diagnosis 59, present on admission indicator"
label var DXPOA60                  "Diagnosis 60, present on admission indicator"
label var DXPOA61                  "Diagnosis 61, present on admission indicator"
label var DXPOA62                  "Diagnosis 62, present on admission indicator"
label var DXPOA63                  "Diagnosis 63, present on admission indicator"
label var DXPOA64                  "Diagnosis 64, present on admission indicator"
label var DXPOA65                  "Diagnosis 65, present on admission indicator"
label var DXPOA66                  "Diagnosis 66, present on admission indicator"
label var DXPOA67                  "Diagnosis 67, present on admission indicator"
label var DXPOA68                  "Diagnosis 68, present on admission indicator"
label var DXPOA69                  "Diagnosis 69, present on admission indicator"
label var DXPOA70                  "Diagnosis 70, present on admission indicator"
label var DXPOA71                  "Diagnosis 71, present on admission indicator"
label var DXPOA72                  "Diagnosis 72, present on admission indicator"
label var DXPOA73                  "Diagnosis 73, present on admission indicator"
label var DXPOA74                  "Diagnosis 74, present on admission indicator"
label var DXPOA75                  "Diagnosis 75, present on admission indicator"
label var DXPOA76                  "Diagnosis 76, present on admission indicator"
label var DXPOA77                  "Diagnosis 77, present on admission indicator"
label var DXPOA78                  "Diagnosis 78, present on admission indicator"
label var DXPOA79                  "Diagnosis 79, present on admission indicator"
label var DXPOA80                  "Diagnosis 80, present on admission indicator"
label var DXPOA81                  "Diagnosis 81, present on admission indicator"
label var DXPOA82                  "Diagnosis 82, present on admission indicator"
label var DXPOA83                  "Diagnosis 83, present on admission indicator"
label var DXPOA84                  "Diagnosis 84, present on admission indicator"
label var DXPOA85                  "Diagnosis 85, present on admission indicator"
label var DXPOA86                  "Diagnosis 86, present on admission indicator"
label var DXPOA87                  "Diagnosis 87, present on admission indicator"
label var DXPOA88                  "Diagnosis 88, present on admission indicator"
label var DXPOA89                  "Diagnosis 89, present on admission indicator"
label var DXPOA90                  "Diagnosis 90, present on admission indicator"
label var DXPOA91                  "Diagnosis 91, present on admission indicator"
label var DXPOA92                  "Diagnosis 92, present on admission indicator"
label var DXPOA93                  "Diagnosis 93, present on admission indicator"
label var DXPOA94                  "Diagnosis 94, present on admission indicator"
label var DXPOA95                  "Diagnosis 95, present on admission indicator"
label var DXPOA96                  "Diagnosis 96, present on admission indicator"
label var DXPOA97                  "Diagnosis 97, present on admission indicator"
label var DXPOA98                  "Diagnosis 98, present on admission indicator"
label var DXPOA99                  "Diagnosis 99, present on admission indicator"
label var DXPOA100                 "Diagnosis 100, present on admission indicator"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HCUP_OS                  "HCUP Observation Stay service indicator"
label var HISPANIC                 "Hispanic ethnicity (uniform)"
label var HISPANIC_X               "Hispanic ethnicity (as received from source)"
label var Homeless                 "Indicator that patient is homeless"
label var HospitalUnit             "Patient was discharged from a special unit within an acute care hospital (reported by source)"
label var HOSPST                   "Hospital state postal code"
label var I10_BIRTH                "ICD-10-CM Birth Indicator"
label var I10_DELIVERY             "ICD-10-CM Delivery Indicator"
label var I10_DX1                  "ICD-10-CM Diagnosis 1"
label var I10_DX2                  "ICD-10-CM Diagnosis 2"
label var I10_DX3                  "ICD-10-CM Diagnosis 3"
label var I10_DX4                  "ICD-10-CM Diagnosis 4"
label var I10_DX5                  "ICD-10-CM Diagnosis 5"
label var I10_DX6                  "ICD-10-CM Diagnosis 6"
label var I10_DX7                  "ICD-10-CM Diagnosis 7"
label var I10_DX8                  "ICD-10-CM Diagnosis 8"
label var I10_DX9                  "ICD-10-CM Diagnosis 9"
label var I10_DX10                 "ICD-10-CM Diagnosis 10"
label var I10_DX11                 "ICD-10-CM Diagnosis 11"
label var I10_DX12                 "ICD-10-CM Diagnosis 12"
label var I10_DX13                 "ICD-10-CM Diagnosis 13"
label var I10_DX14                 "ICD-10-CM Diagnosis 14"
label var I10_DX15                 "ICD-10-CM Diagnosis 15"
label var I10_DX16                 "ICD-10-CM Diagnosis 16"
label var I10_DX17                 "ICD-10-CM Diagnosis 17"
label var I10_DX18                 "ICD-10-CM Diagnosis 18"
label var I10_DX19                 "ICD-10-CM Diagnosis 19"
label var I10_DX20                 "ICD-10-CM Diagnosis 20"
label var I10_DX21                 "ICD-10-CM Diagnosis 21"
label var I10_DX22                 "ICD-10-CM Diagnosis 22"
label var I10_DX23                 "ICD-10-CM Diagnosis 23"
label var I10_DX24                 "ICD-10-CM Diagnosis 24"
label var I10_DX25                 "ICD-10-CM Diagnosis 25"
label var I10_DX26                 "ICD-10-CM Diagnosis 26"
label var I10_DX27                 "ICD-10-CM Diagnosis 27"
label var I10_DX28                 "ICD-10-CM Diagnosis 28"
label var I10_DX29                 "ICD-10-CM Diagnosis 29"
label var I10_DX30                 "ICD-10-CM Diagnosis 30"
label var I10_DX31                 "ICD-10-CM Diagnosis 31"
label var I10_DX32                 "ICD-10-CM Diagnosis 32"
label var I10_DX33                 "ICD-10-CM Diagnosis 33"
label var I10_DX34                 "ICD-10-CM Diagnosis 34"
label var I10_DX35                 "ICD-10-CM Diagnosis 35"
label var I10_DX36                 "ICD-10-CM Diagnosis 36"
label var I10_DX37                 "ICD-10-CM Diagnosis 37"
label var I10_DX38                 "ICD-10-CM Diagnosis 38"
label var I10_DX39                 "ICD-10-CM Diagnosis 39"
label var I10_DX40                 "ICD-10-CM Diagnosis 40"
label var I10_DX41                 "ICD-10-CM Diagnosis 41"
label var I10_DX42                 "ICD-10-CM Diagnosis 42"
label var I10_DX43                 "ICD-10-CM Diagnosis 43"
label var I10_DX44                 "ICD-10-CM Diagnosis 44"
label var I10_DX45                 "ICD-10-CM Diagnosis 45"
label var I10_DX46                 "ICD-10-CM Diagnosis 46"
label var I10_DX47                 "ICD-10-CM Diagnosis 47"
label var I10_DX48                 "ICD-10-CM Diagnosis 48"
label var I10_DX49                 "ICD-10-CM Diagnosis 49"
label var I10_DX50                 "ICD-10-CM Diagnosis 50"
label var I10_DX51                 "ICD-10-CM Diagnosis 51"
label var I10_DX52                 "ICD-10-CM Diagnosis 52"
label var I10_DX53                 "ICD-10-CM Diagnosis 53"
label var I10_DX54                 "ICD-10-CM Diagnosis 54"
label var I10_DX55                 "ICD-10-CM Diagnosis 55"
label var I10_DX56                 "ICD-10-CM Diagnosis 56"
label var I10_DX57                 "ICD-10-CM Diagnosis 57"
label var I10_DX58                 "ICD-10-CM Diagnosis 58"
label var I10_DX59                 "ICD-10-CM Diagnosis 59"
label var I10_DX60                 "ICD-10-CM Diagnosis 60"
label var I10_DX61                 "ICD-10-CM Diagnosis 61"
label var I10_DX62                 "ICD-10-CM Diagnosis 62"
label var I10_DX63                 "ICD-10-CM Diagnosis 63"
label var I10_DX64                 "ICD-10-CM Diagnosis 64"
label var I10_DX65                 "ICD-10-CM Diagnosis 65"
label var I10_DX66                 "ICD-10-CM Diagnosis 66"
label var I10_DX67                 "ICD-10-CM Diagnosis 67"
label var I10_DX68                 "ICD-10-CM Diagnosis 68"
label var I10_DX69                 "ICD-10-CM Diagnosis 69"
label var I10_DX70                 "ICD-10-CM Diagnosis 70"
label var I10_DX71                 "ICD-10-CM Diagnosis 71"
label var I10_DX72                 "ICD-10-CM Diagnosis 72"
label var I10_DX73                 "ICD-10-CM Diagnosis 73"
label var I10_DX74                 "ICD-10-CM Diagnosis 74"
label var I10_DX75                 "ICD-10-CM Diagnosis 75"
label var I10_DX76                 "ICD-10-CM Diagnosis 76"
label var I10_DX77                 "ICD-10-CM Diagnosis 77"
label var I10_DX78                 "ICD-10-CM Diagnosis 78"
label var I10_DX79                 "ICD-10-CM Diagnosis 79"
label var I10_DX80                 "ICD-10-CM Diagnosis 80"
label var I10_DX81                 "ICD-10-CM Diagnosis 81"
label var I10_DX82                 "ICD-10-CM Diagnosis 82"
label var I10_DX83                 "ICD-10-CM Diagnosis 83"
label var I10_DX84                 "ICD-10-CM Diagnosis 84"
label var I10_DX85                 "ICD-10-CM Diagnosis 85"
label var I10_DX86                 "ICD-10-CM Diagnosis 86"
label var I10_DX87                 "ICD-10-CM Diagnosis 87"
label var I10_DX88                 "ICD-10-CM Diagnosis 88"
label var I10_DX89                 "ICD-10-CM Diagnosis 89"
label var I10_DX90                 "ICD-10-CM Diagnosis 90"
label var I10_DX91                 "ICD-10-CM Diagnosis 91"
label var I10_DX92                 "ICD-10-CM Diagnosis 92"
label var I10_DX93                 "ICD-10-CM Diagnosis 93"
label var I10_DX94                 "ICD-10-CM Diagnosis 94"
label var I10_DX95                 "ICD-10-CM Diagnosis 95"
label var I10_DX96                 "ICD-10-CM Diagnosis 96"
label var I10_DX97                 "ICD-10-CM Diagnosis 97"
label var I10_DX98                 "ICD-10-CM Diagnosis 98"
label var I10_DX99                 "ICD-10-CM Diagnosis 99"
label var I10_DX100                "ICD-10-CM Diagnosis 100"
label var I10_DX101                "ICD-10-CM Diagnosis 101"
label var I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
label var I10_NPR                  "ICD-10-PCS Number of procedures on this record"
label var I10_PR1                  "ICD-10-PCS Procedure 1"
label var I10_PR2                  "ICD-10-PCS Procedure 2"
label var I10_PR3                  "ICD-10-PCS Procedure 3"
label var I10_PR4                  "ICD-10-PCS Procedure 4"
label var I10_PR5                  "ICD-10-PCS Procedure 5"
label var I10_PR6                  "ICD-10-PCS Procedure 6"
label var I10_PR7                  "ICD-10-PCS Procedure 7"
label var I10_PR8                  "ICD-10-PCS Procedure 8"
label var I10_PR9                  "ICD-10-PCS Procedure 9"
label var I10_PR10                 "ICD-10-PCS Procedure 10"
label var I10_PR11                 "ICD-10-PCS Procedure 11"
label var I10_PR12                 "ICD-10-PCS Procedure 12"
label var I10_PR13                 "ICD-10-PCS Procedure 13"
label var I10_PR14                 "ICD-10-PCS Procedure 14"
label var I10_PR15                 "ICD-10-PCS Procedure 15"
label var I10_PR16                 "ICD-10-PCS Procedure 16"
label var I10_PR17                 "ICD-10-PCS Procedure 17"
label var I10_PR18                 "ICD-10-PCS Procedure 18"
label var I10_PR19                 "ICD-10-PCS Procedure 19"
label var I10_PR20                 "ICD-10-PCS Procedure 20"
label var I10_PR21                 "ICD-10-PCS Procedure 21"
label var I10_PR22                 "ICD-10-PCS Procedure 22"
label var I10_PR23                 "ICD-10-PCS Procedure 23"
label var I10_PR24                 "ICD-10-PCS Procedure 24"
label var I10_PR25                 "ICD-10-PCS Procedure 25"
label var I10_PR26                 "ICD-10-PCS Procedure 26"
label var I10_PR27                 "ICD-10-PCS Procedure 27"
label var I10_PR28                 "ICD-10-PCS Procedure 28"
label var I10_PR29                 "ICD-10-PCS Procedure 29"
label var I10_PR30                 "ICD-10-PCS Procedure 30"
label var I10_PR31                 "ICD-10-PCS Procedure 31"
label var I10_PR32                 "ICD-10-PCS Procedure 32"
label var I10_PR33                 "ICD-10-PCS Procedure 33"
label var I10_PR34                 "ICD-10-PCS Procedure 34"
label var I10_PR35                 "ICD-10-PCS Procedure 35"
label var I10_PR36                 "ICD-10-PCS Procedure 36"
label var I10_PR37                 "ICD-10-PCS Procedure 37"
label var I10_PR38                 "ICD-10-PCS Procedure 38"
label var I10_PR39                 "ICD-10-PCS Procedure 39"
label var I10_PR40                 "ICD-10-PCS Procedure 40"
label var I10_PR41                 "ICD-10-PCS Procedure 41"
label var I10_PR42                 "ICD-10-PCS Procedure 42"
label var I10_PR43                 "ICD-10-PCS Procedure 43"
label var I10_PR44                 "ICD-10-PCS Procedure 44"
label var I10_PR45                 "ICD-10-PCS Procedure 45"
label var I10_PR46                 "ICD-10-PCS Procedure 46"
label var I10_PR47                 "ICD-10-PCS Procedure 47"
label var I10_PR48                 "ICD-10-PCS Procedure 48"
label var I10_PR49                 "ICD-10-PCS Procedure 49"
label var I10_PR50                 "ICD-10-PCS Procedure 50"
label var I10_PR51                 "ICD-10-PCS Procedure 51"
label var I10_PR52                 "ICD-10-PCS Procedure 52"
label var I10_PR53                 "ICD-10-PCS Procedure 53"
label var I10_PR54                 "ICD-10-PCS Procedure 54"
label var I10_PR55                 "ICD-10-PCS Procedure 55"
label var I10_PR56                 "ICD-10-PCS Procedure 56"
label var I10_PR57                 "ICD-10-PCS Procedure 57"
label var I10_PR58                 "ICD-10-PCS Procedure 58"
label var I10_PR59                 "ICD-10-PCS Procedure 59"
label var I10_PR60                 "ICD-10-PCS Procedure 60"
label var I10_PR61                 "ICD-10-PCS Procedure 61"
label var I10_PR62                 "ICD-10-PCS Procedure 62"
label var I10_PR63                 "ICD-10-PCS Procedure 63"
label var I10_PR64                 "ICD-10-PCS Procedure 64"
label var I10_PR65                 "ICD-10-PCS Procedure 65"
label var I10_PR66                 "ICD-10-PCS Procedure 66"
label var I10_PR67                 "ICD-10-PCS Procedure 67"
label var I10_PR68                 "ICD-10-PCS Procedure 68"
label var I10_PR69                 "ICD-10-PCS Procedure 69"
label var I10_PR70                 "ICD-10-PCS Procedure 70"
label var I10_PR71                 "ICD-10-PCS Procedure 71"
label var I10_PR72                 "ICD-10-PCS Procedure 72"
label var I10_PR73                 "ICD-10-PCS Procedure 73"
label var I10_PR74                 "ICD-10-PCS Procedure 74"
label var I10_PR75                 "ICD-10-PCS Procedure 75"
label var I10_PR76                 "ICD-10-PCS Procedure 76"
label var I10_PR77                 "ICD-10-PCS Procedure 77"
label var I10_PR78                 "ICD-10-PCS Procedure 78"
label var I10_PR79                 "ICD-10-PCS Procedure 79"
label var I10_PR80                 "ICD-10-PCS Procedure 80"
label var I10_PR81                 "ICD-10-PCS Procedure 81"
label var I10_PR82                 "ICD-10-PCS Procedure 82"
label var I10_PR83                 "ICD-10-PCS Procedure 83"
label var I10_PR84                 "ICD-10-PCS Procedure 84"
label var I10_PR85                 "ICD-10-PCS Procedure 85"
label var I10_PR86                 "ICD-10-PCS Procedure 86"
label var I10_PR87                 "ICD-10-PCS Procedure 87"
label var I10_PR88                 "ICD-10-PCS Procedure 88"
label var I10_PR89                 "ICD-10-PCS Procedure 89"
label var I10_PR90                 "ICD-10-PCS Procedure 90"
label var I10_PR91                 "ICD-10-PCS Procedure 91"
label var I10_PR92                 "ICD-10-PCS Procedure 92"
label var I10_PR93                 "ICD-10-PCS Procedure 93"
label var I10_PR94                 "ICD-10-PCS Procedure 94"
label var I10_PR95                 "ICD-10-PCS Procedure 95"
label var I10_PR96                 "ICD-10-PCS Procedure 96"
label var I10_PR97                 "ICD-10-PCS Procedure 97"
label var I10_PR98                 "ICD-10-PCS Procedure 98"
label var I10_PR99                 "ICD-10-PCS Procedure 99"
label var I10_PR100                "ICD-10-PCS Procedure 100"
label var I10_PROCTYPE             "ICD-10-PCS Procedure type indicator"
label var I10_SERVICELINE          "ICD-10-CM/PCS Hospital Service Line"
label var KEY                      "HCUP record identifier"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MARITALSTATUS_X          "Patient's marital status (as received from source)"
label var MARITALSTATUSUB04        "Patient's marital status, UB-04 standard coding"
label var MDC                      "MDC in effect on discharge date"
label var MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MDNUM2_R                 "Physician 2 number (re-identified)"
label var MEDINCSTQ                "Median household income state quartile for patient ZIP Code"
label var MRN_R                    "Medical record number (re-identified)"
label var OS_TIME                  "Observation stay time summed from UNITS"
label var P7EDSRC_X                "Condition Code P7, Direct Inpatient Admission from Emergency Room"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PAY2                     "Secondary expected payer (uniform)"
label var PAY2_X                   "Secondary expected payer (as received from source)"
label var PAY3                     "Tertiary expected payer (uniform)"
label var PAY3_X                   "Tertiary expected payer (as received from source)"
label var PAYER1_X                 "Primary expected payer plan identifier (as received from source)"
label var PAYER2_X                 "Secondary expected payer plan identifier (as received from source)"
label var PAYER3_X                 "Tertiary expected payer plan identifier (as received from source)"
label var PCLASS_ORPROC            "Indicates operating room (major diagnostic or therapeutic) procedure on the record"
label var PL_CBSA                  "Patient location: Core Based Statistical Area (CBSA)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var PL_RUCC                  "Patient location: Rural-Urban Continuum Codes (RUCC)"
label var PL_UIC                   "Patient location: Urban Influence Codes"
label var PL_UR_CAT4               "Patient Location: Urban-Rural 4 Categories"
label var POA_Disch_Edit1          "Discharge has POA missing on all nonexempt diagnoses"
label var POA_Disch_Edit2          "Discharge has POA missing on all nonexempt secondary diagnoses"
label var POA_Hosp_Edit1           "Hospital reported POA as Y on all diagnoses on all discharges"
label var POA_Hosp_Edit2           "Hospital reported POA as missing on all non-Medicare discharges"
label var POA_Hosp_Edit3           "Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
label var POA_Hosp_Edit3_Value     "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
label var PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
label var PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
label var PRDAY1                   "Number of days from admission to I10_PR1"
label var PRDAY2                   "Number of days from admission to I10_PR2"
label var PRDAY3                   "Number of days from admission to I10_PR3"
label var PRDAY4                   "Number of days from admission to I10_PR4"
label var PRDAY5                   "Number of days from admission to I10_PR5"
label var PRDAY6                   "Number of days from admission to I10_PR6"
label var PRDAY7                   "Number of days from admission to I10_PR7"
label var PRDAY8                   "Number of days from admission to I10_PR8"
label var PRDAY9                   "Number of days from admission to I10_PR9"
label var PRDAY10                  "Number of days from admission to I10_PR10"
label var PRDAY11                  "Number of days from admission to I10_PR11"
label var PRDAY12                  "Number of days from admission to I10_PR12"
label var PRDAY13                  "Number of days from admission to I10_PR13"
label var PRDAY14                  "Number of days from admission to I10_PR14"
label var PRDAY15                  "Number of days from admission to I10_PR15"
label var PRDAY16                  "Number of days from admission to I10_PR16"
label var PRDAY17                  "Number of days from admission to I10_PR17"
label var PRDAY18                  "Number of days from admission to I10_PR18"
label var PRDAY19                  "Number of days from admission to I10_PR19"
label var PRDAY20                  "Number of days from admission to I10_PR20"
label var PRDAY21                  "Number of days from admission to I10_PR21"
label var PRDAY22                  "Number of days from admission to I10_PR22"
label var PRDAY23                  "Number of days from admission to I10_PR23"
label var PRDAY24                  "Number of days from admission to I10_PR24"
label var PRDAY25                  "Number of days from admission to I10_PR25"
label var PRDAY26                  "Number of days from admission to I10_PR26"
label var PRDAY27                  "Number of days from admission to I10_PR27"
label var PRDAY28                  "Number of days from admission to I10_PR28"
label var PRDAY29                  "Number of days from admission to I10_PR29"
label var PRDAY30                  "Number of days from admission to I10_PR30"
label var PRDAY31                  "Number of days from admission to I10_PR31"
label var PRDAY32                  "Number of days from admission to I10_PR32"
label var PRDAY33                  "Number of days from admission to I10_PR33"
label var PRDAY34                  "Number of days from admission to I10_PR34"
label var PRDAY35                  "Number of days from admission to I10_PR35"
label var PRDAY36                  "Number of days from admission to I10_PR36"
label var PRDAY37                  "Number of days from admission to I10_PR37"
label var PRDAY38                  "Number of days from admission to I10_PR38"
label var PRDAY39                  "Number of days from admission to I10_PR39"
label var PRDAY40                  "Number of days from admission to I10_PR40"
label var PRDAY41                  "Number of days from admission to I10_PR41"
label var PRDAY42                  "Number of days from admission to I10_PR42"
label var PRDAY43                  "Number of days from admission to I10_PR43"
label var PRDAY44                  "Number of days from admission to I10_PR44"
label var PRDAY45                  "Number of days from admission to I10_PR45"
label var PRDAY46                  "Number of days from admission to I10_PR46"
label var PRDAY47                  "Number of days from admission to I10_PR47"
label var PRDAY48                  "Number of days from admission to I10_PR48"
label var PRDAY49                  "Number of days from admission to I10_PR49"
label var PRDAY50                  "Number of days from admission to I10_PR50"
label var PRDAY51                  "Number of days from admission to I10_PR51"
label var PRDAY52                  "Number of days from admission to I10_PR52"
label var PRDAY53                  "Number of days from admission to I10_PR53"
label var PRDAY54                  "Number of days from admission to I10_PR54"
label var PRDAY55                  "Number of days from admission to I10_PR55"
label var PRDAY56                  "Number of days from admission to I10_PR56"
label var PRDAY57                  "Number of days from admission to I10_PR57"
label var PRDAY58                  "Number of days from admission to I10_PR58"
label var PRDAY59                  "Number of days from admission to I10_PR59"
label var PRDAY60                  "Number of days from admission to I10_PR60"
label var PRDAY61                  "Number of days from admission to I10_PR61"
label var PRDAY62                  "Number of days from admission to I10_PR62"
label var PRDAY63                  "Number of days from admission to I10_PR63"
label var PRDAY64                  "Number of days from admission to I10_PR64"
label var PRDAY65                  "Number of days from admission to I10_PR65"
label var PRDAY66                  "Number of days from admission to I10_PR66"
label var PRDAY67                  "Number of days from admission to I10_PR67"
label var PRDAY68                  "Number of days from admission to I10_PR68"
label var PRDAY69                  "Number of days from admission to I10_PR69"
label var PRDAY70                  "Number of days from admission to I10_PR70"
label var PRDAY71                  "Number of days from admission to I10_PR71"
label var PRDAY72                  "Number of days from admission to I10_PR72"
label var PRDAY73                  "Number of days from admission to I10_PR73"
label var PRDAY74                  "Number of days from admission to I10_PR74"
label var PRDAY75                  "Number of days from admission to I10_PR75"
label var PRDAY76                  "Number of days from admission to I10_PR76"
label var PRDAY77                  "Number of days from admission to I10_PR77"
label var PRDAY78                  "Number of days from admission to I10_PR78"
label var PRDAY79                  "Number of days from admission to I10_PR79"
label var PRDAY80                  "Number of days from admission to I10_PR80"
label var PRDAY81                  "Number of days from admission to I10_PR81"
label var PRDAY82                  "Number of days from admission to I10_PR82"
label var PRDAY83                  "Number of days from admission to I10_PR83"
label var PRDAY84                  "Number of days from admission to I10_PR84"
label var PRDAY85                  "Number of days from admission to I10_PR85"
label var PRDAY86                  "Number of days from admission to I10_PR86"
label var PRDAY87                  "Number of days from admission to I10_PR87"
label var PRDAY88                  "Number of days from admission to I10_PR88"
label var PRDAY89                  "Number of days from admission to I10_PR89"
label var PRDAY90                  "Number of days from admission to I10_PR90"
label var PRDAY91                  "Number of days from admission to I10_PR91"
label var PRDAY92                  "Number of days from admission to I10_PR92"
label var PRDAY93                  "Number of days from admission to I10_PR93"
label var PRDAY94                  "Number of days from admission to I10_PR94"
label var PRDAY95                  "Number of days from admission to I10_PR95"
label var PRDAY96                  "Number of days from admission to I10_PR96"
label var PRDAY97                  "Number of days from admission to I10_PR97"
label var PRDAY98                  "Number of days from admission to I10_PR98"
label var PRDAY99                  "Number of days from admission to I10_PR99"
label var PRDAY100                 "Number of days from admission to I10_PR100"
label var PrimLang                 "Primary language of patient"
label var PSTATE                   "Patient State postal code"
label var PSTATE_GEO               "Patient State postal code assigned from ZIP Code"
label var PSTCO                    "Patient state/county FIPS code"
label var PSTCO_GEO                "Counties assigned based on ZIP Code geographic centroids"
label var RACE                     "Race (uniform)"
label var RACE_PCT_MISS_HOSP       "Hospital percentage of missing or invalid race values"
label var RACE_X                   "Race (as received from source)"
label var READMIT                  "Readmission"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var TRAN_IN                  "Transfer in indicator"
label var TRAN_OUT                 "Transfer out indicator"
label var VisitLink                "Visit linkage variable"
label var YEAR                     "Calendar year"
label var ZIP                      "Patient ZIP Code"
label var ZIP3                     "Patient ZIP Code, first 3 digits"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
label var AYEAR                    "Admission year"

/*** Convert special values to missing values ***/
recode AGE                       (-99 -88 -66=.)
recode AGEDAY                    (-99 -88 -66=.)
recode AGEMONTH                  (-99 -88 -66=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode BWT                       (-999 -888 -666=.)
recode DaysBurnUnit              (-99 -88 -66=.)
recode DaysCCU                   (-99 -88 -66=.)
recode DaysICU                   (-99 -88 -66=.)
recode DaysNICU                  (-99 -88 -66=.)
recode DaysPICU                  (-99 -88 -66=.)
recode DaysShockUnit             (-99 -88 -66=.)
recode DaysToEvent               (-99999 -88888 -66666=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISPUB04                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DRG                       (-99 -88 -66=.)
recode DRG_NoPOA                 (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-9 -8 -6 -5=.)
recode HCUP_OS                   (-9 -8 -6 -5=.)
recode HISPANIC                  (-9 -8 -6 -5=.)
recode Homeless                  (-9 -8 -6 -5=.)
recode HospitalUnit              (-9 -8 -6 -5=.)
recode I10_BIRTH                 (-99 -88 -66=.)
recode I10_DELIVERY              (-99 -88 -66=.)
recode I10_NDX                   (-99 -88 -66=.)
recode I10_NPR                   (-99 -88 -66=.)
recode I10_PROCTYPE              (-99 -88 -66=.)
recode I10_SERVICELINE           (-9 -8 -6 -5=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC_NoPOA                 (-9 -8 -6 -5=.)
recode MDNUM1_R                  (-99999999 -88888888 -66666666=.)
recode MDNUM2_R                  (-99999999 -88888888 -66666666=.)
recode MEDINCSTQ                 (-9 -8 -6 -5=.)
recode MRN_R                     (-99999999 -88888888 -66666666=.)
recode OS_TIME                   (-9999999.99 -8888888.88 -6666666.66=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PAY2                      (-9 -8 -6 -5=.)
recode PAY3                      (-9 -8 -6 -5=.)
recode PCLASS_ORPROC             (-9 -8 -6 -5=.)
recode PL_CBSA                   (-99 -88 -66=.)
recode PL_NCHS                   (-9 -8 -6 -5=.)
recode PL_RUCC                   (-9 -8 -6 -5=.)
recode PL_UIC                    (-9 -8 -6 -5=.)
recode PL_UR_CAT4                (-9 -8 -6 -5=.)
recode POA_Disch_Edit1           (-9 -8 -6 -5=.)
recode POA_Disch_Edit2           (-9 -8 -6 -5=.)
recode POA_Hosp_Edit1            (-9 -8 -6 -5=.)
recode POA_Hosp_Edit2            (-9 -8 -6 -5=.)
recode POA_Hosp_Edit3            (-9 -8 -6 -5=.)
recode POA_Hosp_Edit3_Value      (-9999.99 -8888.88 -6666.66=.)
recode PRDAY1                    (-9999 -8888 -6666=.)
recode PRDAY2                    (-9999 -8888 -6666=.)
recode PRDAY3                    (-9999 -8888 -6666=.)
recode PRDAY4                    (-9999 -8888 -6666=.)
recode PRDAY5                    (-9999 -8888 -6666=.)
recode PRDAY6                    (-9999 -8888 -6666=.)
recode PRDAY7                    (-9999 -8888 -6666=.)
recode PRDAY8                    (-9999 -8888 -6666=.)
recode PRDAY9                    (-9999 -8888 -6666=.)
recode PRDAY10                   (-9999 -8888 -6666=.)
recode PRDAY11                   (-9999 -8888 -6666=.)
recode PRDAY12                   (-9999 -8888 -6666=.)
recode PRDAY13                   (-9999 -8888 -6666=.)
recode PRDAY14                   (-9999 -8888 -6666=.)
recode PRDAY15                   (-9999 -8888 -6666=.)
recode PRDAY16                   (-9999 -8888 -6666=.)
recode PRDAY17                   (-9999 -8888 -6666=.)
recode PRDAY18                   (-9999 -8888 -6666=.)
recode PRDAY19                   (-9999 -8888 -6666=.)
recode PRDAY20                   (-9999 -8888 -6666=.)
recode PRDAY21                   (-9999 -8888 -6666=.)
recode PRDAY22                   (-9999 -8888 -6666=.)
recode PRDAY23                   (-9999 -8888 -6666=.)
recode PRDAY24                   (-9999 -8888 -6666=.)
recode PRDAY25                   (-9999 -8888 -6666=.)
recode PRDAY26                   (-9999 -8888 -6666=.)
recode PRDAY27                   (-9999 -8888 -6666=.)
recode PRDAY28                   (-9999 -8888 -6666=.)
recode PRDAY29                   (-9999 -8888 -6666=.)
recode PRDAY30                   (-9999 -8888 -6666=.)
recode PRDAY31                   (-9999 -8888 -6666=.)
recode PRDAY32                   (-9999 -8888 -6666=.)
recode PRDAY33                   (-9999 -8888 -6666=.)
recode PRDAY34                   (-9999 -8888 -6666=.)
recode PRDAY35                   (-9999 -8888 -6666=.)
recode PRDAY36                   (-9999 -8888 -6666=.)
recode PRDAY37                   (-9999 -8888 -6666=.)
recode PRDAY38                   (-9999 -8888 -6666=.)
recode PRDAY39                   (-9999 -8888 -6666=.)
recode PRDAY40                   (-9999 -8888 -6666=.)
recode PRDAY41                   (-9999 -8888 -6666=.)
recode PRDAY42                   (-9999 -8888 -6666=.)
recode PRDAY43                   (-9999 -8888 -6666=.)
recode PRDAY44                   (-9999 -8888 -6666=.)
recode PRDAY45                   (-9999 -8888 -6666=.)
recode PRDAY46                   (-9999 -8888 -6666=.)
recode PRDAY47                   (-9999 -8888 -6666=.)
recode PRDAY48                   (-9999 -8888 -6666=.)
recode PRDAY49                   (-9999 -8888 -6666=.)
recode PRDAY50                   (-9999 -8888 -6666=.)
recode PRDAY51                   (-9999 -8888 -6666=.)
recode PRDAY52                   (-9999 -8888 -6666=.)
recode PRDAY53                   (-9999 -8888 -6666=.)
recode PRDAY54                   (-9999 -8888 -6666=.)
recode PRDAY55                   (-9999 -8888 -6666=.)
recode PRDAY56                   (-9999 -8888 -6666=.)
recode PRDAY57                   (-9999 -8888 -6666=.)
recode PRDAY58                   (-9999 -8888 -6666=.)
recode PRDAY59                   (-9999 -8888 -6666=.)
recode PRDAY60                   (-9999 -8888 -6666=.)
recode PRDAY61                   (-9999 -8888 -6666=.)
recode PRDAY62                   (-9999 -8888 -6666=.)
recode PRDAY63                   (-9999 -8888 -6666=.)
recode PRDAY64                   (-9999 -8888 -6666=.)
recode PRDAY65                   (-9999 -8888 -6666=.)
recode PRDAY66                   (-9999 -8888 -6666=.)
recode PRDAY67                   (-9999 -8888 -6666=.)
recode PRDAY68                   (-9999 -8888 -6666=.)
recode PRDAY69                   (-9999 -8888 -6666=.)
recode PRDAY70                   (-9999 -8888 -6666=.)
recode PRDAY71                   (-9999 -8888 -6666=.)
recode PRDAY72                   (-9999 -8888 -6666=.)
recode PRDAY73                   (-9999 -8888 -6666=.)
recode PRDAY74                   (-9999 -8888 -6666=.)
recode PRDAY75                   (-9999 -8888 -6666=.)
recode PRDAY76                   (-9999 -8888 -6666=.)
recode PRDAY77                   (-9999 -8888 -6666=.)
recode PRDAY78                   (-9999 -8888 -6666=.)
recode PRDAY79                   (-9999 -8888 -6666=.)
recode PRDAY80                   (-9999 -8888 -6666=.)
recode PRDAY81                   (-9999 -8888 -6666=.)
recode PRDAY82                   (-9999 -8888 -6666=.)
recode PRDAY83                   (-9999 -8888 -6666=.)
recode PRDAY84                   (-9999 -8888 -6666=.)
recode PRDAY85                   (-9999 -8888 -6666=.)
recode PRDAY86                   (-9999 -8888 -6666=.)
recode PRDAY87                   (-9999 -8888 -6666=.)
recode PRDAY88                   (-9999 -8888 -6666=.)
recode PRDAY89                   (-9999 -8888 -6666=.)
recode PRDAY90                   (-9999 -8888 -6666=.)
recode PRDAY91                   (-9999 -8888 -6666=.)
recode PRDAY92                   (-9999 -8888 -6666=.)
recode PRDAY93                   (-9999 -8888 -6666=.)
recode PRDAY94                   (-9999 -8888 -6666=.)
recode PRDAY95                   (-9999 -8888 -6666=.)
recode PRDAY96                   (-9999 -8888 -6666=.)
recode PRDAY97                   (-9999 -8888 -6666=.)
recode PRDAY98                   (-9999 -8888 -6666=.)
recode PRDAY99                   (-9999 -8888 -6666=.)
recode PRDAY100                  (-9999 -8888 -6666=.)
recode PSTCO                     (-9999 -8888 -6666=.)
recode PSTCO_GEO                 (-9999 -8888 -6666=.)
recode RACE                      (-9 -8 -6 -5=.)
recode RACE_PCT_MISS_HOSP        (-999.99 -888.88 -666.66=.)
recode READMIT                   (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode TRAN_IN                   (-9 -8 -6 -5=.)
recode TRAN_OUT                  (-9 -8 -6 -5=.)
recode VisitLink                 (-99999999 -88888888 -66666666=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-99 -88 -66=.)
recode AYEAR                     (-999 -888 -666=.)

save "MD_SID_2023_CORE.dta", replace
