/*****************************************************************************
* Creation Date: 08/12/2024   
* HI_SID_2020_CORE.Do
* This program will load the 2020 HI ASCII CORE File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/*** Set available memory size ***/
set mem 500m

/*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***/
infix 3 firstlineoffile                            ///
      int    AGE                          1-   3   ///
      int    AGE_NEONATE                  4-   6   ///
      byte   AMONTH                       7-   8   ///
      byte   ATYPE                        9-  10   ///
      byte   AWEEKEND                    11-  12   ///
      int    BWT                         13-  16   ///
      byte   DIED                        17-  18   ///
      str    DISP_X                      19-  20   ///
      byte   DISPUB04                    21-  22   ///
      byte   DISPUNIFORM                 23-  24   ///
      byte   DMONTH                      25-  26   ///
      byte   DQTR                        27-  28   ///
      int    DRG                         29-  31   ///
      int    DRG_NoPOA                   32-  34   ///
      byte   DRGVER                      35-  36   ///
      str    DSHOSPID                    37-  53   ///
      str    DXPOA1                      54        ///
      str    DXPOA2                      55        ///
      str    DXPOA3                      56        ///
      str    DXPOA4                      57        ///
      str    DXPOA5                      58        ///
      str    DXPOA6                      59        ///
      str    DXPOA7                      60        ///
      str    DXPOA8                      61        ///
      str    DXPOA9                      62        ///
      str    DXPOA10                     63        ///
      str    DXPOA11                     64        ///
      str    DXPOA12                     65        ///
      str    DXPOA13                     66        ///
      str    DXPOA14                     67        ///
      str    DXPOA15                     68        ///
      str    DXPOA16                     69        ///
      str    DXPOA17                     70        ///
      str    DXPOA18                     71        ///
      str    DXPOA19                     72        ///
      str    DXPOA20                     73        ///
      str    DXPOA21                     74        ///
      str    DXPOA22                     75        ///
      str    DXPOA23                     76        ///
      str    DXPOA24                     77        ///
      str    DXPOA25                     78        ///
      str    DXPOA26                     79        ///
      str    DXPOA27                     80        ///
      str    DXPOA28                     81        ///
      str    DXPOA29                     82        ///
      str    DXPOA30                     83        ///
      str    DXPOA31                     84        ///
      str    DXPOA32                     85        ///
      str    DXPOA33                     86        ///
      str    DXPOA34                     87        ///
      str    DXPOA35                     88        ///
      str    DXPOA36                     89        ///
      str    DXPOA37                     90        ///
      str    DXPOA38                     91        ///
      str    DXPOA39                     92        ///
      str    DXPOA40                     93        ///
      str    DXPOA41                     94        ///
      str    DXPOA42                     95        ///
      byte   FEMALE                      96-  97   ///
      byte   HCUP_ED                     98-  99   ///
      byte   HCUP_OS                    100- 101   ///
      byte   HISPANIC                   102- 103   ///
      str    HOSPST                     104- 105   ///
      int    I10_BIRTH                  106- 108   ///
      int    I10_DELIVERY               109- 111   ///
      str    I10_DX1                    112- 118   ///
      str    I10_DX2                    119- 125   ///
      str    I10_DX3                    126- 132   ///
      str    I10_DX4                    133- 139   ///
      str    I10_DX5                    140- 146   ///
      str    I10_DX6                    147- 153   ///
      str    I10_DX7                    154- 160   ///
      str    I10_DX8                    161- 167   ///
      str    I10_DX9                    168- 174   ///
      str    I10_DX10                   175- 181   ///
      str    I10_DX11                   182- 188   ///
      str    I10_DX12                   189- 195   ///
      str    I10_DX13                   196- 202   ///
      str    I10_DX14                   203- 209   ///
      str    I10_DX15                   210- 216   ///
      str    I10_DX16                   217- 223   ///
      str    I10_DX17                   224- 230   ///
      str    I10_DX18                   231- 237   ///
      str    I10_DX19                   238- 244   ///
      str    I10_DX20                   245- 251   ///
      str    I10_DX21                   252- 258   ///
      str    I10_DX22                   259- 265   ///
      str    I10_DX23                   266- 272   ///
      str    I10_DX24                   273- 279   ///
      str    I10_DX25                   280- 286   ///
      str    I10_DX26                   287- 293   ///
      str    I10_DX27                   294- 300   ///
      str    I10_DX28                   301- 307   ///
      str    I10_DX29                   308- 314   ///
      str    I10_DX30                   315- 321   ///
      str    I10_DX31                   322- 328   ///
      str    I10_DX32                   329- 335   ///
      str    I10_DX33                   336- 342   ///
      str    I10_DX34                   343- 349   ///
      str    I10_DX35                   350- 356   ///
      str    I10_DX36                   357- 363   ///
      str    I10_DX37                   364- 370   ///
      str    I10_DX38                   371- 377   ///
      str    I10_DX39                   378- 384   ///
      str    I10_DX40                   385- 391   ///
      str    I10_DX41                   392- 398   ///
      str    I10_DX42                   399- 405   ///
      int    I10_NDX                    406- 408   ///
      int    I10_NPR                    409- 411   ///
      str    I10_PR1                    412- 418   ///
      str    I10_PR2                    419- 425   ///
      str    I10_PR3                    426- 432   ///
      str    I10_PR4                    433- 439   ///
      str    I10_PR5                    440- 446   ///
      str    I10_PR6                    447- 453   ///
      str    I10_PR7                    454- 460   ///
      str    I10_PR8                    461- 467   ///
      str    I10_PR9                    468- 474   ///
      str    I10_PR10                   475- 481   ///
      str    I10_PR11                   482- 488   ///
      str    I10_PR12                   489- 495   ///
      str    I10_PR13                   496- 502   ///
      str    I10_PR14                   503- 509   ///
      str    I10_PR15                   510- 516   ///
      str    I10_PR16                   517- 523   ///
      str    I10_PR17                   524- 530   ///
      str    I10_PR18                   531- 537   ///
      str    I10_PR19                   538- 544   ///
      str    I10_PR20                   545- 551   ///
      str    I10_PR21                   552- 558   ///
      str    I10_PR22                   559- 565   ///
      str    I10_PR23                   566- 572   ///
      str    I10_PR24                   573- 579   ///
      str    I10_PR25                   580- 586   ///
      str    I10_PR26                   587- 593   ///
      str    I10_PR27                   594- 600   ///
      str    I10_PR28                   601- 607   ///
      str    I10_PR29                   608- 614   ///
      str    I10_PR30                   615- 621   ///
      str    I10_PR31                   622- 628   ///
      str    I10_PR32                   629- 635   ///
      str    I10_PR33                   636- 642   ///
      str    I10_PR34                   643- 649   ///
      str    I10_PR35                   650- 656   ///
      int    I10_PROCTYPE               657- 659   ///
      byte   I10_SERVICELINE            660- 661   ///
      double KEY                        662- 676   ///
      long   LOS                        677- 681   ///
      long   LOS_X                      682- 687   ///
      byte   MDC                        688- 689   ///
      byte   MDC_NoPOA                  690- 691   ///
      long   MDNUM1_R                   692- 700   ///
      long   MDNUM2_R                   701- 709   ///
      long   MDNUM3_R                   710- 718   ///
      byte   MEDINCSTQ                  719- 720   ///
      byte   PAY1                       721- 722   ///
      str    PAY1_X                     723- 724   ///
      byte   PCLASS_ORPROC              725- 726   ///
      int    PL_CBSA                    727- 729   ///
      byte   PL_NCHS                    730- 731   ///
      byte   PL_RUCC                    732- 733   ///
      byte   PL_UIC                     734- 735   ///
      byte   PL_UR_CAT4                 736- 737   ///
      byte   POA_Disch_Edit1            738- 739   ///
      byte   POA_Disch_Edit2            740- 741   ///
      byte   POA_Hosp_Edit1             742- 743   ///
      byte   POA_Hosp_Edit2             744- 745   ///
      byte   POA_Hosp_Edit3             746- 747   ///
      double POA_Hosp_Edit3_Value       748- 755   ///
      str    PointOfOrigin_X            756        ///
      str    PointOfOriginUB04          757        ///
      long   PRDAY1                     758- 762   ///
      long   PRDAY2                     763- 767   ///
      long   PRDAY3                     768- 772   ///
      long   PRDAY4                     773- 777   ///
      long   PRDAY5                     778- 782   ///
      long   PRDAY6                     783- 787   ///
      long   PRDAY7                     788- 792   ///
      long   PRDAY8                     793- 797   ///
      long   PRDAY9                     798- 802   ///
      long   PRDAY10                    803- 807   ///
      long   PRDAY11                    808- 812   ///
      long   PRDAY12                    813- 817   ///
      long   PRDAY13                    818- 822   ///
      long   PRDAY14                    823- 827   ///
      long   PRDAY15                    828- 832   ///
      long   PRDAY16                    833- 837   ///
      long   PRDAY17                    838- 842   ///
      long   PRDAY18                    843- 847   ///
      long   PRDAY19                    848- 852   ///
      long   PRDAY20                    853- 857   ///
      long   PRDAY21                    858- 862   ///
      long   PRDAY22                    863- 867   ///
      long   PRDAY23                    868- 872   ///
      long   PRDAY24                    873- 877   ///
      long   PRDAY25                    878- 882   ///
      long   PRDAY26                    883- 887   ///
      long   PRDAY27                    888- 892   ///
      long   PRDAY28                    893- 897   ///
      long   PRDAY29                    898- 902   ///
      long   PRDAY30                    903- 907   ///
      long   PRDAY31                    908- 912   ///
      long   PRDAY32                    913- 917   ///
      long   PRDAY33                    918- 922   ///
      long   PRDAY34                    923- 927   ///
      long   PRDAY35                    928- 932   ///
      str    PrimLang                   933- 935   ///
      str    PSTATE                     936- 937   ///
      str    PSTATE_GEO                 938- 939   ///
      long   PSTCO_GEO                  940- 944   ///
      byte   RACE                       945- 946   ///
      float  RACE_PCT_MISS_HOSP         947- 953   ///
      str    RACE_X                     954- 955   ///
      double TOTCHG                     956- 965   ///
      double TOTCHG_X                   966- 980   ///
      byte   TRAN_IN                    981- 982   ///
      byte   TRAN_OUT                   983- 984   ///
      int    YEAR                       985- 988   ///
      str    ZIP                        989- 993   ///
      str    ZIP3                       994- 996   ///
      int    ZIPINC_QRTL                997- 999   ///
      long   VisitLink                 1000-1008   ///
      long   DaysToEvent               1009-1014   ///
      int    AYEAR                     1015-1018   ///
      byte   PRMONTH1                  1019-1020   ///
      byte   PRMONTH2                  1021-1022   ///
      byte   PRMONTH3                  1023-1024   ///
      byte   PRMONTH4                  1025-1026   ///
      byte   PRMONTH5                  1027-1028   ///
      byte   PRMONTH6                  1029-1030   ///
      byte   PRMONTH7                  1031-1032   ///
      byte   PRMONTH8                  1033-1034   ///
      byte   PRMONTH9                  1035-1036   ///
      byte   PRMONTH10                 1037-1038   ///
      byte   PRMONTH11                 1039-1040   ///
      byte   PRMONTH12                 1041-1042   ///
      byte   PRMONTH13                 1043-1044   ///
      byte   PRMONTH14                 1045-1046   ///
      byte   PRMONTH15                 1047-1048   ///
      byte   PRMONTH16                 1049-1050   ///
      byte   PRMONTH17                 1051-1052   ///
      byte   PRMONTH18                 1053-1054   ///
      byte   PRMONTH19                 1055-1056   ///
      byte   PRMONTH20                 1057-1058   ///
      byte   PRMONTH21                 1059-1060   ///
      byte   PRMONTH22                 1061-1062   ///
      byte   PRMONTH23                 1063-1064   ///
      byte   PRMONTH24                 1065-1066   ///
      byte   PRMONTH25                 1067-1068   ///
      byte   PRMONTH26                 1069-1070   ///
      byte   PRMONTH27                 1071-1072   ///
      byte   PRMONTH28                 1073-1074   ///
      byte   PRMONTH29                 1075-1076   ///
      byte   PRMONTH30                 1077-1078   ///
      byte   PRMONTH31                 1079-1080   ///
      byte   PRMONTH32                 1081-1082   ///
      byte   PRMONTH33                 1083-1084   ///
      byte   PRMONTH34                 1085-1086   ///
      byte   PRMONTH35                 1087-1088   ///
      int    PRYEAR1                   1089-1092   ///
      int    PRYEAR2                   1093-1096   ///
      int    PRYEAR3                   1097-1100   ///
      int    PRYEAR4                   1101-1104   ///
      int    PRYEAR5                   1105-1108   ///
      int    PRYEAR6                   1109-1112   ///
      int    PRYEAR7                   1113-1116   ///
      int    PRYEAR8                   1117-1120   ///
      int    PRYEAR9                   1121-1124   ///
      int    PRYEAR10                  1125-1128   ///
      int    PRYEAR11                  1129-1132   ///
      int    PRYEAR12                  1133-1136   ///
      int    PRYEAR13                  1137-1140   ///
      int    PRYEAR14                  1141-1144   ///
      int    PRYEAR15                  1145-1148   ///
      int    PRYEAR16                  1149-1152   ///
      int    PRYEAR17                  1153-1156   ///
      int    PRYEAR18                  1157-1160   ///
      int    PRYEAR19                  1161-1164   ///
      int    PRYEAR20                  1165-1168   ///
      int    PRYEAR21                  1169-1172   ///
      int    PRYEAR22                  1173-1176   ///
      int    PRYEAR23                  1177-1180   ///
      int    PRYEAR24                  1181-1184   ///
      int    PRYEAR25                  1185-1188   ///
      int    PRYEAR26                  1189-1192   ///
      int    PRYEAR27                  1193-1196   ///
      int    PRYEAR28                  1197-1200   ///
      int    PRYEAR29                  1201-1204   ///
      int    PRYEAR30                  1205-1208   ///
      int    PRYEAR31                  1209-1212   ///
      int    PRYEAR32                  1213-1216   ///
      int    PRYEAR33                  1217-1220   ///
      int    PRYEAR34                  1221-1224   ///
      int    PRYEAR35                  1225-1228   ///
      using  "HI_SID_2020_CORE.asc"

/***  Assign labels to the data elements ***/
label var AGE                      "Age in years at admission"
label var AGE_NEONATE              "Neonatal age (first 28 days after birth) indicator"
label var AMONTH                   "Admission month"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var BWT                      "Birth weight in grams"
label var DIED                     "Died during hospitalization"
label var DISP_X                   "Disposition of patient (as received from source)"
label var DISPUB04                 "Disposition of patient (UB-04 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DMONTH                   "Discharge month"
label var DQTR                     "Discharge quarter"
label var DRG                      "DRG in effect on discharge date"
label var DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DSHOSPID                 "Data source hospital identifier"
label var DXPOA1                   "Diagnosis 1, present on admission indicator"
label var DXPOA2                   "Diagnosis 2, present on admission indicator"
label var DXPOA3                   "Diagnosis 3, present on admission indicator"
label var DXPOA4                   "Diagnosis 4, present on admission indicator"
label var DXPOA5                   "Diagnosis 5, present on admission indicator"
label var DXPOA6                   "Diagnosis 6, present on admission indicator"
label var DXPOA7                   "Diagnosis 7, present on admission indicator"
label var DXPOA8                   "Diagnosis 8, present on admission indicator"
label var DXPOA9                   "Diagnosis 9, present on admission indicator"
label var DXPOA10                  "Diagnosis 10, present on admission indicator"
label var DXPOA11                  "Diagnosis 11, present on admission indicator"
label var DXPOA12                  "Diagnosis 12, present on admission indicator"
label var DXPOA13                  "Diagnosis 13, present on admission indicator"
label var DXPOA14                  "Diagnosis 14, present on admission indicator"
label var DXPOA15                  "Diagnosis 15, present on admission indicator"
label var DXPOA16                  "Diagnosis 16, present on admission indicator"
label var DXPOA17                  "Diagnosis 17, present on admission indicator"
label var DXPOA18                  "Diagnosis 18, present on admission indicator"
label var DXPOA19                  "Diagnosis 19, present on admission indicator"
label var DXPOA20                  "Diagnosis 20, present on admission indicator"
label var DXPOA21                  "Diagnosis 21, present on admission indicator"
label var DXPOA22                  "Diagnosis 22, present on admission indicator"
label var DXPOA23                  "Diagnosis 23, present on admission indicator"
label var DXPOA24                  "Diagnosis 24, present on admission indicator"
label var DXPOA25                  "Diagnosis 25, present on admission indicator"
label var DXPOA26                  "Diagnosis 26, present on admission indicator"
label var DXPOA27                  "Diagnosis 27, present on admission indicator"
label var DXPOA28                  "Diagnosis 28, present on admission indicator"
label var DXPOA29                  "Diagnosis 29, present on admission indicator"
label var DXPOA30                  "Diagnosis 30, present on admission indicator"
label var DXPOA31                  "Diagnosis 31, present on admission indicator"
label var DXPOA32                  "Diagnosis 32, present on admission indicator"
label var DXPOA33                  "Diagnosis 33, present on admission indicator"
label var DXPOA34                  "Diagnosis 34, present on admission indicator"
label var DXPOA35                  "Diagnosis 35, present on admission indicator"
label var DXPOA36                  "Diagnosis 36, present on admission indicator"
label var DXPOA37                  "Diagnosis 37, present on admission indicator"
label var DXPOA38                  "Diagnosis 38, present on admission indicator"
label var DXPOA39                  "Diagnosis 39, present on admission indicator"
label var DXPOA40                  "Diagnosis 40, present on admission indicator"
label var DXPOA41                  "Diagnosis 41, present on admission indicator"
label var DXPOA42                  "Diagnosis 42, present on admission indicator"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HCUP_OS                  "HCUP Observation Stay service indicator"
label var HISPANIC                 "Hispanic ethnicity (uniform)"
label var HOSPST                   "Hospital state postal code"
label var I10_BIRTH                "ICD-10-CM Birth Indicator"
label var I10_DELIVERY             "ICD-10-CM Delivery Indicator"
label var I10_DX1                  "ICD-10-CM Diagnosis 1"
label var I10_DX2                  "ICD-10-CM Diagnosis 2"
label var I10_DX3                  "ICD-10-CM Diagnosis 3"
label var I10_DX4                  "ICD-10-CM Diagnosis 4"
label var I10_DX5                  "ICD-10-CM Diagnosis 5"
label var I10_DX6                  "ICD-10-CM Diagnosis 6"
label var I10_DX7                  "ICD-10-CM Diagnosis 7"
label var I10_DX8                  "ICD-10-CM Diagnosis 8"
label var I10_DX9                  "ICD-10-CM Diagnosis 9"
label var I10_DX10                 "ICD-10-CM Diagnosis 10"
label var I10_DX11                 "ICD-10-CM Diagnosis 11"
label var I10_DX12                 "ICD-10-CM Diagnosis 12"
label var I10_DX13                 "ICD-10-CM Diagnosis 13"
label var I10_DX14                 "ICD-10-CM Diagnosis 14"
label var I10_DX15                 "ICD-10-CM Diagnosis 15"
label var I10_DX16                 "ICD-10-CM Diagnosis 16"
label var I10_DX17                 "ICD-10-CM Diagnosis 17"
label var I10_DX18                 "ICD-10-CM Diagnosis 18"
label var I10_DX19                 "ICD-10-CM Diagnosis 19"
label var I10_DX20                 "ICD-10-CM Diagnosis 20"
label var I10_DX21                 "ICD-10-CM Diagnosis 21"
label var I10_DX22                 "ICD-10-CM Diagnosis 22"
label var I10_DX23                 "ICD-10-CM Diagnosis 23"
label var I10_DX24                 "ICD-10-CM Diagnosis 24"
label var I10_DX25                 "ICD-10-CM Diagnosis 25"
label var I10_DX26                 "ICD-10-CM Diagnosis 26"
label var I10_DX27                 "ICD-10-CM Diagnosis 27"
label var I10_DX28                 "ICD-10-CM Diagnosis 28"
label var I10_DX29                 "ICD-10-CM Diagnosis 29"
label var I10_DX30                 "ICD-10-CM Diagnosis 30"
label var I10_DX31                 "ICD-10-CM Diagnosis 31"
label var I10_DX32                 "ICD-10-CM Diagnosis 32"
label var I10_DX33                 "ICD-10-CM Diagnosis 33"
label var I10_DX34                 "ICD-10-CM Diagnosis 34"
label var I10_DX35                 "ICD-10-CM Diagnosis 35"
label var I10_DX36                 "ICD-10-CM Diagnosis 36"
label var I10_DX37                 "ICD-10-CM Diagnosis 37"
label var I10_DX38                 "ICD-10-CM Diagnosis 38"
label var I10_DX39                 "ICD-10-CM Diagnosis 39"
label var I10_DX40                 "ICD-10-CM Diagnosis 40"
label var I10_DX41                 "ICD-10-CM Diagnosis 41"
label var I10_DX42                 "ICD-10-CM Diagnosis 42"
label var I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
label var I10_NPR                  "ICD-10-PCS Number of procedures on this record"
label var I10_PR1                  "ICD-10-PCS Procedure 1"
label var I10_PR2                  "ICD-10-PCS Procedure 2"
label var I10_PR3                  "ICD-10-PCS Procedure 3"
label var I10_PR4                  "ICD-10-PCS Procedure 4"
label var I10_PR5                  "ICD-10-PCS Procedure 5"
label var I10_PR6                  "ICD-10-PCS Procedure 6"
label var I10_PR7                  "ICD-10-PCS Procedure 7"
label var I10_PR8                  "ICD-10-PCS Procedure 8"
label var I10_PR9                  "ICD-10-PCS Procedure 9"
label var I10_PR10                 "ICD-10-PCS Procedure 10"
label var I10_PR11                 "ICD-10-PCS Procedure 11"
label var I10_PR12                 "ICD-10-PCS Procedure 12"
label var I10_PR13                 "ICD-10-PCS Procedure 13"
label var I10_PR14                 "ICD-10-PCS Procedure 14"
label var I10_PR15                 "ICD-10-PCS Procedure 15"
label var I10_PR16                 "ICD-10-PCS Procedure 16"
label var I10_PR17                 "ICD-10-PCS Procedure 17"
label var I10_PR18                 "ICD-10-PCS Procedure 18"
label var I10_PR19                 "ICD-10-PCS Procedure 19"
label var I10_PR20                 "ICD-10-PCS Procedure 20"
label var I10_PR21                 "ICD-10-PCS Procedure 21"
label var I10_PR22                 "ICD-10-PCS Procedure 22"
label var I10_PR23                 "ICD-10-PCS Procedure 23"
label var I10_PR24                 "ICD-10-PCS Procedure 24"
label var I10_PR25                 "ICD-10-PCS Procedure 25"
label var I10_PR26                 "ICD-10-PCS Procedure 26"
label var I10_PR27                 "ICD-10-PCS Procedure 27"
label var I10_PR28                 "ICD-10-PCS Procedure 28"
label var I10_PR29                 "ICD-10-PCS Procedure 29"
label var I10_PR30                 "ICD-10-PCS Procedure 30"
label var I10_PR31                 "ICD-10-PCS Procedure 31"
label var I10_PR32                 "ICD-10-PCS Procedure 32"
label var I10_PR33                 "ICD-10-PCS Procedure 33"
label var I10_PR34                 "ICD-10-PCS Procedure 34"
label var I10_PR35                 "ICD-10-PCS Procedure 35"
label var I10_PROCTYPE             "ICD-10-PCS Procedure type indicator"
label var I10_SERVICELINE          "ICD-10-CM/PCS Hospital Service Line"
label var KEY                      "HCUP record identifier"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDC                      "MDC in effect on discharge date"
label var MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MDNUM2_R                 "Physician 2 number (re-identified)"
label var MDNUM3_R                 "Physician 3 number (re-identified)"
label var MEDINCSTQ                "Median household income state quartile for patient ZIP Code"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PCLASS_ORPROC            "Indicates operating room (major diagnostic or therapeutic) procedure on the record"
label var PL_CBSA                  "Patient location: Core Based Statistical Area (CBSA)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var PL_RUCC                  "Patient location: Rural-Urban Continuum Codes (RUCC)"
label var PL_UIC                   "Patient location: Urban Influence Codes"
label var PL_UR_CAT4               "Patient Location: Urban-Rural 4 Categories"
label var POA_Disch_Edit1          "Discharge has POA missing on all nonexempt diagnoses"
label var POA_Disch_Edit2          "Discharge has POA missing on all nonexempt secondary diagnoses"
label var POA_Hosp_Edit1           "Hospital reported POA as Y on all diagnoses on all discharges"
label var POA_Hosp_Edit2           "Hospital reported POA as missing on all non-Medicare discharges"
label var POA_Hosp_Edit3           "Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
label var POA_Hosp_Edit3_Value     "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
label var PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
label var PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
label var PRDAY1                   "Number of days from admission to I10_PR1"
label var PRDAY2                   "Number of days from admission to I10_PR2"
label var PRDAY3                   "Number of days from admission to I10_PR3"
label var PRDAY4                   "Number of days from admission to I10_PR4"
label var PRDAY5                   "Number of days from admission to I10_PR5"
label var PRDAY6                   "Number of days from admission to I10_PR6"
label var PRDAY7                   "Number of days from admission to I10_PR7"
label var PRDAY8                   "Number of days from admission to I10_PR8"
label var PRDAY9                   "Number of days from admission to I10_PR9"
label var PRDAY10                  "Number of days from admission to I10_PR10"
label var PRDAY11                  "Number of days from admission to I10_PR11"
label var PRDAY12                  "Number of days from admission to I10_PR12"
label var PRDAY13                  "Number of days from admission to I10_PR13"
label var PRDAY14                  "Number of days from admission to I10_PR14"
label var PRDAY15                  "Number of days from admission to I10_PR15"
label var PRDAY16                  "Number of days from admission to I10_PR16"
label var PRDAY17                  "Number of days from admission to I10_PR17"
label var PRDAY18                  "Number of days from admission to I10_PR18"
label var PRDAY19                  "Number of days from admission to I10_PR19"
label var PRDAY20                  "Number of days from admission to I10_PR20"
label var PRDAY21                  "Number of days from admission to I10_PR21"
label var PRDAY22                  "Number of days from admission to I10_PR22"
label var PRDAY23                  "Number of days from admission to I10_PR23"
label var PRDAY24                  "Number of days from admission to I10_PR24"
label var PRDAY25                  "Number of days from admission to I10_PR25"
label var PRDAY26                  "Number of days from admission to I10_PR26"
label var PRDAY27                  "Number of days from admission to I10_PR27"
label var PRDAY28                  "Number of days from admission to I10_PR28"
label var PRDAY29                  "Number of days from admission to I10_PR29"
label var PRDAY30                  "Number of days from admission to I10_PR30"
label var PRDAY31                  "Number of days from admission to I10_PR31"
label var PRDAY32                  "Number of days from admission to I10_PR32"
label var PRDAY33                  "Number of days from admission to I10_PR33"
label var PRDAY34                  "Number of days from admission to I10_PR34"
label var PRDAY35                  "Number of days from admission to I10_PR35"
label var PrimLang                 "Primary language of patient"
label var PSTATE                   "Patient State postal code"
label var PSTATE_GEO               "Patient State postal code assigned from ZIP Code"
label var PSTCO_GEO                "Counties assigned based on ZIP Code geographic centroids"
label var RACE                     "Race (uniform)"
label var RACE_PCT_MISS_HOSP       "Hospital percentage of missing or invalid race values"
label var RACE_X                   "Race (as received from source)"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var TRAN_IN                  "Transfer in indicator"
label var TRAN_OUT                 "Transfer out indicator"
label var YEAR                     "Calendar year"
label var ZIP                      "Patient ZIP Code"
label var ZIP3                     "Patient ZIP Code, first 3 digits"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
label var VisitLink                "Visit linkage data element"
label var DaysToEvent              "Days from 'start date' to admission"
label var AYEAR                    "Admission year"
label var PRMONTH1                 "Month of procedure 1"
label var PRMONTH2                 "Month of procedure 2"
label var PRMONTH3                 "Month of procedure 3"
label var PRMONTH4                 "Month of procedure 4"
label var PRMONTH5                 "Month of procedure 5"
label var PRMONTH6                 "Month of procedure 6"
label var PRMONTH7                 "Month of procedure 7"
label var PRMONTH8                 "Month of procedure 8"
label var PRMONTH9                 "Month of procedure 9"
label var PRMONTH10                "Month of procedure 10"
label var PRMONTH11                "Month of procedure 11"
label var PRMONTH12                "Month of procedure 12"
label var PRMONTH13                "Month of procedure 13"
label var PRMONTH14                "Month of procedure 14"
label var PRMONTH15                "Month of procedure 15"
label var PRMONTH16                "Month of procedure 16"
label var PRMONTH17                "Month of procedure 17"
label var PRMONTH18                "Month of procedure 18"
label var PRMONTH19                "Month of procedure 19"
label var PRMONTH20                "Month of procedure 20"
label var PRMONTH21                "Month of procedure 21"
label var PRMONTH22                "Month of procedure 22"
label var PRMONTH23                "Month of procedure 23"
label var PRMONTH24                "Month of procedure 24"
label var PRMONTH25                "Month of procedure 25"
label var PRMONTH26                "Month of procedure 26"
label var PRMONTH27                "Month of procedure 27"
label var PRMONTH28                "Month of procedure 28"
label var PRMONTH29                "Month of procedure 29"
label var PRMONTH30                "Month of procedure 30"
label var PRMONTH31                "Month of procedure 31"
label var PRMONTH32                "Month of procedure 32"
label var PRMONTH33                "Month of procedure 33"
label var PRMONTH34                "Month of procedure 34"
label var PRMONTH35                "Month of procedure 35"
label var PRYEAR1                  "Year of procedure 1"
label var PRYEAR2                  "Year of procedure 2"
label var PRYEAR3                  "Year of procedure 3"
label var PRYEAR4                  "Year of procedure 4"
label var PRYEAR5                  "Year of procedure 5"
label var PRYEAR6                  "Year of procedure 6"
label var PRYEAR7                  "Year of procedure 7"
label var PRYEAR8                  "Year of procedure 8"
label var PRYEAR9                  "Year of procedure 9"
label var PRYEAR10                 "Year of procedure 10"
label var PRYEAR11                 "Year of procedure 11"
label var PRYEAR12                 "Year of procedure 12"
label var PRYEAR13                 "Year of procedure 13"
label var PRYEAR14                 "Year of procedure 14"
label var PRYEAR15                 "Year of procedure 15"
label var PRYEAR16                 "Year of procedure 16"
label var PRYEAR17                 "Year of procedure 17"
label var PRYEAR18                 "Year of procedure 18"
label var PRYEAR19                 "Year of procedure 19"
label var PRYEAR20                 "Year of procedure 20"
label var PRYEAR21                 "Year of procedure 21"
label var PRYEAR22                 "Year of procedure 22"
label var PRYEAR23                 "Year of procedure 23"
label var PRYEAR24                 "Year of procedure 24"
label var PRYEAR25                 "Year of procedure 25"
label var PRYEAR26                 "Year of procedure 26"
label var PRYEAR27                 "Year of procedure 27"
label var PRYEAR28                 "Year of procedure 28"
label var PRYEAR29                 "Year of procedure 29"
label var PRYEAR30                 "Year of procedure 30"
label var PRYEAR31                 "Year of procedure 31"
label var PRYEAR32                 "Year of procedure 32"
label var PRYEAR33                 "Year of procedure 33"
label var PRYEAR34                 "Year of procedure 34"
label var PRYEAR35                 "Year of procedure 35"

/*** Convert special values to missing values ***/
recode AGE                       (-99 -88 -66=.)
recode AGE_NEONATE               (-99 -88 -66=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode BWT                       (-999 -888 -666=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISPUB04                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DMONTH                    (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DRG                       (-99 -88 -66=.)
recode DRG_NoPOA                 (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-9 -8 -6 -5=.)
recode HCUP_OS                   (-9 -8 -6 -5=.)
recode HISPANIC                  (-9 -8 -6 -5=.)
recode I10_BIRTH                 (-99 -88 -66=.)
recode I10_DELIVERY              (-99 -88 -66=.)
recode I10_NDX                   (-99 -88 -66=.)
recode I10_NPR                   (-99 -88 -66=.)
recode I10_PROCTYPE              (-99 -88 -66=.)
recode I10_SERVICELINE           (-9 -8 -6 -5=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC_NoPOA                 (-9 -8 -6 -5=.)
recode MDNUM1_R                  (-99999999 -88888888 -66666666=.)
recode MDNUM2_R                  (-99999999 -88888888 -66666666=.)
recode MDNUM3_R                  (-99999999 -88888888 -66666666=.)
recode MEDINCSTQ                 (-9 -8 -6 -5=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PCLASS_ORPROC             (-9 -8 -6 -5=.)
recode PL_CBSA                   (-99 -88 -66=.)
recode PL_NCHS                   (-9 -8 -6 -5=.)
recode PL_RUCC                   (-9 -8 -6 -5=.)
recode PL_UIC                    (-9 -8 -6 -5=.)
recode PL_UR_CAT4                (-9 -8 -6 -5=.)
recode POA_Disch_Edit1           (-9 -8 -6 -5=.)
recode POA_Disch_Edit2           (-9 -8 -6 -5=.)
recode POA_Hosp_Edit1            (-9 -8 -6 -5=.)
recode POA_Hosp_Edit2            (-9 -8 -6 -5=.)
recode POA_Hosp_Edit3            (-9 -8 -6 -5=.)
recode POA_Hosp_Edit3_Value      (-9999.99 -8888.88 -6666.66=.)
recode PRDAY1                    (-9999 -8888 -6666=.)
recode PRDAY2                    (-9999 -8888 -6666=.)
recode PRDAY3                    (-9999 -8888 -6666=.)
recode PRDAY4                    (-9999 -8888 -6666=.)
recode PRDAY5                    (-9999 -8888 -6666=.)
recode PRDAY6                    (-9999 -8888 -6666=.)
recode PRDAY7                    (-9999 -8888 -6666=.)
recode PRDAY8                    (-9999 -8888 -6666=.)
recode PRDAY9                    (-9999 -8888 -6666=.)
recode PRDAY10                   (-9999 -8888 -6666=.)
recode PRDAY11                   (-9999 -8888 -6666=.)
recode PRDAY12                   (-9999 -8888 -6666=.)
recode PRDAY13                   (-9999 -8888 -6666=.)
recode PRDAY14                   (-9999 -8888 -6666=.)
recode PRDAY15                   (-9999 -8888 -6666=.)
recode PRDAY16                   (-9999 -8888 -6666=.)
recode PRDAY17                   (-9999 -8888 -6666=.)
recode PRDAY18                   (-9999 -8888 -6666=.)
recode PRDAY19                   (-9999 -8888 -6666=.)
recode PRDAY20                   (-9999 -8888 -6666=.)
recode PRDAY21                   (-9999 -8888 -6666=.)
recode PRDAY22                   (-9999 -8888 -6666=.)
recode PRDAY23                   (-9999 -8888 -6666=.)
recode PRDAY24                   (-9999 -8888 -6666=.)
recode PRDAY25                   (-9999 -8888 -6666=.)
recode PRDAY26                   (-9999 -8888 -6666=.)
recode PRDAY27                   (-9999 -8888 -6666=.)
recode PRDAY28                   (-9999 -8888 -6666=.)
recode PRDAY29                   (-9999 -8888 -6666=.)
recode PRDAY30                   (-9999 -8888 -6666=.)
recode PRDAY31                   (-9999 -8888 -6666=.)
recode PRDAY32                   (-9999 -8888 -6666=.)
recode PRDAY33                   (-9999 -8888 -6666=.)
recode PRDAY34                   (-9999 -8888 -6666=.)
recode PRDAY35                   (-9999 -8888 -6666=.)
recode PSTCO_GEO                 (-9999 -8888 -6666=.)
recode RACE                      (-9 -8 -6 -5=.)
recode RACE_PCT_MISS_HOSP        (-999.99 -888.88 -666.66=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode TRAN_IN                   (-9 -8 -6 -5=.)
recode TRAN_OUT                  (-9 -8 -6 -5=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-99 -88 -66=.)
recode VisitLink                 (-99999999 -88888888 -66666666=.)
recode DaysToEvent               (-99999 -88888 -66666=.)
recode AYEAR                     (-999 -888 -666=.)
recode PRMONTH1                  (-9 -8 -6 -5=.)
recode PRMONTH2                  (-9 -8 -6 -5=.)
recode PRMONTH3                  (-9 -8 -6 -5=.)
recode PRMONTH4                  (-9 -8 -6 -5=.)
recode PRMONTH5                  (-9 -8 -6 -5=.)
recode PRMONTH6                  (-9 -8 -6 -5=.)
recode PRMONTH7                  (-9 -8 -6 -5=.)
recode PRMONTH8                  (-9 -8 -6 -5=.)
recode PRMONTH9                  (-9 -8 -6 -5=.)
recode PRMONTH10                 (-9 -8 -6 -5=.)
recode PRMONTH11                 (-9 -8 -6 -5=.)
recode PRMONTH12                 (-9 -8 -6 -5=.)
recode PRMONTH13                 (-9 -8 -6 -5=.)
recode PRMONTH14                 (-9 -8 -6 -5=.)
recode PRMONTH15                 (-9 -8 -6 -5=.)
recode PRMONTH16                 (-9 -8 -6 -5=.)
recode PRMONTH17                 (-9 -8 -6 -5=.)
recode PRMONTH18                 (-9 -8 -6 -5=.)
recode PRMONTH19                 (-9 -8 -6 -5=.)
recode PRMONTH20                 (-9 -8 -6 -5=.)
recode PRMONTH21                 (-9 -8 -6 -5=.)
recode PRMONTH22                 (-9 -8 -6 -5=.)
recode PRMONTH23                 (-9 -8 -6 -5=.)
recode PRMONTH24                 (-9 -8 -6 -5=.)
recode PRMONTH25                 (-9 -8 -6 -5=.)
recode PRMONTH26                 (-9 -8 -6 -5=.)
recode PRMONTH27                 (-9 -8 -6 -5=.)
recode PRMONTH28                 (-9 -8 -6 -5=.)
recode PRMONTH29                 (-9 -8 -6 -5=.)
recode PRMONTH30                 (-9 -8 -6 -5=.)
recode PRMONTH31                 (-9 -8 -6 -5=.)
recode PRMONTH32                 (-9 -8 -6 -5=.)
recode PRMONTH33                 (-9 -8 -6 -5=.)
recode PRMONTH34                 (-9 -8 -6 -5=.)
recode PRMONTH35                 (-9 -8 -6 -5=.)
recode PRYEAR1                   (-999 -888 -666=.)
recode PRYEAR2                   (-999 -888 -666=.)
recode PRYEAR3                   (-999 -888 -666=.)
recode PRYEAR4                   (-999 -888 -666=.)
recode PRYEAR5                   (-999 -888 -666=.)
recode PRYEAR6                   (-999 -888 -666=.)
recode PRYEAR7                   (-999 -888 -666=.)
recode PRYEAR8                   (-999 -888 -666=.)
recode PRYEAR9                   (-999 -888 -666=.)
recode PRYEAR10                  (-999 -888 -666=.)
recode PRYEAR11                  (-999 -888 -666=.)
recode PRYEAR12                  (-999 -888 -666=.)
recode PRYEAR13                  (-999 -888 -666=.)
recode PRYEAR14                  (-999 -888 -666=.)
recode PRYEAR15                  (-999 -888 -666=.)
recode PRYEAR16                  (-999 -888 -666=.)
recode PRYEAR17                  (-999 -888 -666=.)
recode PRYEAR18                  (-999 -888 -666=.)
recode PRYEAR19                  (-999 -888 -666=.)
recode PRYEAR20                  (-999 -888 -666=.)
recode PRYEAR21                  (-999 -888 -666=.)
recode PRYEAR22                  (-999 -888 -666=.)
recode PRYEAR23                  (-999 -888 -666=.)
recode PRYEAR24                  (-999 -888 -666=.)
recode PRYEAR25                  (-999 -888 -666=.)
recode PRYEAR26                  (-999 -888 -666=.)
recode PRYEAR27                  (-999 -888 -666=.)
recode PRYEAR28                  (-999 -888 -666=.)
recode PRYEAR29                  (-999 -888 -666=.)
recode PRYEAR30                  (-999 -888 -666=.)
recode PRYEAR31                  (-999 -888 -666=.)
recode PRYEAR32                  (-999 -888 -666=.)
recode PRYEAR33                  (-999 -888 -666=.)
recode PRYEAR34                  (-999 -888 -666=.)
recode PRYEAR35                  (-999 -888 -666=.)

save "HI_SID_2020_CORE.dta", replace
