/*******************************************************************
* Creation Date: 01/04/2018   
*   SC_SID_2015q4_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'SC_SID_2015q4_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 I10_BODYSYSTEM1                 1-   2
 I10_BODYSYSTEM2                 3-   4
 I10_BODYSYSTEM3                 5-   6
 I10_BODYSYSTEM4                 7-   8
 I10_BODYSYSTEM5                 9-  10
 I10_BODYSYSTEM6                11-  12
 I10_BODYSYSTEM7                13-  14
 I10_BODYSYSTEM8                15-  16
 I10_BODYSYSTEM9                17-  18
 I10_BODYSYSTEM10               19-  20
 I10_BODYSYSTEM11               21-  22
 I10_BODYSYSTEM12               23-  24
 I10_BODYSYSTEM13               25-  26
 I10_BODYSYSTEM14               27-  28
 I10_BODYSYSTEM15               29-  30
 I10_CHRON1                     31-  32
 I10_CHRON2                     33-  34
 I10_CHRON3                     35-  36
 I10_CHRON4                     37-  38
 I10_CHRON5                     39-  40
 I10_CHRON6                     41-  42
 I10_CHRON7                     43-  44
 I10_CHRON8                     45-  46
 I10_CHRON9                     47-  48
 I10_CHRON10                    49-  50
 I10_CHRON11                    51-  52
 I10_CHRON12                    53-  54
 I10_CHRON13                    55-  56
 I10_CHRON14                    57-  58
 I10_CHRON15                    59-  60
 I10_DXMCCS1                    61-  71 (A)
 I10_DXMCCS2                    72-  82 (A)
 I10_DXMCCS3                    83-  93 (A)
 I10_DXMCCS4                    94- 104 (A)
 I10_DXMCCS5                   105- 115 (A)
 I10_DXMCCS6                   116- 126 (A)
 I10_DXMCCS7                   127- 137 (A)
 I10_DXMCCS8                   138- 148 (A)
 I10_DXMCCS9                   149- 159 (A)
 I10_DXMCCS10                  160- 170 (A)
 I10_DXMCCS11                  171- 181 (A)
 I10_DXMCCS12                  182- 192 (A)
 I10_DXMCCS13                  193- 203 (A)
 I10_DXMCCS14                  204- 214 (A)
 I10_DXMCCS15                  215- 225 (A)
 I10_ECauseMCCS1               226- 236 (A)
 I10_ECauseMCCS2               237- 247 (A)
 I10_ECauseMCCS3               248- 258 (A)
 I10_ECauseMCCS4               259- 269 (A)
 I10_ECauseMCCS5               270- 280 (A)
 I10_ECauseMCCS6               281- 291 (A)
 I10_ECauseMCCS7               292- 302 (A)
 I10_ECauseMCCS8               303- 313 (A)
 I10_INJURY                    314- 315
 I10_MULTINJURY                316- 317
 I10_PCLASS1                   318- 319
 I10_PCLASS2                   320- 321
 I10_PCLASS3                   322- 323
 I10_PCLASS4                   324- 325
 I10_PCLASS5                   326- 327
 I10_PCLASS6                   328- 329
 I10_PCLASS7                   330- 331
 I10_PCLASS8                   332- 333
 I10_PCLASS9                   334- 335
 I10_PCLASS10                  336- 337
 I10_PCLASS11                  338- 339
 I10_PCLASS12                  340- 341
 I10_PCLASS13                  342- 343
 I10_PRMCCS1                   344- 351 (A)
 I10_PRMCCS2                   352- 359 (A)
 I10_PRMCCS3                   360- 367 (A)
 I10_PRMCCS4                   368- 375 (A)
 I10_PRMCCS5                   376- 383 (A)
 I10_PRMCCS6                   384- 391 (A)
 I10_PRMCCS7                   392- 399 (A)
 I10_PRMCCS8                   400- 407 (A)
 I10_PRMCCS9                   408- 415 (A)
 I10_PRMCCS10                  416- 423 (A)
 I10_PRMCCS11                  424- 431 (A)
 I10_PRMCCS12                  432- 439 (A)
 I10_PRMCCS13                  440- 447 (A)
 I10_U_BLOOD                   448- 449
 I10_U_CATH                    450- 451
 I10_U_CTSCAN                  452- 453
 I10_U_EKG                     454- 455
 I10_U_MHSA                    456- 457
 I10_U_MRT                     458- 459
 I10_U_PACEMAKER               460- 461
 I10_U_PHYTHERAPY              462- 463
 I10_U_RADTHERAPY              464- 465
 I10_U_STRESS                  466- 467
 KEY                           468- 482
 U_CCU                         483- 484
 U_CHESTXRAY                   485- 486
 U_DIALYSIS                    487- 488
 U_ECHO                        489- 490
 U_ED                          491- 492
 U_EEG                         493- 494
 U_EPO                         495- 496
 U_ICU                         497- 498
 U_LITHOTRIPSY                 499- 500
 U_NEWBN2L                     501- 502
 U_NEWBN3L                     503- 504
 U_NEWBN4L                     505- 506
 U_NUCMED                      507- 508
 U_OBSERVATION                 509- 510
 U_OCCTHERAPY                  511- 512
 U_ORGANACQ                    513- 514
 U_OTHIMPLANTS                 515- 516
 U_RESPTHERAPY                 517- 518
 U_SPEECHTHERAPY               519- 520
 U_ULTRASOUND                  521- 522.


***  Specify write formats  ***.
FORMATS
 I10_BODYSYSTEM1              (F3.0) /
 I10_BODYSYSTEM2              (F3.0) /
 I10_BODYSYSTEM3              (F3.0) /
 I10_BODYSYSTEM4              (F3.0) /
 I10_BODYSYSTEM5              (F3.0) /
 I10_BODYSYSTEM6              (F3.0) /
 I10_BODYSYSTEM7              (F3.0) /
 I10_BODYSYSTEM8              (F3.0) /
 I10_BODYSYSTEM9              (F3.0) /
 I10_BODYSYSTEM10             (F3.0) /
 I10_BODYSYSTEM11             (F3.0) /
 I10_BODYSYSTEM12             (F3.0) /
 I10_BODYSYSTEM13             (F3.0) /
 I10_BODYSYSTEM14             (F3.0) /
 I10_BODYSYSTEM15             (F3.0) /
 I10_CHRON1                   (F3.0) /
 I10_CHRON2                   (F3.0) /
 I10_CHRON3                   (F3.0) /
 I10_CHRON4                   (F3.0) /
 I10_CHRON5                   (F3.0) /
 I10_CHRON6                   (F3.0) /
 I10_CHRON7                   (F3.0) /
 I10_CHRON8                   (F3.0) /
 I10_CHRON9                   (F3.0) /
 I10_CHRON10                  (F3.0) /
 I10_CHRON11                  (F3.0) /
 I10_CHRON12                  (F3.0) /
 I10_CHRON13                  (F3.0) /
 I10_CHRON14                  (F3.0) /
 I10_CHRON15                  (F3.0) /
 I10_INJURY                   (F3.0) /
 I10_MULTINJURY               (F3.0) /
 I10_PCLASS1                  (F3.0) /
 I10_PCLASS2                  (F3.0) /
 I10_PCLASS3                  (F3.0) /
 I10_PCLASS4                  (F3.0) /
 I10_PCLASS5                  (F3.0) /
 I10_PCLASS6                  (F3.0) /
 I10_PCLASS7                  (F3.0) /
 I10_PCLASS8                  (F3.0) /
 I10_PCLASS9                  (F3.0) /
 I10_PCLASS10                 (F3.0) /
 I10_PCLASS11                 (F3.0) /
 I10_PCLASS12                 (F3.0) /
 I10_PCLASS13                 (F3.0) /
 I10_U_BLOOD                  (F3.0) /
 I10_U_CATH                   (F3.0) /
 I10_U_CTSCAN                 (F3.0) /
 I10_U_EKG                    (F3.0) /
 I10_U_MHSA                   (F3.0) /
 I10_U_MRT                    (F3.0) /
 I10_U_PACEMAKER              (F3.0) /
 I10_U_PHYTHERAPY             (F3.0) /
 I10_U_RADTHERAPY             (F3.0) /
 I10_U_STRESS                 (F3.0) /
 KEY                          (F8.0) /
 U_CCU                        (F3.0) /
 U_CHESTXRAY                  (F3.0) /
 U_DIALYSIS                   (F3.0) /
 U_ECHO                       (F3.0) /
 U_ED                         (F3.0) /
 U_EEG                        (F3.0) /
 U_EPO                        (F3.0) /
 U_ICU                        (F3.0) /
 U_LITHOTRIPSY                (F3.0) /
 U_NEWBN2L                    (F3.0) /
 U_NEWBN3L                    (F3.0) /
 U_NEWBN4L                    (F3.0) /
 U_NUCMED                     (F3.0) /
 U_OBSERVATION                (F3.0) /
 U_OCCTHERAPY                 (F3.0) /
 U_ORGANACQ                   (F3.0) /
 U_OTHIMPLANTS                (F3.0) /
 U_RESPTHERAPY                (F3.0) /
 U_SPEECHTHERAPY              (F3.0) /
 U_ULTRASOUND                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 I10_BODYSYSTEM1              "ICD-10-CM Body system 1"
 I10_BODYSYSTEM2              "ICD-10-CM Body system 2"
 I10_BODYSYSTEM3              "ICD-10-CM Body system 3"
 I10_BODYSYSTEM4              "ICD-10-CM Body system 4"
 I10_BODYSYSTEM5              "ICD-10-CM Body system 5"
 I10_BODYSYSTEM6              "ICD-10-CM Body system 6"
 I10_BODYSYSTEM7              "ICD-10-CM Body system 7"
 I10_BODYSYSTEM8              "ICD-10-CM Body system 8"
 I10_BODYSYSTEM9              "ICD-10-CM Body system 9"
 I10_BODYSYSTEM10             "ICD-10-CM Body system 10"
 I10_BODYSYSTEM11             "ICD-10-CM Body system 11"
 I10_BODYSYSTEM12             "ICD-10-CM Body system 12"
 I10_BODYSYSTEM13             "ICD-10-CM Body system 13"
 I10_BODYSYSTEM14             "ICD-10-CM Body system 14"
 I10_BODYSYSTEM15             "ICD-10-CM Body system 15"
 I10_CHRON1                   "ICD-10-CM Chronic condition indicator 1"
 I10_CHRON2                   "ICD-10-CM Chronic condition indicator 2"
 I10_CHRON3                   "ICD-10-CM Chronic condition indicator 3"
 I10_CHRON4                   "ICD-10-CM Chronic condition indicator 4"
 I10_CHRON5                   "ICD-10-CM Chronic condition indicator 5"
 I10_CHRON6                   "ICD-10-CM Chronic condition indicator 6"
 I10_CHRON7                   "ICD-10-CM Chronic condition indicator 7"
 I10_CHRON8                   "ICD-10-CM Chronic condition indicator 8"
 I10_CHRON9                   "ICD-10-CM Chronic condition indicator 9"
 I10_CHRON10                  "ICD-10-CM Chronic condition indicator 10"
 I10_CHRON11                  "ICD-10-CM Chronic condition indicator 11"
 I10_CHRON12                  "ICD-10-CM Chronic condition indicator 12"
 I10_CHRON13                  "ICD-10-CM Chronic condition indicator 13"
 I10_CHRON14                  "ICD-10-CM Chronic condition indicator 14"
 I10_CHRON15                  "ICD-10-CM Chronic condition indicator 15"
 I10_DXMCCS1                  "ICD-10-CM Multi-Level CCS:  Diagnosis 1"
 I10_DXMCCS2                  "ICD-10-CM Multi-Level CCS:  Diagnosis 2"
 I10_DXMCCS3                  "ICD-10-CM Multi-Level CCS:  Diagnosis 3"
 I10_DXMCCS4                  "ICD-10-CM Multi-Level CCS:  Diagnosis 4"
 I10_DXMCCS5                  "ICD-10-CM Multi-Level CCS:  Diagnosis 5"
 I10_DXMCCS6                  "ICD-10-CM Multi-Level CCS:  Diagnosis 6"
 I10_DXMCCS7                  "ICD-10-CM Multi-Level CCS:  Diagnosis 7"
 I10_DXMCCS8                  "ICD-10-CM Multi-Level CCS:  Diagnosis 8"
 I10_DXMCCS9                  "ICD-10-CM Multi-Level CCS:  Diagnosis 9"
 I10_DXMCCS10                 "ICD-10-CM Multi-Level CCS:  Diagnosis 10"
 I10_DXMCCS11                 "ICD-10-CM Multi-Level CCS:  Diagnosis 11"
 I10_DXMCCS12                 "ICD-10-CM Multi-Level CCS:  Diagnosis 12"
 I10_DXMCCS13                 "ICD-10-CM Multi-Level CCS:  Diagnosis 13"
 I10_DXMCCS14                 "ICD-10-CM Multi-Level CCS:  Diagnosis 14"
 I10_DXMCCS15                 "ICD-10-CM Multi-Level CCS:  Diagnosis 15"
 I10_ECauseMCCS1              "ICD-10-CM Multi-Level CCS:  E Cause 1"
 I10_ECauseMCCS2              "ICD-10-CM Multi-Level CCS:  E Cause 2"
 I10_ECauseMCCS3              "ICD-10-CM Multi-Level CCS:  E Cause 3"
 I10_ECauseMCCS4              "ICD-10-CM Multi-Level CCS:  E Cause 4"
 I10_ECauseMCCS5              "ICD-10-CM Multi-Level CCS:  E Cause 5"
 I10_ECauseMCCS6              "ICD-10-CM Multi-Level CCS:  E Cause 6"
 I10_ECauseMCCS7              "ICD-10-CM Multi-Level CCS:  E Cause 7"
 I10_ECauseMCCS8              "ICD-10-CM Multi-Level CCS:  E Cause 8"
 I10_INJURY
 "ICD-10-CM Injury diagnosis reported on record (1:I10_DX1 is an injury; 2:I10_DX2+ is an injury; 0:No injury)"
 I10_MULTINJURY               "ICD-10-CM More than one injury diagnosis reported on record"
 I10_PCLASS1                  "ICD-10-PCS Procedure class 1"
 I10_PCLASS2                  "ICD-10-PCS Procedure class 2"
 I10_PCLASS3                  "ICD-10-PCS Procedure class 3"
 I10_PCLASS4                  "ICD-10-PCS Procedure class 4"
 I10_PCLASS5                  "ICD-10-PCS Procedure class 5"
 I10_PCLASS6                  "ICD-10-PCS Procedure class 6"
 I10_PCLASS7                  "ICD-10-PCS Procedure class 7"
 I10_PCLASS8                  "ICD-10-PCS Procedure class 8"
 I10_PCLASS9                  "ICD-10-PCS Procedure class 9"
 I10_PCLASS10                 "ICD-10-PCS Procedure class 10"
 I10_PCLASS11                 "ICD-10-PCS Procedure class 11"
 I10_PCLASS12                 "ICD-10-PCS Procedure class 12"
 I10_PCLASS13                 "ICD-10-PCS Procedure class 13"
 I10_PRMCCS1                  "ICD-10-PCS Multi-Level CCS:  Procedure 1"
 I10_PRMCCS2                  "ICD-10-PCS Multi-Level CCS:  Procedure 2"
 I10_PRMCCS3                  "ICD-10-PCS Multi-Level CCS:  Procedure 3"
 I10_PRMCCS4                  "ICD-10-PCS Multi-Level CCS:  Procedure 4"
 I10_PRMCCS5                  "ICD-10-PCS Multi-Level CCS:  Procedure 5"
 I10_PRMCCS6                  "ICD-10-PCS Multi-Level CCS:  Procedure 6"
 I10_PRMCCS7                  "ICD-10-PCS Multi-Level CCS:  Procedure 7"
 I10_PRMCCS8                  "ICD-10-PCS Multi-Level CCS:  Procedure 8"
 I10_PRMCCS9                  "ICD-10-PCS Multi-Level CCS:  Procedure 9"
 I10_PRMCCS10                 "ICD-10-PCS Multi-Level CCS:  Procedure 10"
 I10_PRMCCS11                 "ICD-10-PCS Multi-Level CCS:  Procedure 11"
 I10_PRMCCS12                 "ICD-10-PCS Multi-Level CCS:  Procedure 12"
 I10_PRMCCS13                 "ICD-10-PCS Multi-Level CCS:  Procedure 13"
 I10_U_BLOOD                  "ICD-10-PCS Utilization Flag: Blood"
 I10_U_CATH                   "ICD-10-PCS Utilization Flag: Cardiac Catheterization Lab"
 I10_U_CTSCAN                 "ICD-10-PCS Utilization Flag: Computed Tomography Scan"
 I10_U_EKG                    "ICD-10-PCS Utilization Flag: Electrocardiogram"
 I10_U_MHSA                   "ICD-10-PCS Utilization Flag: Mental Health and Substance Abuse"
 I10_U_MRT                    "ICD-10-PCS Utilization Flag: Magnetic Resonance Technology"
 I10_U_PACEMAKER              "ICD-10-PCS Utilization Flag: Pacemaker"
 I10_U_PHYTHERAPY             "ICD-10-PCS Utilization Flag: Physical Therapy"
 I10_U_RADTHERAPY             "ICD-10-PCS Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 I10_U_STRESS                 "ICD-10-PCS Utilization Flag: Cardiac Stress Test"
 KEY                          "HCUP record identifier"
 U_CCU                        "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY                  "Utilization Flag: Chest X-Ray"
 U_DIALYSIS                   "Utilization Flag: Renal Dialysis"
 U_ECHO                       "Utilization Flag: Echocardiology"
 U_ED                         "Utilization Flag: Emergency Room"
 U_EEG                        "Utilization Flag: Electroencephalogram"
 U_EPO                        "Utilization Flag: EPO"
 U_ICU                        "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY                "Utilization Flag: Lithotripsy"
 U_NEWBN2L                    "Utilization Flag: Nursery Level II"
 U_NEWBN3L                    "Utilization Flag: Nursery Level III"
 U_NEWBN4L                    "Utilization Flag: Nursery Level IV"
 U_NUCMED                     "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION                "Utilization Flag: Observation Room"
 U_OCCTHERAPY                 "Utilization Flag: Occupational Therapy"
 U_ORGANACQ                   "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS                "Utilization Flag: Other Implants"
 U_RESPTHERAPY                "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY              "Utilization Flag: Speech - Language Pathology"
 U_ULTRASOUND                 "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE I10_BODYSYSTEM1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM10
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM11
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM12
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM13
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM14
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM15
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'SC_SID_2015q4_DX_PR_GRPS.SAV' /COMPRESSED.
