/*******************************************************************
* Creation Date: 06/29/2016   
*   HI_SID_2014_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'HI_SID_2014_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 BODYSYSTEM1                     1-   2
 BODYSYSTEM2                     3-   4
 BODYSYSTEM3                     5-   6
 BODYSYSTEM4                     7-   8
 BODYSYSTEM5                     9-  10
 BODYSYSTEM6                    11-  12
 BODYSYSTEM7                    13-  14
 BODYSYSTEM8                    15-  16
 BODYSYSTEM9                    17-  18
 BODYSYSTEM10                   19-  20
 BODYSYSTEM11                   21-  22
 BODYSYSTEM12                   23-  24
 BODYSYSTEM13                   25-  26
 BODYSYSTEM14                   27-  28
 BODYSYSTEM15                   29-  30
 BODYSYSTEM16                   31-  32
 BODYSYSTEM17                   33-  34
 BODYSYSTEM18                   35-  36
 BODYSYSTEM19                   37-  38
 BODYSYSTEM20                   39-  40
 BODYSYSTEM21                   41-  42
 BODYSYSTEM22                   43-  44
 BODYSYSTEM23                   45-  46
 BODYSYSTEM24                   47-  48
 BODYSYSTEM25                   49-  50
 CHRON1                         51-  52
 CHRON2                         53-  54
 CHRON3                         55-  56
 CHRON4                         57-  58
 CHRON5                         59-  60
 CHRON6                         61-  62
 CHRON7                         63-  64
 CHRON8                         65-  66
 CHRON9                         67-  68
 CHRON10                        69-  70
 CHRON11                        71-  72
 CHRON12                        73-  74
 CHRON13                        75-  76
 CHRON14                        77-  78
 CHRON15                        79-  80
 CHRON16                        81-  82
 CHRON17                        83-  84
 CHRON18                        85-  86
 CHRON19                        87-  88
 CHRON20                        89-  90
 CHRON21                        91-  92
 CHRON22                        93-  94
 CHRON23                        95-  96
 CHRON24                        97-  98
 CHRON25                        99- 100
 DXMCCS1                       101- 111 (A)
 DXMCCS2                       112- 122 (A)
 DXMCCS3                       123- 133 (A)
 DXMCCS4                       134- 144 (A)
 DXMCCS5                       145- 155 (A)
 DXMCCS6                       156- 166 (A)
 DXMCCS7                       167- 177 (A)
 DXMCCS8                       178- 188 (A)
 DXMCCS9                       189- 199 (A)
 DXMCCS10                      200- 210 (A)
 DXMCCS11                      211- 221 (A)
 DXMCCS12                      222- 232 (A)
 DXMCCS13                      233- 243 (A)
 DXMCCS14                      244- 254 (A)
 DXMCCS15                      255- 265 (A)
 DXMCCS16                      266- 276 (A)
 DXMCCS17                      277- 287 (A)
 DXMCCS18                      288- 298 (A)
 DXMCCS19                      299- 309 (A)
 DXMCCS20                      310- 320 (A)
 DXMCCS21                      321- 331 (A)
 DXMCCS22                      332- 342 (A)
 DXMCCS23                      343- 353 (A)
 DXMCCS24                      354- 364 (A)
 DXMCCS25                      365- 375 (A)
 E_MCCS1                       376- 386 (A)
 E_MCCS2                       387- 397 (A)
 E_MCCS3                       398- 408 (A)
 E_MCCS4                       409- 419 (A)
 E_MCCS5                       420- 430 (A)
 E_MCCS6                       431- 441 (A)
 E_MCCS7                       442- 452 (A)
 E_MCCS8                       453- 463 (A)
 INJURY                        464- 465
 INJURY_CUT                    466- 467
 INJURY_DROWN                  468- 469
 INJURY_FALL                   470- 471
 INJURY_FIRE                   472- 473
 INJURY_FIREARM                474- 475
 INJURY_MACHINERY              476- 477
 INJURY_MVT                    478- 479
 INJURY_NATURE                 480- 481
 INJURY_POISON                 482- 483
 INJURY_STRUCK                 484- 485
 INJURY_SUFFOCATION            486- 487
 INTENT_ASSAULT                488- 489
 INTENT_SELF_HARM              490- 491
 INTENT_UNINTENTIONAL          492- 493
 KEY                           494- 508
 MULTINJURY                    509- 510
 PCLASS1                       511- 512
 PCLASS2                       513- 514
 PCLASS3                       515- 516
 PCLASS4                       517- 518
 PCLASS5                       519- 520
 PCLASS6                       521- 522
 PCLASS7                       523- 524
 PCLASS8                       525- 526
 PCLASS9                       527- 528
 PCLASS10                      529- 530
 PCLASS11                      531- 532
 PCLASS12                      533- 534
 PCLASS13                      535- 536
 PCLASS14                      537- 538
 PCLASS15                      539- 540
 PCLASS16                      541- 542
 PCLASS17                      543- 544
 PCLASS18                      545- 546
 PCLASS19                      547- 548
 PCLASS20                      549- 550
 PCLASS21                      551- 552
 PCLASS22                      553- 554
 PCLASS23                      555- 556
 PCLASS24                      557- 558
 PCLASS25                      559- 560
 PRMCCS1                       561- 568 (A)
 PRMCCS2                       569- 576 (A)
 PRMCCS3                       577- 584 (A)
 PRMCCS4                       585- 592 (A)
 PRMCCS5                       593- 600 (A)
 PRMCCS6                       601- 608 (A)
 PRMCCS7                       609- 616 (A)
 PRMCCS8                       617- 624 (A)
 PRMCCS9                       625- 632 (A)
 PRMCCS10                      633- 640 (A)
 PRMCCS11                      641- 648 (A)
 PRMCCS12                      649- 656 (A)
 PRMCCS13                      657- 664 (A)
 PRMCCS14                      665- 672 (A)
 PRMCCS15                      673- 680 (A)
 PRMCCS16                      681- 688 (A)
 PRMCCS17                      689- 696 (A)
 PRMCCS18                      697- 704 (A)
 PRMCCS19                      705- 712 (A)
 PRMCCS20                      713- 720 (A)
 PRMCCS21                      721- 728 (A)
 PRMCCS22                      729- 736 (A)
 PRMCCS23                      737- 744 (A)
 PRMCCS24                      745- 752 (A)
 PRMCCS25                      753- 760 (A)
 U_BLOOD                       761- 762
 U_CATH                        763- 764
 U_CCU                         765- 766
 U_CHESTXRAY                   767- 768
 U_CTSCAN                      769- 770
 U_DIALYSIS                    771- 772
 U_ECHO                        773- 774
 U_ED                          775- 776
 U_EEG                         777- 778
 U_EKG                         779- 780
 U_EPO                         781- 782
 U_ICU                         783- 784
 U_LITHOTRIPSY                 785- 786
 U_MHSA                        787- 788
 U_MRT                         789- 790
 U_NEWBN2L                     791- 792
 U_NEWBN3L                     793- 794
 U_NEWBN4L                     795- 796
 U_NUCMED                      797- 798
 U_OBSERVATION                 799- 800
 U_OCCTHERAPY                  801- 802
 U_ORGANACQ                    803- 804
 U_OTHIMPLANTS                 805- 806
 U_PACEMAKER                   807- 808
 U_PHYTHERAPY                  809- 810
 U_RADTHERAPY                  811- 812
 U_RESPTHERAPY                 813- 814
 U_SPEECHTHERAPY               815- 816
 U_STRESS                      817- 818
 U_ULTRASOUND                  819- 820.


***  Specify write formats  ***.
FORMATS
 BODYSYSTEM1                  (F3.0) /
 BODYSYSTEM2                  (F3.0) /
 BODYSYSTEM3                  (F3.0) /
 BODYSYSTEM4                  (F3.0) /
 BODYSYSTEM5                  (F3.0) /
 BODYSYSTEM6                  (F3.0) /
 BODYSYSTEM7                  (F3.0) /
 BODYSYSTEM8                  (F3.0) /
 BODYSYSTEM9                  (F3.0) /
 BODYSYSTEM10                 (F3.0) /
 BODYSYSTEM11                 (F3.0) /
 BODYSYSTEM12                 (F3.0) /
 BODYSYSTEM13                 (F3.0) /
 BODYSYSTEM14                 (F3.0) /
 BODYSYSTEM15                 (F3.0) /
 BODYSYSTEM16                 (F3.0) /
 BODYSYSTEM17                 (F3.0) /
 BODYSYSTEM18                 (F3.0) /
 BODYSYSTEM19                 (F3.0) /
 BODYSYSTEM20                 (F3.0) /
 BODYSYSTEM21                 (F3.0) /
 BODYSYSTEM22                 (F3.0) /
 BODYSYSTEM23                 (F3.0) /
 BODYSYSTEM24                 (F3.0) /
 BODYSYSTEM25                 (F3.0) /
 CHRON1                       (F3.0) /
 CHRON2                       (F3.0) /
 CHRON3                       (F3.0) /
 CHRON4                       (F3.0) /
 CHRON5                       (F3.0) /
 CHRON6                       (F3.0) /
 CHRON7                       (F3.0) /
 CHRON8                       (F3.0) /
 CHRON9                       (F3.0) /
 CHRON10                      (F3.0) /
 CHRON11                      (F3.0) /
 CHRON12                      (F3.0) /
 CHRON13                      (F3.0) /
 CHRON14                      (F3.0) /
 CHRON15                      (F3.0) /
 CHRON16                      (F3.0) /
 CHRON17                      (F3.0) /
 CHRON18                      (F3.0) /
 CHRON19                      (F3.0) /
 CHRON20                      (F3.0) /
 CHRON21                      (F3.0) /
 CHRON22                      (F3.0) /
 CHRON23                      (F3.0) /
 CHRON24                      (F3.0) /
 CHRON25                      (F3.0) /
 INJURY                       (F3.0) /
 INJURY_CUT                   (F3.0) /
 INJURY_DROWN                 (F3.0) /
 INJURY_FALL                  (F3.0) /
 INJURY_FIRE                  (F3.0) /
 INJURY_FIREARM               (F3.0) /
 INJURY_MACHINERY             (F3.0) /
 INJURY_MVT                   (F3.0) /
 INJURY_NATURE                (F3.0) /
 INJURY_POISON                (F3.0) /
 INJURY_STRUCK                (F3.0) /
 INJURY_SUFFOCATION           (F3.0) /
 INTENT_ASSAULT               (F3.0) /
 INTENT_SELF_HARM             (F3.0) /
 INTENT_UNINTENTIONAL         (F3.0) /
 KEY                          (F8.0) /
 MULTINJURY                   (F3.0) /
 PCLASS1                      (F3.0) /
 PCLASS2                      (F3.0) /
 PCLASS3                      (F3.0) /
 PCLASS4                      (F3.0) /
 PCLASS5                      (F3.0) /
 PCLASS6                      (F3.0) /
 PCLASS7                      (F3.0) /
 PCLASS8                      (F3.0) /
 PCLASS9                      (F3.0) /
 PCLASS10                     (F3.0) /
 PCLASS11                     (F3.0) /
 PCLASS12                     (F3.0) /
 PCLASS13                     (F3.0) /
 PCLASS14                     (F3.0) /
 PCLASS15                     (F3.0) /
 PCLASS16                     (F3.0) /
 PCLASS17                     (F3.0) /
 PCLASS18                     (F3.0) /
 PCLASS19                     (F3.0) /
 PCLASS20                     (F3.0) /
 PCLASS21                     (F3.0) /
 PCLASS22                     (F3.0) /
 PCLASS23                     (F3.0) /
 PCLASS24                     (F3.0) /
 PCLASS25                     (F3.0) /
 U_BLOOD                      (F3.0) /
 U_CATH                       (F3.0) /
 U_CCU                        (F3.0) /
 U_CHESTXRAY                  (F3.0) /
 U_CTSCAN                     (F3.0) /
 U_DIALYSIS                   (F3.0) /
 U_ECHO                       (F3.0) /
 U_ED                         (F3.0) /
 U_EEG                        (F3.0) /
 U_EKG                        (F3.0) /
 U_EPO                        (F3.0) /
 U_ICU                        (F3.0) /
 U_LITHOTRIPSY                (F3.0) /
 U_MHSA                       (F3.0) /
 U_MRT                        (F3.0) /
 U_NEWBN2L                    (F3.0) /
 U_NEWBN3L                    (F3.0) /
 U_NEWBN4L                    (F3.0) /
 U_NUCMED                     (F3.0) /
 U_OBSERVATION                (F3.0) /
 U_OCCTHERAPY                 (F3.0) /
 U_ORGANACQ                   (F3.0) /
 U_OTHIMPLANTS                (F3.0) /
 U_PACEMAKER                  (F3.0) /
 U_PHYTHERAPY                 (F3.0) /
 U_RADTHERAPY                 (F3.0) /
 U_RESPTHERAPY                (F3.0) /
 U_SPEECHTHERAPY              (F3.0) /
 U_STRESS                     (F3.0) /
 U_ULTRASOUND                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 BODYSYSTEM1                  "Body system 1"
 BODYSYSTEM2                  "Body system 2"
 BODYSYSTEM3                  "Body system 3"
 BODYSYSTEM4                  "Body system 4"
 BODYSYSTEM5                  "Body system 5"
 BODYSYSTEM6                  "Body system 6"
 BODYSYSTEM7                  "Body system 7"
 BODYSYSTEM8                  "Body system 8"
 BODYSYSTEM9                  "Body system 9"
 BODYSYSTEM10                 "Body system 10"
 BODYSYSTEM11                 "Body system 11"
 BODYSYSTEM12                 "Body system 12"
 BODYSYSTEM13                 "Body system 13"
 BODYSYSTEM14                 "Body system 14"
 BODYSYSTEM15                 "Body system 15"
 BODYSYSTEM16                 "Body system 16"
 BODYSYSTEM17                 "Body system 17"
 BODYSYSTEM18                 "Body system 18"
 BODYSYSTEM19                 "Body system 19"
 BODYSYSTEM20                 "Body system 20"
 BODYSYSTEM21                 "Body system 21"
 BODYSYSTEM22                 "Body system 22"
 BODYSYSTEM23                 "Body system 23"
 BODYSYSTEM24                 "Body system 24"
 BODYSYSTEM25                 "Body system 25"
 CHRON1                       "Chronic condition indicator 1"
 CHRON2                       "Chronic condition indicator 2"
 CHRON3                       "Chronic condition indicator 3"
 CHRON4                       "Chronic condition indicator 4"
 CHRON5                       "Chronic condition indicator 5"
 CHRON6                       "Chronic condition indicator 6"
 CHRON7                       "Chronic condition indicator 7"
 CHRON8                       "Chronic condition indicator 8"
 CHRON9                       "Chronic condition indicator 9"
 CHRON10                      "Chronic condition indicator 10"
 CHRON11                      "Chronic condition indicator 11"
 CHRON12                      "Chronic condition indicator 12"
 CHRON13                      "Chronic condition indicator 13"
 CHRON14                      "Chronic condition indicator 14"
 CHRON15                      "Chronic condition indicator 15"
 CHRON16                      "Chronic condition indicator 16"
 CHRON17                      "Chronic condition indicator 17"
 CHRON18                      "Chronic condition indicator 18"
 CHRON19                      "Chronic condition indicator 19"
 CHRON20                      "Chronic condition indicator 20"
 CHRON21                      "Chronic condition indicator 21"
 CHRON22                      "Chronic condition indicator 22"
 CHRON23                      "Chronic condition indicator 23"
 CHRON24                      "Chronic condition indicator 24"
 CHRON25                      "Chronic condition indicator 25"
 DXMCCS1                      "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                      "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                      "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                      "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                      "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                      "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                      "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                      "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                      "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                     "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                     "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                     "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                     "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                     "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                     "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16                     "Multi-Level CCS:  Diagnosis 16"
 DXMCCS17                     "Multi-Level CCS:  Diagnosis 17"
 DXMCCS18                     "Multi-Level CCS:  Diagnosis 18"
 DXMCCS19                     "Multi-Level CCS:  Diagnosis 19"
 DXMCCS20                     "Multi-Level CCS:  Diagnosis 20"
 DXMCCS21                     "Multi-Level CCS:  Diagnosis 21"
 DXMCCS22                     "Multi-Level CCS:  Diagnosis 22"
 DXMCCS23                     "Multi-Level CCS:  Diagnosis 23"
 DXMCCS24                     "Multi-Level CCS:  Diagnosis 24"
 DXMCCS25                     "Multi-Level CCS:  Diagnosis 25"
 E_MCCS1                      "Multi-Level CCS:  E Code 1"
 E_MCCS2                      "Multi-Level CCS:  E Code 2"
 E_MCCS3                      "Multi-Level CCS:  E Code 3"
 E_MCCS4                      "Multi-Level CCS:  E Code 4"
 E_MCCS5                      "Multi-Level CCS:  E Code 5"
 E_MCCS6                      "Multi-Level CCS:  E Code 6"
 E_MCCS7                      "Multi-Level CCS:  E Code 7"
 E_MCCS8                      "Multi-Level CCS:  E Code 8"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT                   "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN                 "Injury by drowning or submersion (by E codes)"
 INJURY_FALL                  "Injury by falling (by E codes)"
 INJURY_FIRE                  "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM               "Injury by firearm (by E codes)"
 INJURY_MACHINERY             "Injury by machinery (by E codes)"
 INJURY_MVT                   "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE
"Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON                "Injury by poison (by E codes)"
 INJURY_STRUCK                "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION           "Injury by suffocation (by E codes)"
 INTENT_ASSAULT               "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM
"Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL         "Unintentional injury indicated on the record (by E codes)"
 KEY                          "HCUP record identifier"
 MULTINJURY                   "More than one injury diagnosis reported on record"
 PCLASS1                      "Procedure class 1"
 PCLASS2                      "Procedure class 2"
 PCLASS3                      "Procedure class 3"
 PCLASS4                      "Procedure class 4"
 PCLASS5                      "Procedure class 5"
 PCLASS6                      "Procedure class 6"
 PCLASS7                      "Procedure class 7"
 PCLASS8                      "Procedure class 8"
 PCLASS9                      "Procedure class 9"
 PCLASS10                     "Procedure class 10"
 PCLASS11                     "Procedure class 11"
 PCLASS12                     "Procedure class 12"
 PCLASS13                     "Procedure class 13"
 PCLASS14                     "Procedure class 14"
 PCLASS15                     "Procedure class 15"
 PCLASS16                     "Procedure class 16"
 PCLASS17                     "Procedure class 17"
 PCLASS18                     "Procedure class 18"
 PCLASS19                     "Procedure class 19"
 PCLASS20                     "Procedure class 20"
 PCLASS21                     "Procedure class 21"
 PCLASS22                     "Procedure class 22"
 PCLASS23                     "Procedure class 23"
 PCLASS24                     "Procedure class 24"
 PCLASS25                     "Procedure class 25"
 PRMCCS1                      "Multi-Level CCS:  Procedure 1"
 PRMCCS2                      "Multi-Level CCS:  Procedure 2"
 PRMCCS3                      "Multi-Level CCS:  Procedure 3"
 PRMCCS4                      "Multi-Level CCS:  Procedure 4"
 PRMCCS5                      "Multi-Level CCS:  Procedure 5"
 PRMCCS6                      "Multi-Level CCS:  Procedure 6"
 PRMCCS7                      "Multi-Level CCS:  Procedure 7"
 PRMCCS8                      "Multi-Level CCS:  Procedure 8"
 PRMCCS9                      "Multi-Level CCS:  Procedure 9"
 PRMCCS10                     "Multi-Level CCS:  Procedure 10"
 PRMCCS11                     "Multi-Level CCS:  Procedure 11"
 PRMCCS12                     "Multi-Level CCS:  Procedure 12"
 PRMCCS13                     "Multi-Level CCS:  Procedure 13"
 PRMCCS14                     "Multi-Level CCS:  Procedure 14"
 PRMCCS15                     "Multi-Level CCS:  Procedure 15"
 PRMCCS16                     "Multi-Level CCS:  Procedure 16"
 PRMCCS17                     "Multi-Level CCS:  Procedure 17"
 PRMCCS18                     "Multi-Level CCS:  Procedure 18"
 PRMCCS19                     "Multi-Level CCS:  Procedure 19"
 PRMCCS20                     "Multi-Level CCS:  Procedure 20"
 PRMCCS21                     "Multi-Level CCS:  Procedure 21"
 PRMCCS22                     "Multi-Level CCS:  Procedure 22"
 PRMCCS23                     "Multi-Level CCS:  Procedure 23"
 PRMCCS24                     "Multi-Level CCS:  Procedure 24"
 PRMCCS25                     "Multi-Level CCS:  Procedure 25"
 U_BLOOD                      "Utilization Flag: Blood"
 U_CATH                       "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU                        "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY                  "Utilization Flag: Chest X-Ray"
 U_CTSCAN                     "Utilization Flag: Computed Tomography Scan"
 U_DIALYSIS                   "Utilization Flag: Renal Dialysis"
 U_ECHO                       "Utilization Flag: Echocardiology"
 U_ED                         "Utilization Flag: Emergency Room"
 U_EEG                        "Utilization Flag: Electroencephalogram"
 U_EKG                        "Utilization Flag: Electrocardiogram"
 U_EPO                        "Utilization Flag: EPO"
 U_ICU                        "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY                "Utilization Flag: Lithotripsy"
 U_MHSA                       "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT                        "Utilization Flag: Magnetic Resonance Technology"
 U_NEWBN2L                    "Utilization Flag: Nursery Level II"
 U_NEWBN3L                    "Utilization Flag: Nursery Level III"
 U_NEWBN4L                    "Utilization Flag: Nursery Level IV"
 U_NUCMED                     "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION                "Utilization Flag: Observation Room"
 U_OCCTHERAPY                 "Utilization Flag: Occupational Therapy"
 U_ORGANACQ                   "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS                "Utilization Flag: Other Implants"
 U_PACEMAKER                  "Utilization Flag: Pacemaker"
 U_PHYTHERAPY                 "Utilization Flag: Physical Therapy"
 U_RADTHERAPY
"Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTHERAPY                "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY              "Utilization Flag: Speech - Language Pathology"
 U_STRESS                     "Utilization Flag: Cardiac Stress Test"
 U_ULTRASOUND                 "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE BODYSYSTEM1
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM2
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM3
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM4
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM5
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM6
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM7
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM8
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM9
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM10
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM11
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM12
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM13
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM14
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM15
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM16
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM17
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM18
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM19
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM20
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM21
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM22
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM23
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM24
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON25
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS16
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS17
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS18
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS19
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS20
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS21
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS22
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS23
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS24
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS25
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'HI_SID_2014_DX_PR_GRPS.SAV' /COMPRESSED.
