/*******************************************************************
* Creation Date: 09/16/2016   
*   SC_SID_2007_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'SC_SID_2007_CORE.ASC' FIXED SKIP=2 / 
 AMONTH                          1-   2
 ASOURCE                         3-   4
 ASOURCE_X                       5     (A)
 ATYPE                           6-   7
 AWEEKEND                        8-   9
 DIED                           10-  11
 DISPUB04                       12-  13
 DISPUNIFORM                    14-  15
 DISP_X                         16-  17 (A)
 DQTR                           18-  19
 DRG                            20-  22
 DRG24                          23-  25
 DRGVER                         26-  27
 DX1                            28-  34 (A)
 DX2                            35-  41 (A)
 DX3                            42-  48 (A)
 DX4                            49-  55 (A)
 DX5                            56-  62 (A)
 DX6                            63-  69 (A)
 DX7                            70-  76 (A)
 DX8                            77-  83 (A)
 DX9                            84-  90 (A)
 DX10                           91-  97 (A)
 DX11                           98- 104 (A)
 DX12                          105- 111 (A)
 DX13                          112- 118 (A)
 DX14                          119- 125 (A)
 DX15                          126- 132 (A)
 DXCCS1                        133- 136
 DXCCS2                        137- 140
 DXCCS3                        141- 144
 DXCCS4                        145- 148
 DXCCS5                        149- 152
 DXCCS6                        153- 156
 DXCCS7                        157- 160
 DXCCS8                        161- 164
 DXCCS9                        165- 168
 DXCCS10                       169- 172
 DXCCS11                       173- 176
 DXCCS12                       177- 180
 DXCCS13                       181- 184
 DXCCS14                       185- 188
 DXCCS15                       189- 192
 DXPOA1                        193     (A)
 DXPOA2                        194     (A)
 DXPOA3                        195     (A)
 DXPOA4                        196     (A)
 DXPOA5                        197     (A)
 DXPOA6                        198     (A)
 DXPOA7                        199     (A)
 DXPOA8                        200     (A)
 DXPOA9                        201     (A)
 DXPOA10                       202     (A)
 DXPOA11                       203     (A)
 DXPOA12                       204     (A)
 DXPOA13                       205     (A)
 DXPOA14                       206     (A)
 DXPOA15                       207     (A)
 DaysICU                       208- 210
 ECODE1                        211- 217 (A)
 ECODE2                        218- 224 (A)
 ECODE3                        225- 231 (A)
 ECODE4                        232- 238 (A)
 ECODE5                        239- 245 (A)
 ECODE6                        246- 252 (A)
 ECODE7                        253- 259 (A)
 ECODE8                        260- 266 (A)
 E_CCS1                        267- 270
 E_CCS2                        271- 274
 E_CCS3                        275- 278
 E_CCS4                        279- 282
 E_CCS5                        283- 286
 E_CCS6                        287- 290
 E_CCS7                        291- 294
 E_CCS8                        295- 298
 E_POA1                        299     (A)
 E_POA2                        300     (A)
 E_POA3                        301     (A)
 E_POA4                        302     (A)
 E_POA5                        303     (A)
 E_POA6                        304     (A)
 E_POA7                        305     (A)
 E_POA8                        306     (A)
 FEMALE                        307- 308
 HCUP_ED                       309- 310
 HCUP_OS                       311- 312
 HOSPBRTH                      313- 315
 HOSPST                        316- 317 (A)
 KEY                           318- 332
 LOS                           333- 337
 LOS_X                         338- 343
 MDC                           344- 345
 MDC24                         346- 347
 MDSPEC1                       348- 350 (A)
 MDSPEC2                       351- 353 (A)
 MEDINCSTQ                     354- 355
 NDX                           356- 358
 NECODE                        359- 360
 NEOMAT                        361- 362
 NPR                           363- 365
 PAY1                          366- 367
 PAY1_X                        368- 369 (A)
 PL_NCHS2006                   370- 371
 PL_RUCA10_2005                372- 373
 PL_RUCA4_2005                 374- 375
 PR1                           376- 382 (A)
 PR2                           383- 389 (A)
 PR3                           390- 396 (A)
 PR4                           397- 403 (A)
 PR5                           404- 410 (A)
 PR6                           411- 417 (A)
 PR7                           418- 424 (A)
 PR8                           425- 431 (A)
 PR9                           432- 438 (A)
 PR10                          439- 445 (A)
 PR11                          446- 452 (A)
 PR12                          453- 459 (A)
 PR13                          460- 466 (A)
 PRCCS1                        467- 469
 PRCCS2                        470- 472
 PRCCS3                        473- 475
 PRCCS4                        476- 478
 PRCCS5                        479- 481
 PRCCS6                        482- 484
 PRCCS7                        485- 487
 PRCCS8                        488- 490
 PRCCS9                        491- 493
 PRCCS10                       494- 496
 PRCCS11                       497- 499
 PRCCS12                       500- 502
 PRCCS13                       503- 505
 PRDAY1                        506- 510
 PRDAY2                        511- 515
 PRDAY3                        516- 520
 PRDAY4                        521- 525
 PRDAY5                        526- 530
 PRDAY6                        531- 535
 PRDAY7                        536- 540
 PRDAY8                        541- 545
 PRDAY9                        546- 550
 PRDAY10                       551- 555
 PRDAY11                       556- 560
 PRDAY12                       561- 565
 PRDAY13                       566- 570
 PROCTYPE                      571- 573
 PSTATE                        574- 575 (A)
 PSTCO                         576- 580
 PointOfOriginUB04             581     (A)
 PointOfOrigin_X               582     (A)
 RACE                          583- 584
 RACE_X                        585     (A)
 TOTCHG                        586- 595
 TOTCHG_X                      596- 610
 YEAR                          611- 614
 ZIPINC_QRTL                   615- 617
 AGEGROUP                      618- 620.


***  Specify write formats  ***.
FORMATS
 AMONTH                       (F3.0) /
 ASOURCE                      (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG24                        (F3.0) /
 DRGVER                       (F3.0) /
 DXCCS1                       (F4.0) /
 DXCCS2                       (F4.0) /
 DXCCS3                       (F4.0) /
 DXCCS4                       (F4.0) /
 DXCCS5                       (F4.0) /
 DXCCS6                       (F4.0) /
 DXCCS7                       (F4.0) /
 DXCCS8                       (F4.0) /
 DXCCS9                       (F4.0) /
 DXCCS10                      (F4.0) /
 DXCCS11                      (F4.0) /
 DXCCS12                      (F4.0) /
 DXCCS13                      (F4.0) /
 DXCCS14                      (F4.0) /
 DXCCS15                      (F4.0) /
 DaysICU                      (F3.0) /
 E_CCS1                       (F3.0) /
 E_CCS2                       (F3.0) /
 E_CCS3                       (F3.0) /
 E_CCS4                       (F3.0) /
 E_CCS5                       (F3.0) /
 E_CCS6                       (F3.0) /
 E_CCS7                       (F3.0) /
 E_CCS8                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HOSPBRTH                     (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC24                        (F3.0) /
 MEDINCSTQ                    (F3.0) /
 NDX                          (F3.0) /
 NECODE                       (F3.0) /
 NEOMAT                       (F3.0) /
 NPR                          (F3.0) /
 PAY1                         (F3.0) /
 PL_NCHS2006                  (F3.0) /
 PL_RUCA10_2005               (F3.0) /
 PL_RUCA4_2005                (F3.0) /
 PRCCS1                       (F3.0) /
 PRCCS2                       (F3.0) /
 PRCCS3                       (F3.0) /
 PRCCS4                       (F3.0) /
 PRCCS5                       (F3.0) /
 PRCCS6                       (F3.0) /
 PRCCS7                       (F3.0) /
 PRCCS8                       (F3.0) /
 PRCCS9                       (F3.0) /
 PRCCS10                      (F3.0) /
 PRCCS11                      (F3.0) /
 PRCCS12                      (F3.0) /
 PRCCS13                      (F3.0) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PROCTYPE                     (F3.0) /
 PSTCO                        (F4.0) /
 RACE                         (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AGEGROUP                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AMONTH                       "Admission month"
 ASOURCE                      "Admission source (uniform)"
 ASOURCE_X                    "Admission source (as received from source)"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 DIED                         "Died during hospitalization"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DISP_X                       "Disposition of patient (as received from source)"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG24                        "DRG, version 24"
 DRGVER                       "DRG grouper version used on discharge date"
 DX1                          "Diagnosis 1"
 DX2                          "Diagnosis 2"
 DX3                          "Diagnosis 3"
 DX4                          "Diagnosis 4"
 DX5                          "Diagnosis 5"
 DX6                          "Diagnosis 6"
 DX7                          "Diagnosis 7"
 DX8                          "Diagnosis 8"
 DX9                          "Diagnosis 9"
 DX10                         "Diagnosis 10"
 DX11                         "Diagnosis 11"
 DX12                         "Diagnosis 12"
 DX13                         "Diagnosis 13"
 DX14                         "Diagnosis 14"
 DX15                         "Diagnosis 15"
 DXCCS1                       "CCS: diagnosis 1"
 DXCCS2                       "CCS: diagnosis 2"
 DXCCS3                       "CCS: diagnosis 3"
 DXCCS4                       "CCS: diagnosis 4"
 DXCCS5                       "CCS: diagnosis 5"
 DXCCS6                       "CCS: diagnosis 6"
 DXCCS7                       "CCS: diagnosis 7"
 DXCCS8                       "CCS: diagnosis 8"
 DXCCS9                       "CCS: diagnosis 9"
 DXCCS10                      "CCS: diagnosis 10"
 DXCCS11                      "CCS: diagnosis 11"
 DXCCS12                      "CCS: diagnosis 12"
 DXCCS13                      "CCS: diagnosis 13"
 DXCCS14                      "CCS: diagnosis 14"
 DXCCS15                      "CCS: diagnosis 15"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DaysICU
"Days in medical/surgical intensive care unit (as received from source)"
 ECODE1                       "E code 1"
 ECODE2                       "E code 2"
 ECODE3                       "E code 3"
 ECODE4                       "E code 4"
 ECODE5                       "E code 5"
 ECODE6                       "E code 6"
 ECODE7                       "E code 7"
 ECODE8                       "E code 8"
 E_CCS1                       "CCS: E Code 1"
 E_CCS2                       "CCS: E Code 2"
 E_CCS3                       "CCS: E Code 3"
 E_CCS4                       "CCS: E Code 4"
 E_CCS5                       "CCS: E Code 5"
 E_CCS6                       "CCS: E Code 6"
 E_CCS7                       "CCS: E Code 7"
 E_CCS8                       "CCS: E Code 8"
 E_POA1                       "E Code 1, present on admission indicator"
 E_POA2                       "E Code 2, present on admission indicator"
 E_POA3                       "E Code 3, present on admission indicator"
 E_POA4                       "E Code 4, present on admission indicator"
 E_POA5                       "E Code 5, present on admission indicator"
 E_POA6                       "E Code 6, present on admission indicator"
 E_POA7                       "E Code 7, present on admission indicator"
 E_POA8                       "E Code 8, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HOSPBRTH                     "Indicator of birth in this hospital"
 HOSPST                       "Hospital state postal code"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC24                        "MDC, version 24"
 MDSPEC1                      "Physician 1 specialty (as received from source)"
 MDSPEC2                      "Physician 2 specialty (as received from source)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 NDX                          "Number of diagnoses on this record"
 NECODE                       "Number of E codes on this record"
 NEOMAT                       "Neonatal and/or maternal DX and/or PR"
 NPR                          "Number of procedures on this record"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PL_NCHS2006                  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PR1                          "Procedure 1"
 PR2                          "Procedure 2"
 PR3                          "Procedure 3"
 PR4                          "Procedure 4"
 PR5                          "Procedure 5"
 PR6                          "Procedure 6"
 PR7                          "Procedure 7"
 PR8                          "Procedure 8"
 PR9                          "Procedure 9"
 PR10                         "Procedure 10"
 PR11                         "Procedure 11"
 PR12                         "Procedure 12"
 PR13                         "Procedure 13"
 PRCCS1                       "CCS: procedure 1"
 PRCCS2                       "CCS: procedure 2"
 PRCCS3                       "CCS: procedure 3"
 PRCCS4                       "CCS: procedure 4"
 PRCCS5                       "CCS: procedure 5"
 PRCCS6                       "CCS: procedure 6"
 PRCCS7                       "CCS: procedure 7"
 PRCCS8                       "CCS: procedure 8"
 PRCCS9                       "CCS: procedure 9"
 PRCCS10                      "CCS: procedure 10"
 PRCCS11                      "CCS: procedure 11"
 PRCCS12                      "CCS: procedure 12"
 PRCCS13                      "CCS: procedure 13"
 PRDAY1                       "Number of days from admission to PR1"
 PRDAY2                       "Number of days from admission to PR2"
 PRDAY3                       "Number of days from admission to PR3"
 PRDAY4                       "Number of days from admission to PR4"
 PRDAY5                       "Number of days from admission to PR5"
 PRDAY6                       "Number of days from admission to PR6"
 PRDAY7                       "Number of days from admission to PR7"
 PRDAY8                       "Number of days from admission to PR8"
 PRDAY9                       "Number of days from admission to PR9"
 PRDAY10                      "Number of days from admission to PR10"
 PRDAY11                      "Number of days from admission to PR11"
 PRDAY12                      "Number of days from admission to PR12"
 PRDAY13                      "Number of days from admission to PR13"
 PROCTYPE                     "Procedure type indicator"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PointOfOriginUB04
"Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X
"Point of origin for admission or visit, as received from source"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 YEAR                         "Calendar year"
 ZIPINC_QRTL
"Median household income national quartile for patient ZIP Code"
 AGEGROUP                     "Age Group" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysICU
 (-99,-88,-66,-55=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEGROUP
 (-99,-88,-66,-55=SYSMIS).



SAVE OUTFILE = 'SC_SID_2007_CORE.SAV' /COMPRESSED.
