/*******************************************************************
*   MD_SID_2000_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL CONVERT THE ASCII             
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MD_SID_2000_CORE.ASC' FIXED / 
 KEY                  1- 14
 AGE                 15- 17
 AGEDAY              18- 20
 AGEMONTH            21- 23
 ASOURCE             24- 25
 ASOURCE_            26- 27 (A)
 ATYPE               28- 29
 AWEEKEND            30- 31
 BWT                 32- 35
 DaysBurn            36- 38
 DaysCCU             39- 41
 DaysICU             42- 44
 DaysNICU            45- 47
 DaysPICU            48- 50
 DaysShoc            51- 53
 DIED                54- 55
 DISP_X              56- 57 (A)
 DISPUNIF            58- 59
 DQTR                60- 61
 DRG                 62- 64
 DRG18               65- 67
 DRGVER              68- 69
 DSHOSPID            70- 82 (A)
 DX1                 83- 87 (A)
 DX2                 88- 92 (A)
 DX3                 93- 97 (A)
 DX4                 98-102 (A)
 DX5                103-107 (A)
 DX6                108-112 (A)
 DX7                113-117 (A)
 DX8                118-122 (A)
 DX9                123-127 (A)
 DX10               128-132 (A)
 DX11               133-137 (A)
 DX12               138-142 (A)
 DX13               143-147 (A)
 DX14               148-152 (A)
 DX15               153-157 (A)
 DX16               158-162 (A)
 DXCCS1             163-166
 DXCCS2             167-170
 DXCCS3             171-174
 DXCCS4             175-178
 DXCCS5             179-182
 DXCCS6             183-186
 DXCCS7             187-190
 DXCCS8             191-194
 DXCCS9             195-198
 DXCCS10            199-202
 DXCCS11            203-206
 DXCCS12            207-210
 DXCCS13            211-214
 DXCCS14            215-218
 DXCCS15            219-222
 DXCCS16            223-226
 FEMALE             227-228
 HISPANIC           229 (A)
 HOSPST             230-231 (A)
 LOS                232-236
 LOS_X              237-242
 MDC                243-244
 MDC18              245-246
 MDID_S             247-262 (A)
 MRN_S              263-279 (A)
 NDX                280-281
 NEOMAT             282-283
 NPR                284-285
 PAY1               286-287
 PAY2               288-289
 PAY1_X             290-291 (A)
 PAY2_X             292-293 (A)
 PAYER1_X           294-295 (A)
 PAYER2_X           296-297 (A)
 PR1                298-301 (A)
 PR2                302-305 (A)
 PR3                306-309 (A)
 PR4                310-313 (A)
 PR5                314-317 (A)
 PR6                318-321 (A)
 PR7                322-325 (A)
 PR8                326-329 (A)
 PR9                330-333 (A)
 PR10               334-337 (A)
 PR11               338-341 (A)
 PR12               342-345 (A)
 PR13               346-349 (A)
 PR14               350-353 (A)
 PR15               354-357 (A)
 PRCCS1             358-360
 PRCCS2             361-363
 PRCCS3             364-366
 PRCCS4             367-369
 PRCCS5             370-372
 PRCCS6             373-375
 PRCCS7             376-378
 PRCCS8             379-381
 PRCCS9             382-384
 PRCCS10            385-387
 PRCCS11            388-390
 PRCCS12            391-393
 PRCCS13            394-396
 PRCCS14            397-399
 PRCCS15            400-402
 PRDAY1             403-405
 PRDAY2             406-408
 PRDAY3             409-411
 PRDAY4             412-414
 PRDAY5             415-417
 PRDAY6             418-420
 PRDAY7             421-423
 PRDAY8             424-426
 PRDAY9             427-429
 PRDAY10            430-432
 PRDAY11            433-435
 RACE               436-437
 RACE_X             438 (A)
 SURGID_S           439-454 (A)
 TOTCHG             455-464
 TOTCHG_X           465-479
 YEAR               480-483.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 AGEMONTH            (F3.0) /
 ASOURCE             (F3.0) /
 ATYPE               (F3.0) /
 AWEEKEND            (F3.0) /
 BWT                 (F4.0) /
 DaysBurn            (F3.0) /
 DaysCCU             (F3.0) /
 DaysICU             (F3.0) /
 DaysNICU            (F3.0) /
 DaysPICU            (F3.0) /
 DaysShoc            (F3.0) /
 DIED                (F3.0) /
 DISPUNIF            (F3.0) /
 DQTR                (F3.0) /
 DRG                 (F3.0) /
 DRG18               (F3.0) /
 DRGVER              (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 DXCCS10             (F4.0) /
 DXCCS11             (F4.0) /
 DXCCS12             (F4.0) /
 DXCCS13             (F4.0) /
 DXCCS14             (F4.0) /
 DXCCS15             (F4.0) /
 DXCCS16             (F4.0) /
 FEMALE              (F3.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 MDC                 (F3.0) /
 MDC18               (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PAY2                (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PRCCS7              (F3.0) /
 PRCCS8              (F3.0) /
 PRCCS9              (F3.0) /
 PRCCS10             (F3.0) /
 PRCCS11             (F3.0) /
 PRCCS12             (F3.0) /
 PRCCS13             (F3.0) /
 PRCCS14             (F3.0) /
 PRCCS15             (F3.0) /
 PRDAY1              (F4.0) /
 PRDAY2              (F4.0) /
 PRDAY3              (F4.0) /
 PRDAY4              (F4.0) /
 PRDAY5              (F4.0) /
 PRDAY6              (F4.0) /
 PRDAY7              (F4.0) /
 PRDAY8              (F4.0) /
 PRDAY9              (F4.0) /
 PRDAY10             (F4.0) /
 PRDAY11             (F4.0) /
 RACE                (F3.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY          "HCUP record identifier"
 AGE          "Age in years at admission"
 AGEDAY       "Age in days (when age < 1 year)"
 AGEMONTH     "Age in months (when age < 11 years)"
 ASOURCE      "Admission source (uniform)"
 ASOURCE_     "Admission source (as received from source)"
 ATYPE        "Admission type"
 AWEEKEND     "Admission day is a weekend"
 BWT          "Birth weight in grams"
 DaysBurn     "Days in burn care unit (as received from the source)"
 DaysCCU      "Days in coronary care unit (as received from the source)"
 DaysICU      "Days in medical/surgical intensive care unit (as received from the source)"
 DaysNICU     "Days in neonetal care unit (as received from the source)"
 DaysPICU     "Days in pediatric care unit (as received from the source)"
 DaysShoc     "Days in shock trauma unit (as received from the source)"
 DIED         "Died during hospitalization"
 DISP_X       "Disposition of patient (as received from source)"
 DISPUNIF     "Disposition of patient, uniform"
 DQTR         "Discharge quarter"
 DRG          "DRG in effect on discharge date"
 DRG18        "DRG, version 18"
 DRGVER       "DRG grouper version used on discharge date"
 DSHOSPID     "Data source hospital identifier"
 DX1          "Principal diagnosis"
 DX2          "Diagnosis 2"
 DX3          "Diagnosis 3"
 DX4          "Diagnosis 4"
 DX5          "Diagnosis 5"
 DX6          "Diagnosis 6"
 DX7          "Diagnosis 7"
 DX8          "Diagnosis 8"
 DX9          "Diagnosis 9"
 DX10         "Diagnosis 10"
 DX11         "Diagnosis 11"
 DX12         "Diagnosis 12"
 DX13         "Diagnosis 13"
 DX14         "Diagnosis 14"
 DX15         "Diagnosis 15"
 DX16         "Diagnosis 16"
 DXCCS1       "CCS: principal diagnosis"
 DXCCS2       "CCS: diagnosis 2"
 DXCCS3       "CCS: diagnosis 3"
 DXCCS4       "CCS: diagnosis 4"
 DXCCS5       "CCS: diagnosis 5"
 DXCCS6       "CCS: diagnosis 6"
 DXCCS7       "CCS: diagnosis 7"
 DXCCS8       "CCS: diagnosis 8"
 DXCCS9       "CCS: diagnosis 9"
 DXCCS10      "CCS: diagnosis 10"
 DXCCS11      "CCS: diagnosis 11"
 DXCCS12      "CCS: diagnosis 12"
 DXCCS13      "CCS: diagnosis 13"
 DXCCS14      "CCS: diagnosis 14"
 DXCCS15      "CCS: diagnosis 15"
 DXCCS16      "CCS: diagnosis 16"
 FEMALE       "Indicator of sex"
 HISPANIC     "Hispanic ethnicity (as received from source)"
 HOSPST       "Hospital state postal code"
 LOS          "Length of stay (cleaned)"
 LOS_X        "Length of stay (as received from source)"
 MDC          "MDC in effect on discharge date"
 MDC18        "MDC, version 18"
 MDID_S       "Attending physician number (synthetic)"
 MRN_S        "Medical record number (synthetic)"
 NDX          "Number of diagnoses on this record"
 NEOMAT       "Neonatal and/or maternal DX and/or PR"
 NPR          "Number of procedures on this record"
 PAY1         "Primary expected payer (uniform)"
 PAY2         "Secondary expected payer (uniform)"
 PAY1_X       "Primary expected payer (as received from source)"
 PAY2_X       "Secondary expected payer (as received from source)"
 PAYER1_X     "Primary expected payer plan identifier (as received from source)"
 PAYER2_X     "Secondary expected payer plan identifier (as received from source)"
 PR1          "Principal procedure"
 PR2          "Procedure 2"
 PR3          "Procedure 3"
 PR4          "Procedure 4"
 PR5          "Procedure 5"
 PR6          "Procedure 6"
 PR7          "Procedure 7"
 PR8          "Procedure 8"
 PR9          "Procedure 9"
 PR10         "Procedure 10"
 PR11         "Procedure 11"
 PR12         "Procedure 12"
 PR13         "Procedure 13"
 PR14         "Procedure 14"
 PR15         "Procedure 15"
 PRCCS1       "CCS: principal procedure"
 PRCCS2       "CCS: procedure 2"
 PRCCS3       "CCS: procedure 3"
 PRCCS4       "CCS: procedure 4"
 PRCCS5       "CCS: procedure 5"
 PRCCS6       "CCS: procedure 6"
 PRCCS7       "CCS: procedure 7"
 PRCCS8       "CCS: procedure 8"
 PRCCS9       "CCS: procedure 9"
 PRCCS10      "CCS: procedure 10"
 PRCCS11      "CCS: procedure 11"
 PRCCS12      "CCS: procedure 12"
 PRCCS13      "CCS: procedure 13"
 PRCCS14      "CCS: procedure 14"
 PRCCS15      "CCS: procedure 15"
 PRDAY1       "Number of days from admission to PR1"
 PRDAY2       "Number of days from admission to PR2"
 PRDAY3       "Number of days from admission to PR3"
 PRDAY4       "Number of days from admission to PR4"
 PRDAY5       "Number of days from admission to PR5"
 PRDAY6       "Number of days from admission to PR6"
 PRDAY7       "Number of days from admission to PR7"
 PRDAY8       "Number of days from admission to PR8"
 PRDAY9       "Number of days from admission to PR9"
 PRDAY10      "Number of days from admission to PR10"
 PRDAY11      "Number of days from admission to PR11"
 RACE         "Race (uniform)"
 RACE_X       "Race (as received from source)"
 SURGID_S     "Primary surgeon number (synthetic)"
 TOTCHG       "Total charges (cleaned)"
 TOTCHG_X     "Total charges (as received from source)"
 YEAR         "Calendar year".


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysBurn
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysCCU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysNICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysPICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysShoc
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).



SAVE OUTFILE = 'MD_SID_2000_CORE.SAV' /COMPRESSED.
