/*******************************************************************
*   MA_SID_2012_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MA_SID_2012_CORE.ASC' FIXED SKIP=2 / 
 ADRG                       1-   3
 ADRGRISKMORTALITY          4-   5
 ADRGSEV                    6-   7
 AGE                        8-  10
 AGEMONTH                  11-  13
 AMDC                      14-  15
 AMONTH                    16-  17
 ASOURCE                   18-  19
 ASOURCEUB92               20     (A)
 ASOURCE_X                 21     (A)
 ATYPE                     22-  23
 AWEEKEND                  24-  25
 BWT                       26-  29
 DIED                      30-  31
 DISPUB04                  32-  33
 DISPUNIFORM               34-  35
 DISP_X                    36-  37 (A)
 DNR                       38-  39
 DQTR                      40-  41
 DRG                       42-  44
 DRG24                     45-  47
 DRGVER                    48-  49
 DRG_NoPOA                 50-  52
 DSHOSPID                  53-  69 (A)
 DX1                       70-  74 (A)
 DX2                       75-  79 (A)
 DX3                       80-  84 (A)
 DX4                       85-  89 (A)
 DX5                       90-  94 (A)
 DX6                       95-  99 (A)
 DX7                      100- 104 (A)
 DX8                      105- 109 (A)
 DX9                      110- 114 (A)
 DX10                     115- 119 (A)
 DX11                     120- 124 (A)
 DX12                     125- 129 (A)
 DX13                     130- 134 (A)
 DX14                     135- 139 (A)
 DX15                     140- 144 (A)
 DXCCS1                   145- 148
 DXCCS2                   149- 152
 DXCCS3                   153- 156
 DXCCS4                   157- 160
 DXCCS5                   161- 164
 DXCCS6                   165- 168
 DXCCS7                   169- 172
 DXCCS8                   173- 176
 DXCCS9                   177- 180
 DXCCS10                  181- 184
 DXCCS11                  185- 188
 DXCCS12                  189- 192
 DXCCS13                  193- 196
 DXCCS14                  197- 200
 DXCCS15                  201- 204
 DXPOA1                   205     (A)
 DXPOA2                   206     (A)
 DXPOA3                   207     (A)
 DXPOA4                   208     (A)
 DXPOA5                   209     (A)
 DXPOA6                   210     (A)
 DXPOA7                   211     (A)
 DXPOA8                   212     (A)
 DXPOA9                   213     (A)
 DXPOA10                  214     (A)
 DXPOA11                  215     (A)
 DXPOA12                  216     (A)
 DXPOA13                  217     (A)
 DXPOA14                  218     (A)
 DXPOA15                  219     (A)
 DaysBetweenVisits        220- 223
 DaysToEvent              224- 229
 ECODE1                   230- 234 (A)
 ECODE2                   235- 239 (A)
 ECODE3                   240- 244 (A)
 ECODE4                   245- 249 (A)
 ECODE5                   250- 254 (A)
 ECODE6                   255- 259 (A)
 ECODE7                   260- 264 (A)
 ECODE8                   265- 269 (A)
 E_CCS1                   270- 273
 E_CCS2                   274- 277
 E_CCS3                   278- 281
 E_CCS4                   282- 285
 E_CCS5                   286- 289
 E_CCS6                   290- 293
 E_CCS7                   294- 297
 E_CCS8                   298- 301
 E_POA1                   302     (A)
 E_POA2                   303     (A)
 E_POA3                   304     (A)
 E_POA4                   305     (A)
 E_POA5                   306     (A)
 E_POA6                   307     (A)
 E_POA7                   308     (A)
 E_POA8                   309     (A)
 FEMALE                   310- 311
 HCUP_ED                  312- 313
 HCUP_OS                  314- 315
 HISPANIC_X               316- 330 (A)
 HOSPBRTH                 331- 333
 HOSPST                   334- 335 (A)
 Homeless                 336- 337
 KEY                      338- 352
 LOS                      353- 357
 LOS_X                    358- 363
 MDC                      364- 365
 MDC24                    366- 367
 MDC_NoPOA                368- 369
 MEDINCSTQ                370- 371
 NCHRONIC                 372- 374
 NDX                      375- 376
 NECODE                   377- 378
 NEOMAT                   379- 380
 NPR                      381- 382
 ORPROC                   383- 384
 OS_TIME                  385- 392
 PAY1                     393- 394
 PAY1_X                   395     (A)
 PAY2                     396- 397
 PAY2_X                   398     (A)
 PAYER1_X                 399- 401 (A)
 PAYER2_X                 402- 404 (A)
 PL_CBSA                  405- 407
 PL_MSA1993               408- 410
 PL_RUCA10_2005           411- 412
 PL_RUCA2005              413- 416
 PL_RUCA4_2005            417- 418
 PL_UR_CAT4               419- 420
 PR1                      421- 424 (A)
 PR2                      425- 428 (A)
 PR3                      429- 432 (A)
 PR4                      433- 436 (A)
 PR5                      437- 440 (A)
 PR6                      441- 444 (A)
 PR7                      445- 448 (A)
 PR8                      449- 452 (A)
 PR9                      453- 456 (A)
 PR10                     457- 460 (A)
 PR11                     461- 464 (A)
 PR12                     465- 468 (A)
 PR13                     469- 472 (A)
 PR14                     473- 476 (A)
 PR15                     477- 480 (A)
 PRCCS1                   481- 483
 PRCCS2                   484- 486
 PRCCS3                   487- 489
 PRCCS4                   490- 492
 PRCCS5                   493- 495
 PRCCS6                   496- 498
 PRCCS7                   499- 501
 PRCCS8                   502- 504
 PRCCS9                   505- 507
 PRCCS10                  508- 510
 PRCCS11                  511- 513
 PRCCS12                  514- 516
 PRCCS13                  517- 519
 PRCCS14                  520- 522
 PRCCS15                  523- 525
 PRDAY1                   526- 530
 PRDAY2                   531- 535
 PRDAY3                   536- 540
 PRDAY4                   541- 545
 PRDAY5                   546- 550
 PRDAY6                   551- 555
 PRDAY7                   556- 560
 PRDAY8                   561- 565
 PRDAY9                   566- 570
 PRDAY10                  571- 575
 PRDAY11                  576- 580
 PRDAY12                  581- 585
 PRDAY13                  586- 590
 PRDAY14                  591- 595
 PRDAY15                  596- 600
 PROCTYPE                 601- 603
 PSTATE                   604- 605 (A)
 PSTCO2                   606- 610
 RACE                     611- 612
 RACE_X                   613- 617 (A)
 TOTCHG                   618- 627
 TOTCHG_X                 628- 642
 TRAN_IN                  643- 644
 TRAN_OUT                 645- 646
 VisitLink                647- 655
 YEAR                     656- 659
 ZIP3                     660- 662 (A)
 ZIPINC_QRTL              663- 665
 AYEAR                    666- 669
 DMONTH                   670- 671
 PRMONTH1                 672- 673
 PRMONTH2                 674- 675
 PRMONTH3                 676- 677
 PRMONTH4                 678- 679
 PRMONTH5                 680- 681
 PRMONTH6                 682- 683
 PRMONTH7                 684- 685
 PRMONTH8                 686- 687
 PRMONTH9                 688- 689
 PRMONTH10                690- 691
 PRMONTH11                692- 693
 PRMONTH12                694- 695
 PRMONTH13                696- 697
 PRMONTH14                698- 699
 PRMONTH15                700- 701
 PRYEAR1                  702- 705
 PRYEAR2                  706- 709
 PRYEAR3                  710- 713
 PRYEAR4                  714- 717
 PRYEAR5                  718- 721
 PRYEAR6                  722- 725
 PRYEAR7                  726- 729
 PRYEAR8                  730- 733
 PRYEAR9                  734- 737
 PRYEAR10                 738- 741
 PRYEAR11                 742- 745
 PRYEAR12                 746- 749
 PRYEAR13                 750- 753
 PRYEAR14                 754- 757
 PRYEAR15                 758- 761.


***  Specify write formats  ***.
FORMATS
 ADRG                    (F3.0) /
 ADRGRISKMORTALITY       (F3.0) /
 ADRGSEV                 (F3.0) /
 AGE                     (F3.0) /
 AGEMONTH                (F3.0) /
 AMDC                    (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 BWT                     (F4.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DNR                     (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DRG_NoPOA               (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DaysBetweenVisits       (F3.0) /
 DaysToEvent             (F8.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Homeless                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MDC_NoPOA               (F3.0) /
 MEDINCSTQ               (F3.0) /
 NCHRONIC                (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 OS_TIME                 (F4.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 TRAN_IN                 (F3.0) /
 TRAN_OUT                (F3.0) /
 VisitLink               (F8.0) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 PRMONTH1                (F3.0) /
 PRMONTH2                (F3.0) /
 PRMONTH3                (F3.0) /
 PRMONTH4                (F3.0) /
 PRMONTH5                (F3.0) /
 PRMONTH6                (F3.0) /
 PRMONTH7                (F3.0) /
 PRMONTH8                (F3.0) /
 PRMONTH9                (F3.0) /
 PRMONTH10               (F3.0) /
 PRMONTH11               (F3.0) /
 PRMONTH12               (F3.0) /
 PRMONTH13               (F3.0) /
 PRMONTH14               (F3.0) /
 PRMONTH15               (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 ADRG                    "All Patient Refined DRG"
 ADRGRISKMORTALITY       "All Patient Refined DRG mortality risk"
 ADRGSEV                 "All Patient Refined DRG severity level"
 AGE                     "Age in years at admission"
 AGEMONTH                "Age in months (when age < 11 years)"
 AMDC                    "All Patient Refined MDC"
 AMONTH                  "Admission month"
 ASOURCE                 "Admission source (uniform)"
 ASOURCEUB92             "Admission source (UB-92 standard coding)"
 ASOURCE_X               "Admission source (as received from source)"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 BWT                     "Birth weight in grams"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DNR                     "Do not resuscitate indicator"
 DQTR                    "Discharge quarter"
 DRG                     "DRG in effect on discharge date"
 DRG24                   "DRG, version 24"
 DRGVER                  "DRG grouper version used on discharge date"
 DRG_NoPOA               "DRG in use on discharge date, calculated without POA"
 DSHOSPID                "Data source hospital identifier"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXPOA1                  "Diagnosis 1, present on admission indicator"
 DXPOA2                  "Diagnosis 2, present on admission indicator"
 DXPOA3                  "Diagnosis 3, present on admission indicator"
 DXPOA4                  "Diagnosis 4, present on admission indicator"
 DXPOA5                  "Diagnosis 5, present on admission indicator"
 DXPOA6                  "Diagnosis 6, present on admission indicator"
 DXPOA7                  "Diagnosis 7, present on admission indicator"
 DXPOA8                  "Diagnosis 8, present on admission indicator"
 DXPOA9                  "Diagnosis 9, present on admission indicator"
 DXPOA10                 "Diagnosis 10, present on admission indicator"
 DXPOA11                 "Diagnosis 11, present on admission indicator"
 DXPOA12                 "Diagnosis 12, present on admission indicator"
 DXPOA13                 "Diagnosis 13, present on admission indicator"
 DXPOA14                 "Diagnosis 14, present on admission indicator"
 DXPOA15                 "Diagnosis 15, present on admission indicator"
 DaysBetweenVisits       "Number of days between visits"
 DaysToEvent             "Days from 'start date' to admission"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 ECODE7                  "E code 7"
 ECODE8                  "E code 8"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_CCS7                  "CCS: E Code 7"
 E_CCS8                  "CCS: E Code 8"
 E_POA1                  "E Code 1, present on admission indicator"
 E_POA2                  "E Code 2, present on admission indicator"
 E_POA3                  "E Code 3, present on admission indicator"
 E_POA4                  "E Code 4, present on admission indicator"
 E_POA5                  "E Code 5, present on admission indicator"
 E_POA6                  "E Code 6, present on admission indicator"
 E_POA7                  "E Code 7, present on admission indicator"
 E_POA8                  "E Code 8, present on admission indicator"
 FEMALE                  "Indicator of sex"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HISPANIC_X              "Hispanic ethnicity (as received from source)"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 Homeless                "Indicator that patient is homeless"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MDC                     "MDC in effect on discharge date"
 MDC24                   "MDC, version 24"
 MDC_NoPOA               "MDC in use on discharge date, calculated without POA"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 NCHRONIC                "Number of chronic conditions"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 ORPROC                  "Major operating room procedure indicator"
 OS_TIME                 "Observation stay time summed from UNITS"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAY2                    "Secondary expected payer (uniform)"
 PAY2_X                  "Secondary expected payer (as received from source)"
 PAYER1_X                "Primary expected payer plan identifier (as received from source)"
 PAYER2_X
"Secondary expected payer plan identifier (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PR11                    "Procedure 11"
 PR12                    "Procedure 12"
 PR13                    "Procedure 13"
 PR14                    "Procedure 14"
 PR15                    "Procedure 15"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRCCS11                 "CCS: procedure 11"
 PRCCS12                 "CCS: procedure 12"
 PRCCS13                 "CCS: procedure 13"
 PRCCS14                 "CCS: procedure 14"
 PRCCS15                 "CCS: procedure 15"
 PRDAY1                  "Number of days from admission to PR1"
 PRDAY2                  "Number of days from admission to PR2"
 PRDAY3                  "Number of days from admission to PR3"
 PRDAY4                  "Number of days from admission to PR4"
 PRDAY5                  "Number of days from admission to PR5"
 PRDAY6                  "Number of days from admission to PR6"
 PRDAY7                  "Number of days from admission to PR7"
 PRDAY8                  "Number of days from admission to PR8"
 PRDAY9                  "Number of days from admission to PR9"
 PRDAY10                 "Number of days from admission to PR10"
 PRDAY11                 "Number of days from admission to PR11"
 PRDAY12                 "Number of days from admission to PR12"
 PRDAY13                 "Number of days from admission to PR13"
 PRDAY14                 "Number of days from admission to PR14"
 PRDAY15                 "Number of days from admission to PR15"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 TRAN_IN                 "Transfer in indicator"
 TRAN_OUT                "Transfer out indicator"
 VisitLink               "Visit linkage variable"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month"
 PRMONTH1                "Month of procedure 1"
 PRMONTH2                "Month of procedure 2"
 PRMONTH3                "Month of procedure 3"
 PRMONTH4                "Month of procedure 4"
 PRMONTH5                "Month of procedure 5"
 PRMONTH6                "Month of procedure 6"
 PRMONTH7                "Month of procedure 7"
 PRMONTH8                "Month of procedure 8"
 PRMONTH9                "Month of procedure 9"
 PRMONTH10               "Month of procedure 10"
 PRMONTH11               "Month of procedure 11"
 PRMONTH12               "Month of procedure 12"
 PRMONTH13               "Month of procedure 13"
 PRMONTH14               "Month of procedure 14"
 PRMONTH15               "Month of procedure 15"
 PRYEAR1                 "Year of procedure 1"
 PRYEAR2                 "Year of procedure 2"
 PRYEAR3                 "Year of procedure 3"
 PRYEAR4                 "Year of procedure 4"
 PRYEAR5                 "Year of procedure 5"
 PRYEAR6                 "Year of procedure 6"
 PRYEAR7                 "Year of procedure 7"
 PRYEAR8                 "Year of procedure 8"
 PRYEAR9                 "Year of procedure 9"
 PRYEAR10                "Year of procedure 10"
 PRYEAR11                "Year of procedure 11"
 PRYEAR12                "Year of procedure 12"
 PRYEAR13                "Year of procedure 13"
 PRYEAR14                "Year of procedure 14"
 PRYEAR15                "Year of procedure 15" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE ADRG
 (-99,-88,-66,-55=SYSMIS).
RECODE ADRGRISKMORTALITY
 (-9,-8,-6,-5=SYSMIS).
RECODE ADRGSEV
 (-9,-8,-6,-5=SYSMIS).
RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMDC
 (-9,-8,-6,-5=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DNR
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysBetweenVisits
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE OS_TIME
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MA_SID_2012_CORE.SAV' /COMPRESSED.
