/*******************************************************************
*   MA_SID_2000_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL CONVERT THE ASCII             
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MA_SID_2000_CORE.ASC' FIXED / 
 KEY                  1- 14
 AGE                 15- 17
 AMONTH              18- 19
 ASOURCE             20- 21
 ASOURCE_            22 (A)
 ATYPE               23- 24
 AWEEKEND            25- 26
 BWT                 27- 30
 DIED                31- 32
 DISP_X              33- 34 (A)
 DISPUB92            35- 36
 DISPUNIF            37- 38
 DQTR                39- 40
 DRG                 41- 43
 DRG18               44- 46
 DRGVER              47- 48
 DSHOSPID            49- 61 (A)
 DX1                 62- 66 (A)
 DX2                 67- 71 (A)
 DX3                 72- 76 (A)
 DX4                 77- 81 (A)
 DX5                 82- 86 (A)
 DX6                 87- 91 (A)
 DX7                 92- 96 (A)
 DX8                 97-101 (A)
 DX9                102-106 (A)
 DX10               107-111 (A)
 DX11               112-116 (A)
 DX12               117-121 (A)
 DX13               122-126 (A)
 DX14               127-131 (A)
 DX15               132-136 (A)
 DX16               137-141 (A)
 DXCCS1             142-145
 DXCCS2             146-149
 DXCCS3             150-153
 DXCCS4             154-157
 DXCCS5             158-161
 DXCCS6             162-165
 DXCCS7             166-169
 DXCCS8             170-173
 DXCCS9             174-177
 DXCCS10            178-181
 DXCCS11            182-185
 DXCCS12            186-189
 DXCCS13            190-193
 DXCCS14            194-197
 DXCCS15            198-201
 DXCCS16            202-205
 FEMALE             206-207
 HOSPST             208-209 (A)
 LOS                210-214
 LOS_X              215-220
 MDC                221-222
 MDC18              223-224
 NDX                225-226
 NEOMAT             227-228
 NPR                229-230
 PAY1               231-232
 PAY2               233-234
 PAY1_X             235 (A)
 PAY2_X             236 (A)
 PAYER1_X           237-239 (A)
 PAYER2_X           240-242 (A)
 PR1                243-246 (A)
 PR2                247-250 (A)
 PR3                251-254 (A)
 PR4                255-258 (A)
 PR5                259-262 (A)
 PR6                263-266 (A)
 PR7                267-270 (A)
 PR8                271-274 (A)
 PR9                275-278 (A)
 PR10               279-282 (A)
 PR11               283-286 (A)
 PR12               287-290 (A)
 PR13               291-294 (A)
 PR14               295-298 (A)
 PR15               299-302 (A)
 PRCCS1             303-305
 PRCCS2             306-308
 PRCCS3             309-311
 PRCCS4             312-314
 PRCCS5             315-317
 PRCCS6             318-320
 PRCCS7             321-323
 PRCCS8             324-326
 PRCCS9             327-329
 PRCCS10            330-332
 PRCCS11            333-335
 PRCCS12            336-338
 PRCCS13            339-341
 PRCCS14            342-344
 PRCCS15            345-347
 PRDAY1             348-350
 PRDAY2             351-353
 PRDAY3             354-356
 RACE               357-358
 RACE_X             359 (A)
 TOTCHG             360-369
 TOTCHG_X           370-384
 YEAR               385-388
 AYEAR              389-392
 DMONTH             393-394
 PRMNTH1            395-396
 PRMNTH2            397-398
 PRMNTH3            399-400
 PRYEAR1            401-404
 PRYEAR2            405-408
 PRYEAR3            409-412.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AMONTH              (F3.0) /
 ASOURCE             (F3.0) /
 ATYPE               (F3.0) /
 AWEEKEND            (F3.0) /
 BWT                 (F4.0) /
 DIED                (F3.0) /
 DISPUB92            (F3.0) /
 DISPUNIF            (F3.0) /
 DQTR                (F3.0) /
 DRG                 (F3.0) /
 DRG18               (F3.0) /
 DRGVER              (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 DXCCS10             (F4.0) /
 DXCCS11             (F4.0) /
 DXCCS12             (F4.0) /
 DXCCS13             (F4.0) /
 DXCCS14             (F4.0) /
 DXCCS15             (F4.0) /
 DXCCS16             (F4.0) /
 FEMALE              (F3.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 MDC                 (F3.0) /
 MDC18               (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PAY2                (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PRCCS7              (F3.0) /
 PRCCS8              (F3.0) /
 PRCCS9              (F3.0) /
 PRCCS10             (F3.0) /
 PRCCS11             (F3.0) /
 PRCCS12             (F3.0) /
 PRCCS13             (F3.0) /
 PRCCS14             (F3.0) /
 PRCCS15             (F3.0) /
 PRDAY1              (F4.0) /
 PRDAY2              (F4.0) /
 PRDAY3              (F4.0) /
 RACE                (F3.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) /
 AYEAR               (F3.0) /
 DMONTH              (F3.0) /
 PRMNTH1             (F3.0) /
 PRMNTH2             (F3.0) /
 PRMNTH3             (F3.0) /
 PRYEAR1             (F3.0) /
 PRYEAR2             (F3.0) /
 PRYEAR3             (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY          "HCUP record identifier"
 AGE          "Age in years at admission"
 AMONTH       "Admission month"
 ASOURCE      "Admission source (uniform)"
 ASOURCE_     "Admission source (as received from source)"
 ATYPE        "Admission type"
 AWEEKEND     "Admission day is a weekend"
 BWT          "Birth weight in grams"
 DIED         "Died during hospitalization"
 DISP_X       "Disposition of patient (as received from source)"
 DISPUB92     "Disposition of patient (UB-92 standard coding)"
 DISPUNIF     "Disposition of patient (uniform)"
 DQTR         "Discharge quarter"
 DRG          "DRG in effect on discharge date"
 DRG18        "DRG, version 18"
 DRGVER       "DRG grouper version used on discharge date"
 DSHOSPID     "Data source hospital identifier"
 DX1          "Principal diagnosis"
 DX2          "Diagnosis 2"
 DX3          "Diagnosis 3"
 DX4          "Diagnosis 4"
 DX5          "Diagnosis 5"
 DX6          "Diagnosis 6"
 DX7          "Diagnosis 7"
 DX8          "Diagnosis 8"
 DX9          "Diagnosis 9"
 DX10         "Diagnosis 10"
 DX11         "Diagnosis 11"
 DX12         "Diagnosis 12"
 DX13         "Diagnosis 13"
 DX14         "Diagnosis 14"
 DX15         "Diagnosis 15"
 DX16         "Diagnosis 16"
 DXCCS1       "CCS: principal diagnosis"
 DXCCS2       "CCS: diagnosis 2"
 DXCCS3       "CCS: diagnosis 3"
 DXCCS4       "CCS: diagnosis 4"
 DXCCS5       "CCS: diagnosis 5"
 DXCCS6       "CCS: diagnosis 6"
 DXCCS7       "CCS: diagnosis 7"
 DXCCS8       "CCS: diagnosis 8"
 DXCCS9       "CCS: diagnosis 9"
 DXCCS10      "CCS: diagnosis 10"
 DXCCS11      "CCS: diagnosis 11"
 DXCCS12      "CCS: diagnosis 12"
 DXCCS13      "CCS: diagnosis 13"
 DXCCS14      "CCS: diagnosis 14"
 DXCCS15      "CCS: diagnosis 15"
 DXCCS16      "CCS: diagnosis 16"
 FEMALE       "Indicator of sex"
 HOSPST       "Hospital state postal code"
 LOS          "Length of stay (cleaned)"
 LOS_X        "Length of stay (as received from source)"
 MDC          "MDC in effect on discharge date"
 MDC18        "MDC, version 18"
 NDX          "Number of diagnoses on this record"
 NEOMAT       "Neonatal and/or maternal DX and/or PR"
 NPR          "Number of procedures on this record"
 PAY1         "Primary expected payer (uniform)"
 PAY2         "Secondary expected payer (uniform)"
 PAY1_X       "Primary expected payer (as received from source)"
 PAY2_X       "Secondary expected payer (as received from source)"
 PAYER1_X     "Primary expected payer plan identifier (as received from source)"
 PAYER2_X     "Secondary expected payer plan identifier (as received from source)"
 PR1          "Principal procedure"
 PR2          "Procedure 2"
 PR3          "Procedure 3"
 PR4          "Procedure 4"
 PR5          "Procedure 5"
 PR6          "Procedure 6"
 PR7          "Procedure 7"
 PR8          "Procedure 8"
 PR9          "Procedure 9"
 PR10         "Procedure 10"
 PR11         "Procedure 11"
 PR12         "Procedure 12"
 PR13         "Procedure 13"
 PR14         "Procedure 14"
 PR15         "Procedure 15"
 PRCCS1       "CCS: principal procedure"
 PRCCS2       "CCS: procedure 2"
 PRCCS3       "CCS: procedure 3"
 PRCCS4       "CCS: procedure 4"
 PRCCS5       "CCS: procedure 5"
 PRCCS6       "CCS: procedure 6"
 PRCCS7       "CCS: procedure 7"
 PRCCS8       "CCS: procedure 8"
 PRCCS9       "CCS: procedure 9"
 PRCCS10      "CCS: procedure 10"
 PRCCS11      "CCS: procedure 11"
 PRCCS12      "CCS: procedure 12"
 PRCCS13      "CCS: procedure 13"
 PRCCS14      "CCS: procedure 14"
 PRCCS15      "CCS: procedure 15"
 PRDAY1       "Number of days from admission to PR1"
 PRDAY2       "Number of days from admission to PR2"
 PRDAY3       "Number of days from admission to PR3"
 RACE         "Race (uniform)"
 RACE_X       "Race (as received from source)"
 TOTCHG       "Total charges (cleaned)"
 TOTCHG_X     "Total charges (as received from source)"
 YEAR         "Calendar year"
 AYEAR        "Admission year"
 DMONTH       "Discharge month"
 PRMNTH1      "Month of procedure 1"
 PRMNTH2      "Month of procedure 2"
 PRMNTH3      "Month of procedure 3"
 PRYEAR1      "Year of procedure 1"
 PRYEAR2      "Year of procedure 2"
 PRYEAR3      "Year of procedure 3".


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MA_SID_2000_CORE.SAV' /COMPRESSED.
