/*******************************************************************
*   CA_SID_2003_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'CA_SID_2003_CORE.ASC' FIXED / 
 KEY                        1-  14
 AGE                       15-  17
 AGEDAY                    18-  20
 AGEMONTH                  21-  23
 AMONTH                    24-  25
 ASCHED                    26-  27
 ASOURCE                   28-  29
 ASOURCE_                  30-  32 (A)
 AWEEKEND                  33-  34
 DIED                      35-  36
 DISP_X                    37-  38 (A)
 DISPUNIF                  39-  40
 DNR                       41-  42
 DQTR                      43-  44
 DRG                       45-  47
 DRG18                     48-  50
 DRGVER                    51-  52
 DSHOSPID                  53-  65 (A)
 DX1                       66-  70 (A)
 DX2                       71-  75 (A)
 DX3                       76-  80 (A)
 DX4                       81-  85 (A)
 DX5                       86-  90 (A)
 DX6                       91-  95 (A)
 DX7                       96- 100 (A)
 DX8                      101- 105 (A)
 DX9                      106- 110 (A)
 DX10                     111- 115 (A)
 DX11                     116- 120 (A)
 DX12                     121- 125 (A)
 DX13                     126- 130 (A)
 DX14                     131- 135 (A)
 DX15                     136- 140 (A)
 DX16                     141- 145 (A)
 DX17                     146- 150 (A)
 DX18                     151- 155 (A)
 DX19                     156- 160 (A)
 DX20                     161- 165 (A)
 DX21                     166- 170 (A)
 DX22                     171- 175 (A)
 DX23                     176- 180 (A)
 DX24                     181- 185 (A)
 DX25                     186- 190 (A)
 DXATAD1                  191- 192
 DXATAD2                  193- 194
 DXATAD3                  195- 196
 DXATAD4                  197- 198
 DXATAD5                  199- 200
 DXATAD6                  201- 202
 DXATAD7                  203- 204
 DXATAD8                  205- 206
 DXATAD9                  207- 208
 DXATAD10                 209- 210
 DXATAD11                 211- 212
 DXATAD12                 213- 214
 DXATAD13                 215- 216
 DXATAD14                 217- 218
 DXATAD15                 219- 220
 DXATAD16                 221- 222
 DXATAD17                 223- 224
 DXATAD18                 225- 226
 DXATAD19                 227- 228
 DXATAD20                 229- 230
 DXATAD21                 231- 232
 DXATAD22                 233- 234
 DXATAD23                 235- 236
 DXATAD24                 237- 238
 DXATAD25                 239- 240
 DXCCS1                   241- 244
 DXCCS2                   245- 248
 DXCCS3                   249- 252
 DXCCS4                   253- 256
 DXCCS5                   257- 260
 DXCCS6                   261- 264
 DXCCS7                   265- 268
 DXCCS8                   269- 272
 DXCCS9                   273- 276
 DXCCS10                  277- 280
 DXCCS11                  281- 284
 DXCCS12                  285- 288
 DXCCS13                  289- 292
 DXCCS14                  293- 296
 DXCCS15                  297- 300
 DXCCS16                  301- 304
 DXCCS17                  305- 308
 DXCCS18                  309- 312
 DXCCS19                  313- 316
 DXCCS20                  317- 320
 DXCCS21                  321- 324
 DXCCS22                  325- 328
 DXCCS23                  329- 332
 DXCCS24                  333- 336
 DXCCS25                  337- 340
 ECODE1                   341- 345 (A)
 ECODE2                   346- 350 (A)
 ECODE3                   351- 355 (A)
 ECODE4                   356- 360 (A)
 ECODE5                   361- 365 (A)
 E_CCS1                   366- 369
 E_CCS2                   370- 373
 E_CCS3                   374- 377
 E_CCS4                   378- 381
 E_CCS5                   382- 385
 FEMALE                   386- 387
 HISPANIC                 388     (A)
 HOSPST                   389- 390 (A)
 LEVELCAR                 391     (A)
 LOS                      392- 396
 LOS_X                    397- 402
 MDC                      403- 404
 MDC18                    405- 406
 NDX                      407- 408
 NECODE                   409- 410
 NEOMAT                   411- 412
 NPR                      413- 414
 PAY1                     415- 416
 PAY1_X                   417- 419 (A)
 PAYER1_X                 420- 423 (A)
 PL_CBSA                  424- 426
 PL_MSA19                 427- 429
 PL_RUCA4                 430- 431
 PL_RUCC2                 432- 433
 PL_UIC20                 434- 435
 PL_UR_CA                 436- 437
 PL_UR_CA                 438- 439
 PNUM_R                   440- 448
 PR1                      449- 452 (A)
 PR2                      453- 456 (A)
 PR3                      457- 460 (A)
 PR4                      461- 464 (A)
 PR5                      465- 468 (A)
 PR6                      469- 472 (A)
 PR7                      473- 476 (A)
 PR8                      477- 480 (A)
 PR9                      481- 484 (A)
 PR10                     485- 488 (A)
 PR11                     489- 492 (A)
 PR12                     493- 496 (A)
 PR13                     497- 500 (A)
 PR14                     501- 504 (A)
 PR15                     505- 508 (A)
 PR16                     509- 512 (A)
 PR17                     513- 516 (A)
 PR18                     517- 520 (A)
 PR19                     521- 524 (A)
 PR20                     525- 528 (A)
 PR21                     529- 532 (A)
 PRCCS1                   533- 535
 PRCCS2                   536- 538
 PRCCS3                   539- 541
 PRCCS4                   542- 544
 PRCCS5                   545- 547
 PRCCS6                   548- 550
 PRCCS7                   551- 553
 PRCCS8                   554- 556
 PRCCS9                   557- 559
 PRCCS10                  560- 562
 PRCCS11                  563- 565
 PRCCS12                  566- 568
 PRCCS13                  569- 571
 PRCCS14                  572- 574
 PRCCS15                  575- 577
 PRCCS16                  578- 580
 PRCCS17                  581- 583
 PRCCS18                  584- 586
 PRCCS19                  587- 589
 PRCCS20                  590- 592
 PRCCS21                  593- 595
 PRDAY1                   596- 600
 PRDAY2                   601- 605
 PRDAY3                   606- 610
 PRDAY4                   611- 615
 PRDAY5                   616- 620
 PRDAY6                   621- 625
 PRDAY7                   626- 630
 PRDAY8                   631- 635
 PRDAY9                   636- 640
 PRDAY10                  641- 645
 PRDAY11                  646- 650
 PRDAY12                  651- 655
 PRDAY13                  656- 660
 PRDAY14                  661- 665
 PRDAY15                  666- 670
 PRDAY16                  671- 675
 PRDAY17                  676- 680
 PRDAY18                  681- 685
 PRDAY19                  686- 690
 PRDAY20                  691- 695
 PRDAY21                  696- 700
 PSTATE                   701- 702 (A)
 RACE                     703- 704
 RACE_X                   705     (A)
 TOTCHG                   706- 715
 TOTCHG_X                 716- 730
 YEAR                     731- 734
 AYEAR                    735- 738
 DMONTH                   739- 740
 BMONTH                   741- 742
 BYEAR                    743- 746
 PRMNTH1                  747- 748
 PRMNTH2                  749- 750
 PRMNTH3                  751- 752
 PRMNTH4                  753- 754
 PRMNTH5                  755- 756
 PRMNTH6                  757- 758
 PRMNTH7                  759- 760
 PRMNTH8                  761- 762
 PRMNTH9                  763- 764
 PRMNTH10                 765- 766
 PRMNTH11                 767- 768
 PRMNTH12                 769- 770
 PRMNTH13                 771- 772
 PRMNTH14                 773- 774
 PRMNTH15                 775- 776
 PRMNTH16                 777- 778
 PRMNTH17                 779- 780
 PRMNTH18                 781- 782
 PRMNTH19                 783- 784
 PRMNTH20                 785- 786
 PRMNTH21                 787- 788
 PRYEAR1                  789- 792
 PRYEAR2                  793- 796
 PRYEAR3                  797- 800
 PRYEAR4                  801- 804
 PRYEAR5                  805- 808
 PRYEAR6                  809- 812
 PRYEAR7                  813- 816
 PRYEAR8                  817- 820
 PRYEAR9                  821- 824
 PRYEAR10                 825- 828
 PRYEAR11                 829- 832
 PRYEAR12                 833- 836
 PRYEAR13                 837- 840
 PRYEAR14                 841- 844
 PRYEAR15                 845- 848
 PRYEAR16                 849- 852
 PRYEAR17                 853- 856
 PRYEAR18                 857- 860
 PRYEAR19                 861- 864
 PRYEAR20                 865- 868
 PRYEAR21                 869- 872.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ASCHED                  (F3.0) /
 ASOURCE                 (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUNIF                (F3.0) /
 DNR                     (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG18                   (F3.0) /
 DRGVER                  (F3.0) /
 DXATAD1                 (F3.0) /
 DXATAD2                 (F3.0) /
 DXATAD3                 (F3.0) /
 DXATAD4                 (F3.0) /
 DXATAD5                 (F3.0) /
 DXATAD6                 (F3.0) /
 DXATAD7                 (F3.0) /
 DXATAD8                 (F3.0) /
 DXATAD9                 (F3.0) /
 DXATAD10                (F3.0) /
 DXATAD11                (F3.0) /
 DXATAD12                (F3.0) /
 DXATAD13                (F3.0) /
 DXATAD14                (F3.0) /
 DXATAD15                (F3.0) /
 DXATAD16                (F3.0) /
 DXATAD17                (F3.0) /
 DXATAD18                (F3.0) /
 DXATAD19                (F3.0) /
 DXATAD20                (F3.0) /
 DXATAD21                (F3.0) /
 DXATAD22                (F3.0) /
 DXATAD23                (F3.0) /
 DXATAD24                (F3.0) /
 DXATAD25                (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 FEMALE                  (F3.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC18                   (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PL_UR_CA                (F3.0) /
 PNUM_R                  (F5.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PRDAY21                 (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRMNTH2                 (F3.0) /
 PRMNTH3                 (F3.0) /
 PRMNTH4                 (F3.0) /
 PRMNTH5                 (F3.0) /
 PRMNTH6                 (F3.0) /
 PRMNTH7                 (F3.0) /
 PRMNTH8                 (F3.0) /
 PRMNTH9                 (F3.0) /
 PRMNTH10                (F3.0) /
 PRMNTH11                (F3.0) /
 PRMNTH12                (F3.0) /
 PRMNTH13                (F3.0) /
 PRMNTH14                (F3.0) /
 PRMNTH15                (F3.0) /
 PRMNTH16                (F3.0) /
 PRMNTH17                (F3.0) /
 PRMNTH18                (F3.0) /
 PRMNTH19                (F3.0) /
 PRMNTH20                (F3.0) /
 PRMNTH21                (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) /
 PRYEAR21                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ASCHED    "Admission scheduled vs. unscheduled"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 AWEEKEND  "Admission day is a weekend"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUNIF  "Disposition of patient (uniform)"
 DNR       "Do not resuscitate indicator"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG18     "DRG, version 18"
 DRGVER    "DRG grouper version used on discharge date"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX17      "Diagnosis 17"
 DX18      "Diagnosis 18"
 DX19      "Diagnosis 19"
 DX20      "Diagnosis 20"
 DX21      "Diagnosis 21"
 DX22      "Diagnosis 22"
 DX23      "Diagnosis 23"
 DX24      "Diagnosis 24"
 DX25      "Diagnosis 25"
 DXATAD1   "Principal diagnosis present at admission"
 DXATAD2   "Diagnosis 2 present at admission"
 DXATAD3   "Diagnosis 3 present at admission"
 DXATAD4   "Diagnosis 4 present at admission"
 DXATAD5   "Diagnosis 5 present at admission"
 DXATAD6   "Diagnosis 6 present at admission"
 DXATAD7   "Diagnosis 7 present at admission"
 DXATAD8   "Diagnosis 8 present at admission"
 DXATAD9   "Diagnosis 9 present at admission"
 DXATAD10  "Diagnosis 10 present at admission"
 DXATAD11  "Diagnosis 11 present at admission"
 DXATAD12  "Diagnosis 12 present at admission"
 DXATAD13  "Diagnosis 13 present at admission"
 DXATAD14  "Diagnosis 14 present at admission"
 DXATAD15  "Diagnosis 15 present at admission"
 DXATAD16  "Diagnosis 16 present at admission"
 DXATAD17  "Diagnosis 17 present at admission"
 DXATAD18  "Diagnosis 18 present at admission"
 DXATAD19  "Diagnosis 19 present at admission"
 DXATAD20  "Diagnosis 20 present at admission"
 DXATAD21  "Diagnosis 21 present at admission"
 DXATAD22  "Diagnosis 22 present at admission"
 DXATAD23  "Diagnosis 23 present at admission"
 DXATAD24  "Diagnosis 24 present at admission"
 DXATAD25  "Diagnosis 25 present at admission"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 DXCCS17   "CCS: diagnosis 17"
 DXCCS18   "CCS: diagnosis 18"
 DXCCS19   "CCS: diagnosis 19"
 DXCCS20   "CCS: diagnosis 20"
 DXCCS21   "CCS: diagnosis 21"
 DXCCS22   "CCS: diagnosis 22"
 DXCCS23   "CCS: diagnosis 23"
 DXCCS24   "CCS: diagnosis 24"
 DXCCS25   "CCS: diagnosis 25"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 FEMALE    "Indicator of sex"
 HISPANIC  "Hispanic ethnicity (as received from source)"
 HOSPST    "Hospital state postal code"
 LEVELCAR  "Level of patient care (as received from source)"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDC       "MDC in effect on discharge date"
 MDC18     "MDC, version 18"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAYER1_X  "Primary expected payer plan identifier (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CA  "Patient Location: Urban-Rural 5 Categories"
 PNUM_R    "Person number (re-identified)"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PR16      "Procedure 16"
 PR17      "Procedure 17"
 PR18      "Procedure 18"
 PR19      "Procedure 19"
 PR20      "Procedure 20"
 PR21      "Procedure 21"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRCCS16   "CCS: procedure 16"
 PRCCS17   "CCS: procedure 17"
 PRCCS18   "CCS: procedure 18"
 PRCCS19   "CCS: procedure 19"
 PRCCS20   "CCS: procedure 20"
 PRCCS21   "CCS: procedure 21"
 PRDAY1    "Number of days from admission to PR1"
 PRDAY2    "Number of days from admission to PR2"
 PRDAY3    "Number of days from admission to PR3"
 PRDAY4    "Number of days from admission to PR4"
 PRDAY5    "Number of days from admission to PR5"
 PRDAY6    "Number of days from admission to PR6"
 PRDAY7    "Number of days from admission to PR7"
 PRDAY8    "Number of days from admission to PR8"
 PRDAY9    "Number of days from admission to PR9"
 PRDAY10   "Number of days from admission to PR10"
 PRDAY11   "Number of days from admission to PR11"
 PRDAY12   "Number of days from admission to PR12"
 PRDAY13   "Number of days from admission to PR13"
 PRDAY14   "Number of days from admission to PR14"
 PRDAY15   "Number of days from admission to PR15"
 PRDAY16   "Number of days from admission to PR16"
 PRDAY17   "Number of days from admission to PR17"
 PRDAY18   "Number of days from admission to PR18"
 PRDAY19   "Number of days from admission to PR19"
 PRDAY20   "Number of days from admission to PR20"
 PRDAY21   "Number of days from admission to PR21"
 PSTATE    "Patient State postal code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRMNTH2   "Month of procedure 2"
 PRMNTH3   "Month of procedure 3"
 PRMNTH4   "Month of procedure 4"
 PRMNTH5   "Month of procedure 5"
 PRMNTH6   "Month of procedure 6"
 PRMNTH7   "Month of procedure 7"
 PRMNTH8   "Month of procedure 8"
 PRMNTH9   "Month of procedure 9"
 PRMNTH10  "Month of procedure 10"
 PRMNTH11  "Month of procedure 11"
 PRMNTH12  "Month of procedure 12"
 PRMNTH13  "Month of procedure 13"
 PRMNTH14  "Month of procedure 14"
 PRMNTH15  "Month of procedure 15"
 PRMNTH16  "Month of procedure 16"
 PRMNTH17  "Month of procedure 17"
 PRMNTH18  "Month of procedure 18"
 PRMNTH19  "Month of procedure 19"
 PRMNTH20  "Month of procedure 20"
 PRMNTH21  "Month of procedure 21"
 PRYEAR1   "Year of procedure 1"
 PRYEAR2   "Year of procedure 2"
 PRYEAR3   "Year of procedure 3"
 PRYEAR4   "Year of procedure 4"
 PRYEAR5   "Year of procedure 5"
 PRYEAR6   "Year of procedure 6"
 PRYEAR7   "Year of procedure 7"
 PRYEAR8   "Year of procedure 8"
 PRYEAR9   "Year of procedure 9"
 PRYEAR10  "Year of procedure 10"
 PRYEAR11  "Year of procedure 11"
 PRYEAR12  "Year of procedure 12"
 PRYEAR13  "Year of procedure 13"
 PRYEAR14  "Year of procedure 14"
 PRYEAR15  "Year of procedure 15"
 PRYEAR16  "Year of procedure 16"
 PRYEAR17  "Year of procedure 17"
 PRYEAR18  "Year of procedure 18"
 PRYEAR19  "Year of procedure 19"
 PRYEAR20  "Year of procedure 20"
 PRYEAR21  "Year of procedure 21" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASCHED
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DNR
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD1
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD2
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD3
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD4
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD5
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD6
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD7
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD8
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD9
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD10
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD11
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD12
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD13
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD14
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD15
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD16
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD17
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD18
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD19
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD20
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD21
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD22
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD23
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD24
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD25
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'CA_SID_2003_CORE.SAV' /COMPRESSED.
