/*******************************************************************
* Creation Date: 05/01/2018   
*   UT_SID_2015q4_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'UT_SID_2015q4_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 I10_BODYSYSTEM1                 1-   2
 I10_BODYSYSTEM2                 3-   4
 I10_BODYSYSTEM3                 5-   6
 I10_BODYSYSTEM4                 7-   8
 I10_BODYSYSTEM5                 9-  10
 I10_BODYSYSTEM6                11-  12
 I10_BODYSYSTEM7                13-  14
 I10_BODYSYSTEM8                15-  16
 I10_BODYSYSTEM9                17-  18
 I10_BODYSYSTEM10               19-  20
 I10_BODYSYSTEM11               21-  22
 I10_BODYSYSTEM12               23-  24
 I10_BODYSYSTEM13               25-  26
 I10_BODYSYSTEM14               27-  28
 I10_BODYSYSTEM15               29-  30
 I10_BODYSYSTEM16               31-  32
 I10_BODYSYSTEM17               33-  34
 I10_BODYSYSTEM18               35-  36
 I10_BODYSYSTEM19               37-  38
 I10_BODYSYSTEM20               39-  40
 I10_BODYSYSTEM21               41-  42
 I10_CHRON1                     43-  44
 I10_CHRON2                     45-  46
 I10_CHRON3                     47-  48
 I10_CHRON4                     49-  50
 I10_CHRON5                     51-  52
 I10_CHRON6                     53-  54
 I10_CHRON7                     55-  56
 I10_CHRON8                     57-  58
 I10_CHRON9                     59-  60
 I10_CHRON10                    61-  62
 I10_CHRON11                    63-  64
 I10_CHRON12                    65-  66
 I10_CHRON13                    67-  68
 I10_CHRON14                    69-  70
 I10_CHRON15                    71-  72
 I10_CHRON16                    73-  74
 I10_CHRON17                    75-  76
 I10_CHRON18                    77-  78
 I10_CHRON19                    79-  80
 I10_CHRON20                    81-  82
 I10_CHRON21                    83-  84
 I10_DXMCCS1                    85-  95 (A)
 I10_DXMCCS2                    96- 106 (A)
 I10_DXMCCS3                   107- 117 (A)
 I10_DXMCCS4                   118- 128 (A)
 I10_DXMCCS5                   129- 139 (A)
 I10_DXMCCS6                   140- 150 (A)
 I10_DXMCCS7                   151- 161 (A)
 I10_DXMCCS8                   162- 172 (A)
 I10_DXMCCS9                   173- 183 (A)
 I10_DXMCCS10                  184- 194 (A)
 I10_DXMCCS11                  195- 205 (A)
 I10_DXMCCS12                  206- 216 (A)
 I10_DXMCCS13                  217- 227 (A)
 I10_DXMCCS14                  228- 238 (A)
 I10_DXMCCS15                  239- 249 (A)
 I10_DXMCCS16                  250- 260 (A)
 I10_DXMCCS17                  261- 271 (A)
 I10_DXMCCS18                  272- 282 (A)
 I10_DXMCCS19                  283- 293 (A)
 I10_DXMCCS20                  294- 304 (A)
 I10_DXMCCS21                  305- 315 (A)
 I10_ECauseMCCS1               316- 326 (A)
 I10_ECauseMCCS2               327- 337 (A)
 I10_ECauseMCCS3               338- 348 (A)
 I10_ECauseMCCS4               349- 359 (A)
 I10_ECauseMCCS5               360- 370 (A)
 I10_ECauseMCCS6               371- 381 (A)
 I10_ECauseMCCS7               382- 392 (A)
 I10_ECauseMCCS8               393- 403 (A)
 I10_ECauseMCCS9               404- 414 (A)
 I10_ECauseMCCS10              415- 425 (A)
 I10_INJURY                    426- 427
 I10_MULTINJURY                428- 429
 I10_PCLASS1                   430- 431
 I10_PCLASS2                   432- 433
 I10_PCLASS3                   434- 435
 I10_PCLASS4                   436- 437
 I10_PCLASS5                   438- 439
 I10_PCLASS6                   440- 441
 I10_PRMCCS1                   442- 449 (A)
 I10_PRMCCS2                   450- 457 (A)
 I10_PRMCCS3                   458- 465 (A)
 I10_PRMCCS4                   466- 473 (A)
 I10_PRMCCS5                   474- 481 (A)
 I10_PRMCCS6                   482- 489 (A)
 I10_U_BLOOD                   490- 491
 I10_U_CATH                    492- 493
 I10_U_CTSCAN                  494- 495
 I10_U_EKG                     496- 497
 I10_U_MHSA                    498- 499
 I10_U_MRT                     500- 501
 I10_U_PACEMAKER               502- 503
 I10_U_PHYTHERAPY              504- 505
 I10_U_RADTHERAPY              506- 507
 I10_U_STRESS                  508- 509
 KEY                           510- 524
 U_CCU                         525- 526
 U_CHESTXRAY                   527- 528
 U_DIALYSIS                    529- 530
 U_ECHO                        531- 532
 U_ED                          533- 534
 U_EEG                         535- 536
 U_EPO                         537- 538
 U_ICU                         539- 540
 U_LITHOTRIPSY                 541- 542
 U_NEWBN2L                     543- 544
 U_NEWBN3L                     545- 546
 U_NEWBN4L                     547- 548
 U_NUCMED                      549- 550
 U_OBSERVATION                 551- 552
 U_OCCTHERAPY                  553- 554
 U_ORGANACQ                    555- 556
 U_OTHIMPLANTS                 557- 558
 U_RESPTHERAPY                 559- 560
 U_SPEECHTHERAPY               561- 562
 U_ULTRASOUND                  563- 564.


***  Specify write formats  ***.
FORMATS
 I10_BODYSYSTEM1              (F3.0) /
 I10_BODYSYSTEM2              (F3.0) /
 I10_BODYSYSTEM3              (F3.0) /
 I10_BODYSYSTEM4              (F3.0) /
 I10_BODYSYSTEM5              (F3.0) /
 I10_BODYSYSTEM6              (F3.0) /
 I10_BODYSYSTEM7              (F3.0) /
 I10_BODYSYSTEM8              (F3.0) /
 I10_BODYSYSTEM9              (F3.0) /
 I10_BODYSYSTEM10             (F3.0) /
 I10_BODYSYSTEM11             (F3.0) /
 I10_BODYSYSTEM12             (F3.0) /
 I10_BODYSYSTEM13             (F3.0) /
 I10_BODYSYSTEM14             (F3.0) /
 I10_BODYSYSTEM15             (F3.0) /
 I10_BODYSYSTEM16             (F3.0) /
 I10_BODYSYSTEM17             (F3.0) /
 I10_BODYSYSTEM18             (F3.0) /
 I10_BODYSYSTEM19             (F3.0) /
 I10_BODYSYSTEM20             (F3.0) /
 I10_BODYSYSTEM21             (F3.0) /
 I10_CHRON1                   (F3.0) /
 I10_CHRON2                   (F3.0) /
 I10_CHRON3                   (F3.0) /
 I10_CHRON4                   (F3.0) /
 I10_CHRON5                   (F3.0) /
 I10_CHRON6                   (F3.0) /
 I10_CHRON7                   (F3.0) /
 I10_CHRON8                   (F3.0) /
 I10_CHRON9                   (F3.0) /
 I10_CHRON10                  (F3.0) /
 I10_CHRON11                  (F3.0) /
 I10_CHRON12                  (F3.0) /
 I10_CHRON13                  (F3.0) /
 I10_CHRON14                  (F3.0) /
 I10_CHRON15                  (F3.0) /
 I10_CHRON16                  (F3.0) /
 I10_CHRON17                  (F3.0) /
 I10_CHRON18                  (F3.0) /
 I10_CHRON19                  (F3.0) /
 I10_CHRON20                  (F3.0) /
 I10_CHRON21                  (F3.0) /
 I10_INJURY                   (F3.0) /
 I10_MULTINJURY               (F3.0) /
 I10_PCLASS1                  (F3.0) /
 I10_PCLASS2                  (F3.0) /
 I10_PCLASS3                  (F3.0) /
 I10_PCLASS4                  (F3.0) /
 I10_PCLASS5                  (F3.0) /
 I10_PCLASS6                  (F3.0) /
 I10_U_BLOOD                  (F3.0) /
 I10_U_CATH                   (F3.0) /
 I10_U_CTSCAN                 (F3.0) /
 I10_U_EKG                    (F3.0) /
 I10_U_MHSA                   (F3.0) /
 I10_U_MRT                    (F3.0) /
 I10_U_PACEMAKER              (F3.0) /
 I10_U_PHYTHERAPY             (F3.0) /
 I10_U_RADTHERAPY             (F3.0) /
 I10_U_STRESS                 (F3.0) /
 KEY                          (F8.0) /
 U_CCU                        (F3.0) /
 U_CHESTXRAY                  (F3.0) /
 U_DIALYSIS                   (F3.0) /
 U_ECHO                       (F3.0) /
 U_ED                         (F3.0) /
 U_EEG                        (F3.0) /
 U_EPO                        (F3.0) /
 U_ICU                        (F3.0) /
 U_LITHOTRIPSY                (F3.0) /
 U_NEWBN2L                    (F3.0) /
 U_NEWBN3L                    (F3.0) /
 U_NEWBN4L                    (F3.0) /
 U_NUCMED                     (F3.0) /
 U_OBSERVATION                (F3.0) /
 U_OCCTHERAPY                 (F3.0) /
 U_ORGANACQ                   (F3.0) /
 U_OTHIMPLANTS                (F3.0) /
 U_RESPTHERAPY                (F3.0) /
 U_SPEECHTHERAPY              (F3.0) /
 U_ULTRASOUND                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 I10_BODYSYSTEM1              "ICD-10-CM Body system 1"
 I10_BODYSYSTEM2              "ICD-10-CM Body system 2"
 I10_BODYSYSTEM3              "ICD-10-CM Body system 3"
 I10_BODYSYSTEM4              "ICD-10-CM Body system 4"
 I10_BODYSYSTEM5              "ICD-10-CM Body system 5"
 I10_BODYSYSTEM6              "ICD-10-CM Body system 6"
 I10_BODYSYSTEM7              "ICD-10-CM Body system 7"
 I10_BODYSYSTEM8              "ICD-10-CM Body system 8"
 I10_BODYSYSTEM9              "ICD-10-CM Body system 9"
 I10_BODYSYSTEM10             "ICD-10-CM Body system 10"
 I10_BODYSYSTEM11             "ICD-10-CM Body system 11"
 I10_BODYSYSTEM12             "ICD-10-CM Body system 12"
 I10_BODYSYSTEM13             "ICD-10-CM Body system 13"
 I10_BODYSYSTEM14             "ICD-10-CM Body system 14"
 I10_BODYSYSTEM15             "ICD-10-CM Body system 15"
 I10_BODYSYSTEM16             "ICD-10-CM Body system 16"
 I10_BODYSYSTEM17             "ICD-10-CM Body system 17"
 I10_BODYSYSTEM18             "ICD-10-CM Body system 18"
 I10_BODYSYSTEM19             "ICD-10-CM Body system 19"
 I10_BODYSYSTEM20             "ICD-10-CM Body system 20"
 I10_BODYSYSTEM21             "ICD-10-CM Body system 21"
 I10_CHRON1                   "ICD-10-CM Chronic condition indicator 1"
 I10_CHRON2                   "ICD-10-CM Chronic condition indicator 2"
 I10_CHRON3                   "ICD-10-CM Chronic condition indicator 3"
 I10_CHRON4                   "ICD-10-CM Chronic condition indicator 4"
 I10_CHRON5                   "ICD-10-CM Chronic condition indicator 5"
 I10_CHRON6                   "ICD-10-CM Chronic condition indicator 6"
 I10_CHRON7                   "ICD-10-CM Chronic condition indicator 7"
 I10_CHRON8                   "ICD-10-CM Chronic condition indicator 8"
 I10_CHRON9                   "ICD-10-CM Chronic condition indicator 9"
 I10_CHRON10                  "ICD-10-CM Chronic condition indicator 10"
 I10_CHRON11                  "ICD-10-CM Chronic condition indicator 11"
 I10_CHRON12                  "ICD-10-CM Chronic condition indicator 12"
 I10_CHRON13                  "ICD-10-CM Chronic condition indicator 13"
 I10_CHRON14                  "ICD-10-CM Chronic condition indicator 14"
 I10_CHRON15                  "ICD-10-CM Chronic condition indicator 15"
 I10_CHRON16                  "ICD-10-CM Chronic condition indicator 16"
 I10_CHRON17                  "ICD-10-CM Chronic condition indicator 17"
 I10_CHRON18                  "ICD-10-CM Chronic condition indicator 18"
 I10_CHRON19                  "ICD-10-CM Chronic condition indicator 19"
 I10_CHRON20                  "ICD-10-CM Chronic condition indicator 20"
 I10_CHRON21                  "ICD-10-CM Chronic condition indicator 21"
 I10_DXMCCS1                  "ICD-10-CM Multi-Level CCS:  Diagnosis 1"
 I10_DXMCCS2                  "ICD-10-CM Multi-Level CCS:  Diagnosis 2"
 I10_DXMCCS3                  "ICD-10-CM Multi-Level CCS:  Diagnosis 3"
 I10_DXMCCS4                  "ICD-10-CM Multi-Level CCS:  Diagnosis 4"
 I10_DXMCCS5                  "ICD-10-CM Multi-Level CCS:  Diagnosis 5"
 I10_DXMCCS6                  "ICD-10-CM Multi-Level CCS:  Diagnosis 6"
 I10_DXMCCS7                  "ICD-10-CM Multi-Level CCS:  Diagnosis 7"
 I10_DXMCCS8                  "ICD-10-CM Multi-Level CCS:  Diagnosis 8"
 I10_DXMCCS9                  "ICD-10-CM Multi-Level CCS:  Diagnosis 9"
 I10_DXMCCS10                 "ICD-10-CM Multi-Level CCS:  Diagnosis 10"
 I10_DXMCCS11                 "ICD-10-CM Multi-Level CCS:  Diagnosis 11"
 I10_DXMCCS12                 "ICD-10-CM Multi-Level CCS:  Diagnosis 12"
 I10_DXMCCS13                 "ICD-10-CM Multi-Level CCS:  Diagnosis 13"
 I10_DXMCCS14                 "ICD-10-CM Multi-Level CCS:  Diagnosis 14"
 I10_DXMCCS15                 "ICD-10-CM Multi-Level CCS:  Diagnosis 15"
 I10_DXMCCS16                 "ICD-10-CM Multi-Level CCS:  Diagnosis 16"
 I10_DXMCCS17                 "ICD-10-CM Multi-Level CCS:  Diagnosis 17"
 I10_DXMCCS18                 "ICD-10-CM Multi-Level CCS:  Diagnosis 18"
 I10_DXMCCS19                 "ICD-10-CM Multi-Level CCS:  Diagnosis 19"
 I10_DXMCCS20                 "ICD-10-CM Multi-Level CCS:  Diagnosis 20"
 I10_DXMCCS21                 "ICD-10-CM Multi-Level CCS:  Diagnosis 21"
 I10_ECauseMCCS1              "ICD-10-CM Multi-Level CCS:  E Cause 1"
 I10_ECauseMCCS2              "ICD-10-CM Multi-Level CCS:  E Cause 2"
 I10_ECauseMCCS3              "ICD-10-CM Multi-Level CCS:  E Cause 3"
 I10_ECauseMCCS4              "ICD-10-CM Multi-Level CCS:  E Cause 4"
 I10_ECauseMCCS5              "ICD-10-CM Multi-Level CCS:  E Cause 5"
 I10_ECauseMCCS6              "ICD-10-CM Multi-Level CCS:  E Cause 6"
 I10_ECauseMCCS7              "ICD-10-CM Multi-Level CCS:  E Cause 7"
 I10_ECauseMCCS8              "ICD-10-CM Multi-Level CCS:  E Cause 8"
 I10_ECauseMCCS9              "ICD-10-CM Multi-Level CCS:  E Cause 9"
 I10_ECauseMCCS10             "ICD-10-CM Multi-Level CCS:  E Cause 10"
 I10_INJURY
 "ICD-10-CM Injury diagnosis reported on record (1:I10_DX1 is an injury; 2:I10_DX2+ is an injury; 0:No injury)"
 I10_MULTINJURY               "ICD-10-CM More than one injury diagnosis reported on record"
 I10_PCLASS1                  "ICD-10-PCS Procedure class 1"
 I10_PCLASS2                  "ICD-10-PCS Procedure class 2"
 I10_PCLASS3                  "ICD-10-PCS Procedure class 3"
 I10_PCLASS4                  "ICD-10-PCS Procedure class 4"
 I10_PCLASS5                  "ICD-10-PCS Procedure class 5"
 I10_PCLASS6                  "ICD-10-PCS Procedure class 6"
 I10_PRMCCS1                  "ICD-10-PCS Multi-Level CCS:  Procedure 1"
 I10_PRMCCS2                  "ICD-10-PCS Multi-Level CCS:  Procedure 2"
 I10_PRMCCS3                  "ICD-10-PCS Multi-Level CCS:  Procedure 3"
 I10_PRMCCS4                  "ICD-10-PCS Multi-Level CCS:  Procedure 4"
 I10_PRMCCS5                  "ICD-10-PCS Multi-Level CCS:  Procedure 5"
 I10_PRMCCS6                  "ICD-10-PCS Multi-Level CCS:  Procedure 6"
 I10_U_BLOOD                  "ICD-10-PCS Utilization Flag: Blood"
 I10_U_CATH                   "ICD-10-PCS Utilization Flag: Cardiac Catheterization Lab"
 I10_U_CTSCAN                 "ICD-10-PCS Utilization Flag: Computed Tomography Scan"
 I10_U_EKG                    "ICD-10-PCS Utilization Flag: Electrocardiogram"
 I10_U_MHSA                   "ICD-10-PCS Utilization Flag: Mental Health and Substance Abuse"
 I10_U_MRT                    "ICD-10-PCS Utilization Flag: Magnetic Resonance Technology"
 I10_U_PACEMAKER              "ICD-10-PCS Utilization Flag: Pacemaker"
 I10_U_PHYTHERAPY             "ICD-10-PCS Utilization Flag: Physical Therapy"
 I10_U_RADTHERAPY             "ICD-10-PCS Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 I10_U_STRESS                 "ICD-10-PCS Utilization Flag: Cardiac Stress Test"
 KEY                          "HCUP record identifier"
 U_CCU                        "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY                  "Utilization Flag: Chest X-Ray"
 U_DIALYSIS                   "Utilization Flag: Renal Dialysis"
 U_ECHO                       "Utilization Flag: Echocardiology"
 U_ED                         "Utilization Flag: Emergency Room"
 U_EEG                        "Utilization Flag: Electroencephalogram"
 U_EPO                        "Utilization Flag: EPO"
 U_ICU                        "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY                "Utilization Flag: Lithotripsy"
 U_NEWBN2L                    "Utilization Flag: Nursery Level II"
 U_NEWBN3L                    "Utilization Flag: Nursery Level III"
 U_NEWBN4L                    "Utilization Flag: Nursery Level IV"
 U_NUCMED                     "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION                "Utilization Flag: Observation Room"
 U_OCCTHERAPY                 "Utilization Flag: Occupational Therapy"
 U_ORGANACQ                   "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS                "Utilization Flag: Other Implants"
 U_RESPTHERAPY                "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY              "Utilization Flag: Speech - Language Pathology"
 U_ULTRASOUND                 "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE I10_BODYSYSTEM1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM10
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM11
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM12
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM13
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM14
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM15
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM16
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM17
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM18
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM19
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM20
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM21
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON21
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'UT_SID_2015q4_DX_PR_GRPS.SAV' /COMPRESSED.
