/*******************************************************************
* Creation Date: 09/06/2017   
*   OR_SID_2015q1q3_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'OR_SID_2015q1q3_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 BODYSYSTEM1                     1-   2
 BODYSYSTEM2                     3-   4
 BODYSYSTEM3                     5-   6
 BODYSYSTEM4                     7-   8
 BODYSYSTEM5                     9-  10
 BODYSYSTEM6                    11-  12
 BODYSYSTEM7                    13-  14
 BODYSYSTEM8                    15-  16
 BODYSYSTEM9                    17-  18
 BODYSYSTEM10                   19-  20
 BODYSYSTEM11                   21-  22
 BODYSYSTEM12                   23-  24
 BODYSYSTEM13                   25-  26
 BODYSYSTEM14                   27-  28
 BODYSYSTEM15                   29-  30
 BODYSYSTEM16                   31-  32
 BODYSYSTEM17                   33-  34
 BODYSYSTEM18                   35-  36
 BODYSYSTEM19                   37-  38
 BODYSYSTEM20                   39-  40
 BODYSYSTEM21                   41-  42
 BODYSYSTEM22                   43-  44
 BODYSYSTEM23                   45-  46
 BODYSYSTEM24                   47-  48
 BODYSYSTEM25                   49-  50
 BODYSYSTEM26                   51-  52
 BODYSYSTEM27                   53-  54
 BODYSYSTEM28                   55-  56
 BODYSYSTEM29                   57-  58
 BODYSYSTEM30                   59-  60
 BODYSYSTEM31                   61-  62
 BODYSYSTEM32                   63-  64
 CHRON1                         65-  66
 CHRON2                         67-  68
 CHRON3                         69-  70
 CHRON4                         71-  72
 CHRON5                         73-  74
 CHRON6                         75-  76
 CHRON7                         77-  78
 CHRON8                         79-  80
 CHRON9                         81-  82
 CHRON10                        83-  84
 CHRON11                        85-  86
 CHRON12                        87-  88
 CHRON13                        89-  90
 CHRON14                        91-  92
 CHRON15                        93-  94
 CHRON16                        95-  96
 CHRON17                        97-  98
 CHRON18                        99- 100
 CHRON19                       101- 102
 CHRON20                       103- 104
 CHRON21                       105- 106
 CHRON22                       107- 108
 CHRON23                       109- 110
 CHRON24                       111- 112
 CHRON25                       113- 114
 CHRON26                       115- 116
 CHRON27                       117- 118
 CHRON28                       119- 120
 CHRON29                       121- 122
 CHRON30                       123- 124
 CHRON31                       125- 126
 CHRON32                       127- 128
 DXMCCS1                       129- 139 (A)
 DXMCCS2                       140- 150 (A)
 DXMCCS3                       151- 161 (A)
 DXMCCS4                       162- 172 (A)
 DXMCCS5                       173- 183 (A)
 DXMCCS6                       184- 194 (A)
 DXMCCS7                       195- 205 (A)
 DXMCCS8                       206- 216 (A)
 DXMCCS9                       217- 227 (A)
 DXMCCS10                      228- 238 (A)
 DXMCCS11                      239- 249 (A)
 DXMCCS12                      250- 260 (A)
 DXMCCS13                      261- 271 (A)
 DXMCCS14                      272- 282 (A)
 DXMCCS15                      283- 293 (A)
 DXMCCS16                      294- 304 (A)
 DXMCCS17                      305- 315 (A)
 DXMCCS18                      316- 326 (A)
 DXMCCS19                      327- 337 (A)
 DXMCCS20                      338- 348 (A)
 DXMCCS21                      349- 359 (A)
 DXMCCS22                      360- 370 (A)
 DXMCCS23                      371- 381 (A)
 DXMCCS24                      382- 392 (A)
 DXMCCS25                      393- 403 (A)
 DXMCCS26                      404- 414 (A)
 DXMCCS27                      415- 425 (A)
 DXMCCS28                      426- 436 (A)
 DXMCCS29                      437- 447 (A)
 DXMCCS30                      448- 458 (A)
 DXMCCS31                      459- 469 (A)
 DXMCCS32                      470- 480 (A)
 E_MCCS1                       481- 491 (A)
 E_MCCS2                       492- 502 (A)
 E_MCCS3                       503- 513 (A)
 E_MCCS4                       514- 524 (A)
 E_MCCS5                       525- 535 (A)
 E_MCCS6                       536- 546 (A)
 E_MCCS7                       547- 557 (A)
 E_MCCS8                       558- 568 (A)
 INJURY                        569- 570
 INJURY_CUT                    571- 572
 INJURY_DROWN                  573- 574
 INJURY_FALL                   575- 576
 INJURY_FIRE                   577- 578
 INJURY_FIREARM                579- 580
 INJURY_MACHINERY              581- 582
 INJURY_MVT                    583- 584
 INJURY_NATURE                 585- 586
 INJURY_POISON                 587- 588
 INJURY_STRUCK                 589- 590
 INJURY_SUFFOCATION            591- 592
 INTENT_ASSAULT                593- 594
 INTENT_SELF_HARM              595- 596
 INTENT_UNINTENTIONAL          597- 598
 KEY                           599- 613
 MULTINJURY                    614- 615
 PCLASS1                       616- 617
 PCLASS2                       618- 619
 PCLASS3                       620- 621
 PCLASS4                       622- 623
 PCLASS5                       624- 625
 PCLASS6                       626- 627
 PCLASS7                       628- 629
 PCLASS8                       630- 631
 PCLASS9                       632- 633
 PCLASS10                      634- 635
 PCLASS11                      636- 637
 PCLASS12                      638- 639
 PCLASS13                      640- 641
 PCLASS14                      642- 643
 PCLASS15                      644- 645
 PCLASS16                      646- 647
 PCLASS17                      648- 649
 PCLASS18                      650- 651
 PCLASS19                      652- 653
 PCLASS20                      654- 655
 PCLASS21                      656- 657
 PCLASS22                      658- 659
 PCLASS23                      660- 661
 PCLASS24                      662- 663
 PCLASS25                      664- 665
 PCLASS26                      666- 667
 PCLASS27                      668- 669
 PCLASS28                      670- 671
 PCLASS29                      672- 673
 PCLASS30                      674- 675
 PCLASS31                      676- 677
 PCLASS32                      678- 679
 PRMCCS1                       680- 687 (A)
 PRMCCS2                       688- 695 (A)
 PRMCCS3                       696- 703 (A)
 PRMCCS4                       704- 711 (A)
 PRMCCS5                       712- 719 (A)
 PRMCCS6                       720- 727 (A)
 PRMCCS7                       728- 735 (A)
 PRMCCS8                       736- 743 (A)
 PRMCCS9                       744- 751 (A)
 PRMCCS10                      752- 759 (A)
 PRMCCS11                      760- 767 (A)
 PRMCCS12                      768- 775 (A)
 PRMCCS13                      776- 783 (A)
 PRMCCS14                      784- 791 (A)
 PRMCCS15                      792- 799 (A)
 PRMCCS16                      800- 807 (A)
 PRMCCS17                      808- 815 (A)
 PRMCCS18                      816- 823 (A)
 PRMCCS19                      824- 831 (A)
 PRMCCS20                      832- 839 (A)
 PRMCCS21                      840- 847 (A)
 PRMCCS22                      848- 855 (A)
 PRMCCS23                      856- 863 (A)
 PRMCCS24                      864- 871 (A)
 PRMCCS25                      872- 879 (A)
 PRMCCS26                      880- 887 (A)
 PRMCCS27                      888- 895 (A)
 PRMCCS28                      896- 903 (A)
 PRMCCS29                      904- 911 (A)
 PRMCCS30                      912- 919 (A)
 PRMCCS31                      920- 927 (A)
 PRMCCS32                      928- 935 (A)
 U_BLOOD                       936- 937
 U_CATH                        938- 939
 U_CCU                         940- 941
 U_CHESTXRAY                   942- 943
 U_CTSCAN                      944- 945
 U_DIALYSIS                    946- 947
 U_ECHO                        948- 949
 U_ED                          950- 951
 U_EEG                         952- 953
 U_EKG                         954- 955
 U_EPO                         956- 957
 U_ICU                         958- 959
 U_LITHOTRIPSY                 960- 961
 U_MHSA                        962- 963
 U_MRT                         964- 965
 U_NEWBN2L                     966- 967
 U_NEWBN3L                     968- 969
 U_NEWBN4L                     970- 971
 U_NUCMED                      972- 973
 U_OBSERVATION                 974- 975
 U_OCCTHERAPY                  976- 977
 U_ORGANACQ                    978- 979
 U_OTHIMPLANTS                 980- 981
 U_PACEMAKER                   982- 983
 U_PHYTHERAPY                  984- 985
 U_RADTHERAPY                  986- 987
 U_RESPTHERAPY                 988- 989
 U_SPEECHTHERAPY               990- 991
 U_STRESS                      992- 993
 U_ULTRASOUND                  994- 995.


***  Specify write formats  ***.
FORMATS
 BODYSYSTEM1                  (F3.0) /
 BODYSYSTEM2                  (F3.0) /
 BODYSYSTEM3                  (F3.0) /
 BODYSYSTEM4                  (F3.0) /
 BODYSYSTEM5                  (F3.0) /
 BODYSYSTEM6                  (F3.0) /
 BODYSYSTEM7                  (F3.0) /
 BODYSYSTEM8                  (F3.0) /
 BODYSYSTEM9                  (F3.0) /
 BODYSYSTEM10                 (F3.0) /
 BODYSYSTEM11                 (F3.0) /
 BODYSYSTEM12                 (F3.0) /
 BODYSYSTEM13                 (F3.0) /
 BODYSYSTEM14                 (F3.0) /
 BODYSYSTEM15                 (F3.0) /
 BODYSYSTEM16                 (F3.0) /
 BODYSYSTEM17                 (F3.0) /
 BODYSYSTEM18                 (F3.0) /
 BODYSYSTEM19                 (F3.0) /
 BODYSYSTEM20                 (F3.0) /
 BODYSYSTEM21                 (F3.0) /
 BODYSYSTEM22                 (F3.0) /
 BODYSYSTEM23                 (F3.0) /
 BODYSYSTEM24                 (F3.0) /
 BODYSYSTEM25                 (F3.0) /
 BODYSYSTEM26                 (F3.0) /
 BODYSYSTEM27                 (F3.0) /
 BODYSYSTEM28                 (F3.0) /
 BODYSYSTEM29                 (F3.0) /
 BODYSYSTEM30                 (F3.0) /
 BODYSYSTEM31                 (F3.0) /
 BODYSYSTEM32                 (F3.0) /
 CHRON1                       (F3.0) /
 CHRON2                       (F3.0) /
 CHRON3                       (F3.0) /
 CHRON4                       (F3.0) /
 CHRON5                       (F3.0) /
 CHRON6                       (F3.0) /
 CHRON7                       (F3.0) /
 CHRON8                       (F3.0) /
 CHRON9                       (F3.0) /
 CHRON10                      (F3.0) /
 CHRON11                      (F3.0) /
 CHRON12                      (F3.0) /
 CHRON13                      (F3.0) /
 CHRON14                      (F3.0) /
 CHRON15                      (F3.0) /
 CHRON16                      (F3.0) /
 CHRON17                      (F3.0) /
 CHRON18                      (F3.0) /
 CHRON19                      (F3.0) /
 CHRON20                      (F3.0) /
 CHRON21                      (F3.0) /
 CHRON22                      (F3.0) /
 CHRON23                      (F3.0) /
 CHRON24                      (F3.0) /
 CHRON25                      (F3.0) /
 CHRON26                      (F3.0) /
 CHRON27                      (F3.0) /
 CHRON28                      (F3.0) /
 CHRON29                      (F3.0) /
 CHRON30                      (F3.0) /
 CHRON31                      (F3.0) /
 CHRON32                      (F3.0) /
 INJURY                       (F3.0) /
 INJURY_CUT                   (F3.0) /
 INJURY_DROWN                 (F3.0) /
 INJURY_FALL                  (F3.0) /
 INJURY_FIRE                  (F3.0) /
 INJURY_FIREARM               (F3.0) /
 INJURY_MACHINERY             (F3.0) /
 INJURY_MVT                   (F3.0) /
 INJURY_NATURE                (F3.0) /
 INJURY_POISON                (F3.0) /
 INJURY_STRUCK                (F3.0) /
 INJURY_SUFFOCATION           (F3.0) /
 INTENT_ASSAULT               (F3.0) /
 INTENT_SELF_HARM             (F3.0) /
 INTENT_UNINTENTIONAL         (F3.0) /
 KEY                          (F8.0) /
 MULTINJURY                   (F3.0) /
 PCLASS1                      (F3.0) /
 PCLASS2                      (F3.0) /
 PCLASS3                      (F3.0) /
 PCLASS4                      (F3.0) /
 PCLASS5                      (F3.0) /
 PCLASS6                      (F3.0) /
 PCLASS7                      (F3.0) /
 PCLASS8                      (F3.0) /
 PCLASS9                      (F3.0) /
 PCLASS10                     (F3.0) /
 PCLASS11                     (F3.0) /
 PCLASS12                     (F3.0) /
 PCLASS13                     (F3.0) /
 PCLASS14                     (F3.0) /
 PCLASS15                     (F3.0) /
 PCLASS16                     (F3.0) /
 PCLASS17                     (F3.0) /
 PCLASS18                     (F3.0) /
 PCLASS19                     (F3.0) /
 PCLASS20                     (F3.0) /
 PCLASS21                     (F3.0) /
 PCLASS22                     (F3.0) /
 PCLASS23                     (F3.0) /
 PCLASS24                     (F3.0) /
 PCLASS25                     (F3.0) /
 PCLASS26                     (F3.0) /
 PCLASS27                     (F3.0) /
 PCLASS28                     (F3.0) /
 PCLASS29                     (F3.0) /
 PCLASS30                     (F3.0) /
 PCLASS31                     (F3.0) /
 PCLASS32                     (F3.0) /
 U_BLOOD                      (F3.0) /
 U_CATH                       (F3.0) /
 U_CCU                        (F3.0) /
 U_CHESTXRAY                  (F3.0) /
 U_CTSCAN                     (F3.0) /
 U_DIALYSIS                   (F3.0) /
 U_ECHO                       (F3.0) /
 U_ED                         (F3.0) /
 U_EEG                        (F3.0) /
 U_EKG                        (F3.0) /
 U_EPO                        (F3.0) /
 U_ICU                        (F3.0) /
 U_LITHOTRIPSY                (F3.0) /
 U_MHSA                       (F3.0) /
 U_MRT                        (F3.0) /
 U_NEWBN2L                    (F3.0) /
 U_NEWBN3L                    (F3.0) /
 U_NEWBN4L                    (F3.0) /
 U_NUCMED                     (F3.0) /
 U_OBSERVATION                (F3.0) /
 U_OCCTHERAPY                 (F3.0) /
 U_ORGANACQ                   (F3.0) /
 U_OTHIMPLANTS                (F3.0) /
 U_PACEMAKER                  (F3.0) /
 U_PHYTHERAPY                 (F3.0) /
 U_RADTHERAPY                 (F3.0) /
 U_RESPTHERAPY                (F3.0) /
 U_SPEECHTHERAPY              (F3.0) /
 U_STRESS                     (F3.0) /
 U_ULTRASOUND                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 BODYSYSTEM1                  "Body system 1"
 BODYSYSTEM2                  "Body system 2"
 BODYSYSTEM3                  "Body system 3"
 BODYSYSTEM4                  "Body system 4"
 BODYSYSTEM5                  "Body system 5"
 BODYSYSTEM6                  "Body system 6"
 BODYSYSTEM7                  "Body system 7"
 BODYSYSTEM8                  "Body system 8"
 BODYSYSTEM9                  "Body system 9"
 BODYSYSTEM10                 "Body system 10"
 BODYSYSTEM11                 "Body system 11"
 BODYSYSTEM12                 "Body system 12"
 BODYSYSTEM13                 "Body system 13"
 BODYSYSTEM14                 "Body system 14"
 BODYSYSTEM15                 "Body system 15"
 BODYSYSTEM16                 "Body system 16"
 BODYSYSTEM17                 "Body system 17"
 BODYSYSTEM18                 "Body system 18"
 BODYSYSTEM19                 "Body system 19"
 BODYSYSTEM20                 "Body system 20"
 BODYSYSTEM21                 "Body system 21"
 BODYSYSTEM22                 "Body system 22"
 BODYSYSTEM23                 "Body system 23"
 BODYSYSTEM24                 "Body system 24"
 BODYSYSTEM25                 "Body system 25"
 BODYSYSTEM26                 "Body system 26"
 BODYSYSTEM27                 "Body system 27"
 BODYSYSTEM28                 "Body system 28"
 BODYSYSTEM29                 "Body system 29"
 BODYSYSTEM30                 "Body system 30"
 BODYSYSTEM31                 "Body system 31"
 BODYSYSTEM32                 "Body system 32"
 CHRON1                       "Chronic condition indicator 1"
 CHRON2                       "Chronic condition indicator 2"
 CHRON3                       "Chronic condition indicator 3"
 CHRON4                       "Chronic condition indicator 4"
 CHRON5                       "Chronic condition indicator 5"
 CHRON6                       "Chronic condition indicator 6"
 CHRON7                       "Chronic condition indicator 7"
 CHRON8                       "Chronic condition indicator 8"
 CHRON9                       "Chronic condition indicator 9"
 CHRON10                      "Chronic condition indicator 10"
 CHRON11                      "Chronic condition indicator 11"
 CHRON12                      "Chronic condition indicator 12"
 CHRON13                      "Chronic condition indicator 13"
 CHRON14                      "Chronic condition indicator 14"
 CHRON15                      "Chronic condition indicator 15"
 CHRON16                      "Chronic condition indicator 16"
 CHRON17                      "Chronic condition indicator 17"
 CHRON18                      "Chronic condition indicator 18"
 CHRON19                      "Chronic condition indicator 19"
 CHRON20                      "Chronic condition indicator 20"
 CHRON21                      "Chronic condition indicator 21"
 CHRON22                      "Chronic condition indicator 22"
 CHRON23                      "Chronic condition indicator 23"
 CHRON24                      "Chronic condition indicator 24"
 CHRON25                      "Chronic condition indicator 25"
 CHRON26                      "Chronic condition indicator 26"
 CHRON27                      "Chronic condition indicator 27"
 CHRON28                      "Chronic condition indicator 28"
 CHRON29                      "Chronic condition indicator 29"
 CHRON30                      "Chronic condition indicator 30"
 CHRON31                      "Chronic condition indicator 31"
 CHRON32                      "Chronic condition indicator 32"
 DXMCCS1                      "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                      "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                      "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                      "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                      "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                      "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                      "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                      "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                      "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                     "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                     "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                     "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                     "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                     "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                     "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16                     "Multi-Level CCS:  Diagnosis 16"
 DXMCCS17                     "Multi-Level CCS:  Diagnosis 17"
 DXMCCS18                     "Multi-Level CCS:  Diagnosis 18"
 DXMCCS19                     "Multi-Level CCS:  Diagnosis 19"
 DXMCCS20                     "Multi-Level CCS:  Diagnosis 20"
 DXMCCS21                     "Multi-Level CCS:  Diagnosis 21"
 DXMCCS22                     "Multi-Level CCS:  Diagnosis 22"
 DXMCCS23                     "Multi-Level CCS:  Diagnosis 23"
 DXMCCS24                     "Multi-Level CCS:  Diagnosis 24"
 DXMCCS25                     "Multi-Level CCS:  Diagnosis 25"
 DXMCCS26                     "Multi-Level CCS:  Diagnosis 26"
 DXMCCS27                     "Multi-Level CCS:  Diagnosis 27"
 DXMCCS28                     "Multi-Level CCS:  Diagnosis 28"
 DXMCCS29                     "Multi-Level CCS:  Diagnosis 29"
 DXMCCS30                     "Multi-Level CCS:  Diagnosis 30"
 DXMCCS31                     "Multi-Level CCS:  Diagnosis 31"
 DXMCCS32                     "Multi-Level CCS:  Diagnosis 32"
 E_MCCS1                      "Multi-Level CCS:  E Code 1"
 E_MCCS2                      "Multi-Level CCS:  E Code 2"
 E_MCCS3                      "Multi-Level CCS:  E Code 3"
 E_MCCS4                      "Multi-Level CCS:  E Code 4"
 E_MCCS5                      "Multi-Level CCS:  E Code 5"
 E_MCCS6                      "Multi-Level CCS:  E Code 6"
 E_MCCS7                      "Multi-Level CCS:  E Code 7"
 E_MCCS8                      "Multi-Level CCS:  E Code 8"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT                   "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN                 "Injury by drowning or submersion (by E codes)"
 INJURY_FALL                  "Injury by falling (by E codes)"
 INJURY_FIRE                  "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM               "Injury by firearm (by E codes)"
 INJURY_MACHINERY             "Injury by machinery (by E codes)"
 INJURY_MVT                   "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE
"Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON                "Injury by poison (by E codes)"
 INJURY_STRUCK                "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION           "Injury by suffocation (by E codes)"
 INTENT_ASSAULT               "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM
"Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL         "Unintentional injury indicated on the record (by E codes)"
 KEY                          "HCUP record identifier"
 MULTINJURY                   "More than one injury diagnosis reported on record"
 PCLASS1                      "Procedure class 1"
 PCLASS2                      "Procedure class 2"
 PCLASS3                      "Procedure class 3"
 PCLASS4                      "Procedure class 4"
 PCLASS5                      "Procedure class 5"
 PCLASS6                      "Procedure class 6"
 PCLASS7                      "Procedure class 7"
 PCLASS8                      "Procedure class 8"
 PCLASS9                      "Procedure class 9"
 PCLASS10                     "Procedure class 10"
 PCLASS11                     "Procedure class 11"
 PCLASS12                     "Procedure class 12"
 PCLASS13                     "Procedure class 13"
 PCLASS14                     "Procedure class 14"
 PCLASS15                     "Procedure class 15"
 PCLASS16                     "Procedure class 16"
 PCLASS17                     "Procedure class 17"
 PCLASS18                     "Procedure class 18"
 PCLASS19                     "Procedure class 19"
 PCLASS20                     "Procedure class 20"
 PCLASS21                     "Procedure class 21"
 PCLASS22                     "Procedure class 22"
 PCLASS23                     "Procedure class 23"
 PCLASS24                     "Procedure class 24"
 PCLASS25                     "Procedure class 25"
 PCLASS26                     "Procedure class 26"
 PCLASS27                     "Procedure class 27"
 PCLASS28                     "Procedure class 28"
 PCLASS29                     "Procedure class 29"
 PCLASS30                     "Procedure class 30"
 PCLASS31                     "Procedure class 31"
 PCLASS32                     "Procedure class 32"
 PRMCCS1                      "Multi-Level CCS:  Procedure 1"
 PRMCCS2                      "Multi-Level CCS:  Procedure 2"
 PRMCCS3                      "Multi-Level CCS:  Procedure 3"
 PRMCCS4                      "Multi-Level CCS:  Procedure 4"
 PRMCCS5                      "Multi-Level CCS:  Procedure 5"
 PRMCCS6                      "Multi-Level CCS:  Procedure 6"
 PRMCCS7                      "Multi-Level CCS:  Procedure 7"
 PRMCCS8                      "Multi-Level CCS:  Procedure 8"
 PRMCCS9                      "Multi-Level CCS:  Procedure 9"
 PRMCCS10                     "Multi-Level CCS:  Procedure 10"
 PRMCCS11                     "Multi-Level CCS:  Procedure 11"
 PRMCCS12                     "Multi-Level CCS:  Procedure 12"
 PRMCCS13                     "Multi-Level CCS:  Procedure 13"
 PRMCCS14                     "Multi-Level CCS:  Procedure 14"
 PRMCCS15                     "Multi-Level CCS:  Procedure 15"
 PRMCCS16                     "Multi-Level CCS:  Procedure 16"
 PRMCCS17                     "Multi-Level CCS:  Procedure 17"
 PRMCCS18                     "Multi-Level CCS:  Procedure 18"
 PRMCCS19                     "Multi-Level CCS:  Procedure 19"
 PRMCCS20                     "Multi-Level CCS:  Procedure 20"
 PRMCCS21                     "Multi-Level CCS:  Procedure 21"
 PRMCCS22                     "Multi-Level CCS:  Procedure 22"
 PRMCCS23                     "Multi-Level CCS:  Procedure 23"
 PRMCCS24                     "Multi-Level CCS:  Procedure 24"
 PRMCCS25                     "Multi-Level CCS:  Procedure 25"
 PRMCCS26                     "Multi-Level CCS:  Procedure 26"
 PRMCCS27                     "Multi-Level CCS:  Procedure 27"
 PRMCCS28                     "Multi-Level CCS:  Procedure 28"
 PRMCCS29                     "Multi-Level CCS:  Procedure 29"
 PRMCCS30                     "Multi-Level CCS:  Procedure 30"
 PRMCCS31                     "Multi-Level CCS:  Procedure 31"
 PRMCCS32                     "Multi-Level CCS:  Procedure 32"
 U_BLOOD                      "Utilization Flag: Blood"
 U_CATH                       "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU                        "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY                  "Utilization Flag: Chest X-Ray"
 U_CTSCAN                     "Utilization Flag: Computed Tomography Scan"
 U_DIALYSIS                   "Utilization Flag: Renal Dialysis"
 U_ECHO                       "Utilization Flag: Echocardiology"
 U_ED                         "Utilization Flag: Emergency Room"
 U_EEG                        "Utilization Flag: Electroencephalogram"
 U_EKG                        "Utilization Flag: Electrocardiogram"
 U_EPO                        "Utilization Flag: EPO"
 U_ICU                        "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY                "Utilization Flag: Lithotripsy"
 U_MHSA                       "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT                        "Utilization Flag: Magnetic Resonance Technology"
 U_NEWBN2L                    "Utilization Flag: Nursery Level II"
 U_NEWBN3L                    "Utilization Flag: Nursery Level III"
 U_NEWBN4L                    "Utilization Flag: Nursery Level IV"
 U_NUCMED                     "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION                "Utilization Flag: Observation Room"
 U_OCCTHERAPY                 "Utilization Flag: Occupational Therapy"
 U_ORGANACQ                   "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS                "Utilization Flag: Other Implants"
 U_PACEMAKER                  "Utilization Flag: Pacemaker"
 U_PHYTHERAPY                 "Utilization Flag: Physical Therapy"
 U_RADTHERAPY
"Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTHERAPY                "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY              "Utilization Flag: Speech - Language Pathology"
 U_STRESS                     "Utilization Flag: Cardiac Stress Test"
 U_ULTRASOUND                 "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE BODYSYSTEM1
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM2
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM3
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM4
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM5
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM6
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM7
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM8
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM9
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM10
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM11
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM12
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM13
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM14
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM15
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM16
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM17
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM18
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM19
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM20
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM21
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM22
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM23
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM24
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM25
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM26
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM27
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM28
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM29
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM30
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM31
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM32
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON32
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS16
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS17
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS18
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS19
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS20
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS21
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS22
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS23
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS24
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS25
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS26
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS27
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS28
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS29
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS30
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS31
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS32
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'OR_SID_2015q1q3_DX_PR_GRPS.SAV' /COMPRESSED.
