/*******************************************************************
*   OR_SID_2007_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'OR_SID_2007_DX_PR_GRPS.ASC' FIXED / 
 CHRON1                     1-   2
 CHRON2                     3-   4
 CHRON3                     5-   6
 CHRON4                     7-   8
 CHRON5                     9-  10
 CHRON6                    11-  12
 CHRON7                    13-  14
 CHRON8                    15-  16
 CHRON9                    17-  18
 CHRONB1                   19-  20
 CHRONB2                   21-  22
 CHRONB3                   23-  24
 CHRONB4                   25-  26
 CHRONB5                   27-  28
 CHRONB6                   29-  30
 CHRONB7                   31-  32
 CHRONB8                   33-  34
 CHRONB9                   35-  36
 DXMCCS1                   37-  47 (A)
 DXMCCS2                   48-  58 (A)
 DXMCCS3                   59-  69 (A)
 DXMCCS4                   70-  80 (A)
 DXMCCS5                   81-  91 (A)
 DXMCCS6                   92- 102 (A)
 DXMCCS7                  103- 113 (A)
 DXMCCS8                  114- 124 (A)
 DXMCCS9                  125- 135 (A)
 E_MCCS1                  136- 146 (A)
 E_MCCS2                  147- 157 (A)
 E_MCCS3                  158- 168 (A)
 E_MCCS4                  169- 179 (A)
 E_MCCS5                  180- 190 (A)
 E_MCCS6                  191- 201 (A)
 E_MCCS7                  202- 212 (A)
 E_MCCS8                  213- 223 (A)
 KEY                      224- 237
 PCLASS1                  238- 239
 PCLASS2                  240- 241
 PCLASS3                  242- 243
 PCLASS4                  244- 245
 PCLASS5                  246- 247
 PCLASS6                  248- 249
 PRMCCS1                  250- 257 (A)
 PRMCCS2                  258- 265 (A)
 PRMCCS3                  266- 273 (A)
 PRMCCS4                  274- 281 (A)
 PRMCCS5                  282- 289 (A)
 PRMCCS6                  290- 297 (A).


***  Specify write formats  ***.
FORMATS
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 KEY                     (F8.0) /
 PCLASS1                 (F3.0) /
 PCLASS2                 (F3.0) /
 PCLASS3                 (F3.0) /
 PCLASS4                 (F3.0) /
 PCLASS5                 (F3.0) /
 PCLASS6                 (F3.0) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1    "Chronic condition indicator 1"
 CHRON2    "Chronic condition indicator 2"
 CHRON3    "Chronic condition indicator 3"
 CHRON4    "Chronic condition indicator 4"
 CHRON5    "Chronic condition indicator 5"
 CHRON6    "Chronic condition indicator 6"
 CHRON7    "Chronic condition indicator 7"
 CHRON8    "Chronic condition indicator 8"
 CHRON9    "Chronic condition indicator 9"
 CHRONB1   "Chronic condition body system 1"
 CHRONB2   "Chronic condition body system 2"
 CHRONB3   "Chronic condition body system 3"
 CHRONB4   "Chronic condition body system 4"
 CHRONB5   "Chronic condition body system 5"
 CHRONB6   "Chronic condition body system 6"
 CHRONB7   "Chronic condition body system 7"
 CHRONB8   "Chronic condition body system 8"
 CHRONB9   "Chronic condition body system 9"
 DXMCCS1   "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2   "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3   "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4   "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5   "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6   "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7   "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8   "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9   "Multi-Level CCS:  Diagnosis 9"
 E_MCCS1   "Multi-Level CCS:  E Code 1"
 E_MCCS2   "Multi-Level CCS:  E Code 2"
 E_MCCS3   "Multi-Level CCS:  E Code 3"
 E_MCCS4   "Multi-Level CCS:  E Code 4"
 E_MCCS5   "Multi-Level CCS:  E Code 5"
 E_MCCS6   "Multi-Level CCS:  E Code 6"
 E_MCCS7   "Multi-Level CCS:  E Code 7"
 E_MCCS8   "Multi-Level CCS:  E Code 8"
 KEY       "HCUP record identifier"
 PCLASS1   "Procedure class 1"
 PCLASS2   "Procedure class 2"
 PCLASS3   "Procedure class 3"
 PCLASS4   "Procedure class 4"
 PCLASS5   "Procedure class 5"
 PCLASS6   "Procedure class 6"
 PRMCCS1   "Multi-Level CCS:  Procedure 1"
 PRMCCS2   "Multi-Level CCS:  Procedure 2"
 PRMCCS3   "Multi-Level CCS:  Procedure 3"
 PRMCCS4   "Multi-Level CCS:  Procedure 4"
 PRMCCS5   "Multi-Level CCS:  Procedure 5"
 PRMCCS6   "Multi-Level CCS:  Procedure 6" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'OR_SID_2007_DX_PR_GRPS.SAV' /COMPRESSED.
