/*******************************************************************
*   NM_SID_2011_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NM_SID_2011_DX_PR_GRPS.ASC' FIXED / 
 CHRON1                     1-   2
 CHRON2                     3-   4
 CHRON3                     5-   6
 CHRON4                     7-   8
 CHRON5                     9-  10
 CHRON6                    11-  12
 CHRON7                    13-  14
 CHRON8                    15-  16
 CHRON9                    17-  18
 CHRON10                   19-  20
 CHRON11                   21-  22
 CHRON12                   23-  24
 CHRON13                   25-  26
 CHRON14                   27-  28
 CHRON15                   29-  30
 CHRON16                   31-  32
 CHRON17                   33-  34
 CHRON18                   35-  36
 CHRONB1                   37-  38
 CHRONB2                   39-  40
 CHRONB3                   41-  42
 CHRONB4                   43-  44
 CHRONB5                   45-  46
 CHRONB6                   47-  48
 CHRONB7                   49-  50
 CHRONB8                   51-  52
 CHRONB9                   53-  54
 CHRONB10                  55-  56
 CHRONB11                  57-  58
 CHRONB12                  59-  60
 CHRONB13                  61-  62
 CHRONB14                  63-  64
 CHRONB15                  65-  66
 CHRONB16                  67-  68
 CHRONB17                  69-  70
 CHRONB18                  71-  72
 DXMCCS1                   73-  83 (A)
 DXMCCS2                   84-  94 (A)
 DXMCCS3                   95- 105 (A)
 DXMCCS4                  106- 116 (A)
 DXMCCS5                  117- 127 (A)
 DXMCCS6                  128- 138 (A)
 DXMCCS7                  139- 149 (A)
 DXMCCS8                  150- 160 (A)
 DXMCCS9                  161- 171 (A)
 DXMCCS10                 172- 182 (A)
 DXMCCS11                 183- 193 (A)
 DXMCCS12                 194- 204 (A)
 DXMCCS13                 205- 215 (A)
 DXMCCS14                 216- 226 (A)
 DXMCCS15                 227- 237 (A)
 DXMCCS16                 238- 248 (A)
 DXMCCS17                 249- 259 (A)
 DXMCCS18                 260- 270 (A)
 E_MCCS1                  271- 281 (A)
 E_MCCS2                  282- 292 (A)
 E_MCCS3                  293- 303 (A)
 E_MCCS4                  304- 314 (A)
 E_MCCS5                  315- 325 (A)
 E_MCCS6                  326- 336 (A)
 E_MCCS7                  337- 347 (A)
 E_MCCS8                  348- 358 (A)
 INJURY                   359- 360
 INJURY_CUT               361- 362
 INJURY_DROWN             363- 364
 INJURY_FALL              365- 366
 INJURY_FIRE              367- 368
 INJURY_FIREARM           369- 370
 INJURY_MACHINERY         371- 372
 INJURY_MVT               373- 374
 INJURY_NATURE            375- 376
 INJURY_POISON            377- 378
 INJURY_STRUCK            379- 380
 INJURY_SUFFOCATION       381- 382
 INTENT_ASSAULT           383- 384
 INTENT_SELF_HARM         385- 386
 INTENT_UNINTENTIONAL     387- 388
 KEY                      389- 403
 MULTINJURY               404- 405
 PCLASS1                  406- 407
 PCLASS2                  408- 409
 PCLASS3                  410- 411
 PCLASS4                  412- 413
 PCLASS5                  414- 415
 PCLASS6                  416- 417
 PRMCCS1                  418- 425 (A)
 PRMCCS2                  426- 433 (A)
 PRMCCS3                  434- 441 (A)
 PRMCCS4                  442- 449 (A)
 PRMCCS5                  450- 457 (A)
 PRMCCS6                  458- 465 (A).


***  Specify write formats  ***.
FORMATS
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRON10                 (F3.0) /
 CHRON11                 (F3.0) /
 CHRON12                 (F3.0) /
 CHRON13                 (F3.0) /
 CHRON14                 (F3.0) /
 CHRON15                 (F3.0) /
 CHRON16                 (F3.0) /
 CHRON17                 (F3.0) /
 CHRON18                 (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 CHRONB10                (F3.0) /
 CHRONB11                (F3.0) /
 CHRONB12                (F3.0) /
 CHRONB13                (F3.0) /
 CHRONB14                (F3.0) /
 CHRONB15                (F3.0) /
 CHRONB16                (F3.0) /
 CHRONB17                (F3.0) /
 CHRONB18                (F3.0) /
 INJURY                  (F3.0) /
 INJURY_CUT              (F3.0) /
 INJURY_DROWN            (F3.0) /
 INJURY_FALL             (F3.0) /
 INJURY_FIRE             (F3.0) /
 INJURY_FIREARM          (F3.0) /
 INJURY_MACHINERY        (F3.0) /
 INJURY_MVT              (F3.0) /
 INJURY_NATURE           (F3.0) /
 INJURY_POISON           (F3.0) /
 INJURY_STRUCK           (F3.0) /
 INJURY_SUFFOCATION      (F3.0) /
 INTENT_ASSAULT          (F3.0) /
 INTENT_SELF_HARM        (F3.0) /
 INTENT_UNINTENTIONAL    (F3.0) /
 KEY                     (F8.0) /
 MULTINJURY              (F3.0) /
 PCLASS1                 (F3.0) /
 PCLASS2                 (F3.0) /
 PCLASS3                 (F3.0) /
 PCLASS4                 (F3.0) /
 PCLASS5                 (F3.0) /
 PCLASS6                 (F3.0) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1                  "Chronic condition indicator 1"
 CHRON2                  "Chronic condition indicator 2"
 CHRON3                  "Chronic condition indicator 3"
 CHRON4                  "Chronic condition indicator 4"
 CHRON5                  "Chronic condition indicator 5"
 CHRON6                  "Chronic condition indicator 6"
 CHRON7                  "Chronic condition indicator 7"
 CHRON8                  "Chronic condition indicator 8"
 CHRON9                  "Chronic condition indicator 9"
 CHRON10                 "Chronic condition indicator 10"
 CHRON11                 "Chronic condition indicator 11"
 CHRON12                 "Chronic condition indicator 12"
 CHRON13                 "Chronic condition indicator 13"
 CHRON14                 "Chronic condition indicator 14"
 CHRON15                 "Chronic condition indicator 15"
 CHRON16                 "Chronic condition indicator 16"
 CHRON17                 "Chronic condition indicator 17"
 CHRON18                 "Chronic condition indicator 18"
 CHRONB1                 "Chronic condition body system 1"
 CHRONB2                 "Chronic condition body system 2"
 CHRONB3                 "Chronic condition body system 3"
 CHRONB4                 "Chronic condition body system 4"
 CHRONB5                 "Chronic condition body system 5"
 CHRONB6                 "Chronic condition body system 6"
 CHRONB7                 "Chronic condition body system 7"
 CHRONB8                 "Chronic condition body system 8"
 CHRONB9                 "Chronic condition body system 9"
 CHRONB10                "Chronic condition body system 10"
 CHRONB11                "Chronic condition body system 11"
 CHRONB12                "Chronic condition body system 12"
 CHRONB13                "Chronic condition body system 13"
 CHRONB14                "Chronic condition body system 14"
 CHRONB15                "Chronic condition body system 15"
 CHRONB16                "Chronic condition body system 16"
 CHRONB17                "Chronic condition body system 17"
 CHRONB18                "Chronic condition body system 18"
 DXMCCS1                 "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                 "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                 "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                 "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                 "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                 "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                 "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                 "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                 "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16                "Multi-Level CCS:  Diagnosis 16"
 DXMCCS17                "Multi-Level CCS:  Diagnosis 17"
 DXMCCS18                "Multi-Level CCS:  Diagnosis 18"
 E_MCCS1                 "Multi-Level CCS:  E Code 1"
 E_MCCS2                 "Multi-Level CCS:  E Code 2"
 E_MCCS3                 "Multi-Level CCS:  E Code 3"
 E_MCCS4                 "Multi-Level CCS:  E Code 4"
 E_MCCS5                 "Multi-Level CCS:  E Code 5"
 E_MCCS6                 "Multi-Level CCS:  E Code 6"
 E_MCCS7                 "Multi-Level CCS:  E Code 7"
 E_MCCS8                 "Multi-Level CCS:  E Code 8"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT              "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN            "Injury by drowning or submersion (by E codes)"
 INJURY_FALL             "Injury by falling (by E codes)"
 INJURY_FIRE             "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM          "Injury by firearm (by E codes)"
 INJURY_MACHINERY        "Injury by machinery (by E codes)"
 INJURY_MVT              "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE           "Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON           "Injury by poison (by E codes)"
 INJURY_STRUCK           "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION      "Injury by suffocation (by E codes)"
 INTENT_ASSAULT          "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM
"Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL    "Unintentional injury indicated on the record (by E codes)"
 KEY                     "HCUP record identifier"
 MULTINJURY              "More than one injury diagnosis reported on record"
 PCLASS1                 "Procedure class 1"
 PCLASS2                 "Procedure class 2"
 PCLASS3                 "Procedure class 3"
 PCLASS4                 "Procedure class 4"
 PCLASS5                 "Procedure class 5"
 PCLASS6                 "Procedure class 6"
 PRMCCS1                 "Multi-Level CCS:  Procedure 1"
 PRMCCS2                 "Multi-Level CCS:  Procedure 2"
 PRMCCS3                 "Multi-Level CCS:  Procedure 3"
 PRMCCS4                 "Multi-Level CCS:  Procedure 4"
 PRMCCS5                 "Multi-Level CCS:  Procedure 5"
 PRMCCS6                 "Multi-Level CCS:  Procedure 6" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB18
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'NM_SID_2011_DX_PR_GRPS.SAV' /COMPRESSED.
