/*******************************************************************
* Creation Date: 04/27/2018   
*   MS_SID_2015q4_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MS_SID_2015q4_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AHOUR                          10-  13
 AMONTH                         14-  15
 ATYPE                          16-  17
 AWEEKEND                       18-  19
 DaysToEvent                    20-  25
 DHOUR                          26-  29
 DIED                           30-  31
 DISP_X                         32-  35 (A)
 DISPUB04                       36-  37
 DISPUNIFORM                    38-  39
 DMONTH                         40-  41
 DQTR                           42-  43
 DRG                            44-  46
 DRG_NoPOA                      47-  49
 DRG32                          50-  52
 DRGVER                         53-  54
 DSHOSPID                       55-  71 (A)
 DXPOA1                         72     (A)
 DXPOA2                         73     (A)
 DXPOA3                         74     (A)
 DXPOA4                         75     (A)
 DXPOA5                         76     (A)
 DXPOA6                         77     (A)
 DXPOA7                         78     (A)
 DXPOA8                         79     (A)
 DXPOA9                         80     (A)
 DXPOA10                        81     (A)
 DXPOA11                        82     (A)
 DXPOA12                        83     (A)
 DXPOA13                        84     (A)
 DXPOA14                        85     (A)
 DXPOA15                        86     (A)
 DXPOA16                        87     (A)
 DXPOA17                        88     (A)
 DXPOA18                        89     (A)
 DXPOA19                        90     (A)
 DXPOA20                        91     (A)
 DXPOA21                        92     (A)
 DXPOA22                        93     (A)
 DXPOA23                        94     (A)
 DXPOA24                        95     (A)
 DXPOA25                        96     (A)
 DXPOA26                        97     (A)
 DXPOA27                        98     (A)
 DXPOA28                        99     (A)
 DXPOA29                       100     (A)
 DXPOA30                       101     (A)
 DXPOA31                       102     (A)
 DXPOA32                       103     (A)
 DXPOA33                       104     (A)
 DXPOA34                       105     (A)
 DXPOA35                       106     (A)
 DXPOA36                       107     (A)
 DXPOA37                       108     (A)
 DXPOA38                       109     (A)
 DXPOA39                       110     (A)
 DXPOA40                       111     (A)
 DXPOA41                       112     (A)
 DXPOA42                       113     (A)
 DXPOA43                       114     (A)
 DXPOA44                       115     (A)
 DXPOA45                       116     (A)
 DXPOA46                       117     (A)
 DXPOA47                       118     (A)
 DXPOA48                       119     (A)
 DXVER                         120- 122
 E_POA1                        123     (A)
 E_POA2                        124     (A)
 E_POA3                        125     (A)
 E_POA4                        126     (A)
 E_POA5                        127     (A)
 E_POA6                        128     (A)
 FEMALE                        129- 130
 HCUP_ED                       131- 132
 HCUP_OS                       133- 134
 HISPANIC                      135- 136
 HISPANIC_X                    137     (A)
 HospitalUnit                  138- 139
 HOSPST                        140- 141 (A)
 I10_DX_Admitting              142- 148 (A)
 I10_DX1                       149- 155 (A)
 I10_DX2                       156- 162 (A)
 I10_DX3                       163- 169 (A)
 I10_DX4                       170- 176 (A)
 I10_DX5                       177- 183 (A)
 I10_DX6                       184- 190 (A)
 I10_DX7                       191- 197 (A)
 I10_DX8                       198- 204 (A)
 I10_DX9                       205- 211 (A)
 I10_DX10                      212- 218 (A)
 I10_DX11                      219- 225 (A)
 I10_DX12                      226- 232 (A)
 I10_DX13                      233- 239 (A)
 I10_DX14                      240- 246 (A)
 I10_DX15                      247- 253 (A)
 I10_DX16                      254- 260 (A)
 I10_DX17                      261- 267 (A)
 I10_DX18                      268- 274 (A)
 I10_DX19                      275- 281 (A)
 I10_DX20                      282- 288 (A)
 I10_DX21                      289- 295 (A)
 I10_DX22                      296- 302 (A)
 I10_DX23                      303- 309 (A)
 I10_DX24                      310- 316 (A)
 I10_DX25                      317- 323 (A)
 I10_DX26                      324- 330 (A)
 I10_DX27                      331- 337 (A)
 I10_DX28                      338- 344 (A)
 I10_DX29                      345- 351 (A)
 I10_DX30                      352- 358 (A)
 I10_DX31                      359- 365 (A)
 I10_DX32                      366- 372 (A)
 I10_DX33                      373- 379 (A)
 I10_DX34                      380- 386 (A)
 I10_DX35                      387- 393 (A)
 I10_DX36                      394- 400 (A)
 I10_DX37                      401- 407 (A)
 I10_DX38                      408- 414 (A)
 I10_DX39                      415- 421 (A)
 I10_DX40                      422- 428 (A)
 I10_DX41                      429- 435 (A)
 I10_DX42                      436- 442 (A)
 I10_DX43                      443- 449 (A)
 I10_DX44                      450- 456 (A)
 I10_DX45                      457- 463 (A)
 I10_DX46                      464- 470 (A)
 I10_DX47                      471- 477 (A)
 I10_DX48                      478- 484 (A)
 I10_DXCCS1                    485- 488
 I10_DXCCS2                    489- 492
 I10_DXCCS3                    493- 496
 I10_DXCCS4                    497- 500
 I10_DXCCS5                    501- 504
 I10_DXCCS6                    505- 508
 I10_DXCCS7                    509- 512
 I10_DXCCS8                    513- 516
 I10_DXCCS9                    517- 520
 I10_DXCCS10                   521- 524
 I10_DXCCS11                   525- 528
 I10_DXCCS12                   529- 532
 I10_DXCCS13                   533- 536
 I10_DXCCS14                   537- 540
 I10_DXCCS15                   541- 544
 I10_DXCCS16                   545- 548
 I10_DXCCS17                   549- 552
 I10_DXCCS18                   553- 556
 I10_DXCCS19                   557- 560
 I10_DXCCS20                   561- 564
 I10_DXCCS21                   565- 568
 I10_DXCCS22                   569- 572
 I10_DXCCS23                   573- 576
 I10_DXCCS24                   577- 580
 I10_DXCCS25                   581- 584
 I10_DXCCS26                   585- 588
 I10_DXCCS27                   589- 592
 I10_DXCCS28                   593- 596
 I10_DXCCS29                   597- 600
 I10_DXCCS30                   601- 604
 I10_DXCCS31                   605- 608
 I10_DXCCS32                   609- 612
 I10_DXCCS33                   613- 616
 I10_DXCCS34                   617- 620
 I10_DXCCS35                   621- 624
 I10_DXCCS36                   625- 628
 I10_DXCCS37                   629- 632
 I10_DXCCS38                   633- 636
 I10_DXCCS39                   637- 640
 I10_DXCCS40                   641- 644
 I10_DXCCS41                   645- 648
 I10_DXCCS42                   649- 652
 I10_DXCCS43                   653- 656
 I10_DXCCS44                   657- 660
 I10_DXCCS45                   661- 664
 I10_DXCCS46                   665- 668
 I10_DXCCS47                   669- 672
 I10_DXCCS48                   673- 676
 I10_ECAUSE1                   677- 683 (A)
 I10_ECAUSE2                   684- 690 (A)
 I10_ECAUSE3                   691- 697 (A)
 I10_ECAUSE4                   698- 704 (A)
 I10_ECAUSE5                   705- 711 (A)
 I10_ECAUSE6                   712- 718 (A)
 I10_ECauseCCS1                719- 722
 I10_ECauseCCS2                723- 726
 I10_ECauseCCS3                727- 730
 I10_ECauseCCS4                731- 734
 I10_ECauseCCS5                735- 738
 I10_ECauseCCS6                739- 742
 I10_HOSPBRTH                  743- 745
 I10_NCHRONIC                  746- 748
 I10_NDX                       749- 751
 I10_NECAUSE                   752- 753
 I10_NEOMAT                    754- 755
 I10_NPR                       756- 758
 I10_ORPROC                    759- 760
 I10_PR1                       761- 767 (A)
 I10_PR2                       768- 774 (A)
 I10_PR3                       775- 781 (A)
 I10_PR4                       782- 788 (A)
 I10_PR5                       789- 795 (A)
 I10_PR6                       796- 802 (A)
 I10_PR7                       803- 809 (A)
 I10_PR8                       810- 816 (A)
 I10_PR9                       817- 823 (A)
 I10_PR10                      824- 830 (A)
 I10_PR11                      831- 837 (A)
 I10_PR12                      838- 844 (A)
 I10_PR13                      845- 851 (A)
 I10_PR14                      852- 858 (A)
 I10_PR15                      859- 865 (A)
 I10_PR16                      866- 872 (A)
 I10_PR17                      873- 879 (A)
 I10_PR18                      880- 886 (A)
 I10_PR19                      887- 893 (A)
 I10_PR20                      894- 900 (A)
 I10_PR21                      901- 907 (A)
 I10_PR22                      908- 914 (A)
 I10_PR23                      915- 921 (A)
 I10_PR24                      922- 928 (A)
 I10_PR25                      929- 935 (A)
 I10_PR26                      936- 942 (A)
 I10_PR27                      943- 949 (A)
 I10_PR28                      950- 956 (A)
 I10_PR29                      957- 963 (A)
 I10_PR30                      964- 970 (A)
 I10_PRCCS1                    971- 973
 I10_PRCCS2                    974- 976
 I10_PRCCS3                    977- 979
 I10_PRCCS4                    980- 982
 I10_PRCCS5                    983- 985
 I10_PRCCS6                    986- 988
 I10_PRCCS7                    989- 991
 I10_PRCCS8                    992- 994
 I10_PRCCS9                    995- 997
 I10_PRCCS10                   998-1000
 I10_PRCCS11                  1001-1003
 I10_PRCCS12                  1004-1006
 I10_PRCCS13                  1007-1009
 I10_PRCCS14                  1010-1012
 I10_PRCCS15                  1013-1015
 I10_PRCCS16                  1016-1018
 I10_PRCCS17                  1019-1021
 I10_PRCCS18                  1022-1024
 I10_PRCCS19                  1025-1027
 I10_PRCCS20                  1028-1030
 I10_PRCCS21                  1031-1033
 I10_PRCCS22                  1034-1036
 I10_PRCCS23                  1037-1039
 I10_PRCCS24                  1040-1042
 I10_PRCCS25                  1043-1045
 I10_PRCCS26                  1046-1048
 I10_PRCCS27                  1049-1051
 I10_PRCCS28                  1052-1054
 I10_PRCCS29                  1055-1057
 I10_PRCCS30                  1058-1060
 I10_PROCTYPE                 1061-1063
 I10_SERVICELINE              1064-1065
 KEY                          1066-1080
 LOS                          1081-1085
 LOS_X                        1086-1091
 MDC                          1092-1093
 MDC_NoPOA                    1094-1095
 MDC32                        1096-1097
 MDNUM1_R                     1098-1106
 MDNUM2_R                     1107-1115
 MDNUM3_R                     1116-1124
 MEDINCSTQ                    1125-1126
 P7EDSRC_X                    1127-1128 (A)
 PAY1                         1129-1130
 PAY1_X                       1131-1135 (A)
 PAY2                         1136-1137
 PAY2_X                       1138-1142 (A)
 PAY3                         1143-1144
 PAY3_X                       1145-1149 (A)
 PL_CBSA                      1150-1152
 PL_NCHS                      1153-1154
 PL_RUCC                      1155-1156
 PL_UIC                       1157-1158
 PL_UR_CAT4                   1159-1160
 POA_Disch_Edit1              1161-1162
 POA_Disch_Edit2              1163-1164
 POA_Hosp_Edit1               1165-1166
 POA_Hosp_Edit2               1167-1168
 POA_Hosp_Edit3               1169-1170
 POA_Hosp_Edit3_Value         1171-1178
 PointOfOrigin_X              1179     (A)
 PointOfOriginUB04            1180     (A)
 PRDAY1                       1181-1185
 PRDAY2                       1186-1190
 PRDAY3                       1191-1195
 PRDAY4                       1196-1200
 PRDAY5                       1201-1205
 PRDAY6                       1206-1210
 PRDAY7                       1211-1215
 PRDAY8                       1216-1220
 PRDAY9                       1221-1225
 PRDAY10                      1226-1230
 PRDAY11                      1231-1235
 PRDAY12                      1236-1240
 PRDAY13                      1241-1245
 PRDAY14                      1246-1250
 PRDAY15                      1251-1255
 PRDAY16                      1256-1260
 PRDAY17                      1261-1265
 PRDAY18                      1266-1270
 PRDAY19                      1271-1275
 PRDAY20                      1276-1280
 PRDAY21                      1281-1285
 PRDAY22                      1286-1290
 PRDAY23                      1291-1295
 PRDAY24                      1296-1300
 PRDAY25                      1301-1305
 PRDAY26                      1306-1310
 PRDAY27                      1311-1315
 PRDAY28                      1316-1320
 PRDAY29                      1321-1325
 PRDAY30                      1326-1330
 PRVER                        1331-1333
 PSTATE                       1334-1335 (A)
 PSTCO2                       1336-1340
 RACE                         1341-1342
 RACE_X                       1343     (A)
 TOTCHG                       1344-1353
 TOTCHG_X                     1354-1368
 TRAN_IN                      1369-1370
 TRAN_OUT                     1371-1372
 VisitLink                    1373-1381
 YEAR                         1382-1385
 ZIP                          1386-1390 (A)
 ZIP3                         1391-1393 (A)
 ZIPINC_QRTL                  1394-1396
 AYEAR                        1397-1400
 BMONTH                       1401-1402
 BYEAR                        1403-1406
 PRMONTH1                     1407-1408
 PRMONTH2                     1409-1410
 PRMONTH3                     1411-1412
 PRMONTH4                     1413-1414
 PRMONTH5                     1415-1416
 PRMONTH6                     1417-1418
 PRMONTH7                     1419-1420
 PRMONTH8                     1421-1422
 PRMONTH9                     1423-1424
 PRMONTH10                    1425-1426
 PRMONTH11                    1427-1428
 PRMONTH12                    1429-1430
 PRMONTH13                    1431-1432
 PRMONTH14                    1433-1434
 PRMONTH15                    1435-1436
 PRMONTH16                    1437-1438
 PRMONTH17                    1439-1440
 PRMONTH18                    1441-1442
 PRMONTH19                    1443-1444
 PRMONTH20                    1445-1446
 PRMONTH21                    1447-1448
 PRMONTH22                    1449-1450
 PRMONTH23                    1451-1452
 PRMONTH24                    1453-1454
 PRMONTH25                    1455-1456
 PRMONTH26                    1457-1458
 PRMONTH27                    1459-1460
 PRMONTH28                    1461-1462
 PRMONTH29                    1463-1464
 PRMONTH30                    1465-1466
 PRYEAR1                      1467-1470
 PRYEAR2                      1471-1474
 PRYEAR3                      1475-1478
 PRYEAR4                      1479-1482
 PRYEAR5                      1483-1486
 PRYEAR6                      1487-1490
 PRYEAR7                      1491-1494
 PRYEAR8                      1495-1498
 PRYEAR9                      1499-1502
 PRYEAR10                     1503-1506
 PRYEAR11                     1507-1510
 PRYEAR12                     1511-1514
 PRYEAR13                     1515-1518
 PRYEAR14                     1519-1522
 PRYEAR15                     1523-1526
 PRYEAR16                     1527-1530
 PRYEAR17                     1531-1534
 PRYEAR18                     1535-1538
 PRYEAR19                     1539-1542
 PRYEAR20                     1543-1546
 PRYEAR21                     1547-1550
 PRYEAR22                     1551-1554
 PRYEAR23                     1555-1558
 PRYEAR24                     1559-1562
 PRYEAR25                     1563-1566
 PRYEAR26                     1567-1570
 PRYEAR27                     1571-1574
 PRYEAR28                     1575-1578
 PRYEAR29                     1579-1582
 PRYEAR30                     1583-1586.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 DaysToEvent                  (F8.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRG32                        (F3.0) /
 DRGVER                       (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 HospitalUnit                 (F3.0) /
 I10_DXCCS1                   (F4.0) /
 I10_DXCCS2                   (F4.0) /
 I10_DXCCS3                   (F4.0) /
 I10_DXCCS4                   (F4.0) /
 I10_DXCCS5                   (F4.0) /
 I10_DXCCS6                   (F4.0) /
 I10_DXCCS7                   (F4.0) /
 I10_DXCCS8                   (F4.0) /
 I10_DXCCS9                   (F4.0) /
 I10_DXCCS10                  (F4.0) /
 I10_DXCCS11                  (F4.0) /
 I10_DXCCS12                  (F4.0) /
 I10_DXCCS13                  (F4.0) /
 I10_DXCCS14                  (F4.0) /
 I10_DXCCS15                  (F4.0) /
 I10_DXCCS16                  (F4.0) /
 I10_DXCCS17                  (F4.0) /
 I10_DXCCS18                  (F4.0) /
 I10_DXCCS19                  (F4.0) /
 I10_DXCCS20                  (F4.0) /
 I10_DXCCS21                  (F4.0) /
 I10_DXCCS22                  (F4.0) /
 I10_DXCCS23                  (F4.0) /
 I10_DXCCS24                  (F4.0) /
 I10_DXCCS25                  (F4.0) /
 I10_DXCCS26                  (F4.0) /
 I10_DXCCS27                  (F4.0) /
 I10_DXCCS28                  (F4.0) /
 I10_DXCCS29                  (F4.0) /
 I10_DXCCS30                  (F4.0) /
 I10_DXCCS31                  (F4.0) /
 I10_DXCCS32                  (F4.0) /
 I10_DXCCS33                  (F4.0) /
 I10_DXCCS34                  (F4.0) /
 I10_DXCCS35                  (F4.0) /
 I10_DXCCS36                  (F4.0) /
 I10_DXCCS37                  (F4.0) /
 I10_DXCCS38                  (F4.0) /
 I10_DXCCS39                  (F4.0) /
 I10_DXCCS40                  (F4.0) /
 I10_DXCCS41                  (F4.0) /
 I10_DXCCS42                  (F4.0) /
 I10_DXCCS43                  (F4.0) /
 I10_DXCCS44                  (F4.0) /
 I10_DXCCS45                  (F4.0) /
 I10_DXCCS46                  (F4.0) /
 I10_DXCCS47                  (F4.0) /
 I10_DXCCS48                  (F4.0) /
 I10_ECauseCCS1               (F3.0) /
 I10_ECauseCCS2               (F3.0) /
 I10_ECauseCCS3               (F3.0) /
 I10_ECauseCCS4               (F3.0) /
 I10_ECauseCCS5               (F3.0) /
 I10_ECauseCCS6               (F3.0) /
 I10_HOSPBRTH                 (F3.0) /
 I10_NCHRONIC                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NECAUSE                  (F3.0) /
 I10_NEOMAT                   (F3.0) /
 I10_NPR                      (F3.0) /
 I10_ORPROC                   (F3.0) /
 I10_PRCCS1                   (F3.0) /
 I10_PRCCS2                   (F3.0) /
 I10_PRCCS3                   (F3.0) /
 I10_PRCCS4                   (F3.0) /
 I10_PRCCS5                   (F3.0) /
 I10_PRCCS6                   (F3.0) /
 I10_PRCCS7                   (F3.0) /
 I10_PRCCS8                   (F3.0) /
 I10_PRCCS9                   (F3.0) /
 I10_PRCCS10                  (F3.0) /
 I10_PRCCS11                  (F3.0) /
 I10_PRCCS12                  (F3.0) /
 I10_PRCCS13                  (F3.0) /
 I10_PRCCS14                  (F3.0) /
 I10_PRCCS15                  (F3.0) /
 I10_PRCCS16                  (F3.0) /
 I10_PRCCS17                  (F3.0) /
 I10_PRCCS18                  (F3.0) /
 I10_PRCCS19                  (F3.0) /
 I10_PRCCS20                  (F3.0) /
 I10_PRCCS21                  (F3.0) /
 I10_PRCCS22                  (F3.0) /
 I10_PRCCS23                  (F3.0) /
 I10_PRCCS24                  (F3.0) /
 I10_PRCCS25                  (F3.0) /
 I10_PRCCS26                  (F3.0) /
 I10_PRCCS27                  (F3.0) /
 I10_PRCCS28                  (F3.0) /
 I10_PRCCS29                  (F3.0) /
 I10_PRCCS30                  (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDC32                        (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRVER                        (F3.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRMONTH26                    (F3.0) /
 PRMONTH27                    (F3.0) /
 PRMONTH28                    (F3.0) /
 PRMONTH29                    (F3.0) /
 PRMONTH30                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) /
 PRYEAR26                     (F3.0) /
 PRYEAR27                     (F3.0) /
 PRYEAR28                     (F3.0) /
 PRYEAR29                     (F3.0) /
 PRYEAR30                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 DaysToEvent                  "Days from 'start date' to admission"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRG32                        "DRG, version 32"
 DRGVER                       "DRG grouper version used on discharge date"
 DSHOSPID                     "Data source hospital identifier"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXVER                        "Diagnosis Version"
 E_POA1                       "E Cause 1, present on admission indicator"
 E_POA2                       "E Cause 2, present on admission indicator"
 E_POA3                       "E Cause 3, present on admission indicator"
 E_POA4                       "E Cause 4, present on admission indicator"
 E_POA5                       "E Cause 5, present on admission indicator"
 E_POA6                       "E Cause 6, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HospitalUnit
"Patient was discharged from a special unit within an acute care hospital (reported by source)"
 HOSPST                       "Hospital state postal code"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DXCCS1                   "ICD-10-CM CCS: diagnosis 1"
 I10_DXCCS2                   "ICD-10-CM CCS: diagnosis 2"
 I10_DXCCS3                   "ICD-10-CM CCS: diagnosis 3"
 I10_DXCCS4                   "ICD-10-CM CCS: diagnosis 4"
 I10_DXCCS5                   "ICD-10-CM CCS: diagnosis 5"
 I10_DXCCS6                   "ICD-10-CM CCS: diagnosis 6"
 I10_DXCCS7                   "ICD-10-CM CCS: diagnosis 7"
 I10_DXCCS8                   "ICD-10-CM CCS: diagnosis 8"
 I10_DXCCS9                   "ICD-10-CM CCS: diagnosis 9"
 I10_DXCCS10                  "ICD-10-CM CCS: diagnosis 10"
 I10_DXCCS11                  "ICD-10-CM CCS: diagnosis 11"
 I10_DXCCS12                  "ICD-10-CM CCS: diagnosis 12"
 I10_DXCCS13                  "ICD-10-CM CCS: diagnosis 13"
 I10_DXCCS14                  "ICD-10-CM CCS: diagnosis 14"
 I10_DXCCS15                  "ICD-10-CM CCS: diagnosis 15"
 I10_DXCCS16                  "ICD-10-CM CCS: diagnosis 16"
 I10_DXCCS17                  "ICD-10-CM CCS: diagnosis 17"
 I10_DXCCS18                  "ICD-10-CM CCS: diagnosis 18"
 I10_DXCCS19                  "ICD-10-CM CCS: diagnosis 19"
 I10_DXCCS20                  "ICD-10-CM CCS: diagnosis 20"
 I10_DXCCS21                  "ICD-10-CM CCS: diagnosis 21"
 I10_DXCCS22                  "ICD-10-CM CCS: diagnosis 22"
 I10_DXCCS23                  "ICD-10-CM CCS: diagnosis 23"
 I10_DXCCS24                  "ICD-10-CM CCS: diagnosis 24"
 I10_DXCCS25                  "ICD-10-CM CCS: diagnosis 25"
 I10_DXCCS26                  "ICD-10-CM CCS: diagnosis 26"
 I10_DXCCS27                  "ICD-10-CM CCS: diagnosis 27"
 I10_DXCCS28                  "ICD-10-CM CCS: diagnosis 28"
 I10_DXCCS29                  "ICD-10-CM CCS: diagnosis 29"
 I10_DXCCS30                  "ICD-10-CM CCS: diagnosis 30"
 I10_DXCCS31                  "ICD-10-CM CCS: diagnosis 31"
 I10_DXCCS32                  "ICD-10-CM CCS: diagnosis 32"
 I10_DXCCS33                  "ICD-10-CM CCS: diagnosis 33"
 I10_DXCCS34                  "ICD-10-CM CCS: diagnosis 34"
 I10_DXCCS35                  "ICD-10-CM CCS: diagnosis 35"
 I10_DXCCS36                  "ICD-10-CM CCS: diagnosis 36"
 I10_DXCCS37                  "ICD-10-CM CCS: diagnosis 37"
 I10_DXCCS38                  "ICD-10-CM CCS: diagnosis 38"
 I10_DXCCS39                  "ICD-10-CM CCS: diagnosis 39"
 I10_DXCCS40                  "ICD-10-CM CCS: diagnosis 40"
 I10_DXCCS41                  "ICD-10-CM CCS: diagnosis 41"
 I10_DXCCS42                  "ICD-10-CM CCS: diagnosis 42"
 I10_DXCCS43                  "ICD-10-CM CCS: diagnosis 43"
 I10_DXCCS44                  "ICD-10-CM CCS: diagnosis 44"
 I10_DXCCS45                  "ICD-10-CM CCS: diagnosis 45"
 I10_DXCCS46                  "ICD-10-CM CCS: diagnosis 46"
 I10_DXCCS47                  "ICD-10-CM CCS: diagnosis 47"
 I10_DXCCS48                  "ICD-10-CM CCS: diagnosis 48"
 I10_ECAUSE1                  "ICD-10-CM E Cause 1"
 I10_ECAUSE2                  "ICD-10-CM E Cause 2"
 I10_ECAUSE3                  "ICD-10-CM E Cause 3"
 I10_ECAUSE4                  "ICD-10-CM E Cause 4"
 I10_ECAUSE5                  "ICD-10-CM E Cause 5"
 I10_ECAUSE6                  "ICD-10-CM E Cause 6"
 I10_ECauseCCS1               "ICD-10-CM CCS: E Cause 1"
 I10_ECauseCCS2               "ICD-10-CM CCS: E Cause 2"
 I10_ECauseCCS3               "ICD-10-CM CCS: E Cause 3"
 I10_ECauseCCS4               "ICD-10-CM CCS: E Cause 4"
 I10_ECauseCCS5               "ICD-10-CM CCS: E Cause 5"
 I10_ECauseCCS6               "ICD-10-CM CCS: E Cause 6"
 I10_HOSPBRTH                 "ICD-10-CM Indicator of birth in this hospital"
 I10_NCHRONIC                 "ICD-10-CM Number of chronic conditions"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NECAUSE                  "ICD-10-CM Number of E Causes on this record"
 I10_NEOMAT                   "ICD-10-CM/PCS Neonatal and/or maternal I10_DX and/or I10_PR"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_ORPROC                   "ICD-10-PCS Major operating room procedure indicator"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PRCCS1                   "ICD-10-PCS CCS: procedure 1"
 I10_PRCCS2                   "ICD-10-PCS CCS: procedure 2"
 I10_PRCCS3                   "ICD-10-PCS CCS: procedure 3"
 I10_PRCCS4                   "ICD-10-PCS CCS: procedure 4"
 I10_PRCCS5                   "ICD-10-PCS CCS: procedure 5"
 I10_PRCCS6                   "ICD-10-PCS CCS: procedure 6"
 I10_PRCCS7                   "ICD-10-PCS CCS: procedure 7"
 I10_PRCCS8                   "ICD-10-PCS CCS: procedure 8"
 I10_PRCCS9                   "ICD-10-PCS CCS: procedure 9"
 I10_PRCCS10                  "ICD-10-PCS CCS: procedure 10"
 I10_PRCCS11                  "ICD-10-PCS CCS: procedure 11"
 I10_PRCCS12                  "ICD-10-PCS CCS: procedure 12"
 I10_PRCCS13                  "ICD-10-PCS CCS: procedure 13"
 I10_PRCCS14                  "ICD-10-PCS CCS: procedure 14"
 I10_PRCCS15                  "ICD-10-PCS CCS: procedure 15"
 I10_PRCCS16                  "ICD-10-PCS CCS: procedure 16"
 I10_PRCCS17                  "ICD-10-PCS CCS: procedure 17"
 I10_PRCCS18                  "ICD-10-PCS CCS: procedure 18"
 I10_PRCCS19                  "ICD-10-PCS CCS: procedure 19"
 I10_PRCCS20                  "ICD-10-PCS CCS: procedure 20"
 I10_PRCCS21                  "ICD-10-PCS CCS: procedure 21"
 I10_PRCCS22                  "ICD-10-PCS CCS: procedure 22"
 I10_PRCCS23                  "ICD-10-PCS CCS: procedure 23"
 I10_PRCCS24                  "ICD-10-PCS CCS: procedure 24"
 I10_PRCCS25                  "ICD-10-PCS CCS: procedure 25"
 I10_PRCCS26                  "ICD-10-PCS CCS: procedure 26"
 I10_PRCCS27                  "ICD-10-PCS CCS: procedure 27"
 I10_PRCCS28                  "ICD-10-PCS CCS: procedure 28"
 I10_PRCCS29                  "ICD-10-PCS CCS: procedure 29"
 I10_PRCCS30                  "ICD-10-PCS CCS: procedure 30"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDC32                        "MDC, version 32"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 P7EDSRC_X                    "Condition Code P7, Direct Inpatient Admission from Emergency Room"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRMONTH26                    "Month of procedure 26"
 PRMONTH27                    "Month of procedure 27"
 PRMONTH28                    "Month of procedure 28"
 PRMONTH29                    "Month of procedure 29"
 PRMONTH30                    "Month of procedure 30"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25"
 PRYEAR26                     "Year of procedure 26"
 PRYEAR27                     "Year of procedure 27"
 PRYEAR28                     "Year of procedure 28"
 PRYEAR29                     "Year of procedure 29"
 PRYEAR30                     "Year of procedure 30" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG32
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE HospitalUnit
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS34
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS35
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS36
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS37
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS38
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS39
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS40
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS41
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS42
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS43
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS44
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS45
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS46
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS47
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS48
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NECAUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC32
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MS_SID_2015q4_CORE.SAV' /COMPRESSED.
