/*******************************************************************
* Creation Date: 07/25/2018   
*   MN_SID_2016_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MN_SID_2016_CORE.ASC' FIXED SKIP=2 / 
 ADRG                            1-   3
 ADRGRISKMORTALITY               4-   5
 ADRGSEV                         6-   7
 AGE                             8-  10
 AGEDAY                         11-  13
 AGEMONTH                       14-  16
 AHOUR                          17-  20
 AMDC                           21-  22
 AMONTH                         23-  24
 ATYPE                          25-  26
 AWEEKEND                       27-  28
 BILLTYPE                       29-  32 (A)
 DHOUR                          33-  36
 DIED                           37-  38
 DISP_X                         39-  40 (A)
 DISPUB04                       41-  42
 DISPUNIFORM                    43-  44
 DMONTH                         45-  46
 DQTR                           47-  48
 DRG                            49-  51
 DRG_NoPOA                      52-  54
 DRGVER                         55-  56
 DXPOA1                         57     (A)
 DXPOA2                         58     (A)
 DXPOA3                         59     (A)
 DXPOA4                         60     (A)
 DXPOA5                         61     (A)
 DXPOA6                         62     (A)
 DXPOA7                         63     (A)
 DXPOA8                         64     (A)
 DXPOA9                         65     (A)
 DXPOA10                        66     (A)
 DXPOA11                        67     (A)
 DXPOA12                        68     (A)
 DXPOA13                        69     (A)
 DXPOA14                        70     (A)
 DXPOA15                        71     (A)
 DXPOA16                        72     (A)
 DXPOA17                        73     (A)
 DXPOA18                        74     (A)
 DXPOA19                        75     (A)
 DXPOA20                        76     (A)
 DXPOA21                        77     (A)
 DXPOA22                        78     (A)
 DXPOA23                        79     (A)
 DXPOA24                        80     (A)
 DXPOA25                        81     (A)
 DXPOA26                        82     (A)
 DXPOA27                        83     (A)
 DXPOA28                        84     (A)
 DXPOA29                        85     (A)
 DXPOA30                        86     (A)
 DXPOA31                        87     (A)
 DXPOA32                        88     (A)
 DXPOA33                        89     (A)
 DXPOA34                        90     (A)
 DXPOA35                        91     (A)
 DXPOA36                        92     (A)
 DXPOA37                        93     (A)
 DXPOA38                        94     (A)
 DXPOA39                        95     (A)
 DXPOA40                        96     (A)
 DXPOA41                        97     (A)
 DXPOA42                        98     (A)
 DXPOA43                        99     (A)
 DXPOA44                       100     (A)
 DXPOA45                       101     (A)
 DXPOA46                       102     (A)
 DXPOA47                       103     (A)
 DXPOA48                       104     (A)
 DXPOA49                       105     (A)
 DXPOA50                       106     (A)
 DXVER                         107- 109
 E_POA1                        110     (A)
 E_POA2                        111     (A)
 E_POA3                        112     (A)
 E_POA4                        113     (A)
 E_POA5                        114     (A)
 E_POA6                        115     (A)
 E_POA7                        116     (A)
 E_POA8                        117     (A)
 FEMALE                        118- 119
 HCUP_ED                       120- 121
 HCUP_OS                       122- 123
 HISPANIC                      124- 125
 HISPANIC_X                    126- 145 (A)
 HOSPST                        146- 147 (A)
 I10_DX_Admitting              148- 154 (A)
 I10_DX1                       155- 161 (A)
 I10_DX2                       162- 168 (A)
 I10_DX3                       169- 175 (A)
 I10_DX4                       176- 182 (A)
 I10_DX5                       183- 189 (A)
 I10_DX6                       190- 196 (A)
 I10_DX7                       197- 203 (A)
 I10_DX8                       204- 210 (A)
 I10_DX9                       211- 217 (A)
 I10_DX10                      218- 224 (A)
 I10_DX11                      225- 231 (A)
 I10_DX12                      232- 238 (A)
 I10_DX13                      239- 245 (A)
 I10_DX14                      246- 252 (A)
 I10_DX15                      253- 259 (A)
 I10_DX16                      260- 266 (A)
 I10_DX17                      267- 273 (A)
 I10_DX18                      274- 280 (A)
 I10_DX19                      281- 287 (A)
 I10_DX20                      288- 294 (A)
 I10_DX21                      295- 301 (A)
 I10_DX22                      302- 308 (A)
 I10_DX23                      309- 315 (A)
 I10_DX24                      316- 322 (A)
 I10_DX25                      323- 329 (A)
 I10_DX26                      330- 336 (A)
 I10_DX27                      337- 343 (A)
 I10_DX28                      344- 350 (A)
 I10_DX29                      351- 357 (A)
 I10_DX30                      358- 364 (A)
 I10_DX31                      365- 371 (A)
 I10_DX32                      372- 378 (A)
 I10_DX33                      379- 385 (A)
 I10_DX34                      386- 392 (A)
 I10_DX35                      393- 399 (A)
 I10_DX36                      400- 406 (A)
 I10_DX37                      407- 413 (A)
 I10_DX38                      414- 420 (A)
 I10_DX39                      421- 427 (A)
 I10_DX40                      428- 434 (A)
 I10_DX41                      435- 441 (A)
 I10_DX42                      442- 448 (A)
 I10_DX43                      449- 455 (A)
 I10_DX44                      456- 462 (A)
 I10_DX45                      463- 469 (A)
 I10_DX46                      470- 476 (A)
 I10_DX47                      477- 483 (A)
 I10_DX48                      484- 490 (A)
 I10_DX49                      491- 497 (A)
 I10_DX50                      498- 504 (A)
 I10_ECAUSE1                   505- 511 (A)
 I10_ECAUSE2                   512- 518 (A)
 I10_ECAUSE3                   519- 525 (A)
 I10_ECAUSE4                   526- 532 (A)
 I10_ECAUSE5                   533- 539 (A)
 I10_ECAUSE6                   540- 546 (A)
 I10_ECAUSE7                   547- 553 (A)
 I10_ECAUSE8                   554- 560 (A)
 I10_NDX                       561- 563
 I10_NECAUSE                   564- 565
 I10_NPR                       566- 568
 I10_PR1                       569- 575 (A)
 I10_PR2                       576- 582 (A)
 I10_PR3                       583- 589 (A)
 I10_PR4                       590- 596 (A)
 I10_PR5                       597- 603 (A)
 I10_PR6                       604- 610 (A)
 I10_PR7                       611- 617 (A)
 I10_PR8                       618- 624 (A)
 I10_PR9                       625- 631 (A)
 I10_PR10                      632- 638 (A)
 I10_PR11                      639- 645 (A)
 I10_PR12                      646- 652 (A)
 I10_PR13                      653- 659 (A)
 I10_PR14                      660- 666 (A)
 I10_PR15                      667- 673 (A)
 I10_PR16                      674- 680 (A)
 I10_PR17                      681- 687 (A)
 I10_PR18                      688- 694 (A)
 I10_PR19                      695- 701 (A)
 I10_PR20                      702- 708 (A)
 I10_PR21                      709- 715 (A)
 I10_PR22                      716- 722 (A)
 I10_PR23                      723- 729 (A)
 I10_PR24                      730- 736 (A)
 I10_PR25                      737- 743 (A)
 I10_PR26                      744- 750 (A)
 I10_PR27                      751- 757 (A)
 I10_PR28                      758- 764 (A)
 I10_PR29                      765- 771 (A)
 I10_PR30                      772- 778 (A)
 I10_PR31                      779- 785 (A)
 I10_PR32                      786- 792 (A)
 I10_PR33                      793- 799 (A)
 I10_PR34                      800- 806 (A)
 I10_PR35                      807- 813 (A)
 I10_PR36                      814- 820 (A)
 I10_PR37                      821- 827 (A)
 I10_PR38                      828- 834 (A)
 I10_PR39                      835- 841 (A)
 I10_PR40                      842- 848 (A)
 I10_PR41                      849- 855 (A)
 I10_PR42                      856- 862 (A)
 I10_PR43                      863- 869 (A)
 I10_PR44                      870- 876 (A)
 I10_PR45                      877- 883 (A)
 I10_PR46                      884- 890 (A)
 I10_PR47                      891- 897 (A)
 I10_PR48                      898- 904 (A)
 I10_PR49                      905- 911 (A)
 I10_PR50                      912- 918 (A)
 I10_PROCTYPE                  919- 921
 KEY                           922- 936
 LOS                           937- 941
 LOS_X                         942- 947
 MDC                           948- 949
 MDC_NoPOA                     950- 951
 MEDINCSTQ                     952- 953
 MRN_R                         954- 962
 OS_TIME                       963- 973
 PAY1                          974- 975
 PAY1_X                        976- 982 (A)
 PAY2                          983- 984
 PAY2_X                        985- 991 (A)
 PAY3                          992- 993
 PAY3_X                        994-1000 (A)
 PL_CBSA                      1001-1003
 PL_NCHS                      1004-1005
 PL_RUCC                      1006-1007
 PL_UIC                       1008-1009
 PL_UR_CAT4                   1010-1011
 POA_Disch_Edit1              1012-1013
 POA_Disch_Edit2              1014-1015
 POA_Hosp_Edit1               1016-1017
 POA_Hosp_Edit2               1018-1019
 POA_Hosp_Edit3               1020-1021
 POA_Hosp_Edit3_Value         1022-1029
 PointOfOrigin_X              1030     (A)
 PointOfOriginUB04            1031     (A)
 PRDAY1                       1032-1036
 PRDAY2                       1037-1041
 PRDAY3                       1042-1046
 PRDAY4                       1047-1051
 PRDAY5                       1052-1056
 PRDAY6                       1057-1061
 PRDAY7                       1062-1066
 PRDAY8                       1067-1071
 PRDAY9                       1072-1076
 PRDAY10                      1077-1081
 PRDAY11                      1082-1086
 PRDAY12                      1087-1091
 PRDAY13                      1092-1096
 PRDAY14                      1097-1101
 PRDAY15                      1102-1106
 PRDAY16                      1107-1111
 PRDAY17                      1112-1116
 PRDAY18                      1117-1121
 PRDAY19                      1122-1126
 PRDAY20                      1127-1131
 PRDAY21                      1132-1136
 PRDAY22                      1137-1141
 PRDAY23                      1142-1146
 PRDAY24                      1147-1151
 PRDAY25                      1152-1156
 PRDAY26                      1157-1161
 PRDAY27                      1162-1166
 PRDAY28                      1167-1171
 PRDAY29                      1172-1176
 PRDAY30                      1177-1181
 PRDAY31                      1182-1186
 PRDAY32                      1187-1191
 PRDAY33                      1192-1196
 PRDAY34                      1197-1201
 PRDAY35                      1202-1206
 PRDAY36                      1207-1211
 PRDAY37                      1212-1216
 PRDAY38                      1217-1221
 PRDAY39                      1222-1226
 PRDAY40                      1227-1231
 PRDAY41                      1232-1236
 PRDAY42                      1237-1241
 PRDAY43                      1242-1246
 PRDAY44                      1247-1251
 PRDAY45                      1252-1256
 PRDAY46                      1257-1261
 PRDAY47                      1262-1266
 PRDAY48                      1267-1271
 PRDAY49                      1272-1276
 PRDAY50                      1277-1281
 PrimLang                     1282-1284 (A)
 PRVER                        1285-1287
 PSTATE                       1288-1289 (A)
 PSTCO2                       1290-1294
 RACE                         1295-1296
 RACE_X                       1297-1316 (A)
 TOTCHG                       1317-1326
 TOTCHG_X                     1327-1341
 TRAN_IN                      1342-1343
 TRAN_OUT                     1344-1345
 YEAR                         1346-1349
 ZIP                          1350-1354 (A)
 ZIP3                         1355-1357 (A)
 ZIPINC_QRTL                  1358-1360
 AYEAR                        1361-1364
 BMONTH                       1365-1366
 BYEAR                        1367-1370
 PRMONTH1                     1371-1372
 PRMONTH2                     1373-1374
 PRMONTH3                     1375-1376
 PRMONTH4                     1377-1378
 PRMONTH5                     1379-1380
 PRMONTH6                     1381-1382
 PRMONTH7                     1383-1384
 PRMONTH8                     1385-1386
 PRMONTH9                     1387-1388
 PRMONTH10                    1389-1390
 PRMONTH11                    1391-1392
 PRMONTH12                    1393-1394
 PRMONTH13                    1395-1396
 PRMONTH14                    1397-1398
 PRMONTH15                    1399-1400
 PRMONTH16                    1401-1402
 PRMONTH17                    1403-1404
 PRMONTH18                    1405-1406
 PRMONTH19                    1407-1408
 PRMONTH20                    1409-1410
 PRMONTH21                    1411-1412
 PRMONTH22                    1413-1414
 PRMONTH23                    1415-1416
 PRMONTH24                    1417-1418
 PRMONTH25                    1419-1420
 PRMONTH26                    1421-1422
 PRMONTH27                    1423-1424
 PRMONTH28                    1425-1426
 PRMONTH29                    1427-1428
 PRMONTH30                    1429-1430
 PRMONTH31                    1431-1432
 PRMONTH32                    1433-1434
 PRMONTH33                    1435-1436
 PRMONTH34                    1437-1438
 PRMONTH35                    1439-1440
 PRMONTH36                    1441-1442
 PRMONTH37                    1443-1444
 PRMONTH38                    1445-1446
 PRMONTH39                    1447-1448
 PRMONTH40                    1449-1450
 PRMONTH41                    1451-1452
 PRMONTH42                    1453-1454
 PRMONTH43                    1455-1456
 PRMONTH44                    1457-1458
 PRMONTH45                    1459-1460
 PRMONTH46                    1461-1462
 PRMONTH47                    1463-1464
 PRMONTH48                    1465-1466
 PRMONTH49                    1467-1468
 PRMONTH50                    1469-1470
 PRYEAR1                      1471-1474
 PRYEAR2                      1475-1478
 PRYEAR3                      1479-1482
 PRYEAR4                      1483-1486
 PRYEAR5                      1487-1490
 PRYEAR6                      1491-1494
 PRYEAR7                      1495-1498
 PRYEAR8                      1499-1502
 PRYEAR9                      1503-1506
 PRYEAR10                     1507-1510
 PRYEAR11                     1511-1514
 PRYEAR12                     1515-1518
 PRYEAR13                     1519-1522
 PRYEAR14                     1523-1526
 PRYEAR15                     1527-1530
 PRYEAR16                     1531-1534
 PRYEAR17                     1535-1538
 PRYEAR18                     1539-1542
 PRYEAR19                     1543-1546
 PRYEAR20                     1547-1550
 PRYEAR21                     1551-1554
 PRYEAR22                     1555-1558
 PRYEAR23                     1559-1562
 PRYEAR24                     1563-1566
 PRYEAR25                     1567-1570
 PRYEAR26                     1571-1574
 PRYEAR27                     1575-1578
 PRYEAR28                     1579-1582
 PRYEAR29                     1583-1586
 PRYEAR30                     1587-1590
 PRYEAR31                     1591-1594
 PRYEAR32                     1595-1598
 PRYEAR33                     1599-1602
 PRYEAR34                     1603-1606
 PRYEAR35                     1607-1610
 PRYEAR36                     1611-1614
 PRYEAR37                     1615-1618
 PRYEAR38                     1619-1622
 PRYEAR39                     1623-1626
 PRYEAR40                     1627-1630
 PRYEAR41                     1631-1634
 PRYEAR42                     1635-1638
 PRYEAR43                     1639-1642
 PRYEAR44                     1643-1646
 PRYEAR45                     1647-1650
 PRYEAR46                     1651-1654
 PRYEAR47                     1655-1658
 PRYEAR48                     1659-1662
 PRYEAR49                     1663-1666
 PRYEAR50                     1667-1670.


***  Specify write formats  ***.
FORMATS
 ADRG                         (F3.0) /
 ADRGRISKMORTALITY            (F3.0) /
 ADRGSEV                      (F3.0) /
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMDC                         (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NECAUSE                  (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRDAY31                      (F4.0) /
 PRDAY32                      (F4.0) /
 PRDAY33                      (F4.0) /
 PRDAY34                      (F4.0) /
 PRDAY35                      (F4.0) /
 PRDAY36                      (F4.0) /
 PRDAY37                      (F4.0) /
 PRDAY38                      (F4.0) /
 PRDAY39                      (F4.0) /
 PRDAY40                      (F4.0) /
 PRDAY41                      (F4.0) /
 PRDAY42                      (F4.0) /
 PRDAY43                      (F4.0) /
 PRDAY44                      (F4.0) /
 PRDAY45                      (F4.0) /
 PRDAY46                      (F4.0) /
 PRDAY47                      (F4.0) /
 PRDAY48                      (F4.0) /
 PRDAY49                      (F4.0) /
 PRDAY50                      (F4.0) /
 PRVER                        (F3.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRMONTH26                    (F3.0) /
 PRMONTH27                    (F3.0) /
 PRMONTH28                    (F3.0) /
 PRMONTH29                    (F3.0) /
 PRMONTH30                    (F3.0) /
 PRMONTH31                    (F3.0) /
 PRMONTH32                    (F3.0) /
 PRMONTH33                    (F3.0) /
 PRMONTH34                    (F3.0) /
 PRMONTH35                    (F3.0) /
 PRMONTH36                    (F3.0) /
 PRMONTH37                    (F3.0) /
 PRMONTH38                    (F3.0) /
 PRMONTH39                    (F3.0) /
 PRMONTH40                    (F3.0) /
 PRMONTH41                    (F3.0) /
 PRMONTH42                    (F3.0) /
 PRMONTH43                    (F3.0) /
 PRMONTH44                    (F3.0) /
 PRMONTH45                    (F3.0) /
 PRMONTH46                    (F3.0) /
 PRMONTH47                    (F3.0) /
 PRMONTH48                    (F3.0) /
 PRMONTH49                    (F3.0) /
 PRMONTH50                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) /
 PRYEAR26                     (F3.0) /
 PRYEAR27                     (F3.0) /
 PRYEAR28                     (F3.0) /
 PRYEAR29                     (F3.0) /
 PRYEAR30                     (F3.0) /
 PRYEAR31                     (F3.0) /
 PRYEAR32                     (F3.0) /
 PRYEAR33                     (F3.0) /
 PRYEAR34                     (F3.0) /
 PRYEAR35                     (F3.0) /
 PRYEAR36                     (F3.0) /
 PRYEAR37                     (F3.0) /
 PRYEAR38                     (F3.0) /
 PRYEAR39                     (F3.0) /
 PRYEAR40                     (F3.0) /
 PRYEAR41                     (F3.0) /
 PRYEAR42                     (F3.0) /
 PRYEAR43                     (F3.0) /
 PRYEAR44                     (F3.0) /
 PRYEAR45                     (F3.0) /
 PRYEAR46                     (F3.0) /
 PRYEAR47                     (F3.0) /
 PRYEAR48                     (F3.0) /
 PRYEAR49                     (F3.0) /
 PRYEAR50                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 ADRG                         "All Patient Refined DRG"
 ADRGRISKMORTALITY            "All Patient Refined DRG mortality risk"
 ADRGSEV                      "All Patient Refined DRG severity level"
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMDC                         "All Patient Refined MDC"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DXVER                        "Diagnosis Version"
 E_POA1                       "External cause 1, present on admission indicator"
 E_POA2                       "External cause 2, present on admission indicator"
 E_POA3                       "External cause 3, present on admission indicator"
 E_POA4                       "External cause 4, present on admission indicator"
 E_POA5                       "External cause 5, present on admission indicator"
 E_POA6                       "External cause 6, present on admission indicator"
 E_POA7                       "External cause 7, present on admission indicator"
 E_POA8                       "External cause 8, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPST                       "Hospital state postal code"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DX49                     "ICD-10-CM Diagnosis 49"
 I10_DX50                     "ICD-10-CM Diagnosis 50"
 I10_ECAUSE1                  "ICD-10-CM External cause 1"
 I10_ECAUSE2                  "ICD-10-CM External cause 2"
 I10_ECAUSE3                  "ICD-10-CM External cause 3"
 I10_ECAUSE4                  "ICD-10-CM External cause 4"
 I10_ECAUSE5                  "ICD-10-CM External cause 5"
 I10_ECAUSE6                  "ICD-10-CM External cause 6"
 I10_ECAUSE7                  "ICD-10-CM External cause 7"
 I10_ECAUSE8                  "ICD-10-CM External cause 8"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NECAUSE                  "ICD-10-CM Number of External cause codes on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PR31                     "ICD-10-PCS Procedure 31"
 I10_PR32                     "ICD-10-PCS Procedure 32"
 I10_PR33                     "ICD-10-PCS Procedure 33"
 I10_PR34                     "ICD-10-PCS Procedure 34"
 I10_PR35                     "ICD-10-PCS Procedure 35"
 I10_PR36                     "ICD-10-PCS Procedure 36"
 I10_PR37                     "ICD-10-PCS Procedure 37"
 I10_PR38                     "ICD-10-PCS Procedure 38"
 I10_PR39                     "ICD-10-PCS Procedure 39"
 I10_PR40                     "ICD-10-PCS Procedure 40"
 I10_PR41                     "ICD-10-PCS Procedure 41"
 I10_PR42                     "ICD-10-PCS Procedure 42"
 I10_PR43                     "ICD-10-PCS Procedure 43"
 I10_PR44                     "ICD-10-PCS Procedure 44"
 I10_PR45                     "ICD-10-PCS Procedure 45"
 I10_PR46                     "ICD-10-PCS Procedure 46"
 I10_PR47                     "ICD-10-PCS Procedure 47"
 I10_PR48                     "ICD-10-PCS Procedure 48"
 I10_PR49                     "ICD-10-PCS Procedure 49"
 I10_PR50                     "ICD-10-PCS Procedure 50"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRDAY31                      "Number of days from admission to I10_PR31"
 PRDAY32                      "Number of days from admission to I10_PR32"
 PRDAY33                      "Number of days from admission to I10_PR33"
 PRDAY34                      "Number of days from admission to I10_PR34"
 PRDAY35                      "Number of days from admission to I10_PR35"
 PRDAY36                      "Number of days from admission to I10_PR36"
 PRDAY37                      "Number of days from admission to I10_PR37"
 PRDAY38                      "Number of days from admission to I10_PR38"
 PRDAY39                      "Number of days from admission to I10_PR39"
 PRDAY40                      "Number of days from admission to I10_PR40"
 PRDAY41                      "Number of days from admission to I10_PR41"
 PRDAY42                      "Number of days from admission to I10_PR42"
 PRDAY43                      "Number of days from admission to I10_PR43"
 PRDAY44                      "Number of days from admission to I10_PR44"
 PRDAY45                      "Number of days from admission to I10_PR45"
 PRDAY46                      "Number of days from admission to I10_PR46"
 PRDAY47                      "Number of days from admission to I10_PR47"
 PRDAY48                      "Number of days from admission to I10_PR48"
 PRDAY49                      "Number of days from admission to I10_PR49"
 PRDAY50                      "Number of days from admission to I10_PR50"
 PrimLang                     "Primary language of patient"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRMONTH26                    "Month of procedure 26"
 PRMONTH27                    "Month of procedure 27"
 PRMONTH28                    "Month of procedure 28"
 PRMONTH29                    "Month of procedure 29"
 PRMONTH30                    "Month of procedure 30"
 PRMONTH31                    "Month of procedure 31"
 PRMONTH32                    "Month of procedure 32"
 PRMONTH33                    "Month of procedure 33"
 PRMONTH34                    "Month of procedure 34"
 PRMONTH35                    "Month of procedure 35"
 PRMONTH36                    "Month of procedure 36"
 PRMONTH37                    "Month of procedure 37"
 PRMONTH38                    "Month of procedure 38"
 PRMONTH39                    "Month of procedure 39"
 PRMONTH40                    "Month of procedure 40"
 PRMONTH41                    "Month of procedure 41"
 PRMONTH42                    "Month of procedure 42"
 PRMONTH43                    "Month of procedure 43"
 PRMONTH44                    "Month of procedure 44"
 PRMONTH45                    "Month of procedure 45"
 PRMONTH46                    "Month of procedure 46"
 PRMONTH47                    "Month of procedure 47"
 PRMONTH48                    "Month of procedure 48"
 PRMONTH49                    "Month of procedure 49"
 PRMONTH50                    "Month of procedure 50"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25"
 PRYEAR26                     "Year of procedure 26"
 PRYEAR27                     "Year of procedure 27"
 PRYEAR28                     "Year of procedure 28"
 PRYEAR29                     "Year of procedure 29"
 PRYEAR30                     "Year of procedure 30"
 PRYEAR31                     "Year of procedure 31"
 PRYEAR32                     "Year of procedure 32"
 PRYEAR33                     "Year of procedure 33"
 PRYEAR34                     "Year of procedure 34"
 PRYEAR35                     "Year of procedure 35"
 PRYEAR36                     "Year of procedure 36"
 PRYEAR37                     "Year of procedure 37"
 PRYEAR38                     "Year of procedure 38"
 PRYEAR39                     "Year of procedure 39"
 PRYEAR40                     "Year of procedure 40"
 PRYEAR41                     "Year of procedure 41"
 PRYEAR42                     "Year of procedure 42"
 PRYEAR43                     "Year of procedure 43"
 PRYEAR44                     "Year of procedure 44"
 PRYEAR45                     "Year of procedure 45"
 PRYEAR46                     "Year of procedure 46"
 PRYEAR47                     "Year of procedure 47"
 PRYEAR48                     "Year of procedure 48"
 PRYEAR49                     "Year of procedure 49"
 PRYEAR50                     "Year of procedure 50" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE ADRG
 (-99,-88,-66,-55=SYSMIS).
RECODE ADRGRISKMORTALITY
 (-9,-8,-6,-5=SYSMIS).
RECODE ADRGSEV
 (-9,-8,-6,-5=SYSMIS).
RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMDC
 (-9,-8,-6,-5=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NECAUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY45
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY46
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY47
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY48
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY49
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY50
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH33
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH34
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH35
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH36
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH37
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH38
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH39
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH40
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH41
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH42
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH43
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH44
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH45
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH46
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH47
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH48
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH49
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH50
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR33
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR34
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR35
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR36
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR37
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR38
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR39
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR40
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR41
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR42
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR43
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR44
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR45
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR46
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR47
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR48
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR49
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR50
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MN_SID_2016_CORE.SAV' /COMPRESSED.
