/*******************************************************************
*   MD_SID_1993_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MD_SID_1993_CORE.ASC' FIXED / 
 AGE                   1-   3
 AGEDAY                4-   6
 SEX                   7-   9
 RACE                 10-  11
 DQTR                 12-  13
 LOS                  14-  18
 DISP                 19-  20
 DIED                 21-  22
 ATYPE                23-  24
 ASOURCE              25-  26
 NDX                  27-  28
 DX1                  29-  33 (A)
 DXV1                 34-  37
 DCCHPR1              38-  41
 NPR                  42-  43
 PR1                  44-  47 (A)
 PRV1                 48-  50
 PCCHPR1              51-  54
 DRG                  55-  57
 MDC                  58-  59
 DRGVER               60-  61
 DRG10                62-  64
 MDC10                65-  66
 PAY1                 67-  68
 TOTCHG               69-  78
 PROCESS              79-  89
 YEAR                 90-  93
 DSHOSPID             94- 106 (A)
 DSNUM               107- 109
 DSTYPE              110- 112
 HOSPST              113- 114 (A)
 MDID_S              115- 130 (A)
 SURGID_S            131- 146 (A)
 ADAYWK              147- 149
 LOS_X               150- 154
 NEOMAT              155- 156
 DXSYS               157- 159
 DSNDX               160- 162
 PRSYS               163- 165
 DSNPR               166- 168
 PRDAY1              169- 173
 PAY1_N              174- 176
 PAY2                177- 178
 PAY2_N              179- 181
 TOTCHG_X            182- 193
 DX2                 194- 198 (A)
 DX3                 199- 203 (A)
 DX4                 204- 208 (A)
 DX5                 209- 213 (A)
 DX6                 214- 218 (A)
 DX7                 219- 223 (A)
 DX8                 224- 228 (A)
 DX9                 229- 233 (A)
 DX10                234- 238 (A)
 DX11                239- 243 (A)
 DX12                244- 248 (A)
 DX13                249- 253 (A)
 DX14                254- 258 (A)
 DX15                259- 263 (A)
 DX16                264- 268 (A)
 DXV2                269- 272
 DXV3                273- 276
 DXV4                277- 280
 DXV5                281- 284
 DXV6                285- 288
 DXV7                289- 292
 DXV8                293- 296
 DXV9                297- 300
 DXV10               301- 304
 DXV11               305- 308
 DXV12               309- 312
 DXV13               313- 316
 DXV14               317- 320
 DXV15               321- 324
 DXV16               325- 328
 DCCHPR2             329- 332
 DCCHPR3             333- 336
 DCCHPR4             337- 340
 DCCHPR5             341- 344
 DCCHPR6             345- 348
 DCCHPR7             349- 352
 DCCHPR8             353- 356
 DCCHPR9             357- 360
 DCCHPR10            361- 364
 DCCHPR11            365- 368
 DCCHPR12            369- 372
 DCCHPR13            373- 376
 DCCHPR14            377- 380
 DCCHPR15            381- 384
 DCCHPR16            385- 388
 PR2                 389- 392 (A)
 PR3                 393- 396 (A)
 PR4                 397- 400 (A)
 PR5                 401- 404 (A)
 PR6                 405- 408 (A)
 PR7                 409- 412 (A)
 PR8                 413- 416 (A)
 PR9                 417- 420 (A)
 PR10                421- 424 (A)
 PR11                425- 428 (A)
 PR12                429- 432 (A)
 PR13                433- 436 (A)
 PR14                437- 440 (A)
 PR15                441- 444 (A)
 PRV2                445- 447
 PRV3                448- 450
 PRV4                451- 453
 PRV5                454- 456
 PRV6                457- 459
 PRV7                460- 462
 PRV8                463- 465
 PRV9                466- 468
 PRV10               469- 471
 PRV11               472- 474
 PRV12               475- 477
 PRV13               478- 480
 PRV14               481- 483
 PRV15               484- 486
 PCCHPR2             487- 490
 PCCHPR3             491- 494
 PCCHPR4             495- 498
 PCCHPR5             499- 502
 PCCHPR6             503- 506
 PCCHPR7             507- 510
 PCCHPR8             511- 514
 PCCHPR9             515- 518
 PCCHPR10            519- 522
 PCCHPR11            523- 526
 PCCHPR12            527- 530
 PCCHPR13            531- 534
 PCCHPR14            535- 538
 PCCHPR15            539- 542
 PRDAY2              543- 547
 PRDAY3              548- 552
 PRDAY4              553- 557
 PRDAY5              558- 562
 PRDAY6              563- 567
 PRDAY7              568- 572
 PRDAY8              573- 577
 PRDAY9              578- 582
 PRDAY10             583- 587
 PRDAY11             588- 592
 PRDAY12             593- 597
 PRDAY13             598- 602
 PRDAY14             603- 607
 PRDAY15             608- 612
 MRN_S               613- 629 (A)
 BWT                 630- 633
 PAY1_X              634- 635 (A)
 PAY2_X              636- 637 (A).


***  Specify write formats  ***.
FORMATS
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 SEX                 (F3.0) /
 RACE                (F3.0) /
 DQTR                (F3.0) /
 LOS                 (F4.0) /
 DISP                (F3.0) /
 DIED                (F3.0) /
 ATYPE               (F3.0) /
 ASOURCE             (F3.0) /
 NDX                 (F3.0) /
 DXV1                (F3.0) /
 DCCHPR1             (F3.0) /
 NPR                 (F3.0) /
 PRV1                (F3.0) /
 PCCHPR1             (F3.0) /
 DRG                 (F3.0) /
 MDC                 (F3.0) /
 DRGVER              (F3.0) /
 DRG10               (F3.0) /
 MDC10               (F3.0) /
 PAY1                (F3.0) /
 TOTCHG              (F6.0) /
 PROCESS             (F6.0) /
 YEAR                (F3.0) /
 DSNUM               (F3.0) /
 DSTYPE              (F3.0) /
 ADAYWK              (F3.0) /
 LOS_X               (F4.0) /
 NEOMAT              (F3.0) /
 DXSYS               (F3.0) /
 DSNDX               (F3.0) /
 PRSYS               (F3.0) /
 DSNPR               (F3.0) /
 PRDAY1              (F4.0) /
 PAY1_N              (F3.0) /
 PAY2                (F3.0) /
 PAY2_N              (F3.0) /
 TOTCHG_X            (F6.2) /
 DXV2                (F3.0) /
 DXV3                (F3.0) /
 DXV4                (F3.0) /
 DXV5                (F3.0) /
 DXV6                (F3.0) /
 DXV7                (F3.0) /
 DXV8                (F3.0) /
 DXV9                (F3.0) /
 DXV10               (F3.0) /
 DXV11               (F3.0) /
 DXV12               (F3.0) /
 DXV13               (F3.0) /
 DXV14               (F3.0) /
 DXV15               (F3.0) /
 DXV16               (F3.0) /
 DCCHPR2             (F3.0) /
 DCCHPR3             (F3.0) /
 DCCHPR4             (F3.0) /
 DCCHPR5             (F3.0) /
 DCCHPR6             (F3.0) /
 DCCHPR7             (F3.0) /
 DCCHPR8             (F3.0) /
 DCCHPR9             (F3.0) /
 DCCHPR10            (F3.0) /
 DCCHPR11            (F3.0) /
 DCCHPR12            (F3.0) /
 DCCHPR13            (F3.0) /
 DCCHPR14            (F3.0) /
 DCCHPR15            (F3.0) /
 DCCHPR16            (F3.0) /
 PRV2                (F3.0) /
 PRV3                (F3.0) /
 PRV4                (F3.0) /
 PRV5                (F3.0) /
 PRV6                (F3.0) /
 PRV7                (F3.0) /
 PRV8                (F3.0) /
 PRV9                (F3.0) /
 PRV10               (F3.0) /
 PRV11               (F3.0) /
 PRV12               (F3.0) /
 PRV13               (F3.0) /
 PRV14               (F3.0) /
 PRV15               (F3.0) /
 PCCHPR2             (F3.0) /
 PCCHPR3             (F3.0) /
 PCCHPR4             (F3.0) /
 PCCHPR5             (F3.0) /
 PCCHPR6             (F3.0) /
 PCCHPR7             (F3.0) /
 PCCHPR8             (F3.0) /
 PCCHPR9             (F3.0) /
 PCCHPR10            (F3.0) /
 PCCHPR11            (F3.0) /
 PCCHPR12            (F3.0) /
 PCCHPR13            (F3.0) /
 PCCHPR14            (F3.0) /
 PCCHPR15            (F3.0) /
 PRDAY2              (F4.0) /
 PRDAY3              (F4.0) /
 PRDAY4              (F4.0) /
 PRDAY5              (F4.0) /
 PRDAY6              (F4.0) /
 PRDAY7              (F4.0) /
 PRDAY8              (F4.0) /
 PRDAY9              (F4.0) /
 PRDAY10             (F4.0) /
 PRDAY11             (F4.0) /
 PRDAY12             (F4.0) /
 PRDAY13             (F4.0) /
 PRDAY14             (F4.0) /
 PRDAY15             (F4.0) /
 BWT                 (F3.0) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE       "I:Age in years at admission"
 AGEDAY    "I:Age in days (when < 1 year)"
 SEX       "I:Sex"
 RACE      "I:Race"
 DQTR      "I:Discharge quarter"
 LOS       "I:Length of stay (cleaned)"
 DISP      "I:Disposition of patient"
 DIED      "I:Died during hospitalization"
 ATYPE     "I:Admission type"
 ASOURCE   "I:Admission source"
 NDX       "I:Number of diagnoses on this discharge"
 DX1       "I:Principal diagnosis"
 DXV1      "I:Validity flag: principal diagnosis"
 DCCHPR1   "I:CCHPR: principal diagnosis"
 NPR       "I:Number of procedures on this discharge"
 PR1       "I:Principal procedure"
 PRV1      "I:Validity flag: principal procedure"
 PCCHPR1   "I:CCHPR: principal procedure"
 DRG       "I:DRG in effect on discharge date"
 MDC       "I:MDC in effect on discharge date"
 DRGVER    "I:DRG grouper version used on disch date"
 DRG10     "I:DRG, Version 10"
 MDC10     "I:MDC, Version 10"
 PAY1      "I:Primary expected payer, uniform"
 TOTCHG    "I:Total charges (cleaned)"
 PROCESS   "I:HCUP-3 discharge processing ID number"
 YEAR      "Calendar year"
 DSHOSPID  "I:Data source hospital ID number"
 DSNUM     "I:Data source ID number"
 DSTYPE    "I:Data source type"
 HOSPST    "Hospital state postal code"
 MDID_S    "I:Attending physician number (synthetic)"
 SURGID_S  "I:Primary surgeon number (synthetic)"
 ADAYWK    "I:Admission day of week"
 LOS_X     "I:Length of stay (uncleaned)"
 NEOMAT    "I:Neonatal and/or maternal DX and/or PR"
 DXSYS     "I:Diagnosis coding system"
 DSNDX     "I:Max number of diagnoses from source"
 PRSYS     "I:Procedure coding system"
 DSNPR     "I:Max number of procedures from source"
 PRDAY1    "I:No. of days from admission to PR1"
 PAY1_N    "I:Primary expected payer, nonuniform"
 PAY2      "I:Secondary expected payer, uniform"
 PAY2_N    "I:Secondary expected payer, nonuniform"
 TOTCHG_X  "I:Total charges (from data source)"
 DX2       "I:Diagnosis 2"
 DX3       "I:Diagnosis 3"
 DX4       "I:Diagnosis 4"
 DX5       "I:Diagnosis 5"
 DX6       "I:Diagnosis 6"
 DX7       "I:Diagnosis 7"
 DX8       "I:Diagnosis 8"
 DX9       "I:Diagnosis 9"
 DX10      "I:Diagnosis 10"
 DX11      "I:Diagnosis 11"
 DX12      "I:Diagnosis 12"
 DX13      "I:Diagnosis 13"
 DX14      "I:Diagnosis 14"
 DX15      "I:Diagnosis 15"
 DX16      "I:Diagnosis 16"
 DXV2      "I:Validity flag: diagnosis 2"
 DXV3      "I:Validity flag: diagnosis 3"
 DXV4      "I:Validity flag: diagnosis 4"
 DXV5      "I:Validity flag: diagnosis 5"
 DXV6      "I:Validity flag: diagnosis 6"
 DXV7      "I:Validity flag: diagnosis 7"
 DXV8      "I:Validity flag: diagnosis 8"
 DXV9      "I:Validity flag: diagnosis 9"
 DXV10     "I:Validity flag: diagnosis 10"
 DXV11     "I:Validity flag: diagnosis 11"
 DXV12     "I:Validity flag: diagnosis 12"
 DXV13     "I:Validity flag: diagnosis 13"
 DXV14     "I:Validity flag: diagnosis 14"
 DXV15     "I:Validity flag: diagnosis 15"
 DXV16     "I:Validity flag: diagnosis 16"
 DCCHPR2   "I:CCHPR: diagnosis 2"
 DCCHPR3   "I:CCHPR: diagnosis 3"
 DCCHPR4   "I:CCHPR: diagnosis 4"
 DCCHPR5   "I:CCHPR: diagnosis 5"
 DCCHPR6   "I:CCHPR: diagnosis 6"
 DCCHPR7   "I:CCHPR: diagnosis 7"
 DCCHPR8   "I:CCHPR: diagnosis 8"
 DCCHPR9   "I:CCHPR: diagnosis 9"
 DCCHPR10  "I:CCHPR: diagnosis 10"
 DCCHPR11  "I:CCHPR: diagnosis 11"
 DCCHPR12  "I:CCHPR: diagnosis 12"
 DCCHPR13  "I:CCHPR: diagnosis 13"
 DCCHPR14  "I:CCHPR: diagnosis 14"
 DCCHPR15  "I:CCHPR: diagnosis 15"
 DCCHPR16  "I:CCHPR: diagnosis 16"
 PR2       "I:Procedure 2"
 PR3       "I:Procedure 3"
 PR4       "I:Procedure 4"
 PR5       "I:Procedure 5"
 PR6       "I:Procedure 6"
 PR7       "I:Procedure 7"
 PR8       "I:Procedure 8"
 PR9       "I:Procedure 9"
 PR10      "I:Procedure 10"
 PR11      "I:Procedure 11"
 PR12      "I:Procedure 12"
 PR13      "I:Procedure 13"
 PR14      "I:Procedure 14"
 PR15      "I:Procedure 15"
 PRV2      "I:Validity flag: procedure 2"
 PRV3      "I:Validity flag: procedure 3"
 PRV4      "I:Validity flag: procedure 4"
 PRV5      "I:Validity flag: procedure 5"
 PRV6      "I:Validity flag: procedure 6"
 PRV7      "I:Validity flag: procedure 7"
 PRV8      "I:Validity flag: procedure 8"
 PRV9      "I:Validity flag: procedure 9"
 PRV10     "I:Validity flag: procedure 10"
 PRV11     "I:Validity flag: procedure 11"
 PRV12     "I:Validity flag: procedure 12"
 PRV13     "I:Validity flag: procedure 13"
 PRV14     "I:Validity flag: procedure 14"
 PRV15     "I:Validity flag: procedure 15"
 PCCHPR2   "I:CCHPR: procedure 2"
 PCCHPR3   "I:CCHPR: procedure 3"
 PCCHPR4   "I:CCHPR: procedure 4"
 PCCHPR5   "I:CCHPR: procedure 5"
 PCCHPR6   "I:CCHPR: procedure 6"
 PCCHPR7   "I:CCHPR: procedure 7"
 PCCHPR8   "I:CCHPR: procedure 8"
 PCCHPR9   "I:CCHPR: procedure 9"
 PCCHPR10  "I:CCHPR: procedure 10"
 PCCHPR11  "I:CCHPR: procedure 11"
 PCCHPR12  "I:CCHPR: procedure 12"
 PCCHPR13  "I:CCHPR: procedure 13"
 PCCHPR14  "I:CCHPR: procedure 14"
 PCCHPR15  "I:CCHPR: procedure 15"
 PRDAY2    "I:No. of days from admission to PR2"
 PRDAY3    "I:No. of days from admission to PR3"
 PRDAY4    "I:No. of days from admission to PR4"
 PRDAY5    "I:No. of days from admission to PR5"
 PRDAY6    "I:No. of days from admission to PR6"
 PRDAY7    "I:No. of days from admission to PR7"
 PRDAY8    "I:No. of days from admission to PR8"
 PRDAY9    "I:No. of days from admission to PR9"
 PRDAY10   "I:No. of days from admission to PR10"
 PRDAY11   "I:No. of days from admission to PR11"
 PRDAY12   "I:No. of days from admission to PR12"
 PRDAY13   "I:No. of days from admission to PR13"
 PRDAY14   "I:No. of days from admission to PR14"
 PRDAY15   "I:No. of days from admission to PR15"
 MRN_S     "I:Medical record number (synthetic)"
 BWT       "I:Birthweight in grams"
 PAY1_X    "I:Primary exp. payer (from data source)"
 PAY2_X    "I:Secondary exp. payer (from data source" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE SEX
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE DISP
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE DXV1
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PRV1
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG10
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC10
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE DSNUM
 (-99,-88,-66,-55=SYSMIS).
RECODE DSTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE ADAYWK
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS_X
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE DXSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNDX
 (-99,-88,-66,-55=SYSMIS).
RECODE PRSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNPR
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PAY1_N
 (-99,-88,-66,-55=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2_N
 (-99,-88,-66,-55=SYSMIS).
RECODE TOTCHG_X
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE DXV2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV16
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR11
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR12
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR13
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR14
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR15
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRV2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV15
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MD_SID_1993_CORE.SAV' /COMPRESSED.
