/*******************************************************************
*   MA_SID_1994_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MA_SID_1994_CORE.ASC' FIXED / 
 SEQ_SID               1-  13
 AGE                  14-  16
 SEX                  17-  19
 RACE                 20-  21
 DQTR                 22-  23
 LOS                  24-  28
 DISP                 29-  30
 DIED                 31-  32
 ATYPE                33-  34
 ASOURCE              35-  36
 NDX                  37-  38
 DX1                  39-  43 (A)
 DXV1                 44-  47
 DCCHPR1              48-  51
 NPR                  52-  53
 PR1                  54-  57 (A)
 PRV1                 58-  60
 PCCHPR1              61-  64
 DRG                  65-  67
 MDC                  68-  69
 DRGVER               70-  71
 DRG10                72-  74
 MDC10                75-  76
 PAY1                 77-  78
 TOTCHG               79-  88
 PROCESS              89-  99
 YEAR                100- 103
 DSHOSPID            104- 116 (A)
 DSNUM               117- 119
 DSTYPE              120- 122
 HOSPST              123- 124 (A)
 ADAYWK              125- 127
 AMONTH              128- 129
 LOS_X               130- 134
 NEOMAT              135- 136
 DXSYS               137- 139
 DSNDX               140- 142
 PRSYS               143- 145
 DSNPR               146- 148
 PRDAY1              149- 153
 PAY1_N              154- 156
 PAY2                157- 158
 PAY2_N              159- 161
 TOTCHG_X            162- 173
 DX2                 174- 178 (A)
 DX3                 179- 183 (A)
 DX4                 184- 188 (A)
 DX5                 189- 193 (A)
 DX6                 194- 198 (A)
 DX7                 199- 203 (A)
 DX8                 204- 208 (A)
 DX9                 209- 213 (A)
 DX10                214- 218 (A)
 DX11                219- 223 (A)
 DXV2                224- 227
 DXV3                228- 231
 DXV4                232- 235
 DXV5                236- 239
 DXV6                240- 243
 DXV7                244- 247
 DXV8                248- 251
 DXV9                252- 255
 DXV10               256- 259
 DXV11               260- 263
 DCCHPR2             264- 267
 DCCHPR3             268- 271
 DCCHPR4             272- 275
 DCCHPR5             276- 279
 DCCHPR6             280- 283
 DCCHPR7             284- 287
 DCCHPR8             288- 291
 DCCHPR9             292- 295
 DCCHPR10            296- 299
 DCCHPR11            300- 303
 PR2                 304- 307 (A)
 PR3                 308- 311 (A)
 PR4                 312- 315 (A)
 PR5                 316- 319 (A)
 PR6                 320- 323 (A)
 PR7                 324- 327 (A)
 PR8                 328- 331 (A)
 PR9                 332- 335 (A)
 PR10                336- 339 (A)
 PRV2                340- 342
 PRV3                343- 345
 PRV4                346- 348
 PRV5                349- 351
 PRV6                352- 354
 PRV7                355- 357
 PRV8                358- 360
 PRV9                361- 363
 PRV10               364- 366
 PCCHPR2             367- 370
 PCCHPR3             371- 374
 PCCHPR4             375- 378
 PCCHPR5             379- 382
 PCCHPR6             383- 386
 PCCHPR7             387- 390
 PCCHPR8             391- 394
 PCCHPR9             395- 398
 PCCHPR10            399- 402
 PRDAY2              403- 407
 PRDAY3              408- 412
 PAY1_X              413     (A)
 PAY2_X              414     (A)
 AYEAR               415- 418
 DMONTH              419- 420
 PRMNTH1             421- 422
 PRMNTH2             423- 424
 PRMNTH3             425- 426
 PRYEAR1             427- 430
 PRYEAR2             431- 434
 PRYEAR3             435- 438.


***  Specify write formats  ***.
FORMATS
 SEQ_SID             (F7.0) /
 AGE                 (F3.0) /
 SEX                 (F3.0) /
 RACE                (F3.0) /
 DQTR                (F3.0) /
 LOS                 (F4.0) /
 DISP                (F3.0) /
 DIED                (F3.0) /
 ATYPE               (F3.0) /
 ASOURCE             (F3.0) /
 NDX                 (F3.0) /
 DXV1                (F3.0) /
 DCCHPR1             (F3.0) /
 NPR                 (F3.0) /
 PRV1                (F3.0) /
 PCCHPR1             (F3.0) /
 DRG                 (F3.0) /
 MDC                 (F3.0) /
 DRGVER              (F3.0) /
 DRG10               (F3.0) /
 MDC10               (F3.0) /
 PAY1                (F3.0) /
 TOTCHG              (F6.0) /
 PROCESS             (F6.0) /
 YEAR                (F3.0) /
 DSNUM               (F3.0) /
 DSTYPE              (F3.0) /
 ADAYWK              (F3.0) /
 AMONTH              (F3.0) /
 LOS_X               (F4.0) /
 NEOMAT              (F3.0) /
 DXSYS               (F3.0) /
 DSNDX               (F3.0) /
 PRSYS               (F3.0) /
 DSNPR               (F3.0) /
 PRDAY1              (F4.0) /
 PAY1_N              (F3.0) /
 PAY2                (F3.0) /
 PAY2_N              (F3.0) /
 TOTCHG_X            (F6.2) /
 DXV2                (F3.0) /
 DXV3                (F3.0) /
 DXV4                (F3.0) /
 DXV5                (F3.0) /
 DXV6                (F3.0) /
 DXV7                (F3.0) /
 DXV8                (F3.0) /
 DXV9                (F3.0) /
 DXV10               (F3.0) /
 DXV11               (F3.0) /
 DCCHPR2             (F3.0) /
 DCCHPR3             (F3.0) /
 DCCHPR4             (F3.0) /
 DCCHPR5             (F3.0) /
 DCCHPR6             (F3.0) /
 DCCHPR7             (F3.0) /
 DCCHPR8             (F3.0) /
 DCCHPR9             (F3.0) /
 DCCHPR10            (F3.0) /
 DCCHPR11            (F3.0) /
 PRV2                (F3.0) /
 PRV3                (F3.0) /
 PRV4                (F3.0) /
 PRV5                (F3.0) /
 PRV6                (F3.0) /
 PRV7                (F3.0) /
 PRV8                (F3.0) /
 PRV9                (F3.0) /
 PRV10               (F3.0) /
 PCCHPR2             (F3.0) /
 PCCHPR3             (F3.0) /
 PCCHPR4             (F3.0) /
 PCCHPR5             (F3.0) /
 PCCHPR6             (F3.0) /
 PCCHPR7             (F3.0) /
 PCCHPR8             (F3.0) /
 PCCHPR9             (F3.0) /
 PCCHPR10            (F3.0) /
 PRDAY2              (F4.0) /
 PRDAY3              (F4.0) /
 AYEAR               (F3.0) /
 DMONTH              (F3.0) /
 PRMNTH1             (F3.0) /
 PRMNTH2             (F3.0) /
 PRMNTH3             (F3.0) /
 PRYEAR1             (F3.0) /
 PRYEAR2             (F3.0) /
 PRYEAR3             (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 SEQ_SID   "I:HCUP-3 SID record sequence number"
 AGE       "I:Age in years at admission"
 SEX       "I:Sex"
 RACE      "I:Race"
 DQTR      "I:Discharge quarter"
 LOS       "I:Length of stay (cleaned)"
 DISP      "I:Disposition of patient"
 DIED      "I:Died during hospitalization"
 ATYPE     "I:Admission type"
 ASOURCE   "I:Admission source"
 NDX       "I:Number of diagnoses on this discharge"
 DX1       "I:Principal diagnosis"
 DXV1      "I:Validity flag: principal diagnosis"
 DCCHPR1   "I:CCHPR: principal diagnosis"
 NPR       "I:Number of procedures on this discharge"
 PR1       "I:Principal procedure"
 PRV1      "I:Validity flag: principal procedure"
 PCCHPR1   "I:CCHPR: principal procedure"
 DRG       "I:DRG in effect on discharge date"
 MDC       "I:MDC in effect on discharge date"
 DRGVER    "I:DRG grouper version used on disch date"
 DRG10     "I:DRG, Version 10"
 MDC10     "I:MDC, Version 10"
 PAY1      "I:Primary expected payer, uniform"
 TOTCHG    "I:Total charges (cleaned)"
 PROCESS   "I:HCUP-3 discharge processing ID number"
 YEAR      "Calendar year"
 DSHOSPID  "I:Data source hospital ID number"
 DSNUM     "I:Data source ID number"
 DSTYPE    "I:Data source type"
 HOSPST    "Hospital state postal code"
 ADAYWK    "I:Admission day of week"
 AMONTH    "I:Admission month"
 LOS_X     "I:Length of stay (uncleaned)"
 NEOMAT    "I:Neonatal and/or maternal DX and/or PR"
 DXSYS     "I:Diagnosis coding system"
 DSNDX     "I:Max number of diagnoses from source"
 PRSYS     "I:Procedure coding system"
 DSNPR     "I:Max number of procedures from source"
 PRDAY1    "I:No. of days from admission to PR1"
 PAY1_N    "I:Primary expected payer, nonuniform"
 PAY2      "I:Secondary expected payer, uniform"
 PAY2_N    "I:Secondary expected payer, nonuniform"
 TOTCHG_X  "I:Total charges (from data source)"
 DX2       "I:Diagnosis 2"
 DX3       "I:Diagnosis 3"
 DX4       "I:Diagnosis 4"
 DX5       "I:Diagnosis 5"
 DX6       "I:Diagnosis 6"
 DX7       "I:Diagnosis 7"
 DX8       "I:Diagnosis 8"
 DX9       "I:Diagnosis 9"
 DX10      "I:Diagnosis 10"
 DX11      "I:Diagnosis 11"
 DXV2      "I:Validity flag: diagnosis 2"
 DXV3      "I:Validity flag: diagnosis 3"
 DXV4      "I:Validity flag: diagnosis 4"
 DXV5      "I:Validity flag: diagnosis 5"
 DXV6      "I:Validity flag: diagnosis 6"
 DXV7      "I:Validity flag: diagnosis 7"
 DXV8      "I:Validity flag: diagnosis 8"
 DXV9      "I:Validity flag: diagnosis 9"
 DXV10     "I:Validity flag: diagnosis 10"
 DXV11     "I:Validity flag: diagnosis 11"
 DCCHPR2   "I:CCHPR: diagnosis 2"
 DCCHPR3   "I:CCHPR: diagnosis 3"
 DCCHPR4   "I:CCHPR: diagnosis 4"
 DCCHPR5   "I:CCHPR: diagnosis 5"
 DCCHPR6   "I:CCHPR: diagnosis 6"
 DCCHPR7   "I:CCHPR: diagnosis 7"
 DCCHPR8   "I:CCHPR: diagnosis 8"
 DCCHPR9   "I:CCHPR: diagnosis 9"
 DCCHPR10  "I:CCHPR: diagnosis 10"
 DCCHPR11  "I:CCHPR: diagnosis 11"
 PR2       "I:Procedure 2"
 PR3       "I:Procedure 3"
 PR4       "I:Procedure 4"
 PR5       "I:Procedure 5"
 PR6       "I:Procedure 6"
 PR7       "I:Procedure 7"
 PR8       "I:Procedure 8"
 PR9       "I:Procedure 9"
 PR10      "I:Procedure 10"
 PRV2      "I:Validity flag: procedure 2"
 PRV3      "I:Validity flag: procedure 3"
 PRV4      "I:Validity flag: procedure 4"
 PRV5      "I:Validity flag: procedure 5"
 PRV6      "I:Validity flag: procedure 6"
 PRV7      "I:Validity flag: procedure 7"
 PRV8      "I:Validity flag: procedure 8"
 PRV9      "I:Validity flag: procedure 9"
 PRV10     "I:Validity flag: procedure 10"
 PCCHPR2   "I:CCHPR: procedure 2"
 PCCHPR3   "I:CCHPR: procedure 3"
 PCCHPR4   "I:CCHPR: procedure 4"
 PCCHPR5   "I:CCHPR: procedure 5"
 PCCHPR6   "I:CCHPR: procedure 6"
 PCCHPR7   "I:CCHPR: procedure 7"
 PCCHPR8   "I:CCHPR: procedure 8"
 PCCHPR9   "I:CCHPR: procedure 9"
 PCCHPR10  "I:CCHPR: procedure 10"
 PRDAY2    "I:No. of days from admission to PR2"
 PRDAY3    "I:No. of days from admission to PR3"
 PAY1_X    "I:Primary exp. payer (from data source)"
 PAY2_X    "I:Secondary exp. payer (from data source"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 PRMNTH1   "Month of procedure 1"
 PRMNTH2   "Month of procedure 2"
 PRMNTH3   "Month of procedure 3"
 PRYEAR1   "Year of procedure 1"
 PRYEAR2   "Year of procedure 2"
 PRYEAR3   "Year of procedure 3" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE SEX
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE DISP
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE DXV1
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PRV1
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG10
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC10
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE DSNUM
 (-99,-88,-66,-55=SYSMIS).
RECODE DSTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE ADAYWK
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS_X
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE DXSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNDX
 (-99,-88,-66,-55=SYSMIS).
RECODE PRSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNPR
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PAY1_N
 (-99,-88,-66,-55=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2_N
 (-99,-88,-66,-55=SYSMIS).
RECODE TOTCHG_X
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE DXV2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV11
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRV2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV10
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MA_SID_1994_CORE.SAV' /COMPRESSED.
