/*******************************************************************
*   HI_SEDD_2006_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'HI_SEDD_2006_CORE.ASC' FIXED / 
 KEY                        1-  14
 AGEDAY                    15-  17
 AGEMONTH                  18-  20
 AMONTH                    21-  22
 ASOURCE                   23-  24
 ASOURCE_                  25     (A)
 ASOURCEU                  26     (A)
 ATYPE                     27-  28
 AWEEKEND                  29-  30
 CPT1                      31-  35 (A)
 CPT2                      36-  40 (A)
 CPT3                      41-  45 (A)
 CPT4                      46-  50 (A)
 CPT5                      51-  55 (A)
 CPT6                      56-  60 (A)
 CPT7                      61-  65 (A)
 CPT8                      66-  70 (A)
 CPT9                      71-  75 (A)
 CPT10                     76-  80 (A)
 CPT11                     81-  85 (A)
 CPT12                     86-  90 (A)
 CPT13                     91-  95 (A)
 CPT14                     96- 100 (A)
 CPT15                    101- 105 (A)
 CPT16                    106- 110 (A)
 CPT17                    111- 115 (A)
 CPT18                    116- 120 (A)
 CPT19                    121- 125 (A)
 CPT20                    126- 130 (A)
 CPTM1_1                  131- 132 (A)
 CPTM1_2                  133- 134 (A)
 CPTM1_3                  135- 136 (A)
 CPTM1_4                  137- 138 (A)
 CPTM1_5                  139- 140 (A)
 CPTM1_6                  141- 142 (A)
 CPTM1_7                  143- 144 (A)
 CPTM1_8                  145- 146 (A)
 CPTM1_9                  147- 148 (A)
 CPTM1_10                 149- 150 (A)
 CPTM1_11                 151- 152 (A)
 CPTM1_12                 153- 154 (A)
 CPTM1_13                 155- 156 (A)
 CPTM1_14                 157- 158 (A)
 CPTM1_15                 159- 160 (A)
 CPTM1_16                 161- 162 (A)
 CPTM1_17                 163- 164 (A)
 CPTM1_18                 165- 166 (A)
 CPTM1_19                 167- 168 (A)
 CPTM1_20                 169- 170 (A)
 CPTM2_1                  171- 172 (A)
 CPTM2_2                  173- 174 (A)
 CPTM2_3                  175- 176 (A)
 CPTM2_4                  177- 178 (A)
 CPTM2_5                  179- 180 (A)
 CPTM2_6                  181- 182 (A)
 CPTM2_7                  183- 184 (A)
 CPTM2_8                  185- 186 (A)
 CPTM2_9                  187- 188 (A)
 CPTM2_10                 189- 190 (A)
 CPTM2_11                 191- 192 (A)
 CPTM2_12                 193- 194 (A)
 CPTM2_13                 195- 196 (A)
 CPTM2_14                 197- 198 (A)
 CPTM2_15                 199- 200 (A)
 CPTM2_16                 201- 202 (A)
 CPTM2_17                 203- 204 (A)
 CPTM2_18                 205- 206 (A)
 CPTM2_19                 207- 208 (A)
 CPTM2_20                 209- 210 (A)
 DIED                     211- 212
 DISP_X                   213- 214 (A)
 DISPUB92                 215- 216
 DISPUNIF                 217- 218
 DQTR                     219- 220
 DX1                      221- 225 (A)
 DX2                      226- 230 (A)
 DX3                      231- 235 (A)
 DX4                      236- 240 (A)
 DX5                      241- 245 (A)
 DX6                      246- 250 (A)
 DX7                      251- 255 (A)
 DX8                      256- 260 (A)
 DX9                      261- 265 (A)
 DX10                     266- 270 (A)
 DXCCS1                   271- 274
 DXCCS2                   275- 278
 DXCCS3                   279- 282
 DXCCS4                   283- 286
 DXCCS5                   287- 290
 DXCCS6                   291- 294
 DXCCS7                   295- 298
 DXCCS8                   299- 302
 DXCCS9                   303- 306
 DXCCS10                  307- 310
 ECODE1                   311- 315 (A)
 ECODE2                   316- 320 (A)
 ECODE3                   321- 325 (A)
 ECODE4                   326- 330 (A)
 ECODE5                   331- 335 (A)
 E_CCS1                   336- 339
 E_CCS2                   340- 343
 E_CCS3                   344- 347
 E_CCS4                   348- 351
 E_CCS5                   352- 355
 FEMALE                   356- 357
 HCUP_AS                  358- 359
 HCUP_ED                  360- 361
 HCUP_OS                  362- 363
 HOSPBRTH                 364- 366
 HOSPST                   367- 368 (A)
 LOS                      369- 373
 LOS_X                    374- 379
 MEDINCST                 380- 381
 MRN_R                    382- 390
 NCPT                     391- 393
 NDX                      394- 395
 NECODE                   396- 397
 NEOMAT                   398- 399
 NPR                      400- 401
 PAY1                     402- 403
 PAY1_X                   404- 405 (A)
 PL_CBSA                  406- 408
 PL_MSA19                 409- 411
 PL_NHCS2                 412- 413
 PL_RUCA1                 414- 415
 PL_RUCA2                 416- 419
 PL_RUCA4                 420- 421
 PL_RUCC2                 422- 423
 PL_UIC20                 424- 425
 PL_UR_CA                 426- 427
 PL_UR_CA                 428- 429
 PNUM_R                   430- 438
 PR1                      439- 442 (A)
 PR2                      443- 446 (A)
 PR3                      447- 450 (A)
 PR4                      451- 454 (A)
 PR5                      455- 458 (A)
 PR6                      459- 462 (A)
 PR7                      463- 466 (A)
 PR8                      467- 470 (A)
 PR9                      471- 474 (A)
 PR10                     475- 478 (A)
 PRCCS1                   479- 481
 PRCCS2                   482- 484
 PRCCS3                   485- 487
 PRCCS4                   488- 490
 PRCCS5                   491- 493
 PRCCS6                   494- 496
 PRCCS7                   497- 499
 PRCCS8                   500- 502
 PRCCS9                   503- 505
 PRCCS10                  506- 508
 PRDAY1                   509- 513
 PRDAY2                   514- 518
 PRDAY3                   519- 523
 PRDAY4                   524- 528
 PRDAY5                   529- 533
 PRDAY6                   534- 538
 PRDAY7                   539- 543
 PRDAY8                   544- 548
 PRDAY9                   549- 553
 PRDAY10                  554- 558
 PROCTYPE                 559- 561
 PSTATE                   562- 563 (A)
 PSTCO2                   564- 568
 RACE                     569- 570
 RACE_X                   571- 572 (A)
 STATE_AS                 573- 574
 STATE_ED                 575- 576
 STATE_OS                 577- 578
 TOTCHG                   579- 588
 TOTCHG_X                 589- 603
 YEAR                     604- 607
 ZIPINC_Q                 608- 610
 HOSPID                   611- 615
 ZIP                      616- 620 (A)
 AGEGROUP                 621- 623
 AYEAR                    624- 627
 DMONTH                   628- 629
 BMONTH                   630- 631
 BYEAR                    632- 635
 PRMNTH1                  636- 637
 PRMNTH2                  638- 639
 PRMNTH3                  640- 641
 PRMNTH4                  642- 643
 PRMNTH5                  644- 645
 PRMNTH6                  646- 647
 PRMNTH7                  648- 649
 PRMNTH8                  650- 651
 PRMNTH9                  652- 653
 PRMNTH10                 654- 655
 PRYEAR1                  656- 659
 PRYEAR2                  660- 663
 PRYEAR3                  664- 667
 PRYEAR4                  668- 671
 PRYEAR5                  672- 675
 PRYEAR6                  676- 679
 PRYEAR7                  680- 683
 PRYEAR8                  684- 687
 PRYEAR9                  688- 691
 PRYEAR10                 692- 695.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUB92                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MEDINCST                (F3.0) /
 MRN_R                   (F5.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NHCS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PL_UR_CA                (F3.0) /
 PNUM_R                  (F5.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 HOSPID                  (F4.0) /
 AGEGROUP                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRMNTH2                 (F3.0) /
 PRMNTH3                 (F3.0) /
 PRMNTH4                 (F3.0) /
 PRMNTH5                 (F3.0) /
 PRMNTH6                 (F3.0) /
 PRMNTH7                 (F3.0) /
 PRMNTH8                 (F3.0) /
 PRMNTH9                 (F3.0) /
 PRMNTH10                (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 CPT16     "CPT/HCPCS procedure code 16"
 CPT17     "CPT/HCPCS procedure code 17"
 CPT18     "CPT/HCPCS procedure code 18"
 CPT19     "CPT/HCPCS procedure code 19"
 CPT20     "CPT/HCPCS procedure code 20"
 CPTM1_1   "First CPT-4/HCPCS modifier 1"
 CPTM1_2   "First CPT-4/HCPCS modifier 2"
 CPTM1_3   "First CPT-4/HCPCS modifier 3"
 CPTM1_4   "First CPT-4/HCPCS modifier 4"
 CPTM1_5   "First CPT-4/HCPCS modifier 5"
 CPTM1_6   "First CPT-4/HCPCS modifier 6"
 CPTM1_7   "First CPT-4/HCPCS modifier 7"
 CPTM1_8   "First CPT-4/HCPCS modifier 8"
 CPTM1_9   "First CPT-4/HCPCS modifier 9"
 CPTM1_10  "First CPT-4/HCPCS modifier 10"
 CPTM1_11  "First CPT-4/HCPCS modifier 11"
 CPTM1_12  "First CPT-4/HCPCS modifier 12"
 CPTM1_13  "First CPT-4/HCPCS modifier 13"
 CPTM1_14  "First CPT-4/HCPCS modifier 14"
 CPTM1_15  "First CPT-4/HCPCS modifier 15"
 CPTM1_16  "First CPT-4/HCPCS modifier 16"
 CPTM1_17  "First CPT-4/HCPCS modifier 17"
 CPTM1_18  "First CPT-4/HCPCS modifier 18"
 CPTM1_19  "First CPT-4/HCPCS modifier 19"
 CPTM1_20  "First CPT-4/HCPCS modifier 20"
 CPTM2_1   "Second CPT-4/HCPCS modifier 1"
 CPTM2_2   "Second CPT-4/HCPCS modifier 2"
 CPTM2_3   "Second CPT-4/HCPCS modifier 3"
 CPTM2_4   "Second CPT-4/HCPCS modifier 4"
 CPTM2_5   "Second CPT-4/HCPCS modifier 5"
 CPTM2_6   "Second CPT-4/HCPCS modifier 6"
 CPTM2_7   "Second CPT-4/HCPCS modifier 7"
 CPTM2_8   "Second CPT-4/HCPCS modifier 8"
 CPTM2_9   "Second CPT-4/HCPCS modifier 9"
 CPTM2_10  "Second CPT-4/HCPCS modifier 10"
 CPTM2_11  "Second CPT-4/HCPCS modifier 11"
 CPTM2_12  "Second CPT-4/HCPCS modifier 12"
 CPTM2_13  "Second CPT-4/HCPCS modifier 13"
 CPTM2_14  "Second CPT-4/HCPCS modifier 14"
 CPTM2_15  "Second CPT-4/HCPCS modifier 15"
 CPTM2_16  "Second CPT-4/HCPCS modifier 16"
 CPTM2_17  "Second CPT-4/HCPCS modifier 17"
 CPTM2_18  "Second CPT-4/HCPCS modifier 18"
 CPTM2_19  "Second CPT-4/HCPCS modifier 19"
 CPTM2_20  "Second CPT-4/HCPCS modifier 20"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 MRN_R     "Medical record number (re-identified)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NHCS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CA  "Patient Location: Urban-Rural 5 Categories"
 PNUM_R    "Person number (re-identified)"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRDAY1    "Number of days from admission to PR1"
 PRDAY2    "Number of days from admission to PR2"
 PRDAY3    "Number of days from admission to PR3"
 PRDAY4    "Number of days from admission to PR4"
 PRDAY5    "Number of days from admission to PR5"
 PRDAY6    "Number of days from admission to PR6"
 PRDAY7    "Number of days from admission to PR7"
 PRDAY8    "Number of days from admission to PR8"
 PRDAY9    "Number of days from admission to PR9"
 PRDAY10   "Number of days from admission to PR10"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 HOSPID    "HCUP hospital identification number"
 ZIP       "Patient ZIP Code"
 AGEGROUP  "Age Group"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRMNTH2   "Month of procedure 2"
 PRMNTH3   "Month of procedure 3"
 PRMNTH4   "Month of procedure 4"
 PRMNTH5   "Month of procedure 5"
 PRMNTH6   "Month of procedure 6"
 PRMNTH7   "Month of procedure 7"
 PRMNTH8   "Month of procedure 8"
 PRMNTH9   "Month of procedure 9"
 PRMNTH10  "Month of procedure 10"
 PRYEAR1   "Year of procedure 1"
 PRYEAR2   "Year of procedure 2"
 PRYEAR3   "Year of procedure 3"
 PRYEAR4   "Year of procedure 4"
 PRYEAR5   "Year of procedure 5"
 PRYEAR6   "Year of procedure 6"
 PRYEAR7   "Year of procedure 7"
 PRYEAR8   "Year of procedure 8"
 PRYEAR9   "Year of procedure 9"
 PRYEAR10  "Year of procedure 10" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NHCS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEGROUP
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'HI_SEDD_2006_CORE.SAV' /COMPRESSED.
