/*******************************************************************
*   WI_SEDD_2008_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'WI_SEDD_2008_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 ATYPE                     12-  13
 AWEEKEND                  14-  15
 BILLTYPE                  16-  19 (A)
 CPT1                      20-  24 (A)
 CPT2                      25-  29 (A)
 CPT3                      30-  34 (A)
 CPT4                      35-  39 (A)
 CPT5                      40-  44 (A)
 CPT6                      45-  49 (A)
 CPT7                      50-  54 (A)
 CPT8                      55-  59 (A)
 CPT9                      60-  64 (A)
 CPT10                     65-  69 (A)
 CPT11                     70-  74 (A)
 CPT12                     75-  79 (A)
 CPT13                     80-  84 (A)
 CPT14                     85-  89 (A)
 CPT15                     90-  94 (A)
 CPT16                     95-  99 (A)
 CPT17                    100- 104 (A)
 CPT18                    105- 109 (A)
 CPT19                    110- 114 (A)
 CPT20                    115- 119 (A)
 CPT21                    120- 124 (A)
 CPT22                    125- 129 (A)
 CPT23                    130- 134 (A)
 CPT24                    135- 139 (A)
 CPT25                    140- 144 (A)
 CPT26                    145- 149 (A)
 CPT27                    150- 154 (A)
 CPT28                    155- 159 (A)
 CPT29                    160- 164 (A)
 CPT30                    165- 169 (A)
 CPTCCS1                  170- 172
 CPTCCS2                  173- 175
 CPTCCS3                  176- 178
 CPTCCS4                  179- 181
 CPTCCS5                  182- 184
 CPTCCS6                  185- 187
 CPTCCS7                  188- 190
 CPTCCS8                  191- 193
 CPTCCS9                  194- 196
 CPTCCS10                 197- 199
 CPTCCS11                 200- 202
 CPTCCS12                 203- 205
 CPTCCS13                 206- 208
 CPTCCS14                 209- 211
 CPTCCS15                 212- 214
 CPTCCS16                 215- 217
 CPTCCS17                 218- 220
 CPTCCS18                 221- 223
 CPTCCS19                 224- 226
 CPTCCS20                 227- 229
 CPTCCS21                 230- 232
 CPTCCS22                 233- 235
 CPTCCS23                 236- 238
 CPTCCS24                 239- 241
 CPTCCS25                 242- 244
 CPTCCS26                 245- 247
 CPTCCS27                 248- 250
 CPTCCS28                 251- 253
 CPTCCS29                 254- 256
 CPTCCS30                 257- 259
 CPTM1_1                  260- 261 (A)
 CPTM1_2                  262- 263 (A)
 CPTM1_3                  264- 265 (A)
 CPTM1_4                  266- 267 (A)
 CPTM1_5                  268- 269 (A)
 CPTM1_6                  270- 271 (A)
 CPTM1_7                  272- 273 (A)
 CPTM1_8                  274- 275 (A)
 CPTM1_9                  276- 277 (A)
 CPTM1_10                 278- 279 (A)
 CPTM1_11                 280- 281 (A)
 CPTM1_12                 282- 283 (A)
 CPTM1_13                 284- 285 (A)
 CPTM1_14                 286- 287 (A)
 CPTM1_15                 288- 289 (A)
 CPTM1_16                 290- 291 (A)
 CPTM1_17                 292- 293 (A)
 CPTM1_18                 294- 295 (A)
 CPTM1_19                 296- 297 (A)
 CPTM1_20                 298- 299 (A)
 CPTM1_21                 300- 301 (A)
 CPTM1_22                 302- 303 (A)
 CPTM1_23                 304- 305 (A)
 CPTM1_24                 306- 307 (A)
 CPTM1_25                 308- 309 (A)
 CPTM1_26                 310- 311 (A)
 CPTM1_27                 312- 313 (A)
 CPTM1_28                 314- 315 (A)
 CPTM1_29                 316- 317 (A)
 CPTM1_30                 318- 319 (A)
 CPTM2_1                  320- 321 (A)
 CPTM2_2                  322- 323 (A)
 CPTM2_3                  324- 325 (A)
 CPTM2_4                  326- 327 (A)
 CPTM2_5                  328- 329 (A)
 CPTM2_6                  330- 331 (A)
 CPTM2_7                  332- 333 (A)
 CPTM2_8                  334- 335 (A)
 CPTM2_9                  336- 337 (A)
 CPTM2_10                 338- 339 (A)
 CPTM2_11                 340- 341 (A)
 CPTM2_12                 342- 343 (A)
 CPTM2_13                 344- 345 (A)
 CPTM2_14                 346- 347 (A)
 CPTM2_15                 348- 349 (A)
 CPTM2_16                 350- 351 (A)
 CPTM2_17                 352- 353 (A)
 CPTM2_18                 354- 355 (A)
 CPTM2_19                 356- 357 (A)
 CPTM2_20                 358- 359 (A)
 CPTM2_21                 360- 361 (A)
 CPTM2_22                 362- 363 (A)
 CPTM2_23                 364- 365 (A)
 CPTM2_24                 366- 367 (A)
 CPTM2_25                 368- 369 (A)
 CPTM2_26                 370- 371 (A)
 CPTM2_27                 372- 373 (A)
 CPTM2_28                 374- 375 (A)
 CPTM2_29                 376- 377 (A)
 CPTM2_30                 378- 379 (A)
 DIED                     380- 381
 DISPUB04                 382- 383
 DISPUNIF                 384- 385
 DISP_X                   386- 387 (A)
 DQTR                     388- 389
 DSHOSPID                 390- 402 (A)
 DX1                      403- 407 (A)
 DX2                      408- 412 (A)
 DX3                      413- 417 (A)
 DX4                      418- 422 (A)
 DX5                      423- 427 (A)
 DX6                      428- 432 (A)
 DX7                      433- 437 (A)
 DX8                      438- 442 (A)
 DX9                      443- 447 (A)
 DX10                     448- 452 (A)
 DX11                     453- 457 (A)
 DX12                     458- 462 (A)
 DX13                     463- 467 (A)
 DX14                     468- 472 (A)
 DX15                     473- 477 (A)
 DX16                     478- 482 (A)
 DX17                     483- 487 (A)
 DX18                     488- 492 (A)
 DX19                     493- 497 (A)
 DX20                     498- 502 (A)
 DX21                     503- 507 (A)
 DX22                     508- 512 (A)
 DX23                     513- 517 (A)
 DX24                     518- 522 (A)
 DX25                     523- 527 (A)
 DX26                     528- 532 (A)
 DX27                     533- 537 (A)
 DX28                     538- 542 (A)
 DX29                     543- 547 (A)
 DX30                     548- 552 (A)
 DXCCS1                   553- 556
 DXCCS2                   557- 560
 DXCCS3                   561- 564
 DXCCS4                   565- 568
 DXCCS5                   569- 572
 DXCCS6                   573- 576
 DXCCS7                   577- 580
 DXCCS8                   581- 584
 DXCCS9                   585- 588
 DXCCS10                  589- 592
 DXCCS11                  593- 596
 DXCCS12                  597- 600
 DXCCS13                  601- 604
 DXCCS14                  605- 608
 DXCCS15                  609- 612
 DXCCS16                  613- 616
 DXCCS17                  617- 620
 DXCCS18                  621- 624
 DXCCS19                  625- 628
 DXCCS20                  629- 632
 DXCCS21                  633- 636
 DXCCS22                  637- 640
 DXCCS23                  641- 644
 DXCCS24                  645- 648
 DXCCS25                  649- 652
 DXCCS26                  653- 656
 DXCCS27                  657- 660
 DXCCS28                  661- 664
 DXCCS29                  665- 668
 DXCCS30                  669- 672
 DX_Visit                 673- 677 (A)
 DX_Visit                 678- 682 (A)
 DX_Visit                 683- 687 (A)
 ECODE1                   688- 692 (A)
 ECODE2                   693- 697 (A)
 ECODE3                   698- 702 (A)
 ECODE4                   703- 707 (A)
 ECODE5                   708- 712 (A)
 ECODE6                   713- 717 (A)
 ECODE7                   718- 722 (A)
 ECODE8                   723- 727 (A)
 ECODE9                   728- 732 (A)
 ECODE10                  733- 737 (A)
 ECODE11                  738- 742 (A)
 ECODE12                  743- 747 (A)
 E_CCS1                   748- 751
 E_CCS2                   752- 755
 E_CCS3                   756- 759
 E_CCS4                   760- 763
 E_CCS5                   764- 767
 E_CCS6                   768- 771
 E_CCS7                   772- 775
 E_CCS8                   776- 779
 E_CCS9                   780- 783
 E_CCS10                  784- 787
 E_CCS11                  788- 791
 E_CCS12                  792- 795
 FEMALE                   796- 797
 HCUP_AS                  798- 799
 HCUP_ED                  800- 801
 HCUP_OS                  802- 803
 HISPANIC                 804     (A)
 HOSPBRTH                 805- 807
 HOSPST                   808- 809 (A)
 Homeless                 810- 811
 KEY                      812- 825
 LOS                      826- 830
 LOS_X                    831- 836
 MDSPEC1                  837- 839 (A)
 MDSPEC2                  840- 842 (A)
 MEDINCST                 843- 844
 MRN_R                    845- 853
 NCPT                     854- 856
 NDX                      857- 858
 NECODE                   859- 860
 NEOMAT                   861- 862
 NPR                      863- 864
 PAY1                     865- 866
 PAY1_X                   867- 871 (A)
 PAY2                     872- 873
 PAY2_X                   874- 878 (A)
 PL_CBSA                  879- 881
 PL_MSA19                 882- 884
 PL_NCHS2                 885- 886
 PL_RUCA1                 887- 888
 PL_RUCA2                 889- 892
 PL_RUCA4                 893- 894
 PL_RUCC2                 895- 896
 PL_UIC20                 897- 898
 PL_UR_CA                 899- 900
 PR1                      901- 904 (A)
 PR2                      905- 908 (A)
 PR3                      909- 912 (A)
 PR4                      913- 916 (A)
 PR5                      917- 920 (A)
 PR6                      921- 924 (A)
 PR7                      925- 928 (A)
 PR8                      929- 932 (A)
 PR9                      933- 936 (A)
 PR10                     937- 940 (A)
 PR11                     941- 944 (A)
 PR12                     945- 948 (A)
 PR13                     949- 952 (A)
 PR14                     953- 956 (A)
 PR15                     957- 960 (A)
 PR16                     961- 964 (A)
 PR17                     965- 968 (A)
 PR18                     969- 972 (A)
 PR19                     973- 976 (A)
 PR20                     977- 980 (A)
 PR21                     981- 984 (A)
 PR22                     985- 988 (A)
 PR23                     989- 992 (A)
 PR24                     993- 996 (A)
 PR25                     997-1000 (A)
 PR26                    1001-1004 (A)
 PR27                    1005-1008 (A)
 PR28                    1009-1012 (A)
 PR29                    1013-1016 (A)
 PR30                    1017-1020 (A)
 PRCCS1                  1021-1023
 PRCCS2                  1024-1026
 PRCCS3                  1027-1029
 PRCCS4                  1030-1032
 PRCCS5                  1033-1035
 PRCCS6                  1036-1038
 PRCCS7                  1039-1041
 PRCCS8                  1042-1044
 PRCCS9                  1045-1047
 PRCCS10                 1048-1050
 PRCCS11                 1051-1053
 PRCCS12                 1054-1056
 PRCCS13                 1057-1059
 PRCCS14                 1060-1062
 PRCCS15                 1063-1065
 PRCCS16                 1066-1068
 PRCCS17                 1069-1071
 PRCCS18                 1072-1074
 PRCCS19                 1075-1077
 PRCCS20                 1078-1080
 PRCCS21                 1081-1083
 PRCCS22                 1084-1086
 PRCCS23                 1087-1089
 PRCCS24                 1090-1092
 PRCCS25                 1093-1095
 PRCCS26                 1096-1098
 PRCCS27                 1099-1101
 PRCCS28                 1102-1104
 PRCCS29                 1105-1107
 PRCCS30                 1108-1110
 PRDAY1                  1111-1115
 PROCTYPE                1116-1118
 PSTATE                  1119-1120 (A)
 PSTCO2                  1121-1125
 POFOUB04                1126     (A)
 POFO_X                  1127     (A)
 RACE                    1128-1129
 RACE_X                  1130     (A)
 STATE_AS                1131-1132
 STATE_ED                1133-1134
 STATE_OS                1135-1136
 TOTCHG                  1137-1146
 TOTCHG_X                1147-1161
 YEAR                    1162-1165
 ZIPINC_Q                1166-1168
 ZIP                     1169-1173 (A)
 AYEAR                   1174-1177
 DMONTH                  1178-1179
 BMONTH                  1180-1181
 BYEAR                   1182-1185
 PRMNTH1                 1186-1187
 PRYEAR1                 1188-1191.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 CPTCCS21                (F4.0) /
 CPTCCS22                (F4.0) /
 CPTCCS23                (F4.0) /
 CPTCCS24                (F4.0) /
 CPTCCS25                (F4.0) /
 CPTCCS26                (F4.0) /
 CPTCCS27                (F4.0) /
 CPTCCS28                (F4.0) /
 CPTCCS29                (F4.0) /
 CPTCCS30                (F4.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 E_CCS9                  (F3.0) /
 E_CCS10                 (F3.0) /
 E_CCS11                 (F3.0) /
 E_CCS12                 (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Homeless                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MEDINCST                (F3.0) /
 MRN_R                   (F5.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NCHS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRCCS26                 (F3.0) /
 PRCCS27                 (F3.0) /
 PRCCS28                 (F3.0) /
 PRCCS29                 (F3.0) /
 PRCCS30                 (F3.0) /
 PRDAY1                  (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRYEAR1                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 BILLTYPE  "UB-92 bill type"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 CPT16     "CPT/HCPCS procedure code 16"
 CPT17     "CPT/HCPCS procedure code 17"
 CPT18     "CPT/HCPCS procedure code 18"
 CPT19     "CPT/HCPCS procedure code 19"
 CPT20     "CPT/HCPCS procedure code 20"
 CPT21     "CPT/HCPCS procedure code 21"
 CPT22     "CPT/HCPCS procedure code 22"
 CPT23     "CPT/HCPCS procedure code 23"
 CPT24     "CPT/HCPCS procedure code 24"
 CPT25     "CPT/HCPCS procedure code 25"
 CPT26     "CPT/HCPCS procedure code 26"
 CPT27     "CPT/HCPCS procedure code 27"
 CPT28     "CPT/HCPCS procedure code 28"
 CPT29     "CPT/HCPCS procedure code 29"
 CPT30     "CPT/HCPCS procedure code 30"
 CPTCCS1   "CCS: CPT 1"
 CPTCCS2   "CCS: CPT 2"
 CPTCCS3   "CCS: CPT 3"
 CPTCCS4   "CCS: CPT 4"
 CPTCCS5   "CCS: CPT 5"
 CPTCCS6   "CCS: CPT 6"
 CPTCCS7   "CCS: CPT 7"
 CPTCCS8   "CCS: CPT 8"
 CPTCCS9   "CCS: CPT 9"
 CPTCCS10  "CCS: CPT 10"
 CPTCCS11  "CCS: CPT 11"
 CPTCCS12  "CCS: CPT 12"
 CPTCCS13  "CCS: CPT 13"
 CPTCCS14  "CCS: CPT 14"
 CPTCCS15  "CCS: CPT 15"
 CPTCCS16  "CCS: CPT 16"
 CPTCCS17  "CCS: CPT 17"
 CPTCCS18  "CCS: CPT 18"
 CPTCCS19  "CCS: CPT 19"
 CPTCCS20  "CCS: CPT 20"
 CPTCCS21  "CCS: CPT 21"
 CPTCCS22  "CCS: CPT 22"
 CPTCCS23  "CCS: CPT 23"
 CPTCCS24  "CCS: CPT 24"
 CPTCCS25  "CCS: CPT 25"
 CPTCCS26  "CCS: CPT 26"
 CPTCCS27  "CCS: CPT 27"
 CPTCCS28  "CCS: CPT 28"
 CPTCCS29  "CCS: CPT 29"
 CPTCCS30  "CCS: CPT 30"
 CPTM1_1   "First CPT-4/HCPCS modifier 1"
 CPTM1_2   "First CPT-4/HCPCS modifier 2"
 CPTM1_3   "First CPT-4/HCPCS modifier 3"
 CPTM1_4   "First CPT-4/HCPCS modifier 4"
 CPTM1_5   "First CPT-4/HCPCS modifier 5"
 CPTM1_6   "First CPT-4/HCPCS modifier 6"
 CPTM1_7   "First CPT-4/HCPCS modifier 7"
 CPTM1_8   "First CPT-4/HCPCS modifier 8"
 CPTM1_9   "First CPT-4/HCPCS modifier 9"
 CPTM1_10  "First CPT-4/HCPCS modifier 10"
 CPTM1_11  "First CPT-4/HCPCS modifier 11"
 CPTM1_12  "First CPT-4/HCPCS modifier 12"
 CPTM1_13  "First CPT-4/HCPCS modifier 13"
 CPTM1_14  "First CPT-4/HCPCS modifier 14"
 CPTM1_15  "First CPT-4/HCPCS modifier 15"
 CPTM1_16  "First CPT-4/HCPCS modifier 16"
 CPTM1_17  "First CPT-4/HCPCS modifier 17"
 CPTM1_18  "First CPT-4/HCPCS modifier 18"
 CPTM1_19  "First CPT-4/HCPCS modifier 19"
 CPTM1_20  "First CPT-4/HCPCS modifier 20"
 CPTM1_21  "First CPT-4/HCPCS modifier 21"
 CPTM1_22  "First CPT-4/HCPCS modifier 22"
 CPTM1_23  "First CPT-4/HCPCS modifier 23"
 CPTM1_24  "First CPT-4/HCPCS modifier 24"
 CPTM1_25  "First CPT-4/HCPCS modifier 25"
 CPTM1_26  "First CPT-4/HCPCS modifier 26"
 CPTM1_27  "First CPT-4/HCPCS modifier 27"
 CPTM1_28  "First CPT-4/HCPCS modifier 28"
 CPTM1_29  "First CPT-4/HCPCS modifier 29"
 CPTM1_30  "First CPT-4/HCPCS modifier 30"
 CPTM2_1   "Second CPT-4/HCPCS modifier 1"
 CPTM2_2   "Second CPT-4/HCPCS modifier 2"
 CPTM2_3   "Second CPT-4/HCPCS modifier 3"
 CPTM2_4   "Second CPT-4/HCPCS modifier 4"
 CPTM2_5   "Second CPT-4/HCPCS modifier 5"
 CPTM2_6   "Second CPT-4/HCPCS modifier 6"
 CPTM2_7   "Second CPT-4/HCPCS modifier 7"
 CPTM2_8   "Second CPT-4/HCPCS modifier 8"
 CPTM2_9   "Second CPT-4/HCPCS modifier 9"
 CPTM2_10  "Second CPT-4/HCPCS modifier 10"
 CPTM2_11  "Second CPT-4/HCPCS modifier 11"
 CPTM2_12  "Second CPT-4/HCPCS modifier 12"
 CPTM2_13  "Second CPT-4/HCPCS modifier 13"
 CPTM2_14  "Second CPT-4/HCPCS modifier 14"
 CPTM2_15  "Second CPT-4/HCPCS modifier 15"
 CPTM2_16  "Second CPT-4/HCPCS modifier 16"
 CPTM2_17  "Second CPT-4/HCPCS modifier 17"
 CPTM2_18  "Second CPT-4/HCPCS modifier 18"
 CPTM2_19  "Second CPT-4/HCPCS modifier 19"
 CPTM2_20  "Second CPT-4/HCPCS modifier 20"
 CPTM2_21  "Second CPT-4/HCPCS modifier 21"
 CPTM2_22  "Second CPT-4/HCPCS modifier 22"
 CPTM2_23  "Second CPT-4/HCPCS modifier 23"
 CPTM2_24  "Second CPT-4/HCPCS modifier 24"
 CPTM2_25  "Second CPT-4/HCPCS modifier 25"
 CPTM2_26  "Second CPT-4/HCPCS modifier 26"
 CPTM2_27  "Second CPT-4/HCPCS modifier 27"
 CPTM2_28  "Second CPT-4/HCPCS modifier 28"
 CPTM2_29  "Second CPT-4/HCPCS modifier 29"
 CPTM2_30  "Second CPT-4/HCPCS modifier 30"
 DIED      "Died during hospitalization"
 DISPUB04  "Disposition of patient (UB-04 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DISP_X    "Disposition of patient (as received from source)"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Diagnosis 1"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX17      "Diagnosis 17"
 DX18      "Diagnosis 18"
 DX19      "Diagnosis 19"
 DX20      "Diagnosis 20"
 DX21      "Diagnosis 21"
 DX22      "Diagnosis 22"
 DX23      "Diagnosis 23"
 DX24      "Diagnosis 24"
 DX25      "Diagnosis 25"
 DX26      "Diagnosis 26"
 DX27      "Diagnosis 27"
 DX28      "Diagnosis 28"
 DX29      "Diagnosis 29"
 DX30      "Diagnosis 30"
 DXCCS1    "CCS: diagnosis 1"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 DXCCS17   "CCS: diagnosis 17"
 DXCCS18   "CCS: diagnosis 18"
 DXCCS19   "CCS: diagnosis 19"
 DXCCS20   "CCS: diagnosis 20"
 DXCCS21   "CCS: diagnosis 21"
 DXCCS22   "CCS: diagnosis 22"
 DXCCS23   "CCS: diagnosis 23"
 DXCCS24   "CCS: diagnosis 24"
 DXCCS25   "CCS: diagnosis 25"
 DXCCS26   "CCS: diagnosis 26"
 DXCCS27   "CCS: diagnosis 27"
 DXCCS28   "CCS: diagnosis 28"
 DXCCS29   "CCS: diagnosis 29"
 DXCCS30   "CCS: diagnosis 30"
 DX_Visit  "Reason for visit diagnosis 1"
 DX_Visit  "Reason for visit diagnosis 2"
 DX_Visit  "Reason for visit diagnosis 3"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 ECODE7    "E code 7"
 ECODE8    "E code 8"
 ECODE9    "E code 9"
 ECODE10   "E code 10"
 ECODE11   "E code 11"
 ECODE12   "E code 12"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 E_CCS7    "CCS: E Code 7"
 E_CCS8    "CCS: E Code 8"
 E_CCS9    "CCS: E Code 9"
 E_CCS10   "CCS: E Code 10"
 E_CCS11   "CCS: E Code 11"
 E_CCS12   "CCS: E Code 12"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HISPANIC  "Hispanic ethnicity (as received from source)"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 Homeless  "Indicator that patient is homeless"
 KEY       "HCUP record identifier"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDSPEC1   "Physician 1 specialty (as received from source)"
 MDSPEC2   "Physician 2 specialty (as received from source)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 MRN_R     "Medical record number (re-identified)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2      "Secondary expected payer (uniform)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PR1       "Procedure 1"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PR16      "Procedure 16"
 PR17      "Procedure 17"
 PR18      "Procedure 18"
 PR19      "Procedure 19"
 PR20      "Procedure 20"
 PR21      "Procedure 21"
 PR22      "Procedure 22"
 PR23      "Procedure 23"
 PR24      "Procedure 24"
 PR25      "Procedure 25"
 PR26      "Procedure 26"
 PR27      "Procedure 27"
 PR28      "Procedure 28"
 PR29      "Procedure 29"
 PR30      "Procedure 30"
 PRCCS1    "CCS: procedure 1"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRCCS16   "CCS: procedure 16"
 PRCCS17   "CCS: procedure 17"
 PRCCS18   "CCS: procedure 18"
 PRCCS19   "CCS: procedure 19"
 PRCCS20   "CCS: procedure 20"
 PRCCS21   "CCS: procedure 21"
 PRCCS22   "CCS: procedure 22"
 PRCCS23   "CCS: procedure 23"
 PRCCS24   "CCS: procedure 24"
 PRCCS25   "CCS: procedure 25"
 PRCCS26   "CCS: procedure 26"
 PRCCS27   "CCS: procedure 27"
 PRCCS28   "CCS: procedure 28"
 PRCCS29   "CCS: procedure 29"
 PRCCS30   "CCS: procedure 30"
 PRDAY1    "Number of days from admission to PR1"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 POFOUB04  "Point of origin for admission or visit, UB-04 standard coding"
 POFO_X    "Point of origin for admission or visit, as received from source"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRYEAR1   "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'WI_SEDD_2008_CORE.SAV' /COMPRESSED.
