/*******************************************************************
*   VT_SEDD_2007_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'VT_SEDD_2007_DX_PR_GRPS.ASC' FIXED / 
 CHRON1                     1-   2
 CHRON2                     3-   4
 CHRON3                     5-   6
 CHRON4                     7-   8
 CHRON5                     9-  10
 CHRON6                    11-  12
 CHRON7                    13-  14
 CHRON8                    15-  16
 CHRON9                    17-  18
 CHRON10                   19-  20
 CHRON11                   21-  22
 CHRON12                   23-  24
 CHRON13                   25-  26
 CHRON14                   27-  28
 CHRON15                   29-  30
 CHRON16                   31-  32
 CHRON17                   33-  34
 CHRON18                   35-  36
 CHRON19                   37-  38
 CHRON20                   39-  40
 CHRONB1                   41-  42
 CHRONB2                   43-  44
 CHRONB3                   45-  46
 CHRONB4                   47-  48
 CHRONB5                   49-  50
 CHRONB6                   51-  52
 CHRONB7                   53-  54
 CHRONB8                   55-  56
 CHRONB9                   57-  58
 CHRONB10                  59-  60
 CHRONB11                  61-  62
 CHRONB12                  63-  64
 CHRONB13                  65-  66
 CHRONB14                  67-  68
 CHRONB15                  69-  70
 CHRONB16                  71-  72
 CHRONB17                  73-  74
 CHRONB18                  75-  76
 CHRONB19                  77-  78
 CHRONB20                  79-  80
 DXMCCS1                   81-  91 (A)
 DXMCCS2                   92- 102 (A)
 DXMCCS3                  103- 113 (A)
 DXMCCS4                  114- 124 (A)
 DXMCCS5                  125- 135 (A)
 DXMCCS6                  136- 146 (A)
 DXMCCS7                  147- 157 (A)
 DXMCCS8                  158- 168 (A)
 DXMCCS9                  169- 179 (A)
 DXMCCS10                 180- 190 (A)
 DXMCCS11                 191- 201 (A)
 DXMCCS12                 202- 212 (A)
 DXMCCS13                 213- 223 (A)
 DXMCCS14                 224- 234 (A)
 DXMCCS15                 235- 245 (A)
 DXMCCS16                 246- 256 (A)
 DXMCCS17                 257- 267 (A)
 DXMCCS18                 268- 278 (A)
 DXMCCS19                 279- 289 (A)
 DXMCCS20                 290- 300 (A)
 E_MCCS1                  301- 311 (A)
 E_MCCS2                  312- 322 (A)
 E_MCCS3                  323- 333 (A)
 E_MCCS4                  334- 344 (A)
 E_MCCS5                  345- 355 (A)
 KEY                      356- 369
 PCLASS1                  370- 371
 PCLASS2                  372- 373
 PCLASS3                  374- 375
 PCLASS4                  376- 377
 PCLASS5                  378- 379
 PCLASS6                  380- 381
 PCLASS7                  382- 383
 PCLASS8                  384- 385
 PCLASS9                  386- 387
 PCLASS10                 388- 389
 PCLASS11                 390- 391
 PCLASS12                 392- 393
 PCLASS13                 394- 395
 PCLASS14                 396- 397
 PCLASS15                 398- 399
 PCLASS16                 400- 401
 PCLASS17                 402- 403
 PCLASS18                 404- 405
 PCLASS19                 406- 407
 PCLASS20                 408- 409
 PRMCCS1                  410- 417 (A)
 PRMCCS2                  418- 425 (A)
 PRMCCS3                  426- 433 (A)
 PRMCCS4                  434- 441 (A)
 PRMCCS5                  442- 449 (A)
 PRMCCS6                  450- 457 (A)
 PRMCCS7                  458- 465 (A)
 PRMCCS8                  466- 473 (A)
 PRMCCS9                  474- 481 (A)
 PRMCCS10                 482- 489 (A)
 PRMCCS11                 490- 497 (A)
 PRMCCS12                 498- 505 (A)
 PRMCCS13                 506- 513 (A)
 PRMCCS14                 514- 521 (A)
 PRMCCS15                 522- 529 (A)
 PRMCCS16                 530- 537 (A)
 PRMCCS17                 538- 545 (A)
 PRMCCS18                 546- 553 (A)
 PRMCCS19                 554- 561 (A)
 PRMCCS20                 562- 569 (A)
 U_BLOOD                  570- 571
 U_CATH                   572- 573
 U_CCU                    574- 575
 U_CHESTX                 576- 577
 U_CTSCAN                 578- 579
 U_DIALYS                 580- 581
 U_ECHO                   582- 583
 U_ED                     584- 585
 U_EEG                    586- 587
 U_EKG                    588- 589
 U_EPO                    590- 591
 U_ICU                    592- 593
 U_LITHOT                 594- 595
 U_MHSA                   596- 597
 U_MRT                    598- 599
 U_NEWBN2                 600- 601
 U_NEWBN3                 602- 603
 U_NEWBN4                 604- 605
 U_NUCMED                 606- 607
 U_OBSERV                 608- 609
 U_OCCTHE                 610- 611
 U_ORGANA                 612- 613
 U_OTHIMP                 614- 615
 U_PACEMA                 616- 617
 U_PHYTHE                 618- 619
 U_RADTHE                 620- 621
 U_RESPTH                 622- 623
 U_SPEECH                 624- 625
 U_STRESS                 626- 627
 U_ULTRAS                 628- 629.


***  Specify write formats  ***.
FORMATS
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRON10                 (F3.0) /
 CHRON11                 (F3.0) /
 CHRON12                 (F3.0) /
 CHRON13                 (F3.0) /
 CHRON14                 (F3.0) /
 CHRON15                 (F3.0) /
 CHRON16                 (F3.0) /
 CHRON17                 (F3.0) /
 CHRON18                 (F3.0) /
 CHRON19                 (F3.0) /
 CHRON20                 (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 CHRONB10                (F3.0) /
 CHRONB11                (F3.0) /
 CHRONB12                (F3.0) /
 CHRONB13                (F3.0) /
 CHRONB14                (F3.0) /
 CHRONB15                (F3.0) /
 CHRONB16                (F3.0) /
 CHRONB17                (F3.0) /
 CHRONB18                (F3.0) /
 CHRONB19                (F3.0) /
 CHRONB20                (F3.0) /
 KEY                     (F8.0) /
 PCLASS1                 (F3.0) /
 PCLASS2                 (F3.0) /
 PCLASS3                 (F3.0) /
 PCLASS4                 (F3.0) /
 PCLASS5                 (F3.0) /
 PCLASS6                 (F3.0) /
 PCLASS7                 (F3.0) /
 PCLASS8                 (F3.0) /
 PCLASS9                 (F3.0) /
 PCLASS10                (F3.0) /
 PCLASS11                (F3.0) /
 PCLASS12                (F3.0) /
 PCLASS13                (F3.0) /
 PCLASS14                (F3.0) /
 PCLASS15                (F3.0) /
 PCLASS16                (F3.0) /
 PCLASS17                (F3.0) /
 PCLASS18                (F3.0) /
 PCLASS19                (F3.0) /
 PCLASS20                (F3.0) /
 U_BLOOD                 (F3.0) /
 U_CATH                  (F3.0) /
 U_CCU                   (F3.0) /
 U_CHESTX                (F3.0) /
 U_CTSCAN                (F3.0) /
 U_DIALYS                (F3.0) /
 U_ECHO                  (F3.0) /
 U_ED                    (F3.0) /
 U_EEG                   (F3.0) /
 U_EKG                   (F3.0) /
 U_EPO                   (F3.0) /
 U_ICU                   (F3.0) /
 U_LITHOT                (F3.0) /
 U_MHSA                  (F3.0) /
 U_MRT                   (F3.0) /
 U_NEWBN2                (F3.0) /
 U_NEWBN3                (F3.0) /
 U_NEWBN4                (F3.0) /
 U_NUCMED                (F3.0) /
 U_OBSERV                (F3.0) /
 U_OCCTHE                (F3.0) /
 U_ORGANA                (F3.0) /
 U_OTHIMP                (F3.0) /
 U_PACEMA                (F3.0) /
 U_PHYTHE                (F3.0) /
 U_RADTHE                (F3.0) /
 U_RESPTH                (F3.0) /
 U_SPEECH                (F3.0) /
 U_STRESS                (F3.0) /
 U_ULTRAS                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1    "Chronic condition indicator 1"
 CHRON2    "Chronic condition indicator 2"
 CHRON3    "Chronic condition indicator 3"
 CHRON4    "Chronic condition indicator 4"
 CHRON5    "Chronic condition indicator 5"
 CHRON6    "Chronic condition indicator 6"
 CHRON7    "Chronic condition indicator 7"
 CHRON8    "Chronic condition indicator 8"
 CHRON9    "Chronic condition indicator 9"
 CHRON10   "Chronic condition indicator 10"
 CHRON11   "Chronic condition indicator 11"
 CHRON12   "Chronic condition indicator 12"
 CHRON13   "Chronic condition indicator 13"
 CHRON14   "Chronic condition indicator 14"
 CHRON15   "Chronic condition indicator 15"
 CHRON16   "Chronic condition indicator 16"
 CHRON17   "Chronic condition indicator 17"
 CHRON18   "Chronic condition indicator 18"
 CHRON19   "Chronic condition indicator 19"
 CHRON20   "Chronic condition indicator 20"
 CHRONB1   "Chronic condition body system 1"
 CHRONB2   "Chronic condition body system 2"
 CHRONB3   "Chronic condition body system 3"
 CHRONB4   "Chronic condition body system 4"
 CHRONB5   "Chronic condition body system 5"
 CHRONB6   "Chronic condition body system 6"
 CHRONB7   "Chronic condition body system 7"
 CHRONB8   "Chronic condition body system 8"
 CHRONB9   "Chronic condition body system 9"
 CHRONB10  "Chronic condition body system 10"
 CHRONB11  "Chronic condition body system 11"
 CHRONB12  "Chronic condition body system 12"
 CHRONB13  "Chronic condition body system 13"
 CHRONB14  "Chronic condition body system 14"
 CHRONB15  "Chronic condition body system 15"
 CHRONB16  "Chronic condition body system 16"
 CHRONB17  "Chronic condition body system 17"
 CHRONB18  "Chronic condition body system 18"
 CHRONB19  "Chronic condition body system 19"
 CHRONB20  "Chronic condition body system 20"
 DXMCCS1   "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2   "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3   "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4   "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5   "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6   "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7   "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8   "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9   "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10  "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11  "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12  "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13  "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14  "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15  "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16  "Multi-Level CCS:  Diagnosis 16"
 DXMCCS17  "Multi-Level CCS:  Diagnosis 17"
 DXMCCS18  "Multi-Level CCS:  Diagnosis 18"
 DXMCCS19  "Multi-Level CCS:  Diagnosis 19"
 DXMCCS20  "Multi-Level CCS:  Diagnosis 20"
 E_MCCS1   "Multi-Level CCS:  E Code 1"
 E_MCCS2   "Multi-Level CCS:  E Code 2"
 E_MCCS3   "Multi-Level CCS:  E Code 3"
 E_MCCS4   "Multi-Level CCS:  E Code 4"
 E_MCCS5   "Multi-Level CCS:  E Code 5"
 KEY       "HCUP record identifier"
 PCLASS1   "Procedure class 1"
 PCLASS2   "Procedure class 2"
 PCLASS3   "Procedure class 3"
 PCLASS4   "Procedure class 4"
 PCLASS5   "Procedure class 5"
 PCLASS6   "Procedure class 6"
 PCLASS7   "Procedure class 7"
 PCLASS8   "Procedure class 8"
 PCLASS9   "Procedure class 9"
 PCLASS10  "Procedure class 10"
 PCLASS11  "Procedure class 11"
 PCLASS12  "Procedure class 12"
 PCLASS13  "Procedure class 13"
 PCLASS14  "Procedure class 14"
 PCLASS15  "Procedure class 15"
 PCLASS16  "Procedure class 16"
 PCLASS17  "Procedure class 17"
 PCLASS18  "Procedure class 18"
 PCLASS19  "Procedure class 19"
 PCLASS20  "Procedure class 20"
 PRMCCS1   "Multi-Level CCS:  Procedure 1"
 PRMCCS2   "Multi-Level CCS:  Procedure 2"
 PRMCCS3   "Multi-Level CCS:  Procedure 3"
 PRMCCS4   "Multi-Level CCS:  Procedure 4"
 PRMCCS5   "Multi-Level CCS:  Procedure 5"
 PRMCCS6   "Multi-Level CCS:  Procedure 6"
 PRMCCS7   "Multi-Level CCS:  Procedure 7"
 PRMCCS8   "Multi-Level CCS:  Procedure 8"
 PRMCCS9   "Multi-Level CCS:  Procedure 9"
 PRMCCS10  "Multi-Level CCS:  Procedure 10"
 PRMCCS11  "Multi-Level CCS:  Procedure 11"
 PRMCCS12  "Multi-Level CCS:  Procedure 12"
 PRMCCS13  "Multi-Level CCS:  Procedure 13"
 PRMCCS14  "Multi-Level CCS:  Procedure 14"
 PRMCCS15  "Multi-Level CCS:  Procedure 15"
 PRMCCS16  "Multi-Level CCS:  Procedure 16"
 PRMCCS17  "Multi-Level CCS:  Procedure 17"
 PRMCCS18  "Multi-Level CCS:  Procedure 18"
 PRMCCS19  "Multi-Level CCS:  Procedure 19"
 PRMCCS20  "Multi-Level CCS:  Procedure 20"
 U_BLOOD   "Utilization Flag: Blood"
 U_CATH    "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU     "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTX  "Utilization Flag: Chest X-Ray"
 U_CTSCAN  "Utilization Flag: Computed Tomography Scan"
 U_DIALYS  "Utilization Flag: Renal Dialysis"
 U_ECHO    "Utilization Flag: Echocardiology"
 U_ED      "Utilization Flag: Emergency Room"
 U_EEG     "Utilization Flag: Electroencephalogram"
 U_EKG     "Utilization Flag: Electrocardiogram"
 U_EPO     "Utilization Flag: EPO"
 U_ICU     "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOT  "Utilization Flag: Lithotripsy"
 U_MHSA    "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT     "Utilization Flag: Medical Resonance Technology"
 U_NEWBN2  "Utilization Flag: Nursery Level II"
 U_NEWBN3  "Utilization Flag: Nursery Level III"
 U_NEWBN4  "Utilization Flag: Nursery Level IV"
 U_NUCMED  "Utilization Flag: Nuclear Medicine"
 U_OBSERV  "Utilization Flag: Observation Room"
 U_OCCTHE  "Utilization Flag: Occupational Therapy"
 U_ORGANA  "Utilization Flag: Organ Acquisition"
 U_OTHIMP  "Utilization Flag: Other Implants"
 U_PACEMA  "Utilization Flag: Pacemaker"
 U_PHYTHE  "Utilization Flag: Physical Therapy"
 U_RADTHE  "Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTH  "Utilization Flag: Respiratory Services"
 U_SPEECH  "Utilization Flag: Speech - Language Pathology"
 U_STRESS  "Utilization Flag: Cardiac Stress Test"
 U_ULTRAS  "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB20
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS16
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS17
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS18
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS19
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS20
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTX
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERV
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHE
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMP
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHE
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHE
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRAS
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'VT_SEDD_2007_DX_PR_GRPS.SAV' /COMPRESSED.
