/*******************************************************************
*   NY_SEDD_2006_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NY_SEDD_2006_CHGS.ASC' FIXED / 
 KEY                        1-  18
 CHARGE                    19-  30
 CPTHCPCS                  31-  35 (A)
 CPTMod1                   36-  37 (A)
 CPTMod2                   38-  39 (A)
 REVCODE                   40-  43 (A).


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 CHARGE                  (F6.2) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY                     "HCUP record identifier"
 CHARGE                  "Line item charges (as received from source)"
 CPTHCPCS                "Line item CPT-4/HCPCS procedure code (as received from source)"
 CPTMod1                 "Line item CPT-4/HCPCS first modifier (as received from source)"
 CPTMod2                 "Line item CPT-4/HCPCS second modifier (as received from source)"
 REVCODE                 "Line item revenue code (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHARGE
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).



SAVE OUTFILE = 'NY_SEDD_2006_CHGS.SAV' /COMPRESSED.
