/*******************************************************************
*   NV_SEDD_2010_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NV_SEDD_2010_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AHOUR                     10-  13
 AMONTH                    14-  15
 ASOURCE                   16-  17
 ASOURCEUB92               18     (A)
 ASOURCE_X                 19-  20 (A)
 ATYPE                     21-  22
 AWEEKEND                  23-  24
 BILLTYPE                  25-  28 (A)
 CPT1                      29-  33 (A)
 CPT2                      34-  38 (A)
 CPT3                      39-  43 (A)
 CPT4                      44-  48 (A)
 CPT5                      49-  53 (A)
 CPT6                      54-  58 (A)
 CPT7                      59-  63 (A)
 CPT8                      64-  68 (A)
 CPT9                      69-  73 (A)
 CPT10                     74-  78 (A)
 CPT11                     79-  83 (A)
 CPT12                     84-  88 (A)
 CPT13                     89-  93 (A)
 CPT14                     94-  98 (A)
 CPT15                     99- 103 (A)
 CPT16                    104- 108 (A)
 CPT17                    109- 113 (A)
 CPT18                    114- 118 (A)
 CPT19                    119- 123 (A)
 CPT20                    124- 128 (A)
 CPT21                    129- 133 (A)
 CPT22                    134- 138 (A)
 CPT23                    139- 143 (A)
 CPT24                    144- 148 (A)
 CPT25                    149- 153 (A)
 CPT26                    154- 158 (A)
 CPT27                    159- 163 (A)
 CPT28                    164- 168 (A)
 CPT29                    169- 173 (A)
 CPT30                    174- 178 (A)
 CPTCCS1                  179- 181
 CPTCCS2                  182- 184
 CPTCCS3                  185- 187
 CPTCCS4                  188- 190
 CPTCCS5                  191- 193
 CPTCCS6                  194- 196
 CPTCCS7                  197- 199
 CPTCCS8                  200- 202
 CPTCCS9                  203- 205
 CPTCCS10                 206- 208
 CPTCCS11                 209- 211
 CPTCCS12                 212- 214
 CPTCCS13                 215- 217
 CPTCCS14                 218- 220
 CPTCCS15                 221- 223
 CPTCCS16                 224- 226
 CPTCCS17                 227- 229
 CPTCCS18                 230- 232
 CPTCCS19                 233- 235
 CPTCCS20                 236- 238
 CPTCCS21                 239- 241
 CPTCCS22                 242- 244
 CPTCCS23                 245- 247
 CPTCCS24                 248- 250
 CPTCCS25                 251- 253
 CPTCCS26                 254- 256
 CPTCCS27                 257- 259
 CPTCCS28                 260- 262
 CPTCCS29                 263- 265
 CPTCCS30                 266- 268
 CPTM1_1                  269- 270 (A)
 CPTM1_2                  271- 272 (A)
 CPTM1_3                  273- 274 (A)
 CPTM1_4                  275- 276 (A)
 CPTM1_5                  277- 278 (A)
 CPTM1_6                  279- 280 (A)
 CPTM1_7                  281- 282 (A)
 CPTM1_8                  283- 284 (A)
 CPTM1_9                  285- 286 (A)
 CPTM1_10                 287- 288 (A)
 CPTM1_11                 289- 290 (A)
 CPTM1_12                 291- 292 (A)
 CPTM1_13                 293- 294 (A)
 CPTM1_14                 295- 296 (A)
 CPTM1_15                 297- 298 (A)
 CPTM1_16                 299- 300 (A)
 CPTM1_17                 301- 302 (A)
 CPTM1_18                 303- 304 (A)
 CPTM1_19                 305- 306 (A)
 CPTM1_20                 307- 308 (A)
 CPTM1_21                 309- 310 (A)
 CPTM1_22                 311- 312 (A)
 CPTM1_23                 313- 314 (A)
 CPTM1_24                 315- 316 (A)
 CPTM1_25                 317- 318 (A)
 CPTM1_26                 319- 320 (A)
 CPTM1_27                 321- 322 (A)
 CPTM1_28                 323- 324 (A)
 CPTM1_29                 325- 326 (A)
 CPTM1_30                 327- 328 (A)
 CPTM2_1                  329- 330 (A)
 CPTM2_2                  331- 332 (A)
 CPTM2_3                  333- 334 (A)
 CPTM2_4                  335- 336 (A)
 CPTM2_5                  337- 338 (A)
 CPTM2_6                  339- 340 (A)
 CPTM2_7                  341- 342 (A)
 CPTM2_8                  343- 344 (A)
 CPTM2_9                  345- 346 (A)
 CPTM2_10                 347- 348 (A)
 CPTM2_11                 349- 350 (A)
 CPTM2_12                 351- 352 (A)
 CPTM2_13                 353- 354 (A)
 CPTM2_14                 355- 356 (A)
 CPTM2_15                 357- 358 (A)
 CPTM2_16                 359- 360 (A)
 CPTM2_17                 361- 362 (A)
 CPTM2_18                 363- 364 (A)
 CPTM2_19                 365- 366 (A)
 CPTM2_20                 367- 368 (A)
 CPTM2_21                 369- 370 (A)
 CPTM2_22                 371- 372 (A)
 CPTM2_23                 373- 374 (A)
 CPTM2_24                 375- 376 (A)
 CPTM2_25                 377- 378 (A)
 CPTM2_26                 379- 380 (A)
 CPTM2_27                 381- 382 (A)
 CPTM2_28                 383- 384 (A)
 CPTM2_29                 385- 386 (A)
 CPTM2_30                 387- 388 (A)
 DHOUR                    389- 392
 DIED                     393- 394
 DISPUB04                 395- 396
 DISPUNIFORM              397- 398
 DISP_X                   399- 400 (A)
 DQTR                     401- 402
 DSHOSPID                 403- 419 (A)
 DX1                      420- 424 (A)
 DX2                      425- 429 (A)
 DX3                      430- 434 (A)
 DX4                      435- 439 (A)
 DX5                      440- 444 (A)
 DX6                      445- 449 (A)
 DX7                      450- 454 (A)
 DX8                      455- 459 (A)
 DX9                      460- 464 (A)
 DX10                     465- 469 (A)
 DX11                     470- 474 (A)
 DX12                     475- 479 (A)
 DX13                     480- 484 (A)
 DX14                     485- 489 (A)
 DX15                     490- 494 (A)
 DX16                     495- 499 (A)
 DX17                     500- 504 (A)
 DX18                     505- 509 (A)
 DX19                     510- 514 (A)
 DX20                     515- 519 (A)
 DX21                     520- 524 (A)
 DX22                     525- 529 (A)
 DX23                     530- 534 (A)
 DX24                     535- 539 (A)
 DX25                     540- 544 (A)
 DX26                     545- 549 (A)
 DX27                     550- 554 (A)
 DX28                     555- 559 (A)
 DX29                     560- 564 (A)
 DX30                     565- 569 (A)
 DX31                     570- 574 (A)
 DX32                     575- 579 (A)
 DX33                     580- 584 (A)
 DXCCS1                   585- 588
 DXCCS2                   589- 592
 DXCCS3                   593- 596
 DXCCS4                   597- 600
 DXCCS5                   601- 604
 DXCCS6                   605- 608
 DXCCS7                   609- 612
 DXCCS8                   613- 616
 DXCCS9                   617- 620
 DXCCS10                  621- 624
 DXCCS11                  625- 628
 DXCCS12                  629- 632
 DXCCS13                  633- 636
 DXCCS14                  637- 640
 DXCCS15                  641- 644
 DXCCS16                  645- 648
 DXCCS17                  649- 652
 DXCCS18                  653- 656
 DXCCS19                  657- 660
 DXCCS20                  661- 664
 DXCCS21                  665- 668
 DXCCS22                  669- 672
 DXCCS23                  673- 676
 DXCCS24                  677- 680
 DXCCS25                  681- 684
 DXCCS26                  685- 688
 DXCCS27                  689- 692
 DXCCS28                  693- 696
 DXCCS29                  697- 700
 DXCCS30                  701- 704
 DXCCS31                  705- 708
 DXCCS32                  709- 712
 DXCCS33                  713- 716
 ECODE1                   717- 721 (A)
 ECODE2                   722- 726 (A)
 ECODE3                   727- 731 (A)
 ECODE4                   732- 736 (A)
 E_CCS1                   737- 740
 E_CCS2                   741- 744
 E_CCS3                   745- 748
 E_CCS4                   749- 752
 FEMALE                   753- 754
 HCUP_AS                  755- 756
 HCUP_ED                  757- 758
 HCUP_OS                  759- 760
 HOSPBRTH                 761- 763
 HOSPST                   764- 765 (A)
 HOSP_NPI                 766- 775 (A)
 Homeless                 776- 777
 KEY                      778- 795
 LOS                      796- 800
 LOS_X                    801- 806
 MARITALSTATUSUB04        807     (A)
 MARITALSTATUS_X          808     (A)
 MDNUM1_R                 809- 817
 MDNUM2_R                 818- 826
 MDNUMTYPE1               827     (A)
 MDNUMTYPE2               828     (A)
 MEDINCSTQ                829- 830
 NCHRONIC                 831- 833
 NCPT                     834- 836
 NDX                      837- 838
 NECODE                   839- 840
 NEOMAT                   841- 842
 PAY1                     843- 844
 PAY1_X                   845- 846 (A)
 PAY2                     847- 848
 PAY2_X                   849- 850 (A)
 PAY3                     851- 852
 PAY3_X                   853- 854 (A)
 PL_NCHS2006              855- 856
 PL_RUCA10_2005           857- 858
 PL_RUCA2005              859- 862
 PL_RUCA4_2005            863- 864
 PL_RUCC2003              865- 866
 PL_UIC2003               867- 868
 PL_UR_CAT4               869- 870
 PROCTYPE                 871- 873
 PSTATE                   874- 875 (A)
 PSTCO                    876- 880
 PSTCO2                   881- 885
 PointOfOriginUB04        886     (A)
 PointOfOrigin_X          887- 888 (A)
 RACE                     889- 890
 RACE_X                   891- 892 (A)
 STATE_AS                 893- 894
 STATE_ED                 895- 896
 STATE_OS                 897- 898
 TOTCHG                   899- 908
 TOTCHG_X                 909- 923
 YEAR                     924- 927
 ZIPINC_QRTL              928- 930
 AYEAR                    931- 934
 DMONTH                   935- 936.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 CPTCCS21                (F4.0) /
 CPTCCS22                (F4.0) /
 CPTCCS23                (F4.0) /
 CPTCCS24                (F4.0) /
 CPTCCS25                (F4.0) /
 CPTCCS26                (F4.0) /
 CPTCCS27                (F4.0) /
 CPTCCS28                (F4.0) /
 CPTCCS29                (F4.0) /
 CPTCCS30                (F4.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 DXCCS31                 (F4.0) /
 DXCCS32                 (F4.0) /
 DXCCS33                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Homeless                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MEDINCSTQ               (F3.0) /
 NCHRONIC                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PAY3                    (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AHOUR                   "Admission Hour"
 AMONTH                  "Admission month"
 ASOURCE                 "Admission source (uniform)"
 ASOURCEUB92             "Admission source (UB-92 standard coding)"
 ASOURCE_X               "Admission source (as received from source)"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 BILLTYPE                "UB-92 bill type"
 CPT1                    "CPT/HCPCS procedure code 1"
 CPT2                    "CPT/HCPCS procedure code 2"
 CPT3                    "CPT/HCPCS procedure code 3"
 CPT4                    "CPT/HCPCS procedure code 4"
 CPT5                    "CPT/HCPCS procedure code 5"
 CPT6                    "CPT/HCPCS procedure code 6"
 CPT7                    "CPT/HCPCS procedure code 7"
 CPT8                    "CPT/HCPCS procedure code 8"
 CPT9                    "CPT/HCPCS procedure code 9"
 CPT10                   "CPT/HCPCS procedure code 10"
 CPT11                   "CPT/HCPCS procedure code 11"
 CPT12                   "CPT/HCPCS procedure code 12"
 CPT13                   "CPT/HCPCS procedure code 13"
 CPT14                   "CPT/HCPCS procedure code 14"
 CPT15                   "CPT/HCPCS procedure code 15"
 CPT16                   "CPT/HCPCS procedure code 16"
 CPT17                   "CPT/HCPCS procedure code 17"
 CPT18                   "CPT/HCPCS procedure code 18"
 CPT19                   "CPT/HCPCS procedure code 19"
 CPT20                   "CPT/HCPCS procedure code 20"
 CPT21                   "CPT/HCPCS procedure code 21"
 CPT22                   "CPT/HCPCS procedure code 22"
 CPT23                   "CPT/HCPCS procedure code 23"
 CPT24                   "CPT/HCPCS procedure code 24"
 CPT25                   "CPT/HCPCS procedure code 25"
 CPT26                   "CPT/HCPCS procedure code 26"
 CPT27                   "CPT/HCPCS procedure code 27"
 CPT28                   "CPT/HCPCS procedure code 28"
 CPT29                   "CPT/HCPCS procedure code 29"
 CPT30                   "CPT/HCPCS procedure code 30"
 CPTCCS1                 "CCS: CPT 1"
 CPTCCS2                 "CCS: CPT 2"
 CPTCCS3                 "CCS: CPT 3"
 CPTCCS4                 "CCS: CPT 4"
 CPTCCS5                 "CCS: CPT 5"
 CPTCCS6                 "CCS: CPT 6"
 CPTCCS7                 "CCS: CPT 7"
 CPTCCS8                 "CCS: CPT 8"
 CPTCCS9                 "CCS: CPT 9"
 CPTCCS10                "CCS: CPT 10"
 CPTCCS11                "CCS: CPT 11"
 CPTCCS12                "CCS: CPT 12"
 CPTCCS13                "CCS: CPT 13"
 CPTCCS14                "CCS: CPT 14"
 CPTCCS15                "CCS: CPT 15"
 CPTCCS16                "CCS: CPT 16"
 CPTCCS17                "CCS: CPT 17"
 CPTCCS18                "CCS: CPT 18"
 CPTCCS19                "CCS: CPT 19"
 CPTCCS20                "CCS: CPT 20"
 CPTCCS21                "CCS: CPT 21"
 CPTCCS22                "CCS: CPT 22"
 CPTCCS23                "CCS: CPT 23"
 CPTCCS24                "CCS: CPT 24"
 CPTCCS25                "CCS: CPT 25"
 CPTCCS26                "CCS: CPT 26"
 CPTCCS27                "CCS: CPT 27"
 CPTCCS28                "CCS: CPT 28"
 CPTCCS29                "CCS: CPT 29"
 CPTCCS30                "CCS: CPT 30"
 CPTM1_1                 "First CPT-4/HCPCS modifier 1"
 CPTM1_2                 "First CPT-4/HCPCS modifier 2"
 CPTM1_3                 "First CPT-4/HCPCS modifier 3"
 CPTM1_4                 "First CPT-4/HCPCS modifier 4"
 CPTM1_5                 "First CPT-4/HCPCS modifier 5"
 CPTM1_6                 "First CPT-4/HCPCS modifier 6"
 CPTM1_7                 "First CPT-4/HCPCS modifier 7"
 CPTM1_8                 "First CPT-4/HCPCS modifier 8"
 CPTM1_9                 "First CPT-4/HCPCS modifier 9"
 CPTM1_10                "First CPT-4/HCPCS modifier 10"
 CPTM1_11                "First CPT-4/HCPCS modifier 11"
 CPTM1_12                "First CPT-4/HCPCS modifier 12"
 CPTM1_13                "First CPT-4/HCPCS modifier 13"
 CPTM1_14                "First CPT-4/HCPCS modifier 14"
 CPTM1_15                "First CPT-4/HCPCS modifier 15"
 CPTM1_16                "First CPT-4/HCPCS modifier 16"
 CPTM1_17                "First CPT-4/HCPCS modifier 17"
 CPTM1_18                "First CPT-4/HCPCS modifier 18"
 CPTM1_19                "First CPT-4/HCPCS modifier 19"
 CPTM1_20                "First CPT-4/HCPCS modifier 20"
 CPTM1_21                "First CPT-4/HCPCS modifier 21"
 CPTM1_22                "First CPT-4/HCPCS modifier 22"
 CPTM1_23                "First CPT-4/HCPCS modifier 23"
 CPTM1_24                "First CPT-4/HCPCS modifier 24"
 CPTM1_25                "First CPT-4/HCPCS modifier 25"
 CPTM1_26                "First CPT-4/HCPCS modifier 26"
 CPTM1_27                "First CPT-4/HCPCS modifier 27"
 CPTM1_28                "First CPT-4/HCPCS modifier 28"
 CPTM1_29                "First CPT-4/HCPCS modifier 29"
 CPTM1_30                "First CPT-4/HCPCS modifier 30"
 CPTM2_1                 "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                 "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                 "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                 "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                 "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                 "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                 "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                 "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                 "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                "Second CPT-4/HCPCS modifier 25"
 CPTM2_26                "Second CPT-4/HCPCS modifier 26"
 CPTM2_27                "Second CPT-4/HCPCS modifier 27"
 CPTM2_28                "Second CPT-4/HCPCS modifier 28"
 CPTM2_29                "Second CPT-4/HCPCS modifier 29"
 CPTM2_30                "Second CPT-4/HCPCS modifier 30"
 DHOUR                   "Discharge Hour"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DSHOSPID                "Data source hospital identifier"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DX21                    "Diagnosis 21"
 DX22                    "Diagnosis 22"
 DX23                    "Diagnosis 23"
 DX24                    "Diagnosis 24"
 DX25                    "Diagnosis 25"
 DX26                    "Diagnosis 26"
 DX27                    "Diagnosis 27"
 DX28                    "Diagnosis 28"
 DX29                    "Diagnosis 29"
 DX30                    "Diagnosis 30"
 DX31                    "Diagnosis 31"
 DX32                    "Diagnosis 32"
 DX33                    "Diagnosis 33"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXCCS21                 "CCS: diagnosis 21"
 DXCCS22                 "CCS: diagnosis 22"
 DXCCS23                 "CCS: diagnosis 23"
 DXCCS24                 "CCS: diagnosis 24"
 DXCCS25                 "CCS: diagnosis 25"
 DXCCS26                 "CCS: diagnosis 26"
 DXCCS27                 "CCS: diagnosis 27"
 DXCCS28                 "CCS: diagnosis 28"
 DXCCS29                 "CCS: diagnosis 29"
 DXCCS30                 "CCS: diagnosis 30"
 DXCCS31                 "CCS: diagnosis 31"
 DXCCS32                 "CCS: diagnosis 32"
 DXCCS33                 "CCS: diagnosis 33"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 FEMALE                  "Indicator of sex"
 HCUP_AS                 "HCUP Ambulatory Surgery service indicator"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 HOSP_NPI                "Hospital NPI"
 Homeless                "Indicator that patient is homeless"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MARITALSTATUSUB04       "Patient's marital status, UB-04 standard coding"
 MARITALSTATUS_X         "Patient's marital status (as received from source)"
 MDNUM1_R                "Physician 1 number (re-identified)"
 MDNUM2_R                "Physician 2 number (re-identified)"
 MDNUMTYPE1              "Physician 1 number type"
 MDNUMTYPE2              "Physician 2 number type"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 NCHRONIC                "Number of chronic conditions"
 NCPT                    "Number of CPT/HCPCS procedures on this record"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAY2                    "Secondary expected payer (uniform)"
 PAY2_X                  "Secondary expected payer (as received from source)"
 PAY3                    "Tertiary expected payer (uniform)"
 PAY3_X                  "Tertiary expected payer (as received from source)"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04       "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X         "Point of origin for admission or visit, as received from source"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 STATE_AS                "State Ambulatory Surgery service indicator"
 STATE_ED                "State Emergency Department service indicator"
 STATE_OS                "State Observation Stay service indicator"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 YEAR                    "Calendar year"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'NV_SEDD_2010_CORE.SAV' /COMPRESSED.
