/*******************************************************************
* Creation Date: 02/01/2024   
*   ME_SEDD_2021_CORE.sps:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************/

DATA LIST FILE = 'ME_SEDD_2021_CORE.asc' FIXED SKIP=2 / 
 AMONTH                          1-   2
 AWEEKEND                        3-   4
 BILLTYPE                        5-   8 (A)
 CPT1                            9-  13 (A)
 CPT2                           14-  18 (A)
 CPT3                           19-  23 (A)
 CPT4                           24-  28 (A)
 CPT5                           29-  33 (A)
 CPT6                           34-  38 (A)
 CPT7                           39-  43 (A)
 CPT8                           44-  48 (A)
 CPT9                           49-  53 (A)
 CPT10                          54-  58 (A)
 CPT11                          59-  63 (A)
 CPT12                          64-  68 (A)
 CPT13                          69-  73 (A)
 CPT14                          74-  78 (A)
 CPT15                          79-  83 (A)
 CPT16                          84-  88 (A)
 CPT17                          89-  93 (A)
 CPT18                          94-  98 (A)
 CPT19                          99- 103 (A)
 CPT20                         104- 108 (A)
 CPT21                         109- 113 (A)
 CPT22                         114- 118 (A)
 CPT23                         119- 123 (A)
 CPT24                         124- 128 (A)
 CPT25                         129- 133 (A)
 CPT26                         134- 138 (A)
 CPT27                         139- 143 (A)
 CPT28                         144- 148 (A)
 CPT29                         149- 153 (A)
 CPT30                         154- 158 (A)
 CPT31                         159- 163 (A)
 CPT32                         164- 168 (A)
 CPT33                         169- 173 (A)
 CPT34                         174- 178 (A)
 CPT35                         179- 183 (A)
 CPT36                         184- 188 (A)
 CPT37                         189- 193 (A)
 CPT38                         194- 198 (A)
 CPT39                         199- 203 (A)
 CPT40                         204- 208 (A)
 CPT41                         209- 213 (A)
 CPT42                         214- 218 (A)
 CPT43                         219- 223 (A)
 CPT44                         224- 228 (A)
 CPT45                         229- 233 (A)
 CPT46                         234- 238 (A)
 CPT47                         239- 243 (A)
 CPT48                         244- 248 (A)
 CPT49                         249- 253 (A)
 CPT50                         254- 258 (A)
 CPT51                         259- 263 (A)
 CPT52                         264- 268 (A)
 CPT53                         269- 273 (A)
 CPT54                         274- 278 (A)
 CPT55                         279- 283 (A)
 CPT56                         284- 288 (A)
 CPT57                         289- 293 (A)
 CPT58                         294- 298 (A)
 CPT59                         299- 303 (A)
 CPT60                         304- 308 (A)
 CPT61                         309- 313 (A)
 CPT62                         314- 318 (A)
 CPT63                         319- 323 (A)
 CPT64                         324- 328 (A)
 CPT65                         329- 333 (A)
 CPT66                         334- 338 (A)
 CPT67                         339- 343 (A)
 CPT68                         344- 348 (A)
 CPT69                         349- 353 (A)
 CPT70                         354- 358 (A)
 CPT71                         359- 363 (A)
 CPT72                         364- 368 (A)
 CPT73                         369- 373 (A)
 CPT74                         374- 378 (A)
 CPT75                         379- 383 (A)
 CPT76                         384- 388 (A)
 CPT77                         389- 393 (A)
 CPT78                         394- 398 (A)
 CPT79                         399- 403 (A)
 CPT80                         404- 408 (A)
 CPT81                         409- 413 (A)
 CPT82                         414- 418 (A)
 CPT83                         419- 423 (A)
 CPT84                         424- 428 (A)
 CPT85                         429- 433 (A)
 CPT86                         434- 438 (A)
 CPT87                         439- 443 (A)
 CPT88                         444- 448 (A)
 CPT89                         449- 453 (A)
 CPT90                         454- 458 (A)
 CPT91                         459- 463 (A)
 CPT92                         464- 468 (A)
 CPT93                         469- 473 (A)
 CPT94                         474- 478 (A)
 CPT95                         479- 483 (A)
 CPT96                         484- 488 (A)
 CPT97                         489- 493 (A)
 CPT98                         494- 498 (A)
 CPT99                         499- 503 (A)
 CPT100                        504- 508 (A)
 CPTCCS1                       509- 511
 CPTCCS2                       512- 514
 CPTCCS3                       515- 517
 CPTCCS4                       518- 520
 CPTCCS5                       521- 523
 CPTCCS6                       524- 526
 CPTCCS7                       527- 529
 CPTCCS8                       530- 532
 CPTCCS9                       533- 535
 CPTCCS10                      536- 538
 CPTCCS11                      539- 541
 CPTCCS12                      542- 544
 CPTCCS13                      545- 547
 CPTCCS14                      548- 550
 CPTCCS15                      551- 553
 CPTCCS16                      554- 556
 CPTCCS17                      557- 559
 CPTCCS18                      560- 562
 CPTCCS19                      563- 565
 CPTCCS20                      566- 568
 CPTCCS21                      569- 571
 CPTCCS22                      572- 574
 CPTCCS23                      575- 577
 CPTCCS24                      578- 580
 CPTCCS25                      581- 583
 CPTCCS26                      584- 586
 CPTCCS27                      587- 589
 CPTCCS28                      590- 592
 CPTCCS29                      593- 595
 CPTCCS30                      596- 598
 CPTCCS31                      599- 601
 CPTCCS32                      602- 604
 CPTCCS33                      605- 607
 CPTCCS34                      608- 610
 CPTCCS35                      611- 613
 CPTCCS36                      614- 616
 CPTCCS37                      617- 619
 CPTCCS38                      620- 622
 CPTCCS39                      623- 625
 CPTCCS40                      626- 628
 CPTCCS41                      629- 631
 CPTCCS42                      632- 634
 CPTCCS43                      635- 637
 CPTCCS44                      638- 640
 CPTCCS45                      641- 643
 CPTCCS46                      644- 646
 CPTCCS47                      647- 649
 CPTCCS48                      650- 652
 CPTCCS49                      653- 655
 CPTCCS50                      656- 658
 CPTCCS51                      659- 661
 CPTCCS52                      662- 664
 CPTCCS53                      665- 667
 CPTCCS54                      668- 670
 CPTCCS55                      671- 673
 CPTCCS56                      674- 676
 CPTCCS57                      677- 679
 CPTCCS58                      680- 682
 CPTCCS59                      683- 685
 CPTCCS60                      686- 688
 CPTCCS61                      689- 691
 CPTCCS62                      692- 694
 CPTCCS63                      695- 697
 CPTCCS64                      698- 700
 CPTCCS65                      701- 703
 CPTCCS66                      704- 706
 CPTCCS67                      707- 709
 CPTCCS68                      710- 712
 CPTCCS69                      713- 715
 CPTCCS70                      716- 718
 CPTCCS71                      719- 721
 CPTCCS72                      722- 724
 CPTCCS73                      725- 727
 CPTCCS74                      728- 730
 CPTCCS75                      731- 733
 CPTCCS76                      734- 736
 CPTCCS77                      737- 739
 CPTCCS78                      740- 742
 CPTCCS79                      743- 745
 CPTCCS80                      746- 748
 CPTCCS81                      749- 751
 CPTCCS82                      752- 754
 CPTCCS83                      755- 757
 CPTCCS84                      758- 760
 CPTCCS85                      761- 763
 CPTCCS86                      764- 766
 CPTCCS87                      767- 769
 CPTCCS88                      770- 772
 CPTCCS89                      773- 775
 CPTCCS90                      776- 778
 CPTCCS91                      779- 781
 CPTCCS92                      782- 784
 CPTCCS93                      785- 787
 CPTCCS94                      788- 790
 CPTCCS95                      791- 793
 CPTCCS96                      794- 796
 CPTCCS97                      797- 799
 CPTCCS98                      800- 802
 CPTCCS99                      803- 805
 CPTCCS100                     806- 808
 CPTDAY1                       809- 811
 CPTDAY2                       812- 814
 CPTDAY3                       815- 817
 CPTDAY4                       818- 820
 CPTDAY5                       821- 823
 CPTDAY6                       824- 826
 CPTDAY7                       827- 829
 CPTDAY8                       830- 832
 CPTDAY9                       833- 835
 CPTDAY10                      836- 838
 CPTDAY11                      839- 841
 CPTDAY12                      842- 844
 CPTDAY13                      845- 847
 CPTDAY14                      848- 850
 CPTDAY15                      851- 853
 CPTDAY16                      854- 856
 CPTDAY17                      857- 859
 CPTDAY18                      860- 862
 CPTDAY19                      863- 865
 CPTDAY20                      866- 868
 CPTDAY21                      869- 871
 CPTDAY22                      872- 874
 CPTDAY23                      875- 877
 CPTDAY24                      878- 880
 CPTDAY25                      881- 883
 CPTDAY26                      884- 886
 CPTDAY27                      887- 889
 CPTDAY28                      890- 892
 CPTDAY29                      893- 895
 CPTDAY30                      896- 898
 CPTDAY31                      899- 901
 CPTDAY32                      902- 904
 CPTDAY33                      905- 907
 CPTDAY34                      908- 910
 CPTDAY35                      911- 913
 CPTDAY36                      914- 916
 CPTDAY37                      917- 919
 CPTDAY38                      920- 922
 CPTDAY39                      923- 925
 CPTDAY40                      926- 928
 CPTDAY41                      929- 931
 CPTDAY42                      932- 934
 CPTDAY43                      935- 937
 CPTDAY44                      938- 940
 CPTDAY45                      941- 943
 CPTDAY46                      944- 946
 CPTDAY47                      947- 949
 CPTDAY48                      950- 952
 CPTDAY49                      953- 955
 CPTDAY50                      956- 958
 CPTDAY51                      959- 961
 CPTDAY52                      962- 964
 CPTDAY53                      965- 967
 CPTDAY54                      968- 970
 CPTDAY55                      971- 973
 CPTDAY56                      974- 976
 CPTDAY57                      977- 979
 CPTDAY58                      980- 982
 CPTDAY59                      983- 985
 CPTDAY60                      986- 988
 CPTDAY61                      989- 991
 CPTDAY62                      992- 994
 CPTDAY63                      995- 997
 CPTDAY64                      998-1000
 CPTDAY65                     1001-1003
 CPTDAY66                     1004-1006
 CPTDAY67                     1007-1009
 CPTDAY68                     1010-1012
 CPTDAY69                     1013-1015
 CPTDAY70                     1016-1018
 CPTDAY71                     1019-1021
 CPTDAY72                     1022-1024
 CPTDAY73                     1025-1027
 CPTDAY74                     1028-1030
 CPTDAY75                     1031-1033
 CPTDAY76                     1034-1036
 CPTDAY77                     1037-1039
 CPTDAY78                     1040-1042
 CPTDAY79                     1043-1045
 CPTDAY80                     1046-1048
 CPTDAY81                     1049-1051
 CPTDAY82                     1052-1054
 CPTDAY83                     1055-1057
 CPTDAY84                     1058-1060
 CPTDAY85                     1061-1063
 CPTDAY86                     1064-1066
 CPTDAY87                     1067-1069
 CPTDAY88                     1070-1072
 CPTDAY89                     1073-1075
 CPTDAY90                     1076-1078
 CPTDAY91                     1079-1081
 CPTDAY92                     1082-1084
 CPTDAY93                     1085-1087
 CPTDAY94                     1088-1090
 CPTDAY95                     1091-1093
 CPTDAY96                     1094-1096
 CPTDAY97                     1097-1099
 CPTDAY98                     1100-1102
 CPTDAY99                     1103-1105
 CPTDAY100                    1106-1108
 CPTM1_1                      1109-1110 (A)
 CPTM1_2                      1111-1112 (A)
 CPTM1_3                      1113-1114 (A)
 CPTM1_4                      1115-1116 (A)
 CPTM1_5                      1117-1118 (A)
 CPTM1_6                      1119-1120 (A)
 CPTM1_7                      1121-1122 (A)
 CPTM1_8                      1123-1124 (A)
 CPTM1_9                      1125-1126 (A)
 CPTM1_10                     1127-1128 (A)
 CPTM1_11                     1129-1130 (A)
 CPTM1_12                     1131-1132 (A)
 CPTM1_13                     1133-1134 (A)
 CPTM1_14                     1135-1136 (A)
 CPTM1_15                     1137-1138 (A)
 CPTM1_16                     1139-1140 (A)
 CPTM1_17                     1141-1142 (A)
 CPTM1_18                     1143-1144 (A)
 CPTM1_19                     1145-1146 (A)
 CPTM1_20                     1147-1148 (A)
 CPTM1_21                     1149-1150 (A)
 CPTM1_22                     1151-1152 (A)
 CPTM1_23                     1153-1154 (A)
 CPTM1_24                     1155-1156 (A)
 CPTM1_25                     1157-1158 (A)
 CPTM1_26                     1159-1160 (A)
 CPTM1_27                     1161-1162 (A)
 CPTM1_28                     1163-1164 (A)
 CPTM1_29                     1165-1166 (A)
 CPTM1_30                     1167-1168 (A)
 CPTM1_31                     1169-1170 (A)
 CPTM1_32                     1171-1172 (A)
 CPTM1_33                     1173-1174 (A)
 CPTM1_34                     1175-1176 (A)
 CPTM1_35                     1177-1178 (A)
 CPTM1_36                     1179-1180 (A)
 CPTM1_37                     1181-1182 (A)
 CPTM1_38                     1183-1184 (A)
 CPTM1_39                     1185-1186 (A)
 CPTM1_40                     1187-1188 (A)
 CPTM1_41                     1189-1190 (A)
 CPTM1_42                     1191-1192 (A)
 CPTM1_43                     1193-1194 (A)
 CPTM1_44                     1195-1196 (A)
 CPTM1_45                     1197-1198 (A)
 CPTM1_46                     1199-1200 (A)
 CPTM1_47                     1201-1202 (A)
 CPTM1_48                     1203-1204 (A)
 CPTM1_49                     1205-1206 (A)
 CPTM1_50                     1207-1208 (A)
 CPTM1_51                     1209-1210 (A)
 CPTM1_52                     1211-1212 (A)
 CPTM1_53                     1213-1214 (A)
 CPTM1_54                     1215-1216 (A)
 CPTM1_55                     1217-1218 (A)
 CPTM1_56                     1219-1220 (A)
 CPTM1_57                     1221-1222 (A)
 CPTM1_58                     1223-1224 (A)
 CPTM1_59                     1225-1226 (A)
 CPTM1_60                     1227-1228 (A)
 CPTM1_61                     1229-1230 (A)
 CPTM1_62                     1231-1232 (A)
 CPTM1_63                     1233-1234 (A)
 CPTM1_64                     1235-1236 (A)
 CPTM1_65                     1237-1238 (A)
 CPTM1_66                     1239-1240 (A)
 CPTM1_67                     1241-1242 (A)
 CPTM1_68                     1243-1244 (A)
 CPTM1_69                     1245-1246 (A)
 CPTM1_70                     1247-1248 (A)
 CPTM1_71                     1249-1250 (A)
 CPTM1_72                     1251-1252 (A)
 CPTM1_73                     1253-1254 (A)
 CPTM1_74                     1255-1256 (A)
 CPTM1_75                     1257-1258 (A)
 CPTM1_76                     1259-1260 (A)
 CPTM1_77                     1261-1262 (A)
 CPTM1_78                     1263-1264 (A)
 CPTM1_79                     1265-1266 (A)
 CPTM1_80                     1267-1268 (A)
 CPTM1_81                     1269-1270 (A)
 CPTM1_82                     1271-1272 (A)
 CPTM1_83                     1273-1274 (A)
 CPTM1_84                     1275-1276 (A)
 CPTM1_85                     1277-1278 (A)
 CPTM1_86                     1279-1280 (A)
 CPTM1_87                     1281-1282 (A)
 CPTM1_88                     1283-1284 (A)
 CPTM1_89                     1285-1286 (A)
 CPTM1_90                     1287-1288 (A)
 CPTM1_91                     1289-1290 (A)
 CPTM1_92                     1291-1292 (A)
 CPTM1_93                     1293-1294 (A)
 CPTM1_94                     1295-1296 (A)
 CPTM1_95                     1297-1298 (A)
 CPTM1_96                     1299-1300 (A)
 CPTM1_97                     1301-1302 (A)
 CPTM1_98                     1303-1304 (A)
 CPTM1_99                     1305-1306 (A)
 CPTM1_100                    1307-1308 (A)
 CPTM2_1                      1309-1310 (A)
 CPTM2_2                      1311-1312 (A)
 CPTM2_3                      1313-1314 (A)
 CPTM2_4                      1315-1316 (A)
 CPTM2_5                      1317-1318 (A)
 CPTM2_6                      1319-1320 (A)
 CPTM2_7                      1321-1322 (A)
 CPTM2_8                      1323-1324 (A)
 CPTM2_9                      1325-1326 (A)
 CPTM2_10                     1327-1328 (A)
 CPTM2_11                     1329-1330 (A)
 CPTM2_12                     1331-1332 (A)
 CPTM2_13                     1333-1334 (A)
 CPTM2_14                     1335-1336 (A)
 CPTM2_15                     1337-1338 (A)
 CPTM2_16                     1339-1340 (A)
 CPTM2_17                     1341-1342 (A)
 CPTM2_18                     1343-1344 (A)
 CPTM2_19                     1345-1346 (A)
 CPTM2_20                     1347-1348 (A)
 CPTM2_21                     1349-1350 (A)
 CPTM2_22                     1351-1352 (A)
 CPTM2_23                     1353-1354 (A)
 CPTM2_24                     1355-1356 (A)
 CPTM2_25                     1357-1358 (A)
 CPTM2_26                     1359-1360 (A)
 CPTM2_27                     1361-1362 (A)
 CPTM2_28                     1363-1364 (A)
 CPTM2_29                     1365-1366 (A)
 CPTM2_30                     1367-1368 (A)
 CPTM2_31                     1369-1370 (A)
 CPTM2_32                     1371-1372 (A)
 CPTM2_33                     1373-1374 (A)
 CPTM2_34                     1375-1376 (A)
 CPTM2_35                     1377-1378 (A)
 CPTM2_36                     1379-1380 (A)
 CPTM2_37                     1381-1382 (A)
 CPTM2_38                     1383-1384 (A)
 CPTM2_39                     1385-1386 (A)
 CPTM2_40                     1387-1388 (A)
 CPTM2_41                     1389-1390 (A)
 CPTM2_42                     1391-1392 (A)
 CPTM2_43                     1393-1394 (A)
 CPTM2_44                     1395-1396 (A)
 CPTM2_45                     1397-1398 (A)
 CPTM2_46                     1399-1400 (A)
 CPTM2_47                     1401-1402 (A)
 CPTM2_48                     1403-1404 (A)
 CPTM2_49                     1405-1406 (A)
 CPTM2_50                     1407-1408 (A)
 CPTM2_51                     1409-1410 (A)
 CPTM2_52                     1411-1412 (A)
 CPTM2_53                     1413-1414 (A)
 CPTM2_54                     1415-1416 (A)
 CPTM2_55                     1417-1418 (A)
 CPTM2_56                     1419-1420 (A)
 CPTM2_57                     1421-1422 (A)
 CPTM2_58                     1423-1424 (A)
 CPTM2_59                     1425-1426 (A)
 CPTM2_60                     1427-1428 (A)
 CPTM2_61                     1429-1430 (A)
 CPTM2_62                     1431-1432 (A)
 CPTM2_63                     1433-1434 (A)
 CPTM2_64                     1435-1436 (A)
 CPTM2_65                     1437-1438 (A)
 CPTM2_66                     1439-1440 (A)
 CPTM2_67                     1441-1442 (A)
 CPTM2_68                     1443-1444 (A)
 CPTM2_69                     1445-1446 (A)
 CPTM2_70                     1447-1448 (A)
 CPTM2_71                     1449-1450 (A)
 CPTM2_72                     1451-1452 (A)
 CPTM2_73                     1453-1454 (A)
 CPTM2_74                     1455-1456 (A)
 CPTM2_75                     1457-1458 (A)
 CPTM2_76                     1459-1460 (A)
 CPTM2_77                     1461-1462 (A)
 CPTM2_78                     1463-1464 (A)
 CPTM2_79                     1465-1466 (A)
 CPTM2_80                     1467-1468 (A)
 CPTM2_81                     1469-1470 (A)
 CPTM2_82                     1471-1472 (A)
 CPTM2_83                     1473-1474 (A)
 CPTM2_84                     1475-1476 (A)
 CPTM2_85                     1477-1478 (A)
 CPTM2_86                     1479-1480 (A)
 CPTM2_87                     1481-1482 (A)
 CPTM2_88                     1483-1484 (A)
 CPTM2_89                     1485-1486 (A)
 CPTM2_90                     1487-1488 (A)
 CPTM2_91                     1489-1490 (A)
 CPTM2_92                     1491-1492 (A)
 CPTM2_93                     1493-1494 (A)
 CPTM2_94                     1495-1496 (A)
 CPTM2_95                     1497-1498 (A)
 CPTM2_96                     1499-1500 (A)
 CPTM2_97                     1501-1502 (A)
 CPTM2_98                     1503-1504 (A)
 CPTM2_99                     1505-1506 (A)
 CPTM2_100                    1507-1508 (A)
 DIED                         1509-1510
 DISPUB04                     1511-1512
 DISPUNIFORM                  1513-1514
 DMONTH                       1515-1516
 DQTR                         1517-1518
 FEMALE                       1519-1520
 HCUP_ED                      1521-1522
 HCUP_OS                      1523-1524
 HCUP_SURGERY_BROAD_CPT       1525-1529
 HCUP_SURGERY_NARROW_CPT      1530-1534
 HOSPST                       1535-1536 (A)
 I10_DX_Visit_Reason1         1537-1543 (A)
 I10_DX_Visit_Reason2         1544-1550 (A)
 I10_DX_Visit_Reason3         1551-1557 (A)
 I10_DX1                      1558-1564 (A)
 I10_DX2                      1565-1571 (A)
 I10_DX3                      1572-1578 (A)
 I10_DX4                      1579-1585 (A)
 I10_DX5                      1586-1592 (A)
 I10_DX6                      1593-1599 (A)
 I10_DX7                      1600-1606 (A)
 I10_DX8                      1607-1613 (A)
 I10_DX9                      1614-1620 (A)
 I10_DX10                     1621-1627 (A)
 I10_DX11                     1628-1634 (A)
 I10_DX12                     1635-1641 (A)
 I10_DX13                     1642-1648 (A)
 I10_DX14                     1649-1655 (A)
 I10_DX15                     1656-1662 (A)
 I10_DX16                     1663-1669 (A)
 I10_DX17                     1670-1676 (A)
 I10_DX18                     1677-1683 (A)
 I10_DX19                     1684-1690 (A)
 I10_DX20                     1691-1697 (A)
 I10_DX21                     1698-1704 (A)
 I10_DX22                     1705-1711 (A)
 I10_DX23                     1712-1718 (A)
 I10_DX24                     1719-1725 (A)
 I10_DX25                     1726-1732 (A)
 I10_DX26                     1733-1739 (A)
 I10_DX27                     1740-1746 (A)
 I10_DX28                     1747-1753 (A)
 I10_NDX                      1754-1756
 I10_PROCTYPE                 1757-1759
 KEY                          1760-1774
 LOS                          1775-1779
 MDSPEC1                      1780-1781 (A)
 MDSPEC2                      1782-1783 (A)
 MEDINCSTQ                    1784-1785
 MRN_R                        1786-1794
 NCPT                         1795-1798
 OPservice                    1799-1801 (A)
 OS_TIME                      1802-1812
 PAY1                         1813-1814
 PAY2                         1815-1816
 PAY3                         1817-1818
 PL_CBSA                      1819-1821
 PL_NCHS                      1822-1823
 PL_UIC                       1824-1825
 PL_UR_CAT4                   1826-1827
 PointOfOriginUB04            1828     (A)
 PSTATE                       1829-1830 (A)
 PSTATE_GEO                   1831-1832 (A)
 PSTCO                        1833-1837
 PSTCO_GEO                    1838-1842
 SASD_SEDD                    1843-1844
 STATE_AS                     1845-1846
 STATE_ED                     1847-1848
 STATE_OS                     1849-1850
 YEAR                         1851-1854
 ZIP3                         1855-1857 (A)
 ZIPINC_QRTL                  1858-1860
 AGEGROUP                     1861-1863
 HOSPID                       1864-1868
 AYEAR                        1869-1872.


/***  Specify write formats  ***/
FORMATS
 AMONTH                       (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTCCS51                     (F4.0) /
 CPTCCS52                     (F4.0) /
 CPTCCS53                     (F4.0) /
 CPTCCS54                     (F4.0) /
 CPTCCS55                     (F4.0) /
 CPTCCS56                     (F4.0) /
 CPTCCS57                     (F4.0) /
 CPTCCS58                     (F4.0) /
 CPTCCS59                     (F4.0) /
 CPTCCS60                     (F4.0) /
 CPTCCS61                     (F4.0) /
 CPTCCS62                     (F4.0) /
 CPTCCS63                     (F4.0) /
 CPTCCS64                     (F4.0) /
 CPTCCS65                     (F4.0) /
 CPTCCS66                     (F4.0) /
 CPTCCS67                     (F4.0) /
 CPTCCS68                     (F4.0) /
 CPTCCS69                     (F4.0) /
 CPTCCS70                     (F4.0) /
 CPTCCS71                     (F4.0) /
 CPTCCS72                     (F4.0) /
 CPTCCS73                     (F4.0) /
 CPTCCS74                     (F4.0) /
 CPTCCS75                     (F4.0) /
 CPTCCS76                     (F4.0) /
 CPTCCS77                     (F4.0) /
 CPTCCS78                     (F4.0) /
 CPTCCS79                     (F4.0) /
 CPTCCS80                     (F4.0) /
 CPTCCS81                     (F4.0) /
 CPTCCS82                     (F4.0) /
 CPTCCS83                     (F4.0) /
 CPTCCS84                     (F4.0) /
 CPTCCS85                     (F4.0) /
 CPTCCS86                     (F4.0) /
 CPTCCS87                     (F4.0) /
 CPTCCS88                     (F4.0) /
 CPTCCS89                     (F4.0) /
 CPTCCS90                     (F4.0) /
 CPTCCS91                     (F4.0) /
 CPTCCS92                     (F4.0) /
 CPTCCS93                     (F4.0) /
 CPTCCS94                     (F4.0) /
 CPTCCS95                     (F4.0) /
 CPTCCS96                     (F4.0) /
 CPTCCS97                     (F4.0) /
 CPTCCS98                     (F4.0) /
 CPTCCS99                     (F4.0) /
 CPTCCS100                    (F4.0) /
 CPTDAY1                      (F4.0) /
 CPTDAY2                      (F4.0) /
 CPTDAY3                      (F4.0) /
 CPTDAY4                      (F4.0) /
 CPTDAY5                      (F4.0) /
 CPTDAY6                      (F4.0) /
 CPTDAY7                      (F4.0) /
 CPTDAY8                      (F4.0) /
 CPTDAY9                      (F4.0) /
 CPTDAY10                     (F4.0) /
 CPTDAY11                     (F4.0) /
 CPTDAY12                     (F4.0) /
 CPTDAY13                     (F4.0) /
 CPTDAY14                     (F4.0) /
 CPTDAY15                     (F4.0) /
 CPTDAY16                     (F4.0) /
 CPTDAY17                     (F4.0) /
 CPTDAY18                     (F4.0) /
 CPTDAY19                     (F4.0) /
 CPTDAY20                     (F4.0) /
 CPTDAY21                     (F4.0) /
 CPTDAY22                     (F4.0) /
 CPTDAY23                     (F4.0) /
 CPTDAY24                     (F4.0) /
 CPTDAY25                     (F4.0) /
 CPTDAY26                     (F4.0) /
 CPTDAY27                     (F4.0) /
 CPTDAY28                     (F4.0) /
 CPTDAY29                     (F4.0) /
 CPTDAY30                     (F4.0) /
 CPTDAY31                     (F4.0) /
 CPTDAY32                     (F4.0) /
 CPTDAY33                     (F4.0) /
 CPTDAY34                     (F4.0) /
 CPTDAY35                     (F4.0) /
 CPTDAY36                     (F4.0) /
 CPTDAY37                     (F4.0) /
 CPTDAY38                     (F4.0) /
 CPTDAY39                     (F4.0) /
 CPTDAY40                     (F4.0) /
 CPTDAY41                     (F4.0) /
 CPTDAY42                     (F4.0) /
 CPTDAY43                     (F4.0) /
 CPTDAY44                     (F4.0) /
 CPTDAY45                     (F4.0) /
 CPTDAY46                     (F4.0) /
 CPTDAY47                     (F4.0) /
 CPTDAY48                     (F4.0) /
 CPTDAY49                     (F4.0) /
 CPTDAY50                     (F4.0) /
 CPTDAY51                     (F4.0) /
 CPTDAY52                     (F4.0) /
 CPTDAY53                     (F4.0) /
 CPTDAY54                     (F4.0) /
 CPTDAY55                     (F4.0) /
 CPTDAY56                     (F4.0) /
 CPTDAY57                     (F4.0) /
 CPTDAY58                     (F4.0) /
 CPTDAY59                     (F4.0) /
 CPTDAY60                     (F4.0) /
 CPTDAY61                     (F4.0) /
 CPTDAY62                     (F4.0) /
 CPTDAY63                     (F4.0) /
 CPTDAY64                     (F4.0) /
 CPTDAY65                     (F4.0) /
 CPTDAY66                     (F4.0) /
 CPTDAY67                     (F4.0) /
 CPTDAY68                     (F4.0) /
 CPTDAY69                     (F4.0) /
 CPTDAY70                     (F4.0) /
 CPTDAY71                     (F4.0) /
 CPTDAY72                     (F4.0) /
 CPTDAY73                     (F4.0) /
 CPTDAY74                     (F4.0) /
 CPTDAY75                     (F4.0) /
 CPTDAY76                     (F4.0) /
 CPTDAY77                     (F4.0) /
 CPTDAY78                     (F4.0) /
 CPTDAY79                     (F4.0) /
 CPTDAY80                     (F4.0) /
 CPTDAY81                     (F4.0) /
 CPTDAY82                     (F4.0) /
 CPTDAY83                     (F4.0) /
 CPTDAY84                     (F4.0) /
 CPTDAY85                     (F4.0) /
 CPTDAY86                     (F4.0) /
 CPTDAY87                     (F4.0) /
 CPTDAY88                     (F4.0) /
 CPTDAY89                     (F4.0) /
 CPTDAY90                     (F4.0) /
 CPTDAY91                     (F4.0) /
 CPTDAY92                     (F4.0) /
 CPTDAY93                     (F4.0) /
 CPTDAY94                     (F4.0) /
 CPTDAY95                     (F4.0) /
 CPTDAY96                     (F4.0) /
 CPTDAY97                     (F4.0) /
 CPTDAY98                     (F4.0) /
 CPTDAY99                     (F4.0) /
 CPTDAY100                    (F4.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HCUP_SURGERY_BROAD_CPT       (F3.0) /
 HCUP_SURGERY_NARROW_CPT      (F3.0) /
 I10_NDX                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 NCPT                         (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO_GEO                    (F4.0) /
 SASD_SEDD                    (F3.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AGEGROUP                     (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) .


/***  Assign labels to the variables ***/
VARIABLE LABELS 
 AMONTH                       "Admission month"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPT51                        "CPT/HCPCS procedure code 51"
 CPT52                        "CPT/HCPCS procedure code 52"
 CPT53                        "CPT/HCPCS procedure code 53"
 CPT54                        "CPT/HCPCS procedure code 54"
 CPT55                        "CPT/HCPCS procedure code 55"
 CPT56                        "CPT/HCPCS procedure code 56"
 CPT57                        "CPT/HCPCS procedure code 57"
 CPT58                        "CPT/HCPCS procedure code 58"
 CPT59                        "CPT/HCPCS procedure code 59"
 CPT60                        "CPT/HCPCS procedure code 60"
 CPT61                        "CPT/HCPCS procedure code 61"
 CPT62                        "CPT/HCPCS procedure code 62"
 CPT63                        "CPT/HCPCS procedure code 63"
 CPT64                        "CPT/HCPCS procedure code 64"
 CPT65                        "CPT/HCPCS procedure code 65"
 CPT66                        "CPT/HCPCS procedure code 66"
 CPT67                        "CPT/HCPCS procedure code 67"
 CPT68                        "CPT/HCPCS procedure code 68"
 CPT69                        "CPT/HCPCS procedure code 69"
 CPT70                        "CPT/HCPCS procedure code 70"
 CPT71                        "CPT/HCPCS procedure code 71"
 CPT72                        "CPT/HCPCS procedure code 72"
 CPT73                        "CPT/HCPCS procedure code 73"
 CPT74                        "CPT/HCPCS procedure code 74"
 CPT75                        "CPT/HCPCS procedure code 75"
 CPT76                        "CPT/HCPCS procedure code 76"
 CPT77                        "CPT/HCPCS procedure code 77"
 CPT78                        "CPT/HCPCS procedure code 78"
 CPT79                        "CPT/HCPCS procedure code 79"
 CPT80                        "CPT/HCPCS procedure code 80"
 CPT81                        "CPT/HCPCS procedure code 81"
 CPT82                        "CPT/HCPCS procedure code 82"
 CPT83                        "CPT/HCPCS procedure code 83"
 CPT84                        "CPT/HCPCS procedure code 84"
 CPT85                        "CPT/HCPCS procedure code 85"
 CPT86                        "CPT/HCPCS procedure code 86"
 CPT87                        "CPT/HCPCS procedure code 87"
 CPT88                        "CPT/HCPCS procedure code 88"
 CPT89                        "CPT/HCPCS procedure code 89"
 CPT90                        "CPT/HCPCS procedure code 90"
 CPT91                        "CPT/HCPCS procedure code 91"
 CPT92                        "CPT/HCPCS procedure code 92"
 CPT93                        "CPT/HCPCS procedure code 93"
 CPT94                        "CPT/HCPCS procedure code 94"
 CPT95                        "CPT/HCPCS procedure code 95"
 CPT96                        "CPT/HCPCS procedure code 96"
 CPT97                        "CPT/HCPCS procedure code 97"
 CPT98                        "CPT/HCPCS procedure code 98"
 CPT99                        "CPT/HCPCS procedure code 99"
 CPT100                       "CPT/HCPCS procedure code 100"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTCCS51                     "CCS: CPT 51"
 CPTCCS52                     "CCS: CPT 52"
 CPTCCS53                     "CCS: CPT 53"
 CPTCCS54                     "CCS: CPT 54"
 CPTCCS55                     "CCS: CPT 55"
 CPTCCS56                     "CCS: CPT 56"
 CPTCCS57                     "CCS: CPT 57"
 CPTCCS58                     "CCS: CPT 58"
 CPTCCS59                     "CCS: CPT 59"
 CPTCCS60                     "CCS: CPT 60"
 CPTCCS61                     "CCS: CPT 61"
 CPTCCS62                     "CCS: CPT 62"
 CPTCCS63                     "CCS: CPT 63"
 CPTCCS64                     "CCS: CPT 64"
 CPTCCS65                     "CCS: CPT 65"
 CPTCCS66                     "CCS: CPT 66"
 CPTCCS67                     "CCS: CPT 67"
 CPTCCS68                     "CCS: CPT 68"
 CPTCCS69                     "CCS: CPT 69"
 CPTCCS70                     "CCS: CPT 70"
 CPTCCS71                     "CCS: CPT 71"
 CPTCCS72                     "CCS: CPT 72"
 CPTCCS73                     "CCS: CPT 73"
 CPTCCS74                     "CCS: CPT 74"
 CPTCCS75                     "CCS: CPT 75"
 CPTCCS76                     "CCS: CPT 76"
 CPTCCS77                     "CCS: CPT 77"
 CPTCCS78                     "CCS: CPT 78"
 CPTCCS79                     "CCS: CPT 79"
 CPTCCS80                     "CCS: CPT 80"
 CPTCCS81                     "CCS: CPT 81"
 CPTCCS82                     "CCS: CPT 82"
 CPTCCS83                     "CCS: CPT 83"
 CPTCCS84                     "CCS: CPT 84"
 CPTCCS85                     "CCS: CPT 85"
 CPTCCS86                     "CCS: CPT 86"
 CPTCCS87                     "CCS: CPT 87"
 CPTCCS88                     "CCS: CPT 88"
 CPTCCS89                     "CCS: CPT 89"
 CPTCCS90                     "CCS: CPT 90"
 CPTCCS91                     "CCS: CPT 91"
 CPTCCS92                     "CCS: CPT 92"
 CPTCCS93                     "CCS: CPT 93"
 CPTCCS94                     "CCS: CPT 94"
 CPTCCS95                     "CCS: CPT 95"
 CPTCCS96                     "CCS: CPT 96"
 CPTCCS97                     "CCS: CPT 97"
 CPTCCS98                     "CCS: CPT 98"
 CPTCCS99                     "CCS: CPT 99"
 CPTCCS100                    "CCS: CPT 100"
 CPTDAY1                      "Number of days from admission to CPT1"
 CPTDAY2                      "Number of days from admission to CPT2"
 CPTDAY3                      "Number of days from admission to CPT3"
 CPTDAY4                      "Number of days from admission to CPT4"
 CPTDAY5                      "Number of days from admission to CPT5"
 CPTDAY6                      "Number of days from admission to CPT6"
 CPTDAY7                      "Number of days from admission to CPT7"
 CPTDAY8                      "Number of days from admission to CPT8"
 CPTDAY9                      "Number of days from admission to CPT9"
 CPTDAY10                     "Number of days from admission to CPT10"
 CPTDAY11                     "Number of days from admission to CPT11"
 CPTDAY12                     "Number of days from admission to CPT12"
 CPTDAY13                     "Number of days from admission to CPT13"
 CPTDAY14                     "Number of days from admission to CPT14"
 CPTDAY15                     "Number of days from admission to CPT15"
 CPTDAY16                     "Number of days from admission to CPT16"
 CPTDAY17                     "Number of days from admission to CPT17"
 CPTDAY18                     "Number of days from admission to CPT18"
 CPTDAY19                     "Number of days from admission to CPT19"
 CPTDAY20                     "Number of days from admission to CPT20"
 CPTDAY21                     "Number of days from admission to CPT21"
 CPTDAY22                     "Number of days from admission to CPT22"
 CPTDAY23                     "Number of days from admission to CPT23"
 CPTDAY24                     "Number of days from admission to CPT24"
 CPTDAY25                     "Number of days from admission to CPT25"
 CPTDAY26                     "Number of days from admission to CPT26"
 CPTDAY27                     "Number of days from admission to CPT27"
 CPTDAY28                     "Number of days from admission to CPT28"
 CPTDAY29                     "Number of days from admission to CPT29"
 CPTDAY30                     "Number of days from admission to CPT30"
 CPTDAY31                     "Number of days from admission to CPT31"
 CPTDAY32                     "Number of days from admission to CPT32"
 CPTDAY33                     "Number of days from admission to CPT33"
 CPTDAY34                     "Number of days from admission to CPT34"
 CPTDAY35                     "Number of days from admission to CPT35"
 CPTDAY36                     "Number of days from admission to CPT36"
 CPTDAY37                     "Number of days from admission to CPT37"
 CPTDAY38                     "Number of days from admission to CPT38"
 CPTDAY39                     "Number of days from admission to CPT39"
 CPTDAY40                     "Number of days from admission to CPT40"
 CPTDAY41                     "Number of days from admission to CPT41"
 CPTDAY42                     "Number of days from admission to CPT42"
 CPTDAY43                     "Number of days from admission to CPT43"
 CPTDAY44                     "Number of days from admission to CPT44"
 CPTDAY45                     "Number of days from admission to CPT45"
 CPTDAY46                     "Number of days from admission to CPT46"
 CPTDAY47                     "Number of days from admission to CPT47"
 CPTDAY48                     "Number of days from admission to CPT48"
 CPTDAY49                     "Number of days from admission to CPT49"
 CPTDAY50                     "Number of days from admission to CPT50"
 CPTDAY51                     "Number of days from admission to CPT51"
 CPTDAY52                     "Number of days from admission to CPT52"
 CPTDAY53                     "Number of days from admission to CPT53"
 CPTDAY54                     "Number of days from admission to CPT54"
 CPTDAY55                     "Number of days from admission to CPT55"
 CPTDAY56                     "Number of days from admission to CPT56"
 CPTDAY57                     "Number of days from admission to CPT57"
 CPTDAY58                     "Number of days from admission to CPT58"
 CPTDAY59                     "Number of days from admission to CPT59"
 CPTDAY60                     "Number of days from admission to CPT60"
 CPTDAY61                     "Number of days from admission to CPT61"
 CPTDAY62                     "Number of days from admission to CPT62"
 CPTDAY63                     "Number of days from admission to CPT63"
 CPTDAY64                     "Number of days from admission to CPT64"
 CPTDAY65                     "Number of days from admission to CPT65"
 CPTDAY66                     "Number of days from admission to CPT66"
 CPTDAY67                     "Number of days from admission to CPT67"
 CPTDAY68                     "Number of days from admission to CPT68"
 CPTDAY69                     "Number of days from admission to CPT69"
 CPTDAY70                     "Number of days from admission to CPT70"
 CPTDAY71                     "Number of days from admission to CPT71"
 CPTDAY72                     "Number of days from admission to CPT72"
 CPTDAY73                     "Number of days from admission to CPT73"
 CPTDAY74                     "Number of days from admission to CPT74"
 CPTDAY75                     "Number of days from admission to CPT75"
 CPTDAY76                     "Number of days from admission to CPT76"
 CPTDAY77                     "Number of days from admission to CPT77"
 CPTDAY78                     "Number of days from admission to CPT78"
 CPTDAY79                     "Number of days from admission to CPT79"
 CPTDAY80                     "Number of days from admission to CPT80"
 CPTDAY81                     "Number of days from admission to CPT81"
 CPTDAY82                     "Number of days from admission to CPT82"
 CPTDAY83                     "Number of days from admission to CPT83"
 CPTDAY84                     "Number of days from admission to CPT84"
 CPTDAY85                     "Number of days from admission to CPT85"
 CPTDAY86                     "Number of days from admission to CPT86"
 CPTDAY87                     "Number of days from admission to CPT87"
 CPTDAY88                     "Number of days from admission to CPT88"
 CPTDAY89                     "Number of days from admission to CPT89"
 CPTDAY90                     "Number of days from admission to CPT90"
 CPTDAY91                     "Number of days from admission to CPT91"
 CPTDAY92                     "Number of days from admission to CPT92"
 CPTDAY93                     "Number of days from admission to CPT93"
 CPTDAY94                     "Number of days from admission to CPT94"
 CPTDAY95                     "Number of days from admission to CPT95"
 CPTDAY96                     "Number of days from admission to CPT96"
 CPTDAY97                     "Number of days from admission to CPT97"
 CPTDAY98                     "Number of days from admission to CPT98"
 CPTDAY99                     "Number of days from admission to CPT99"
 CPTDAY100                    "Number of days from admission to CPT100"
 CPTM1_1                      "First CPT-4/HCPCS modifier 1"
 CPTM1_2                      "First CPT-4/HCPCS modifier 2"
 CPTM1_3                      "First CPT-4/HCPCS modifier 3"
 CPTM1_4                      "First CPT-4/HCPCS modifier 4"
 CPTM1_5                      "First CPT-4/HCPCS modifier 5"
 CPTM1_6                      "First CPT-4/HCPCS modifier 6"
 CPTM1_7                      "First CPT-4/HCPCS modifier 7"
 CPTM1_8                      "First CPT-4/HCPCS modifier 8"
 CPTM1_9                      "First CPT-4/HCPCS modifier 9"
 CPTM1_10                     "First CPT-4/HCPCS modifier 10"
 CPTM1_11                     "First CPT-4/HCPCS modifier 11"
 CPTM1_12                     "First CPT-4/HCPCS modifier 12"
 CPTM1_13                     "First CPT-4/HCPCS modifier 13"
 CPTM1_14                     "First CPT-4/HCPCS modifier 14"
 CPTM1_15                     "First CPT-4/HCPCS modifier 15"
 CPTM1_16                     "First CPT-4/HCPCS modifier 16"
 CPTM1_17                     "First CPT-4/HCPCS modifier 17"
 CPTM1_18                     "First CPT-4/HCPCS modifier 18"
 CPTM1_19                     "First CPT-4/HCPCS modifier 19"
 CPTM1_20                     "First CPT-4/HCPCS modifier 20"
 CPTM1_21                     "First CPT-4/HCPCS modifier 21"
 CPTM1_22                     "First CPT-4/HCPCS modifier 22"
 CPTM1_23                     "First CPT-4/HCPCS modifier 23"
 CPTM1_24                     "First CPT-4/HCPCS modifier 24"
 CPTM1_25                     "First CPT-4/HCPCS modifier 25"
 CPTM1_26                     "First CPT-4/HCPCS modifier 26"
 CPTM1_27                     "First CPT-4/HCPCS modifier 27"
 CPTM1_28                     "First CPT-4/HCPCS modifier 28"
 CPTM1_29                     "First CPT-4/HCPCS modifier 29"
 CPTM1_30                     "First CPT-4/HCPCS modifier 30"
 CPTM1_31                     "First CPT-4/HCPCS modifier 31"
 CPTM1_32                     "First CPT-4/HCPCS modifier 32"
 CPTM1_33                     "First CPT-4/HCPCS modifier 33"
 CPTM1_34                     "First CPT-4/HCPCS modifier 34"
 CPTM1_35                     "First CPT-4/HCPCS modifier 35"
 CPTM1_36                     "First CPT-4/HCPCS modifier 36"
 CPTM1_37                     "First CPT-4/HCPCS modifier 37"
 CPTM1_38                     "First CPT-4/HCPCS modifier 38"
 CPTM1_39                     "First CPT-4/HCPCS modifier 39"
 CPTM1_40                     "First CPT-4/HCPCS modifier 40"
 CPTM1_41                     "First CPT-4/HCPCS modifier 41"
 CPTM1_42                     "First CPT-4/HCPCS modifier 42"
 CPTM1_43                     "First CPT-4/HCPCS modifier 43"
 CPTM1_44                     "First CPT-4/HCPCS modifier 44"
 CPTM1_45                     "First CPT-4/HCPCS modifier 45"
 CPTM1_46                     "First CPT-4/HCPCS modifier 46"
 CPTM1_47                     "First CPT-4/HCPCS modifier 47"
 CPTM1_48                     "First CPT-4/HCPCS modifier 48"
 CPTM1_49                     "First CPT-4/HCPCS modifier 49"
 CPTM1_50                     "First CPT-4/HCPCS modifier 50"
 CPTM1_51                     "First CPT-4/HCPCS modifier 51"
 CPTM1_52                     "First CPT-4/HCPCS modifier 52"
 CPTM1_53                     "First CPT-4/HCPCS modifier 53"
 CPTM1_54                     "First CPT-4/HCPCS modifier 54"
 CPTM1_55                     "First CPT-4/HCPCS modifier 55"
 CPTM1_56                     "First CPT-4/HCPCS modifier 56"
 CPTM1_57                     "First CPT-4/HCPCS modifier 57"
 CPTM1_58                     "First CPT-4/HCPCS modifier 58"
 CPTM1_59                     "First CPT-4/HCPCS modifier 59"
 CPTM1_60                     "First CPT-4/HCPCS modifier 60"
 CPTM1_61                     "First CPT-4/HCPCS modifier 61"
 CPTM1_62                     "First CPT-4/HCPCS modifier 62"
 CPTM1_63                     "First CPT-4/HCPCS modifier 63"
 CPTM1_64                     "First CPT-4/HCPCS modifier 64"
 CPTM1_65                     "First CPT-4/HCPCS modifier 65"
 CPTM1_66                     "First CPT-4/HCPCS modifier 66"
 CPTM1_67                     "First CPT-4/HCPCS modifier 67"
 CPTM1_68                     "First CPT-4/HCPCS modifier 68"
 CPTM1_69                     "First CPT-4/HCPCS modifier 69"
 CPTM1_70                     "First CPT-4/HCPCS modifier 70"
 CPTM1_71                     "First CPT-4/HCPCS modifier 71"
 CPTM1_72                     "First CPT-4/HCPCS modifier 72"
 CPTM1_73                     "First CPT-4/HCPCS modifier 73"
 CPTM1_74                     "First CPT-4/HCPCS modifier 74"
 CPTM1_75                     "First CPT-4/HCPCS modifier 75"
 CPTM1_76                     "First CPT-4/HCPCS modifier 76"
 CPTM1_77                     "First CPT-4/HCPCS modifier 77"
 CPTM1_78                     "First CPT-4/HCPCS modifier 78"
 CPTM1_79                     "First CPT-4/HCPCS modifier 79"
 CPTM1_80                     "First CPT-4/HCPCS modifier 80"
 CPTM1_81                     "First CPT-4/HCPCS modifier 81"
 CPTM1_82                     "First CPT-4/HCPCS modifier 82"
 CPTM1_83                     "First CPT-4/HCPCS modifier 83"
 CPTM1_84                     "First CPT-4/HCPCS modifier 84"
 CPTM1_85                     "First CPT-4/HCPCS modifier 85"
 CPTM1_86                     "First CPT-4/HCPCS modifier 86"
 CPTM1_87                     "First CPT-4/HCPCS modifier 87"
 CPTM1_88                     "First CPT-4/HCPCS modifier 88"
 CPTM1_89                     "First CPT-4/HCPCS modifier 89"
 CPTM1_90                     "First CPT-4/HCPCS modifier 90"
 CPTM1_91                     "First CPT-4/HCPCS modifier 91"
 CPTM1_92                     "First CPT-4/HCPCS modifier 92"
 CPTM1_93                     "First CPT-4/HCPCS modifier 93"
 CPTM1_94                     "First CPT-4/HCPCS modifier 94"
 CPTM1_95                     "First CPT-4/HCPCS modifier 95"
 CPTM1_96                     "First CPT-4/HCPCS modifier 96"
 CPTM1_97                     "First CPT-4/HCPCS modifier 97"
 CPTM1_98                     "First CPT-4/HCPCS modifier 98"
 CPTM1_99                     "First CPT-4/HCPCS modifier 99"
 CPTM1_100                    "First CPT-4/HCPCS modifier 100"
 CPTM2_1                      "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                      "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                      "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                      "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                      "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                      "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                      "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                      "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                      "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                     "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                     "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                     "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                     "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                     "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                     "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                     "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                     "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                     "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                     "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                     "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                     "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                     "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                     "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                     "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                     "Second CPT-4/HCPCS modifier 25"
 CPTM2_26                     "Second CPT-4/HCPCS modifier 26"
 CPTM2_27                     "Second CPT-4/HCPCS modifier 27"
 CPTM2_28                     "Second CPT-4/HCPCS modifier 28"
 CPTM2_29                     "Second CPT-4/HCPCS modifier 29"
 CPTM2_30                     "Second CPT-4/HCPCS modifier 30"
 CPTM2_31                     "Second CPT-4/HCPCS modifier 31"
 CPTM2_32                     "Second CPT-4/HCPCS modifier 32"
 CPTM2_33                     "Second CPT-4/HCPCS modifier 33"
 CPTM2_34                     "Second CPT-4/HCPCS modifier 34"
 CPTM2_35                     "Second CPT-4/HCPCS modifier 35"
 CPTM2_36                     "Second CPT-4/HCPCS modifier 36"
 CPTM2_37                     "Second CPT-4/HCPCS modifier 37"
 CPTM2_38                     "Second CPT-4/HCPCS modifier 38"
 CPTM2_39                     "Second CPT-4/HCPCS modifier 39"
 CPTM2_40                     "Second CPT-4/HCPCS modifier 40"
 CPTM2_41                     "Second CPT-4/HCPCS modifier 41"
 CPTM2_42                     "Second CPT-4/HCPCS modifier 42"
 CPTM2_43                     "Second CPT-4/HCPCS modifier 43"
 CPTM2_44                     "Second CPT-4/HCPCS modifier 44"
 CPTM2_45                     "Second CPT-4/HCPCS modifier 45"
 CPTM2_46                     "Second CPT-4/HCPCS modifier 46"
 CPTM2_47                     "Second CPT-4/HCPCS modifier 47"
 CPTM2_48                     "Second CPT-4/HCPCS modifier 48"
 CPTM2_49                     "Second CPT-4/HCPCS modifier 49"
 CPTM2_50                     "Second CPT-4/HCPCS modifier 50"
 CPTM2_51                     "Second CPT-4/HCPCS modifier 51"
 CPTM2_52                     "Second CPT-4/HCPCS modifier 52"
 CPTM2_53                     "Second CPT-4/HCPCS modifier 53"
 CPTM2_54                     "Second CPT-4/HCPCS modifier 54"
 CPTM2_55                     "Second CPT-4/HCPCS modifier 55"
 CPTM2_56                     "Second CPT-4/HCPCS modifier 56"
 CPTM2_57                     "Second CPT-4/HCPCS modifier 57"
 CPTM2_58                     "Second CPT-4/HCPCS modifier 58"
 CPTM2_59                     "Second CPT-4/HCPCS modifier 59"
 CPTM2_60                     "Second CPT-4/HCPCS modifier 60"
 CPTM2_61                     "Second CPT-4/HCPCS modifier 61"
 CPTM2_62                     "Second CPT-4/HCPCS modifier 62"
 CPTM2_63                     "Second CPT-4/HCPCS modifier 63"
 CPTM2_64                     "Second CPT-4/HCPCS modifier 64"
 CPTM2_65                     "Second CPT-4/HCPCS modifier 65"
 CPTM2_66                     "Second CPT-4/HCPCS modifier 66"
 CPTM2_67                     "Second CPT-4/HCPCS modifier 67"
 CPTM2_68                     "Second CPT-4/HCPCS modifier 68"
 CPTM2_69                     "Second CPT-4/HCPCS modifier 69"
 CPTM2_70                     "Second CPT-4/HCPCS modifier 70"
 CPTM2_71                     "Second CPT-4/HCPCS modifier 71"
 CPTM2_72                     "Second CPT-4/HCPCS modifier 72"
 CPTM2_73                     "Second CPT-4/HCPCS modifier 73"
 CPTM2_74                     "Second CPT-4/HCPCS modifier 74"
 CPTM2_75                     "Second CPT-4/HCPCS modifier 75"
 CPTM2_76                     "Second CPT-4/HCPCS modifier 76"
 CPTM2_77                     "Second CPT-4/HCPCS modifier 77"
 CPTM2_78                     "Second CPT-4/HCPCS modifier 78"
 CPTM2_79                     "Second CPT-4/HCPCS modifier 79"
 CPTM2_80                     "Second CPT-4/HCPCS modifier 80"
 CPTM2_81                     "Second CPT-4/HCPCS modifier 81"
 CPTM2_82                     "Second CPT-4/HCPCS modifier 82"
 CPTM2_83                     "Second CPT-4/HCPCS modifier 83"
 CPTM2_84                     "Second CPT-4/HCPCS modifier 84"
 CPTM2_85                     "Second CPT-4/HCPCS modifier 85"
 CPTM2_86                     "Second CPT-4/HCPCS modifier 86"
 CPTM2_87                     "Second CPT-4/HCPCS modifier 87"
 CPTM2_88                     "Second CPT-4/HCPCS modifier 88"
 CPTM2_89                     "Second CPT-4/HCPCS modifier 89"
 CPTM2_90                     "Second CPT-4/HCPCS modifier 90"
 CPTM2_91                     "Second CPT-4/HCPCS modifier 91"
 CPTM2_92                     "Second CPT-4/HCPCS modifier 92"
 CPTM2_93                     "Second CPT-4/HCPCS modifier 93"
 CPTM2_94                     "Second CPT-4/HCPCS modifier 94"
 CPTM2_95                     "Second CPT-4/HCPCS modifier 95"
 CPTM2_96                     "Second CPT-4/HCPCS modifier 96"
 CPTM2_97                     "Second CPT-4/HCPCS modifier 97"
 CPTM2_98                     "Second CPT-4/HCPCS modifier 98"
 CPTM2_99                     "Second CPT-4/HCPCS modifier 99"
 CPTM2_100                    "Second CPT-4/HCPCS modifier 100"
 DIED                         "Died during hospitalization"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HCUP_SURGERY_BROAD_CPT       "Number of reported CPT procedures that qualify as a surgery using a broad definition"
 HCUP_SURGERY_NARROW_CPT      "Number of reported CPT procedures that qualify as a surgery using a narrow definition"
 HOSPST                       "Hospital state postal code"
 I10_DX_Visit_Reason1         "ICD-10-CM Reason for visit diagnosis 1"
 I10_DX_Visit_Reason2         "ICD-10-CM Reason for visit diagnosis 2"
 I10_DX_Visit_Reason3         "ICD-10-CM Reason for visit diagnosis 3"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 MDSPEC1                      "Physician 1 specialty (as received from source)"
 MDSPEC2                      "Physician 2 specialty (as received from source)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 OPservice                    "Indicator of outpatient service (as received from source)"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY3                         "Tertiary expected payer (uniform)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PSTATE                       "Patient State postal code"
 PSTATE_GEO                   "Patient State postal code assigned from ZIP Code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO_GEO                    "Counties assigned based on ZIP Code geographic centroids"
 SASD_SEDD                    "SASD and SEDD indicator"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 YEAR                         "Calendar year"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AGEGROUP                     " "
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year" .


/**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************/

RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS53
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS54
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS55
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS56
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS57
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS58
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS59
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS60
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS61
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS62
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS63
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS64
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS65
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS66
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS67
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS68
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS69
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS70
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS71
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS72
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS73
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS74
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS75
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS76
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS77
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS78
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS79
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS80
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS81
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS82
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS83
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS84
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS85
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS86
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS87
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS88
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS89
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS90
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS91
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS92
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS93
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS94
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS95
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS96
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS97
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS98
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS99
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS100
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY53
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY54
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY55
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY56
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY57
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY58
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY59
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY60
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY61
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY62
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY63
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY64
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY65
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY66
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY67
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY68
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY69
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY70
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY71
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY72
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY73
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY74
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY75
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY76
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY77
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY78
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY79
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY80
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY81
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY82
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY83
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY84
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY85
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY86
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY87
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY88
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY89
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY90
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY91
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY92
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY93
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY94
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY95
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY96
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY97
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY98
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY99
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY100
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_SURGERY_BROAD_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HCUP_SURGERY_NARROW_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO_GEO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE SASD_SEDD
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEGROUP
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'ME_SEDD_2021_CORE.sav' /COMPRESSED.
