/*******************************************************************
*   ME_SEDD_2008_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'ME_SEDD_2008_CORE.ASC' FIXED / 
 AMONTH                     1-   2
 ASOURCE                    3-   4
 AWEEKEND                   5-   6
 BILLTYPE                   7-  10 (A)
 CPT1                      11-  15 (A)
 CPT2                      16-  20 (A)
 CPT3                      21-  25 (A)
 CPT4                      26-  30 (A)
 CPT5                      31-  35 (A)
 CPT6                      36-  40 (A)
 CPT7                      41-  45 (A)
 CPT8                      46-  50 (A)
 CPT9                      51-  55 (A)
 CPT10                     56-  60 (A)
 CPT11                     61-  65 (A)
 CPT12                     66-  70 (A)
 CPT13                     71-  75 (A)
 CPT14                     76-  80 (A)
 CPT15                     81-  85 (A)
 CPT16                     86-  90 (A)
 CPT17                     91-  95 (A)
 CPT18                     96- 100 (A)
 CPT19                    101- 105 (A)
 CPT20                    106- 110 (A)
 CPT21                    111- 115 (A)
 CPT22                    116- 120 (A)
 CPT23                    121- 125 (A)
 CPT24                    126- 130 (A)
 CPT25                    131- 135 (A)
 CPT26                    136- 140 (A)
 CPT27                    141- 145 (A)
 CPT28                    146- 150 (A)
 CPT29                    151- 155 (A)
 CPT30                    156- 160 (A)
 CPTCCS1                  161- 163
 CPTCCS2                  164- 166
 CPTCCS3                  167- 169
 CPTCCS4                  170- 172
 CPTCCS5                  173- 175
 CPTCCS6                  176- 178
 CPTCCS7                  179- 181
 CPTCCS8                  182- 184
 CPTCCS9                  185- 187
 CPTCCS10                 188- 190
 CPTCCS11                 191- 193
 CPTCCS12                 194- 196
 CPTCCS13                 197- 199
 CPTCCS14                 200- 202
 CPTCCS15                 203- 205
 CPTCCS16                 206- 208
 CPTCCS17                 209- 211
 CPTCCS18                 212- 214
 CPTCCS19                 215- 217
 CPTCCS20                 218- 220
 CPTCCS21                 221- 223
 CPTCCS22                 224- 226
 CPTCCS23                 227- 229
 CPTCCS24                 230- 232
 CPTCCS25                 233- 235
 CPTCCS26                 236- 238
 CPTCCS27                 239- 241
 CPTCCS28                 242- 244
 CPTCCS29                 245- 247
 CPTCCS30                 248- 250
 CPTDAY1                  251- 253
 CPTDAY2                  254- 256
 CPTDAY3                  257- 259
 CPTDAY4                  260- 262
 CPTDAY5                  263- 265
 CPTDAY6                  266- 268
 CPTDAY7                  269- 271
 CPTDAY8                  272- 274
 CPTDAY9                  275- 277
 CPTDAY10                 278- 280
 CPTDAY11                 281- 283
 CPTDAY12                 284- 286
 CPTDAY13                 287- 289
 CPTDAY14                 290- 292
 CPTDAY15                 293- 295
 CPTDAY16                 296- 298
 CPTDAY17                 299- 301
 CPTDAY18                 302- 304
 CPTDAY19                 305- 307
 CPTDAY20                 308- 310
 CPTDAY21                 311- 313
 CPTDAY22                 314- 316
 CPTDAY23                 317- 319
 CPTDAY24                 320- 322
 CPTDAY25                 323- 325
 CPTDAY26                 326- 328
 CPTDAY27                 329- 331
 CPTDAY28                 332- 334
 CPTDAY29                 335- 337
 CPTDAY30                 338- 340
 CPTM1_1                  341- 342 (A)
 CPTM1_2                  343- 344 (A)
 CPTM1_3                  345- 346 (A)
 CPTM1_4                  347- 348 (A)
 CPTM1_5                  349- 350 (A)
 CPTM1_6                  351- 352 (A)
 CPTM1_7                  353- 354 (A)
 CPTM1_8                  355- 356 (A)
 CPTM1_9                  357- 358 (A)
 CPTM1_10                 359- 360 (A)
 CPTM1_11                 361- 362 (A)
 CPTM1_12                 363- 364 (A)
 CPTM1_13                 365- 366 (A)
 CPTM1_14                 367- 368 (A)
 CPTM1_15                 369- 370 (A)
 CPTM1_16                 371- 372 (A)
 CPTM1_17                 373- 374 (A)
 CPTM1_18                 375- 376 (A)
 CPTM1_19                 377- 378 (A)
 CPTM1_20                 379- 380 (A)
 CPTM1_21                 381- 382 (A)
 CPTM1_22                 383- 384 (A)
 CPTM1_23                 385- 386 (A)
 CPTM1_24                 387- 388 (A)
 CPTM1_25                 389- 390 (A)
 CPTM1_26                 391- 392 (A)
 CPTM1_27                 393- 394 (A)
 CPTM1_28                 395- 396 (A)
 CPTM1_29                 397- 398 (A)
 CPTM1_30                 399- 400 (A)
 CPTM2_1                  401- 402 (A)
 CPTM2_2                  403- 404 (A)
 CPTM2_3                  405- 406 (A)
 CPTM2_4                  407- 408 (A)
 CPTM2_5                  409- 410 (A)
 CPTM2_6                  411- 412 (A)
 CPTM2_7                  413- 414 (A)
 CPTM2_8                  415- 416 (A)
 CPTM2_9                  417- 418 (A)
 CPTM2_10                 419- 420 (A)
 CPTM2_11                 421- 422 (A)
 CPTM2_12                 423- 424 (A)
 CPTM2_13                 425- 426 (A)
 CPTM2_14                 427- 428 (A)
 CPTM2_15                 429- 430 (A)
 CPTM2_16                 431- 432 (A)
 CPTM2_17                 433- 434 (A)
 CPTM2_18                 435- 436 (A)
 CPTM2_19                 437- 438 (A)
 CPTM2_20                 439- 440 (A)
 CPTM2_21                 441- 442 (A)
 CPTM2_22                 443- 444 (A)
 CPTM2_23                 445- 446 (A)
 CPTM2_24                 447- 448 (A)
 CPTM2_25                 449- 450 (A)
 CPTM2_26                 451- 452 (A)
 CPTM2_27                 453- 454 (A)
 CPTM2_28                 455- 456 (A)
 CPTM2_29                 457- 458 (A)
 CPTM2_30                 459- 460 (A)
 DIED                     461- 462
 DISPUB04                 463- 464
 DISPUNIF                 465- 466
 DQTR                     467- 468
 DX1                      469- 473 (A)
 DX2                      474- 478 (A)
 DX3                      479- 483 (A)
 DX4                      484- 488 (A)
 DX5                      489- 493 (A)
 DX6                      494- 498 (A)
 DX7                      499- 503 (A)
 DX8                      504- 508 (A)
 DX9                      509- 513 (A)
 DXCCS1                   514- 517
 DXCCS2                   518- 521
 DXCCS3                   522- 525
 DXCCS4                   526- 529
 DXCCS5                   530- 533
 DXCCS6                   534- 537
 DXCCS7                   538- 541
 DXCCS8                   542- 545
 DXCCS9                   546- 549
 ECODE1                   550- 554 (A)
 ECODE2                   555- 559 (A)
 ECODE3                   560- 564 (A)
 ECODE4                   565- 569 (A)
 ECODE5                   570- 574 (A)
 E_CCS1                   575- 578
 E_CCS2                   579- 582
 E_CCS3                   583- 586
 E_CCS4                   587- 590
 E_CCS5                   591- 594
 FEMALE                   595- 596
 HCUP_AS                  597- 598
 HCUP_ED                  599- 600
 HCUP_OS                  601- 602
 HISPANIC                 603     (A)
 HOSPBRTH                 604- 606
 HOSPST                   607- 608 (A)
 KEY                      609- 622
 LOS                      623- 627
 MDSPEC1                  628- 629 (A)
 MDSPEC2                  630- 631 (A)
 MEDINCST                 632- 633
 MRN_R                    634- 642
 NCPT                     643- 645
 NDX                      646- 647
 NECODE                   648- 649
 NEOMAT                   650- 651
 PAY1                     652- 653
 PL_CBSA                  654- 656
 PL_MSA19                 657- 659
 PL_NCHS2                 660- 661
 PL_RUCA4                 662- 663
 PL_UIC20                 664- 665
 PL_UR_CA                 666- 667
 PROCTYPE                 668- 670
 PSTATE                   671- 672 (A)
 PSTCO                    673- 677
 PSTCO2                   678- 682
 POFOUB04                 683     (A)
 RACE                     684- 685
 RACE_X                   686     (A)
 STATE_AS                 687- 688
 STATE_ED                 689- 690
 STATE_OS                 691- 692
 YEAR                     693- 696
 ZIP3                     697- 699 (A)
 ZIPINC_Q                 700- 702
 ZIP_S                    703- 707 (A)
 AGEGROUP                 708- 710
 HOSPID                   711- 715
 AYEAR                    716- 719
 DMONTH                   720- 721.


***  Specify write formats  ***.
FORMATS
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 AWEEKEND                (F3.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 CPTCCS21                (F4.0) /
 CPTCCS22                (F4.0) /
 CPTCCS23                (F4.0) /
 CPTCCS24                (F4.0) /
 CPTCCS25                (F4.0) /
 CPTCCS26                (F4.0) /
 CPTCCS27                (F4.0) /
 CPTCCS28                (F4.0) /
 CPTCCS29                (F4.0) /
 CPTCCS30                (F4.0) /
 CPTDAY1                 (F4.0) /
 CPTDAY2                 (F4.0) /
 CPTDAY3                 (F4.0) /
 CPTDAY4                 (F4.0) /
 CPTDAY5                 (F4.0) /
 CPTDAY6                 (F4.0) /
 CPTDAY7                 (F4.0) /
 CPTDAY8                 (F4.0) /
 CPTDAY9                 (F4.0) /
 CPTDAY10                (F4.0) /
 CPTDAY11                (F4.0) /
 CPTDAY12                (F4.0) /
 CPTDAY13                (F4.0) /
 CPTDAY14                (F4.0) /
 CPTDAY15                (F4.0) /
 CPTDAY16                (F4.0) /
 CPTDAY17                (F4.0) /
 CPTDAY18                (F4.0) /
 CPTDAY19                (F4.0) /
 CPTDAY20                (F4.0) /
 CPTDAY21                (F4.0) /
 CPTDAY22                (F4.0) /
 CPTDAY23                (F4.0) /
 CPTDAY24                (F4.0) /
 CPTDAY25                (F4.0) /
 CPTDAY26                (F4.0) /
 CPTDAY27                (F4.0) /
 CPTDAY28                (F4.0) /
 CPTDAY29                (F4.0) /
 CPTDAY30                (F4.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 MEDINCST                (F3.0) /
 MRN_R                   (F5.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NCHS2                (F3.0) /
 PL_RUCA4                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AGEGROUP                (F8.0) /
 HOSPID                  (F4.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 AWEEKEND  "Admission day is a weekend"
 BILLTYPE  "UB-92 bill type"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 CPT16     "CPT/HCPCS procedure code 16"
 CPT17     "CPT/HCPCS procedure code 17"
 CPT18     "CPT/HCPCS procedure code 18"
 CPT19     "CPT/HCPCS procedure code 19"
 CPT20     "CPT/HCPCS procedure code 20"
 CPT21     "CPT/HCPCS procedure code 21"
 CPT22     "CPT/HCPCS procedure code 22"
 CPT23     "CPT/HCPCS procedure code 23"
 CPT24     "CPT/HCPCS procedure code 24"
 CPT25     "CPT/HCPCS procedure code 25"
 CPT26     "CPT/HCPCS procedure code 26"
 CPT27     "CPT/HCPCS procedure code 27"
 CPT28     "CPT/HCPCS procedure code 28"
 CPT29     "CPT/HCPCS procedure code 29"
 CPT30     "CPT/HCPCS procedure code 30"
 CPTCCS1   "CCS: CPT 1"
 CPTCCS2   "CCS: CPT 2"
 CPTCCS3   "CCS: CPT 3"
 CPTCCS4   "CCS: CPT 4"
 CPTCCS5   "CCS: CPT 5"
 CPTCCS6   "CCS: CPT 6"
 CPTCCS7   "CCS: CPT 7"
 CPTCCS8   "CCS: CPT 8"
 CPTCCS9   "CCS: CPT 9"
 CPTCCS10  "CCS: CPT 10"
 CPTCCS11  "CCS: CPT 11"
 CPTCCS12  "CCS: CPT 12"
 CPTCCS13  "CCS: CPT 13"
 CPTCCS14  "CCS: CPT 14"
 CPTCCS15  "CCS: CPT 15"
 CPTCCS16  "CCS: CPT 16"
 CPTCCS17  "CCS: CPT 17"
 CPTCCS18  "CCS: CPT 18"
 CPTCCS19  "CCS: CPT 19"
 CPTCCS20  "CCS: CPT 20"
 CPTCCS21  "CCS: CPT 21"
 CPTCCS22  "CCS: CPT 22"
 CPTCCS23  "CCS: CPT 23"
 CPTCCS24  "CCS: CPT 24"
 CPTCCS25  "CCS: CPT 25"
 CPTCCS26  "CCS: CPT 26"
 CPTCCS27  "CCS: CPT 27"
 CPTCCS28  "CCS: CPT 28"
 CPTCCS29  "CCS: CPT 29"
 CPTCCS30  "CCS: CPT 30"
 CPTDAY1   "Number of days from admission to CPT1"
 CPTDAY2   "Number of days from admission to CPT2"
 CPTDAY3   "Number of days from admission to CPT3"
 CPTDAY4   "Number of days from admission to CPT4"
 CPTDAY5   "Number of days from admission to CPT5"
 CPTDAY6   "Number of days from admission to CPT6"
 CPTDAY7   "Number of days from admission to CPT7"
 CPTDAY8   "Number of days from admission to CPT8"
 CPTDAY9   "Number of days from admission to CPT9"
 CPTDAY10  "Number of days from admission to CPT10"
 CPTDAY11  "Number of days from admission to CPT11"
 CPTDAY12  "Number of days from admission to CPT12"
 CPTDAY13  "Number of days from admission to CPT13"
 CPTDAY14  "Number of days from admission to CPT14"
 CPTDAY15  "Number of days from admission to CPT15"
 CPTDAY16  "Number of days from admission to CPT16"
 CPTDAY17  "Number of days from admission to CPT17"
 CPTDAY18  "Number of days from admission to CPT18"
 CPTDAY19  "Number of days from admission to CPT19"
 CPTDAY20  "Number of days from admission to CPT20"
 CPTDAY21  "Number of days from admission to CPT21"
 CPTDAY22  "Number of days from admission to CPT22"
 CPTDAY23  "Number of days from admission to CPT23"
 CPTDAY24  "Number of days from admission to CPT24"
 CPTDAY25  "Number of days from admission to CPT25"
 CPTDAY26  "Number of days from admission to CPT26"
 CPTDAY27  "Number of days from admission to CPT27"
 CPTDAY28  "Number of days from admission to CPT28"
 CPTDAY29  "Number of days from admission to CPT29"
 CPTDAY30  "Number of days from admission to CPT30"
 CPTM1_1   "First CPT-4/HCPCS modifier 1"
 CPTM1_2   "First CPT-4/HCPCS modifier 2"
 CPTM1_3   "First CPT-4/HCPCS modifier 3"
 CPTM1_4   "First CPT-4/HCPCS modifier 4"
 CPTM1_5   "First CPT-4/HCPCS modifier 5"
 CPTM1_6   "First CPT-4/HCPCS modifier 6"
 CPTM1_7   "First CPT-4/HCPCS modifier 7"
 CPTM1_8   "First CPT-4/HCPCS modifier 8"
 CPTM1_9   "First CPT-4/HCPCS modifier 9"
 CPTM1_10  "First CPT-4/HCPCS modifier 10"
 CPTM1_11  "First CPT-4/HCPCS modifier 11"
 CPTM1_12  "First CPT-4/HCPCS modifier 12"
 CPTM1_13  "First CPT-4/HCPCS modifier 13"
 CPTM1_14  "First CPT-4/HCPCS modifier 14"
 CPTM1_15  "First CPT-4/HCPCS modifier 15"
 CPTM1_16  "First CPT-4/HCPCS modifier 16"
 CPTM1_17  "First CPT-4/HCPCS modifier 17"
 CPTM1_18  "First CPT-4/HCPCS modifier 18"
 CPTM1_19  "First CPT-4/HCPCS modifier 19"
 CPTM1_20  "First CPT-4/HCPCS modifier 20"
 CPTM1_21  "First CPT-4/HCPCS modifier 21"
 CPTM1_22  "First CPT-4/HCPCS modifier 22"
 CPTM1_23  "First CPT-4/HCPCS modifier 23"
 CPTM1_24  "First CPT-4/HCPCS modifier 24"
 CPTM1_25  "First CPT-4/HCPCS modifier 25"
 CPTM1_26  "First CPT-4/HCPCS modifier 26"
 CPTM1_27  "First CPT-4/HCPCS modifier 27"
 CPTM1_28  "First CPT-4/HCPCS modifier 28"
 CPTM1_29  "First CPT-4/HCPCS modifier 29"
 CPTM1_30  "First CPT-4/HCPCS modifier 30"
 CPTM2_1   "Second CPT-4/HCPCS modifier 1"
 CPTM2_2   "Second CPT-4/HCPCS modifier 2"
 CPTM2_3   "Second CPT-4/HCPCS modifier 3"
 CPTM2_4   "Second CPT-4/HCPCS modifier 4"
 CPTM2_5   "Second CPT-4/HCPCS modifier 5"
 CPTM2_6   "Second CPT-4/HCPCS modifier 6"
 CPTM2_7   "Second CPT-4/HCPCS modifier 7"
 CPTM2_8   "Second CPT-4/HCPCS modifier 8"
 CPTM2_9   "Second CPT-4/HCPCS modifier 9"
 CPTM2_10  "Second CPT-4/HCPCS modifier 10"
 CPTM2_11  "Second CPT-4/HCPCS modifier 11"
 CPTM2_12  "Second CPT-4/HCPCS modifier 12"
 CPTM2_13  "Second CPT-4/HCPCS modifier 13"
 CPTM2_14  "Second CPT-4/HCPCS modifier 14"
 CPTM2_15  "Second CPT-4/HCPCS modifier 15"
 CPTM2_16  "Second CPT-4/HCPCS modifier 16"
 CPTM2_17  "Second CPT-4/HCPCS modifier 17"
 CPTM2_18  "Second CPT-4/HCPCS modifier 18"
 CPTM2_19  "Second CPT-4/HCPCS modifier 19"
 CPTM2_20  "Second CPT-4/HCPCS modifier 20"
 CPTM2_21  "Second CPT-4/HCPCS modifier 21"
 CPTM2_22  "Second CPT-4/HCPCS modifier 22"
 CPTM2_23  "Second CPT-4/HCPCS modifier 23"
 CPTM2_24  "Second CPT-4/HCPCS modifier 24"
 CPTM2_25  "Second CPT-4/HCPCS modifier 25"
 CPTM2_26  "Second CPT-4/HCPCS modifier 26"
 CPTM2_27  "Second CPT-4/HCPCS modifier 27"
 CPTM2_28  "Second CPT-4/HCPCS modifier 28"
 CPTM2_29  "Second CPT-4/HCPCS modifier 29"
 CPTM2_30  "Second CPT-4/HCPCS modifier 30"
 DIED      "Died during hospitalization"
 DISPUB04  "Disposition of patient (UB-04 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DX1       "Diagnosis 1"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DXCCS1    "CCS: diagnosis 1"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HISPANIC  "Hispanic ethnicity (as received from source)"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 KEY       "HCUP record identifier"
 LOS       "Length of stay (cleaned)"
 MDSPEC1   "Physician 1 specialty (as received from source)"
 MDSPEC2   "Physician 2 specialty (as received from source)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 MRN_R     "Medical record number (re-identified)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 PAY1      "Primary expected payer (uniform)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO     "Patient state/county FIPS code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 POFOUB04  "Point of origin for admission or visit, UB-04 standard coding"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 YEAR      "Calendar year"
 ZIP3      "Patient ZIP Code, first 3 digits"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 ZIP_S     "Patient ZIP Code (synthetic)"
 AGEGROUP  " "
 HOSPID    "HCUP hospital identification number"
 AYEAR     "Admission year"
 DMONTH    "Discharge month" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY30
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEGROUP
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'ME_SEDD_2008_CORE.SAV' /COMPRESSED.
