/*******************************************************************
*   MD_SEDD_2005_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MD_SEDD_2005_CHGS.ASC' FIXED / 
 KEY                        1-  14
 APG                       15-  17
 CHARGE                    18-  29
 CPTHCPCS                  30-  34 (A)
 CPTMod1                   35-  36 (A)
 CPTMod2                   37-  38 (A)
 REVCODE                   39-  42 (A)
 SERVDAY                   43-  47
 UNITS                     48-  55.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 APG                     (F3.0) /
 CHARGE                  (F6.2) /
 SERVDAY                 (F3.0) /
 UNITS                   (F4.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 APG       "Ambulatory Patient Group (as received from source)"
 CHARGE    "Line item charges (as received from source)"
 CPTHCPCS  "Line item CPT-4/HCPCS procedure code (as received from source)"
 CPTMod1   "Line item CPT-4/HCPCS first modifier (as received from source)"
 CPTMod2   "Line item CPT-4/HCPCS second modifier (as received from source)"
 REVCODE   "Line item revenue code (as received from source)"
 SERVDAY   "Line item days from admission date"
 UNITS     "Line item units (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE APG
 (-99,-88,-66,-55=SYSMIS).
RECODE CHARGE
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE SERVDAY
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE UNITS
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).



SAVE OUTFILE = 'MD_SEDD_2005_CHGS.SAV' /COMPRESSED.
