/*******************************************************************
*   MD_SEDD_2004_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MD_SEDD_2004_CORE.ASC' FIXED / 
 KEY                        1-  14
 AGE                       15-  17
 AGEDAY                    18-  20
 AGEMONTH                  21-  23
 AWEEKEND                  24-  25
 CPT1                      26-  30 (A)
 CPT2                      31-  35 (A)
 CPT3                      36-  40 (A)
 CPT4                      41-  45 (A)
 CPT5                      46-  50 (A)
 CPT6                      51-  55 (A)
 CPT7                      56-  60 (A)
 CPT8                      61-  65 (A)
 CPT9                      66-  70 (A)
 CPT10                     71-  75 (A)
 CPT11                     76-  80 (A)
 CPT12                     81-  85 (A)
 CPT13                     86-  90 (A)
 CPT14                     91-  95 (A)
 CPT15                     96- 100 (A)
 CPT16                    101- 105 (A)
 CPT17                    106- 110 (A)
 CPT18                    111- 115 (A)
 CPT19                    116- 120 (A)
 CPT20                    121- 125 (A)
 CPT21                    126- 130 (A)
 CPT22                    131- 135 (A)
 CPT23                    136- 140 (A)
 CPT24                    141- 145 (A)
 CPT25                    146- 150 (A)
 CPT26                    151- 155 (A)
 CPT27                    156- 160 (A)
 CPT28                    161- 165 (A)
 CPT29                    166- 170 (A)
 CPT30                    171- 175 (A)
 CPT31                    176- 180 (A)
 CPT32                    181- 185 (A)
 CPT33                    186- 190 (A)
 CPT34                    191- 195 (A)
 CPT35                    196- 200 (A)
 CPT36                    201- 205 (A)
 CPT37                    206- 210 (A)
 CPT38                    211- 215 (A)
 CPT39                    216- 220 (A)
 CPT40                    221- 225 (A)
 CPT41                    226- 230 (A)
 CPT42                    231- 235 (A)
 CPT43                    236- 240 (A)
 CPT44                    241- 245 (A)
 CPT45                    246- 250 (A)
 CPT46                    251- 255 (A)
 CPT47                    256- 260 (A)
 CPT48                    261- 265 (A)
 CPT49                    266- 270 (A)
 CPT50                    271- 275 (A)
 CPT51                    276- 280 (A)
 CPT52                    281- 285 (A)
 CPT53                    286- 290 (A)
 CPT54                    291- 295 (A)
 CPT55                    296- 300 (A)
 CPT56                    301- 305 (A)
 CPT57                    306- 310 (A)
 CPT58                    311- 315 (A)
 CPT59                    316- 320 (A)
 CPT60                    321- 325 (A)
 CPT61                    326- 330 (A)
 CPT62                    331- 335 (A)
 CPT63                    336- 340 (A)
 CPT64                    341- 345 (A)
 CPT65                    346- 350 (A)
 CPT66                    351- 355 (A)
 CPT67                    356- 360 (A)
 CPT68                    361- 365 (A)
 CPT69                    366- 370 (A)
 CPT70                    371- 375 (A)
 CPT71                    376- 380 (A)
 CPT72                    381- 385 (A)
 CPT73                    386- 390 (A)
 CPT74                    391- 395 (A)
 CPT75                    396- 400 (A)
 CPT76                    401- 405 (A)
 CPT77                    406- 410 (A)
 CPT78                    411- 415 (A)
 CPT79                    416- 420 (A)
 CPT80                    421- 425 (A)
 CPT81                    426- 430 (A)
 CPT82                    431- 435 (A)
 CPT83                    436- 440 (A)
 CPT84                    441- 445 (A)
 CPT85                    446- 450 (A)
 CPT86                    451- 455 (A)
 CPT87                    456- 460 (A)
 CPT88                    461- 465 (A)
 CPT89                    466- 470 (A)
 CPT90                    471- 475 (A)
 CPT91                    476- 480 (A)
 CPT92                    481- 485 (A)
 CPT93                    486- 490 (A)
 CPT94                    491- 495 (A)
 CPT95                    496- 500 (A)
 CPT96                    501- 505 (A)
 CPT97                    506- 510 (A)
 CPT98                    511- 515 (A)
 CPT99                    516- 520 (A)
 CPT100                   521- 525 (A)
 DQTR                     526- 527
 DSHOSPID                 528- 540 (A)
 DX1                      541- 545 (A)
 DX2                      546- 550 (A)
 DX3                      551- 555 (A)
 DX4                      556- 560 (A)
 DX5                      561- 565 (A)
 DX6                      566- 570 (A)
 DX7                      571- 575 (A)
 DX8                      576- 580 (A)
 DX9                      581- 585 (A)
 DX10                     586- 590 (A)
 DX11                     591- 595 (A)
 DX12                     596- 600 (A)
 DX13                     601- 605 (A)
 DX14                     606- 610 (A)
 DX15                     611- 615 (A)
 DX16                     616- 620 (A)
 DX_Visit                 621- 625 (A)
 DXCCS1                   626- 629
 DXCCS2                   630- 633
 DXCCS3                   634- 637
 DXCCS4                   638- 641
 DXCCS5                   642- 645
 DXCCS6                   646- 649
 DXCCS7                   650- 653
 DXCCS8                   654- 657
 DXCCS9                   658- 661
 DXCCS10                  662- 665
 DXCCS11                  666- 669
 DXCCS12                  670- 673
 DXCCS13                  674- 677
 DXCCS14                  678- 681
 DXCCS15                  682- 685
 DXCCS16                  686- 689
 ECODE1                   690- 694 (A)
 ECODE2                   695- 699 (A)
 ECODE3                   700- 704 (A)
 ECODE4                   705- 709 (A)
 ECODE5                   710- 714 (A)
 ECODE6                   715- 719 (A)
 E_CCS1                   720- 723
 E_CCS2                   724- 727
 E_CCS3                   728- 731
 E_CCS4                   732- 735
 E_CCS5                   736- 739
 E_CCS6                   740- 743
 FEMALE                   744- 745
 HCUP_AS                  746- 747
 HCUP_ED                  748- 749
 HCUP_OS                  750- 751
 HOSPST                   752- 753 (A)
 LOS                      754- 758
 LOS_X                    759- 764
 MRN_R                    765- 773
 NCPT                     774- 776
 NDX                      777- 778
 NECODE                   779- 780
 NEOMAT                   781- 782
 PAY1                     783- 784
 PAY2                     785- 786
 PAY1_X                   787- 788 (A)
 PAY2_X                   789- 790 (A)
 PAYER1_X                 791- 792 (A)
 PAYER2_X                 793- 794 (A)
 PL_CBSA                  795- 797
 PL_MSA19                 798- 800
 PL_RUCA4                 801- 802
 PL_RUCC2                 803- 804
 PL_UIC20                 805- 806
 PL_UR_CA                 807- 808
 PL_UR_CA                 809- 810
 PSTATE                   811- 812 (A)
 PSTCO                    813- 817
 PSTCO2                   818- 822
 RACE                     823- 824
 RACE_X                   825     (A)
 STATE_AS                 826- 827
 STATE_ED                 828- 829
 STATE_OS                 830- 831
 TOTCHG                   832- 841
 TOTCHG_X                 842- 856
 YEAR                     857- 860
 ZIP3                     861- 863 (A)
 APG1                     864- 867
 APG2                     868- 871
 APG3                     872- 875
 APG4                     876- 879
 APG5                     880- 883
 APG6                     884- 887
 APG7                     888- 891
 APG8                     892- 895
 APG9                     896- 899
 APG10                    900- 903
 APG11                    904- 907
 APG12                    908- 911
 APG13                    912- 915
 APG14                    916- 919
 APG15                    920- 923
 APG16                    924- 927
 APG17                    928- 931
 APG18                    932- 935
 APG19                    936- 939
 APG20                    940- 943
 APG21                    944- 947
 APG22                    948- 951
 APG23                    952- 955
 APG24                    956- 959
 APG25                    960- 963
 APG26                    964- 967
 APG27                    968- 971
 APG28                    972- 975
 APG29                    976- 979
 APG30                    980- 983
 APG31                    984- 987
 APG32                    988- 991
 APG33                    992- 995
 APG34                    996- 999
 APG35                   1000-1003
 APG36                   1004-1007
 APG37                   1008-1011
 APG38                   1012-1015
 APG39                   1016-1019
 APG40                   1020-1023
 APG41                   1024-1027
 APG42                   1028-1031
 APG43                   1032-1035
 APG44                   1036-1039
 APG45                   1040-1043
 APG46                   1044-1047
 APG47                   1048-1051
 APG48                   1052-1055
 APG49                   1056-1059
 APG50                   1060-1063
 APG51                   1064-1067
 APG52                   1068-1071
 APG53                   1072-1075
 APG54                   1076-1079
 APG55                   1080-1083
 APG56                   1084-1087
 APG57                   1088-1091
 APG58                   1092-1095
 APG59                   1096-1099
 APG60                   1100-1103
 APG61                   1104-1107
 APG62                   1108-1111
 APG63                   1112-1115
 APG64                   1116-1119
 APG65                   1120-1123
 APG66                   1124-1127
 APG67                   1128-1131
 APG68                   1132-1135
 APG69                   1136-1139
 APG70                   1140-1143
 APG71                   1144-1147
 APG72                   1148-1151
 APG73                   1152-1155
 APG74                   1156-1159
 APG75                   1160-1163
 APG76                   1164-1167
 APG77                   1168-1171
 APG78                   1172-1175
 APG79                   1176-1179
 APG80                   1180-1183
 APG81                   1184-1187
 APG82                   1188-1191
 APG83                   1192-1195
 APG84                   1196-1199
 APG85                   1200-1203
 APG86                   1204-1207
 APG87                   1208-1211
 APG88                   1212-1215
 APG89                   1216-1219
 APG90                   1220-1223
 APG91                   1224-1227
 APG92                   1228-1231
 APG93                   1232-1235
 APG94                   1236-1239
 APG95                   1240-1243
 APG96                   1244-1247
 APG97                   1248-1251
 APG98                   1252-1255
 APG99                   1256-1259
 APG100                  1260-1263.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AWEEKEND                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MRN_R                   (F5.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PL_UR_CA                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 APG1                    (F3.0) /
 APG2                    (F3.0) /
 APG3                    (F3.0) /
 APG4                    (F3.0) /
 APG5                    (F3.0) /
 APG6                    (F3.0) /
 APG7                    (F3.0) /
 APG8                    (F3.0) /
 APG9                    (F3.0) /
 APG10                   (F3.0) /
 APG11                   (F3.0) /
 APG12                   (F3.0) /
 APG13                   (F3.0) /
 APG14                   (F3.0) /
 APG15                   (F3.0) /
 APG16                   (F3.0) /
 APG17                   (F3.0) /
 APG18                   (F3.0) /
 APG19                   (F3.0) /
 APG20                   (F3.0) /
 APG21                   (F3.0) /
 APG22                   (F3.0) /
 APG23                   (F3.0) /
 APG24                   (F3.0) /
 APG25                   (F3.0) /
 APG26                   (F3.0) /
 APG27                   (F3.0) /
 APG28                   (F3.0) /
 APG29                   (F3.0) /
 APG30                   (F3.0) /
 APG31                   (F3.0) /
 APG32                   (F3.0) /
 APG33                   (F3.0) /
 APG34                   (F3.0) /
 APG35                   (F3.0) /
 APG36                   (F3.0) /
 APG37                   (F3.0) /
 APG38                   (F3.0) /
 APG39                   (F3.0) /
 APG40                   (F3.0) /
 APG41                   (F3.0) /
 APG42                   (F3.0) /
 APG43                   (F3.0) /
 APG44                   (F3.0) /
 APG45                   (F3.0) /
 APG46                   (F3.0) /
 APG47                   (F3.0) /
 APG48                   (F3.0) /
 APG49                   (F3.0) /
 APG50                   (F3.0) /
 APG51                   (F3.0) /
 APG52                   (F3.0) /
 APG53                   (F3.0) /
 APG54                   (F3.0) /
 APG55                   (F3.0) /
 APG56                   (F3.0) /
 APG57                   (F3.0) /
 APG58                   (F3.0) /
 APG59                   (F3.0) /
 APG60                   (F3.0) /
 APG61                   (F3.0) /
 APG62                   (F3.0) /
 APG63                   (F3.0) /
 APG64                   (F3.0) /
 APG65                   (F3.0) /
 APG66                   (F3.0) /
 APG67                   (F3.0) /
 APG68                   (F3.0) /
 APG69                   (F3.0) /
 APG70                   (F3.0) /
 APG71                   (F3.0) /
 APG72                   (F3.0) /
 APG73                   (F3.0) /
 APG74                   (F3.0) /
 APG75                   (F3.0) /
 APG76                   (F3.0) /
 APG77                   (F3.0) /
 APG78                   (F3.0) /
 APG79                   (F3.0) /
 APG80                   (F3.0) /
 APG81                   (F3.0) /
 APG82                   (F3.0) /
 APG83                   (F3.0) /
 APG84                   (F3.0) /
 APG85                   (F3.0) /
 APG86                   (F3.0) /
 APG87                   (F3.0) /
 APG88                   (F3.0) /
 APG89                   (F3.0) /
 APG90                   (F3.0) /
 APG91                   (F3.0) /
 APG92                   (F3.0) /
 APG93                   (F3.0) /
 APG94                   (F3.0) /
 APG95                   (F3.0) /
 APG96                   (F3.0) /
 APG97                   (F3.0) /
 APG98                   (F3.0) /
 APG99                   (F3.0) /
 APG100                  (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 CPT16     "CPT/HCPCS procedure code 16"
 CPT17     "CPT/HCPCS procedure code 17"
 CPT18     "CPT/HCPCS procedure code 18"
 CPT19     "CPT/HCPCS procedure code 19"
 CPT20     "CPT/HCPCS procedure code 20"
 CPT21     "CPT/HCPCS procedure code 21"
 CPT22     "CPT/HCPCS procedure code 22"
 CPT23     "CPT/HCPCS procedure code 23"
 CPT24     "CPT/HCPCS procedure code 24"
 CPT25     "CPT/HCPCS procedure code 25"
 CPT26     "CPT/HCPCS procedure code 26"
 CPT27     "CPT/HCPCS procedure code 27"
 CPT28     "CPT/HCPCS procedure code 28"
 CPT29     "CPT/HCPCS procedure code 29"
 CPT30     "CPT/HCPCS procedure code 30"
 CPT31     "CPT/HCPCS procedure code 31"
 CPT32     "CPT/HCPCS procedure code 32"
 CPT33     "CPT/HCPCS procedure code 33"
 CPT34     "CPT/HCPCS procedure code 34"
 CPT35     "CPT/HCPCS procedure code 35"
 CPT36     "CPT/HCPCS procedure code 36"
 CPT37     "CPT/HCPCS procedure code 37"
 CPT38     "CPT/HCPCS procedure code 38"
 CPT39     "CPT/HCPCS procedure code 39"
 CPT40     "CPT/HCPCS procedure code 40"
 CPT41     "CPT/HCPCS procedure code 41"
 CPT42     "CPT/HCPCS procedure code 42"
 CPT43     "CPT/HCPCS procedure code 43"
 CPT44     "CPT/HCPCS procedure code 44"
 CPT45     "CPT/HCPCS procedure code 45"
 CPT46     "CPT/HCPCS procedure code 46"
 CPT47     "CPT/HCPCS procedure code 47"
 CPT48     "CPT/HCPCS procedure code 48"
 CPT49     "CPT/HCPCS procedure code 49"
 CPT50     "CPT/HCPCS procedure code 50"
 CPT51     "CPT/HCPCS procedure code 51"
 CPT52     "CPT/HCPCS procedure code 52"
 CPT53     "CPT/HCPCS procedure code 53"
 CPT54     "CPT/HCPCS procedure code 54"
 CPT55     "CPT/HCPCS procedure code 55"
 CPT56     "CPT/HCPCS procedure code 56"
 CPT57     "CPT/HCPCS procedure code 57"
 CPT58     "CPT/HCPCS procedure code 58"
 CPT59     "CPT/HCPCS procedure code 59"
 CPT60     "CPT/HCPCS procedure code 60"
 CPT61     "CPT/HCPCS procedure code 61"
 CPT62     "CPT/HCPCS procedure code 62"
 CPT63     "CPT/HCPCS procedure code 63"
 CPT64     "CPT/HCPCS procedure code 64"
 CPT65     "CPT/HCPCS procedure code 65"
 CPT66     "CPT/HCPCS procedure code 66"
 CPT67     "CPT/HCPCS procedure code 67"
 CPT68     "CPT/HCPCS procedure code 68"
 CPT69     "CPT/HCPCS procedure code 69"
 CPT70     "CPT/HCPCS procedure code 70"
 CPT71     "CPT/HCPCS procedure code 71"
 CPT72     "CPT/HCPCS procedure code 72"
 CPT73     "CPT/HCPCS procedure code 73"
 CPT74     "CPT/HCPCS procedure code 74"
 CPT75     "CPT/HCPCS procedure code 75"
 CPT76     "CPT/HCPCS procedure code 76"
 CPT77     "CPT/HCPCS procedure code 77"
 CPT78     "CPT/HCPCS procedure code 78"
 CPT79     "CPT/HCPCS procedure code 79"
 CPT80     "CPT/HCPCS procedure code 80"
 CPT81     "CPT/HCPCS procedure code 81"
 CPT82     "CPT/HCPCS procedure code 82"
 CPT83     "CPT/HCPCS procedure code 83"
 CPT84     "CPT/HCPCS procedure code 84"
 CPT85     "CPT/HCPCS procedure code 85"
 CPT86     "CPT/HCPCS procedure code 86"
 CPT87     "CPT/HCPCS procedure code 87"
 CPT88     "CPT/HCPCS procedure code 88"
 CPT89     "CPT/HCPCS procedure code 89"
 CPT90     "CPT/HCPCS procedure code 90"
 CPT91     "CPT/HCPCS procedure code 91"
 CPT92     "CPT/HCPCS procedure code 92"
 CPT93     "CPT/HCPCS procedure code 93"
 CPT94     "CPT/HCPCS procedure code 94"
 CPT95     "CPT/HCPCS procedure code 95"
 CPT96     "CPT/HCPCS procedure code 96"
 CPT97     "CPT/HCPCS procedure code 97"
 CPT98     "CPT/HCPCS procedure code 98"
 CPT99     "CPT/HCPCS procedure code 99"
 CPT100    "CPT/HCPCS procedure code 100"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX_Visit  "Reason for visit diagnosis"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MRN_R     "Medical record number (re-identified)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 PAY1      "Primary expected payer (uniform)"
 PAY2      "Secondary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PAYER1_X  "Primary expected payer plan identifier (as received from source)"
 PAYER2_X  "Secondary expected payer plan identifier (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CA  "Patient Location: Urban-Rural 5 Categories"
 PSTATE    "Patient State postal code"
 PSTCO     "Patient state/county FIPS code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIP3      "Patient ZIP Code, first 3 digits"
 APG1      "Ambulatory Patient Group 1 (as received from source)"
 APG2      "Ambulatory Patient Group 2 (as received from source)"
 APG3      "Ambulatory Patient Group 3 (as received from source)"
 APG4      "Ambulatory Patient Group 4 (as received from source)"
 APG5      "Ambulatory Patient Group 5 (as received from source)"
 APG6      "Ambulatory Patient Group 6 (as received from source)"
 APG7      "Ambulatory Patient Group 7 (as received from source)"
 APG8      "Ambulatory Patient Group 8 (as received from source)"
 APG9      "Ambulatory Patient Group 9 (as received from source)"
 APG10     "Ambulatory Patient Group 10 (as received from source)"
 APG11     "Ambulatory Patient Group 11 (as received from source)"
 APG12     "Ambulatory Patient Group 12 (as received from source)"
 APG13     "Ambulatory Patient Group 13 (as received from source)"
 APG14     "Ambulatory Patient Group 14 (as received from source)"
 APG15     "Ambulatory Patient Group 15 (as received from source)"
 APG16     "Ambulatory Patient Group 16 (as received from source)"
 APG17     "Ambulatory Patient Group 17 (as received from source)"
 APG18     "Ambulatory Patient Group 18 (as received from source)"
 APG19     "Ambulatory Patient Group 19 (as received from source)"
 APG20     "Ambulatory Patient Group 20 (as received from source)"
 APG21     "Ambulatory Patient Group 21 (as received from source)"
 APG22     "Ambulatory Patient Group 22 (as received from source)"
 APG23     "Ambulatory Patient Group 23 (as received from source)"
 APG24     "Ambulatory Patient Group 24 (as received from source)"
 APG25     "Ambulatory Patient Group 25 (as received from source)"
 APG26     "Ambulatory Patient Group 26 (as received from source)"
 APG27     "Ambulatory Patient Group 27 (as received from source)"
 APG28     "Ambulatory Patient Group 28 (as received from source)"
 APG29     "Ambulatory Patient Group 29 (as received from source)"
 APG30     "Ambulatory Patient Group 30 (as received from source)"
 APG31     "Ambulatory Patient Group 31 (as received from source)"
 APG32     "Ambulatory Patient Group 32 (as received from source)"
 APG33     "Ambulatory Patient Group 33 (as received from source)"
 APG34     "Ambulatory Patient Group 34 (as received from source)"
 APG35     "Ambulatory Patient Group 35 (as received from source)"
 APG36     "Ambulatory Patient Group 36 (as received from source)"
 APG37     "Ambulatory Patient Group 37 (as received from source)"
 APG38     "Ambulatory Patient Group 38 (as received from source)"
 APG39     "Ambulatory Patient Group 39 (as received from source)"
 APG40     "Ambulatory Patient Group 40 (as received from source)"
 APG41     "Ambulatory Patient Group 41 (as received from source)"
 APG42     "Ambulatory Patient Group 42 (as received from source)"
 APG43     "Ambulatory Patient Group 43 (as received from source)"
 APG44     "Ambulatory Patient Group 44 (as received from source)"
 APG45     "Ambulatory Patient Group 45 (as received from source)"
 APG46     "Ambulatory Patient Group 46 (as received from source)"
 APG47     "Ambulatory Patient Group 47 (as received from source)"
 APG48     "Ambulatory Patient Group 48 (as received from source)"
 APG49     "Ambulatory Patient Group 49 (as received from source)"
 APG50     "Ambulatory Patient Group 50 (as received from source)"
 APG51     "Ambulatory Patient Group 51 (as received from source)"
 APG52     "Ambulatory Patient Group 52 (as received from source)"
 APG53     "Ambulatory Patient Group 53 (as received from source)"
 APG54     "Ambulatory Patient Group 54 (as received from source)"
 APG55     "Ambulatory Patient Group 55 (as received from source)"
 APG56     "Ambulatory Patient Group 56 (as received from source)"
 APG57     "Ambulatory Patient Group 57 (as received from source)"
 APG58     "Ambulatory Patient Group 58 (as received from source)"
 APG59     "Ambulatory Patient Group 59 (as received from source)"
 APG60     "Ambulatory Patient Group 60 (as received from source)"
 APG61     "Ambulatory Patient Group 61 (as received from source)"
 APG62     "Ambulatory Patient Group 62 (as received from source)"
 APG63     "Ambulatory Patient Group 63 (as received from source)"
 APG64     "Ambulatory Patient Group 64 (as received from source)"
 APG65     "Ambulatory Patient Group 65 (as received from source)"
 APG66     "Ambulatory Patient Group 66 (as received from source)"
 APG67     "Ambulatory Patient Group 67 (as received from source)"
 APG68     "Ambulatory Patient Group 68 (as received from source)"
 APG69     "Ambulatory Patient Group 69 (as received from source)"
 APG70     "Ambulatory Patient Group 70 (as received from source)"
 APG71     "Ambulatory Patient Group 71 (as received from source)"
 APG72     "Ambulatory Patient Group 72 (as received from source)"
 APG73     "Ambulatory Patient Group 73 (as received from source)"
 APG74     "Ambulatory Patient Group 74 (as received from source)"
 APG75     "Ambulatory Patient Group 75 (as received from source)"
 APG76     "Ambulatory Patient Group 76 (as received from source)"
 APG77     "Ambulatory Patient Group 77 (as received from source)"
 APG78     "Ambulatory Patient Group 78 (as received from source)"
 APG79     "Ambulatory Patient Group 79 (as received from source)"
 APG80     "Ambulatory Patient Group 80 (as received from source)"
 APG81     "Ambulatory Patient Group 81 (as received from source)"
 APG82     "Ambulatory Patient Group 82 (as received from source)"
 APG83     "Ambulatory Patient Group 83 (as received from source)"
 APG84     "Ambulatory Patient Group 84 (as received from source)"
 APG85     "Ambulatory Patient Group 85 (as received from source)"
 APG86     "Ambulatory Patient Group 86 (as received from source)"
 APG87     "Ambulatory Patient Group 87 (as received from source)"
 APG88     "Ambulatory Patient Group 88 (as received from source)"
 APG89     "Ambulatory Patient Group 89 (as received from source)"
 APG90     "Ambulatory Patient Group 90 (as received from source)"
 APG91     "Ambulatory Patient Group 91 (as received from source)"
 APG92     "Ambulatory Patient Group 92 (as received from source)"
 APG93     "Ambulatory Patient Group 93 (as received from source)"
 APG94     "Ambulatory Patient Group 94 (as received from source)"
 APG95     "Ambulatory Patient Group 95 (as received from source)"
 APG96     "Ambulatory Patient Group 96 (as received from source)"
 APG97     "Ambulatory Patient Group 97 (as received from source)"
 APG98     "Ambulatory Patient Group 98 (as received from source)"
 APG99     "Ambulatory Patient Group 99 (as received from source)"
 APG100    "Ambulatory Patient Group 100 (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE APG1
 (-999,-888,-666,-555=SYSMIS).
RECODE APG2
 (-999,-888,-666,-555=SYSMIS).
RECODE APG3
 (-999,-888,-666,-555=SYSMIS).
RECODE APG4
 (-999,-888,-666,-555=SYSMIS).
RECODE APG5
 (-999,-888,-666,-555=SYSMIS).
RECODE APG6
 (-999,-888,-666,-555=SYSMIS).
RECODE APG7
 (-999,-888,-666,-555=SYSMIS).
RECODE APG8
 (-999,-888,-666,-555=SYSMIS).
RECODE APG9
 (-999,-888,-666,-555=SYSMIS).
RECODE APG10
 (-999,-888,-666,-555=SYSMIS).
RECODE APG11
 (-999,-888,-666,-555=SYSMIS).
RECODE APG12
 (-999,-888,-666,-555=SYSMIS).
RECODE APG13
 (-999,-888,-666,-555=SYSMIS).
RECODE APG14
 (-999,-888,-666,-555=SYSMIS).
RECODE APG15
 (-999,-888,-666,-555=SYSMIS).
RECODE APG16
 (-999,-888,-666,-555=SYSMIS).
RECODE APG17
 (-999,-888,-666,-555=SYSMIS).
RECODE APG18
 (-999,-888,-666,-555=SYSMIS).
RECODE APG19
 (-999,-888,-666,-555=SYSMIS).
RECODE APG20
 (-999,-888,-666,-555=SYSMIS).
RECODE APG21
 (-999,-888,-666,-555=SYSMIS).
RECODE APG22
 (-999,-888,-666,-555=SYSMIS).
RECODE APG23
 (-999,-888,-666,-555=SYSMIS).
RECODE APG24
 (-999,-888,-666,-555=SYSMIS).
RECODE APG25
 (-999,-888,-666,-555=SYSMIS).
RECODE APG26
 (-999,-888,-666,-555=SYSMIS).
RECODE APG27
 (-999,-888,-666,-555=SYSMIS).
RECODE APG28
 (-999,-888,-666,-555=SYSMIS).
RECODE APG29
 (-999,-888,-666,-555=SYSMIS).
RECODE APG30
 (-999,-888,-666,-555=SYSMIS).
RECODE APG31
 (-999,-888,-666,-555=SYSMIS).
RECODE APG32
 (-999,-888,-666,-555=SYSMIS).
RECODE APG33
 (-999,-888,-666,-555=SYSMIS).
RECODE APG34
 (-999,-888,-666,-555=SYSMIS).
RECODE APG35
 (-999,-888,-666,-555=SYSMIS).
RECODE APG36
 (-999,-888,-666,-555=SYSMIS).
RECODE APG37
 (-999,-888,-666,-555=SYSMIS).
RECODE APG38
 (-999,-888,-666,-555=SYSMIS).
RECODE APG39
 (-999,-888,-666,-555=SYSMIS).
RECODE APG40
 (-999,-888,-666,-555=SYSMIS).
RECODE APG41
 (-999,-888,-666,-555=SYSMIS).
RECODE APG42
 (-999,-888,-666,-555=SYSMIS).
RECODE APG43
 (-999,-888,-666,-555=SYSMIS).
RECODE APG44
 (-999,-888,-666,-555=SYSMIS).
RECODE APG45
 (-999,-888,-666,-555=SYSMIS).
RECODE APG46
 (-999,-888,-666,-555=SYSMIS).
RECODE APG47
 (-999,-888,-666,-555=SYSMIS).
RECODE APG48
 (-999,-888,-666,-555=SYSMIS).
RECODE APG49
 (-999,-888,-666,-555=SYSMIS).
RECODE APG50
 (-999,-888,-666,-555=SYSMIS).
RECODE APG51
 (-999,-888,-666,-555=SYSMIS).
RECODE APG52
 (-999,-888,-666,-555=SYSMIS).
RECODE APG53
 (-999,-888,-666,-555=SYSMIS).
RECODE APG54
 (-999,-888,-666,-555=SYSMIS).
RECODE APG55
 (-999,-888,-666,-555=SYSMIS).
RECODE APG56
 (-999,-888,-666,-555=SYSMIS).
RECODE APG57
 (-999,-888,-666,-555=SYSMIS).
RECODE APG58
 (-999,-888,-666,-555=SYSMIS).
RECODE APG59
 (-999,-888,-666,-555=SYSMIS).
RECODE APG60
 (-999,-888,-666,-555=SYSMIS).
RECODE APG61
 (-999,-888,-666,-555=SYSMIS).
RECODE APG62
 (-999,-888,-666,-555=SYSMIS).
RECODE APG63
 (-999,-888,-666,-555=SYSMIS).
RECODE APG64
 (-999,-888,-666,-555=SYSMIS).
RECODE APG65
 (-999,-888,-666,-555=SYSMIS).
RECODE APG66
 (-999,-888,-666,-555=SYSMIS).
RECODE APG67
 (-999,-888,-666,-555=SYSMIS).
RECODE APG68
 (-999,-888,-666,-555=SYSMIS).
RECODE APG69
 (-999,-888,-666,-555=SYSMIS).
RECODE APG70
 (-999,-888,-666,-555=SYSMIS).
RECODE APG71
 (-999,-888,-666,-555=SYSMIS).
RECODE APG72
 (-999,-888,-666,-555=SYSMIS).
RECODE APG73
 (-999,-888,-666,-555=SYSMIS).
RECODE APG74
 (-999,-888,-666,-555=SYSMIS).
RECODE APG75
 (-999,-888,-666,-555=SYSMIS).
RECODE APG76
 (-999,-888,-666,-555=SYSMIS).
RECODE APG77
 (-999,-888,-666,-555=SYSMIS).
RECODE APG78
 (-999,-888,-666,-555=SYSMIS).
RECODE APG79
 (-999,-888,-666,-555=SYSMIS).
RECODE APG80
 (-999,-888,-666,-555=SYSMIS).
RECODE APG81
 (-999,-888,-666,-555=SYSMIS).
RECODE APG82
 (-999,-888,-666,-555=SYSMIS).
RECODE APG83
 (-999,-888,-666,-555=SYSMIS).
RECODE APG84
 (-999,-888,-666,-555=SYSMIS).
RECODE APG85
 (-999,-888,-666,-555=SYSMIS).
RECODE APG86
 (-999,-888,-666,-555=SYSMIS).
RECODE APG87
 (-999,-888,-666,-555=SYSMIS).
RECODE APG88
 (-999,-888,-666,-555=SYSMIS).
RECODE APG89
 (-999,-888,-666,-555=SYSMIS).
RECODE APG90
 (-999,-888,-666,-555=SYSMIS).
RECODE APG91
 (-999,-888,-666,-555=SYSMIS).
RECODE APG92
 (-999,-888,-666,-555=SYSMIS).
RECODE APG93
 (-999,-888,-666,-555=SYSMIS).
RECODE APG94
 (-999,-888,-666,-555=SYSMIS).
RECODE APG95
 (-999,-888,-666,-555=SYSMIS).
RECODE APG96
 (-999,-888,-666,-555=SYSMIS).
RECODE APG97
 (-999,-888,-666,-555=SYSMIS).
RECODE APG98
 (-999,-888,-666,-555=SYSMIS).
RECODE APG99
 (-999,-888,-666,-555=SYSMIS).
RECODE APG100
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MD_SEDD_2004_CORE.SAV' /COMPRESSED.
