/*******************************************************************
*   MD_SEDD_2002_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MD_SEDD_2002_CORE.ASC' FIXED / 
 KEY                   1-  14
 AGE                  15-  17
 AGEDAY               18-  20
 AGEMONTH             21-  23
 AWEEKEND             24-  25
 CPT1                 26-  30 (A)
 CPT2                 31-  35 (A)
 CPT3                 36-  40 (A)
 CPT4                 41-  45 (A)
 CPT5                 46-  50 (A)
 CPT6                 51-  55 (A)
 CPT7                 56-  60 (A)
 CPT8                 61-  65 (A)
 CPT9                 66-  70 (A)
 CPT10                71-  75 (A)
 CPT11                76-  80 (A)
 CPT12                81-  85 (A)
 CPT13                86-  90 (A)
 CPT14                91-  95 (A)
 CPT15                96- 100 (A)
 CPT16               101- 105 (A)
 CPT17               106- 110 (A)
 CPT18               111- 115 (A)
 CPT19               116- 120 (A)
 CPT20               121- 125 (A)
 CPT21               126- 130 (A)
 CPT22               131- 135 (A)
 CPT23               136- 140 (A)
 CPT24               141- 145 (A)
 CPT25               146- 150 (A)
 CPT26               151- 155 (A)
 CPT27               156- 160 (A)
 CPT28               161- 165 (A)
 CPT29               166- 170 (A)
 CPT30               171- 175 (A)
 CPT31               176- 180 (A)
 CPT32               181- 185 (A)
 CPT33               186- 190 (A)
 CPT34               191- 195 (A)
 CPT35               196- 200 (A)
 CPT36               201- 205 (A)
 CPT37               206- 210 (A)
 CPT38               211- 215 (A)
 CPT39               216- 220 (A)
 CPT40               221- 225 (A)
 CPT41               226- 230 (A)
 CPT42               231- 235 (A)
 CPT43               236- 240 (A)
 CPT44               241- 245 (A)
 CPT45               246- 250 (A)
 CPT46               251- 255 (A)
 CPT47               256- 260 (A)
 CPT48               261- 265 (A)
 CPT49               266- 270 (A)
 CPT50               271- 275 (A)
 CPT51               276- 280 (A)
 CPT52               281- 285 (A)
 CPT53               286- 290 (A)
 CPT54               291- 295 (A)
 CPT55               296- 300 (A)
 DQTR                301- 302
 DSHOSPID            303- 315 (A)
 DX1                 316- 320 (A)
 DX2                 321- 325 (A)
 DX3                 326- 330 (A)
 DX4                 331- 335 (A)
 DX5                 336- 340 (A)
 DX6                 341- 345 (A)
 DX7                 346- 350 (A)
 DX8                 351- 355 (A)
 DX9                 356- 360 (A)
 DX10                361- 365 (A)
 DX11                366- 370 (A)
 DX12                371- 375 (A)
 DX13                376- 380 (A)
 DX14                381- 385 (A)
 DX15                386- 390 (A)
 DX16                391- 395 (A)
 DX17                396- 400 (A)
 DXCCS1              401- 404
 DXCCS2              405- 408
 DXCCS3              409- 412
 DXCCS4              413- 416
 DXCCS5              417- 420
 DXCCS6              421- 424
 DXCCS7              425- 428
 DXCCS8              429- 432
 DXCCS9              433- 436
 DXCCS10             437- 440
 DXCCS11             441- 444
 DXCCS12             445- 448
 DXCCS13             449- 452
 DXCCS14             453- 456
 DXCCS15             457- 460
 DXCCS16             461- 464
 DXCCS17             465- 468
 FEMALE              469- 470
 HOSPST              471- 472 (A)
 LOS                 473- 477
 LOS_X               478- 483
 MRN_S               484- 501 (A)
 NCPT                502- 503
 NDX                 504- 505
 NEOMAT              506- 507
 PAY1                508- 509
 PAY2                510- 511
 PAY1_X              512- 513 (A)
 PAY2_X              514- 515 (A)
 PL_CBSA             516- 517
 PL_MSA19            518- 519
 PL_RUCA4            520- 521
 PL_RUCC             522- 523
 PL_UIC              524- 525
 PSTCO               526- 530
 PSTCO2              531- 535
 RACE                536- 537
 RACE_X              538     (A)
 TOTCHG              539- 548
 TOTCHG_X            549- 563
 YEAR                564- 567.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 AGEMONTH            (F3.0) /
 AWEEKEND            (F3.0) /
 DQTR                (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 DXCCS10             (F4.0) /
 DXCCS11             (F4.0) /
 DXCCS12             (F4.0) /
 DXCCS13             (F4.0) /
 DXCCS14             (F4.0) /
 DXCCS15             (F4.0) /
 DXCCS16             (F4.0) /
 DXCCS17             (F4.0) /
 FEMALE              (F3.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 NCPT                (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 PAY1                (F3.0) /
 PAY2                (F3.0) /
 PL_CBSA             (F3.0) /
 PL_MSA19            (F3.0) /
 PL_RUCA4            (F3.0) /
 PL_RUCC             (F3.0) /
 PL_UIC              (F3.0) /
 PSTCO               (F4.0) /
 PSTCO2              (F4.0) /
 RACE                (F3.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 CPT16     "CPT/HCPCS procedure code 16"
 CPT17     "CPT/HCPCS procedure code 17"
 CPT18     "CPT/HCPCS procedure code 18"
 CPT19     "CPT/HCPCS procedure code 19"
 CPT20     "CPT/HCPCS procedure code 20"
 CPT21     "CPT/HCPCS procedure code 21"
 CPT22     "CPT/HCPCS procedure code 22"
 CPT23     "CPT/HCPCS procedure code 23"
 CPT24     "CPT/HCPCS procedure code 24"
 CPT25     "CPT/HCPCS procedure code 25"
 CPT26     "CPT/HCPCS procedure code 26"
 CPT27     "CPT/HCPCS procedure code 27"
 CPT28     "CPT/HCPCS procedure code 28"
 CPT29     "CPT/HCPCS procedure code 29"
 CPT30     "CPT/HCPCS procedure code 30"
 CPT31     "CPT/HCPCS procedure code 31"
 CPT32     "CPT/HCPCS procedure code 32"
 CPT33     "CPT/HCPCS procedure code 33"
 CPT34     "CPT/HCPCS procedure code 34"
 CPT35     "CPT/HCPCS procedure code 35"
 CPT36     "CPT/HCPCS procedure code 36"
 CPT37     "CPT/HCPCS procedure code 37"
 CPT38     "CPT/HCPCS procedure code 38"
 CPT39     "CPT/HCPCS procedure code 39"
 CPT40     "CPT/HCPCS procedure code 40"
 CPT41     "CPT/HCPCS procedure code 41"
 CPT42     "CPT/HCPCS procedure code 42"
 CPT43     "CPT/HCPCS procedure code 43"
 CPT44     "CPT/HCPCS procedure code 44"
 CPT45     "CPT/HCPCS procedure code 45"
 CPT46     "CPT/HCPCS procedure code 46"
 CPT47     "CPT/HCPCS procedure code 47"
 CPT48     "CPT/HCPCS procedure code 48"
 CPT49     "CPT/HCPCS procedure code 49"
 CPT50     "CPT/HCPCS procedure code 50"
 CPT51     "CPT/HCPCS procedure code 51"
 CPT52     "CPT/HCPCS procedure code 52"
 CPT53     "CPT/HCPCS procedure code 53"
 CPT54     "CPT/HCPCS procedure code 54"
 CPT55     "CPT/HCPCS procedure code 55"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX17      "Diagnosis 17"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 DXCCS17   "CCS: diagnosis 17"
 FEMALE    "Indicator of sex"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MRN_S     "Medical record number (synthetic)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 PAY1      "Primary expected payer (uniform)"
 PAY2      "Secondary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC   "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC    "Patient location: Urban Influence Codes"
 PSTCO     "Patient state/county FIPS code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE NCPT
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_MSA19
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).



SAVE OUTFILE = 'MD_SEDD_2002_CORE.SAV' /COMPRESSED.
