/*******************************************************************
*   MA_SEDD_2006_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'MA_SEDD_2006_DX_PR_GRPS.ASC' FIXED / 
 KEY                        1-  14
 CCSMGN1                   15-  17
 CCSMGN2                   18-  20
 CCSMGN3                   21-  23
 CCSMGN4                   24-  26
 CCSMGN5                   27-  29
 CCSMGN6                   30-  32
 CCSMSP1                   33-  36
 CCSMSP2                   37-  40
 CCSMSP3                   41-  44
 CCSMSP4                   45-  48
 CCSMSP5                   49-  52
 CCSMSP6                   53-  56
 CHRON1                    57-  58
 CHRON2                    59-  60
 CHRON3                    61-  62
 CHRON4                    63-  64
 CHRON5                    65-  66
 CHRON6                    67-  68
 CHRONB1                   69-  70
 CHRONB2                   71-  72
 CHRONB3                   73-  74
 CHRONB4                   75-  76
 CHRONB5                   77-  78
 CHRONB6                   79-  80
 PCLASS1                   81-  82
 PCLASS2                   83-  84
 PCLASS3                   85-  86
 PCLASS4                   87-  88.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 CCSMGN1                 (F3.0) /
 CCSMGN2                 (F3.0) /
 CCSMGN3                 (F3.0) /
 CCSMGN4                 (F3.0) /
 CCSMGN5                 (F3.0) /
 CCSMGN6                 (F3.0) /
 CCSMSP1                 (F3.0) /
 CCSMSP2                 (F3.0) /
 CCSMSP3                 (F3.0) /
 CCSMSP4                 (F3.0) /
 CCSMSP5                 (F3.0) /
 CCSMSP6                 (F3.0) /
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 PCLASS1                 (F3.0) /
 PCLASS2                 (F3.0) /
 PCLASS3                 (F3.0) /
 PCLASS4                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 CCSMGN1   "CCS-MHSA general category: principal diagnosis"
 CCSMGN2   "CCS-MHSA general category: diagnosis 2"
 CCSMGN3   "CCS-MHSA general category: diagnosis 3"
 CCSMGN4   "CCS-MHSA general category: diagnosis 4"
 CCSMGN5   "CCS-MHSA general category: diagnosis 5"
 CCSMGN6   "CCS-MHSA general category: diagnosis 6"
 CCSMSP1   "CCS-MHSA specific category: principal diagnosis"
 CCSMSP2   "CCS-MHSA specific category: diagnosis 2"
 CCSMSP3   "CCS-MHSA specific category: diagnosis 3"
 CCSMSP4   "CCS-MHSA specific category: diagnosis 4"
 CCSMSP5   "CCS-MHSA specific category: diagnosis 5"
 CCSMSP6   "CCS-MHSA specific category: diagnosis 6"
 CHRON1    "Chronic condition indicator 1"
 CHRON2    "Chronic condition indicator 2"
 CHRON3    "Chronic condition indicator 3"
 CHRON4    "Chronic condition indicator 4"
 CHRON5    "Chronic condition indicator 5"
 CHRON6    "Chronic condition indicator 6"
 CHRONB1   "Chronic condition body system 1"
 CHRONB2   "Chronic condition body system 2"
 CHRONB3   "Chronic condition body system 3"
 CHRONB4   "Chronic condition body system 4"
 CHRONB5   "Chronic condition body system 5"
 CHRONB6   "Chronic condition body system 6"
 PCLASS1   "Principal procedure class"
 PCLASS2   "Procedure class 2"
 PCLASS3   "Procedure class 3"
 PCLASS4   "Procedure class 4" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CCSMGN1
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN2
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN3
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN4
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN5
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN6
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMSP1
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP2
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP3
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP4
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP5
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP6
 (-999,-888,-666,-555=SYSMIS).
RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'MA_SEDD_2006_DX_PR_GRPS.SAV' /COMPRESSED.
