/*******************************************************************
*   IA_SEDD_2009_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'IA_SEDD_2009_DX_PR_GRPS.ASC' FIXED / 
 CHRON1                     1-   2
 CHRON2                     3-   4
 CHRON3                     5-   6
 CHRON4                     7-   8
 CHRON5                     9-  10
 CHRON6                    11-  12
 CHRON7                    13-  14
 CHRON8                    15-  16
 CHRON9                    17-  18
 CHRON10                   19-  20
 CHRON11                   21-  22
 CHRON12                   23-  24
 CHRON13                   25-  26
 CHRON14                   27-  28
 CHRON15                   29-  30
 CHRON16                   31-  32
 CHRON17                   33-  34
 CHRON18                   35-  36
 CHRON19                   37-  38
 CHRON20                   39-  40
 CHRON21                   41-  42
 CHRON22                   43-  44
 CHRON23                   45-  46
 CHRON24                   47-  48
 CHRON25                   49-  50
 CHRON26                   51-  52
 CHRON27                   53-  54
 CHRON28                   55-  56
 CHRON29                   57-  58
 CHRON30                   59-  60
 CHRON31                   61-  62
 CHRON32                   63-  64
 CHRONB1                   65-  66
 CHRONB2                   67-  68
 CHRONB3                   69-  70
 CHRONB4                   71-  72
 CHRONB5                   73-  74
 CHRONB6                   75-  76
 CHRONB7                   77-  78
 CHRONB8                   79-  80
 CHRONB9                   81-  82
 CHRONB10                  83-  84
 CHRONB11                  85-  86
 CHRONB12                  87-  88
 CHRONB13                  89-  90
 CHRONB14                  91-  92
 CHRONB15                  93-  94
 CHRONB16                  95-  96
 CHRONB17                  97-  98
 CHRONB18                  99- 100
 CHRONB19                 101- 102
 CHRONB20                 103- 104
 CHRONB21                 105- 106
 CHRONB22                 107- 108
 CHRONB23                 109- 110
 CHRONB24                 111- 112
 CHRONB25                 113- 114
 CHRONB26                 115- 116
 CHRONB27                 117- 118
 CHRONB28                 119- 120
 CHRONB29                 121- 122
 CHRONB30                 123- 124
 CHRONB31                 125- 126
 CHRONB32                 127- 128
 DXMCCS1                  129- 139 (A)
 DXMCCS2                  140- 150 (A)
 DXMCCS3                  151- 161 (A)
 DXMCCS4                  162- 172 (A)
 DXMCCS5                  173- 183 (A)
 DXMCCS6                  184- 194 (A)
 DXMCCS7                  195- 205 (A)
 DXMCCS8                  206- 216 (A)
 DXMCCS9                  217- 227 (A)
 DXMCCS10                 228- 238 (A)
 DXMCCS11                 239- 249 (A)
 DXMCCS12                 250- 260 (A)
 DXMCCS13                 261- 271 (A)
 DXMCCS14                 272- 282 (A)
 DXMCCS15                 283- 293 (A)
 DXMCCS16                 294- 304 (A)
 DXMCCS17                 305- 315 (A)
 DXMCCS18                 316- 326 (A)
 DXMCCS19                 327- 337 (A)
 DXMCCS20                 338- 348 (A)
 DXMCCS21                 349- 359 (A)
 DXMCCS22                 360- 370 (A)
 DXMCCS23                 371- 381 (A)
 DXMCCS24                 382- 392 (A)
 DXMCCS25                 393- 403 (A)
 DXMCCS26                 404- 414 (A)
 DXMCCS27                 415- 425 (A)
 DXMCCS28                 426- 436 (A)
 DXMCCS29                 437- 447 (A)
 DXMCCS30                 448- 458 (A)
 DXMCCS31                 459- 469 (A)
 DXMCCS32                 470- 480 (A)
 E_MCCS1                  481- 491 (A)
 E_MCCS2                  492- 502 (A)
 E_MCCS3                  503- 513 (A)
 E_MCCS4                  514- 524 (A)
 E_MCCS5                  525- 535 (A)
 E_MCCS6                  536- 546 (A)
 E_MCCS7                  547- 557 (A)
 KEY                      558- 571
 U_BLOOD                  572- 573
 U_CATH                   574- 575
 U_CCU                    576- 577
 U_CHESTXRAY              578- 579
 U_CTSCAN                 580- 581
 U_DIALYSIS               582- 583
 U_ECHO                   584- 585
 U_ED                     586- 587
 U_EEG                    588- 589
 U_EKG                    590- 591
 U_EPO                    592- 593
 U_ICU                    594- 595
 U_LITHOTRIPSY            596- 597
 U_MHSA                   598- 599
 U_MRT                    600- 601
 U_NEWBN2L                602- 603
 U_NEWBN3L                604- 605
 U_NEWBN4L                606- 607
 U_NUCMED                 608- 609
 U_OBSERVATION            610- 611
 U_OCCTHERAPY             612- 613
 U_ORGANACQ               614- 615
 U_OTHIMPLANTS            616- 617
 U_PACEMAKER              618- 619
 U_PHYTHERAPY             620- 621
 U_RADTHERAPY             622- 623
 U_RESPTHERAPY            624- 625
 U_SPEECHTHERAPY          626- 627
 U_STRESS                 628- 629
 U_ULTRASOUND             630- 631.


***  Specify write formats  ***.
FORMATS
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRON10                 (F3.0) /
 CHRON11                 (F3.0) /
 CHRON12                 (F3.0) /
 CHRON13                 (F3.0) /
 CHRON14                 (F3.0) /
 CHRON15                 (F3.0) /
 CHRON16                 (F3.0) /
 CHRON17                 (F3.0) /
 CHRON18                 (F3.0) /
 CHRON19                 (F3.0) /
 CHRON20                 (F3.0) /
 CHRON21                 (F3.0) /
 CHRON22                 (F3.0) /
 CHRON23                 (F3.0) /
 CHRON24                 (F3.0) /
 CHRON25                 (F3.0) /
 CHRON26                 (F3.0) /
 CHRON27                 (F3.0) /
 CHRON28                 (F3.0) /
 CHRON29                 (F3.0) /
 CHRON30                 (F3.0) /
 CHRON31                 (F3.0) /
 CHRON32                 (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 CHRONB10                (F3.0) /
 CHRONB11                (F3.0) /
 CHRONB12                (F3.0) /
 CHRONB13                (F3.0) /
 CHRONB14                (F3.0) /
 CHRONB15                (F3.0) /
 CHRONB16                (F3.0) /
 CHRONB17                (F3.0) /
 CHRONB18                (F3.0) /
 CHRONB19                (F3.0) /
 CHRONB20                (F3.0) /
 CHRONB21                (F3.0) /
 CHRONB22                (F3.0) /
 CHRONB23                (F3.0) /
 CHRONB24                (F3.0) /
 CHRONB25                (F3.0) /
 CHRONB26                (F3.0) /
 CHRONB27                (F3.0) /
 CHRONB28                (F3.0) /
 CHRONB29                (F3.0) /
 CHRONB30                (F3.0) /
 CHRONB31                (F3.0) /
 CHRONB32                (F3.0) /
 KEY                     (F8.0) /
 U_BLOOD                 (F3.0) /
 U_CATH                  (F3.0) /
 U_CCU                   (F3.0) /
 U_CHESTXRAY             (F3.0) /
 U_CTSCAN                (F3.0) /
 U_DIALYSIS              (F3.0) /
 U_ECHO                  (F3.0) /
 U_ED                    (F3.0) /
 U_EEG                   (F3.0) /
 U_EKG                   (F3.0) /
 U_EPO                   (F3.0) /
 U_ICU                   (F3.0) /
 U_LITHOTRIPSY           (F3.0) /
 U_MHSA                  (F3.0) /
 U_MRT                   (F3.0) /
 U_NEWBN2L               (F3.0) /
 U_NEWBN3L               (F3.0) /
 U_NEWBN4L               (F3.0) /
 U_NUCMED                (F3.0) /
 U_OBSERVATION           (F3.0) /
 U_OCCTHERAPY            (F3.0) /
 U_ORGANACQ              (F3.0) /
 U_OTHIMPLANTS           (F3.0) /
 U_PACEMAKER             (F3.0) /
 U_PHYTHERAPY            (F3.0) /
 U_RADTHERAPY            (F3.0) /
 U_RESPTHERAPY           (F3.0) /
 U_SPEECHTHERAPY         (F3.0) /
 U_STRESS                (F3.0) /
 U_ULTRASOUND            (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1                  "Chronic condition indicator 1"
 CHRON2                  "Chronic condition indicator 2"
 CHRON3                  "Chronic condition indicator 3"
 CHRON4                  "Chronic condition indicator 4"
 CHRON5                  "Chronic condition indicator 5"
 CHRON6                  "Chronic condition indicator 6"
 CHRON7                  "Chronic condition indicator 7"
 CHRON8                  "Chronic condition indicator 8"
 CHRON9                  "Chronic condition indicator 9"
 CHRON10                 "Chronic condition indicator 10"
 CHRON11                 "Chronic condition indicator 11"
 CHRON12                 "Chronic condition indicator 12"
 CHRON13                 "Chronic condition indicator 13"
 CHRON14                 "Chronic condition indicator 14"
 CHRON15                 "Chronic condition indicator 15"
 CHRON16                 "Chronic condition indicator 16"
 CHRON17                 "Chronic condition indicator 17"
 CHRON18                 "Chronic condition indicator 18"
 CHRON19                 "Chronic condition indicator 19"
 CHRON20                 "Chronic condition indicator 20"
 CHRON21                 "Chronic condition indicator 21"
 CHRON22                 "Chronic condition indicator 22"
 CHRON23                 "Chronic condition indicator 23"
 CHRON24                 "Chronic condition indicator 24"
 CHRON25                 "Chronic condition indicator 25"
 CHRON26                 "Chronic condition indicator 26"
 CHRON27                 "Chronic condition indicator 27"
 CHRON28                 "Chronic condition indicator 28"
 CHRON29                 "Chronic condition indicator 29"
 CHRON30                 "Chronic condition indicator 30"
 CHRON31                 "Chronic condition indicator 31"
 CHRON32                 "Chronic condition indicator 32"
 CHRONB1                 "Chronic condition body system 1"
 CHRONB2                 "Chronic condition body system 2"
 CHRONB3                 "Chronic condition body system 3"
 CHRONB4                 "Chronic condition body system 4"
 CHRONB5                 "Chronic condition body system 5"
 CHRONB6                 "Chronic condition body system 6"
 CHRONB7                 "Chronic condition body system 7"
 CHRONB8                 "Chronic condition body system 8"
 CHRONB9                 "Chronic condition body system 9"
 CHRONB10                "Chronic condition body system 10"
 CHRONB11                "Chronic condition body system 11"
 CHRONB12                "Chronic condition body system 12"
 CHRONB13                "Chronic condition body system 13"
 CHRONB14                "Chronic condition body system 14"
 CHRONB15                "Chronic condition body system 15"
 CHRONB16                "Chronic condition body system 16"
 CHRONB17                "Chronic condition body system 17"
 CHRONB18                "Chronic condition body system 18"
 CHRONB19                "Chronic condition body system 19"
 CHRONB20                "Chronic condition body system 20"
 CHRONB21                "Chronic condition body system 21"
 CHRONB22                "Chronic condition body system 22"
 CHRONB23                "Chronic condition body system 23"
 CHRONB24                "Chronic condition body system 24"
 CHRONB25                "Chronic condition body system 25"
 CHRONB26                "Chronic condition body system 26"
 CHRONB27                "Chronic condition body system 27"
 CHRONB28                "Chronic condition body system 28"
 CHRONB29                "Chronic condition body system 29"
 CHRONB30                "Chronic condition body system 30"
 CHRONB31                "Chronic condition body system 31"
 CHRONB32                "Chronic condition body system 32"
 DXMCCS1                 "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                 "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                 "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                 "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                 "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                 "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                 "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                 "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                 "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16                "Multi-Level CCS:  Diagnosis 16"
 DXMCCS17                "Multi-Level CCS:  Diagnosis 17"
 DXMCCS18                "Multi-Level CCS:  Diagnosis 18"
 DXMCCS19                "Multi-Level CCS:  Diagnosis 19"
 DXMCCS20                "Multi-Level CCS:  Diagnosis 20"
 DXMCCS21                "Multi-Level CCS:  Diagnosis 21"
 DXMCCS22                "Multi-Level CCS:  Diagnosis 22"
 DXMCCS23                "Multi-Level CCS:  Diagnosis 23"
 DXMCCS24                "Multi-Level CCS:  Diagnosis 24"
 DXMCCS25                "Multi-Level CCS:  Diagnosis 25"
 DXMCCS26                "Multi-Level CCS:  Diagnosis 26"
 DXMCCS27                "Multi-Level CCS:  Diagnosis 27"
 DXMCCS28                "Multi-Level CCS:  Diagnosis 28"
 DXMCCS29                "Multi-Level CCS:  Diagnosis 29"
 DXMCCS30                "Multi-Level CCS:  Diagnosis 30"
 DXMCCS31                "Multi-Level CCS:  Diagnosis 31"
 DXMCCS32                "Multi-Level CCS:  Diagnosis 32"
 E_MCCS1                 "Multi-Level CCS:  E Code 1"
 E_MCCS2                 "Multi-Level CCS:  E Code 2"
 E_MCCS3                 "Multi-Level CCS:  E Code 3"
 E_MCCS4                 "Multi-Level CCS:  E Code 4"
 E_MCCS5                 "Multi-Level CCS:  E Code 5"
 E_MCCS6                 "Multi-Level CCS:  E Code 6"
 E_MCCS7                 "Multi-Level CCS:  E Code 7"
 KEY                     "HCUP record identifier"
 U_BLOOD                 "Utilization Flag: Blood"
 U_CATH                  "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU                   "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY             "Utilization Flag: Chest X-Ray"
 U_CTSCAN                "Utilization Flag: Computed Tomography Scan"
 U_DIALYSIS              "Utilization Flag: Renal Dialysis"
 U_ECHO                  "Utilization Flag: Echocardiology"
 U_ED                    "Utilization Flag: Emergency Room"
 U_EEG                   "Utilization Flag: Electroencephalogram"
 U_EKG                   "Utilization Flag: Electrocardiogram"
 U_EPO                   "Utilization Flag: EPO"
 U_ICU                   "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY           "Utilization Flag: Lithotripsy"
 U_MHSA                  "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT                   "Utilization Flag: Medical Resonance Technology"
 U_NEWBN2L               "Utilization Flag: Nursery Level II"
 U_NEWBN3L               "Utilization Flag: Nursery Level III"
 U_NEWBN4L               "Utilization Flag: Nursery Level IV"
 U_NUCMED                "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION           "Utilization Flag: Observation Room"
 U_OCCTHERAPY            "Utilization Flag: Occupational Therapy"
 U_ORGANACQ              "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS           "Utilization Flag: Other Implants"
 U_PACEMAKER             "Utilization Flag: Pacemaker"
 U_PHYTHERAPY            "Utilization Flag: Physical Therapy"
 U_RADTHERAPY
"Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTHERAPY           "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY         "Utilization Flag: Speech - Language Pathology"
 U_STRESS                "Utilization Flag: Cardiac Stress Test"
 U_ULTRASOUND            "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON32
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB32
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'IA_SEDD_2009_DX_PR_GRPS.SAV' /COMPRESSED.
