/*******************************************************************
*   IA_SEDD_2006_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'IA_SEDD_2006_CHGS.ASC' FIXED / 
 KEY                        1-  14
 CHARGE                    15-  26
 CPTHCPCS                  27-  31 (A)
 REVCODE                   32-  35 (A)
 SERVDAY                   36-  40
 UNITS                     41-  48.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 CHARGE                  (F6.2) /
 SERVDAY                 (F3.0) /
 UNITS                   (F4.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 CHARGE    "Line item charges (as received from source)"
 CPTHCPCS  "Line item CPT-4/HCPCS procedure code (as received from source)"
 REVCODE   "Line item revenue code (as received from source)"
 SERVDAY   "Line item days from admission date"
 UNITS     "Line item units (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHARGE
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE SERVDAY
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE UNITS
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).



SAVE OUTFILE = 'IA_SEDD_2006_CHGS.SAV' /COMPRESSED.
