/*******************************************************************
* Creation Date: 08/06/2024   
*   HI_SEDD_2019_CORE.sps:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************/

DATA LIST FILE = 'HI_SEDD_2019_CORE.asc' FIXED SKIP=2 / 
 AGE                             1-   3
 AMONTH                          4-   5
 ATYPE                           6-   7
 AWEEKEND                        8-   9
 CPT1                           10-  14 (A)
 CPT2                           15-  19 (A)
 CPT3                           20-  24 (A)
 CPT4                           25-  29 (A)
 CPT5                           30-  34 (A)
 CPT6                           35-  39 (A)
 CPT7                           40-  44 (A)
 CPT8                           45-  49 (A)
 CPT9                           50-  54 (A)
 CPT10                          55-  59 (A)
 CPT11                          60-  64 (A)
 CPT12                          65-  69 (A)
 CPT13                          70-  74 (A)
 CPT14                          75-  79 (A)
 CPT15                          80-  84 (A)
 CPT16                          85-  89 (A)
 CPT17                          90-  94 (A)
 CPT18                          95-  99 (A)
 CPT19                         100- 104 (A)
 CPT20                         105- 109 (A)
 CPT21                         110- 114 (A)
 CPT22                         115- 119 (A)
 CPT23                         120- 124 (A)
 CPT24                         125- 129 (A)
 CPT25                         130- 134 (A)
 CPT26                         135- 139 (A)
 CPT27                         140- 144 (A)
 CPT28                         145- 149 (A)
 CPT29                         150- 154 (A)
 CPT30                         155- 159 (A)
 CPT31                         160- 164 (A)
 CPT32                         165- 169 (A)
 CPT33                         170- 174 (A)
 CPT34                         175- 179 (A)
 CPT35                         180- 184 (A)
 CPT36                         185- 189 (A)
 CPT37                         190- 194 (A)
 CPT38                         195- 199 (A)
 CPT39                         200- 204 (A)
 CPT40                         205- 209 (A)
 CPT41                         210- 214 (A)
 CPT42                         215- 219 (A)
 CPT43                         220- 224 (A)
 CPT44                         225- 229 (A)
 CPT45                         230- 234 (A)
 CPT46                         235- 239 (A)
 CPT47                         240- 244 (A)
 CPT48                         245- 249 (A)
 CPT49                         250- 254 (A)
 CPT50                         255- 259 (A)
 CPT51                         260- 264 (A)
 CPT52                         265- 269 (A)
 CPT53                         270- 274 (A)
 CPT54                         275- 279 (A)
 CPT55                         280- 284 (A)
 CPT56                         285- 289 (A)
 CPT57                         290- 294 (A)
 CPT58                         295- 299 (A)
 CPT59                         300- 304 (A)
 CPT60                         305- 309 (A)
 CPT61                         310- 314 (A)
 CPT62                         315- 319 (A)
 CPT63                         320- 324 (A)
 CPT64                         325- 329 (A)
 CPT65                         330- 334 (A)
 CPT66                         335- 339 (A)
 CPT67                         340- 344 (A)
 CPT68                         345- 349 (A)
 CPT69                         350- 354 (A)
 CPT70                         355- 359 (A)
 CPT71                         360- 364 (A)
 CPT72                         365- 369 (A)
 CPT73                         370- 374 (A)
 CPT74                         375- 379 (A)
 CPT75                         380- 384 (A)
 CPT76                         385- 389 (A)
 CPT77                         390- 394 (A)
 CPT78                         395- 399 (A)
 CPT79                         400- 404 (A)
 CPT80                         405- 409 (A)
 CPT81                         410- 414 (A)
 CPT82                         415- 419 (A)
 CPT83                         420- 424 (A)
 CPT84                         425- 429 (A)
 CPT85                         430- 434 (A)
 CPT86                         435- 439 (A)
 CPT87                         440- 444 (A)
 CPT88                         445- 449 (A)
 CPT89                         450- 454 (A)
 CPT90                         455- 459 (A)
 CPT91                         460- 464 (A)
 CPT92                         465- 469 (A)
 CPT93                         470- 474 (A)
 CPT94                         475- 479 (A)
 CPT95                         480- 484 (A)
 CPT96                         485- 489 (A)
 CPT97                         490- 494 (A)
 CPT98                         495- 499 (A)
 CPT99                         500- 504 (A)
 CPT100                        505- 509 (A)
 CPT101                        510- 514 (A)
 CPT102                        515- 519 (A)
 CPT103                        520- 524 (A)
 CPT104                        525- 529 (A)
 CPT105                        530- 534 (A)
 CPT106                        535- 539 (A)
 CPT107                        540- 544 (A)
 CPT108                        545- 549 (A)
 CPT109                        550- 554 (A)
 CPT110                        555- 559 (A)
 CPTCCS1                       560- 562
 CPTCCS2                       563- 565
 CPTCCS3                       566- 568
 CPTCCS4                       569- 571
 CPTCCS5                       572- 574
 CPTCCS6                       575- 577
 CPTCCS7                       578- 580
 CPTCCS8                       581- 583
 CPTCCS9                       584- 586
 CPTCCS10                      587- 589
 CPTCCS11                      590- 592
 CPTCCS12                      593- 595
 CPTCCS13                      596- 598
 CPTCCS14                      599- 601
 CPTCCS15                      602- 604
 CPTCCS16                      605- 607
 CPTCCS17                      608- 610
 CPTCCS18                      611- 613
 CPTCCS19                      614- 616
 CPTCCS20                      617- 619
 CPTCCS21                      620- 622
 CPTCCS22                      623- 625
 CPTCCS23                      626- 628
 CPTCCS24                      629- 631
 CPTCCS25                      632- 634
 CPTCCS26                      635- 637
 CPTCCS27                      638- 640
 CPTCCS28                      641- 643
 CPTCCS29                      644- 646
 CPTCCS30                      647- 649
 CPTCCS31                      650- 652
 CPTCCS32                      653- 655
 CPTCCS33                      656- 658
 CPTCCS34                      659- 661
 CPTCCS35                      662- 664
 CPTCCS36                      665- 667
 CPTCCS37                      668- 670
 CPTCCS38                      671- 673
 CPTCCS39                      674- 676
 CPTCCS40                      677- 679
 CPTCCS41                      680- 682
 CPTCCS42                      683- 685
 CPTCCS43                      686- 688
 CPTCCS44                      689- 691
 CPTCCS45                      692- 694
 CPTCCS46                      695- 697
 CPTCCS47                      698- 700
 CPTCCS48                      701- 703
 CPTCCS49                      704- 706
 CPTCCS50                      707- 709
 CPTCCS51                      710- 712
 CPTCCS52                      713- 715
 CPTCCS53                      716- 718
 CPTCCS54                      719- 721
 CPTCCS55                      722- 724
 CPTCCS56                      725- 727
 CPTCCS57                      728- 730
 CPTCCS58                      731- 733
 CPTCCS59                      734- 736
 CPTCCS60                      737- 739
 CPTCCS61                      740- 742
 CPTCCS62                      743- 745
 CPTCCS63                      746- 748
 CPTCCS64                      749- 751
 CPTCCS65                      752- 754
 CPTCCS66                      755- 757
 CPTCCS67                      758- 760
 CPTCCS68                      761- 763
 CPTCCS69                      764- 766
 CPTCCS70                      767- 769
 CPTCCS71                      770- 772
 CPTCCS72                      773- 775
 CPTCCS73                      776- 778
 CPTCCS74                      779- 781
 CPTCCS75                      782- 784
 CPTCCS76                      785- 787
 CPTCCS77                      788- 790
 CPTCCS78                      791- 793
 CPTCCS79                      794- 796
 CPTCCS80                      797- 799
 CPTCCS81                      800- 802
 CPTCCS82                      803- 805
 CPTCCS83                      806- 808
 CPTCCS84                      809- 811
 CPTCCS85                      812- 814
 CPTCCS86                      815- 817
 CPTCCS87                      818- 820
 CPTCCS88                      821- 823
 CPTCCS89                      824- 826
 CPTCCS90                      827- 829
 CPTCCS91                      830- 832
 CPTCCS92                      833- 835
 CPTCCS93                      836- 838
 CPTCCS94                      839- 841
 CPTCCS95                      842- 844
 CPTCCS96                      845- 847
 CPTCCS97                      848- 850
 CPTCCS98                      851- 853
 CPTCCS99                      854- 856
 CPTCCS100                     857- 859
 CPTCCS101                     860- 862
 CPTCCS102                     863- 865
 CPTCCS103                     866- 868
 CPTCCS104                     869- 871
 CPTCCS105                     872- 874
 CPTCCS106                     875- 877
 CPTCCS107                     878- 880
 CPTCCS108                     881- 883
 CPTCCS109                     884- 886
 CPTCCS110                     887- 889
 CPTM1_1                       890- 891 (A)
 CPTM1_2                       892- 893 (A)
 CPTM1_3                       894- 895 (A)
 CPTM1_4                       896- 897 (A)
 CPTM1_5                       898- 899 (A)
 CPTM1_6                       900- 901 (A)
 CPTM1_7                       902- 903 (A)
 CPTM1_8                       904- 905 (A)
 CPTM1_9                       906- 907 (A)
 CPTM1_10                      908- 909 (A)
 CPTM1_11                      910- 911 (A)
 CPTM1_12                      912- 913 (A)
 CPTM1_13                      914- 915 (A)
 CPTM1_14                      916- 917 (A)
 CPTM1_15                      918- 919 (A)
 CPTM1_16                      920- 921 (A)
 CPTM1_17                      922- 923 (A)
 CPTM1_18                      924- 925 (A)
 CPTM1_19                      926- 927 (A)
 CPTM1_20                      928- 929 (A)
 CPTM1_21                      930- 931 (A)
 CPTM1_22                      932- 933 (A)
 CPTM1_23                      934- 935 (A)
 CPTM1_24                      936- 937 (A)
 CPTM1_25                      938- 939 (A)
 CPTM1_26                      940- 941 (A)
 CPTM1_27                      942- 943 (A)
 CPTM1_28                      944- 945 (A)
 CPTM1_29                      946- 947 (A)
 CPTM1_30                      948- 949 (A)
 CPTM1_31                      950- 951 (A)
 CPTM1_32                      952- 953 (A)
 CPTM1_33                      954- 955 (A)
 CPTM1_34                      956- 957 (A)
 CPTM1_35                      958- 959 (A)
 CPTM1_36                      960- 961 (A)
 CPTM1_37                      962- 963 (A)
 CPTM1_38                      964- 965 (A)
 CPTM1_39                      966- 967 (A)
 CPTM1_40                      968- 969 (A)
 CPTM1_41                      970- 971 (A)
 CPTM1_42                      972- 973 (A)
 CPTM1_43                      974- 975 (A)
 CPTM1_44                      976- 977 (A)
 CPTM1_45                      978- 979 (A)
 CPTM1_46                      980- 981 (A)
 CPTM1_47                      982- 983 (A)
 CPTM1_48                      984- 985 (A)
 CPTM1_49                      986- 987 (A)
 CPTM1_50                      988- 989 (A)
 CPTM1_51                      990- 991 (A)
 CPTM1_52                      992- 993 (A)
 CPTM1_53                      994- 995 (A)
 CPTM1_54                      996- 997 (A)
 CPTM1_55                      998- 999 (A)
 CPTM1_56                     1000-1001 (A)
 CPTM1_57                     1002-1003 (A)
 CPTM1_58                     1004-1005 (A)
 CPTM1_59                     1006-1007 (A)
 CPTM1_60                     1008-1009 (A)
 CPTM1_61                     1010-1011 (A)
 CPTM1_62                     1012-1013 (A)
 CPTM1_63                     1014-1015 (A)
 CPTM1_64                     1016-1017 (A)
 CPTM1_65                     1018-1019 (A)
 CPTM1_66                     1020-1021 (A)
 CPTM1_67                     1022-1023 (A)
 CPTM1_68                     1024-1025 (A)
 CPTM1_69                     1026-1027 (A)
 CPTM1_70                     1028-1029 (A)
 CPTM1_71                     1030-1031 (A)
 CPTM1_72                     1032-1033 (A)
 CPTM1_73                     1034-1035 (A)
 CPTM1_74                     1036-1037 (A)
 CPTM1_75                     1038-1039 (A)
 CPTM1_76                     1040-1041 (A)
 CPTM1_77                     1042-1043 (A)
 CPTM1_78                     1044-1045 (A)
 CPTM1_79                     1046-1047 (A)
 CPTM1_80                     1048-1049 (A)
 CPTM1_81                     1050-1051 (A)
 CPTM1_82                     1052-1053 (A)
 CPTM1_83                     1054-1055 (A)
 CPTM1_84                     1056-1057 (A)
 CPTM1_85                     1058-1059 (A)
 CPTM1_86                     1060-1061 (A)
 CPTM1_87                     1062-1063 (A)
 CPTM1_88                     1064-1065 (A)
 CPTM1_89                     1066-1067 (A)
 CPTM1_90                     1068-1069 (A)
 CPTM1_91                     1070-1071 (A)
 CPTM1_92                     1072-1073 (A)
 CPTM1_93                     1074-1075 (A)
 CPTM1_94                     1076-1077 (A)
 CPTM1_95                     1078-1079 (A)
 CPTM1_96                     1080-1081 (A)
 CPTM1_97                     1082-1083 (A)
 CPTM1_98                     1084-1085 (A)
 CPTM1_99                     1086-1087 (A)
 CPTM1_100                    1088-1089 (A)
 CPTM1_101                    1090-1091 (A)
 CPTM1_102                    1092-1093 (A)
 CPTM1_103                    1094-1095 (A)
 CPTM1_104                    1096-1097 (A)
 CPTM1_105                    1098-1099 (A)
 CPTM1_106                    1100-1101 (A)
 CPTM1_107                    1102-1103 (A)
 CPTM1_108                    1104-1105 (A)
 CPTM1_109                    1106-1107 (A)
 CPTM1_110                    1108-1109 (A)
 CPTM2_1                      1110-1111 (A)
 CPTM2_2                      1112-1113 (A)
 CPTM2_3                      1114-1115 (A)
 CPTM2_4                      1116-1117 (A)
 CPTM2_5                      1118-1119 (A)
 CPTM2_6                      1120-1121 (A)
 CPTM2_7                      1122-1123 (A)
 CPTM2_8                      1124-1125 (A)
 CPTM2_9                      1126-1127 (A)
 CPTM2_10                     1128-1129 (A)
 CPTM2_11                     1130-1131 (A)
 CPTM2_12                     1132-1133 (A)
 CPTM2_13                     1134-1135 (A)
 CPTM2_14                     1136-1137 (A)
 CPTM2_15                     1138-1139 (A)
 CPTM2_16                     1140-1141 (A)
 CPTM2_17                     1142-1143 (A)
 CPTM2_18                     1144-1145 (A)
 CPTM2_19                     1146-1147 (A)
 CPTM2_20                     1148-1149 (A)
 CPTM2_21                     1150-1151 (A)
 CPTM2_22                     1152-1153 (A)
 CPTM2_23                     1154-1155 (A)
 CPTM2_24                     1156-1157 (A)
 CPTM2_25                     1158-1159 (A)
 CPTM2_26                     1160-1161 (A)
 CPTM2_27                     1162-1163 (A)
 CPTM2_28                     1164-1165 (A)
 CPTM2_29                     1166-1167 (A)
 CPTM2_30                     1168-1169 (A)
 CPTM2_31                     1170-1171 (A)
 CPTM2_32                     1172-1173 (A)
 CPTM2_33                     1174-1175 (A)
 CPTM2_34                     1176-1177 (A)
 CPTM2_35                     1178-1179 (A)
 CPTM2_36                     1180-1181 (A)
 CPTM2_37                     1182-1183 (A)
 CPTM2_38                     1184-1185 (A)
 CPTM2_39                     1186-1187 (A)
 CPTM2_40                     1188-1189 (A)
 CPTM2_41                     1190-1191 (A)
 CPTM2_42                     1192-1193 (A)
 CPTM2_43                     1194-1195 (A)
 CPTM2_44                     1196-1197 (A)
 CPTM2_45                     1198-1199 (A)
 CPTM2_46                     1200-1201 (A)
 CPTM2_47                     1202-1203 (A)
 CPTM2_48                     1204-1205 (A)
 CPTM2_49                     1206-1207 (A)
 CPTM2_50                     1208-1209 (A)
 CPTM2_51                     1210-1211 (A)
 CPTM2_52                     1212-1213 (A)
 CPTM2_53                     1214-1215 (A)
 CPTM2_54                     1216-1217 (A)
 CPTM2_55                     1218-1219 (A)
 CPTM2_56                     1220-1221 (A)
 CPTM2_57                     1222-1223 (A)
 CPTM2_58                     1224-1225 (A)
 CPTM2_59                     1226-1227 (A)
 CPTM2_60                     1228-1229 (A)
 CPTM2_61                     1230-1231 (A)
 CPTM2_62                     1232-1233 (A)
 CPTM2_63                     1234-1235 (A)
 CPTM2_64                     1236-1237 (A)
 CPTM2_65                     1238-1239 (A)
 CPTM2_66                     1240-1241 (A)
 CPTM2_67                     1242-1243 (A)
 CPTM2_68                     1244-1245 (A)
 CPTM2_69                     1246-1247 (A)
 CPTM2_70                     1248-1249 (A)
 CPTM2_71                     1250-1251 (A)
 CPTM2_72                     1252-1253 (A)
 CPTM2_73                     1254-1255 (A)
 CPTM2_74                     1256-1257 (A)
 CPTM2_75                     1258-1259 (A)
 CPTM2_76                     1260-1261 (A)
 CPTM2_77                     1262-1263 (A)
 CPTM2_78                     1264-1265 (A)
 CPTM2_79                     1266-1267 (A)
 CPTM2_80                     1268-1269 (A)
 CPTM2_81                     1270-1271 (A)
 CPTM2_82                     1272-1273 (A)
 CPTM2_83                     1274-1275 (A)
 CPTM2_84                     1276-1277 (A)
 CPTM2_85                     1278-1279 (A)
 CPTM2_86                     1280-1281 (A)
 CPTM2_87                     1282-1283 (A)
 CPTM2_88                     1284-1285 (A)
 CPTM2_89                     1286-1287 (A)
 CPTM2_90                     1288-1289 (A)
 CPTM2_91                     1290-1291 (A)
 CPTM2_92                     1292-1293 (A)
 CPTM2_93                     1294-1295 (A)
 CPTM2_94                     1296-1297 (A)
 CPTM2_95                     1298-1299 (A)
 CPTM2_96                     1300-1301 (A)
 CPTM2_97                     1302-1303 (A)
 CPTM2_98                     1304-1305 (A)
 CPTM2_99                     1306-1307 (A)
 CPTM2_100                    1308-1309 (A)
 CPTM2_101                    1310-1311 (A)
 CPTM2_102                    1312-1313 (A)
 CPTM2_103                    1314-1315 (A)
 CPTM2_104                    1316-1317 (A)
 CPTM2_105                    1318-1319 (A)
 CPTM2_106                    1320-1321 (A)
 CPTM2_107                    1322-1323 (A)
 CPTM2_108                    1324-1325 (A)
 CPTM2_109                    1326-1327 (A)
 CPTM2_110                    1328-1329 (A)
 DIED                         1330-1331
 DISP_X                       1332-1333 (A)
 DISPUB04                     1334-1335
 DISPUNIFORM                  1336-1337
 DMONTH                       1338-1339
 DQTR                         1340-1341
 DSHOSPID                     1342-1358 (A)
 FEMALE                       1359-1360
 HCUP_ED                      1361-1362
 HCUP_OS                      1363-1364
 HISPANIC                     1365-1366
 HOSPST                       1367-1368 (A)
 I10_DX1                      1369-1375 (A)
 I10_DX2                      1376-1382 (A)
 I10_DX3                      1383-1389 (A)
 I10_DX4                      1390-1396 (A)
 I10_DX5                      1397-1403 (A)
 I10_DX6                      1404-1410 (A)
 I10_DX7                      1411-1417 (A)
 I10_DX8                      1418-1424 (A)
 I10_DX9                      1425-1431 (A)
 I10_DX10                     1432-1438 (A)
 I10_DX11                     1439-1445 (A)
 I10_DX12                     1446-1452 (A)
 I10_DX13                     1453-1459 (A)
 I10_DX14                     1460-1466 (A)
 I10_DX15                     1467-1473 (A)
 I10_DX16                     1474-1480 (A)
 I10_DX17                     1481-1487 (A)
 I10_DX18                     1488-1494 (A)
 I10_DX19                     1495-1501 (A)
 I10_DX20                     1502-1508 (A)
 I10_DX21                     1509-1515 (A)
 I10_DX22                     1516-1522 (A)
 I10_DX23                     1523-1529 (A)
 I10_DX24                     1530-1536 (A)
 I10_DX25                     1537-1543 (A)
 I10_DX26                     1544-1550 (A)
 I10_DX27                     1551-1557 (A)
 I10_DX28                     1558-1564 (A)
 I10_NDX                      1565-1567
 I10_PROCTYPE                 1568-1570
 KEY                          1571-1585
 LOS                          1586-1590
 LOS_X                        1591-1596
 MEDINCSTQ                    1597-1598
 NCPT                         1599-1602
 OS_TIME                      1603-1613
 PAY1                         1614-1615
 PAY1_X                       1616-1617 (A)
 PL_CBSA                      1618-1620
 PL_NCHS                      1621-1622
 PL_RUCC                      1623-1624
 PL_UIC                       1625-1626
 PL_UR_CAT4                   1627-1628
 PointOfOrigin_X              1629     (A)
 PointOfOriginUB04            1630     (A)
 PrimLang                     1631-1633 (A)
 PSTATE                       1634-1635 (A)
 PSTATE_GEO                   1636-1637 (A)
 PSTCO_GEO                    1638-1642
 RACE                         1643-1644
 RACE_X                       1645-1646 (A)
 STATE_AS                     1647-1648
 STATE_ED                     1649-1650
 STATE_OS                     1651-1652
 TOTCHG                       1653-1662
 TOTCHG_X                     1663-1677
 YEAR                         1678-1681
 ZIP                          1682-1686 (A)
 ZIP3                         1687-1689 (A)
 ZIPINC_QRTL                  1690-1692
 VisitLink                    1693-1701
 DaysToEvent                  1702-1707
 AYEAR                        1708-1711.


/***  Specify write formats  ***/
FORMATS
 AGE                          (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTCCS51                     (F4.0) /
 CPTCCS52                     (F4.0) /
 CPTCCS53                     (F4.0) /
 CPTCCS54                     (F4.0) /
 CPTCCS55                     (F4.0) /
 CPTCCS56                     (F4.0) /
 CPTCCS57                     (F4.0) /
 CPTCCS58                     (F4.0) /
 CPTCCS59                     (F4.0) /
 CPTCCS60                     (F4.0) /
 CPTCCS61                     (F4.0) /
 CPTCCS62                     (F4.0) /
 CPTCCS63                     (F4.0) /
 CPTCCS64                     (F4.0) /
 CPTCCS65                     (F4.0) /
 CPTCCS66                     (F4.0) /
 CPTCCS67                     (F4.0) /
 CPTCCS68                     (F4.0) /
 CPTCCS69                     (F4.0) /
 CPTCCS70                     (F4.0) /
 CPTCCS71                     (F4.0) /
 CPTCCS72                     (F4.0) /
 CPTCCS73                     (F4.0) /
 CPTCCS74                     (F4.0) /
 CPTCCS75                     (F4.0) /
 CPTCCS76                     (F4.0) /
 CPTCCS77                     (F4.0) /
 CPTCCS78                     (F4.0) /
 CPTCCS79                     (F4.0) /
 CPTCCS80                     (F4.0) /
 CPTCCS81                     (F4.0) /
 CPTCCS82                     (F4.0) /
 CPTCCS83                     (F4.0) /
 CPTCCS84                     (F4.0) /
 CPTCCS85                     (F4.0) /
 CPTCCS86                     (F4.0) /
 CPTCCS87                     (F4.0) /
 CPTCCS88                     (F4.0) /
 CPTCCS89                     (F4.0) /
 CPTCCS90                     (F4.0) /
 CPTCCS91                     (F4.0) /
 CPTCCS92                     (F4.0) /
 CPTCCS93                     (F4.0) /
 CPTCCS94                     (F4.0) /
 CPTCCS95                     (F4.0) /
 CPTCCS96                     (F4.0) /
 CPTCCS97                     (F4.0) /
 CPTCCS98                     (F4.0) /
 CPTCCS99                     (F4.0) /
 CPTCCS100                    (F4.0) /
 CPTCCS101                    (F4.0) /
 CPTCCS102                    (F4.0) /
 CPTCCS103                    (F4.0) /
 CPTCCS104                    (F4.0) /
 CPTCCS105                    (F4.0) /
 CPTCCS106                    (F4.0) /
 CPTCCS107                    (F4.0) /
 CPTCCS108                    (F4.0) /
 CPTCCS109                    (F4.0) /
 CPTCCS110                    (F4.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 I10_NDX                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MEDINCSTQ                    (F3.0) /
 NCPT                         (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PSTCO_GEO                    (F4.0) /
 RACE                         (F3.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 VisitLink                    (F8.0) /
 DaysToEvent                  (F8.0) /
 AYEAR                        (F3.0) .


/***  Assign labels to the variables ***/
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPT51                        "CPT/HCPCS procedure code 51"
 CPT52                        "CPT/HCPCS procedure code 52"
 CPT53                        "CPT/HCPCS procedure code 53"
 CPT54                        "CPT/HCPCS procedure code 54"
 CPT55                        "CPT/HCPCS procedure code 55"
 CPT56                        "CPT/HCPCS procedure code 56"
 CPT57                        "CPT/HCPCS procedure code 57"
 CPT58                        "CPT/HCPCS procedure code 58"
 CPT59                        "CPT/HCPCS procedure code 59"
 CPT60                        "CPT/HCPCS procedure code 60"
 CPT61                        "CPT/HCPCS procedure code 61"
 CPT62                        "CPT/HCPCS procedure code 62"
 CPT63                        "CPT/HCPCS procedure code 63"
 CPT64                        "CPT/HCPCS procedure code 64"
 CPT65                        "CPT/HCPCS procedure code 65"
 CPT66                        "CPT/HCPCS procedure code 66"
 CPT67                        "CPT/HCPCS procedure code 67"
 CPT68                        "CPT/HCPCS procedure code 68"
 CPT69                        "CPT/HCPCS procedure code 69"
 CPT70                        "CPT/HCPCS procedure code 70"
 CPT71                        "CPT/HCPCS procedure code 71"
 CPT72                        "CPT/HCPCS procedure code 72"
 CPT73                        "CPT/HCPCS procedure code 73"
 CPT74                        "CPT/HCPCS procedure code 74"
 CPT75                        "CPT/HCPCS procedure code 75"
 CPT76                        "CPT/HCPCS procedure code 76"
 CPT77                        "CPT/HCPCS procedure code 77"
 CPT78                        "CPT/HCPCS procedure code 78"
 CPT79                        "CPT/HCPCS procedure code 79"
 CPT80                        "CPT/HCPCS procedure code 80"
 CPT81                        "CPT/HCPCS procedure code 81"
 CPT82                        "CPT/HCPCS procedure code 82"
 CPT83                        "CPT/HCPCS procedure code 83"
 CPT84                        "CPT/HCPCS procedure code 84"
 CPT85                        "CPT/HCPCS procedure code 85"
 CPT86                        "CPT/HCPCS procedure code 86"
 CPT87                        "CPT/HCPCS procedure code 87"
 CPT88                        "CPT/HCPCS procedure code 88"
 CPT89                        "CPT/HCPCS procedure code 89"
 CPT90                        "CPT/HCPCS procedure code 90"
 CPT91                        "CPT/HCPCS procedure code 91"
 CPT92                        "CPT/HCPCS procedure code 92"
 CPT93                        "CPT/HCPCS procedure code 93"
 CPT94                        "CPT/HCPCS procedure code 94"
 CPT95                        "CPT/HCPCS procedure code 95"
 CPT96                        "CPT/HCPCS procedure code 96"
 CPT97                        "CPT/HCPCS procedure code 97"
 CPT98                        "CPT/HCPCS procedure code 98"
 CPT99                        "CPT/HCPCS procedure code 99"
 CPT100                       "CPT/HCPCS procedure code 100"
 CPT101                       "CPT/HCPCS procedure code 101"
 CPT102                       "CPT/HCPCS procedure code 102"
 CPT103                       "CPT/HCPCS procedure code 103"
 CPT104                       "CPT/HCPCS procedure code 104"
 CPT105                       "CPT/HCPCS procedure code 105"
 CPT106                       "CPT/HCPCS procedure code 106"
 CPT107                       "CPT/HCPCS procedure code 107"
 CPT108                       "CPT/HCPCS procedure code 108"
 CPT109                       "CPT/HCPCS procedure code 109"
 CPT110                       "CPT/HCPCS procedure code 110"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTCCS51                     "CCS: CPT 51"
 CPTCCS52                     "CCS: CPT 52"
 CPTCCS53                     "CCS: CPT 53"
 CPTCCS54                     "CCS: CPT 54"
 CPTCCS55                     "CCS: CPT 55"
 CPTCCS56                     "CCS: CPT 56"
 CPTCCS57                     "CCS: CPT 57"
 CPTCCS58                     "CCS: CPT 58"
 CPTCCS59                     "CCS: CPT 59"
 CPTCCS60                     "CCS: CPT 60"
 CPTCCS61                     "CCS: CPT 61"
 CPTCCS62                     "CCS: CPT 62"
 CPTCCS63                     "CCS: CPT 63"
 CPTCCS64                     "CCS: CPT 64"
 CPTCCS65                     "CCS: CPT 65"
 CPTCCS66                     "CCS: CPT 66"
 CPTCCS67                     "CCS: CPT 67"
 CPTCCS68                     "CCS: CPT 68"
 CPTCCS69                     "CCS: CPT 69"
 CPTCCS70                     "CCS: CPT 70"
 CPTCCS71                     "CCS: CPT 71"
 CPTCCS72                     "CCS: CPT 72"
 CPTCCS73                     "CCS: CPT 73"
 CPTCCS74                     "CCS: CPT 74"
 CPTCCS75                     "CCS: CPT 75"
 CPTCCS76                     "CCS: CPT 76"
 CPTCCS77                     "CCS: CPT 77"
 CPTCCS78                     "CCS: CPT 78"
 CPTCCS79                     "CCS: CPT 79"
 CPTCCS80                     "CCS: CPT 80"
 CPTCCS81                     "CCS: CPT 81"
 CPTCCS82                     "CCS: CPT 82"
 CPTCCS83                     "CCS: CPT 83"
 CPTCCS84                     "CCS: CPT 84"
 CPTCCS85                     "CCS: CPT 85"
 CPTCCS86                     "CCS: CPT 86"
 CPTCCS87                     "CCS: CPT 87"
 CPTCCS88                     "CCS: CPT 88"
 CPTCCS89                     "CCS: CPT 89"
 CPTCCS90                     "CCS: CPT 90"
 CPTCCS91                     "CCS: CPT 91"
 CPTCCS92                     "CCS: CPT 92"
 CPTCCS93                     "CCS: CPT 93"
 CPTCCS94                     "CCS: CPT 94"
 CPTCCS95                     "CCS: CPT 95"
 CPTCCS96                     "CCS: CPT 96"
 CPTCCS97                     "CCS: CPT 97"
 CPTCCS98                     "CCS: CPT 98"
 CPTCCS99                     "CCS: CPT 99"
 CPTCCS100                    "CCS: CPT 100"
 CPTCCS101                    "CCS: CPT 101"
 CPTCCS102                    "CCS: CPT 102"
 CPTCCS103                    "CCS: CPT 103"
 CPTCCS104                    "CCS: CPT 104"
 CPTCCS105                    "CCS: CPT 105"
 CPTCCS106                    "CCS: CPT 106"
 CPTCCS107                    "CCS: CPT 107"
 CPTCCS108                    "CCS: CPT 108"
 CPTCCS109                    "CCS: CPT 109"
 CPTCCS110                    "CCS: CPT 110"
 CPTM1_1                      "First CPT-4/HCPCS modifier 1"
 CPTM1_2                      "First CPT-4/HCPCS modifier 2"
 CPTM1_3                      "First CPT-4/HCPCS modifier 3"
 CPTM1_4                      "First CPT-4/HCPCS modifier 4"
 CPTM1_5                      "First CPT-4/HCPCS modifier 5"
 CPTM1_6                      "First CPT-4/HCPCS modifier 6"
 CPTM1_7                      "First CPT-4/HCPCS modifier 7"
 CPTM1_8                      "First CPT-4/HCPCS modifier 8"
 CPTM1_9                      "First CPT-4/HCPCS modifier 9"
 CPTM1_10                     "First CPT-4/HCPCS modifier 10"
 CPTM1_11                     "First CPT-4/HCPCS modifier 11"
 CPTM1_12                     "First CPT-4/HCPCS modifier 12"
 CPTM1_13                     "First CPT-4/HCPCS modifier 13"
 CPTM1_14                     "First CPT-4/HCPCS modifier 14"
 CPTM1_15                     "First CPT-4/HCPCS modifier 15"
 CPTM1_16                     "First CPT-4/HCPCS modifier 16"
 CPTM1_17                     "First CPT-4/HCPCS modifier 17"
 CPTM1_18                     "First CPT-4/HCPCS modifier 18"
 CPTM1_19                     "First CPT-4/HCPCS modifier 19"
 CPTM1_20                     "First CPT-4/HCPCS modifier 20"
 CPTM1_21                     "First CPT-4/HCPCS modifier 21"
 CPTM1_22                     "First CPT-4/HCPCS modifier 22"
 CPTM1_23                     "First CPT-4/HCPCS modifier 23"
 CPTM1_24                     "First CPT-4/HCPCS modifier 24"
 CPTM1_25                     "First CPT-4/HCPCS modifier 25"
 CPTM1_26                     "First CPT-4/HCPCS modifier 26"
 CPTM1_27                     "First CPT-4/HCPCS modifier 27"
 CPTM1_28                     "First CPT-4/HCPCS modifier 28"
 CPTM1_29                     "First CPT-4/HCPCS modifier 29"
 CPTM1_30                     "First CPT-4/HCPCS modifier 30"
 CPTM1_31                     "First CPT-4/HCPCS modifier 31"
 CPTM1_32                     "First CPT-4/HCPCS modifier 32"
 CPTM1_33                     "First CPT-4/HCPCS modifier 33"
 CPTM1_34                     "First CPT-4/HCPCS modifier 34"
 CPTM1_35                     "First CPT-4/HCPCS modifier 35"
 CPTM1_36                     "First CPT-4/HCPCS modifier 36"
 CPTM1_37                     "First CPT-4/HCPCS modifier 37"
 CPTM1_38                     "First CPT-4/HCPCS modifier 38"
 CPTM1_39                     "First CPT-4/HCPCS modifier 39"
 CPTM1_40                     "First CPT-4/HCPCS modifier 40"
 CPTM1_41                     "First CPT-4/HCPCS modifier 41"
 CPTM1_42                     "First CPT-4/HCPCS modifier 42"
 CPTM1_43                     "First CPT-4/HCPCS modifier 43"
 CPTM1_44                     "First CPT-4/HCPCS modifier 44"
 CPTM1_45                     "First CPT-4/HCPCS modifier 45"
 CPTM1_46                     "First CPT-4/HCPCS modifier 46"
 CPTM1_47                     "First CPT-4/HCPCS modifier 47"
 CPTM1_48                     "First CPT-4/HCPCS modifier 48"
 CPTM1_49                     "First CPT-4/HCPCS modifier 49"
 CPTM1_50                     "First CPT-4/HCPCS modifier 50"
 CPTM1_51                     "First CPT-4/HCPCS modifier 51"
 CPTM1_52                     "First CPT-4/HCPCS modifier 52"
 CPTM1_53                     "First CPT-4/HCPCS modifier 53"
 CPTM1_54                     "First CPT-4/HCPCS modifier 54"
 CPTM1_55                     "First CPT-4/HCPCS modifier 55"
 CPTM1_56                     "First CPT-4/HCPCS modifier 56"
 CPTM1_57                     "First CPT-4/HCPCS modifier 57"
 CPTM1_58                     "First CPT-4/HCPCS modifier 58"
 CPTM1_59                     "First CPT-4/HCPCS modifier 59"
 CPTM1_60                     "First CPT-4/HCPCS modifier 60"
 CPTM1_61                     "First CPT-4/HCPCS modifier 61"
 CPTM1_62                     "First CPT-4/HCPCS modifier 62"
 CPTM1_63                     "First CPT-4/HCPCS modifier 63"
 CPTM1_64                     "First CPT-4/HCPCS modifier 64"
 CPTM1_65                     "First CPT-4/HCPCS modifier 65"
 CPTM1_66                     "First CPT-4/HCPCS modifier 66"
 CPTM1_67                     "First CPT-4/HCPCS modifier 67"
 CPTM1_68                     "First CPT-4/HCPCS modifier 68"
 CPTM1_69                     "First CPT-4/HCPCS modifier 69"
 CPTM1_70                     "First CPT-4/HCPCS modifier 70"
 CPTM1_71                     "First CPT-4/HCPCS modifier 71"
 CPTM1_72                     "First CPT-4/HCPCS modifier 72"
 CPTM1_73                     "First CPT-4/HCPCS modifier 73"
 CPTM1_74                     "First CPT-4/HCPCS modifier 74"
 CPTM1_75                     "First CPT-4/HCPCS modifier 75"
 CPTM1_76                     "First CPT-4/HCPCS modifier 76"
 CPTM1_77                     "First CPT-4/HCPCS modifier 77"
 CPTM1_78                     "First CPT-4/HCPCS modifier 78"
 CPTM1_79                     "First CPT-4/HCPCS modifier 79"
 CPTM1_80                     "First CPT-4/HCPCS modifier 80"
 CPTM1_81                     "First CPT-4/HCPCS modifier 81"
 CPTM1_82                     "First CPT-4/HCPCS modifier 82"
 CPTM1_83                     "First CPT-4/HCPCS modifier 83"
 CPTM1_84                     "First CPT-4/HCPCS modifier 84"
 CPTM1_85                     "First CPT-4/HCPCS modifier 85"
 CPTM1_86                     "First CPT-4/HCPCS modifier 86"
 CPTM1_87                     "First CPT-4/HCPCS modifier 87"
 CPTM1_88                     "First CPT-4/HCPCS modifier 88"
 CPTM1_89                     "First CPT-4/HCPCS modifier 89"
 CPTM1_90                     "First CPT-4/HCPCS modifier 90"
 CPTM1_91                     "First CPT-4/HCPCS modifier 91"
 CPTM1_92                     "First CPT-4/HCPCS modifier 92"
 CPTM1_93                     "First CPT-4/HCPCS modifier 93"
 CPTM1_94                     "First CPT-4/HCPCS modifier 94"
 CPTM1_95                     "First CPT-4/HCPCS modifier 95"
 CPTM1_96                     "First CPT-4/HCPCS modifier 96"
 CPTM1_97                     "First CPT-4/HCPCS modifier 97"
 CPTM1_98                     "First CPT-4/HCPCS modifier 98"
 CPTM1_99                     "First CPT-4/HCPCS modifier 99"
 CPTM1_100                    "First CPT-4/HCPCS modifier 100"
 CPTM1_101                    "First CPT-4/HCPCS modifier 101"
 CPTM1_102                    "First CPT-4/HCPCS modifier 102"
 CPTM1_103                    "First CPT-4/HCPCS modifier 103"
 CPTM1_104                    "First CPT-4/HCPCS modifier 104"
 CPTM1_105                    "First CPT-4/HCPCS modifier 105"
 CPTM1_106                    "First CPT-4/HCPCS modifier 106"
 CPTM1_107                    "First CPT-4/HCPCS modifier 107"
 CPTM1_108                    "First CPT-4/HCPCS modifier 108"
 CPTM1_109                    "First CPT-4/HCPCS modifier 109"
 CPTM1_110                    "First CPT-4/HCPCS modifier 110"
 CPTM2_1                      "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                      "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                      "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                      "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                      "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                      "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                      "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                      "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                      "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                     "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                     "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                     "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                     "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                     "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                     "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                     "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                     "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                     "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                     "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                     "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                     "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                     "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                     "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                     "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                     "Second CPT-4/HCPCS modifier 25"
 CPTM2_26                     "Second CPT-4/HCPCS modifier 26"
 CPTM2_27                     "Second CPT-4/HCPCS modifier 27"
 CPTM2_28                     "Second CPT-4/HCPCS modifier 28"
 CPTM2_29                     "Second CPT-4/HCPCS modifier 29"
 CPTM2_30                     "Second CPT-4/HCPCS modifier 30"
 CPTM2_31                     "Second CPT-4/HCPCS modifier 31"
 CPTM2_32                     "Second CPT-4/HCPCS modifier 32"
 CPTM2_33                     "Second CPT-4/HCPCS modifier 33"
 CPTM2_34                     "Second CPT-4/HCPCS modifier 34"
 CPTM2_35                     "Second CPT-4/HCPCS modifier 35"
 CPTM2_36                     "Second CPT-4/HCPCS modifier 36"
 CPTM2_37                     "Second CPT-4/HCPCS modifier 37"
 CPTM2_38                     "Second CPT-4/HCPCS modifier 38"
 CPTM2_39                     "Second CPT-4/HCPCS modifier 39"
 CPTM2_40                     "Second CPT-4/HCPCS modifier 40"
 CPTM2_41                     "Second CPT-4/HCPCS modifier 41"
 CPTM2_42                     "Second CPT-4/HCPCS modifier 42"
 CPTM2_43                     "Second CPT-4/HCPCS modifier 43"
 CPTM2_44                     "Second CPT-4/HCPCS modifier 44"
 CPTM2_45                     "Second CPT-4/HCPCS modifier 45"
 CPTM2_46                     "Second CPT-4/HCPCS modifier 46"
 CPTM2_47                     "Second CPT-4/HCPCS modifier 47"
 CPTM2_48                     "Second CPT-4/HCPCS modifier 48"
 CPTM2_49                     "Second CPT-4/HCPCS modifier 49"
 CPTM2_50                     "Second CPT-4/HCPCS modifier 50"
 CPTM2_51                     "Second CPT-4/HCPCS modifier 51"
 CPTM2_52                     "Second CPT-4/HCPCS modifier 52"
 CPTM2_53                     "Second CPT-4/HCPCS modifier 53"
 CPTM2_54                     "Second CPT-4/HCPCS modifier 54"
 CPTM2_55                     "Second CPT-4/HCPCS modifier 55"
 CPTM2_56                     "Second CPT-4/HCPCS modifier 56"
 CPTM2_57                     "Second CPT-4/HCPCS modifier 57"
 CPTM2_58                     "Second CPT-4/HCPCS modifier 58"
 CPTM2_59                     "Second CPT-4/HCPCS modifier 59"
 CPTM2_60                     "Second CPT-4/HCPCS modifier 60"
 CPTM2_61                     "Second CPT-4/HCPCS modifier 61"
 CPTM2_62                     "Second CPT-4/HCPCS modifier 62"
 CPTM2_63                     "Second CPT-4/HCPCS modifier 63"
 CPTM2_64                     "Second CPT-4/HCPCS modifier 64"
 CPTM2_65                     "Second CPT-4/HCPCS modifier 65"
 CPTM2_66                     "Second CPT-4/HCPCS modifier 66"
 CPTM2_67                     "Second CPT-4/HCPCS modifier 67"
 CPTM2_68                     "Second CPT-4/HCPCS modifier 68"
 CPTM2_69                     "Second CPT-4/HCPCS modifier 69"
 CPTM2_70                     "Second CPT-4/HCPCS modifier 70"
 CPTM2_71                     "Second CPT-4/HCPCS modifier 71"
 CPTM2_72                     "Second CPT-4/HCPCS modifier 72"
 CPTM2_73                     "Second CPT-4/HCPCS modifier 73"
 CPTM2_74                     "Second CPT-4/HCPCS modifier 74"
 CPTM2_75                     "Second CPT-4/HCPCS modifier 75"
 CPTM2_76                     "Second CPT-4/HCPCS modifier 76"
 CPTM2_77                     "Second CPT-4/HCPCS modifier 77"
 CPTM2_78                     "Second CPT-4/HCPCS modifier 78"
 CPTM2_79                     "Second CPT-4/HCPCS modifier 79"
 CPTM2_80                     "Second CPT-4/HCPCS modifier 80"
 CPTM2_81                     "Second CPT-4/HCPCS modifier 81"
 CPTM2_82                     "Second CPT-4/HCPCS modifier 82"
 CPTM2_83                     "Second CPT-4/HCPCS modifier 83"
 CPTM2_84                     "Second CPT-4/HCPCS modifier 84"
 CPTM2_85                     "Second CPT-4/HCPCS modifier 85"
 CPTM2_86                     "Second CPT-4/HCPCS modifier 86"
 CPTM2_87                     "Second CPT-4/HCPCS modifier 87"
 CPTM2_88                     "Second CPT-4/HCPCS modifier 88"
 CPTM2_89                     "Second CPT-4/HCPCS modifier 89"
 CPTM2_90                     "Second CPT-4/HCPCS modifier 90"
 CPTM2_91                     "Second CPT-4/HCPCS modifier 91"
 CPTM2_92                     "Second CPT-4/HCPCS modifier 92"
 CPTM2_93                     "Second CPT-4/HCPCS modifier 93"
 CPTM2_94                     "Second CPT-4/HCPCS modifier 94"
 CPTM2_95                     "Second CPT-4/HCPCS modifier 95"
 CPTM2_96                     "Second CPT-4/HCPCS modifier 96"
 CPTM2_97                     "Second CPT-4/HCPCS modifier 97"
 CPTM2_98                     "Second CPT-4/HCPCS modifier 98"
 CPTM2_99                     "Second CPT-4/HCPCS modifier 99"
 CPTM2_100                    "Second CPT-4/HCPCS modifier 100"
 CPTM2_101                    "Second CPT-4/HCPCS modifier 101"
 CPTM2_102                    "Second CPT-4/HCPCS modifier 102"
 CPTM2_103                    "Second CPT-4/HCPCS modifier 103"
 CPTM2_104                    "Second CPT-4/HCPCS modifier 104"
 CPTM2_105                    "Second CPT-4/HCPCS modifier 105"
 CPTM2_106                    "Second CPT-4/HCPCS modifier 106"
 CPTM2_107                    "Second CPT-4/HCPCS modifier 107"
 CPTM2_108                    "Second CPT-4/HCPCS modifier 108"
 CPTM2_109                    "Second CPT-4/HCPCS modifier 109"
 CPTM2_110                    "Second CPT-4/HCPCS modifier 110"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DSHOSPID                     "Data source hospital identifier"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HOSPST                       "Hospital state postal code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes (RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PrimLang                     "Primary language of patient"
 PSTATE                       "Patient State postal code"
 PSTATE_GEO                   "Patient State postal code assigned from ZIP Code"
 PSTCO_GEO                    "Counties assigned based on ZIP Code geographic centroids"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 VisitLink                    "Visit linkage data element"
 DaysToEvent                  "Days from 'start date' to admission"
 AYEAR                        "Admission year" .


/**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************/

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS53
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS54
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS55
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS56
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS57
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS58
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS59
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS60
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS61
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS62
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS63
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS64
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS65
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS66
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS67
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS68
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS69
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS70
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS71
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS72
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS73
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS74
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS75
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS76
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS77
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS78
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS79
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS80
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS81
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS82
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS83
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS84
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS85
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS86
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS87
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS88
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS89
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS90
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS91
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS92
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS93
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS94
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS95
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS96
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS97
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS98
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS99
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS100
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS101
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS102
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS103
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS104
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS105
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS106
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS107
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS108
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS109
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS110
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PSTCO_GEO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'HI_SEDD_2019_CORE.sav' /COMPRESSED.
