/*******************************************************************
* Creation Date: 05/13/2016   
*   GA_SEDD_2012_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'GA_SEDD_2012_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 CHRON1                          1-   2
 CHRON2                          3-   4
 CHRON3                          5-   6
 CHRON4                          7-   8
 CHRON5                          9-  10
 CHRON6                         11-  12
 CHRON7                         13-  14
 CHRON8                         15-  16
 CHRON9                         17-  18
 CHRON10                        19-  20
 CHRON11                        21-  22
 CHRON12                        23-  24
 CHRON13                        25-  26
 CHRON14                        27-  28
 CHRON15                        29-  30
 CHRON16                        31-  32
 CHRON17                        33-  34
 CHRON18                        35-  36
 CHRON19                        37-  38
 CHRON20                        39-  40
 CHRON21                        41-  42
 CHRON22                        43-  44
 CHRON23                        45-  46
 CHRON24                        47-  48
 CHRON25                        49-  50
 CHRON26                        51-  52
 CHRON27                        53-  54
 CHRON28                        55-  56
 CHRON29                        57-  58
 CHRON30                        59-  60
 CHRON31                        61-  62
 CHRON32                        63-  64
 CHRON33                        65-  66
 CHRON34                        67-  68
 CHRON35                        69-  70
 CHRONB1                        71-  72
 CHRONB2                        73-  74
 CHRONB3                        75-  76
 CHRONB4                        77-  78
 CHRONB5                        79-  80
 CHRONB6                        81-  82
 CHRONB7                        83-  84
 CHRONB8                        85-  86
 CHRONB9                        87-  88
 CHRONB10                       89-  90
 CHRONB11                       91-  92
 CHRONB12                       93-  94
 CHRONB13                       95-  96
 CHRONB14                       97-  98
 CHRONB15                       99- 100
 CHRONB16                      101- 102
 CHRONB17                      103- 104
 CHRONB18                      105- 106
 CHRONB19                      107- 108
 CHRONB20                      109- 110
 CHRONB21                      111- 112
 CHRONB22                      113- 114
 CHRONB23                      115- 116
 CHRONB24                      117- 118
 CHRONB25                      119- 120
 CHRONB26                      121- 122
 CHRONB27                      123- 124
 CHRONB28                      125- 126
 CHRONB29                      127- 128
 CHRONB30                      129- 130
 CHRONB31                      131- 132
 CHRONB32                      133- 134
 CHRONB33                      135- 136
 CHRONB34                      137- 138
 CHRONB35                      139- 140
 DXMCCS1                       141- 151 (A)
 DXMCCS2                       152- 162 (A)
 DXMCCS3                       163- 173 (A)
 DXMCCS4                       174- 184 (A)
 DXMCCS5                       185- 195 (A)
 DXMCCS6                       196- 206 (A)
 DXMCCS7                       207- 217 (A)
 DXMCCS8                       218- 228 (A)
 DXMCCS9                       229- 239 (A)
 DXMCCS10                      240- 250 (A)
 DXMCCS11                      251- 261 (A)
 DXMCCS12                      262- 272 (A)
 DXMCCS13                      273- 283 (A)
 DXMCCS14                      284- 294 (A)
 DXMCCS15                      295- 305 (A)
 DXMCCS16                      306- 316 (A)
 DXMCCS17                      317- 327 (A)
 DXMCCS18                      328- 338 (A)
 DXMCCS19                      339- 349 (A)
 DXMCCS20                      350- 360 (A)
 DXMCCS21                      361- 371 (A)
 DXMCCS22                      372- 382 (A)
 DXMCCS23                      383- 393 (A)
 DXMCCS24                      394- 404 (A)
 DXMCCS25                      405- 415 (A)
 DXMCCS26                      416- 426 (A)
 DXMCCS27                      427- 437 (A)
 DXMCCS28                      438- 448 (A)
 DXMCCS29                      449- 459 (A)
 DXMCCS30                      460- 470 (A)
 DXMCCS31                      471- 481 (A)
 DXMCCS32                      482- 492 (A)
 DXMCCS33                      493- 503 (A)
 DXMCCS34                      504- 514 (A)
 DXMCCS35                      515- 525 (A)
 E_MCCS1                       526- 536 (A)
 E_MCCS2                       537- 547 (A)
 E_MCCS3                       548- 558 (A)
 E_MCCS4                       559- 569 (A)
 E_MCCS5                       570- 580 (A)
 E_MCCS6                       581- 591 (A)
 E_MCCS7                       592- 602 (A)
 E_MCCS8                       603- 613 (A)
 E_MCCS9                       614- 624 (A)
 E_MCCS10                      625- 635 (A)
 E_MCCS11                      636- 646 (A)
 E_MCCS12                      647- 657 (A)
 E_MCCS13                      658- 668 (A)
 E_MCCS14                      669- 679 (A)
 E_MCCS15                      680- 690 (A)
 E_MCCS16                      691- 701 (A)
 E_MCCS17                      702- 712 (A)
 E_MCCS18                      713- 723 (A)
 E_MCCS19                      724- 734 (A)
 E_MCCS20                      735- 745 (A)
 INJURY                        746- 747
 INJURY_CUT                    748- 749
 INJURY_DROWN                  750- 751
 INJURY_FALL                   752- 753
 INJURY_FIRE                   754- 755
 INJURY_FIREARM                756- 757
 INJURY_MACHINERY              758- 759
 INJURY_MVT                    760- 761
 INJURY_NATURE                 762- 763
 INJURY_POISON                 764- 765
 INJURY_STRUCK                 766- 767
 INJURY_SUFFOCATION            768- 769
 INTENT_ASSAULT                770- 771
 INTENT_SELF_HARM              772- 773
 INTENT_UNINTENTIONAL          774- 775
 KEY                           776- 790
 MULTINJURY                    791- 792
 PCLASS1                       793- 794
 PCLASS2                       795- 796
 PCLASS3                       797- 798
 PCLASS4                       799- 800
 PCLASS5                       801- 802
 PCLASS6                       803- 804
 PCLASS7                       805- 806
 PCLASS8                       807- 808
 PCLASS9                       809- 810
 PCLASS10                      811- 812
 PCLASS11                      813- 814
 PCLASS12                      815- 816
 PCLASS13                      817- 818
 PCLASS14                      819- 820
 PCLASS15                      821- 822
 PCLASS16                      823- 824
 PCLASS17                      825- 826
 PCLASS18                      827- 828
 PCLASS19                      829- 830
 PCLASS20                      831- 832
 PCLASS21                      833- 834
 PCLASS22                      835- 836
 PCLASS23                      837- 838
 PCLASS24                      839- 840
 PCLASS25                      841- 842
 PRMCCS1                       843- 850 (A)
 PRMCCS2                       851- 858 (A)
 PRMCCS3                       859- 866 (A)
 PRMCCS4                       867- 874 (A)
 PRMCCS5                       875- 882 (A)
 PRMCCS6                       883- 890 (A)
 PRMCCS7                       891- 898 (A)
 PRMCCS8                       899- 906 (A)
 PRMCCS9                       907- 914 (A)
 PRMCCS10                      915- 922 (A)
 PRMCCS11                      923- 930 (A)
 PRMCCS12                      931- 938 (A)
 PRMCCS13                      939- 946 (A)
 PRMCCS14                      947- 954 (A)
 PRMCCS15                      955- 962 (A)
 PRMCCS16                      963- 970 (A)
 PRMCCS17                      971- 978 (A)
 PRMCCS18                      979- 986 (A)
 PRMCCS19                      987- 994 (A)
 PRMCCS20                      995-1002 (A)
 PRMCCS21                     1003-1010 (A)
 PRMCCS22                     1011-1018 (A)
 PRMCCS23                     1019-1026 (A)
 PRMCCS24                     1027-1034 (A)
 PRMCCS25                     1035-1042 (A)
 U_BLOOD                      1043-1044
 U_CATH                       1045-1046
 U_CCU                        1047-1048
 U_CHESTXRAY                  1049-1050
 U_CTSCAN                     1051-1052
 U_DIALYSIS                   1053-1054
 U_ECHO                       1055-1056
 U_ED                         1057-1058
 U_EEG                        1059-1060
 U_EKG                        1061-1062
 U_EPO                        1063-1064
 U_ICU                        1065-1066
 U_LITHOTRIPSY                1067-1068
 U_MHSA                       1069-1070
 U_MRT                        1071-1072
 U_NEWBN2L                    1073-1074
 U_NEWBN3L                    1075-1076
 U_NEWBN4L                    1077-1078
 U_NUCMED                     1079-1080
 U_OBSERVATION                1081-1082
 U_OCCTHERAPY                 1083-1084
 U_ORGANACQ                   1085-1086
 U_OTHIMPLANTS                1087-1088
 U_PACEMAKER                  1089-1090
 U_PHYTHERAPY                 1091-1092
 U_RADTHERAPY                 1093-1094
 U_RESPTHERAPY                1095-1096
 U_SPEECHTHERAPY              1097-1098
 U_STRESS                     1099-1100
 U_ULTRASOUND                 1101-1102.


***  Specify write formats  ***.
FORMATS
 CHRON1                       (F3.0) /
 CHRON2                       (F3.0) /
 CHRON3                       (F3.0) /
 CHRON4                       (F3.0) /
 CHRON5                       (F3.0) /
 CHRON6                       (F3.0) /
 CHRON7                       (F3.0) /
 CHRON8                       (F3.0) /
 CHRON9                       (F3.0) /
 CHRON10                      (F3.0) /
 CHRON11                      (F3.0) /
 CHRON12                      (F3.0) /
 CHRON13                      (F3.0) /
 CHRON14                      (F3.0) /
 CHRON15                      (F3.0) /
 CHRON16                      (F3.0) /
 CHRON17                      (F3.0) /
 CHRON18                      (F3.0) /
 CHRON19                      (F3.0) /
 CHRON20                      (F3.0) /
 CHRON21                      (F3.0) /
 CHRON22                      (F3.0) /
 CHRON23                      (F3.0) /
 CHRON24                      (F3.0) /
 CHRON25                      (F3.0) /
 CHRON26                      (F3.0) /
 CHRON27                      (F3.0) /
 CHRON28                      (F3.0) /
 CHRON29                      (F3.0) /
 CHRON30                      (F3.0) /
 CHRON31                      (F3.0) /
 CHRON32                      (F3.0) /
 CHRON33                      (F3.0) /
 CHRON34                      (F3.0) /
 CHRON35                      (F3.0) /
 CHRONB1                      (F3.0) /
 CHRONB2                      (F3.0) /
 CHRONB3                      (F3.0) /
 CHRONB4                      (F3.0) /
 CHRONB5                      (F3.0) /
 CHRONB6                      (F3.0) /
 CHRONB7                      (F3.0) /
 CHRONB8                      (F3.0) /
 CHRONB9                      (F3.0) /
 CHRONB10                     (F3.0) /
 CHRONB11                     (F3.0) /
 CHRONB12                     (F3.0) /
 CHRONB13                     (F3.0) /
 CHRONB14                     (F3.0) /
 CHRONB15                     (F3.0) /
 CHRONB16                     (F3.0) /
 CHRONB17                     (F3.0) /
 CHRONB18                     (F3.0) /
 CHRONB19                     (F3.0) /
 CHRONB20                     (F3.0) /
 CHRONB21                     (F3.0) /
 CHRONB22                     (F3.0) /
 CHRONB23                     (F3.0) /
 CHRONB24                     (F3.0) /
 CHRONB25                     (F3.0) /
 CHRONB26                     (F3.0) /
 CHRONB27                     (F3.0) /
 CHRONB28                     (F3.0) /
 CHRONB29                     (F3.0) /
 CHRONB30                     (F3.0) /
 CHRONB31                     (F3.0) /
 CHRONB32                     (F3.0) /
 CHRONB33                     (F3.0) /
 CHRONB34                     (F3.0) /
 CHRONB35                     (F3.0) /
 INJURY                       (F3.0) /
 INJURY_CUT                   (F3.0) /
 INJURY_DROWN                 (F3.0) /
 INJURY_FALL                  (F3.0) /
 INJURY_FIRE                  (F3.0) /
 INJURY_FIREARM               (F3.0) /
 INJURY_MACHINERY             (F3.0) /
 INJURY_MVT                   (F3.0) /
 INJURY_NATURE                (F3.0) /
 INJURY_POISON                (F3.0) /
 INJURY_STRUCK                (F3.0) /
 INJURY_SUFFOCATION           (F3.0) /
 INTENT_ASSAULT               (F3.0) /
 INTENT_SELF_HARM             (F3.0) /
 INTENT_UNINTENTIONAL         (F3.0) /
 KEY                          (F8.0) /
 MULTINJURY                   (F3.0) /
 PCLASS1                      (F3.0) /
 PCLASS2                      (F3.0) /
 PCLASS3                      (F3.0) /
 PCLASS4                      (F3.0) /
 PCLASS5                      (F3.0) /
 PCLASS6                      (F3.0) /
 PCLASS7                      (F3.0) /
 PCLASS8                      (F3.0) /
 PCLASS9                      (F3.0) /
 PCLASS10                     (F3.0) /
 PCLASS11                     (F3.0) /
 PCLASS12                     (F3.0) /
 PCLASS13                     (F3.0) /
 PCLASS14                     (F3.0) /
 PCLASS15                     (F3.0) /
 PCLASS16                     (F3.0) /
 PCLASS17                     (F3.0) /
 PCLASS18                     (F3.0) /
 PCLASS19                     (F3.0) /
 PCLASS20                     (F3.0) /
 PCLASS21                     (F3.0) /
 PCLASS22                     (F3.0) /
 PCLASS23                     (F3.0) /
 PCLASS24                     (F3.0) /
 PCLASS25                     (F3.0) /
 U_BLOOD                      (F3.0) /
 U_CATH                       (F3.0) /
 U_CCU                        (F3.0) /
 U_CHESTXRAY                  (F3.0) /
 U_CTSCAN                     (F3.0) /
 U_DIALYSIS                   (F3.0) /
 U_ECHO                       (F3.0) /
 U_ED                         (F3.0) /
 U_EEG                        (F3.0) /
 U_EKG                        (F3.0) /
 U_EPO                        (F3.0) /
 U_ICU                        (F3.0) /
 U_LITHOTRIPSY                (F3.0) /
 U_MHSA                       (F3.0) /
 U_MRT                        (F3.0) /
 U_NEWBN2L                    (F3.0) /
 U_NEWBN3L                    (F3.0) /
 U_NEWBN4L                    (F3.0) /
 U_NUCMED                     (F3.0) /
 U_OBSERVATION                (F3.0) /
 U_OCCTHERAPY                 (F3.0) /
 U_ORGANACQ                   (F3.0) /
 U_OTHIMPLANTS                (F3.0) /
 U_PACEMAKER                  (F3.0) /
 U_PHYTHERAPY                 (F3.0) /
 U_RADTHERAPY                 (F3.0) /
 U_RESPTHERAPY                (F3.0) /
 U_SPEECHTHERAPY              (F3.0) /
 U_STRESS                     (F3.0) /
 U_ULTRASOUND                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1                       "Chronic condition indicator 1"
 CHRON2                       "Chronic condition indicator 2"
 CHRON3                       "Chronic condition indicator 3"
 CHRON4                       "Chronic condition indicator 4"
 CHRON5                       "Chronic condition indicator 5"
 CHRON6                       "Chronic condition indicator 6"
 CHRON7                       "Chronic condition indicator 7"
 CHRON8                       "Chronic condition indicator 8"
 CHRON9                       "Chronic condition indicator 9"
 CHRON10                      "Chronic condition indicator 10"
 CHRON11                      "Chronic condition indicator 11"
 CHRON12                      "Chronic condition indicator 12"
 CHRON13                      "Chronic condition indicator 13"
 CHRON14                      "Chronic condition indicator 14"
 CHRON15                      "Chronic condition indicator 15"
 CHRON16                      "Chronic condition indicator 16"
 CHRON17                      "Chronic condition indicator 17"
 CHRON18                      "Chronic condition indicator 18"
 CHRON19                      "Chronic condition indicator 19"
 CHRON20                      "Chronic condition indicator 20"
 CHRON21                      "Chronic condition indicator 21"
 CHRON22                      "Chronic condition indicator 22"
 CHRON23                      "Chronic condition indicator 23"
 CHRON24                      "Chronic condition indicator 24"
 CHRON25                      "Chronic condition indicator 25"
 CHRON26                      "Chronic condition indicator 26"
 CHRON27                      "Chronic condition indicator 27"
 CHRON28                      "Chronic condition indicator 28"
 CHRON29                      "Chronic condition indicator 29"
 CHRON30                      "Chronic condition indicator 30"
 CHRON31                      "Chronic condition indicator 31"
 CHRON32                      "Chronic condition indicator 32"
 CHRON33                      "Chronic condition indicator 33"
 CHRON34                      "Chronic condition indicator 34"
 CHRON35                      "Chronic condition indicator 35"
 CHRONB1                      "Chronic condition body system 1"
 CHRONB2                      "Chronic condition body system 2"
 CHRONB3                      "Chronic condition body system 3"
 CHRONB4                      "Chronic condition body system 4"
 CHRONB5                      "Chronic condition body system 5"
 CHRONB6                      "Chronic condition body system 6"
 CHRONB7                      "Chronic condition body system 7"
 CHRONB8                      "Chronic condition body system 8"
 CHRONB9                      "Chronic condition body system 9"
 CHRONB10                     "Chronic condition body system 10"
 CHRONB11                     "Chronic condition body system 11"
 CHRONB12                     "Chronic condition body system 12"
 CHRONB13                     "Chronic condition body system 13"
 CHRONB14                     "Chronic condition body system 14"
 CHRONB15                     "Chronic condition body system 15"
 CHRONB16                     "Chronic condition body system 16"
 CHRONB17                     "Chronic condition body system 17"
 CHRONB18                     "Chronic condition body system 18"
 CHRONB19                     "Chronic condition body system 19"
 CHRONB20                     "Chronic condition body system 20"
 CHRONB21                     "Chronic condition body system 21"
 CHRONB22                     "Chronic condition body system 22"
 CHRONB23                     "Chronic condition body system 23"
 CHRONB24                     "Chronic condition body system 24"
 CHRONB25                     "Chronic condition body system 25"
 CHRONB26                     "Chronic condition body system 26"
 CHRONB27                     "Chronic condition body system 27"
 CHRONB28                     "Chronic condition body system 28"
 CHRONB29                     "Chronic condition body system 29"
 CHRONB30                     "Chronic condition body system 30"
 CHRONB31                     "Chronic condition body system 31"
 CHRONB32                     "Chronic condition body system 32"
 CHRONB33                     "Chronic condition body system 33"
 CHRONB34                     "Chronic condition body system 34"
 CHRONB35                     "Chronic condition body system 35"
 DXMCCS1                      "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                      "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                      "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                      "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                      "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                      "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                      "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                      "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                      "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                     "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                     "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                     "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                     "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                     "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                     "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16                     "Multi-Level CCS:  Diagnosis 16"
 DXMCCS17                     "Multi-Level CCS:  Diagnosis 17"
 DXMCCS18                     "Multi-Level CCS:  Diagnosis 18"
 DXMCCS19                     "Multi-Level CCS:  Diagnosis 19"
 DXMCCS20                     "Multi-Level CCS:  Diagnosis 20"
 DXMCCS21                     "Multi-Level CCS:  Diagnosis 21"
 DXMCCS22                     "Multi-Level CCS:  Diagnosis 22"
 DXMCCS23                     "Multi-Level CCS:  Diagnosis 23"
 DXMCCS24                     "Multi-Level CCS:  Diagnosis 24"
 DXMCCS25                     "Multi-Level CCS:  Diagnosis 25"
 DXMCCS26                     "Multi-Level CCS:  Diagnosis 26"
 DXMCCS27                     "Multi-Level CCS:  Diagnosis 27"
 DXMCCS28                     "Multi-Level CCS:  Diagnosis 28"
 DXMCCS29                     "Multi-Level CCS:  Diagnosis 29"
 DXMCCS30                     "Multi-Level CCS:  Diagnosis 30"
 DXMCCS31                     "Multi-Level CCS:  Diagnosis 31"
 DXMCCS32                     "Multi-Level CCS:  Diagnosis 32"
 DXMCCS33                     "Multi-Level CCS:  Diagnosis 33"
 DXMCCS34                     "Multi-Level CCS:  Diagnosis 34"
 DXMCCS35                     "Multi-Level CCS:  Diagnosis 35"
 E_MCCS1                      "Multi-Level CCS:  E Code 1"
 E_MCCS2                      "Multi-Level CCS:  E Code 2"
 E_MCCS3                      "Multi-Level CCS:  E Code 3"
 E_MCCS4                      "Multi-Level CCS:  E Code 4"
 E_MCCS5                      "Multi-Level CCS:  E Code 5"
 E_MCCS6                      "Multi-Level CCS:  E Code 6"
 E_MCCS7                      "Multi-Level CCS:  E Code 7"
 E_MCCS8                      "Multi-Level CCS:  E Code 8"
 E_MCCS9                      "Multi-Level CCS:  E Code 9"
 E_MCCS10                     "Multi-Level CCS:  E Code 10"
 E_MCCS11                     "Multi-Level CCS:  E Code 11"
 E_MCCS12                     "Multi-Level CCS:  E Code 12"
 E_MCCS13                     "Multi-Level CCS:  E Code 13"
 E_MCCS14                     "Multi-Level CCS:  E Code 14"
 E_MCCS15                     "Multi-Level CCS:  E Code 15"
 E_MCCS16                     "Multi-Level CCS:  E Code 16"
 E_MCCS17                     "Multi-Level CCS:  E Code 17"
 E_MCCS18                     "Multi-Level CCS:  E Code 18"
 E_MCCS19                     "Multi-Level CCS:  E Code 19"
 E_MCCS20                     "Multi-Level CCS:  E Code 20"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT                   "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN                 "Injury by drowning or submersion (by E codes)"
 INJURY_FALL                  "Injury by falling (by E codes)"
 INJURY_FIRE                  "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM               "Injury by firearm (by E codes)"
 INJURY_MACHINERY             "Injury by machinery (by E codes)"
 INJURY_MVT                   "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE
"Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON                "Injury by poison (by E codes)"
 INJURY_STRUCK                "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION           "Injury by suffocation (by E codes)"
 INTENT_ASSAULT               "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM
"Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL         "Unintentional injury indicated on the record (by E codes)"
 KEY                          "HCUP record identifier"
 MULTINJURY                   "More than one injury diagnosis reported on record"
 PCLASS1                      "Procedure class 1"
 PCLASS2                      "Procedure class 2"
 PCLASS3                      "Procedure class 3"
 PCLASS4                      "Procedure class 4"
 PCLASS5                      "Procedure class 5"
 PCLASS6                      "Procedure class 6"
 PCLASS7                      "Procedure class 7"
 PCLASS8                      "Procedure class 8"
 PCLASS9                      "Procedure class 9"
 PCLASS10                     "Procedure class 10"
 PCLASS11                     "Procedure class 11"
 PCLASS12                     "Procedure class 12"
 PCLASS13                     "Procedure class 13"
 PCLASS14                     "Procedure class 14"
 PCLASS15                     "Procedure class 15"
 PCLASS16                     "Procedure class 16"
 PCLASS17                     "Procedure class 17"
 PCLASS18                     "Procedure class 18"
 PCLASS19                     "Procedure class 19"
 PCLASS20                     "Procedure class 20"
 PCLASS21                     "Procedure class 21"
 PCLASS22                     "Procedure class 22"
 PCLASS23                     "Procedure class 23"
 PCLASS24                     "Procedure class 24"
 PCLASS25                     "Procedure class 25"
 PRMCCS1                      "Multi-Level CCS:  Procedure 1"
 PRMCCS2                      "Multi-Level CCS:  Procedure 2"
 PRMCCS3                      "Multi-Level CCS:  Procedure 3"
 PRMCCS4                      "Multi-Level CCS:  Procedure 4"
 PRMCCS5                      "Multi-Level CCS:  Procedure 5"
 PRMCCS6                      "Multi-Level CCS:  Procedure 6"
 PRMCCS7                      "Multi-Level CCS:  Procedure 7"
 PRMCCS8                      "Multi-Level CCS:  Procedure 8"
 PRMCCS9                      "Multi-Level CCS:  Procedure 9"
 PRMCCS10                     "Multi-Level CCS:  Procedure 10"
 PRMCCS11                     "Multi-Level CCS:  Procedure 11"
 PRMCCS12                     "Multi-Level CCS:  Procedure 12"
 PRMCCS13                     "Multi-Level CCS:  Procedure 13"
 PRMCCS14                     "Multi-Level CCS:  Procedure 14"
 PRMCCS15                     "Multi-Level CCS:  Procedure 15"
 PRMCCS16                     "Multi-Level CCS:  Procedure 16"
 PRMCCS17                     "Multi-Level CCS:  Procedure 17"
 PRMCCS18                     "Multi-Level CCS:  Procedure 18"
 PRMCCS19                     "Multi-Level CCS:  Procedure 19"
 PRMCCS20                     "Multi-Level CCS:  Procedure 20"
 PRMCCS21                     "Multi-Level CCS:  Procedure 21"
 PRMCCS22                     "Multi-Level CCS:  Procedure 22"
 PRMCCS23                     "Multi-Level CCS:  Procedure 23"
 PRMCCS24                     "Multi-Level CCS:  Procedure 24"
 PRMCCS25                     "Multi-Level CCS:  Procedure 25"
 U_BLOOD                      "Utilization Flag: Blood"
 U_CATH                       "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU                        "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY                  "Utilization Flag: Chest X-Ray"
 U_CTSCAN                     "Utilization Flag: Computed Tomography Scan"
 U_DIALYSIS                   "Utilization Flag: Renal Dialysis"
 U_ECHO                       "Utilization Flag: Echocardiology"
 U_ED                         "Utilization Flag: Emergency Room"
 U_EEG                        "Utilization Flag: Electroencephalogram"
 U_EKG                        "Utilization Flag: Electrocardiogram"
 U_EPO                        "Utilization Flag: EPO"
 U_ICU                        "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY                "Utilization Flag: Lithotripsy"
 U_MHSA                       "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT                        "Utilization Flag: Medical Resonance Technology"
 U_NEWBN2L                    "Utilization Flag: Nursery Level II"
 U_NEWBN3L                    "Utilization Flag: Nursery Level III"
 U_NEWBN4L                    "Utilization Flag: Nursery Level IV"
 U_NUCMED                     "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION                "Utilization Flag: Observation Room"
 U_OCCTHERAPY                 "Utilization Flag: Occupational Therapy"
 U_ORGANACQ                   "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS                "Utilization Flag: Other Implants"
 U_PACEMAKER                  "Utilization Flag: Pacemaker"
 U_PHYTHERAPY                 "Utilization Flag: Physical Therapy"
 U_RADTHERAPY
"Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTHERAPY                "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY              "Utilization Flag: Speech - Language Pathology"
 U_STRESS                     "Utilization Flag: Cardiac Stress Test"
 U_ULTRASOUND                 "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON32
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON33
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON34
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON35
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB32
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB33
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB34
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB35
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS16
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS17
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS18
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS19
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS20
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS21
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS22
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS23
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS24
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS25
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'GA_SEDD_2012_DX_PR_GRPS.SAV' /COMPRESSED.
