/*******************************************************************
* Creation Date: 02/26/2025   
*   FL_SEDD_2023_CHGS.sps:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      SEDD CHGS FILE INTO SPSS                                   
*******************************************************************/


/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************/

DATA LIST FILE = 'FL_SEDD_2023_CHGS.asc' FIXED SKIP=2 / 
 CHG1                            1-  12
 CHG2                           13-  24
 CHG3                           25-  36
 CHG4                           37-  48
 CHG5                           49-  60
 CHG6                           61-  72
 CHG7                           73-  84
 CHG8                           85-  96
 CHG9                           97- 108
 CHG10                         109- 120
 CHG11                         121- 132
 CHG12                         133- 144
 CHG13                         145- 156
 CHG14                         157- 168
 KEY                           169- 183.


/***  Specify write formats  ***/
FORMATS
 CHG1                         (F6.2) /
 CHG2                         (F6.2) /
 CHG3                         (F6.2) /
 CHG4                         (F6.2) /
 CHG5                         (F6.2) /
 CHG6                         (F6.2) /
 CHG7                         (F6.2) /
 CHG8                         (F6.2) /
 CHG9                         (F6.2) /
 CHG10                        (F6.2) /
 CHG11                        (F6.2) /
 CHG12                        (F6.2) /
 CHG13                        (F6.2) /
 CHG14                        (F6.2) /
 KEY                          (F8.0) .


/***  Assign labels to the variables ***/
VARIABLE LABELS 
 CHG1                         "Detailed charges 1 (as received from source)"
 CHG2                         "Detailed charges 2 (as received from source)"
 CHG3                         "Detailed charges 3 (as received from source)"
 CHG4                         "Detailed charges 4 (as received from source)"
 CHG5                         "Detailed charges 5 (as received from source)"
 CHG6                         "Detailed charges 6 (as received from source)"
 CHG7                         "Detailed charges 7 (as received from source)"
 CHG8                         "Detailed charges 8 (as received from source)"
 CHG9                         "Detailed charges 9 (as received from source)"
 CHG10                        "Detailed charges 10 (as received from source)"
 CHG11                        "Detailed charges 11 (as received from source)"
 CHG12                        "Detailed charges 12 (as received from source)"
 CHG13                        "Detailed charges 13 (as received from source)"
 CHG14                        "Detailed charges 14 (as received from source)"
 KEY                          "HCUP record identifier" .


/**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************/

RECODE CHG1
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG2
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG3
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG4
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG5
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG6
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG7
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG8
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG9
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG10
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG11
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG12
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG13
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG14
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).



SAVE OUTFILE = 'FL_SEDD_2023_CHGS.sav' /COMPRESSED.
