/*******************************************************************
* Creation Date: 10/12/2020   
*   AR_SEDD_2018_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'AR_SEDD_2018_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AHOUR                          10-  13
 AMONTH                         14-  15
 ATYPE                          16-  17
 AWEEKEND                       18-  19
 BILLTYPE                       20-  23 (A)
 CPT1                           24-  28 (A)
 CPT2                           29-  33 (A)
 CPT3                           34-  38 (A)
 CPT4                           39-  43 (A)
 CPT5                           44-  48 (A)
 CPT6                           49-  53 (A)
 CPT7                           54-  58 (A)
 CPT8                           59-  63 (A)
 CPT9                           64-  68 (A)
 CPT10                          69-  73 (A)
 CPT11                          74-  78 (A)
 CPT12                          79-  83 (A)
 CPT13                          84-  88 (A)
 CPT14                          89-  93 (A)
 CPT15                          94-  98 (A)
 CPT16                          99- 103 (A)
 CPT17                         104- 108 (A)
 CPT18                         109- 113 (A)
 CPT19                         114- 118 (A)
 CPT20                         119- 123 (A)
 CPT21                         124- 128 (A)
 CPT22                         129- 133 (A)
 CPT23                         134- 138 (A)
 CPT24                         139- 143 (A)
 CPT25                         144- 148 (A)
 CPT26                         149- 153 (A)
 CPT27                         154- 158 (A)
 CPT28                         159- 163 (A)
 CPT29                         164- 168 (A)
 CPT30                         169- 173 (A)
 CPT31                         174- 178 (A)
 CPT32                         179- 183 (A)
 CPT33                         184- 188 (A)
 CPT34                         189- 193 (A)
 CPT35                         194- 198 (A)
 CPT36                         199- 203 (A)
 CPT37                         204- 208 (A)
 CPT38                         209- 213 (A)
 CPT39                         214- 218 (A)
 CPT40                         219- 223 (A)
 CPT41                         224- 228 (A)
 CPT42                         229- 233 (A)
 CPT43                         234- 238 (A)
 CPT44                         239- 243 (A)
 CPT45                         244- 248 (A)
 CPT46                         249- 253 (A)
 CPT47                         254- 258 (A)
 CPT48                         259- 263 (A)
 CPT49                         264- 268 (A)
 CPT50                         269- 273 (A)
 CPT51                         274- 278 (A)
 CPT52                         279- 283 (A)
 CPT53                         284- 288 (A)
 CPT54                         289- 293 (A)
 CPT55                         294- 298 (A)
 CPT56                         299- 303 (A)
 CPT57                         304- 308 (A)
 CPT58                         309- 313 (A)
 CPT59                         314- 318 (A)
 CPT60                         319- 323 (A)
 CPT61                         324- 328 (A)
 CPT62                         329- 333 (A)
 CPT63                         334- 338 (A)
 CPT64                         339- 343 (A)
 CPT65                         344- 348 (A)
 CPT66                         349- 353 (A)
 CPT67                         354- 358 (A)
 CPT68                         359- 363 (A)
 CPT69                         364- 368 (A)
 CPT70                         369- 373 (A)
 CPT71                         374- 378 (A)
 CPT72                         379- 383 (A)
 CPT73                         384- 388 (A)
 CPT74                         389- 393 (A)
 CPT75                         394- 398 (A)
 CPT76                         399- 403 (A)
 CPTCCS1                       404- 406
 CPTCCS2                       407- 409
 CPTCCS3                       410- 412
 CPTCCS4                       413- 415
 CPTCCS5                       416- 418
 CPTCCS6                       419- 421
 CPTCCS7                       422- 424
 CPTCCS8                       425- 427
 CPTCCS9                       428- 430
 CPTCCS10                      431- 433
 CPTCCS11                      434- 436
 CPTCCS12                      437- 439
 CPTCCS13                      440- 442
 CPTCCS14                      443- 445
 CPTCCS15                      446- 448
 CPTCCS16                      449- 451
 CPTCCS17                      452- 454
 CPTCCS18                      455- 457
 CPTCCS19                      458- 460
 CPTCCS20                      461- 463
 CPTCCS21                      464- 466
 CPTCCS22                      467- 469
 CPTCCS23                      470- 472
 CPTCCS24                      473- 475
 CPTCCS25                      476- 478
 CPTCCS26                      479- 481
 CPTCCS27                      482- 484
 CPTCCS28                      485- 487
 CPTCCS29                      488- 490
 CPTCCS30                      491- 493
 CPTCCS31                      494- 496
 CPTCCS32                      497- 499
 CPTCCS33                      500- 502
 CPTCCS34                      503- 505
 CPTCCS35                      506- 508
 CPTCCS36                      509- 511
 CPTCCS37                      512- 514
 CPTCCS38                      515- 517
 CPTCCS39                      518- 520
 CPTCCS40                      521- 523
 CPTCCS41                      524- 526
 CPTCCS42                      527- 529
 CPTCCS43                      530- 532
 CPTCCS44                      533- 535
 CPTCCS45                      536- 538
 CPTCCS46                      539- 541
 CPTCCS47                      542- 544
 CPTCCS48                      545- 547
 CPTCCS49                      548- 550
 CPTCCS50                      551- 553
 CPTCCS51                      554- 556
 CPTCCS52                      557- 559
 CPTCCS53                      560- 562
 CPTCCS54                      563- 565
 CPTCCS55                      566- 568
 CPTCCS56                      569- 571
 CPTCCS57                      572- 574
 CPTCCS58                      575- 577
 CPTCCS59                      578- 580
 CPTCCS60                      581- 583
 CPTCCS61                      584- 586
 CPTCCS62                      587- 589
 CPTCCS63                      590- 592
 CPTCCS64                      593- 595
 CPTCCS65                      596- 598
 CPTCCS66                      599- 601
 CPTCCS67                      602- 604
 CPTCCS68                      605- 607
 CPTCCS69                      608- 610
 CPTCCS70                      611- 613
 CPTCCS71                      614- 616
 CPTCCS72                      617- 619
 CPTCCS73                      620- 622
 CPTCCS74                      623- 625
 CPTCCS75                      626- 628
 CPTCCS76                      629- 631
 CPTDAY1                       632- 634
 CPTDAY2                       635- 637
 CPTDAY3                       638- 640
 CPTDAY4                       641- 643
 CPTDAY5                       644- 646
 CPTDAY6                       647- 649
 CPTDAY7                       650- 652
 DaysToEvent                   653- 658
 DHOUR                         659- 662
 DIED                          663- 664
 DISP_X                        665- 666 (A)
 DISPUB04                      667- 668
 DISPUNIFORM                   669- 670
 DMONTH                        671- 672
 DQTR                          673- 674
 DSHOSPID                      675- 691 (A)
 DURATION                      692- 697
 FEMALE                        698- 699
 HCUP_ED                       700- 701
 HCUP_OS                       702- 703
 HISPANIC                      704- 705
 HISPANIC_X                    706     (A)
 HOSPST                        707- 708 (A)
 I10_DX_Visit_Reason1          709- 715 (A)
 I10_DX1                       716- 722 (A)
 I10_DX2                       723- 729 (A)
 I10_DX3                       730- 736 (A)
 I10_DX4                       737- 743 (A)
 I10_DX5                       744- 750 (A)
 I10_DX6                       751- 757 (A)
 I10_DX7                       758- 764 (A)
 I10_DX8                       765- 771 (A)
 I10_DX9                       772- 778 (A)
 I10_DX10                      779- 785 (A)
 I10_DX11                      786- 792 (A)
 I10_DX12                      793- 799 (A)
 I10_DX13                      800- 806 (A)
 I10_DX14                      807- 813 (A)
 I10_DX15                      814- 820 (A)
 I10_DX16                      821- 827 (A)
 I10_DX17                      828- 834 (A)
 I10_DX18                      835- 841 (A)
 I10_DX19                      842- 848 (A)
 I10_DX20                      849- 855 (A)
 I10_DX21                      856- 862 (A)
 I10_DX22                      863- 869 (A)
 I10_DX23                      870- 876 (A)
 I10_DX24                      877- 883 (A)
 I10_DX25                      884- 890 (A)
 I10_DX26                      891- 897 (A)
 I10_DX27                      898- 904 (A)
 I10_DX28                      905- 911 (A)
 I10_DX29                      912- 918 (A)
 I10_DX30                      919- 925 (A)
 I10_DX31                      926- 932 (A)
 I10_NDX                       933- 935
 I10_NPR                       936- 938
 I10_PR1                       939- 945 (A)
 I10_PR2                       946- 952 (A)
 I10_PR3                       953- 959 (A)
 I10_PR4                       960- 966 (A)
 I10_PR5                       967- 973 (A)
 I10_PR6                       974- 980 (A)
 I10_PR7                       981- 987 (A)
 I10_PROCTYPE                  988- 990
 KEY                           991-1005
 LOS                          1006-1010
 LOS_X                        1011-1016
 MARITALSTATUS_X              1017     (A)
 MARITALSTATUSUB04            1018     (A)
 MDNUM1_R                     1019-1027
 MDNUM2_R                     1028-1036
 MDNUM3_R                     1037-1045
 MDNUM4_R                     1046-1054
 MEDINCSTQ                    1055-1056
 MRN_R                        1057-1065
 NCPT                         1066-1069
 OS_TIME                      1070-1080
 PAY1                         1081-1082
 PAY1_X                       1083     (A)
 PAY2                         1084-1085
 PAY2_X                       1086     (A)
 PAY3                         1087-1088
 PAY3_X                       1089     (A)
 PL_CBSA                      1090-1092
 PL_NCHS                      1093-1094
 PL_RUCC                      1095-1096
 PL_UIC                       1097-1098
 PL_UR_CAT4                   1099-1100
 PointOfOrigin_X              1101     (A)
 PointOfOriginUB04            1102     (A)
 PRDAY1                       1103-1107
 PRDAY2                       1108-1112
 PRDAY3                       1113-1117
 PRDAY4                       1118-1122
 PRDAY5                       1123-1127
 PRDAY6                       1128-1132
 PRDAY7                       1133-1137
 PSTATE                       1138-1139 (A)
 PSTCO                        1140-1144
 PSTCO2                       1145-1149
 RACE                         1150-1151
 RACE_X                       1152     (A)
 STATE_AS                     1153-1154
 STATE_ED                     1155-1156
 STATE_OS                     1157-1158
 TOTCHG                       1159-1168
 TOTCHG_X                     1169-1183
 VisitLink                    1184-1192
 YEAR                         1193-1196
 ZIP3                         1197-1199 (A)
 ZIPINC_QRTL                  1200-1202
 AYEAR                        1203-1206
 BMONTH                       1207-1208
 BYEAR                        1209-1212
 PRMONTH1                     1213-1214
 PRMONTH2                     1215-1216
 PRMONTH3                     1217-1218
 PRMONTH4                     1219-1220
 PRMONTH5                     1221-1222
 PRMONTH6                     1223-1224
 PRMONTH7                     1225-1226
 PRYEAR1                      1227-1230
 PRYEAR2                      1231-1234
 PRYEAR3                      1235-1238
 PRYEAR4                      1239-1242
 PRYEAR5                      1243-1246
 PRYEAR6                      1247-1250
 PRYEAR7                      1251-1254.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTCCS51                     (F4.0) /
 CPTCCS52                     (F4.0) /
 CPTCCS53                     (F4.0) /
 CPTCCS54                     (F4.0) /
 CPTCCS55                     (F4.0) /
 CPTCCS56                     (F4.0) /
 CPTCCS57                     (F4.0) /
 CPTCCS58                     (F4.0) /
 CPTCCS59                     (F4.0) /
 CPTCCS60                     (F4.0) /
 CPTCCS61                     (F4.0) /
 CPTCCS62                     (F4.0) /
 CPTCCS63                     (F4.0) /
 CPTCCS64                     (F4.0) /
 CPTCCS65                     (F4.0) /
 CPTCCS66                     (F4.0) /
 CPTCCS67                     (F4.0) /
 CPTCCS68                     (F4.0) /
 CPTCCS69                     (F4.0) /
 CPTCCS70                     (F4.0) /
 CPTCCS71                     (F4.0) /
 CPTCCS72                     (F4.0) /
 CPTCCS73                     (F4.0) /
 CPTCCS74                     (F4.0) /
 CPTCCS75                     (F4.0) /
 CPTCCS76                     (F4.0) /
 CPTDAY1                      (F4.0) /
 CPTDAY2                      (F4.0) /
 CPTDAY3                      (F4.0) /
 CPTDAY4                      (F4.0) /
 CPTDAY5                      (F4.0) /
 CPTDAY6                      (F4.0) /
 CPTDAY7                      (F4.0) /
 DaysToEvent                  (F8.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DURATION                     (F4.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MDNUM4_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 NCPT                         (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPT51                        "CPT/HCPCS procedure code 51"
 CPT52                        "CPT/HCPCS procedure code 52"
 CPT53                        "CPT/HCPCS procedure code 53"
 CPT54                        "CPT/HCPCS procedure code 54"
 CPT55                        "CPT/HCPCS procedure code 55"
 CPT56                        "CPT/HCPCS procedure code 56"
 CPT57                        "CPT/HCPCS procedure code 57"
 CPT58                        "CPT/HCPCS procedure code 58"
 CPT59                        "CPT/HCPCS procedure code 59"
 CPT60                        "CPT/HCPCS procedure code 60"
 CPT61                        "CPT/HCPCS procedure code 61"
 CPT62                        "CPT/HCPCS procedure code 62"
 CPT63                        "CPT/HCPCS procedure code 63"
 CPT64                        "CPT/HCPCS procedure code 64"
 CPT65                        "CPT/HCPCS procedure code 65"
 CPT66                        "CPT/HCPCS procedure code 66"
 CPT67                        "CPT/HCPCS procedure code 67"
 CPT68                        "CPT/HCPCS procedure code 68"
 CPT69                        "CPT/HCPCS procedure code 69"
 CPT70                        "CPT/HCPCS procedure code 70"
 CPT71                        "CPT/HCPCS procedure code 71"
 CPT72                        "CPT/HCPCS procedure code 72"
 CPT73                        "CPT/HCPCS procedure code 73"
 CPT74                        "CPT/HCPCS procedure code 74"
 CPT75                        "CPT/HCPCS procedure code 75"
 CPT76                        "CPT/HCPCS procedure code 76"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTCCS51                     "CCS: CPT 51"
 CPTCCS52                     "CCS: CPT 52"
 CPTCCS53                     "CCS: CPT 53"
 CPTCCS54                     "CCS: CPT 54"
 CPTCCS55                     "CCS: CPT 55"
 CPTCCS56                     "CCS: CPT 56"
 CPTCCS57                     "CCS: CPT 57"
 CPTCCS58                     "CCS: CPT 58"
 CPTCCS59                     "CCS: CPT 59"
 CPTCCS60                     "CCS: CPT 60"
 CPTCCS61                     "CCS: CPT 61"
 CPTCCS62                     "CCS: CPT 62"
 CPTCCS63                     "CCS: CPT 63"
 CPTCCS64                     "CCS: CPT 64"
 CPTCCS65                     "CCS: CPT 65"
 CPTCCS66                     "CCS: CPT 66"
 CPTCCS67                     "CCS: CPT 67"
 CPTCCS68                     "CCS: CPT 68"
 CPTCCS69                     "CCS: CPT 69"
 CPTCCS70                     "CCS: CPT 70"
 CPTCCS71                     "CCS: CPT 71"
 CPTCCS72                     "CCS: CPT 72"
 CPTCCS73                     "CCS: CPT 73"
 CPTCCS74                     "CCS: CPT 74"
 CPTCCS75                     "CCS: CPT 75"
 CPTCCS76                     "CCS: CPT 76"
 CPTDAY1                      "Number of days from admission to CPT1"
 CPTDAY2                      "Number of days from admission to CPT2"
 CPTDAY3                      "Number of days from admission to CPT3"
 CPTDAY4                      "Number of days from admission to CPT4"
 CPTDAY5                      "Number of days from admission to CPT5"
 CPTDAY6                      "Number of days from admission to CPT6"
 CPTDAY7                      "Number of days from admission to CPT7"
 DaysToEvent                  "Days from 'start date' to admission"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DSHOSPID                     "Data source hospital identifier"
 DURATION                     "Elapsed time for hospital care in hours and minutes"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPST                       "Hospital state postal code"
 I10_DX_Visit_Reason1         "ICD-10-CM Reason for visit diagnosis 1"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MARITALSTATUS_X              "Patient's marital status (as received from source)"
 MARITALSTATUSUB04            "Patient's marital status, UB-04 standard coding"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MDNUM4_R                     "Physician 4 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes (RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS53
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS54
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS55
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS56
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS57
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS58
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS59
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS60
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS61
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS62
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS63
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS64
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS65
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS66
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS67
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS68
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS69
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS70
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS71
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS72
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS73
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS74
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS75
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS76
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DURATION
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM4_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'AR_SEDD_2018_CORE.SAV' /COMPRESSED.
