/*******************************************************************
* Creation Date: 07/06/2022   
*   AK_SEDD_2020_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'AK_SEDD_2020_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEMONTH                        4-   6
 AHOUR                           7-  10
 AMONTH                         11-  12
 ATYPE                          13-  14
 AWEEKEND                       15-  16
 BILLTYPE                       17-  20 (A)
 CPT1                           21-  25 (A)
 CPT2                           26-  30 (A)
 CPT3                           31-  35 (A)
 CPT4                           36-  40 (A)
 CPT5                           41-  45 (A)
 CPT6                           46-  50 (A)
 CPT7                           51-  55 (A)
 CPT8                           56-  60 (A)
 CPT9                           61-  65 (A)
 CPT10                          66-  70 (A)
 CPT11                          71-  75 (A)
 CPT12                          76-  80 (A)
 CPT13                          81-  85 (A)
 CPT14                          86-  90 (A)
 CPT15                          91-  95 (A)
 CPT16                          96- 100 (A)
 CPT17                         101- 105 (A)
 CPT18                         106- 110 (A)
 CPT19                         111- 115 (A)
 CPT20                         116- 120 (A)
 CPT21                         121- 125 (A)
 CPT22                         126- 130 (A)
 CPT23                         131- 135 (A)
 CPT24                         136- 140 (A)
 CPT25                         141- 145 (A)
 CPT26                         146- 150 (A)
 CPT27                         151- 155 (A)
 CPT28                         156- 160 (A)
 CPT29                         161- 165 (A)
 CPT30                         166- 170 (A)
 CPT31                         171- 175 (A)
 CPT32                         176- 180 (A)
 CPT33                         181- 185 (A)
 CPT34                         186- 190 (A)
 CPT35                         191- 195 (A)
 CPT36                         196- 200 (A)
 CPT37                         201- 205 (A)
 CPT38                         206- 210 (A)
 CPT39                         211- 215 (A)
 CPT40                         216- 220 (A)
 CPT41                         221- 225 (A)
 CPT42                         226- 230 (A)
 CPT43                         231- 235 (A)
 CPT44                         236- 240 (A)
 CPT45                         241- 245 (A)
 CPT46                         246- 250 (A)
 CPT47                         251- 255 (A)
 CPT48                         256- 260 (A)
 CPT49                         261- 265 (A)
 CPT50                         266- 270 (A)
 CPT51                         271- 275 (A)
 CPT52                         276- 280 (A)
 CPT53                         281- 285 (A)
 CPT54                         286- 290 (A)
 CPT55                         291- 295 (A)
 CPT56                         296- 300 (A)
 CPT57                         301- 305 (A)
 CPT58                         306- 310 (A)
 CPT59                         311- 315 (A)
 CPT60                         316- 320 (A)
 CPT61                         321- 325 (A)
 CPT62                         326- 330 (A)
 CPT63                         331- 335 (A)
 CPT64                         336- 340 (A)
 CPT65                         341- 345 (A)
 CPT66                         346- 350 (A)
 CPT67                         351- 355 (A)
 CPT68                         356- 360 (A)
 CPT69                         361- 365 (A)
 CPT70                         366- 370 (A)
 CPT71                         371- 375 (A)
 CPT72                         376- 380 (A)
 CPT73                         381- 385 (A)
 CPT74                         386- 390 (A)
 CPT75                         391- 395 (A)
 CPT76                         396- 400 (A)
 CPT77                         401- 405 (A)
 CPT78                         406- 410 (A)
 CPT79                         411- 415 (A)
 CPT80                         416- 420 (A)
 CPT81                         421- 425 (A)
 CPT82                         426- 430 (A)
 CPT83                         431- 435 (A)
 CPT84                         436- 440 (A)
 CPT85                         441- 445 (A)
 CPT86                         446- 450 (A)
 CPT87                         451- 455 (A)
 CPT88                         456- 460 (A)
 CPT89                         461- 465 (A)
 CPT90                         466- 470 (A)
 CPT91                         471- 475 (A)
 CPT92                         476- 480 (A)
 CPT93                         481- 485 (A)
 CPT94                         486- 490 (A)
 CPT95                         491- 495 (A)
 CPT96                         496- 500 (A)
 CPT97                         501- 505 (A)
 CPT98                         506- 510 (A)
 CPT99                         511- 515 (A)
 CPT100                        516- 520 (A)
 CPT101                        521- 525 (A)
 CPT102                        526- 530 (A)
 CPT103                        531- 535 (A)
 CPT104                        536- 540 (A)
 CPT105                        541- 545 (A)
 CPT106                        546- 550 (A)
 CPT107                        551- 555 (A)
 CPT108                        556- 560 (A)
 CPT109                        561- 565 (A)
 CPT110                        566- 570 (A)
 CPT111                        571- 575 (A)
 CPT112                        576- 580 (A)
 CPT113                        581- 585 (A)
 CPT114                        586- 590 (A)
 CPT115                        591- 595 (A)
 CPT116                        596- 600 (A)
 CPT117                        601- 605 (A)
 CPT118                        606- 610 (A)
 CPT119                        611- 615 (A)
 CPT120                        616- 620 (A)
 CPTCCS1                       621- 623
 CPTCCS2                       624- 626
 CPTCCS3                       627- 629
 CPTCCS4                       630- 632
 CPTCCS5                       633- 635
 CPTCCS6                       636- 638
 CPTCCS7                       639- 641
 CPTCCS8                       642- 644
 CPTCCS9                       645- 647
 CPTCCS10                      648- 650
 CPTCCS11                      651- 653
 CPTCCS12                      654- 656
 CPTCCS13                      657- 659
 CPTCCS14                      660- 662
 CPTCCS15                      663- 665
 CPTCCS16                      666- 668
 CPTCCS17                      669- 671
 CPTCCS18                      672- 674
 CPTCCS19                      675- 677
 CPTCCS20                      678- 680
 CPTCCS21                      681- 683
 CPTCCS22                      684- 686
 CPTCCS23                      687- 689
 CPTCCS24                      690- 692
 CPTCCS25                      693- 695
 CPTCCS26                      696- 698
 CPTCCS27                      699- 701
 CPTCCS28                      702- 704
 CPTCCS29                      705- 707
 CPTCCS30                      708- 710
 CPTCCS31                      711- 713
 CPTCCS32                      714- 716
 CPTCCS33                      717- 719
 CPTCCS34                      720- 722
 CPTCCS35                      723- 725
 CPTCCS36                      726- 728
 CPTCCS37                      729- 731
 CPTCCS38                      732- 734
 CPTCCS39                      735- 737
 CPTCCS40                      738- 740
 CPTCCS41                      741- 743
 CPTCCS42                      744- 746
 CPTCCS43                      747- 749
 CPTCCS44                      750- 752
 CPTCCS45                      753- 755
 CPTCCS46                      756- 758
 CPTCCS47                      759- 761
 CPTCCS48                      762- 764
 CPTCCS49                      765- 767
 CPTCCS50                      768- 770
 CPTCCS51                      771- 773
 CPTCCS52                      774- 776
 CPTCCS53                      777- 779
 CPTCCS54                      780- 782
 CPTCCS55                      783- 785
 CPTCCS56                      786- 788
 CPTCCS57                      789- 791
 CPTCCS58                      792- 794
 CPTCCS59                      795- 797
 CPTCCS60                      798- 800
 CPTCCS61                      801- 803
 CPTCCS62                      804- 806
 CPTCCS63                      807- 809
 CPTCCS64                      810- 812
 CPTCCS65                      813- 815
 CPTCCS66                      816- 818
 CPTCCS67                      819- 821
 CPTCCS68                      822- 824
 CPTCCS69                      825- 827
 CPTCCS70                      828- 830
 CPTCCS71                      831- 833
 CPTCCS72                      834- 836
 CPTCCS73                      837- 839
 CPTCCS74                      840- 842
 CPTCCS75                      843- 845
 CPTCCS76                      846- 848
 CPTCCS77                      849- 851
 CPTCCS78                      852- 854
 CPTCCS79                      855- 857
 CPTCCS80                      858- 860
 CPTCCS81                      861- 863
 CPTCCS82                      864- 866
 CPTCCS83                      867- 869
 CPTCCS84                      870- 872
 CPTCCS85                      873- 875
 CPTCCS86                      876- 878
 CPTCCS87                      879- 881
 CPTCCS88                      882- 884
 CPTCCS89                      885- 887
 CPTCCS90                      888- 890
 CPTCCS91                      891- 893
 CPTCCS92                      894- 896
 CPTCCS93                      897- 899
 CPTCCS94                      900- 902
 CPTCCS95                      903- 905
 CPTCCS96                      906- 908
 CPTCCS97                      909- 911
 CPTCCS98                      912- 914
 CPTCCS99                      915- 917
 CPTCCS100                     918- 920
 CPTCCS101                     921- 923
 CPTCCS102                     924- 926
 CPTCCS103                     927- 929
 CPTCCS104                     930- 932
 CPTCCS105                     933- 935
 CPTCCS106                     936- 938
 CPTCCS107                     939- 941
 CPTCCS108                     942- 944
 CPTCCS109                     945- 947
 CPTCCS110                     948- 950
 CPTCCS111                     951- 953
 CPTCCS112                     954- 956
 CPTCCS113                     957- 959
 CPTCCS114                     960- 962
 CPTCCS115                     963- 965
 CPTCCS116                     966- 968
 CPTCCS117                     969- 971
 CPTCCS118                     972- 974
 CPTCCS119                     975- 977
 CPTCCS120                     978- 980
 CPTDAY1                       981- 983
 CPTDAY2                       984- 986
 CPTDAY3                       987- 989
 CPTDAY4                       990- 992
 CPTDAY5                       993- 995
 CPTDAY6                       996- 998
 CPTDAY7                       999-1001
 CPTDAY8                      1002-1004
 CPTDAY9                      1005-1007
 CPTDAY10                     1008-1010
 CPTDAY11                     1011-1013
 CPTDAY12                     1014-1016
 CPTDAY13                     1017-1019
 CPTDAY14                     1020-1022
 CPTDAY15                     1023-1025
 CPTDAY16                     1026-1028
 CPTDAY17                     1029-1031
 CPTDAY18                     1032-1034
 CPTDAY19                     1035-1037
 CPTDAY20                     1038-1040
 CPTDAY21                     1041-1043
 CPTDAY22                     1044-1046
 CPTDAY23                     1047-1049
 CPTDAY24                     1050-1052
 CPTDAY25                     1053-1055
 CPTDAY26                     1056-1058
 CPTDAY27                     1059-1061
 CPTDAY28                     1062-1064
 CPTDAY29                     1065-1067
 CPTDAY30                     1068-1070
 CPTDAY31                     1071-1073
 CPTDAY32                     1074-1076
 CPTDAY33                     1077-1079
 CPTDAY34                     1080-1082
 CPTDAY35                     1083-1085
 CPTDAY36                     1086-1088
 CPTDAY37                     1089-1091
 CPTDAY38                     1092-1094
 CPTDAY39                     1095-1097
 CPTDAY40                     1098-1100
 CPTDAY41                     1101-1103
 CPTDAY42                     1104-1106
 CPTDAY43                     1107-1109
 CPTDAY44                     1110-1112
 CPTDAY45                     1113-1115
 CPTDAY46                     1116-1118
 CPTDAY47                     1119-1121
 CPTDAY48                     1122-1124
 CPTDAY49                     1125-1127
 CPTDAY50                     1128-1130
 CPTDAY51                     1131-1133
 CPTDAY52                     1134-1136
 CPTDAY53                     1137-1139
 CPTDAY54                     1140-1142
 CPTDAY55                     1143-1145
 CPTDAY56                     1146-1148
 CPTDAY57                     1149-1151
 CPTDAY58                     1152-1154
 CPTDAY59                     1155-1157
 CPTDAY60                     1158-1160
 CPTDAY61                     1161-1163
 CPTDAY62                     1164-1166
 CPTDAY63                     1167-1169
 CPTDAY64                     1170-1172
 CPTDAY65                     1173-1175
 CPTDAY66                     1176-1178
 CPTDAY67                     1179-1181
 CPTDAY68                     1182-1184
 CPTDAY69                     1185-1187
 CPTDAY70                     1188-1190
 CPTDAY71                     1191-1193
 CPTDAY72                     1194-1196
 CPTDAY73                     1197-1199
 CPTDAY74                     1200-1202
 CPTDAY75                     1203-1205
 CPTDAY76                     1206-1208
 CPTDAY77                     1209-1211
 CPTDAY78                     1212-1214
 CPTDAY79                     1215-1217
 CPTDAY80                     1218-1220
 CPTDAY81                     1221-1223
 CPTDAY82                     1224-1226
 CPTDAY83                     1227-1229
 CPTDAY84                     1230-1232
 CPTDAY85                     1233-1235
 CPTDAY86                     1236-1238
 CPTDAY87                     1239-1241
 CPTDAY88                     1242-1244
 CPTDAY89                     1245-1247
 CPTDAY90                     1248-1250
 CPTDAY91                     1251-1253
 CPTDAY92                     1254-1256
 CPTDAY93                     1257-1259
 CPTDAY94                     1260-1262
 CPTDAY95                     1263-1265
 CPTDAY96                     1266-1268
 CPTDAY97                     1269-1271
 CPTDAY98                     1272-1274
 CPTDAY99                     1275-1277
 CPTDAY100                    1278-1280
 CPTDAY101                    1281-1283
 CPTDAY102                    1284-1286
 CPTDAY103                    1287-1289
 CPTDAY104                    1290-1292
 CPTDAY105                    1293-1295
 CPTDAY106                    1296-1298
 CPTDAY107                    1299-1301
 CPTDAY108                    1302-1304
 CPTDAY109                    1305-1307
 CPTDAY110                    1308-1310
 CPTDAY111                    1311-1313
 CPTDAY112                    1314-1316
 CPTDAY113                    1317-1319
 CPTDAY114                    1320-1322
 CPTDAY115                    1323-1325
 CPTDAY116                    1326-1328
 CPTDAY117                    1329-1331
 CPTDAY118                    1332-1334
 CPTDAY119                    1335-1337
 CPTDAY120                    1338-1340
 DaysToEvent                  1341-1346
 DHOUR                        1347-1350
 DIED                         1351-1352
 DISP_X                       1353-1354 (A)
 DISPUB04                     1355-1356
 DISPUNIFORM                  1357-1358
 DMONTH                       1359-1360
 DQTR                         1361-1362
 DURATION                     1363-1368
 DXPOA1                       1369     (A)
 DXPOA2                       1370     (A)
 DXPOA3                       1371     (A)
 DXPOA4                       1372     (A)
 DXPOA5                       1373     (A)
 DXPOA6                       1374     (A)
 DXPOA7                       1375     (A)
 DXPOA8                       1376     (A)
 DXPOA9                       1377     (A)
 DXPOA10                      1378     (A)
 DXPOA11                      1379     (A)
 DXPOA12                      1380     (A)
 DXPOA13                      1381     (A)
 DXPOA14                      1382     (A)
 DXPOA15                      1383     (A)
 DXPOA16                      1384     (A)
 DXPOA17                      1385     (A)
 DXPOA18                      1386     (A)
 DXPOA19                      1387     (A)
 DXPOA20                      1388     (A)
 DXPOA21                      1389     (A)
 DXPOA22                      1390     (A)
 DXPOA23                      1391     (A)
 DXPOA24                      1392     (A)
 DXPOA25                      1393     (A)
 DXPOA26                      1394     (A)
 DXPOA27                      1395     (A)
 DXPOA28                      1396     (A)
 DXPOA29                      1397     (A)
 DXPOA30                      1398     (A)
 FEMALE                       1399-1400
 HCUP_ED                      1401-1402
 HCUP_OS                      1403-1404
 HCUP_SURGERY_BROAD_CPT       1405-1409
 HCUP_SURGERY_NARROW_CPT      1410-1414
 HISPANIC                     1415-1416
 HISPANIC_X                   1417     (A)
 HOSPST                       1418-1419 (A)
 I10_DX_Visit_Reason1         1420-1426 (A)
 I10_DX_Visit_Reason2         1427-1433 (A)
 I10_DX_Visit_Reason3         1434-1440 (A)
 I10_DX1                      1441-1447 (A)
 I10_DX2                      1448-1454 (A)
 I10_DX3                      1455-1461 (A)
 I10_DX4                      1462-1468 (A)
 I10_DX5                      1469-1475 (A)
 I10_DX6                      1476-1482 (A)
 I10_DX7                      1483-1489 (A)
 I10_DX8                      1490-1496 (A)
 I10_DX9                      1497-1503 (A)
 I10_DX10                     1504-1510 (A)
 I10_DX11                     1511-1517 (A)
 I10_DX12                     1518-1524 (A)
 I10_DX13                     1525-1531 (A)
 I10_DX14                     1532-1538 (A)
 I10_DX15                     1539-1545 (A)
 I10_DX16                     1546-1552 (A)
 I10_DX17                     1553-1559 (A)
 I10_DX18                     1560-1566 (A)
 I10_DX19                     1567-1573 (A)
 I10_DX20                     1574-1580 (A)
 I10_DX21                     1581-1587 (A)
 I10_DX22                     1588-1594 (A)
 I10_DX23                     1595-1601 (A)
 I10_DX24                     1602-1608 (A)
 I10_DX25                     1609-1615 (A)
 I10_DX26                     1616-1622 (A)
 I10_DX27                     1623-1629 (A)
 I10_DX28                     1630-1636 (A)
 I10_DX29                     1637-1643 (A)
 I10_DX30                     1644-1650 (A)
 I10_NDX                      1651-1653
 I10_NPR                      1654-1656
 I10_PR1                      1657-1663 (A)
 I10_PR2                      1664-1670 (A)
 I10_PR3                      1671-1677 (A)
 I10_PR4                      1678-1684 (A)
 I10_PR5                      1685-1691 (A)
 I10_PR6                      1692-1698 (A)
 I10_PR7                      1699-1705 (A)
 I10_PR8                      1706-1712 (A)
 I10_PR9                      1713-1719 (A)
 I10_PR10                     1720-1726 (A)
 I10_PROCTYPE                 1727-1729
 KEY                          1730-1744
 LOS                          1745-1749
 LOS_X                        1750-1755
 MEDINCSTQ                    1756-1757
 NCPT                         1758-1761
 OBSERVATION                  1762-1765
 OPservice                    1766     (A)
 OS_TIME                      1767-1777
 PAY1                         1778-1779
 PAY1_X                       1780-1781 (A)
 PAY2                         1782-1783
 PAY2_X                       1784-1785 (A)
 PAY3                         1786-1787
 PAY3_X                       1788-1789 (A)
 PL_CBSA                      1790-1792
 PL_NCHS                      1793-1794
 POA_Disch_Edit1              1795-1796
 POA_Disch_Edit2              1797-1798
 POA_Hosp_Edit1               1799-1800
 POA_Hosp_Edit2               1801-1802
 POA_Hosp_Edit3               1803-1804
 POA_Hosp_Edit3_Value         1805-1812
 PointOfOrigin_X              1813     (A)
 PointOfOriginUB04            1814     (A)
 PRDAY1                       1815-1819
 PRDAY2                       1820-1824
 PRDAY3                       1825-1829
 PRDAY4                       1830-1834
 PRDAY5                       1835-1839
 PRDAY6                       1840-1844
 PRDAY7                       1845-1849
 PRDAY8                       1850-1854
 PRDAY9                       1855-1859
 PRDAY10                      1860-1864
 PSTATE                       1865-1866 (A)
 PSTATE_GEO                   1867-1868 (A)
 RACE                         1869-1870
 RACE_X                       1871     (A)
 STATE_AS                     1872-1873
 STATE_ED                     1874-1875
 STATE_OS                     1876-1877
 TOTCHG                       1878-1887
 TOTCHG_X                     1888-1902
 VisitLink                    1903-1911
 YEAR                         1912-1915
 ZIPINC_QRTL                  1916-1918
 HOSPID                       1919-1923
 AYEAR                        1924-1927
 BMONTH                       1928-1929
 BYEAR                        1930-1933
 PRMONTH1                     1934-1935
 PRMONTH2                     1936-1937
 PRMONTH3                     1938-1939
 PRMONTH4                     1940-1941
 PRMONTH5                     1942-1943
 PRMONTH6                     1944-1945
 PRMONTH7                     1946-1947
 PRMONTH8                     1948-1949
 PRMONTH9                     1950-1951
 PRMONTH10                    1952-1953
 PRYEAR1                      1954-1957
 PRYEAR2                      1958-1961
 PRYEAR3                      1962-1965
 PRYEAR4                      1966-1969
 PRYEAR5                      1970-1973
 PRYEAR6                      1974-1977
 PRYEAR7                      1978-1981
 PRYEAR8                      1982-1985
 PRYEAR9                      1986-1989
 PRYEAR10                     1990-1993.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTCCS51                     (F4.0) /
 CPTCCS52                     (F4.0) /
 CPTCCS53                     (F4.0) /
 CPTCCS54                     (F4.0) /
 CPTCCS55                     (F4.0) /
 CPTCCS56                     (F4.0) /
 CPTCCS57                     (F4.0) /
 CPTCCS58                     (F4.0) /
 CPTCCS59                     (F4.0) /
 CPTCCS60                     (F4.0) /
 CPTCCS61                     (F4.0) /
 CPTCCS62                     (F4.0) /
 CPTCCS63                     (F4.0) /
 CPTCCS64                     (F4.0) /
 CPTCCS65                     (F4.0) /
 CPTCCS66                     (F4.0) /
 CPTCCS67                     (F4.0) /
 CPTCCS68                     (F4.0) /
 CPTCCS69                     (F4.0) /
 CPTCCS70                     (F4.0) /
 CPTCCS71                     (F4.0) /
 CPTCCS72                     (F4.0) /
 CPTCCS73                     (F4.0) /
 CPTCCS74                     (F4.0) /
 CPTCCS75                     (F4.0) /
 CPTCCS76                     (F4.0) /
 CPTCCS77                     (F4.0) /
 CPTCCS78                     (F4.0) /
 CPTCCS79                     (F4.0) /
 CPTCCS80                     (F4.0) /
 CPTCCS81                     (F4.0) /
 CPTCCS82                     (F4.0) /
 CPTCCS83                     (F4.0) /
 CPTCCS84                     (F4.0) /
 CPTCCS85                     (F4.0) /
 CPTCCS86                     (F4.0) /
 CPTCCS87                     (F4.0) /
 CPTCCS88                     (F4.0) /
 CPTCCS89                     (F4.0) /
 CPTCCS90                     (F4.0) /
 CPTCCS91                     (F4.0) /
 CPTCCS92                     (F4.0) /
 CPTCCS93                     (F4.0) /
 CPTCCS94                     (F4.0) /
 CPTCCS95                     (F4.0) /
 CPTCCS96                     (F4.0) /
 CPTCCS97                     (F4.0) /
 CPTCCS98                     (F4.0) /
 CPTCCS99                     (F4.0) /
 CPTCCS100                    (F4.0) /
 CPTCCS101                    (F4.0) /
 CPTCCS102                    (F4.0) /
 CPTCCS103                    (F4.0) /
 CPTCCS104                    (F4.0) /
 CPTCCS105                    (F4.0) /
 CPTCCS106                    (F4.0) /
 CPTCCS107                    (F4.0) /
 CPTCCS108                    (F4.0) /
 CPTCCS109                    (F4.0) /
 CPTCCS110                    (F4.0) /
 CPTCCS111                    (F4.0) /
 CPTCCS112                    (F4.0) /
 CPTCCS113                    (F4.0) /
 CPTCCS114                    (F4.0) /
 CPTCCS115                    (F4.0) /
 CPTCCS116                    (F4.0) /
 CPTCCS117                    (F4.0) /
 CPTCCS118                    (F4.0) /
 CPTCCS119                    (F4.0) /
 CPTCCS120                    (F4.0) /
 CPTDAY1                      (F4.0) /
 CPTDAY2                      (F4.0) /
 CPTDAY3                      (F4.0) /
 CPTDAY4                      (F4.0) /
 CPTDAY5                      (F4.0) /
 CPTDAY6                      (F4.0) /
 CPTDAY7                      (F4.0) /
 CPTDAY8                      (F4.0) /
 CPTDAY9                      (F4.0) /
 CPTDAY10                     (F4.0) /
 CPTDAY11                     (F4.0) /
 CPTDAY12                     (F4.0) /
 CPTDAY13                     (F4.0) /
 CPTDAY14                     (F4.0) /
 CPTDAY15                     (F4.0) /
 CPTDAY16                     (F4.0) /
 CPTDAY17                     (F4.0) /
 CPTDAY18                     (F4.0) /
 CPTDAY19                     (F4.0) /
 CPTDAY20                     (F4.0) /
 CPTDAY21                     (F4.0) /
 CPTDAY22                     (F4.0) /
 CPTDAY23                     (F4.0) /
 CPTDAY24                     (F4.0) /
 CPTDAY25                     (F4.0) /
 CPTDAY26                     (F4.0) /
 CPTDAY27                     (F4.0) /
 CPTDAY28                     (F4.0) /
 CPTDAY29                     (F4.0) /
 CPTDAY30                     (F4.0) /
 CPTDAY31                     (F4.0) /
 CPTDAY32                     (F4.0) /
 CPTDAY33                     (F4.0) /
 CPTDAY34                     (F4.0) /
 CPTDAY35                     (F4.0) /
 CPTDAY36                     (F4.0) /
 CPTDAY37                     (F4.0) /
 CPTDAY38                     (F4.0) /
 CPTDAY39                     (F4.0) /
 CPTDAY40                     (F4.0) /
 CPTDAY41                     (F4.0) /
 CPTDAY42                     (F4.0) /
 CPTDAY43                     (F4.0) /
 CPTDAY44                     (F4.0) /
 CPTDAY45                     (F4.0) /
 CPTDAY46                     (F4.0) /
 CPTDAY47                     (F4.0) /
 CPTDAY48                     (F4.0) /
 CPTDAY49                     (F4.0) /
 CPTDAY50                     (F4.0) /
 CPTDAY51                     (F4.0) /
 CPTDAY52                     (F4.0) /
 CPTDAY53                     (F4.0) /
 CPTDAY54                     (F4.0) /
 CPTDAY55                     (F4.0) /
 CPTDAY56                     (F4.0) /
 CPTDAY57                     (F4.0) /
 CPTDAY58                     (F4.0) /
 CPTDAY59                     (F4.0) /
 CPTDAY60                     (F4.0) /
 CPTDAY61                     (F4.0) /
 CPTDAY62                     (F4.0) /
 CPTDAY63                     (F4.0) /
 CPTDAY64                     (F4.0) /
 CPTDAY65                     (F4.0) /
 CPTDAY66                     (F4.0) /
 CPTDAY67                     (F4.0) /
 CPTDAY68                     (F4.0) /
 CPTDAY69                     (F4.0) /
 CPTDAY70                     (F4.0) /
 CPTDAY71                     (F4.0) /
 CPTDAY72                     (F4.0) /
 CPTDAY73                     (F4.0) /
 CPTDAY74                     (F4.0) /
 CPTDAY75                     (F4.0) /
 CPTDAY76                     (F4.0) /
 CPTDAY77                     (F4.0) /
 CPTDAY78                     (F4.0) /
 CPTDAY79                     (F4.0) /
 CPTDAY80                     (F4.0) /
 CPTDAY81                     (F4.0) /
 CPTDAY82                     (F4.0) /
 CPTDAY83                     (F4.0) /
 CPTDAY84                     (F4.0) /
 CPTDAY85                     (F4.0) /
 CPTDAY86                     (F4.0) /
 CPTDAY87                     (F4.0) /
 CPTDAY88                     (F4.0) /
 CPTDAY89                     (F4.0) /
 CPTDAY90                     (F4.0) /
 CPTDAY91                     (F4.0) /
 CPTDAY92                     (F4.0) /
 CPTDAY93                     (F4.0) /
 CPTDAY94                     (F4.0) /
 CPTDAY95                     (F4.0) /
 CPTDAY96                     (F4.0) /
 CPTDAY97                     (F4.0) /
 CPTDAY98                     (F4.0) /
 CPTDAY99                     (F4.0) /
 CPTDAY100                    (F4.0) /
 CPTDAY101                    (F4.0) /
 CPTDAY102                    (F4.0) /
 CPTDAY103                    (F4.0) /
 CPTDAY104                    (F4.0) /
 CPTDAY105                    (F4.0) /
 CPTDAY106                    (F4.0) /
 CPTDAY107                    (F4.0) /
 CPTDAY108                    (F4.0) /
 CPTDAY109                    (F4.0) /
 CPTDAY110                    (F4.0) /
 CPTDAY111                    (F4.0) /
 CPTDAY112                    (F4.0) /
 CPTDAY113                    (F4.0) /
 CPTDAY114                    (F4.0) /
 CPTDAY115                    (F4.0) /
 CPTDAY116                    (F4.0) /
 CPTDAY117                    (F4.0) /
 CPTDAY118                    (F4.0) /
 CPTDAY119                    (F4.0) /
 CPTDAY120                    (F4.0) /
 DaysToEvent                  (F8.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DURATION                     (F4.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HCUP_SURGERY_BROAD_CPT       (F3.0) /
 HCUP_SURGERY_NARROW_CPT      (F3.0) /
 HISPANIC                     (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MEDINCSTQ                    (F3.0) /
 NCPT                         (F3.0) /
 OBSERVATION                  (F4.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 RACE                         (F3.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPT51                        "CPT/HCPCS procedure code 51"
 CPT52                        "CPT/HCPCS procedure code 52"
 CPT53                        "CPT/HCPCS procedure code 53"
 CPT54                        "CPT/HCPCS procedure code 54"
 CPT55                        "CPT/HCPCS procedure code 55"
 CPT56                        "CPT/HCPCS procedure code 56"
 CPT57                        "CPT/HCPCS procedure code 57"
 CPT58                        "CPT/HCPCS procedure code 58"
 CPT59                        "CPT/HCPCS procedure code 59"
 CPT60                        "CPT/HCPCS procedure code 60"
 CPT61                        "CPT/HCPCS procedure code 61"
 CPT62                        "CPT/HCPCS procedure code 62"
 CPT63                        "CPT/HCPCS procedure code 63"
 CPT64                        "CPT/HCPCS procedure code 64"
 CPT65                        "CPT/HCPCS procedure code 65"
 CPT66                        "CPT/HCPCS procedure code 66"
 CPT67                        "CPT/HCPCS procedure code 67"
 CPT68                        "CPT/HCPCS procedure code 68"
 CPT69                        "CPT/HCPCS procedure code 69"
 CPT70                        "CPT/HCPCS procedure code 70"
 CPT71                        "CPT/HCPCS procedure code 71"
 CPT72                        "CPT/HCPCS procedure code 72"
 CPT73                        "CPT/HCPCS procedure code 73"
 CPT74                        "CPT/HCPCS procedure code 74"
 CPT75                        "CPT/HCPCS procedure code 75"
 CPT76                        "CPT/HCPCS procedure code 76"
 CPT77                        "CPT/HCPCS procedure code 77"
 CPT78                        "CPT/HCPCS procedure code 78"
 CPT79                        "CPT/HCPCS procedure code 79"
 CPT80                        "CPT/HCPCS procedure code 80"
 CPT81                        "CPT/HCPCS procedure code 81"
 CPT82                        "CPT/HCPCS procedure code 82"
 CPT83                        "CPT/HCPCS procedure code 83"
 CPT84                        "CPT/HCPCS procedure code 84"
 CPT85                        "CPT/HCPCS procedure code 85"
 CPT86                        "CPT/HCPCS procedure code 86"
 CPT87                        "CPT/HCPCS procedure code 87"
 CPT88                        "CPT/HCPCS procedure code 88"
 CPT89                        "CPT/HCPCS procedure code 89"
 CPT90                        "CPT/HCPCS procedure code 90"
 CPT91                        "CPT/HCPCS procedure code 91"
 CPT92                        "CPT/HCPCS procedure code 92"
 CPT93                        "CPT/HCPCS procedure code 93"
 CPT94                        "CPT/HCPCS procedure code 94"
 CPT95                        "CPT/HCPCS procedure code 95"
 CPT96                        "CPT/HCPCS procedure code 96"
 CPT97                        "CPT/HCPCS procedure code 97"
 CPT98                        "CPT/HCPCS procedure code 98"
 CPT99                        "CPT/HCPCS procedure code 99"
 CPT100                       "CPT/HCPCS procedure code 100"
 CPT101                       "CPT/HCPCS procedure code 101"
 CPT102                       "CPT/HCPCS procedure code 102"
 CPT103                       "CPT/HCPCS procedure code 103"
 CPT104                       "CPT/HCPCS procedure code 104"
 CPT105                       "CPT/HCPCS procedure code 105"
 CPT106                       "CPT/HCPCS procedure code 106"
 CPT107                       "CPT/HCPCS procedure code 107"
 CPT108                       "CPT/HCPCS procedure code 108"
 CPT109                       "CPT/HCPCS procedure code 109"
 CPT110                       "CPT/HCPCS procedure code 110"
 CPT111                       "CPT/HCPCS procedure code 111"
 CPT112                       "CPT/HCPCS procedure code 112"
 CPT113                       "CPT/HCPCS procedure code 113"
 CPT114                       "CPT/HCPCS procedure code 114"
 CPT115                       "CPT/HCPCS procedure code 115"
 CPT116                       "CPT/HCPCS procedure code 116"
 CPT117                       "CPT/HCPCS procedure code 117"
 CPT118                       "CPT/HCPCS procedure code 118"
 CPT119                       "CPT/HCPCS procedure code 119"
 CPT120                       "CPT/HCPCS procedure code 120"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTCCS51                     "CCS: CPT 51"
 CPTCCS52                     "CCS: CPT 52"
 CPTCCS53                     "CCS: CPT 53"
 CPTCCS54                     "CCS: CPT 54"
 CPTCCS55                     "CCS: CPT 55"
 CPTCCS56                     "CCS: CPT 56"
 CPTCCS57                     "CCS: CPT 57"
 CPTCCS58                     "CCS: CPT 58"
 CPTCCS59                     "CCS: CPT 59"
 CPTCCS60                     "CCS: CPT 60"
 CPTCCS61                     "CCS: CPT 61"
 CPTCCS62                     "CCS: CPT 62"
 CPTCCS63                     "CCS: CPT 63"
 CPTCCS64                     "CCS: CPT 64"
 CPTCCS65                     "CCS: CPT 65"
 CPTCCS66                     "CCS: CPT 66"
 CPTCCS67                     "CCS: CPT 67"
 CPTCCS68                     "CCS: CPT 68"
 CPTCCS69                     "CCS: CPT 69"
 CPTCCS70                     "CCS: CPT 70"
 CPTCCS71                     "CCS: CPT 71"
 CPTCCS72                     "CCS: CPT 72"
 CPTCCS73                     "CCS: CPT 73"
 CPTCCS74                     "CCS: CPT 74"
 CPTCCS75                     "CCS: CPT 75"
 CPTCCS76                     "CCS: CPT 76"
 CPTCCS77                     "CCS: CPT 77"
 CPTCCS78                     "CCS: CPT 78"
 CPTCCS79                     "CCS: CPT 79"
 CPTCCS80                     "CCS: CPT 80"
 CPTCCS81                     "CCS: CPT 81"
 CPTCCS82                     "CCS: CPT 82"
 CPTCCS83                     "CCS: CPT 83"
 CPTCCS84                     "CCS: CPT 84"
 CPTCCS85                     "CCS: CPT 85"
 CPTCCS86                     "CCS: CPT 86"
 CPTCCS87                     "CCS: CPT 87"
 CPTCCS88                     "CCS: CPT 88"
 CPTCCS89                     "CCS: CPT 89"
 CPTCCS90                     "CCS: CPT 90"
 CPTCCS91                     "CCS: CPT 91"
 CPTCCS92                     "CCS: CPT 92"
 CPTCCS93                     "CCS: CPT 93"
 CPTCCS94                     "CCS: CPT 94"
 CPTCCS95                     "CCS: CPT 95"
 CPTCCS96                     "CCS: CPT 96"
 CPTCCS97                     "CCS: CPT 97"
 CPTCCS98                     "CCS: CPT 98"
 CPTCCS99                     "CCS: CPT 99"
 CPTCCS100                    "CCS: CPT 100"
 CPTCCS101                    "CCS: CPT 101"
 CPTCCS102                    "CCS: CPT 102"
 CPTCCS103                    "CCS: CPT 103"
 CPTCCS104                    "CCS: CPT 104"
 CPTCCS105                    "CCS: CPT 105"
 CPTCCS106                    "CCS: CPT 106"
 CPTCCS107                    "CCS: CPT 107"
 CPTCCS108                    "CCS: CPT 108"
 CPTCCS109                    "CCS: CPT 109"
 CPTCCS110                    "CCS: CPT 110"
 CPTCCS111                    "CCS: CPT 111"
 CPTCCS112                    "CCS: CPT 112"
 CPTCCS113                    "CCS: CPT 113"
 CPTCCS114                    "CCS: CPT 114"
 CPTCCS115                    "CCS: CPT 115"
 CPTCCS116                    "CCS: CPT 116"
 CPTCCS117                    "CCS: CPT 117"
 CPTCCS118                    "CCS: CPT 118"
 CPTCCS119                    "CCS: CPT 119"
 CPTCCS120                    "CCS: CPT 120"
 CPTDAY1                      "Number of days from admission to CPT1"
 CPTDAY2                      "Number of days from admission to CPT2"
 CPTDAY3                      "Number of days from admission to CPT3"
 CPTDAY4                      "Number of days from admission to CPT4"
 CPTDAY5                      "Number of days from admission to CPT5"
 CPTDAY6                      "Number of days from admission to CPT6"
 CPTDAY7                      "Number of days from admission to CPT7"
 CPTDAY8                      "Number of days from admission to CPT8"
 CPTDAY9                      "Number of days from admission to CPT9"
 CPTDAY10                     "Number of days from admission to CPT10"
 CPTDAY11                     "Number of days from admission to CPT11"
 CPTDAY12                     "Number of days from admission to CPT12"
 CPTDAY13                     "Number of days from admission to CPT13"
 CPTDAY14                     "Number of days from admission to CPT14"
 CPTDAY15                     "Number of days from admission to CPT15"
 CPTDAY16                     "Number of days from admission to CPT16"
 CPTDAY17                     "Number of days from admission to CPT17"
 CPTDAY18                     "Number of days from admission to CPT18"
 CPTDAY19                     "Number of days from admission to CPT19"
 CPTDAY20                     "Number of days from admission to CPT20"
 CPTDAY21                     "Number of days from admission to CPT21"
 CPTDAY22                     "Number of days from admission to CPT22"
 CPTDAY23                     "Number of days from admission to CPT23"
 CPTDAY24                     "Number of days from admission to CPT24"
 CPTDAY25                     "Number of days from admission to CPT25"
 CPTDAY26                     "Number of days from admission to CPT26"
 CPTDAY27                     "Number of days from admission to CPT27"
 CPTDAY28                     "Number of days from admission to CPT28"
 CPTDAY29                     "Number of days from admission to CPT29"
 CPTDAY30                     "Number of days from admission to CPT30"
 CPTDAY31                     "Number of days from admission to CPT31"
 CPTDAY32                     "Number of days from admission to CPT32"
 CPTDAY33                     "Number of days from admission to CPT33"
 CPTDAY34                     "Number of days from admission to CPT34"
 CPTDAY35                     "Number of days from admission to CPT35"
 CPTDAY36                     "Number of days from admission to CPT36"
 CPTDAY37                     "Number of days from admission to CPT37"
 CPTDAY38                     "Number of days from admission to CPT38"
 CPTDAY39                     "Number of days from admission to CPT39"
 CPTDAY40                     "Number of days from admission to CPT40"
 CPTDAY41                     "Number of days from admission to CPT41"
 CPTDAY42                     "Number of days from admission to CPT42"
 CPTDAY43                     "Number of days from admission to CPT43"
 CPTDAY44                     "Number of days from admission to CPT44"
 CPTDAY45                     "Number of days from admission to CPT45"
 CPTDAY46                     "Number of days from admission to CPT46"
 CPTDAY47                     "Number of days from admission to CPT47"
 CPTDAY48                     "Number of days from admission to CPT48"
 CPTDAY49                     "Number of days from admission to CPT49"
 CPTDAY50                     "Number of days from admission to CPT50"
 CPTDAY51                     "Number of days from admission to CPT51"
 CPTDAY52                     "Number of days from admission to CPT52"
 CPTDAY53                     "Number of days from admission to CPT53"
 CPTDAY54                     "Number of days from admission to CPT54"
 CPTDAY55                     "Number of days from admission to CPT55"
 CPTDAY56                     "Number of days from admission to CPT56"
 CPTDAY57                     "Number of days from admission to CPT57"
 CPTDAY58                     "Number of days from admission to CPT58"
 CPTDAY59                     "Number of days from admission to CPT59"
 CPTDAY60                     "Number of days from admission to CPT60"
 CPTDAY61                     "Number of days from admission to CPT61"
 CPTDAY62                     "Number of days from admission to CPT62"
 CPTDAY63                     "Number of days from admission to CPT63"
 CPTDAY64                     "Number of days from admission to CPT64"
 CPTDAY65                     "Number of days from admission to CPT65"
 CPTDAY66                     "Number of days from admission to CPT66"
 CPTDAY67                     "Number of days from admission to CPT67"
 CPTDAY68                     "Number of days from admission to CPT68"
 CPTDAY69                     "Number of days from admission to CPT69"
 CPTDAY70                     "Number of days from admission to CPT70"
 CPTDAY71                     "Number of days from admission to CPT71"
 CPTDAY72                     "Number of days from admission to CPT72"
 CPTDAY73                     "Number of days from admission to CPT73"
 CPTDAY74                     "Number of days from admission to CPT74"
 CPTDAY75                     "Number of days from admission to CPT75"
 CPTDAY76                     "Number of days from admission to CPT76"
 CPTDAY77                     "Number of days from admission to CPT77"
 CPTDAY78                     "Number of days from admission to CPT78"
 CPTDAY79                     "Number of days from admission to CPT79"
 CPTDAY80                     "Number of days from admission to CPT80"
 CPTDAY81                     "Number of days from admission to CPT81"
 CPTDAY82                     "Number of days from admission to CPT82"
 CPTDAY83                     "Number of days from admission to CPT83"
 CPTDAY84                     "Number of days from admission to CPT84"
 CPTDAY85                     "Number of days from admission to CPT85"
 CPTDAY86                     "Number of days from admission to CPT86"
 CPTDAY87                     "Number of days from admission to CPT87"
 CPTDAY88                     "Number of days from admission to CPT88"
 CPTDAY89                     "Number of days from admission to CPT89"
 CPTDAY90                     "Number of days from admission to CPT90"
 CPTDAY91                     "Number of days from admission to CPT91"
 CPTDAY92                     "Number of days from admission to CPT92"
 CPTDAY93                     "Number of days from admission to CPT93"
 CPTDAY94                     "Number of days from admission to CPT94"
 CPTDAY95                     "Number of days from admission to CPT95"
 CPTDAY96                     "Number of days from admission to CPT96"
 CPTDAY97                     "Number of days from admission to CPT97"
 CPTDAY98                     "Number of days from admission to CPT98"
 CPTDAY99                     "Number of days from admission to CPT99"
 CPTDAY100                    "Number of days from admission to CPT100"
 CPTDAY101                    "Number of days from admission to CPT101"
 CPTDAY102                    "Number of days from admission to CPT102"
 CPTDAY103                    "Number of days from admission to CPT103"
 CPTDAY104                    "Number of days from admission to CPT104"
 CPTDAY105                    "Number of days from admission to CPT105"
 CPTDAY106                    "Number of days from admission to CPT106"
 CPTDAY107                    "Number of days from admission to CPT107"
 CPTDAY108                    "Number of days from admission to CPT108"
 CPTDAY109                    "Number of days from admission to CPT109"
 CPTDAY110                    "Number of days from admission to CPT110"
 CPTDAY111                    "Number of days from admission to CPT111"
 CPTDAY112                    "Number of days from admission to CPT112"
 CPTDAY113                    "Number of days from admission to CPT113"
 CPTDAY114                    "Number of days from admission to CPT114"
 CPTDAY115                    "Number of days from admission to CPT115"
 CPTDAY116                    "Number of days from admission to CPT116"
 CPTDAY117                    "Number of days from admission to CPT117"
 CPTDAY118                    "Number of days from admission to CPT118"
 CPTDAY119                    "Number of days from admission to CPT119"
 CPTDAY120                    "Number of days from admission to CPT120"
 DaysToEvent                  "Days from 'start date' to admission"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DURATION                     "Elapsed time for hospital care in hours and minutes"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HCUP_SURGERY_BROAD_CPT       "Number of reported CPT procedures that qualify as a surgery using a broad definition"
 HCUP_SURGERY_NARROW_CPT      "Number of reported CPT procedures that qualify as a surgery using a narrow definition"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPST                       "Hospital state postal code"
 I10_DX_Visit_Reason1         "ICD-10-CM Reason for visit diagnosis 1"
 I10_DX_Visit_Reason2         "ICD-10-CM Reason for visit diagnosis 2"
 I10_DX_Visit_Reason3         "ICD-10-CM Reason for visit diagnosis 3"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 OBSERVATION                  "Time for observation services (as received from source)"
 OPservice                    "Indicator of outpatient service (as received from source)"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PSTATE                       "Patient State postal code"
 PSTATE_GEO                   "Patient State postal code assigned from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS53
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS54
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS55
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS56
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS57
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS58
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS59
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS60
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS61
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS62
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS63
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS64
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS65
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS66
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS67
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS68
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS69
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS70
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS71
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS72
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS73
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS74
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS75
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS76
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS77
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS78
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS79
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS80
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS81
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS82
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS83
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS84
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS85
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS86
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS87
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS88
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS89
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS90
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS91
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS92
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS93
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS94
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS95
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS96
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS97
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS98
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS99
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS100
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS101
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS102
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS103
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS104
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS105
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS106
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS107
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS108
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS109
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS110
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS111
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS112
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS113
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS114
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS115
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS116
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS117
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS118
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS119
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS120
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY53
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY54
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY55
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY56
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY57
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY58
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY59
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY60
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY61
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY62
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY63
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY64
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY65
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY66
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY67
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY68
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY69
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY70
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY71
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY72
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY73
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY74
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY75
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY76
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY77
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY78
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY79
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY80
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY81
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY82
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY83
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY84
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY85
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY86
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY87
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY88
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY89
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY90
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY91
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY92
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY93
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY94
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY95
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY96
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY97
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY98
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY99
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY100
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY101
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY102
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY103
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY104
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY105
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY106
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY107
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY108
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY109
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY110
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY111
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY112
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY113
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY114
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY115
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY116
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY117
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY118
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY119
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY120
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DURATION
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_SURGERY_BROAD_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HCUP_SURGERY_NARROW_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE OBSERVATION
 (-999,-888,-666,-555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'AK_SEDD_2020_CORE.SAV' /COMPRESSED.
