/*******************************************************************
* Creation Date: 05/22/2014   
*   NY_SASD_2012_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NY_SASD_2012_CORE.ASC' FIXED SKIP=2 / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AHOUR                     10-  13
 AMONTH                    14-  15
 ANESTH                    16-  18
 AWEEKEND                  19-  20
 BILLTYPE                  21-  24 (A)
 CPT1                      25-  29 (A)
 CPT2                      30-  34 (A)
 CPT3                      35-  39 (A)
 CPT4                      40-  44 (A)
 CPT5                      45-  49 (A)
 CPT6                      50-  54 (A)
 CPT7                      55-  59 (A)
 CPT8                      60-  64 (A)
 CPT9                      65-  69 (A)
 CPT10                     70-  74 (A)
 CPT11                     75-  79 (A)
 CPT12                     80-  84 (A)
 CPT13                     85-  89 (A)
 CPT14                     90-  94 (A)
 CPT15                     95-  99 (A)
 CPT16                    100- 104 (A)
 CPT17                    105- 109 (A)
 CPT18                    110- 114 (A)
 CPT19                    115- 119 (A)
 CPT20                    120- 124 (A)
 CPT21                    125- 129 (A)
 CPT22                    130- 134 (A)
 CPT23                    135- 139 (A)
 CPT24                    140- 144 (A)
 CPT25                    145- 149 (A)
 CPT26                    150- 154 (A)
 CPT27                    155- 159 (A)
 CPT28                    160- 164 (A)
 CPT29                    165- 169 (A)
 CPT30                    170- 174 (A)
 CPT31                    175- 179 (A)
 CPT32                    180- 184 (A)
 CPT33                    185- 189 (A)
 CPT34                    190- 194 (A)
 CPT35                    195- 199 (A)
 CPT36                    200- 204 (A)
 CPT37                    205- 209 (A)
 CPT38                    210- 214 (A)
 CPT39                    215- 219 (A)
 CPT40                    220- 224 (A)
 CPT41                    225- 229 (A)
 CPT42                    230- 234 (A)
 CPT43                    235- 239 (A)
 CPT44                    240- 244 (A)
 CPT45                    245- 249 (A)
 CPT46                    250- 254 (A)
 CPT47                    255- 259 (A)
 CPT48                    260- 264 (A)
 CPT49                    265- 269 (A)
 CPT50                    270- 274 (A)
 CPTCCS1                  275- 277
 CPTCCS2                  278- 280
 CPTCCS3                  281- 283
 CPTCCS4                  284- 286
 CPTCCS5                  287- 289
 CPTCCS6                  290- 292
 CPTCCS7                  293- 295
 CPTCCS8                  296- 298
 CPTCCS9                  299- 301
 CPTCCS10                 302- 304
 CPTCCS11                 305- 307
 CPTCCS12                 308- 310
 CPTCCS13                 311- 313
 CPTCCS14                 314- 316
 CPTCCS15                 317- 319
 CPTCCS16                 320- 322
 CPTCCS17                 323- 325
 CPTCCS18                 326- 328
 CPTCCS19                 329- 331
 CPTCCS20                 332- 334
 CPTCCS21                 335- 337
 CPTCCS22                 338- 340
 CPTCCS23                 341- 343
 CPTCCS24                 344- 346
 CPTCCS25                 347- 349
 CPTCCS26                 350- 352
 CPTCCS27                 353- 355
 CPTCCS28                 356- 358
 CPTCCS29                 359- 361
 CPTCCS30                 362- 364
 CPTCCS31                 365- 367
 CPTCCS32                 368- 370
 CPTCCS33                 371- 373
 CPTCCS34                 374- 376
 CPTCCS35                 377- 379
 CPTCCS36                 380- 382
 CPTCCS37                 383- 385
 CPTCCS38                 386- 388
 CPTCCS39                 389- 391
 CPTCCS40                 392- 394
 CPTCCS41                 395- 397
 CPTCCS42                 398- 400
 CPTCCS43                 401- 403
 CPTCCS44                 404- 406
 CPTCCS45                 407- 409
 CPTCCS46                 410- 412
 CPTCCS47                 413- 415
 CPTCCS48                 416- 418
 CPTCCS49                 419- 421
 CPTCCS50                 422- 424
 CPTM1_1                  425- 426 (A)
 CPTM1_2                  427- 428 (A)
 CPTM1_3                  429- 430 (A)
 CPTM1_4                  431- 432 (A)
 CPTM1_5                  433- 434 (A)
 CPTM1_6                  435- 436 (A)
 CPTM1_7                  437- 438 (A)
 CPTM1_8                  439- 440 (A)
 CPTM1_9                  441- 442 (A)
 CPTM1_10                 443- 444 (A)
 CPTM1_11                 445- 446 (A)
 CPTM1_12                 447- 448 (A)
 CPTM1_13                 449- 450 (A)
 CPTM1_14                 451- 452 (A)
 CPTM1_15                 453- 454 (A)
 CPTM1_16                 455- 456 (A)
 CPTM1_17                 457- 458 (A)
 CPTM1_18                 459- 460 (A)
 CPTM1_19                 461- 462 (A)
 CPTM1_20                 463- 464 (A)
 CPTM1_21                 465- 466 (A)
 CPTM1_22                 467- 468 (A)
 CPTM1_23                 469- 470 (A)
 CPTM1_24                 471- 472 (A)
 CPTM1_25                 473- 474 (A)
 CPTM1_26                 475- 476 (A)
 CPTM1_27                 477- 478 (A)
 CPTM1_28                 479- 480 (A)
 CPTM1_29                 481- 482 (A)
 CPTM1_30                 483- 484 (A)
 CPTM1_31                 485- 486 (A)
 CPTM1_32                 487- 488 (A)
 CPTM1_33                 489- 490 (A)
 CPTM1_34                 491- 492 (A)
 CPTM1_35                 493- 494 (A)
 CPTM1_36                 495- 496 (A)
 CPTM1_37                 497- 498 (A)
 CPTM1_38                 499- 500 (A)
 CPTM1_39                 501- 502 (A)
 CPTM1_40                 503- 504 (A)
 CPTM1_41                 505- 506 (A)
 CPTM1_42                 507- 508 (A)
 CPTM1_43                 509- 510 (A)
 CPTM1_44                 511- 512 (A)
 CPTM1_45                 513- 514 (A)
 CPTM1_46                 515- 516 (A)
 CPTM1_47                 517- 518 (A)
 CPTM1_48                 519- 520 (A)
 CPTM1_49                 521- 522 (A)
 CPTM1_50                 523- 524 (A)
 CPTM2_1                  525- 526 (A)
 CPTM2_2                  527- 528 (A)
 CPTM2_3                  529- 530 (A)
 CPTM2_4                  531- 532 (A)
 CPTM2_5                  533- 534 (A)
 CPTM2_6                  535- 536 (A)
 CPTM2_7                  537- 538 (A)
 CPTM2_8                  539- 540 (A)
 CPTM2_9                  541- 542 (A)
 CPTM2_10                 543- 544 (A)
 CPTM2_11                 545- 546 (A)
 CPTM2_12                 547- 548 (A)
 CPTM2_13                 549- 550 (A)
 CPTM2_14                 551- 552 (A)
 CPTM2_15                 553- 554 (A)
 CPTM2_16                 555- 556 (A)
 CPTM2_17                 557- 558 (A)
 CPTM2_18                 559- 560 (A)
 CPTM2_19                 561- 562 (A)
 CPTM2_20                 563- 564 (A)
 CPTM2_21                 565- 566 (A)
 CPTM2_22                 567- 568 (A)
 CPTM2_23                 569- 570 (A)
 CPTM2_24                 571- 572 (A)
 CPTM2_25                 573- 574 (A)
 CPTM2_26                 575- 576 (A)
 CPTM2_27                 577- 578 (A)
 CPTM2_28                 579- 580 (A)
 CPTM2_29                 581- 582 (A)
 CPTM2_30                 583- 584 (A)
 CPTM2_31                 585- 586 (A)
 CPTM2_32                 587- 588 (A)
 CPTM2_33                 589- 590 (A)
 CPTM2_34                 591- 592 (A)
 CPTM2_35                 593- 594 (A)
 CPTM2_36                 595- 596 (A)
 CPTM2_37                 597- 598 (A)
 CPTM2_38                 599- 600 (A)
 CPTM2_39                 601- 602 (A)
 CPTM2_40                 603- 604 (A)
 CPTM2_41                 605- 606 (A)
 CPTM2_42                 607- 608 (A)
 CPTM2_43                 609- 610 (A)
 CPTM2_44                 611- 612 (A)
 CPTM2_45                 613- 614 (A)
 CPTM2_46                 615- 616 (A)
 CPTM2_47                 617- 618 (A)
 CPTM2_48                 619- 620 (A)
 CPTM2_49                 621- 622 (A)
 CPTM2_50                 623- 624 (A)
 DHOUR                    625- 628
 DIED                     629- 630
 DISPUB04                 631- 632
 DISPUNIFORM              633- 634
 DISP_X                   635- 636 (A)
 DQTR                     637- 638
 DSHOSPID                 639- 655 (A)
 DURATION                 656- 661
 DX1                      662- 666 (A)
 DX2                      667- 671 (A)
 DX3                      672- 676 (A)
 DX4                      677- 681 (A)
 DX5                      682- 686 (A)
 DX6                      687- 691 (A)
 DX7                      692- 696 (A)
 DX8                      697- 701 (A)
 DX9                      702- 706 (A)
 DX10                     707- 711 (A)
 DX11                     712- 716 (A)
 DX12                     717- 721 (A)
 DX13                     722- 726 (A)
 DX14                     727- 731 (A)
 DX15                     732- 736 (A)
 DX16                     737- 741 (A)
 DX17                     742- 746 (A)
 DX18                     747- 751 (A)
 DX19                     752- 756 (A)
 DX20                     757- 761 (A)
 DX21                     762- 766 (A)
 DX22                     767- 771 (A)
 DX23                     772- 776 (A)
 DX24                     777- 781 (A)
 DX25                     782- 786 (A)
 DXCCS1                   787- 790
 DXCCS2                   791- 794
 DXCCS3                   795- 798
 DXCCS4                   799- 802
 DXCCS5                   803- 806
 DXCCS6                   807- 810
 DXCCS7                   811- 814
 DXCCS8                   815- 818
 DXCCS9                   819- 822
 DXCCS10                  823- 826
 DXCCS11                  827- 830
 DXCCS12                  831- 834
 DXCCS13                  835- 838
 DXCCS14                  839- 842
 DXCCS15                  843- 846
 DXCCS16                  847- 850
 DXCCS17                  851- 854
 DXCCS18                  855- 858
 DXCCS19                  859- 862
 DXCCS20                  863- 866
 DXCCS21                  867- 870
 DXCCS22                  871- 874
 DXCCS23                  875- 878
 DXCCS24                  879- 882
 DXCCS25                  883- 886
 DX_Visit_Reason1         887- 891 (A)
 DaysToEvent              892- 897
 ECODE1                   898- 902 (A)
 ECODE2                   903- 907 (A)
 ECODE3                   908- 912 (A)
 ECODE4                   913- 917 (A)
 ECODE5                   918- 922 (A)
 ECODE6                   923- 927 (A)
 ECODE7                   928- 932 (A)
 ECODE8                   933- 937 (A)
 E_CCS1                   938- 941
 E_CCS2                   942- 945
 E_CCS3                   946- 949
 E_CCS4                   950- 953
 E_CCS5                   954- 957
 E_CCS6                   958- 961
 E_CCS7                   962- 965
 E_CCS8                   966- 969
 FEMALE                   970- 971
 HCUP_ED                  972- 973
 HCUP_OS                  974- 975
 HISPANIC_X               976     (A)
 HOSPBRTH                 977- 979
 HOSPST                   980- 981 (A)
 Homeless                 982- 983
 KEY                      984- 998
 LOS                      999-1003
 LOS_X                   1004-1009
 MEDINCSTQ               1010-1011
 NCHRONIC                1012-1014
 NCPT                    1015-1017
 NDX                     1018-1019
 NECODE                  1020-1021
 NEOMAT                  1022-1023
 OPservice               1024     (A)
 ORTIME                  1025-1028
 PAY1                    1029-1030
 PAY1_X                  1031-1032 (A)
 PAYER1_X                1033-1037 (A)
 PAYER2_X                1038-1042 (A)
 PL_CBSA                 1043-1045
 PL_MSA1993              1046-1048
 PL_NCHS2006             1049-1050
 PL_RUCA10_2005          1051-1052
 PL_RUCA2005             1053-1056
 PL_RUCA4_2005           1057-1058
 PL_RUCC2003             1059-1060
 PL_UIC2003              1061-1062
 PL_UR_CAT4              1063-1064
 PROCTYPE                1065-1067
 PSTATE                  1068-1069 (A)
 PSTCO                   1070-1074
 PSTCO2                  1075-1079
 RACE                    1080-1081
 RACE_X                  1082-1083 (A)
 STATE_AS                1084-1085
 STATE_ED                1086-1087
 STATE_OS                1088-1089
 TOTCHG                  1090-1099
 TOTCHG_X                1100-1114
 VisitLink               1115-1123
 YEAR                    1124-1127
 ZIP3                    1128-1130 (A)
 ZIPINC_QRTL             1131-1133
 ZIP                     1134-1138 (A)
 AYEAR                   1139-1142
 DMONTH                  1143-1144
 BMONTH                  1145-1146
 BYEAR                   1147-1150.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ANESTH                  (F3.0) /
 AWEEKEND                (F3.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 CPTCCS21                (F4.0) /
 CPTCCS22                (F4.0) /
 CPTCCS23                (F4.0) /
 CPTCCS24                (F4.0) /
 CPTCCS25                (F4.0) /
 CPTCCS26                (F4.0) /
 CPTCCS27                (F4.0) /
 CPTCCS28                (F4.0) /
 CPTCCS29                (F4.0) /
 CPTCCS30                (F4.0) /
 CPTCCS31                (F4.0) /
 CPTCCS32                (F4.0) /
 CPTCCS33                (F4.0) /
 CPTCCS34                (F4.0) /
 CPTCCS35                (F4.0) /
 CPTCCS36                (F4.0) /
 CPTCCS37                (F4.0) /
 CPTCCS38                (F4.0) /
 CPTCCS39                (F4.0) /
 CPTCCS40                (F4.0) /
 CPTCCS41                (F4.0) /
 CPTCCS42                (F4.0) /
 CPTCCS43                (F4.0) /
 CPTCCS44                (F4.0) /
 CPTCCS45                (F4.0) /
 CPTCCS46                (F4.0) /
 CPTCCS47                (F4.0) /
 CPTCCS48                (F4.0) /
 CPTCCS49                (F4.0) /
 CPTCCS50                (F4.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DURATION                (F4.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DaysToEvent             (F8.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Homeless                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MEDINCSTQ               (F3.0) /
 NCHRONIC                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 ORTIME                  (F4.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 VisitLink               (F8.0) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AHOUR                   "Admission Hour"
 AMONTH                  "Admission month"
 ANESTH                  "Method of anesthesia"
 AWEEKEND                "Admission day is a weekend"
 BILLTYPE                "UB-92 bill type"
 CPT1                    "CPT/HCPCS procedure code 1"
 CPT2                    "CPT/HCPCS procedure code 2"
 CPT3                    "CPT/HCPCS procedure code 3"
 CPT4                    "CPT/HCPCS procedure code 4"
 CPT5                    "CPT/HCPCS procedure code 5"
 CPT6                    "CPT/HCPCS procedure code 6"
 CPT7                    "CPT/HCPCS procedure code 7"
 CPT8                    "CPT/HCPCS procedure code 8"
 CPT9                    "CPT/HCPCS procedure code 9"
 CPT10                   "CPT/HCPCS procedure code 10"
 CPT11                   "CPT/HCPCS procedure code 11"
 CPT12                   "CPT/HCPCS procedure code 12"
 CPT13                   "CPT/HCPCS procedure code 13"
 CPT14                   "CPT/HCPCS procedure code 14"
 CPT15                   "CPT/HCPCS procedure code 15"
 CPT16                   "CPT/HCPCS procedure code 16"
 CPT17                   "CPT/HCPCS procedure code 17"
 CPT18                   "CPT/HCPCS procedure code 18"
 CPT19                   "CPT/HCPCS procedure code 19"
 CPT20                   "CPT/HCPCS procedure code 20"
 CPT21                   "CPT/HCPCS procedure code 21"
 CPT22                   "CPT/HCPCS procedure code 22"
 CPT23                   "CPT/HCPCS procedure code 23"
 CPT24                   "CPT/HCPCS procedure code 24"
 CPT25                   "CPT/HCPCS procedure code 25"
 CPT26                   "CPT/HCPCS procedure code 26"
 CPT27                   "CPT/HCPCS procedure code 27"
 CPT28                   "CPT/HCPCS procedure code 28"
 CPT29                   "CPT/HCPCS procedure code 29"
 CPT30                   "CPT/HCPCS procedure code 30"
 CPT31                   "CPT/HCPCS procedure code 31"
 CPT32                   "CPT/HCPCS procedure code 32"
 CPT33                   "CPT/HCPCS procedure code 33"
 CPT34                   "CPT/HCPCS procedure code 34"
 CPT35                   "CPT/HCPCS procedure code 35"
 CPT36                   "CPT/HCPCS procedure code 36"
 CPT37                   "CPT/HCPCS procedure code 37"
 CPT38                   "CPT/HCPCS procedure code 38"
 CPT39                   "CPT/HCPCS procedure code 39"
 CPT40                   "CPT/HCPCS procedure code 40"
 CPT41                   "CPT/HCPCS procedure code 41"
 CPT42                   "CPT/HCPCS procedure code 42"
 CPT43                   "CPT/HCPCS procedure code 43"
 CPT44                   "CPT/HCPCS procedure code 44"
 CPT45                   "CPT/HCPCS procedure code 45"
 CPT46                   "CPT/HCPCS procedure code 46"
 CPT47                   "CPT/HCPCS procedure code 47"
 CPT48                   "CPT/HCPCS procedure code 48"
 CPT49                   "CPT/HCPCS procedure code 49"
 CPT50                   "CPT/HCPCS procedure code 50"
 CPTCCS1                 "CCS: CPT 1"
 CPTCCS2                 "CCS: CPT 2"
 CPTCCS3                 "CCS: CPT 3"
 CPTCCS4                 "CCS: CPT 4"
 CPTCCS5                 "CCS: CPT 5"
 CPTCCS6                 "CCS: CPT 6"
 CPTCCS7                 "CCS: CPT 7"
 CPTCCS8                 "CCS: CPT 8"
 CPTCCS9                 "CCS: CPT 9"
 CPTCCS10                "CCS: CPT 10"
 CPTCCS11                "CCS: CPT 11"
 CPTCCS12                "CCS: CPT 12"
 CPTCCS13                "CCS: CPT 13"
 CPTCCS14                "CCS: CPT 14"
 CPTCCS15                "CCS: CPT 15"
 CPTCCS16                "CCS: CPT 16"
 CPTCCS17                "CCS: CPT 17"
 CPTCCS18                "CCS: CPT 18"
 CPTCCS19                "CCS: CPT 19"
 CPTCCS20                "CCS: CPT 20"
 CPTCCS21                "CCS: CPT 21"
 CPTCCS22                "CCS: CPT 22"
 CPTCCS23                "CCS: CPT 23"
 CPTCCS24                "CCS: CPT 24"
 CPTCCS25                "CCS: CPT 25"
 CPTCCS26                "CCS: CPT 26"
 CPTCCS27                "CCS: CPT 27"
 CPTCCS28                "CCS: CPT 28"
 CPTCCS29                "CCS: CPT 29"
 CPTCCS30                "CCS: CPT 30"
 CPTCCS31                "CCS: CPT 31"
 CPTCCS32                "CCS: CPT 32"
 CPTCCS33                "CCS: CPT 33"
 CPTCCS34                "CCS: CPT 34"
 CPTCCS35                "CCS: CPT 35"
 CPTCCS36                "CCS: CPT 36"
 CPTCCS37                "CCS: CPT 37"
 CPTCCS38                "CCS: CPT 38"
 CPTCCS39                "CCS: CPT 39"
 CPTCCS40                "CCS: CPT 40"
 CPTCCS41                "CCS: CPT 41"
 CPTCCS42                "CCS: CPT 42"
 CPTCCS43                "CCS: CPT 43"
 CPTCCS44                "CCS: CPT 44"
 CPTCCS45                "CCS: CPT 45"
 CPTCCS46                "CCS: CPT 46"
 CPTCCS47                "CCS: CPT 47"
 CPTCCS48                "CCS: CPT 48"
 CPTCCS49                "CCS: CPT 49"
 CPTCCS50                "CCS: CPT 50"
 CPTM1_1                 "First CPT-4/HCPCS modifier 1"
 CPTM1_2                 "First CPT-4/HCPCS modifier 2"
 CPTM1_3                 "First CPT-4/HCPCS modifier 3"
 CPTM1_4                 "First CPT-4/HCPCS modifier 4"
 CPTM1_5                 "First CPT-4/HCPCS modifier 5"
 CPTM1_6                 "First CPT-4/HCPCS modifier 6"
 CPTM1_7                 "First CPT-4/HCPCS modifier 7"
 CPTM1_8                 "First CPT-4/HCPCS modifier 8"
 CPTM1_9                 "First CPT-4/HCPCS modifier 9"
 CPTM1_10                "First CPT-4/HCPCS modifier 10"
 CPTM1_11                "First CPT-4/HCPCS modifier 11"
 CPTM1_12                "First CPT-4/HCPCS modifier 12"
 CPTM1_13                "First CPT-4/HCPCS modifier 13"
 CPTM1_14                "First CPT-4/HCPCS modifier 14"
 CPTM1_15                "First CPT-4/HCPCS modifier 15"
 CPTM1_16                "First CPT-4/HCPCS modifier 16"
 CPTM1_17                "First CPT-4/HCPCS modifier 17"
 CPTM1_18                "First CPT-4/HCPCS modifier 18"
 CPTM1_19                "First CPT-4/HCPCS modifier 19"
 CPTM1_20                "First CPT-4/HCPCS modifier 20"
 CPTM1_21                "First CPT-4/HCPCS modifier 21"
 CPTM1_22                "First CPT-4/HCPCS modifier 22"
 CPTM1_23                "First CPT-4/HCPCS modifier 23"
 CPTM1_24                "First CPT-4/HCPCS modifier 24"
 CPTM1_25                "First CPT-4/HCPCS modifier 25"
 CPTM1_26                "First CPT-4/HCPCS modifier 26"
 CPTM1_27                "First CPT-4/HCPCS modifier 27"
 CPTM1_28                "First CPT-4/HCPCS modifier 28"
 CPTM1_29                "First CPT-4/HCPCS modifier 29"
 CPTM1_30                "First CPT-4/HCPCS modifier 30"
 CPTM1_31                "First CPT-4/HCPCS modifier 31"
 CPTM1_32                "First CPT-4/HCPCS modifier 32"
 CPTM1_33                "First CPT-4/HCPCS modifier 33"
 CPTM1_34                "First CPT-4/HCPCS modifier 34"
 CPTM1_35                "First CPT-4/HCPCS modifier 35"
 CPTM1_36                "First CPT-4/HCPCS modifier 36"
 CPTM1_37                "First CPT-4/HCPCS modifier 37"
 CPTM1_38                "First CPT-4/HCPCS modifier 38"
 CPTM1_39                "First CPT-4/HCPCS modifier 39"
 CPTM1_40                "First CPT-4/HCPCS modifier 40"
 CPTM1_41                "First CPT-4/HCPCS modifier 41"
 CPTM1_42                "First CPT-4/HCPCS modifier 42"
 CPTM1_43                "First CPT-4/HCPCS modifier 43"
 CPTM1_44                "First CPT-4/HCPCS modifier 44"
 CPTM1_45                "First CPT-4/HCPCS modifier 45"
 CPTM1_46                "First CPT-4/HCPCS modifier 46"
 CPTM1_47                "First CPT-4/HCPCS modifier 47"
 CPTM1_48                "First CPT-4/HCPCS modifier 48"
 CPTM1_49                "First CPT-4/HCPCS modifier 49"
 CPTM1_50                "First CPT-4/HCPCS modifier 50"
 CPTM2_1                 "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                 "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                 "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                 "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                 "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                 "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                 "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                 "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                 "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                "Second CPT-4/HCPCS modifier 25"
 CPTM2_26                "Second CPT-4/HCPCS modifier 26"
 CPTM2_27                "Second CPT-4/HCPCS modifier 27"
 CPTM2_28                "Second CPT-4/HCPCS modifier 28"
 CPTM2_29                "Second CPT-4/HCPCS modifier 29"
 CPTM2_30                "Second CPT-4/HCPCS modifier 30"
 CPTM2_31                "Second CPT-4/HCPCS modifier 31"
 CPTM2_32                "Second CPT-4/HCPCS modifier 32"
 CPTM2_33                "Second CPT-4/HCPCS modifier 33"
 CPTM2_34                "Second CPT-4/HCPCS modifier 34"
 CPTM2_35                "Second CPT-4/HCPCS modifier 35"
 CPTM2_36                "Second CPT-4/HCPCS modifier 36"
 CPTM2_37                "Second CPT-4/HCPCS modifier 37"
 CPTM2_38                "Second CPT-4/HCPCS modifier 38"
 CPTM2_39                "Second CPT-4/HCPCS modifier 39"
 CPTM2_40                "Second CPT-4/HCPCS modifier 40"
 CPTM2_41                "Second CPT-4/HCPCS modifier 41"
 CPTM2_42                "Second CPT-4/HCPCS modifier 42"
 CPTM2_43                "Second CPT-4/HCPCS modifier 43"
 CPTM2_44                "Second CPT-4/HCPCS modifier 44"
 CPTM2_45                "Second CPT-4/HCPCS modifier 45"
 CPTM2_46                "Second CPT-4/HCPCS modifier 46"
 CPTM2_47                "Second CPT-4/HCPCS modifier 47"
 CPTM2_48                "Second CPT-4/HCPCS modifier 48"
 CPTM2_49                "Second CPT-4/HCPCS modifier 49"
 CPTM2_50                "Second CPT-4/HCPCS modifier 50"
 DHOUR                   "Discharge Hour"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DSHOSPID                "Data source hospital identifier"
 DURATION                "Elapsed time for hospital care in hours"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DX21                    "Diagnosis 21"
 DX22                    "Diagnosis 22"
 DX23                    "Diagnosis 23"
 DX24                    "Diagnosis 24"
 DX25                    "Diagnosis 25"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXCCS21                 "CCS: diagnosis 21"
 DXCCS22                 "CCS: diagnosis 22"
 DXCCS23                 "CCS: diagnosis 23"
 DXCCS24                 "CCS: diagnosis 24"
 DXCCS25                 "CCS: diagnosis 25"
 DX_Visit_Reason1        "Reason for visit diagnosis 1"
 DaysToEvent             "Days from 'start date' to admission"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 ECODE7                  "E code 7"
 ECODE8                  "E code 8"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_CCS7                  "CCS: E Code 7"
 E_CCS8                  "CCS: E Code 8"
 FEMALE                  "Indicator of sex"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HISPANIC_X              "Hispanic ethnicity (as received from source)"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 Homeless                "Indicator that patient is homeless"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 NCHRONIC                "Number of chronic conditions"
 NCPT                    "Number of CPT/HCPCS procedures on this record"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 OPservice               "Indicator of outpatient service (as received from source)"
 ORTIME                  "Operating room time in minutes"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAYER1_X                "Primary expected payer plan identifier (as received from source)"
 PAYER2_X
"Secondary expected payer plan identifier (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 STATE_AS                "State Ambulatory Surgery service indicator"
 STATE_ED                "State Emergency Department service indicator"
 STATE_OS                "State Observation Stay service indicator"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 VisitLink               "Visit linkage variable"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 ZIP                     "Patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month"
 BMONTH                  "Birth month"
 BYEAR                   "Birth year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ANESTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DURATION
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE ORTIME
 (-999,-888,-666,-555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'NY_SASD_2012_CORE.SAV' /COMPRESSED.
