/*******************************************************************
*   NC_SASD_2000_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'NC_SASD_2000_CORE.ASC' FIXED / 
 KEY                   1-  14
 AGE                  15-  17
 AGEDAY               18-  20
 AGEMONTH             21-  23
 AMONTH               24-  25
 AWEEKEND             26-  27
 CPT1                 28-  32 (A)
 CPT2                 33-  37 (A)
 CPT3                 38-  42 (A)
 CPT4                 43-  47 (A)
 CPT5                 48-  52 (A)
 CPT6                 53-  57 (A)
 CPT7                 58-  62 (A)
 CPT8                 63-  67 (A)
 CPT9                 68-  72 (A)
 CPT10                73-  77 (A)
 CPT11                78-  82 (A)
 CPT12                83-  87 (A)
 DQTR                 88-  89
 DSHOSPID             90- 102 (A)
 DX1                 103- 107 (A)
 DX2                 108- 112 (A)
 DX3                 113- 117 (A)
 DX4                 118- 122 (A)
 DX5                 123- 127 (A)
 DX6                 128- 132 (A)
 DX7                 133- 137 (A)
 DX8                 138- 142 (A)
 DX9                 143- 147 (A)
 DX10                148- 152 (A)
 DX11                153- 157 (A)
 DXCCS1              158- 161
 DXCCS2              162- 165
 DXCCS3              166- 169
 DXCCS4              170- 173
 DXCCS5              174- 177
 DXCCS6              178- 181
 DXCCS7              182- 185
 DXCCS8              186- 189
 DXCCS9              190- 193
 DXCCS10             194- 197
 DXCCS11             198- 201
 FEMALE              202- 203
 HOSPST              204- 205 (A)
 LOS                 206- 210
 LOS_X               211- 216
 NCPT                217- 218
 NDX                 219- 220
 NEOMAT              221- 222
 NPR                 223- 224
 PAY1                225- 226
 PAY1_X              227     (A)
 PNUM_S              228- 244 (A)
 PR1                 245- 248 (A)
 PR2                 249- 252 (A)
 PR3                 253- 256 (A)
 PR4                 257- 260 (A)
 PR5                 261- 264 (A)
 PR6                 265- 268 (A)
 PR7                 269- 272 (A)
 PR8                 273- 276 (A)
 PR9                 277- 280 (A)
 PR10                281- 284 (A)
 PR11                285- 288 (A)
 PR12                289- 292 (A)
 PR13                293- 296 (A)
 PR14                297- 300 (A)
 PR15                301- 304 (A)
 PR16                305- 308 (A)
 PR17                309- 312 (A)
 PR18                313- 316 (A)
 PRCCS1              317- 319
 PRCCS2              320- 322
 PRCCS3              323- 325
 PRCCS4              326- 328
 PRCCS5              329- 331
 PRCCS6              332- 334
 PRCCS7              335- 337
 PRCCS8              338- 340
 PRCCS9              341- 343
 PRCCS10             344- 346
 PRCCS11             347- 349
 PRCCS12             350- 352
 PRCCS13             353- 355
 PRCCS14             356- 358
 PRCCS15             359- 361
 PRCCS16             362- 364
 PRCCS17             365- 367
 PRCCS18             368- 370
 PRDAY1              371- 375
 PRDAY2              376- 380
 PRDAY3              381- 385
 PRDAY4              386- 390
 PRDAY5              391- 395
 PRDAY6              396- 400
 PRDAY7              401- 405
 PRDAY8              406- 410
 PRDAY9              411- 415
 PRDAY10             416- 420
 PRDAY11             421- 425
 PRDAY12             426- 430
 PRDAY13             431- 435
 PRDAY14             436- 440
 PRDAY15             441- 445
 PRDAY16             446- 450
 PRDAY17             451- 455
 PRDAY18             456- 460
 TOTCHG              461- 470
 TOTCHG_X            471- 485
 YEAR                486- 489
 ZIP                 490- 494 (A)
 AYEAR               495- 498
 DMONTH              499- 500
 BMONTH              501- 502
 BYEAR               503- 506
 PRMNTH1             507- 508
 PRMNTH2             509- 510
 PRMNTH3             511- 512
 PRMNTH4             513- 514
 PRMNTH5             515- 516
 PRMNTH6             517- 518
 PRMNTH7             519- 520
 PRMNTH8             521- 522
 PRMNTH9             523- 524
 PRMNTH10            525- 526
 PRMNTH11            527- 528
 PRMNTH12            529- 530
 PRMNTH13            531- 532
 PRMNTH14            533- 534
 PRMNTH15            535- 536
 PRMNTH16            537- 538
 PRMNTH17            539- 540
 PRMNTH18            541- 542
 PRYEAR1             543- 546
 PRYEAR2             547- 550
 PRYEAR3             551- 554
 PRYEAR4             555- 558
 PRYEAR5             559- 562
 PRYEAR6             563- 566
 PRYEAR7             567- 570
 PRYEAR8             571- 574
 PRYEAR9             575- 578
 PRYEAR10            579- 582
 PRYEAR11            583- 586
 PRYEAR12            587- 590
 PRYEAR13            591- 594
 PRYEAR14            595- 598
 PRYEAR15            599- 602
 PRYEAR16            603- 606
 PRYEAR17            607- 610
 PRYEAR18            611- 614.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 AGEMONTH            (F3.0) /
 AMONTH              (F3.0) /
 AWEEKEND            (F3.0) /
 DQTR                (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 DXCCS10             (F4.0) /
 DXCCS11             (F4.0) /
 FEMALE              (F3.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 NCPT                (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PRCCS7              (F3.0) /
 PRCCS8              (F3.0) /
 PRCCS9              (F3.0) /
 PRCCS10             (F3.0) /
 PRCCS11             (F3.0) /
 PRCCS12             (F3.0) /
 PRCCS13             (F3.0) /
 PRCCS14             (F3.0) /
 PRCCS15             (F3.0) /
 PRCCS16             (F3.0) /
 PRCCS17             (F3.0) /
 PRCCS18             (F3.0) /
 PRDAY1              (F4.0) /
 PRDAY2              (F4.0) /
 PRDAY3              (F4.0) /
 PRDAY4              (F4.0) /
 PRDAY5              (F4.0) /
 PRDAY6              (F4.0) /
 PRDAY7              (F4.0) /
 PRDAY8              (F4.0) /
 PRDAY9              (F4.0) /
 PRDAY10             (F4.0) /
 PRDAY11             (F4.0) /
 PRDAY12             (F4.0) /
 PRDAY13             (F4.0) /
 PRDAY14             (F4.0) /
 PRDAY15             (F4.0) /
 PRDAY16             (F4.0) /
 PRDAY17             (F4.0) /
 PRDAY18             (F4.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) /
 AYEAR               (F3.0) /
 DMONTH              (F3.0) /
 BMONTH              (F3.0) /
 BYEAR               (F3.0) /
 PRMNTH1             (F3.0) /
 PRMNTH2             (F3.0) /
 PRMNTH3             (F3.0) /
 PRMNTH4             (F3.0) /
 PRMNTH5             (F3.0) /
 PRMNTH6             (F3.0) /
 PRMNTH7             (F3.0) /
 PRMNTH8             (F3.0) /
 PRMNTH9             (F3.0) /
 PRMNTH10            (F3.0) /
 PRMNTH11            (F3.0) /
 PRMNTH12            (F3.0) /
 PRMNTH13            (F3.0) /
 PRMNTH14            (F3.0) /
 PRMNTH15            (F3.0) /
 PRMNTH16            (F3.0) /
 PRMNTH17            (F3.0) /
 PRMNTH18            (F3.0) /
 PRYEAR1             (F3.0) /
 PRYEAR2             (F3.0) /
 PRYEAR3             (F3.0) /
 PRYEAR4             (F3.0) /
 PRYEAR5             (F3.0) /
 PRYEAR6             (F3.0) /
 PRYEAR7             (F3.0) /
 PRYEAR8             (F3.0) /
 PRYEAR9             (F3.0) /
 PRYEAR10            (F3.0) /
 PRYEAR11            (F3.0) /
 PRYEAR12            (F3.0) /
 PRYEAR13            (F3.0) /
 PRYEAR14            (F3.0) /
 PRYEAR15            (F3.0) /
 PRYEAR16            (F3.0) /
 PRYEAR17            (F3.0) /
 PRYEAR18            (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 FEMALE    "Indicator of sex"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PNUM_S    "Person number (synthetic)"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PR16      "Procedure 16"
 PR17      "Procedure 17"
 PR18      "Procedure 18"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRCCS16   "CCS: procedure 16"
 PRCCS17   "CCS: procedure 17"
 PRCCS18   "CCS: procedure 18"
 PRDAY1    "Number of days from admission to PR1"
 PRDAY2    "Number of days from admission to PR2"
 PRDAY3    "Number of days from admission to PR3"
 PRDAY4    "Number of days from admission to PR4"
 PRDAY5    "Number of days from admission to PR5"
 PRDAY6    "Number of days from admission to PR6"
 PRDAY7    "Number of days from admission to PR7"
 PRDAY8    "Number of days from admission to PR8"
 PRDAY9    "Number of days from admission to PR9"
 PRDAY10   "Number of days from admission to PR10"
 PRDAY11   "Number of days from admission to PR11"
 PRDAY12   "Number of days from admission to PR12"
 PRDAY13   "Number of days from admission to PR13"
 PRDAY14   "Number of days from admission to PR14"
 PRDAY15   "Number of days from admission to PR15"
 PRDAY16   "Number of days from admission to PR16"
 PRDAY17   "Number of days from admission to PR17"
 PRDAY18   "Number of days from admission to PR18"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIP       "Patient zip code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRMNTH2   "Month of procedure 2"
 PRMNTH3   "Month of procedure 3"
 PRMNTH4   "Month of procedure 4"
 PRMNTH5   "Month of procedure 5"
 PRMNTH6   "Month of procedure 6"
 PRMNTH7   "Month of procedure 7"
 PRMNTH8   "Month of procedure 8"
 PRMNTH9   "Month of procedure 9"
 PRMNTH10  "Month of procedure 10"
 PRMNTH11  "Month of procedure 11"
 PRMNTH12  "Month of procedure 12"
 PRMNTH13  "Month of procedure 13"
 PRMNTH14  "Month of procedure 14"
 PRMNTH15  "Month of procedure 15"
 PRMNTH16  "Month of procedure 16"
 PRMNTH17  "Month of procedure 17"
 PRMNTH18  "Month of procedure 18"
 PRYEAR1   "Year of procedure 1"
 PRYEAR2   "Year of procedure 2"
 PRYEAR3   "Year of procedure 3"
 PRYEAR4   "Year of procedure 4"
 PRYEAR5   "Year of procedure 5"
 PRYEAR6   "Year of procedure 6"
 PRYEAR7   "Year of procedure 7"
 PRYEAR8   "Year of procedure 8"
 PRYEAR9   "Year of procedure 9"
 PRYEAR10  "Year of procedure 10"
 PRYEAR11  "Year of procedure 11"
 PRYEAR12  "Year of procedure 12"
 PRYEAR13  "Year of procedure 13"
 PRYEAR14  "Year of procedure 14"
 PRYEAR15  "Year of procedure 15"
 PRYEAR16  "Year of procedure 16"
 PRYEAR17  "Year of procedure 17"
 PRYEAR18  "Year of procedure 18" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE NCPT
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'NC_SASD_2000_CORE.SAV' /COMPRESSED.
