/*******************************************************************
*   ME_SASD_2001_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CHGS FILE INTO SPSS                             
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'ME_SASD_2001_CHGS.ASC' FIXED / 
 KEY                   1-  14
 CPTHCPCS             15-  19 (A)
 UNITS                20-  27
 CHARGE               28-  39
 REVCODE              40-  43 (A)
 SERVDAY              44-  48.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 UNITS               (F4.0) /
 CHARGE              (F6.2) /
 SERVDAY             (F4.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 CPTHCPCS  "Line item CPT or HCPCS procedure code (as received from source)"
 UNITS     "Line item units (as received from source)"
 CHARGE    "Line item charges (as received from source)"
 REVCODE   "Line item revenue code (as received from source)"
 SERVDAY   "Line item days from admission date" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE UNITS
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE CHARGE
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE SERVDAY
 (-9999,-8888,-6666,-5555=SYSMIS).



SAVE OUTFILE = 'ME_SASD_2001_CHGS.SAV' /COMPRESSED.
