/*******************************************************************
*   MD_SASD_2000_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL CONVERT THE ASCII             
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MD_SASD_2000_CORE.ASC' FIXED / 
 KEY                  1- 14
 AGE                 15- 17
 AGEDAY              18- 20
 AGEMONTH            21- 23
 AWEEKEND            24- 25
 CPT1                26- 30 (A)
 CPT2                31- 35 (A)
 CPT3                36- 40 (A)
 CPT4                41- 45 (A)
 CPT5                46- 50 (A)
 CPT6                51- 55 (A)
 CPT7                56- 60 (A)
 CPT8                61- 65 (A)
 DIED                66- 67
 DISP_X              68- 69 (A)
 DISPUNIF            70- 71
 DQTR                72- 73
 DSHOSPID            74- 86 (A)
 DX1                 87- 91 (A)
 DX2                 92- 96 (A)
 DX3                 97-101 (A)
 DX4                102-106 (A)
 DX5                107-111 (A)
 DX6                112-116 (A)
 DX7                117-121 (A)
 DX8                122-126 (A)
 DX9                127-131 (A)
 DXCCS1             132-135
 DXCCS2             136-139
 DXCCS3             140-143
 DXCCS4             144-147
 DXCCS5             148-151
 DXCCS6             152-155
 DXCCS7             156-159
 DXCCS8             160-163
 DXCCS9             164-167
 FEMALE             168-169
 HISPANIC           170 (A)
 HOSPST             171-172 (A)
 LOS                173-177
 LOS_X              178-183
 MRN_S              184-200 (A)
 NCPT               201-202
 NDX                203-204
 NEOMAT             205-206
 NPR                207-208
 PAY1               209-210
 PAY2               211-212
 PAY1_X             213-214 (A)
 PAY2_X             215-216 (A)
 PAYER1_X           217-218 (A)
 PAYER2_X           219-220 (A)
 PR1                221-224 (A)
 PR2                225-228 (A)
 PR3                229-232 (A)
 PR4                233-236 (A)
 PR5                237-240 (A)
 PR6                241-244 (A)
 PR7                245-248 (A)
 PR8                249-252 (A)
 PRCCS1             253-255
 PRCCS2             256-258
 PRCCS3             259-261
 PRCCS4             262-264
 PRCCS5             265-267
 PRCCS6             268-270
 PRCCS7             271-273
 PRCCS8             274-276
 RACE               277-278
 RACE_X             279 (A)
 SURGID_S           280-295 (A)
 TOTCHG             296-305
 TOTCHG_X           306-320
 YEAR               321-324.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 AGEMONTH            (F3.0) /
 AWEEKEND            (F3.0) /
 DIED                (F3.0) /
 DISPUNIF            (F3.0) /
 DQTR                (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 FEMALE              (F3.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 NCPT                (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PAY2                (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PRCCS7              (F3.0) /
 PRCCS8              (F3.0) /
 RACE                (F3.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY          "HCUP record identifier"
 AGE          "Age in years at admission"
 AGEDAY       "Age in days (when age < 1 year)"
 AGEMONTH     "Age in months (when age < 11 years)"
 AWEEKEND     "Admission day is a weekend"
 CPT1         "CPT/HCPCS procedure code 1"
 CPT2         "CPT/HCPCS procedure code 2"
 CPT3         "CPT/HCPCS procedure code 3"
 CPT4         "CPT/HCPCS procedure code 4"
 CPT5         "CPT/HCPCS procedure code 5"
 CPT6         "CPT/HCPCS procedure code 6"
 CPT7         "CPT/HCPCS procedure code 7"
 CPT8         "CPT/HCPCS procedure code 8"
 DIED         "Died during hospitalization"
 DISP_X       "Disposition of patient (as received from source)"
 DISPUNIF     "Disposition of patient, uniform"
 DQTR         "Discharge quarter"
 DSHOSPID     "Data source hospital identifier"
 DX1          "Principal diagnosis"
 DX2          "Diagnosis 2"
 DX3          "Diagnosis 3"
 DX4          "Diagnosis 4"
 DX5          "Diagnosis 5"
 DX6          "Diagnosis 6"
 DX7          "Diagnosis 7"
 DX8          "Diagnosis 8"
 DX9          "Diagnosis 9"
 DXCCS1       "CCS: principal diagnosis"
 DXCCS2       "CCS: diagnosis 2"
 DXCCS3       "CCS: diagnosis 3"
 DXCCS4       "CCS: diagnosis 4"
 DXCCS5       "CCS: diagnosis 5"
 DXCCS6       "CCS: diagnosis 6"
 DXCCS7       "CCS: diagnosis 7"
 DXCCS8       "CCS: diagnosis 8"
 DXCCS9       "CCS: diagnosis 9"
 FEMALE       "Indicator of sex"
 HISPANIC     "Hispanic ethnicity (as received from source)"
 HOSPST       "Hospital state postal code"
 LOS          "Length of stay (cleaned)"
 LOS_X        "Length of stay (as received from source)"
 MRN_S        "Medical record number (synthetic)"
 NCPT         "Number of CPT/HCPCS procedures on this record"
 NDX          "Number of diagnoses on this record"
 NEOMAT       "Neonatal and/or maternal DX and/or PR"
 NPR          "Number of procedures on this record"
 PAY1         "Primary expected payer (uniform)"
 PAY2         "Secondary expected payer (uniform)"
 PAY1_X       "Primary expected payer (as received from source)"
 PAY2_X       "Secondary expected payer (as received from source)"
 PAYER1_X     "Primary expected payer plan identifier (as received from source)"
 PAYER2_X     "Secondary expected payer plan identifier (as received from source)"
 PR1          "Principal procedure"
 PR2          "Procedure 2"
 PR3          "Procedure 3"
 PR4          "Procedure 4"
 PR5          "Procedure 5"
 PR6          "Procedure 6"
 PR7          "Procedure 7"
 PR8          "Procedure 8"
 PRCCS1       "CCS: principal procedure"
 PRCCS2       "CCS: procedure 2"
 PRCCS3       "CCS: procedure 3"
 PRCCS4       "CCS: procedure 4"
 PRCCS5       "CCS: procedure 5"
 PRCCS6       "CCS: procedure 6"
 PRCCS7       "CCS: procedure 7"
 PRCCS8       "CCS: procedure 8"
 RACE         "Race (uniform)"
 RACE_X       "Race (as received from source)"
 SURGID_S     "Primary surgeon number (synthetic)"
 TOTCHG       "Total charges (cleaned)"
 TOTCHG_X     "Total charges (as received from source)"
 YEAR         "Calendar year".


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPT1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE CPT2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE CPT3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE CPT4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE CPT5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE CPT6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE CPT7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE CPT8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE NCPT
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).



SAVE OUTFILE = 'MD_SASD_2000_CORE.SAV' /COMPRESSED.
