/*******************************************************************
*   UT_SASD_2007_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'UT_SASD_2007_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 APG1                      12-  15
 APG2                      16-  19
 APG3                      20-  23
 APG4                      24-  27
 APG5                      28-  31
 APG6                      32-  35
 APGCAT1                   36-  38
 APGCAT2                   39-  41
 APGCAT3                   42-  44
 APGCAT4                   45-  47
 APGCAT5                   48-  50
 APGCAT6                   51-  53
 APGTYPE1                  54-  56
 APGTYPE2                  57-  59
 APGTYPE3                  60-  62
 APGTYPE4                  63-  65
 APGTYPE5                  66-  68
 APGTYPE6                  69-  71
 ASOURCE                   72-  73
 ASOURCEU                  74     (A)
 ASOURCE_                  75     (A)
 AWEEKEND                  76-  77
 CPT1                      78-  82 (A)
 CPT2                      83-  87 (A)
 CPT3                      88-  92 (A)
 CPT4                      93-  97 (A)
 CPT5                      98- 102 (A)
 CPT6                     103- 107 (A)
 CPTM1_1                  108- 109 (A)
 CPTM1_2                  110- 111 (A)
 CPTM1_3                  112- 113 (A)
 CPTM1_4                  114- 115 (A)
 CPTM1_5                  116- 117 (A)
 CPTM1_6                  118- 119 (A)
 CPTM2_1                  120- 121 (A)
 CPTM2_2                  122- 123 (A)
 CPTM2_3                  124- 125 (A)
 CPTM2_4                  126- 127 (A)
 CPTM2_5                  128- 129 (A)
 CPTM2_6                  130- 131 (A)
 DIED                     132- 133
 DISPUB04                 134- 135
 DISPUNIF                 136- 137
 DISP_X                   138- 139 (A)
 DQTR                     140- 141
 DSHOSPID                 142- 154 (A)
 DX1                      155- 159 (A)
 DX2                      160- 164 (A)
 DX3                      165- 169 (A)
 DX4                      170- 174 (A)
 DX5                      175- 179 (A)
 DX6                      180- 184 (A)
 DX7                      185- 189 (A)
 DX8                      190- 194 (A)
 DX9                      195- 199 (A)
 DXCCS1                   200- 203
 DXCCS2                   204- 207
 DXCCS3                   208- 211
 DXCCS4                   212- 215
 DXCCS5                   216- 219
 DXCCS6                   220- 223
 DXCCS7                   224- 227
 DXCCS8                   228- 231
 DXCCS9                   232- 235
 ECODE1                   236- 240 (A)
 ECODE2                   241- 245 (A)
 ECODE3                   246- 250 (A)
 ECODE4                   251- 255 (A)
 ECODE5                   256- 260 (A)
 E_CCS1                   261- 264
 E_CCS2                   265- 268
 E_CCS3                   269- 272
 E_CCS4                   273- 276
 E_CCS5                   277- 280
 FEMALE                   281- 282
 HCUP_AS                  283- 284
 HCUP_ED                  285- 286
 HCUP_OS                  287- 288
 HOSPBRTH                 289- 291
 HOSPST                   292- 293 (A)
 Homeless                 294- 295
 KEY                      296- 309
 LOS                      310- 314
 LOS_X                    315- 320
 MEDINCST                 321- 322
 NCPT                     323- 325
 NDX                      326- 327
 NECODE                   328- 329
 NEOMAT                   330- 331
 NPR                      332- 333
 PAY1                     334- 335
 PAY1_X                   336- 337 (A)
 PAY2                     338- 339
 PAY2_X                   340- 341 (A)
 PAY3_X                   342- 343 (A)
 PL_CBSA                  344- 346
 PL_MSA19                 347- 349
 PL_NCHS2                 350- 351
 PL_RUCA1                 352- 353
 PL_RUCA2                 354- 357
 PL_RUCA4                 358- 359
 PL_RUCC2                 360- 361
 PL_UIC20                 362- 363
 PL_UR_CA                 364- 365
 PR1                      366- 369 (A)
 PR2                      370- 373 (A)
 PR3                      374- 377 (A)
 PR4                      378- 381 (A)
 PR5                      382- 385 (A)
 PR6                      386- 389 (A)
 PRCCS1                   390- 392
 PRCCS2                   393- 395
 PRCCS3                   396- 398
 PRCCS4                   399- 401
 PRCCS5                   402- 404
 PRCCS6                   405- 407
 PRDAY1                   408- 412
 PROCTYPE                 413- 415
 PSTATE                   416- 417 (A)
 PSTCO2                   418- 422
 STATE_AS                 423- 424
 STATE_ED                 425- 426
 STATE_OS                 427- 428
 TOTCHG                   429- 438
 TOTCHG_X                 439- 453
 YEAR                     454- 457
 ZIPINC_Q                 458- 460
 ZIP                      461- 465 (A)
 AYEAR                    466- 469
 DMONTH                   470- 471
 BMONTH                   472- 473
 BYEAR                    474- 477
 PRMNTH1                  478- 479
 PRYEAR1                  480- 483.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 APG1                    (F3.0) /
 APG2                    (F3.0) /
 APG3                    (F3.0) /
 APG4                    (F3.0) /
 APG5                    (F3.0) /
 APG6                    (F3.0) /
 APGCAT1                 (F3.0) /
 APGCAT2                 (F3.0) /
 APGCAT3                 (F3.0) /
 APGCAT4                 (F3.0) /
 APGCAT5                 (F3.0) /
 APGCAT6                 (F3.0) /
 APGTYPE1                (F3.0) /
 APGTYPE2                (F3.0) /
 APGTYPE3                (F3.0) /
 APGTYPE4                (F3.0) /
 APGTYPE5                (F3.0) /
 APGTYPE6                (F3.0) /
 ASOURCE                 (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Homeless                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MEDINCST                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NCHS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRDAY1                  (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO2                  (F4.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRYEAR1                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 APG1      "Ambulatory Patient Group 1 (as received from source)"
 APG2      "Ambulatory Patient Group 2 (as received from source)"
 APG3      "Ambulatory Patient Group 3 (as received from source)"
 APG4      "Ambulatory Patient Group 4 (as received from source)"
 APG5      "Ambulatory Patient Group 5 (as received from source)"
 APG6      "Ambulatory Patient Group 6 (as received from source)"
 APGCAT1   "Ambulatory Patient Group Category 1 (as received from source)"
 APGCAT2   "Ambulatory Patient Group Category 2 (as received from source)"
 APGCAT3   "Ambulatory Patient Group Category 3 (as received from source)"
 APGCAT4   "Ambulatory Patient Group Category 4 (as received from source)"
 APGCAT5   "Ambulatory Patient Group Category 5 (as received from source)"
 APGCAT6   "Ambulatory Patient Group Category 6 (as received from source)"
 APGTYPE1  "Ambulatory Patient Group Type 1 (as received from source)"
 APGTYPE2  "Ambulatory Patient Group Type 1 (as received from source)"
 APGTYPE3  "Ambulatory Patient Group Type 1 (as received from source)"
 APGTYPE4  "Ambulatory Patient Group Type 1 (as received from source)"
 APGTYPE5  "Ambulatory Patient Group Type 1 (as received from source)"
 APGTYPE6  "Ambulatory Patient Group Type 1 (as received from source)"
 ASOURCE   "Admission source (uniform)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 ASOURCE_  "Admission source (as received from source)"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPTM1_1   "First CPT-4/HCPCS modifier 1"
 CPTM1_2   "First CPT-4/HCPCS modifier 2"
 CPTM1_3   "First CPT-4/HCPCS modifier 3"
 CPTM1_4   "First CPT-4/HCPCS modifier 4"
 CPTM1_5   "First CPT-4/HCPCS modifier 5"
 CPTM1_6   "First CPT-4/HCPCS modifier 6"
 CPTM2_1   "Second CPT-4/HCPCS modifier 1"
 CPTM2_2   "Second CPT-4/HCPCS modifier 2"
 CPTM2_3   "Second CPT-4/HCPCS modifier 3"
 CPTM2_4   "Second CPT-4/HCPCS modifier 4"
 CPTM2_5   "Second CPT-4/HCPCS modifier 5"
 CPTM2_6   "Second CPT-4/HCPCS modifier 6"
 DIED      "Died during hospitalization"
 DISPUB04  "Disposition of patient (UB-04 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DISP_X    "Disposition of patient (as received from source)"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Diagnosis 1"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DXCCS1    "CCS: diagnosis 1"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 Homeless  "Indicator that patient is homeless"
 KEY       "HCUP record identifier"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2      "Secondary expected payer (uniform)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PAY3_X    "Tertiary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PR1       "Procedure 1"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PRCCS1    "CCS: procedure 1"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRDAY1    "Number of days from admission to PR1"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRYEAR1   "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE APG1
 (-999,-888,-666,-555=SYSMIS).
RECODE APG2
 (-999,-888,-666,-555=SYSMIS).
RECODE APG3
 (-999,-888,-666,-555=SYSMIS).
RECODE APG4
 (-999,-888,-666,-555=SYSMIS).
RECODE APG5
 (-999,-888,-666,-555=SYSMIS).
RECODE APG6
 (-999,-888,-666,-555=SYSMIS).
RECODE APGCAT1
 (-99,-88,-66,-55=SYSMIS).
RECODE APGCAT2
 (-99,-88,-66,-55=SYSMIS).
RECODE APGCAT3
 (-99,-88,-66,-55=SYSMIS).
RECODE APGCAT4
 (-99,-88,-66,-55=SYSMIS).
RECODE APGCAT5
 (-99,-88,-66,-55=SYSMIS).
RECODE APGCAT6
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE1
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE2
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE3
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE4
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE5
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE6
 (-99,-88,-66,-55=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'UT_SASD_2007_CORE.SAV' /COMPRESSED.
